"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Integrations = exports.LambdaIntegration = exports.Integration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const utils_1 = require("../spec/utils");
/**
 * An integration for an API operation. You can extend this to implement your own integration if you like.
 */
class Integration {
    /**
     * Grant permissions for the API to invoke the integration
     */
    grant(_props) {
        // No permissions to grant by default
    }
}
exports.Integration = Integration;
_a = JSII_RTTI_SYMBOL_1;
Integration[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.Integration", version: "0.14.18" };
/**
 * A lambda integration
 */
class LambdaIntegration extends Integration {
    constructor(lambdaFunction) {
        super();
        this.lambdaFunction = lambdaFunction;
    }
    /**
     * Render the lambda integration as a snippet of OpenAPI
     */
    render(props) {
        return {
            type: "AWS_PROXY",
            httpMethod: "POST",
            uri: utils_1.functionInvocationUri(props.scope, this.lambdaFunction),
            passthroughBehavior: "WHEN_NO_MATCH",
        };
    }
    /**
     * Grant API Gateway permissions to invoke the lambda
     */
    grant({ scope, api, operationId, method, path, }) {
        new aws_lambda_1.CfnPermission(scope, `LambdaPermission-${operationId}`, {
            action: "lambda:InvokeFunction",
            principal: "apigateway.amazonaws.com",
            functionName: this.lambdaFunction.functionArn,
            sourceArn: aws_cdk_lib_1.Stack.of(scope).formatArn({
                service: "execute-api",
                resource: api.restApiId,
                // Scope permissions to any stage and a specific method and path of the operation.
                // Path parameters (eg {param} are replaced with wildcards)
                resourceName: `*/${method.toUpperCase()}${path.replace(/{[^\}]*\}/g, "*")}`,
            }),
        });
    }
}
exports.LambdaIntegration = LambdaIntegration;
_b = JSII_RTTI_SYMBOL_1;
LambdaIntegration[_b] = { fqn: "@aws-prototyping-sdk/open-api-gateway.LambdaIntegration", version: "0.14.18" };
/**
 * A collection of integrations to connect API operations with a backend to service requests
 */
class Integrations {
    /**
     * An integration that invokes a lambda function to service the request
     * @param lambdaFunction the function to invoke
     */
    static lambda(lambdaFunction) {
        return new LambdaIntegration(lambdaFunction);
    }
}
exports.Integrations = Integrations;
_c = JSII_RTTI_SYMBOL_1;
Integrations[_c] = { fqn: "@aws-prototyping-sdk/open-api-gateway.Integrations", version: "0.14.18" };
//# sourceMappingURL=data:application/json;base64,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