# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.12.1
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class FlowBreadcrumbEntity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'permissions': 'PermissionsDTO',
        'versioned_flow_state': 'str',
        'breadcrumb': 'FlowBreadcrumbDTO',
        'parent_breadcrumb': 'FlowBreadcrumbEntity'
    }

    attribute_map = {
        'id': 'id',
        'permissions': 'permissions',
        'versioned_flow_state': 'versionedFlowState',
        'breadcrumb': 'breadcrumb',
        'parent_breadcrumb': 'parentBreadcrumb'
    }

    def __init__(self, id=None, permissions=None, versioned_flow_state=None, breadcrumb=None, parent_breadcrumb=None):
        """
        FlowBreadcrumbEntity - a model defined in Swagger
        """

        self._id = None
        self._permissions = None
        self._versioned_flow_state = None
        self._breadcrumb = None
        self._parent_breadcrumb = None

        if id is not None:
          self.id = id
        if permissions is not None:
          self.permissions = permissions
        if versioned_flow_state is not None:
          self.versioned_flow_state = versioned_flow_state
        if breadcrumb is not None:
          self.breadcrumb = breadcrumb
        if parent_breadcrumb is not None:
          self.parent_breadcrumb = parent_breadcrumb

    @property
    def id(self):
        """
        Gets the id of this FlowBreadcrumbEntity.
        The id of this ancestor ProcessGroup.

        :return: The id of this FlowBreadcrumbEntity.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FlowBreadcrumbEntity.
        The id of this ancestor ProcessGroup.

        :param id: The id of this FlowBreadcrumbEntity.
        :type: str
        """

        self._id = id

    @property
    def permissions(self):
        """
        Gets the permissions of this FlowBreadcrumbEntity.
        The permissions for this ancestor ProcessGroup.

        :return: The permissions of this FlowBreadcrumbEntity.
        :rtype: PermissionsDTO
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """
        Sets the permissions of this FlowBreadcrumbEntity.
        The permissions for this ancestor ProcessGroup.

        :param permissions: The permissions of this FlowBreadcrumbEntity.
        :type: PermissionsDTO
        """

        self._permissions = permissions

    @property
    def versioned_flow_state(self):
        """
        Gets the versioned_flow_state of this FlowBreadcrumbEntity.
        The current state of the Process Group, as it relates to the Versioned Flow

        :return: The versioned_flow_state of this FlowBreadcrumbEntity.
        :rtype: str
        """
        return self._versioned_flow_state

    @versioned_flow_state.setter
    def versioned_flow_state(self, versioned_flow_state):
        """
        Sets the versioned_flow_state of this FlowBreadcrumbEntity.
        The current state of the Process Group, as it relates to the Versioned Flow

        :param versioned_flow_state: The versioned_flow_state of this FlowBreadcrumbEntity.
        :type: str
        """
        allowed_values = ["LOCALLY_MODIFIED", "STALE", "LOCALLY_MODIFIED_AND_STALE", "UP_TO_DATE", "SYNC_FAILURE"]
        if versioned_flow_state not in allowed_values:
            raise ValueError(
                "Invalid value for `versioned_flow_state` ({0}), must be one of {1}"
                .format(versioned_flow_state, allowed_values)
            )

        self._versioned_flow_state = versioned_flow_state

    @property
    def breadcrumb(self):
        """
        Gets the breadcrumb of this FlowBreadcrumbEntity.
        This breadcrumb.

        :return: The breadcrumb of this FlowBreadcrumbEntity.
        :rtype: FlowBreadcrumbDTO
        """
        return self._breadcrumb

    @breadcrumb.setter
    def breadcrumb(self, breadcrumb):
        """
        Sets the breadcrumb of this FlowBreadcrumbEntity.
        This breadcrumb.

        :param breadcrumb: The breadcrumb of this FlowBreadcrumbEntity.
        :type: FlowBreadcrumbDTO
        """

        self._breadcrumb = breadcrumb

    @property
    def parent_breadcrumb(self):
        """
        Gets the parent_breadcrumb of this FlowBreadcrumbEntity.
        The parent breadcrumb for this breadcrumb.

        :return: The parent_breadcrumb of this FlowBreadcrumbEntity.
        :rtype: FlowBreadcrumbEntity
        """
        return self._parent_breadcrumb

    @parent_breadcrumb.setter
    def parent_breadcrumb(self, parent_breadcrumb):
        """
        Sets the parent_breadcrumb of this FlowBreadcrumbEntity.
        The parent breadcrumb for this breadcrumb.

        :param parent_breadcrumb: The parent_breadcrumb of this FlowBreadcrumbEntity.
        :type: FlowBreadcrumbEntity
        """

        self._parent_breadcrumb = parent_breadcrumb

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FlowBreadcrumbEntity):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
