# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/01_event.ipynb (unless otherwise specified).

__all__ = ['get_event_name', 'get_event_date']

# Cell

from .base import make_soup
from .constants import LINESCORE_SOUP_TYPE, BOXSCORE_SOUP_TYPE
from bs4 import BeautifulSoup
from typing import Union, Optional

# Internal Cell

def _get_event_name_from_linescore_page(
     soup : BeautifulSoup
)->str:
    """Returns the name of the event based on the event_id. Built so for larger-scale scraping less API calls are made."""
    return soup.find('title').string

def _get_event_name_from_boxscore_page(

    soup : BeautifulSoup

)->str:
    """Returns the name of the vent based on the game_id. Build so for larger-scale scrpaing less API calls are made."""

    return soup.find('h3',attrs={'class':'entry-title-widget'}).string

# Internal Cell


def _get_event_url(
     cz_event_id : Union[str,int]
    ,cz_draw_id : Optional[Union[str,int]] = None
)->str:
    """Returns the cz event page url."""

    if cz_draw_id is None:
        return 'https://curlingzone.com/event.php?view=Scores&eventid=%s#1'%cz_event_id

    return 'https://curlingzone.com/event.php?eventid=%s&view=Scores&showdrawid=%s#1'%(cz_event_id,cz_draw_id)

def _get_game_url(
    cz_game_id : Union[str,int]
)->str:
    """Returns the cz game page url."""

    return 'https://www.curlingzone.com/game.php?1=1&showgameid=%s#1'%cz_game_id

def get_url(

     soup_type : str
    ,**url_kwargs

)->str:
    """Helper function for returning the correct CurlingZone URL."""

    soup_type = soup_type.lower()

    if soup_type == LINESCORE_SOUP_TYPE:
        return _get_event_url(**url_kwargs)
    elif soup_type == BOXSCORE_SOUP_TYPE:
        return _get_game_url(**url_kwargs)
    else:
        raise NotImplementedError("%s soup type is not implemented."%soup_type)

def _get_event_name(

     soup : BeautifulSoup
    ,soup_type : str


)->str:
    soup_type = soup_type.lower()

    if soup_type == LINESCORE_SOUP_TYPE:
        return _get_event_name_from_linescore_page(soup=soup)
    elif soup_type == BOXSCORE_SOUP_TYPE:
        return _get_event_name_from_boxscore_page(soup=soup)
    else:
        raise NotImplementedError("%s soup type is not implemented."%soup_type)

# Cell
def get_event_name(
     cz_event_id : Optional[Union[str,int]] = None
    ,cz_draw_id : Optional[Union[str,int]] = None
    ,cz_game_id : Optional[Union[str,int]] = None
    ,**request_kwargs
)->str:
    """Returns the name of the event based on the cz_event_id or the cz_game_id."""

    # TODO : how to handle situations where an event_id is valid but that event hasn't been conducted yet?
    # e.g. event_id = 12312321312 returns 'CurlingZone – Everything Curling'

    ids = [cz_event_id,cz_game_id]
    if all(ids) or not any(ids):
        raise ValueError("One of cz_event_id or cz_game_id can be a non NoneType.")

    if cz_event_id:
        soup_type = LINESCORE_SOUP_TYPE
        url_kwargs = {
             'cz_event_id' : cz_event_id
            ,'cz_draw_id' : cz_draw_id
        }


    else:
        soup_type = BOXSCORE_SOUP_TYPE
        url_kwargs = {
             'cz_game_id' : cz_game_id
        }
        url = _get_game_url(cz_game_id = cz_game_id)

    url = get_url(soup_type = soup_type,**url_kwargs)
    soup = make_soup(url=url,**request_kwargs)

    return _get_event_name(soup=soup,soup_type = soup_type)

# Internal Cell

def _get_event_date_from_linescore_page(

     soup : BeautifulSoup
)->str:
    """Returns the dates of the event from the passed soup. Built so for larger-scale scraping less API calls are made."""
    return soup.find(name='div',attrs={'class':'badge-widget'}).string

def _get_event_date_from_boxscore_page(

    soup : BeautifulSoup

)->str:
    """Returns the dates of the event from the passed soup. Built so for larger-scale scraping less API calls are made."""
    return soup.find('div',attrs={'class':'badge-widget'}).string

# Internal Cell

def _get_event_date(

     soup : BeautifulSoup
    ,soup_type : str


)->str:
    soup_type = soup_type.lower()

    if soup_type == LINESCORE_SOUP_TYPE:
        return _get_event_date_from_linescore_page(soup=soup)
    elif soup_type == BOXSCORE_SOUP_TYPE:
        return _get_event_date_from_boxscore_page(soup=soup)
    else:
        raise NotImplementedError("%s soup type is not implemented."%soup_type)

# Cell

def get_event_date(

     cz_event_id : Optional[Union[str,int]] = None
    ,cz_draw_id : Optional[Union[str,int]] = None
    ,cz_game_id : Optional[Union[str,int]] = None
    ,**request_kwargs

)->str:
    """Returns the dates of the event based on the cz_event_id or the cz_game_id."""

    # TODO : how to handle situations where an event_id is valid but that event hasn't been conducted yet?
    # e.g. event_id = 12312321312 returns 'Recent'

    ids = [cz_event_id,cz_game_id]
    if all(ids) or not any(ids):
        raise ValueError("One of cz_event_id or cz_game_id can be a non NoneType.")

    if cz_event_id:
        soup_type = LINESCORE_SOUP_TYPE
        url_kwargs = {
             'cz_event_id' : cz_event_id
            ,'cz_draw_id' : cz_draw_id
        }



    else:
        soup_type = BOXSCORE_SOUP_TYPE
        url_kwargs = {
            'cz_game_id' : cz_game_id
        }


    url =  get_url(soup_type = soup_type,**url_kwargs)
    soup = make_soup(url=url,**request_kwargs)

    return _get_event_date(soup=soup,soup_type=soup_type)