"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineAnchoreInlineScanAction = void 0;
const aws_codebuild_1 = require("@aws-cdk/aws-codebuild");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
class CodePipelineAnchoreInlineScanAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.TEST,
            provider: 'CodeBuild',
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.input],
        });
        this.props = props;
    }
    bound(scope, _stage, options) {
        var _a, _b, _c;
        const buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_4_0;
        const version = (_a = this.props.version) !== null && _a !== void 0 ? _a : 'v0.7.2';
        const timeout = (_b = this.props.timeout) !== null && _b !== void 0 ? _b : 300;
        const policyBundlePath = (_c = this.props.policyBundlePath) !== null && _c !== void 0 ? _c : './policy_bundle.json';
        const url = `https://ci-tools.anchore.io/inline_scan-${version}`;
        const project = new aws_codebuild_1.PipelineProject(scope, 'VulnScanProject', {
            cache: aws_codebuild_1.Cache.local(aws_codebuild_1.LocalCacheMode.DOCKER_LAYER),
            environment: {
                buildImage,
                computeType: this.props.computeType || buildImage.defaultComputeType,
                privileged: true,
            },
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    pre_build: {
                        commands: ['echo Build started on `date`', 'docker build -t image2scan:ci .', 'echo Build completed on `date`'],
                    },
                    build: {
                        commands: [
                            'echo Scan started on `date`',
                            `curl -s ${url} | if [ -f "${policyBundlePath}" ]; then bash -s -- -f -t ${timeout} -b ${policyBundlePath} image2scan:ci; else bash -s -- -f -t ${timeout} image2scan:ci; fi`,
                            'echo Scan completed on `date`',
                        ],
                    },
                },
            }),
        });
        // grant the Pipeline role the required permissions to this Project
        options.role.addToPolicy(new aws_iam_1.PolicyStatement({
            resources: [project.projectArn],
            actions: ['codebuild:BatchGetBuilds', 'codebuild:StartBuild', 'codebuild:StopBuild'],
        }));
        // allow the Project access to the Pipeline's artifact Bucket
        // but only if the project is not imported
        // (ie., has a role) - otherwise, the IAM library throws an error
        if (project.role) {
            options.bucket.grantRead(project);
        }
        return {
            configuration: {
                ProjectName: project.projectName,
            },
        };
    }
}
exports.CodePipelineAnchoreInlineScanAction = CodePipelineAnchoreInlineScanAction;
//# sourceMappingURL=data:application/json;base64,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