import numpy as np
import numba
import scipy.optimize as sopt
import json

sin = np.sin
cos = np.cos
atan2 = np.arctan2
sqrt = np.sqrt 
sign = np.sign 
exp = np.exp


class cigre_europe_residential_4w2w_class: 

    def __init__(self): 

        self.t_end = 10.000000 
        self.Dt = 0.0010000 
        self.decimation = 10.000000 
        self.itol = 1e-6 
        self.Dt_max = 0.001000 
        self.Dt_min = 0.001000 
        self.solvern = 5 
        self.imax = 100 
        self.N_x = 1
        self.N_y = 433 
        self.N_z = 123 
        self.N_store = 10000 
        self.params_list = ['a_R1', 'b_R1', 'c_R1', 'a_R10', 'b_R10', 'c_R10', 'coef_a_R10', 'coef_b_R10', 'coef_c_R10', 'a_R14', 'b_R14', 'c_R14', 'coef_a_R14', 'coef_b_R14', 'coef_c_R14'] 
        self.params_values_list  = [2.92, 0.45, 0.027, 2.92, 0.45, 0.027, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 2.92, 0.45, 0.027, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333] 
        self.inputs_ini_list = ['v_R0_a_r', 'v_R0_a_i', 'v_R0_b_r', 'v_R0_b_i', 'v_R0_c_r', 'v_R0_c_i', 'v_D1_a_r', 'v_D1_a_i', 'v_D1_b_r', 'v_D1_b_i', 'v_D1_c_r', 'v_D1_c_i', 'i_R1_n_r', 'i_R1_n_i', 'i_R11_n_r', 'i_R11_n_i', 'i_R15_n_r', 'i_R15_n_i', 'i_R16_n_r', 'i_R16_n_i', 'i_R17_n_r', 'i_R17_n_i', 'i_R18_n_r', 'i_R18_n_i', 'i_R2_a_r', 'i_R2_a_i', 'i_R2_b_r', 'i_R2_b_i', 'i_R2_c_r', 'i_R2_c_i', 'i_R2_n_r', 'i_R2_n_i', 'i_R3_a_r', 'i_R3_a_i', 'i_R3_b_r', 'i_R3_b_i', 'i_R3_c_r', 'i_R3_c_i', 'i_R3_n_r', 'i_R3_n_i', 'i_R4_a_r', 'i_R4_a_i', 'i_R4_b_r', 'i_R4_b_i', 'i_R4_c_r', 'i_R4_c_i', 'i_R4_n_r', 'i_R4_n_i', 'i_R5_a_r', 'i_R5_a_i', 'i_R5_b_r', 'i_R5_b_i', 'i_R5_c_r', 'i_R5_c_i', 'i_R5_n_r', 'i_R5_n_i', 'i_R6_a_r', 'i_R6_a_i', 'i_R6_b_r', 'i_R6_b_i', 'i_R6_c_r', 'i_R6_c_i', 'i_R6_n_r', 'i_R6_n_i', 'i_R7_a_r', 'i_R7_a_i', 'i_R7_b_r', 'i_R7_b_i', 'i_R7_c_r', 'i_R7_c_i', 'i_R7_n_r', 'i_R7_n_i', 'i_R8_a_r', 'i_R8_a_i', 'i_R8_b_r', 'i_R8_b_i', 'i_R8_c_r', 'i_R8_c_i', 'i_R8_n_r', 'i_R8_n_i', 'i_R9_a_r', 'i_R9_a_i', 'i_R9_b_r', 'i_R9_b_i', 'i_R9_c_r', 'i_R9_c_i', 'i_R9_n_r', 'i_R9_n_i', 'i_R10_a_r', 'i_R10_a_i', 'i_R10_b_r', 'i_R10_b_i', 'i_R10_c_r', 'i_R10_c_i', 'i_R10_n_r', 'i_R10_n_i', 'i_R12_a_r', 'i_R12_a_i', 'i_R12_b_r', 'i_R12_b_i', 'i_R12_c_r', 'i_R12_c_i', 'i_R12_n_r', 'i_R12_n_i', 'i_R13_a_r', 'i_R13_a_i', 'i_R13_b_r', 'i_R13_b_i', 'i_R13_c_r', 'i_R13_c_i', 'i_R13_n_r', 'i_R13_n_i', 'i_R14_a_r', 'i_R14_a_i', 'i_R14_b_r', 'i_R14_b_i', 'i_R14_c_r', 'i_R14_c_i', 'i_R14_n_r', 'i_R14_n_i', 'i_D1_n_r', 'i_D1_n_i', 'i_D3_a_r', 'i_D3_a_i', 'i_D3_b_r', 'i_D3_b_i', 'i_D3_c_r', 'i_D3_c_i', 'i_D3_n_r', 'i_D3_n_i', 'i_D4_a_r', 'i_D4_a_i', 'i_D4_b_r', 'i_D4_b_i', 'i_D4_c_r', 'i_D4_c_i', 'i_D4_n_r', 'i_D4_n_i', 'i_D6_a_r', 'i_D6_a_i', 'i_D6_b_r', 'i_D6_b_i', 'i_D6_c_r', 'i_D6_c_i', 'i_D6_n_r', 'i_D6_n_i', 'i_D9_a_r', 'i_D9_a_i', 'i_D9_b_r', 'i_D9_b_i', 'i_D9_c_r', 'i_D9_c_i', 'i_D9_n_r', 'i_D9_n_i', 'i_D10_a_i', 'i_D10_b_r', 'i_D10_b_i', 'i_D10_c_r', 'i_D10_c_i', 'i_D10_n_i', 'i_D11_b_r', 'i_D11_b_i', 'i_D11_c_r', 'i_D11_c_i', 'i_D16_b_r', 'i_D16_b_i', 'i_D16_c_r', 'i_D16_c_i', 'i_D17_b_r', 'i_D17_b_i', 'i_D17_c_r', 'i_D17_c_i', 'i_D18_b_r', 'i_D18_b_i', 'i_D18_c_r', 'i_D18_c_i', 'i_D14_a_i', 'i_D14_b_r', 'i_D14_b_i', 'i_D14_c_r', 'i_D14_c_i', 'i_D14_n_i', 'i_D15_b_r', 'i_D15_b_i', 'i_D15_c_r', 'i_D15_c_i', 'p_R1_a', 'q_R1_a', 'p_R1_b', 'q_R1_b', 'p_R1_c', 'q_R1_c', 'p_R11_a', 'q_R11_a', 'p_R11_b', 'q_R11_b', 'p_R11_c', 'q_R11_c', 'p_R15_a', 'q_R15_a', 'p_R15_b', 'q_R15_b', 'p_R15_c', 'q_R15_c', 'p_R16_a', 'q_R16_a', 'p_R16_b', 'q_R16_b', 'p_R16_c', 'q_R16_c', 'p_R17_a', 'q_R17_a', 'p_R17_b', 'q_R17_b', 'p_R17_c', 'q_R17_c', 'p_R18_a', 'q_R18_a', 'p_R18_b', 'q_R18_b', 'p_R18_c', 'q_R18_c', 'p_D15_1', 'q_D15_1', 'p_D11_1', 'q_D11_1', 'p_D16_1', 'q_D16_1', 'p_D17_1', 'q_D17_1', 'p_D18_1', 'q_D18_1', 'v_dc_D1', 'q_R1', 'p_R10', 'q_R10', 'p_R14', 'q_R14', 'u_dummy'] 
        self.inputs_ini_values_list  = [11547.0, 0.0, -5773.499999999997, -9999.995337498915, -5773.5000000000055, 9999.99533749891, 800.0, 0.0, 0.0, -0.0, -0.0, 0.0, -0.11377181081280696, -0.062435919138408735, 0.038921773012907224, -0.1048963759937358, 0.34454059643019264, -0.7980789681157034, 0.37357657109664544, -0.8707524308167933, 0.3054824960816518, -0.6990681853205416, 0.4382865509753664, -0.9973969692563287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -63333.333333333765, -20816.659994665173, -63333.33333333563, -20816.659994662015, -63333.33333333578, -20816.65999465767, -4750.000000000053, -1561.2494995996628, -4749.999999999867, -1561.24949959979, -4750.000000000133, -1561.2494995994743, -16466.666666665096, -5412.33159861012, -16466.666666668374, -5412.331598611336, -16466.66666666625, -5412.331598613994, -17416.666666666664, -5724.581498531865, -17416.666666666515, -5724.5814985328325, -17416.66666666606, -5724.581498532622, -11083.333333333874, -3642.9154990660636, -11083.333333333529, -3642.9154990657007, -11083.333333333101, -3642.9154990652314, -14883.33333333232, -4891.91509874379, -14883.333333334123, -4891.91509874528, -14883.333333332876, -4891.915098746649, 174505.2828211094, 0.0, 174505.2828211094, 0.0, 174505.28282110934, 0.0, 174505.28282110937, 0.0, 174505.28282110937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0] 
        self.inputs_run_list = ['v_R0_a_r', 'v_R0_a_i', 'v_R0_b_r', 'v_R0_b_i', 'v_R0_c_r', 'v_R0_c_i', 'v_D1_a_r', 'v_D1_a_i', 'v_D1_b_r', 'v_D1_b_i', 'v_D1_c_r', 'v_D1_c_i', 'i_R1_n_r', 'i_R1_n_i', 'i_R11_n_r', 'i_R11_n_i', 'i_R15_n_r', 'i_R15_n_i', 'i_R16_n_r', 'i_R16_n_i', 'i_R17_n_r', 'i_R17_n_i', 'i_R18_n_r', 'i_R18_n_i', 'i_R2_a_r', 'i_R2_a_i', 'i_R2_b_r', 'i_R2_b_i', 'i_R2_c_r', 'i_R2_c_i', 'i_R2_n_r', 'i_R2_n_i', 'i_R3_a_r', 'i_R3_a_i', 'i_R3_b_r', 'i_R3_b_i', 'i_R3_c_r', 'i_R3_c_i', 'i_R3_n_r', 'i_R3_n_i', 'i_R4_a_r', 'i_R4_a_i', 'i_R4_b_r', 'i_R4_b_i', 'i_R4_c_r', 'i_R4_c_i', 'i_R4_n_r', 'i_R4_n_i', 'i_R5_a_r', 'i_R5_a_i', 'i_R5_b_r', 'i_R5_b_i', 'i_R5_c_r', 'i_R5_c_i', 'i_R5_n_r', 'i_R5_n_i', 'i_R6_a_r', 'i_R6_a_i', 'i_R6_b_r', 'i_R6_b_i', 'i_R6_c_r', 'i_R6_c_i', 'i_R6_n_r', 'i_R6_n_i', 'i_R7_a_r', 'i_R7_a_i', 'i_R7_b_r', 'i_R7_b_i', 'i_R7_c_r', 'i_R7_c_i', 'i_R7_n_r', 'i_R7_n_i', 'i_R8_a_r', 'i_R8_a_i', 'i_R8_b_r', 'i_R8_b_i', 'i_R8_c_r', 'i_R8_c_i', 'i_R8_n_r', 'i_R8_n_i', 'i_R9_a_r', 'i_R9_a_i', 'i_R9_b_r', 'i_R9_b_i', 'i_R9_c_r', 'i_R9_c_i', 'i_R9_n_r', 'i_R9_n_i', 'i_R10_a_r', 'i_R10_a_i', 'i_R10_b_r', 'i_R10_b_i', 'i_R10_c_r', 'i_R10_c_i', 'i_R10_n_r', 'i_R10_n_i', 'i_R12_a_r', 'i_R12_a_i', 'i_R12_b_r', 'i_R12_b_i', 'i_R12_c_r', 'i_R12_c_i', 'i_R12_n_r', 'i_R12_n_i', 'i_R13_a_r', 'i_R13_a_i', 'i_R13_b_r', 'i_R13_b_i', 'i_R13_c_r', 'i_R13_c_i', 'i_R13_n_r', 'i_R13_n_i', 'i_R14_a_r', 'i_R14_a_i', 'i_R14_b_r', 'i_R14_b_i', 'i_R14_c_r', 'i_R14_c_i', 'i_R14_n_r', 'i_R14_n_i', 'i_D1_n_r', 'i_D1_n_i', 'i_D3_a_r', 'i_D3_a_i', 'i_D3_b_r', 'i_D3_b_i', 'i_D3_c_r', 'i_D3_c_i', 'i_D3_n_r', 'i_D3_n_i', 'i_D4_a_r', 'i_D4_a_i', 'i_D4_b_r', 'i_D4_b_i', 'i_D4_c_r', 'i_D4_c_i', 'i_D4_n_r', 'i_D4_n_i', 'i_D6_a_r', 'i_D6_a_i', 'i_D6_b_r', 'i_D6_b_i', 'i_D6_c_r', 'i_D6_c_i', 'i_D6_n_r', 'i_D6_n_i', 'i_D9_a_r', 'i_D9_a_i', 'i_D9_b_r', 'i_D9_b_i', 'i_D9_c_r', 'i_D9_c_i', 'i_D9_n_r', 'i_D9_n_i', 'i_D10_a_i', 'i_D10_b_r', 'i_D10_b_i', 'i_D10_c_r', 'i_D10_c_i', 'i_D10_n_i', 'i_D11_b_r', 'i_D11_b_i', 'i_D11_c_r', 'i_D11_c_i', 'i_D16_b_r', 'i_D16_b_i', 'i_D16_c_r', 'i_D16_c_i', 'i_D17_b_r', 'i_D17_b_i', 'i_D17_c_r', 'i_D17_c_i', 'i_D18_b_r', 'i_D18_b_i', 'i_D18_c_r', 'i_D18_c_i', 'i_D14_a_i', 'i_D14_b_r', 'i_D14_b_i', 'i_D14_c_r', 'i_D14_c_i', 'i_D14_n_i', 'i_D15_b_r', 'i_D15_b_i', 'i_D15_c_r', 'i_D15_c_i', 'p_R1_a', 'q_R1_a', 'p_R1_b', 'q_R1_b', 'p_R1_c', 'q_R1_c', 'p_R11_a', 'q_R11_a', 'p_R11_b', 'q_R11_b', 'p_R11_c', 'q_R11_c', 'p_R15_a', 'q_R15_a', 'p_R15_b', 'q_R15_b', 'p_R15_c', 'q_R15_c', 'p_R16_a', 'q_R16_a', 'p_R16_b', 'q_R16_b', 'p_R16_c', 'q_R16_c', 'p_R17_a', 'q_R17_a', 'p_R17_b', 'q_R17_b', 'p_R17_c', 'q_R17_c', 'p_R18_a', 'q_R18_a', 'p_R18_b', 'q_R18_b', 'p_R18_c', 'q_R18_c', 'p_D15_1', 'q_D15_1', 'p_D11_1', 'q_D11_1', 'p_D16_1', 'q_D16_1', 'p_D17_1', 'q_D17_1', 'p_D18_1', 'q_D18_1', 'v_dc_D1', 'q_R1', 'p_R10', 'q_R10', 'p_R14', 'q_R14', 'u_dummy'] 
        self.inputs_run_values_list = [11547.0, 0.0, -5773.499999999997, -9999.995337498915, -5773.5000000000055, 9999.99533749891, 800.0, 0.0, 0.0, -0.0, -0.0, 0.0, -0.11377181081280696, -0.062435919138408735, 0.038921773012907224, -0.1048963759937358, 0.34454059643019264, -0.7980789681157034, 0.37357657109664544, -0.8707524308167933, 0.3054824960816518, -0.6990681853205416, 0.4382865509753664, -0.9973969692563287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -63333.333333333765, -20816.659994665173, -63333.33333333563, -20816.659994662015, -63333.33333333578, -20816.65999465767, -4750.000000000053, -1561.2494995996628, -4749.999999999867, -1561.24949959979, -4750.000000000133, -1561.2494995994743, -16466.666666665096, -5412.33159861012, -16466.666666668374, -5412.331598611336, -16466.66666666625, -5412.331598613994, -17416.666666666664, -5724.581498531865, -17416.666666666515, -5724.5814985328325, -17416.66666666606, -5724.581498532622, -11083.333333333874, -3642.9154990660636, -11083.333333333529, -3642.9154990657007, -11083.333333333101, -3642.9154990652314, -14883.33333333232, -4891.91509874379, -14883.333333334123, -4891.91509874528, -14883.333333332876, -4891.915098746649, 174505.2828211094, 0.0, 174505.2828211094, 0.0, 174505.28282110934, 0.0, 174505.28282110937, 0.0, 174505.28282110937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0] 
        self.outputs_list = ['v_R0_a_m', 'v_R0_b_m', 'v_R0_c_m', 'v_D1_a_m', 'v_D1_b_m', 'v_D1_c_m', 'v_R1_a_m', 'v_R1_b_m', 'v_R1_c_m', 'v_R1_n_m', 'v_R11_a_m', 'v_R11_b_m', 'v_R11_c_m', 'v_R11_n_m', 'v_R15_a_m', 'v_R15_b_m', 'v_R15_c_m', 'v_R15_n_m', 'v_R16_a_m', 'v_R16_b_m', 'v_R16_c_m', 'v_R16_n_m', 'v_R17_a_m', 'v_R17_b_m', 'v_R17_c_m', 'v_R17_n_m', 'v_R18_a_m', 'v_R18_b_m', 'v_R18_c_m', 'v_R18_n_m', 'v_D15_a_m', 'v_D15_n_m', 'v_D11_a_m', 'v_D11_n_m', 'v_D16_a_m', 'v_D16_n_m', 'v_D17_a_m', 'v_D17_n_m', 'v_D18_a_m', 'v_D18_n_m', 'v_R2_a_m', 'v_R2_b_m', 'v_R2_c_m', 'v_R2_n_m', 'v_R3_a_m', 'v_R3_b_m', 'v_R3_c_m', 'v_R3_n_m', 'v_R4_a_m', 'v_R4_b_m', 'v_R4_c_m', 'v_R4_n_m', 'v_R5_a_m', 'v_R5_b_m', 'v_R5_c_m', 'v_R5_n_m', 'v_R6_a_m', 'v_R6_b_m', 'v_R6_c_m', 'v_R6_n_m', 'v_R7_a_m', 'v_R7_b_m', 'v_R7_c_m', 'v_R7_n_m', 'v_R8_a_m', 'v_R8_b_m', 'v_R8_c_m', 'v_R8_n_m', 'v_R9_a_m', 'v_R9_b_m', 'v_R9_c_m', 'v_R9_n_m', 'v_R10_a_m', 'v_R10_b_m', 'v_R10_c_m', 'v_R10_n_m', 'v_R12_a_m', 'v_R12_b_m', 'v_R12_c_m', 'v_R12_n_m', 'v_R13_a_m', 'v_R13_b_m', 'v_R13_c_m', 'v_R13_n_m', 'v_R14_a_m', 'v_R14_b_m', 'v_R14_c_m', 'v_R14_n_m', 'v_D1_n_m', 'v_D3_a_m', 'v_D3_b_m', 'v_D3_c_m', 'v_D3_n_m', 'v_D4_a_m', 'v_D4_b_m', 'v_D4_c_m', 'v_D4_n_m', 'v_D6_a_m', 'v_D6_b_m', 'v_D6_c_m', 'v_D6_n_m', 'v_D9_a_m', 'v_D9_b_m', 'v_D9_c_m', 'v_D9_n_m', 'v_D10_a_m', 'v_D10_b_m', 'v_D10_c_m', 'v_D10_n_m', 'v_D11_b_m', 'v_D11_c_m', 'v_D16_b_m', 'v_D16_c_m', 'v_D17_b_m', 'v_D17_c_m', 'v_D18_b_m', 'v_D18_c_m', 'v_D14_a_m', 'v_D14_b_m', 'v_D14_c_m', 'v_D14_n_m', 'v_D15_b_m', 'v_D15_c_m'] 
        self.x_list = ['x_dummy'] 
        self.y_run_list = ['v_R1_a_r', 'v_R1_a_i', 'v_R1_b_r', 'v_R1_b_i', 'v_R1_c_r', 'v_R1_c_i', 'v_R1_n_r', 'v_R1_n_i', 'v_R11_a_r', 'v_R11_a_i', 'v_R11_b_r', 'v_R11_b_i', 'v_R11_c_r', 'v_R11_c_i', 'v_R11_n_r', 'v_R11_n_i', 'v_R15_a_r', 'v_R15_a_i', 'v_R15_b_r', 'v_R15_b_i', 'v_R15_c_r', 'v_R15_c_i', 'v_R15_n_r', 'v_R15_n_i', 'v_R16_a_r', 'v_R16_a_i', 'v_R16_b_r', 'v_R16_b_i', 'v_R16_c_r', 'v_R16_c_i', 'v_R16_n_r', 'v_R16_n_i', 'v_R17_a_r', 'v_R17_a_i', 'v_R17_b_r', 'v_R17_b_i', 'v_R17_c_r', 'v_R17_c_i', 'v_R17_n_r', 'v_R17_n_i', 'v_R18_a_r', 'v_R18_a_i', 'v_R18_b_r', 'v_R18_b_i', 'v_R18_c_r', 'v_R18_c_i', 'v_R18_n_r', 'v_R18_n_i', 'v_D15_a_r', 'v_D15_a_i', 'v_D15_n_r', 'v_D15_n_i', 'v_D11_a_r', 'v_D11_a_i', 'v_D11_n_r', 'v_D11_n_i', 'v_D16_a_r', 'v_D16_a_i', 'v_D16_n_r', 'v_D16_n_i', 'v_D17_a_r', 'v_D17_a_i', 'v_D17_n_r', 'v_D17_n_i', 'v_D18_a_r', 'v_D18_a_i', 'v_D18_n_r', 'v_D18_n_i', 'v_R2_a_r', 'v_R2_a_i', 'v_R2_b_r', 'v_R2_b_i', 'v_R2_c_r', 'v_R2_c_i', 'v_R2_n_r', 'v_R2_n_i', 'v_R3_a_r', 'v_R3_a_i', 'v_R3_b_r', 'v_R3_b_i', 'v_R3_c_r', 'v_R3_c_i', 'v_R3_n_r', 'v_R3_n_i', 'v_R4_a_r', 'v_R4_a_i', 'v_R4_b_r', 'v_R4_b_i', 'v_R4_c_r', 'v_R4_c_i', 'v_R4_n_r', 'v_R4_n_i', 'v_R5_a_r', 'v_R5_a_i', 'v_R5_b_r', 'v_R5_b_i', 'v_R5_c_r', 'v_R5_c_i', 'v_R5_n_r', 'v_R5_n_i', 'v_R6_a_r', 'v_R6_a_i', 'v_R6_b_r', 'v_R6_b_i', 'v_R6_c_r', 'v_R6_c_i', 'v_R6_n_r', 'v_R6_n_i', 'v_R7_a_r', 'v_R7_a_i', 'v_R7_b_r', 'v_R7_b_i', 'v_R7_c_r', 'v_R7_c_i', 'v_R7_n_r', 'v_R7_n_i', 'v_R8_a_r', 'v_R8_a_i', 'v_R8_b_r', 'v_R8_b_i', 'v_R8_c_r', 'v_R8_c_i', 'v_R8_n_r', 'v_R8_n_i', 'v_R9_a_r', 'v_R9_a_i', 'v_R9_b_r', 'v_R9_b_i', 'v_R9_c_r', 'v_R9_c_i', 'v_R9_n_r', 'v_R9_n_i', 'v_R10_a_r', 'v_R10_a_i', 'v_R10_b_r', 'v_R10_b_i', 'v_R10_c_r', 'v_R10_c_i', 'v_R10_n_r', 'v_R10_n_i', 'v_R12_a_r', 'v_R12_a_i', 'v_R12_b_r', 'v_R12_b_i', 'v_R12_c_r', 'v_R12_c_i', 'v_R12_n_r', 'v_R12_n_i', 'v_R13_a_r', 'v_R13_a_i', 'v_R13_b_r', 'v_R13_b_i', 'v_R13_c_r', 'v_R13_c_i', 'v_R13_n_r', 'v_R13_n_i', 'v_R14_a_r', 'v_R14_a_i', 'v_R14_b_r', 'v_R14_b_i', 'v_R14_c_r', 'v_R14_c_i', 'v_R14_n_r', 'v_R14_n_i', 'v_D1_n_r', 'v_D1_n_i', 'v_D3_a_r', 'v_D3_a_i', 'v_D3_b_r', 'v_D3_b_i', 'v_D3_c_r', 'v_D3_c_i', 'v_D3_n_r', 'v_D3_n_i', 'v_D4_a_r', 'v_D4_a_i', 'v_D4_b_r', 'v_D4_b_i', 'v_D4_c_r', 'v_D4_c_i', 'v_D4_n_r', 'v_D4_n_i', 'v_D6_a_r', 'v_D6_a_i', 'v_D6_b_r', 'v_D6_b_i', 'v_D6_c_r', 'v_D6_c_i', 'v_D6_n_r', 'v_D6_n_i', 'v_D9_a_r', 'v_D9_a_i', 'v_D9_b_r', 'v_D9_b_i', 'v_D9_c_r', 'v_D9_c_i', 'v_D9_n_r', 'v_D9_n_i', 'v_D10_a_r', 'v_D10_a_i', 'v_D10_b_r', 'v_D10_b_i', 'v_D10_c_r', 'v_D10_c_i', 'v_D10_n_r', 'v_D10_n_i', 'v_D11_b_r', 'v_D11_b_i', 'v_D11_c_r', 'v_D11_c_i', 'v_D16_b_r', 'v_D16_b_i', 'v_D16_c_r', 'v_D16_c_i', 'v_D17_b_r', 'v_D17_b_i', 'v_D17_c_r', 'v_D17_c_i', 'v_D18_b_r', 'v_D18_b_i', 'v_D18_c_r', 'v_D18_c_i', 'v_D14_a_r', 'v_D14_a_i', 'v_D14_b_r', 'v_D14_b_i', 'v_D14_c_r', 'v_D14_c_i', 'v_D14_n_r', 'v_D14_n_i', 'v_D15_b_r', 'v_D15_b_i', 'v_D15_c_r', 'v_D15_c_i', 'i_t_R0_R1_a_r', 'i_t_R0_R1_a_i', 'i_t_R0_R1_b_r', 'i_t_R0_R1_b_i', 'i_t_R0_R1_c_r', 'i_t_R0_R1_c_i', 'i_l_R1_R2_a_r', 'i_l_R1_R2_a_i', 'i_l_R1_R2_b_r', 'i_l_R1_R2_b_i', 'i_l_R1_R2_c_r', 'i_l_R1_R2_c_i', 'i_l_R1_R2_n_r', 'i_l_R1_R2_n_i', 'i_l_D1_D3_a_r', 'i_l_D1_D3_a_i', 'i_l_D1_D3_b_r', 'i_l_D1_D3_b_i', 'i_l_D1_D3_c_r', 'i_l_D1_D3_c_i', 'i_l_D1_D3_n_r', 'i_l_D1_D3_n_i', 'i_l_D3_D4_a_r', 'i_l_D3_D4_a_i', 'i_l_D3_D4_b_r', 'i_l_D3_D4_b_i', 'i_l_D3_D4_c_r', 'i_l_D3_D4_c_i', 'i_l_D3_D4_n_r', 'i_l_D3_D4_n_i', 'i_l_D4_D6_a_r', 'i_l_D4_D6_a_i', 'i_l_D4_D6_b_r', 'i_l_D4_D6_b_i', 'i_l_D4_D6_c_r', 'i_l_D4_D6_c_i', 'i_l_D4_D6_n_r', 'i_l_D4_D6_n_i', 'i_l_D6_D9_a_r', 'i_l_D6_D9_a_i', 'i_l_D6_D9_b_r', 'i_l_D6_D9_b_i', 'i_l_D6_D9_c_r', 'i_l_D6_D9_c_i', 'i_l_D6_D9_n_r', 'i_l_D6_D9_n_i', 'i_l_D9_D10_a_r', 'i_l_D9_D10_a_i', 'i_l_D9_D10_b_r', 'i_l_D9_D10_b_i', 'i_l_D9_D10_c_r', 'i_l_D9_D10_c_i', 'i_l_D9_D10_n_r', 'i_l_D9_D10_n_i', 'i_l_D3_D11_a_r', 'i_l_D3_D11_a_i', 'i_l_D3_D11_b_r', 'i_l_D3_D11_b_i', 'i_l_D3_D11_c_r', 'i_l_D3_D11_c_i', 'i_l_D3_D11_n_r', 'i_l_D3_D11_n_i', 'i_l_D6_D16_a_r', 'i_l_D6_D16_a_i', 'i_l_D6_D16_b_r', 'i_l_D6_D16_b_i', 'i_l_D6_D16_c_r', 'i_l_D6_D16_c_i', 'i_l_D6_D16_n_r', 'i_l_D6_D16_n_i', 'i_l_D9_D17_a_r', 'i_l_D9_D17_a_i', 'i_l_D9_D17_b_r', 'i_l_D9_D17_b_i', 'i_l_D9_D17_c_r', 'i_l_D9_D17_c_i', 'i_l_D9_D17_n_r', 'i_l_D9_D17_n_i', 'i_l_D10_D18_a_r', 'i_l_D10_D18_a_i', 'i_l_D10_D18_b_r', 'i_l_D10_D18_b_i', 'i_l_D10_D18_c_r', 'i_l_D10_D18_c_i', 'i_l_D10_D18_n_r', 'i_l_D10_D18_n_i', 'i_l_D4_D14_a_r', 'i_l_D4_D14_a_i', 'i_l_D4_D14_b_r', 'i_l_D4_D14_b_i', 'i_l_D4_D14_c_r', 'i_l_D4_D14_c_i', 'i_l_D4_D14_n_r', 'i_l_D4_D14_n_i', 'i_l_D14_D15_a_r', 'i_l_D14_D15_a_i', 'i_l_D14_D15_b_r', 'i_l_D14_D15_b_i', 'i_l_D14_D15_c_r', 'i_l_D14_D15_c_i', 'i_l_D14_D15_n_r', 'i_l_D14_D15_n_i', 'i_load_R1_a_r', 'i_load_R1_a_i', 'i_load_R1_b_r', 'i_load_R1_b_i', 'i_load_R1_c_r', 'i_load_R1_c_i', 'i_load_R1_n_r', 'i_load_R1_n_i', 'i_load_R11_a_r', 'i_load_R11_a_i', 'i_load_R11_b_r', 'i_load_R11_b_i', 'i_load_R11_c_r', 'i_load_R11_c_i', 'i_load_R11_n_r', 'i_load_R11_n_i', 'i_load_R15_a_r', 'i_load_R15_a_i', 'i_load_R15_b_r', 'i_load_R15_b_i', 'i_load_R15_c_r', 'i_load_R15_c_i', 'i_load_R15_n_r', 'i_load_R15_n_i', 'i_load_R16_a_r', 'i_load_R16_a_i', 'i_load_R16_b_r', 'i_load_R16_b_i', 'i_load_R16_c_r', 'i_load_R16_c_i', 'i_load_R16_n_r', 'i_load_R16_n_i', 'i_load_R17_a_r', 'i_load_R17_a_i', 'i_load_R17_b_r', 'i_load_R17_b_i', 'i_load_R17_c_r', 'i_load_R17_c_i', 'i_load_R17_n_r', 'i_load_R17_n_i', 'i_load_R18_a_r', 'i_load_R18_a_i', 'i_load_R18_b_r', 'i_load_R18_b_i', 'i_load_R18_c_r', 'i_load_R18_c_i', 'i_load_R18_n_r', 'i_load_R18_n_i', 'i_load_D15_a_r', 'i_load_D15_a_i', 'i_load_D15_n_r', 'i_load_D15_n_i', 'i_load_D11_a_r', 'i_load_D11_a_i', 'i_load_D11_n_r', 'i_load_D11_n_i', 'i_load_D16_a_r', 'i_load_D16_a_i', 'i_load_D16_n_r', 'i_load_D16_n_i', 'i_load_D17_a_r', 'i_load_D17_a_i', 'i_load_D17_n_r', 'i_load_D17_n_i', 'i_load_D18_a_r', 'i_load_D18_a_i', 'i_load_D18_n_r', 'i_load_D18_n_i', 'i_vsc_R1_a_r', 'i_vsc_R1_a_i', 'i_vsc_R1_b_r', 'i_vsc_R1_b_i', 'i_vsc_R1_c_r', 'i_vsc_R1_c_i', 'p_R1', 'p_D1', 'p_loss_R1', 'i_vsc_R10_a_r', 'i_vsc_R10_a_i', 'i_vsc_R10_b_r', 'i_vsc_R10_b_i', 'i_vsc_R10_c_r', 'i_vsc_R10_c_i', 'i_vsc_D10_a_r', 'i_vsc_D10_n_r', 'p_D10', 'p_loss_R10', 'i_vsc_R14_a_r', 'i_vsc_R14_a_i', 'i_vsc_R14_b_r', 'i_vsc_R14_b_i', 'i_vsc_R14_c_r', 'i_vsc_R14_c_i', 'i_vsc_D14_a_r', 'i_vsc_D14_n_r', 'p_D14', 'p_loss_R14'] 
        self.xy_list = self.x_list + self.y_run_list 
        self.y_ini_list = ['v_R1_a_r', 'v_R1_a_i', 'v_R1_b_r', 'v_R1_b_i', 'v_R1_c_r', 'v_R1_c_i', 'v_R1_n_r', 'v_R1_n_i', 'v_R11_a_r', 'v_R11_a_i', 'v_R11_b_r', 'v_R11_b_i', 'v_R11_c_r', 'v_R11_c_i', 'v_R11_n_r', 'v_R11_n_i', 'v_R15_a_r', 'v_R15_a_i', 'v_R15_b_r', 'v_R15_b_i', 'v_R15_c_r', 'v_R15_c_i', 'v_R15_n_r', 'v_R15_n_i', 'v_R16_a_r', 'v_R16_a_i', 'v_R16_b_r', 'v_R16_b_i', 'v_R16_c_r', 'v_R16_c_i', 'v_R16_n_r', 'v_R16_n_i', 'v_R17_a_r', 'v_R17_a_i', 'v_R17_b_r', 'v_R17_b_i', 'v_R17_c_r', 'v_R17_c_i', 'v_R17_n_r', 'v_R17_n_i', 'v_R18_a_r', 'v_R18_a_i', 'v_R18_b_r', 'v_R18_b_i', 'v_R18_c_r', 'v_R18_c_i', 'v_R18_n_r', 'v_R18_n_i', 'v_D15_a_r', 'v_D15_a_i', 'v_D15_n_r', 'v_D15_n_i', 'v_D11_a_r', 'v_D11_a_i', 'v_D11_n_r', 'v_D11_n_i', 'v_D16_a_r', 'v_D16_a_i', 'v_D16_n_r', 'v_D16_n_i', 'v_D17_a_r', 'v_D17_a_i', 'v_D17_n_r', 'v_D17_n_i', 'v_D18_a_r', 'v_D18_a_i', 'v_D18_n_r', 'v_D18_n_i', 'v_R2_a_r', 'v_R2_a_i', 'v_R2_b_r', 'v_R2_b_i', 'v_R2_c_r', 'v_R2_c_i', 'v_R2_n_r', 'v_R2_n_i', 'v_R3_a_r', 'v_R3_a_i', 'v_R3_b_r', 'v_R3_b_i', 'v_R3_c_r', 'v_R3_c_i', 'v_R3_n_r', 'v_R3_n_i', 'v_R4_a_r', 'v_R4_a_i', 'v_R4_b_r', 'v_R4_b_i', 'v_R4_c_r', 'v_R4_c_i', 'v_R4_n_r', 'v_R4_n_i', 'v_R5_a_r', 'v_R5_a_i', 'v_R5_b_r', 'v_R5_b_i', 'v_R5_c_r', 'v_R5_c_i', 'v_R5_n_r', 'v_R5_n_i', 'v_R6_a_r', 'v_R6_a_i', 'v_R6_b_r', 'v_R6_b_i', 'v_R6_c_r', 'v_R6_c_i', 'v_R6_n_r', 'v_R6_n_i', 'v_R7_a_r', 'v_R7_a_i', 'v_R7_b_r', 'v_R7_b_i', 'v_R7_c_r', 'v_R7_c_i', 'v_R7_n_r', 'v_R7_n_i', 'v_R8_a_r', 'v_R8_a_i', 'v_R8_b_r', 'v_R8_b_i', 'v_R8_c_r', 'v_R8_c_i', 'v_R8_n_r', 'v_R8_n_i', 'v_R9_a_r', 'v_R9_a_i', 'v_R9_b_r', 'v_R9_b_i', 'v_R9_c_r', 'v_R9_c_i', 'v_R9_n_r', 'v_R9_n_i', 'v_R10_a_r', 'v_R10_a_i', 'v_R10_b_r', 'v_R10_b_i', 'v_R10_c_r', 'v_R10_c_i', 'v_R10_n_r', 'v_R10_n_i', 'v_R12_a_r', 'v_R12_a_i', 'v_R12_b_r', 'v_R12_b_i', 'v_R12_c_r', 'v_R12_c_i', 'v_R12_n_r', 'v_R12_n_i', 'v_R13_a_r', 'v_R13_a_i', 'v_R13_b_r', 'v_R13_b_i', 'v_R13_c_r', 'v_R13_c_i', 'v_R13_n_r', 'v_R13_n_i', 'v_R14_a_r', 'v_R14_a_i', 'v_R14_b_r', 'v_R14_b_i', 'v_R14_c_r', 'v_R14_c_i', 'v_R14_n_r', 'v_R14_n_i', 'v_D1_n_r', 'v_D1_n_i', 'v_D3_a_r', 'v_D3_a_i', 'v_D3_b_r', 'v_D3_b_i', 'v_D3_c_r', 'v_D3_c_i', 'v_D3_n_r', 'v_D3_n_i', 'v_D4_a_r', 'v_D4_a_i', 'v_D4_b_r', 'v_D4_b_i', 'v_D4_c_r', 'v_D4_c_i', 'v_D4_n_r', 'v_D4_n_i', 'v_D6_a_r', 'v_D6_a_i', 'v_D6_b_r', 'v_D6_b_i', 'v_D6_c_r', 'v_D6_c_i', 'v_D6_n_r', 'v_D6_n_i', 'v_D9_a_r', 'v_D9_a_i', 'v_D9_b_r', 'v_D9_b_i', 'v_D9_c_r', 'v_D9_c_i', 'v_D9_n_r', 'v_D9_n_i', 'v_D10_a_r', 'v_D10_a_i', 'v_D10_b_r', 'v_D10_b_i', 'v_D10_c_r', 'v_D10_c_i', 'v_D10_n_r', 'v_D10_n_i', 'v_D11_b_r', 'v_D11_b_i', 'v_D11_c_r', 'v_D11_c_i', 'v_D16_b_r', 'v_D16_b_i', 'v_D16_c_r', 'v_D16_c_i', 'v_D17_b_r', 'v_D17_b_i', 'v_D17_c_r', 'v_D17_c_i', 'v_D18_b_r', 'v_D18_b_i', 'v_D18_c_r', 'v_D18_c_i', 'v_D14_a_r', 'v_D14_a_i', 'v_D14_b_r', 'v_D14_b_i', 'v_D14_c_r', 'v_D14_c_i', 'v_D14_n_r', 'v_D14_n_i', 'v_D15_b_r', 'v_D15_b_i', 'v_D15_c_r', 'v_D15_c_i', 'i_t_R0_R1_a_r', 'i_t_R0_R1_a_i', 'i_t_R0_R1_b_r', 'i_t_R0_R1_b_i', 'i_t_R0_R1_c_r', 'i_t_R0_R1_c_i', 'i_l_R1_R2_a_r', 'i_l_R1_R2_a_i', 'i_l_R1_R2_b_r', 'i_l_R1_R2_b_i', 'i_l_R1_R2_c_r', 'i_l_R1_R2_c_i', 'i_l_R1_R2_n_r', 'i_l_R1_R2_n_i', 'i_l_D1_D3_a_r', 'i_l_D1_D3_a_i', 'i_l_D1_D3_b_r', 'i_l_D1_D3_b_i', 'i_l_D1_D3_c_r', 'i_l_D1_D3_c_i', 'i_l_D1_D3_n_r', 'i_l_D1_D3_n_i', 'i_l_D3_D4_a_r', 'i_l_D3_D4_a_i', 'i_l_D3_D4_b_r', 'i_l_D3_D4_b_i', 'i_l_D3_D4_c_r', 'i_l_D3_D4_c_i', 'i_l_D3_D4_n_r', 'i_l_D3_D4_n_i', 'i_l_D4_D6_a_r', 'i_l_D4_D6_a_i', 'i_l_D4_D6_b_r', 'i_l_D4_D6_b_i', 'i_l_D4_D6_c_r', 'i_l_D4_D6_c_i', 'i_l_D4_D6_n_r', 'i_l_D4_D6_n_i', 'i_l_D6_D9_a_r', 'i_l_D6_D9_a_i', 'i_l_D6_D9_b_r', 'i_l_D6_D9_b_i', 'i_l_D6_D9_c_r', 'i_l_D6_D9_c_i', 'i_l_D6_D9_n_r', 'i_l_D6_D9_n_i', 'i_l_D9_D10_a_r', 'i_l_D9_D10_a_i', 'i_l_D9_D10_b_r', 'i_l_D9_D10_b_i', 'i_l_D9_D10_c_r', 'i_l_D9_D10_c_i', 'i_l_D9_D10_n_r', 'i_l_D9_D10_n_i', 'i_l_D3_D11_a_r', 'i_l_D3_D11_a_i', 'i_l_D3_D11_b_r', 'i_l_D3_D11_b_i', 'i_l_D3_D11_c_r', 'i_l_D3_D11_c_i', 'i_l_D3_D11_n_r', 'i_l_D3_D11_n_i', 'i_l_D6_D16_a_r', 'i_l_D6_D16_a_i', 'i_l_D6_D16_b_r', 'i_l_D6_D16_b_i', 'i_l_D6_D16_c_r', 'i_l_D6_D16_c_i', 'i_l_D6_D16_n_r', 'i_l_D6_D16_n_i', 'i_l_D9_D17_a_r', 'i_l_D9_D17_a_i', 'i_l_D9_D17_b_r', 'i_l_D9_D17_b_i', 'i_l_D9_D17_c_r', 'i_l_D9_D17_c_i', 'i_l_D9_D17_n_r', 'i_l_D9_D17_n_i', 'i_l_D10_D18_a_r', 'i_l_D10_D18_a_i', 'i_l_D10_D18_b_r', 'i_l_D10_D18_b_i', 'i_l_D10_D18_c_r', 'i_l_D10_D18_c_i', 'i_l_D10_D18_n_r', 'i_l_D10_D18_n_i', 'i_l_D4_D14_a_r', 'i_l_D4_D14_a_i', 'i_l_D4_D14_b_r', 'i_l_D4_D14_b_i', 'i_l_D4_D14_c_r', 'i_l_D4_D14_c_i', 'i_l_D4_D14_n_r', 'i_l_D4_D14_n_i', 'i_l_D14_D15_a_r', 'i_l_D14_D15_a_i', 'i_l_D14_D15_b_r', 'i_l_D14_D15_b_i', 'i_l_D14_D15_c_r', 'i_l_D14_D15_c_i', 'i_l_D14_D15_n_r', 'i_l_D14_D15_n_i', 'i_load_R1_a_r', 'i_load_R1_a_i', 'i_load_R1_b_r', 'i_load_R1_b_i', 'i_load_R1_c_r', 'i_load_R1_c_i', 'i_load_R1_n_r', 'i_load_R1_n_i', 'i_load_R11_a_r', 'i_load_R11_a_i', 'i_load_R11_b_r', 'i_load_R11_b_i', 'i_load_R11_c_r', 'i_load_R11_c_i', 'i_load_R11_n_r', 'i_load_R11_n_i', 'i_load_R15_a_r', 'i_load_R15_a_i', 'i_load_R15_b_r', 'i_load_R15_b_i', 'i_load_R15_c_r', 'i_load_R15_c_i', 'i_load_R15_n_r', 'i_load_R15_n_i', 'i_load_R16_a_r', 'i_load_R16_a_i', 'i_load_R16_b_r', 'i_load_R16_b_i', 'i_load_R16_c_r', 'i_load_R16_c_i', 'i_load_R16_n_r', 'i_load_R16_n_i', 'i_load_R17_a_r', 'i_load_R17_a_i', 'i_load_R17_b_r', 'i_load_R17_b_i', 'i_load_R17_c_r', 'i_load_R17_c_i', 'i_load_R17_n_r', 'i_load_R17_n_i', 'i_load_R18_a_r', 'i_load_R18_a_i', 'i_load_R18_b_r', 'i_load_R18_b_i', 'i_load_R18_c_r', 'i_load_R18_c_i', 'i_load_R18_n_r', 'i_load_R18_n_i', 'i_load_D15_a_r', 'i_load_D15_a_i', 'i_load_D15_n_r', 'i_load_D15_n_i', 'i_load_D11_a_r', 'i_load_D11_a_i', 'i_load_D11_n_r', 'i_load_D11_n_i', 'i_load_D16_a_r', 'i_load_D16_a_i', 'i_load_D16_n_r', 'i_load_D16_n_i', 'i_load_D17_a_r', 'i_load_D17_a_i', 'i_load_D17_n_r', 'i_load_D17_n_i', 'i_load_D18_a_r', 'i_load_D18_a_i', 'i_load_D18_n_r', 'i_load_D18_n_i', 'i_vsc_R1_a_r', 'i_vsc_R1_a_i', 'i_vsc_R1_b_r', 'i_vsc_R1_b_i', 'i_vsc_R1_c_r', 'i_vsc_R1_c_i', 'p_R1', 'p_D1', 'p_loss_R1', 'i_vsc_R10_a_r', 'i_vsc_R10_a_i', 'i_vsc_R10_b_r', 'i_vsc_R10_b_i', 'i_vsc_R10_c_r', 'i_vsc_R10_c_i', 'i_vsc_D10_a_r', 'i_vsc_D10_n_r', 'p_D10', 'p_loss_R10', 'i_vsc_R14_a_r', 'i_vsc_R14_a_i', 'i_vsc_R14_b_r', 'i_vsc_R14_b_i', 'i_vsc_R14_c_r', 'i_vsc_R14_c_i', 'i_vsc_D14_a_r', 'i_vsc_D14_n_r', 'p_D14', 'p_loss_R14'] 
        self.xy_ini_list = self.x_list + self.y_ini_list 
        self.t = 0.0
        self.it = 0
        self.it_store = 0
        self.xy_prev = np.zeros((self.N_x+self.N_y,1))
        self.initialization_tol = 1e-6
        self.N_u = len(self.inputs_run_list) 
        self.sopt_root_method='hybr'
        self.sopt_root_jac=True
        self.u_ini_list = self.inputs_ini_list
        self.u_ini_values_list = self.inputs_ini_values_list
        self.u_run_list = self.inputs_run_list
        self.u_run_values_list = self.inputs_run_values_list
        self.N_u = len(self.u_run_list)
        Fx_ini_rows,Fx_ini_cols,Fy_ini_rows,Fy_ini_cols,Gx_ini_rows,Gx_ini_cols,Gy_ini_rows,Gy_ini_cols = nonzeros()

        self.Fx_ini_rows = np.array(Fx_ini_rows) 
        if len(Fx_ini_rows) == 1: 
            self.Fx_ini_rows = np.array([[Fx_ini_rows]]).reshape(1,) 
            self.Fx_ini_cols = np.array([[Fx_ini_cols]]).reshape(1,)  
            
        self.Fx_ini_cols = np.array(Fx_ini_cols)
        self.Fy_ini_rows = np.array(Fy_ini_rows)        
        self.Fy_ini_cols = np.array(Fy_ini_cols)
        self.Gx_ini_rows = np.array(Gx_ini_rows)        
        self.Gx_ini_cols = np.array(Gx_ini_cols)
        self.Gy_ini_rows = np.array(Gy_ini_rows)        
        self.Gy_ini_cols = np.array(Gy_ini_cols)
        
        
        self.yini2urun = list(set(self.inputs_run_list).intersection(set(self.y_ini_list)))
        self.uini2yrun = list(set(self.y_run_list).intersection(set(self.inputs_ini_list)))

        self.update() 
                
    def update(self): 

        self.N_steps = int(np.ceil(self.t_end/self.Dt)) 
        dt = [  
              ('t_end', np.float64),
              ('Dt', np.float64),
              ('decimation', np.float64),
              ('itol', np.float64),
              ('Dt_max', np.float64),
              ('Dt_min', np.float64),
              ('solvern', np.int64),
              ('imax', np.int64),
              ('N_steps', np.int64),
              ('N_store', np.int64),
              ('N_x', np.int64),
              ('N_y', np.int64),
              ('N_z', np.int64),
              ('t', np.float64),
              ('it', np.int64),
              ('it_store', np.int64),
              ('idx', np.int64),
              ('idy', np.int64),
              ('f', np.float64, (self.N_x,1)),
              ('x', np.float64, (self.N_x,1)),
              ('x_0', np.float64, (self.N_x,1)),
              ('g', np.float64, (self.N_y,1)),
              ('y_run', np.float64, (self.N_y,1)),
              ('y_ini', np.float64, (self.N_y,1)),
              ('u_run', np.float64, (self.N_u,1)),
              ('y_0', np.float64, (self.N_y,1)),
              ('h', np.float64, (self.N_z,1)),
              ('Fx', np.float64, (self.N_x,self.N_x)),
              ('Fy', np.float64, (self.N_x,self.N_y)),
              ('Gx', np.float64, (self.N_y,self.N_x)),
              ('Gy', np.float64, (self.N_y,self.N_y)),
              ('Fu', np.float64, (self.N_x,self.N_u)),
              ('Gu', np.float64, (self.N_y,self.N_u)),
              ('Hx', np.float64, (self.N_z,self.N_x)),
              ('Hy', np.float64, (self.N_z,self.N_y)),
              ('Hu', np.float64, (self.N_z,self.N_u)),
              ('Fx_ini', np.float64, (self.N_x,self.N_x)),
              ('Fy_ini', np.float64, (self.N_x,self.N_y)),
              ('Gx_ini', np.float64, (self.N_y,self.N_x)),
              ('Gy_ini', np.float64, (self.N_y,self.N_y)),
              ('T', np.float64, (self.N_store+1,1)),
              ('X', np.float64, (self.N_store+1,self.N_x)),
              ('Y', np.float64, (self.N_store+1,self.N_y)),
              ('Z', np.float64, (self.N_store+1,self.N_z)),
              ('iters', np.float64, (self.N_store+1,1)),
              ('store', np.int64),
              ('Fx_ini_rows', np.int64, self.Fx_ini_rows.shape),
              ('Fx_ini_cols', np.int64, self.Fx_ini_cols.shape),
              ('Fy_ini_rows', np.int64, self.Fy_ini_rows.shape),
              ('Fy_ini_cols', np.int64, self.Fy_ini_cols.shape),
              ('Gx_ini_rows', np.int64, self.Gx_ini_rows.shape),
              ('Gx_ini_cols', np.int64, self.Gx_ini_cols.shape),
              ('Gy_ini_rows', np.int64, self.Gy_ini_rows.shape),
              ('Gy_ini_cols', np.int64, self.Gy_ini_cols.shape),
              ('Ac_ini', np.float64, ((self.N_x+self.N_y,self.N_x+self.N_y))),   
              ('fg', np.float64, ((self.N_x+self.N_y,1))),  
             ]



        
        
        values = [
                self.t_end,                          
                self.Dt,
                self.decimation,
                self.itol,
                self.Dt_max,
                self.Dt_min,
                self.solvern,
                self.imax,
                self.N_steps,
                self.N_store,
                self.N_x,
                self.N_y,
                self.N_z,
                self.t,
                self.it,
                self.it_store,
                0,                                     # idx
                0,                                     # idy
                np.zeros((self.N_x,1)),                # f
                np.zeros((self.N_x,1)),                # x
                np.zeros((self.N_x,1)),                # x_0
                np.zeros((self.N_y,1)),                # g
                np.zeros((self.N_y,1)),                # y_run
                np.zeros((self.N_y,1)),                # y_ini
                np.zeros((self.N_u,1)),                # u_run
                np.zeros((self.N_y,1)),                # y_0
                np.zeros((self.N_z,1)),                # h
                np.zeros((self.N_x,self.N_x)),         # Fx   
                np.zeros((self.N_x,self.N_y)),         # Fy 
                np.zeros((self.N_y,self.N_x)),         # Gx 
                np.zeros((self.N_y,self.N_y)),         # Fy
                np.zeros((self.N_x,self.N_u)),         # Fu 
                np.zeros((self.N_y,self.N_u)),         # Gu 
                np.zeros((self.N_z,self.N_x)),         # Hx 
                np.zeros((self.N_z,self.N_y)),         # Hy 
                np.zeros((self.N_z,self.N_u)),         # Hu 
                np.zeros((self.N_x,self.N_x)),         # Fx_ini  
                np.zeros((self.N_x,self.N_y)),         # Fy_ini 
                np.zeros((self.N_y,self.N_x)),         # Gx_ini 
                np.zeros((self.N_y,self.N_y)),         # Fy_ini 
                np.zeros((self.N_store+1,1)),          # T
                np.zeros((self.N_store+1,self.N_x)),   # X
                np.zeros((self.N_store+1,self.N_y)),   # Y
                np.zeros((self.N_store+1,self.N_z)),   # Z
                np.zeros((self.N_store+1,1)),          # iters
                1,
                self.Fx_ini_rows,       
                self.Fx_ini_cols,
                self.Fy_ini_rows,       
                self.Fy_ini_cols,
                self.Gx_ini_rows,        
                self.Gx_ini_cols,
                self.Gy_ini_rows,       
                self.Gy_ini_cols,
                np.zeros((self.N_x+self.N_y,self.N_x+self.N_y)),  
                np.zeros((self.N_x+self.N_y,1)),
                ]  

        dt += [(item,np.float64) for item in self.params_list]
        values += [item for item in self.params_values_list]

        for item_id,item_val in zip(self.inputs_ini_list,self.inputs_ini_values_list):
            if item_id in self.inputs_run_list: continue
            dt += [(item_id,np.float64)]
            values += [item_val]

        dt += [(item,np.float64) for item in self.inputs_run_list]
        values += [item for item in self.inputs_run_values_list]

        self.struct = np.rec.array([tuple(values)], dtype=np.dtype(dt))
        
        xy0 = np.zeros((self.N_x+self.N_y,))
        self.ini_dae_jacobian_nn(xy0)
        self.run_dae_jacobian_nn(xy0)
        


    def load_params(self,data_input):

        if type(data_input) == str:
            json_file = data_input
            self.json_file = json_file
            self.json_data = open(json_file).read().replace("'",'"')
            data = json.loads(self.json_data)
        elif type(data_input) == dict:
            data = data_input

        self.data = data
        for item in self.data:
            self.struct[0][item] = self.data[item]
            if item in self.params_list:
                self.params_values_list[self.params_list.index(item)] = self.data[item]
            elif item in self.inputs_ini_list:
                self.inputs_ini_values_list[self.inputs_ini_list.index(item)] = self.data[item]
            elif item in self.inputs_run_list:
                self.inputs_run_values_list[self.inputs_run_list.index(item)] = self.data[item]
            else: 
                print(f'parameter or input {item} not found')

    def save_params(self,file_name = 'parameters.json'):
        params_dict = {}
        for item in self.params_list:
            params_dict.update({item:self.get_value(item)})

        params_dict_str = json.dumps(params_dict, indent=4)
        with open(file_name,'w') as fobj:
            fobj.write(params_dict_str)

    def save_inputs_ini(self,file_name = 'inputs_ini.json'):
        inputs_ini_dict = {}
        for item in self.inputs_ini_list:
            inputs_ini_dict.update({item:self.get_value(item)})

        inputs_ini_dict_str = json.dumps(inputs_ini_dict, indent=4)
        with open(file_name,'w') as fobj:
            fobj.write(inputs_ini_dict_str)

    def ini_problem(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_ini[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        if self.compile:
            ini(self.struct,2)
            ini(self.struct,3)       
        else:
            ini.py_func(self.struct,2)
            ini.py_func(self.struct,3)                   
        fg = np.vstack((self.struct[0].f,self.struct[0].g))[:,0]
        return fg

    def run_problem(self,x):
        t = self.struct[0].t
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_run[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        
        if self.compile:
            run(t,self.struct,2)
            run(t,self.struct,3)
            run(t,self.struct,10)
            run(t,self.struct,11)
            run(t,self.struct,12)
            run(t,self.struct,13)
        else:
            run.py_func(t,self.struct,2)
            run.py_func(t,self.struct,3)
            run.py_func(t,self.struct,10)
            run.py_func(t,self.struct,11)
            run.py_func(t,self.struct,12)
            run.py_func(t,self.struct,13)            
        
        fg = np.vstack((self.struct[0].f,self.struct[0].g))[:,0]
        return fg
    

    def run_dae_jacobian(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_run[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        run(0.0,self.struct,10)
        run(0.0,self.struct,11)     
        run(0.0,self.struct,12)
        run(0.0,self.struct,13)
        A_c = np.block([[self.struct[0].Fx,self.struct[0].Fy],
                        [self.struct[0].Gx,self.struct[0].Gy]])
        return A_c

    def run_dae_jacobian_nn(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_run[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        run_nn(0.0,self.struct,10)
        run_nn(0.0,self.struct,11)     
        run_nn(0.0,self.struct,12)
        run_nn(0.0,self.struct,13)
 

    
    def eval_jacobians(self):

        run(0.0,self.struct,10)
        run(0.0,self.struct,11)  
        run(0.0,self.struct,12) 

        return 1


    def ini_dae_jacobian(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_ini[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        if self.compile:
            ini(self.struct,10)
            ini(self.struct,11) 
        else:
            ini.py_func(self.struct,10)
            ini.py_func(self.struct,11)             
        A_c = np.block([[self.struct[0].Fx_ini,self.struct[0].Fy_ini],
                        [self.struct[0].Gx_ini,self.struct[0].Gy_ini]])
        return A_c

    def ini_dae_jacobian_nn(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_ini[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        ini_nn(self.struct,10)
        ini_nn(self.struct,11)       
 

    def f_ode(self,x):
        self.struct[0].x[:,0] = x
        run(self.struct,1)
        return self.struct[0].f[:,0]

    def f_odeint(self,x,t):
        self.struct[0].x[:,0] = x
        run(self.struct,1)
        return self.struct[0].f[:,0]

    def f_ivp(self,t,x):
        self.struct[0].x[:,0] = x
        run(self.struct,1)
        return self.struct[0].f[:,0]

    def Fx_ode(self,x):
        self.struct[0].x[:,0] = x
        run(self.struct,10)
        return self.struct[0].Fx

    def eval_A(self):
        
        Fx = self.struct[0].Fx
        Fy = self.struct[0].Fy
        Gx = self.struct[0].Gx
        Gy = self.struct[0].Gy
        
        A = Fx - Fy @ np.linalg.solve(Gy,Gx)
        
        self.A = A
        
        return A

    def eval_A_ini(self):
        
        Fx = self.struct[0].Fx_ini
        Fy = self.struct[0].Fy_ini
        Gx = self.struct[0].Gx_ini
        Gy = self.struct[0].Gy_ini
        
        A = Fx - Fy @ np.linalg.solve(Gy,Gx)
        
        
        return A
    
    def reset(self):
        for param,param_value in zip(self.params_list,self.params_values_list):
            self.struct[0][param] = param_value
        for input_name,input_value in zip(self.inputs_ini_list,self.inputs_ini_values_list):
            self.struct[0][input_name] = input_value   
        for input_name,input_value in zip(self.inputs_run_list,self.inputs_run_values_list):
            self.struct[0][input_name] = input_value  

    def simulate(self,events,xy0=0):
        
        # initialize both the ini and the run system
        self.initialize(events,xy0=xy0)
        
        # simulation run
        for event in events:  
            # make all the desired changes
            self.run([event]) 
            
        # post process
        T,X,Y,Z = self.post()
        
        return T,X,Y,Z
    

    
    def run(self,events):
        

        # simulation run
        for event in events:  
            # make all the desired changes
            for item in event:
                self.struct[0][item] = event[item]
            daesolver(self.struct)    # run until next event
            
        return 1
 
    def rtrun(self,events):
        

        # simulation run
        for event in events:  
            # make all the desired changes
            for item in event:
                self.struct[0][item] = event[item]
            self.struct[0].it_store = self.struct[0].N_store-1
            daesolver(self.struct)    # run until next event
            
            
        return 1
    
    def post(self):
        
        # post process result    
        T = self.struct[0]['T'][:self.struct[0].it_store]
        X = self.struct[0]['X'][:self.struct[0].it_store,:]
        Y = self.struct[0]['Y'][:self.struct[0].it_store,:]
        Z = self.struct[0]['Z'][:self.struct[0].it_store,:]
        iters = self.struct[0]['iters'][:self.struct[0].it_store,:]
    
        self.T = T
        self.X = X
        self.Y = Y
        self.Z = Z
        self.iters = iters
        
        return T,X,Y,Z
        
    def save_0(self,file_name = 'xy_0.json'):
        xy_0_dict = {}
        for item in self.x_list:
            xy_0_dict.update({item:self.get_value(item)})
        for item in self.y_ini_list:
            xy_0_dict.update({item:self.get_value(item)})
    
        xy_0_str = json.dumps(xy_0_dict, indent=4)
        with open(file_name,'w') as fobj:
            fobj.write(xy_0_str)

    def load_0(self,file_name = 'xy_0.json'):
        with open(file_name) as fobj:
            xy_0_str = fobj.read()
        xy_0_dict = json.loads(xy_0_str)
    
        for item in xy_0_dict:
            if item in self.x_list:
                self.xy_prev[self.x_list.index(item)] = xy_0_dict[item]
            if item in self.y_ini_list:
                self.xy_prev[self.y_ini_list.index(item)+self.N_x] = xy_0_dict[item]
                
            
    def initialize(self,events=[{}],xy0=0,compile=True):
        '''
        

        Parameters
        ----------
        events : dictionary 
            Dictionary with at least 't_end' and all inputs and parameters 
            that need to be changed.
        xy0 : float or string, optional
            0 means all states should be zero as initial guess. 
            If not zero all the states initial guess are the given input.
            If 'prev' it uses the last known initialization result as initial guess.

        Returns
        -------
        T : TYPE
            DESCRIPTION.
        X : TYPE
            DESCRIPTION.
        Y : TYPE
            DESCRIPTION.
        Z : TYPE
            DESCRIPTION.

        '''
        
        self.compile = compile
        
        # simulation parameters
        self.struct[0].it = 0       # set time step to zero
        self.struct[0].it_store = 0 # set storage to zero
        self.struct[0].t = 0.0      # set time to zero
                    
        # initialization
        it_event = 0
        event = events[it_event]
        for item in event:
            self.struct[0][item] = event[item]
            
        
        ## compute initial conditions using x and y_ini 
        if type(xy0) == str:
            if xy0 == 'prev':
                xy0 = self.xy_prev
            else:
                self.load_0(xy0)
                xy0 = self.xy_prev
        elif type(xy0) == dict:
            with open('xy_0.json','w') as fobj:
                fobj.write(json.dumps(xy0))
            self.load_0('xy_0.json')
            xy0 = self.xy_prev            
        else:
            if xy0 == 0:
                xy0 = np.zeros(self.N_x+self.N_y)
            elif xy0 == 1:
                xy0 = np.ones(self.N_x+self.N_y)
            else:
                xy0 = xy0*np.ones(self.N_x+self.N_y)

        #xy = sopt.fsolve(self.ini_problem,xy0, jac=self.ini_dae_jacobian )

        
        if self.sopt_root_jac:
            sol = sopt.root(self.ini_problem, xy0, 
                            jac=self.ini_dae_jacobian, 
                            method=self.sopt_root_method, tol=self.initialization_tol)
        else:
            sol = sopt.root(self.ini_problem, xy0, method=self.sopt_root_method)

        self.initialization_ok = True
        if sol.success == False:
            print('initialization not found!')
            self.initialization_ok = False

            T = self.struct[0]['T'][:self.struct[0].it_store]
            X = self.struct[0]['X'][:self.struct[0].it_store,:]
            Y = self.struct[0]['Y'][:self.struct[0].it_store,:]
            Z = self.struct[0]['Z'][:self.struct[0].it_store,:]
            iters = self.struct[0]['iters'][:self.struct[0].it_store,:]

        if self.initialization_ok:
            xy = sol.x
            self.xy_prev = xy
            self.struct[0].x[:,0] = xy[0:self.N_x]
            self.struct[0].y_run[:,0] = xy[self.N_x:]

            ## y_ini to u_run
            for item in self.inputs_run_list:
                if item in self.y_ini_list:
                    self.struct[0][item] = self.struct[0].y_ini[self.y_ini_list.index(item)]

            ## u_ini to y_run
            for item in self.inputs_ini_list:
                if item in self.y_run_list:
                    self.struct[0].y_run[self.y_run_list.index(item)] = self.struct[0][item]


            #xy = sopt.fsolve(self.ini_problem,xy0, jac=self.ini_dae_jacobian )
            if self.sopt_root_jac:
                sol = sopt.root(self.run_problem, xy0, 
                                jac=self.run_dae_jacobian, 
                                method=self.sopt_root_method, tol=self.initialization_tol)
            else:
                sol = sopt.root(self.run_problem, xy0, method=self.sopt_root_method)

            if self.compile:
                # evaluate f and g
                run(0.0,self.struct,2)
                run(0.0,self.struct,3)                
    
                # evaluate run jacobians 
                run(0.0,self.struct,10)
                run(0.0,self.struct,11)                
                run(0.0,self.struct,12) 
                run(0.0,self.struct,14) 
                
            else:
                # evaluate f and g
                run.py_func(0.0,self.struct,2)
                run.py_func(0.0,self.struct,3)                
    
                # evaluate run jacobians 
                run.py_func(0.0,self.struct,10)
                run.py_func(0.0,self.struct,11)                
                run.py_func(0.0,self.struct,12) 
                run.py_func(0.0,self.struct,14)                 
                
             
            # post process result    
            T = self.struct[0]['T'][:self.struct[0].it_store]
            X = self.struct[0]['X'][:self.struct[0].it_store,:]
            Y = self.struct[0]['Y'][:self.struct[0].it_store,:]
            Z = self.struct[0]['Z'][:self.struct[0].it_store,:]
            iters = self.struct[0]['iters'][:self.struct[0].it_store,:]
        
            self.T = T
            self.X = X
            self.Y = Y
            self.Z = Z
            self.iters = iters
            
        return self.initialization_ok
    
    
    def get_value(self,name):
        if name in self.inputs_run_list:
            value = self.struct[0][name]
        if name in self.x_list:
            idx = self.x_list.index(name)
            value = self.struct[0].x[idx,0]
        if name in self.y_run_list:
            idy = self.y_run_list.index(name)
            value = self.struct[0].y_run[idy,0]
        if name in self.params_list:
            value = self.struct[0][name]
        if name in self.outputs_list:
            value = self.struct[0].h[self.outputs_list.index(name),0] 

        return value
    
    def get_values(self,name):
        if name in self.x_list:
            values = self.X[:,self.x_list.index(name)]
        if name in self.y_run_list:
            values = self.Y[:,self.y_run_list.index(name)]
        if name in self.outputs_list:
            values = self.Z[:,self.outputs_list.index(name)]
                        
        return values

    def get_mvalue(self,names):
        '''

        Parameters
        ----------
        names : list
            list of variables names to return each value.

        Returns
        -------
        mvalue : TYPE
            list of value of each variable.

        '''
        mvalue = []
        for name in names:
            mvalue += [self.get_value(name)]
                        
        return mvalue
    
    def set_value(self,name_,value):
        if name_ in self.inputs_run_list:
            self.struct[0][name_] = value
            return
        elif name_ in self.params_list:
            self.struct[0][name_] = value
            return
        elif name_ in self.inputs_ini_list:
            self.struct[0][name_] = value
            return 
        else:
            print(f'Input or parameter {name_} not found.')

    def set_values(self,dictionary):
        
        for item in dictionary:
            self.set_value(item,dictionary[item])
            
            
    def report_x(self,value_format='5.2f', decimals=2):
        for item in self.x_list:
            print(f'{item:5s} = {self.get_value(item):5.{decimals}f}')

    def report_y(self,value_format='5.2f', decimals=2):
        for item in self.y_run_list:
            print(f'{item:5s} = {self.get_value(item):5.{decimals}f}')
            
    def report_u(self,value_format='5.2f', decimals=2):
        for item in self.inputs_run_list:
            print(f'{item:5s} = {self.get_value(item):5.{decimals}f}')

    def report_z(self,value_format='5.2f', decimals=2):
        for item in self.outputs_list:
            print(f'{item:5s} = {self.get_value(item):5.{decimals}f}')

    def report_params(self,value_format='5.2f', decimals=2):
        for item in self.params_list:
            print(f'{item:5s} = {self.get_value(item):5.{decimals}f}')
            
    def get_x(self):
        return self.struct[0].x
    
    def ss(self):
        
        ssate(self.struct,self.xy_prev.reshape(len(self.xy_prev),1))
        
        ## y_ini to y_run
        self.struct[0].y_run = self.struct[0].y_ini
        
        ## y_ini to u_run
        for item in self.yini2urun:
            self.struct[0][item] = self.struct[0].y_ini[self.y_ini_list.index(item)]
                
        ## u_ini to y_run
        for item in self.uini2yrun:
            self.struct[0].y_run[self.y_run_list.index(item)] = self.struct[0][item]






@numba.njit(cache=True)
def ini(struct,mode):

    # Parameters:
    a_R1 = struct[0].a_R1
    b_R1 = struct[0].b_R1
    c_R1 = struct[0].c_R1
    a_R10 = struct[0].a_R10
    b_R10 = struct[0].b_R10
    c_R10 = struct[0].c_R10
    coef_a_R10 = struct[0].coef_a_R10
    coef_b_R10 = struct[0].coef_b_R10
    coef_c_R10 = struct[0].coef_c_R10
    a_R14 = struct[0].a_R14
    b_R14 = struct[0].b_R14
    c_R14 = struct[0].c_R14
    coef_a_R14 = struct[0].coef_a_R14
    coef_b_R14 = struct[0].coef_b_R14
    coef_c_R14 = struct[0].coef_c_R14
    
    # Inputs:
    v_R0_a_r = struct[0].v_R0_a_r
    v_R0_a_i = struct[0].v_R0_a_i
    v_R0_b_r = struct[0].v_R0_b_r
    v_R0_b_i = struct[0].v_R0_b_i
    v_R0_c_r = struct[0].v_R0_c_r
    v_R0_c_i = struct[0].v_R0_c_i
    v_D1_a_r = struct[0].v_D1_a_r
    v_D1_a_i = struct[0].v_D1_a_i
    v_D1_b_r = struct[0].v_D1_b_r
    v_D1_b_i = struct[0].v_D1_b_i
    v_D1_c_r = struct[0].v_D1_c_r
    v_D1_c_i = struct[0].v_D1_c_i
    i_R1_n_r = struct[0].i_R1_n_r
    i_R1_n_i = struct[0].i_R1_n_i
    i_R11_n_r = struct[0].i_R11_n_r
    i_R11_n_i = struct[0].i_R11_n_i
    i_R15_n_r = struct[0].i_R15_n_r
    i_R15_n_i = struct[0].i_R15_n_i
    i_R16_n_r = struct[0].i_R16_n_r
    i_R16_n_i = struct[0].i_R16_n_i
    i_R17_n_r = struct[0].i_R17_n_r
    i_R17_n_i = struct[0].i_R17_n_i
    i_R18_n_r = struct[0].i_R18_n_r
    i_R18_n_i = struct[0].i_R18_n_i
    i_R2_a_r = struct[0].i_R2_a_r
    i_R2_a_i = struct[0].i_R2_a_i
    i_R2_b_r = struct[0].i_R2_b_r
    i_R2_b_i = struct[0].i_R2_b_i
    i_R2_c_r = struct[0].i_R2_c_r
    i_R2_c_i = struct[0].i_R2_c_i
    i_R2_n_r = struct[0].i_R2_n_r
    i_R2_n_i = struct[0].i_R2_n_i
    i_R3_a_r = struct[0].i_R3_a_r
    i_R3_a_i = struct[0].i_R3_a_i
    i_R3_b_r = struct[0].i_R3_b_r
    i_R3_b_i = struct[0].i_R3_b_i
    i_R3_c_r = struct[0].i_R3_c_r
    i_R3_c_i = struct[0].i_R3_c_i
    i_R3_n_r = struct[0].i_R3_n_r
    i_R3_n_i = struct[0].i_R3_n_i
    i_R4_a_r = struct[0].i_R4_a_r
    i_R4_a_i = struct[0].i_R4_a_i
    i_R4_b_r = struct[0].i_R4_b_r
    i_R4_b_i = struct[0].i_R4_b_i
    i_R4_c_r = struct[0].i_R4_c_r
    i_R4_c_i = struct[0].i_R4_c_i
    i_R4_n_r = struct[0].i_R4_n_r
    i_R4_n_i = struct[0].i_R4_n_i
    i_R5_a_r = struct[0].i_R5_a_r
    i_R5_a_i = struct[0].i_R5_a_i
    i_R5_b_r = struct[0].i_R5_b_r
    i_R5_b_i = struct[0].i_R5_b_i
    i_R5_c_r = struct[0].i_R5_c_r
    i_R5_c_i = struct[0].i_R5_c_i
    i_R5_n_r = struct[0].i_R5_n_r
    i_R5_n_i = struct[0].i_R5_n_i
    i_R6_a_r = struct[0].i_R6_a_r
    i_R6_a_i = struct[0].i_R6_a_i
    i_R6_b_r = struct[0].i_R6_b_r
    i_R6_b_i = struct[0].i_R6_b_i
    i_R6_c_r = struct[0].i_R6_c_r
    i_R6_c_i = struct[0].i_R6_c_i
    i_R6_n_r = struct[0].i_R6_n_r
    i_R6_n_i = struct[0].i_R6_n_i
    i_R7_a_r = struct[0].i_R7_a_r
    i_R7_a_i = struct[0].i_R7_a_i
    i_R7_b_r = struct[0].i_R7_b_r
    i_R7_b_i = struct[0].i_R7_b_i
    i_R7_c_r = struct[0].i_R7_c_r
    i_R7_c_i = struct[0].i_R7_c_i
    i_R7_n_r = struct[0].i_R7_n_r
    i_R7_n_i = struct[0].i_R7_n_i
    i_R8_a_r = struct[0].i_R8_a_r
    i_R8_a_i = struct[0].i_R8_a_i
    i_R8_b_r = struct[0].i_R8_b_r
    i_R8_b_i = struct[0].i_R8_b_i
    i_R8_c_r = struct[0].i_R8_c_r
    i_R8_c_i = struct[0].i_R8_c_i
    i_R8_n_r = struct[0].i_R8_n_r
    i_R8_n_i = struct[0].i_R8_n_i
    i_R9_a_r = struct[0].i_R9_a_r
    i_R9_a_i = struct[0].i_R9_a_i
    i_R9_b_r = struct[0].i_R9_b_r
    i_R9_b_i = struct[0].i_R9_b_i
    i_R9_c_r = struct[0].i_R9_c_r
    i_R9_c_i = struct[0].i_R9_c_i
    i_R9_n_r = struct[0].i_R9_n_r
    i_R9_n_i = struct[0].i_R9_n_i
    i_R10_a_r = struct[0].i_R10_a_r
    i_R10_a_i = struct[0].i_R10_a_i
    i_R10_b_r = struct[0].i_R10_b_r
    i_R10_b_i = struct[0].i_R10_b_i
    i_R10_c_r = struct[0].i_R10_c_r
    i_R10_c_i = struct[0].i_R10_c_i
    i_R10_n_r = struct[0].i_R10_n_r
    i_R10_n_i = struct[0].i_R10_n_i
    i_R12_a_r = struct[0].i_R12_a_r
    i_R12_a_i = struct[0].i_R12_a_i
    i_R12_b_r = struct[0].i_R12_b_r
    i_R12_b_i = struct[0].i_R12_b_i
    i_R12_c_r = struct[0].i_R12_c_r
    i_R12_c_i = struct[0].i_R12_c_i
    i_R12_n_r = struct[0].i_R12_n_r
    i_R12_n_i = struct[0].i_R12_n_i
    i_R13_a_r = struct[0].i_R13_a_r
    i_R13_a_i = struct[0].i_R13_a_i
    i_R13_b_r = struct[0].i_R13_b_r
    i_R13_b_i = struct[0].i_R13_b_i
    i_R13_c_r = struct[0].i_R13_c_r
    i_R13_c_i = struct[0].i_R13_c_i
    i_R13_n_r = struct[0].i_R13_n_r
    i_R13_n_i = struct[0].i_R13_n_i
    i_R14_a_r = struct[0].i_R14_a_r
    i_R14_a_i = struct[0].i_R14_a_i
    i_R14_b_r = struct[0].i_R14_b_r
    i_R14_b_i = struct[0].i_R14_b_i
    i_R14_c_r = struct[0].i_R14_c_r
    i_R14_c_i = struct[0].i_R14_c_i
    i_R14_n_r = struct[0].i_R14_n_r
    i_R14_n_i = struct[0].i_R14_n_i
    i_D1_n_r = struct[0].i_D1_n_r
    i_D1_n_i = struct[0].i_D1_n_i
    i_D3_a_r = struct[0].i_D3_a_r
    i_D3_a_i = struct[0].i_D3_a_i
    i_D3_b_r = struct[0].i_D3_b_r
    i_D3_b_i = struct[0].i_D3_b_i
    i_D3_c_r = struct[0].i_D3_c_r
    i_D3_c_i = struct[0].i_D3_c_i
    i_D3_n_r = struct[0].i_D3_n_r
    i_D3_n_i = struct[0].i_D3_n_i
    i_D4_a_r = struct[0].i_D4_a_r
    i_D4_a_i = struct[0].i_D4_a_i
    i_D4_b_r = struct[0].i_D4_b_r
    i_D4_b_i = struct[0].i_D4_b_i
    i_D4_c_r = struct[0].i_D4_c_r
    i_D4_c_i = struct[0].i_D4_c_i
    i_D4_n_r = struct[0].i_D4_n_r
    i_D4_n_i = struct[0].i_D4_n_i
    i_D6_a_r = struct[0].i_D6_a_r
    i_D6_a_i = struct[0].i_D6_a_i
    i_D6_b_r = struct[0].i_D6_b_r
    i_D6_b_i = struct[0].i_D6_b_i
    i_D6_c_r = struct[0].i_D6_c_r
    i_D6_c_i = struct[0].i_D6_c_i
    i_D6_n_r = struct[0].i_D6_n_r
    i_D6_n_i = struct[0].i_D6_n_i
    i_D9_a_r = struct[0].i_D9_a_r
    i_D9_a_i = struct[0].i_D9_a_i
    i_D9_b_r = struct[0].i_D9_b_r
    i_D9_b_i = struct[0].i_D9_b_i
    i_D9_c_r = struct[0].i_D9_c_r
    i_D9_c_i = struct[0].i_D9_c_i
    i_D9_n_r = struct[0].i_D9_n_r
    i_D9_n_i = struct[0].i_D9_n_i
    i_D10_a_i = struct[0].i_D10_a_i
    i_D10_b_r = struct[0].i_D10_b_r
    i_D10_b_i = struct[0].i_D10_b_i
    i_D10_c_r = struct[0].i_D10_c_r
    i_D10_c_i = struct[0].i_D10_c_i
    i_D10_n_i = struct[0].i_D10_n_i
    i_D11_b_r = struct[0].i_D11_b_r
    i_D11_b_i = struct[0].i_D11_b_i
    i_D11_c_r = struct[0].i_D11_c_r
    i_D11_c_i = struct[0].i_D11_c_i
    i_D16_b_r = struct[0].i_D16_b_r
    i_D16_b_i = struct[0].i_D16_b_i
    i_D16_c_r = struct[0].i_D16_c_r
    i_D16_c_i = struct[0].i_D16_c_i
    i_D17_b_r = struct[0].i_D17_b_r
    i_D17_b_i = struct[0].i_D17_b_i
    i_D17_c_r = struct[0].i_D17_c_r
    i_D17_c_i = struct[0].i_D17_c_i
    i_D18_b_r = struct[0].i_D18_b_r
    i_D18_b_i = struct[0].i_D18_b_i
    i_D18_c_r = struct[0].i_D18_c_r
    i_D18_c_i = struct[0].i_D18_c_i
    i_D14_a_i = struct[0].i_D14_a_i
    i_D14_b_r = struct[0].i_D14_b_r
    i_D14_b_i = struct[0].i_D14_b_i
    i_D14_c_r = struct[0].i_D14_c_r
    i_D14_c_i = struct[0].i_D14_c_i
    i_D14_n_i = struct[0].i_D14_n_i
    i_D15_b_r = struct[0].i_D15_b_r
    i_D15_b_i = struct[0].i_D15_b_i
    i_D15_c_r = struct[0].i_D15_c_r
    i_D15_c_i = struct[0].i_D15_c_i
    p_R1_a = struct[0].p_R1_a
    q_R1_a = struct[0].q_R1_a
    p_R1_b = struct[0].p_R1_b
    q_R1_b = struct[0].q_R1_b
    p_R1_c = struct[0].p_R1_c
    q_R1_c = struct[0].q_R1_c
    p_R11_a = struct[0].p_R11_a
    q_R11_a = struct[0].q_R11_a
    p_R11_b = struct[0].p_R11_b
    q_R11_b = struct[0].q_R11_b
    p_R11_c = struct[0].p_R11_c
    q_R11_c = struct[0].q_R11_c
    p_R15_a = struct[0].p_R15_a
    q_R15_a = struct[0].q_R15_a
    p_R15_b = struct[0].p_R15_b
    q_R15_b = struct[0].q_R15_b
    p_R15_c = struct[0].p_R15_c
    q_R15_c = struct[0].q_R15_c
    p_R16_a = struct[0].p_R16_a
    q_R16_a = struct[0].q_R16_a
    p_R16_b = struct[0].p_R16_b
    q_R16_b = struct[0].q_R16_b
    p_R16_c = struct[0].p_R16_c
    q_R16_c = struct[0].q_R16_c
    p_R17_a = struct[0].p_R17_a
    q_R17_a = struct[0].q_R17_a
    p_R17_b = struct[0].p_R17_b
    q_R17_b = struct[0].q_R17_b
    p_R17_c = struct[0].p_R17_c
    q_R17_c = struct[0].q_R17_c
    p_R18_a = struct[0].p_R18_a
    q_R18_a = struct[0].q_R18_a
    p_R18_b = struct[0].p_R18_b
    q_R18_b = struct[0].q_R18_b
    p_R18_c = struct[0].p_R18_c
    q_R18_c = struct[0].q_R18_c
    p_D15_1 = struct[0].p_D15_1
    q_D15_1 = struct[0].q_D15_1
    p_D11_1 = struct[0].p_D11_1
    q_D11_1 = struct[0].q_D11_1
    p_D16_1 = struct[0].p_D16_1
    q_D16_1 = struct[0].q_D16_1
    p_D17_1 = struct[0].p_D17_1
    q_D17_1 = struct[0].q_D17_1
    p_D18_1 = struct[0].p_D18_1
    q_D18_1 = struct[0].q_D18_1
    v_dc_D1 = struct[0].v_dc_D1
    q_R1 = struct[0].q_R1
    p_R10 = struct[0].p_R10
    q_R10 = struct[0].q_R10
    p_R14 = struct[0].p_R14
    q_R14 = struct[0].q_R14
    u_dummy = struct[0].u_dummy
    
    # Dynamical states:
    x_dummy = struct[0].x[0,0]
    
    # Algebraic states:
    v_R1_a_r = struct[0].y_ini[0,0]
    v_R1_a_i = struct[0].y_ini[1,0]
    v_R1_b_r = struct[0].y_ini[2,0]
    v_R1_b_i = struct[0].y_ini[3,0]
    v_R1_c_r = struct[0].y_ini[4,0]
    v_R1_c_i = struct[0].y_ini[5,0]
    v_R1_n_r = struct[0].y_ini[6,0]
    v_R1_n_i = struct[0].y_ini[7,0]
    v_R11_a_r = struct[0].y_ini[8,0]
    v_R11_a_i = struct[0].y_ini[9,0]
    v_R11_b_r = struct[0].y_ini[10,0]
    v_R11_b_i = struct[0].y_ini[11,0]
    v_R11_c_r = struct[0].y_ini[12,0]
    v_R11_c_i = struct[0].y_ini[13,0]
    v_R11_n_r = struct[0].y_ini[14,0]
    v_R11_n_i = struct[0].y_ini[15,0]
    v_R15_a_r = struct[0].y_ini[16,0]
    v_R15_a_i = struct[0].y_ini[17,0]
    v_R15_b_r = struct[0].y_ini[18,0]
    v_R15_b_i = struct[0].y_ini[19,0]
    v_R15_c_r = struct[0].y_ini[20,0]
    v_R15_c_i = struct[0].y_ini[21,0]
    v_R15_n_r = struct[0].y_ini[22,0]
    v_R15_n_i = struct[0].y_ini[23,0]
    v_R16_a_r = struct[0].y_ini[24,0]
    v_R16_a_i = struct[0].y_ini[25,0]
    v_R16_b_r = struct[0].y_ini[26,0]
    v_R16_b_i = struct[0].y_ini[27,0]
    v_R16_c_r = struct[0].y_ini[28,0]
    v_R16_c_i = struct[0].y_ini[29,0]
    v_R16_n_r = struct[0].y_ini[30,0]
    v_R16_n_i = struct[0].y_ini[31,0]
    v_R17_a_r = struct[0].y_ini[32,0]
    v_R17_a_i = struct[0].y_ini[33,0]
    v_R17_b_r = struct[0].y_ini[34,0]
    v_R17_b_i = struct[0].y_ini[35,0]
    v_R17_c_r = struct[0].y_ini[36,0]
    v_R17_c_i = struct[0].y_ini[37,0]
    v_R17_n_r = struct[0].y_ini[38,0]
    v_R17_n_i = struct[0].y_ini[39,0]
    v_R18_a_r = struct[0].y_ini[40,0]
    v_R18_a_i = struct[0].y_ini[41,0]
    v_R18_b_r = struct[0].y_ini[42,0]
    v_R18_b_i = struct[0].y_ini[43,0]
    v_R18_c_r = struct[0].y_ini[44,0]
    v_R18_c_i = struct[0].y_ini[45,0]
    v_R18_n_r = struct[0].y_ini[46,0]
    v_R18_n_i = struct[0].y_ini[47,0]
    v_D15_a_r = struct[0].y_ini[48,0]
    v_D15_a_i = struct[0].y_ini[49,0]
    v_D15_n_r = struct[0].y_ini[50,0]
    v_D15_n_i = struct[0].y_ini[51,0]
    v_D11_a_r = struct[0].y_ini[52,0]
    v_D11_a_i = struct[0].y_ini[53,0]
    v_D11_n_r = struct[0].y_ini[54,0]
    v_D11_n_i = struct[0].y_ini[55,0]
    v_D16_a_r = struct[0].y_ini[56,0]
    v_D16_a_i = struct[0].y_ini[57,0]
    v_D16_n_r = struct[0].y_ini[58,0]
    v_D16_n_i = struct[0].y_ini[59,0]
    v_D17_a_r = struct[0].y_ini[60,0]
    v_D17_a_i = struct[0].y_ini[61,0]
    v_D17_n_r = struct[0].y_ini[62,0]
    v_D17_n_i = struct[0].y_ini[63,0]
    v_D18_a_r = struct[0].y_ini[64,0]
    v_D18_a_i = struct[0].y_ini[65,0]
    v_D18_n_r = struct[0].y_ini[66,0]
    v_D18_n_i = struct[0].y_ini[67,0]
    v_R2_a_r = struct[0].y_ini[68,0]
    v_R2_a_i = struct[0].y_ini[69,0]
    v_R2_b_r = struct[0].y_ini[70,0]
    v_R2_b_i = struct[0].y_ini[71,0]
    v_R2_c_r = struct[0].y_ini[72,0]
    v_R2_c_i = struct[0].y_ini[73,0]
    v_R2_n_r = struct[0].y_ini[74,0]
    v_R2_n_i = struct[0].y_ini[75,0]
    v_R3_a_r = struct[0].y_ini[76,0]
    v_R3_a_i = struct[0].y_ini[77,0]
    v_R3_b_r = struct[0].y_ini[78,0]
    v_R3_b_i = struct[0].y_ini[79,0]
    v_R3_c_r = struct[0].y_ini[80,0]
    v_R3_c_i = struct[0].y_ini[81,0]
    v_R3_n_r = struct[0].y_ini[82,0]
    v_R3_n_i = struct[0].y_ini[83,0]
    v_R4_a_r = struct[0].y_ini[84,0]
    v_R4_a_i = struct[0].y_ini[85,0]
    v_R4_b_r = struct[0].y_ini[86,0]
    v_R4_b_i = struct[0].y_ini[87,0]
    v_R4_c_r = struct[0].y_ini[88,0]
    v_R4_c_i = struct[0].y_ini[89,0]
    v_R4_n_r = struct[0].y_ini[90,0]
    v_R4_n_i = struct[0].y_ini[91,0]
    v_R5_a_r = struct[0].y_ini[92,0]
    v_R5_a_i = struct[0].y_ini[93,0]
    v_R5_b_r = struct[0].y_ini[94,0]
    v_R5_b_i = struct[0].y_ini[95,0]
    v_R5_c_r = struct[0].y_ini[96,0]
    v_R5_c_i = struct[0].y_ini[97,0]
    v_R5_n_r = struct[0].y_ini[98,0]
    v_R5_n_i = struct[0].y_ini[99,0]
    v_R6_a_r = struct[0].y_ini[100,0]
    v_R6_a_i = struct[0].y_ini[101,0]
    v_R6_b_r = struct[0].y_ini[102,0]
    v_R6_b_i = struct[0].y_ini[103,0]
    v_R6_c_r = struct[0].y_ini[104,0]
    v_R6_c_i = struct[0].y_ini[105,0]
    v_R6_n_r = struct[0].y_ini[106,0]
    v_R6_n_i = struct[0].y_ini[107,0]
    v_R7_a_r = struct[0].y_ini[108,0]
    v_R7_a_i = struct[0].y_ini[109,0]
    v_R7_b_r = struct[0].y_ini[110,0]
    v_R7_b_i = struct[0].y_ini[111,0]
    v_R7_c_r = struct[0].y_ini[112,0]
    v_R7_c_i = struct[0].y_ini[113,0]
    v_R7_n_r = struct[0].y_ini[114,0]
    v_R7_n_i = struct[0].y_ini[115,0]
    v_R8_a_r = struct[0].y_ini[116,0]
    v_R8_a_i = struct[0].y_ini[117,0]
    v_R8_b_r = struct[0].y_ini[118,0]
    v_R8_b_i = struct[0].y_ini[119,0]
    v_R8_c_r = struct[0].y_ini[120,0]
    v_R8_c_i = struct[0].y_ini[121,0]
    v_R8_n_r = struct[0].y_ini[122,0]
    v_R8_n_i = struct[0].y_ini[123,0]
    v_R9_a_r = struct[0].y_ini[124,0]
    v_R9_a_i = struct[0].y_ini[125,0]
    v_R9_b_r = struct[0].y_ini[126,0]
    v_R9_b_i = struct[0].y_ini[127,0]
    v_R9_c_r = struct[0].y_ini[128,0]
    v_R9_c_i = struct[0].y_ini[129,0]
    v_R9_n_r = struct[0].y_ini[130,0]
    v_R9_n_i = struct[0].y_ini[131,0]
    v_R10_a_r = struct[0].y_ini[132,0]
    v_R10_a_i = struct[0].y_ini[133,0]
    v_R10_b_r = struct[0].y_ini[134,0]
    v_R10_b_i = struct[0].y_ini[135,0]
    v_R10_c_r = struct[0].y_ini[136,0]
    v_R10_c_i = struct[0].y_ini[137,0]
    v_R10_n_r = struct[0].y_ini[138,0]
    v_R10_n_i = struct[0].y_ini[139,0]
    v_R12_a_r = struct[0].y_ini[140,0]
    v_R12_a_i = struct[0].y_ini[141,0]
    v_R12_b_r = struct[0].y_ini[142,0]
    v_R12_b_i = struct[0].y_ini[143,0]
    v_R12_c_r = struct[0].y_ini[144,0]
    v_R12_c_i = struct[0].y_ini[145,0]
    v_R12_n_r = struct[0].y_ini[146,0]
    v_R12_n_i = struct[0].y_ini[147,0]
    v_R13_a_r = struct[0].y_ini[148,0]
    v_R13_a_i = struct[0].y_ini[149,0]
    v_R13_b_r = struct[0].y_ini[150,0]
    v_R13_b_i = struct[0].y_ini[151,0]
    v_R13_c_r = struct[0].y_ini[152,0]
    v_R13_c_i = struct[0].y_ini[153,0]
    v_R13_n_r = struct[0].y_ini[154,0]
    v_R13_n_i = struct[0].y_ini[155,0]
    v_R14_a_r = struct[0].y_ini[156,0]
    v_R14_a_i = struct[0].y_ini[157,0]
    v_R14_b_r = struct[0].y_ini[158,0]
    v_R14_b_i = struct[0].y_ini[159,0]
    v_R14_c_r = struct[0].y_ini[160,0]
    v_R14_c_i = struct[0].y_ini[161,0]
    v_R14_n_r = struct[0].y_ini[162,0]
    v_R14_n_i = struct[0].y_ini[163,0]
    v_D1_n_r = struct[0].y_ini[164,0]
    v_D1_n_i = struct[0].y_ini[165,0]
    v_D3_a_r = struct[0].y_ini[166,0]
    v_D3_a_i = struct[0].y_ini[167,0]
    v_D3_b_r = struct[0].y_ini[168,0]
    v_D3_b_i = struct[0].y_ini[169,0]
    v_D3_c_r = struct[0].y_ini[170,0]
    v_D3_c_i = struct[0].y_ini[171,0]
    v_D3_n_r = struct[0].y_ini[172,0]
    v_D3_n_i = struct[0].y_ini[173,0]
    v_D4_a_r = struct[0].y_ini[174,0]
    v_D4_a_i = struct[0].y_ini[175,0]
    v_D4_b_r = struct[0].y_ini[176,0]
    v_D4_b_i = struct[0].y_ini[177,0]
    v_D4_c_r = struct[0].y_ini[178,0]
    v_D4_c_i = struct[0].y_ini[179,0]
    v_D4_n_r = struct[0].y_ini[180,0]
    v_D4_n_i = struct[0].y_ini[181,0]
    v_D6_a_r = struct[0].y_ini[182,0]
    v_D6_a_i = struct[0].y_ini[183,0]
    v_D6_b_r = struct[0].y_ini[184,0]
    v_D6_b_i = struct[0].y_ini[185,0]
    v_D6_c_r = struct[0].y_ini[186,0]
    v_D6_c_i = struct[0].y_ini[187,0]
    v_D6_n_r = struct[0].y_ini[188,0]
    v_D6_n_i = struct[0].y_ini[189,0]
    v_D9_a_r = struct[0].y_ini[190,0]
    v_D9_a_i = struct[0].y_ini[191,0]
    v_D9_b_r = struct[0].y_ini[192,0]
    v_D9_b_i = struct[0].y_ini[193,0]
    v_D9_c_r = struct[0].y_ini[194,0]
    v_D9_c_i = struct[0].y_ini[195,0]
    v_D9_n_r = struct[0].y_ini[196,0]
    v_D9_n_i = struct[0].y_ini[197,0]
    v_D10_a_r = struct[0].y_ini[198,0]
    v_D10_a_i = struct[0].y_ini[199,0]
    v_D10_b_r = struct[0].y_ini[200,0]
    v_D10_b_i = struct[0].y_ini[201,0]
    v_D10_c_r = struct[0].y_ini[202,0]
    v_D10_c_i = struct[0].y_ini[203,0]
    v_D10_n_r = struct[0].y_ini[204,0]
    v_D10_n_i = struct[0].y_ini[205,0]
    v_D11_b_r = struct[0].y_ini[206,0]
    v_D11_b_i = struct[0].y_ini[207,0]
    v_D11_c_r = struct[0].y_ini[208,0]
    v_D11_c_i = struct[0].y_ini[209,0]
    v_D16_b_r = struct[0].y_ini[210,0]
    v_D16_b_i = struct[0].y_ini[211,0]
    v_D16_c_r = struct[0].y_ini[212,0]
    v_D16_c_i = struct[0].y_ini[213,0]
    v_D17_b_r = struct[0].y_ini[214,0]
    v_D17_b_i = struct[0].y_ini[215,0]
    v_D17_c_r = struct[0].y_ini[216,0]
    v_D17_c_i = struct[0].y_ini[217,0]
    v_D18_b_r = struct[0].y_ini[218,0]
    v_D18_b_i = struct[0].y_ini[219,0]
    v_D18_c_r = struct[0].y_ini[220,0]
    v_D18_c_i = struct[0].y_ini[221,0]
    v_D14_a_r = struct[0].y_ini[222,0]
    v_D14_a_i = struct[0].y_ini[223,0]
    v_D14_b_r = struct[0].y_ini[224,0]
    v_D14_b_i = struct[0].y_ini[225,0]
    v_D14_c_r = struct[0].y_ini[226,0]
    v_D14_c_i = struct[0].y_ini[227,0]
    v_D14_n_r = struct[0].y_ini[228,0]
    v_D14_n_i = struct[0].y_ini[229,0]
    v_D15_b_r = struct[0].y_ini[230,0]
    v_D15_b_i = struct[0].y_ini[231,0]
    v_D15_c_r = struct[0].y_ini[232,0]
    v_D15_c_i = struct[0].y_ini[233,0]
    i_t_R0_R1_a_r = struct[0].y_ini[234,0]
    i_t_R0_R1_a_i = struct[0].y_ini[235,0]
    i_t_R0_R1_b_r = struct[0].y_ini[236,0]
    i_t_R0_R1_b_i = struct[0].y_ini[237,0]
    i_t_R0_R1_c_r = struct[0].y_ini[238,0]
    i_t_R0_R1_c_i = struct[0].y_ini[239,0]
    i_l_R1_R2_a_r = struct[0].y_ini[240,0]
    i_l_R1_R2_a_i = struct[0].y_ini[241,0]
    i_l_R1_R2_b_r = struct[0].y_ini[242,0]
    i_l_R1_R2_b_i = struct[0].y_ini[243,0]
    i_l_R1_R2_c_r = struct[0].y_ini[244,0]
    i_l_R1_R2_c_i = struct[0].y_ini[245,0]
    i_l_R1_R2_n_r = struct[0].y_ini[246,0]
    i_l_R1_R2_n_i = struct[0].y_ini[247,0]
    i_l_D1_D3_a_r = struct[0].y_ini[248,0]
    i_l_D1_D3_a_i = struct[0].y_ini[249,0]
    i_l_D1_D3_b_r = struct[0].y_ini[250,0]
    i_l_D1_D3_b_i = struct[0].y_ini[251,0]
    i_l_D1_D3_c_r = struct[0].y_ini[252,0]
    i_l_D1_D3_c_i = struct[0].y_ini[253,0]
    i_l_D1_D3_n_r = struct[0].y_ini[254,0]
    i_l_D1_D3_n_i = struct[0].y_ini[255,0]
    i_l_D3_D4_a_r = struct[0].y_ini[256,0]
    i_l_D3_D4_a_i = struct[0].y_ini[257,0]
    i_l_D3_D4_b_r = struct[0].y_ini[258,0]
    i_l_D3_D4_b_i = struct[0].y_ini[259,0]
    i_l_D3_D4_c_r = struct[0].y_ini[260,0]
    i_l_D3_D4_c_i = struct[0].y_ini[261,0]
    i_l_D3_D4_n_r = struct[0].y_ini[262,0]
    i_l_D3_D4_n_i = struct[0].y_ini[263,0]
    i_l_D4_D6_a_r = struct[0].y_ini[264,0]
    i_l_D4_D6_a_i = struct[0].y_ini[265,0]
    i_l_D4_D6_b_r = struct[0].y_ini[266,0]
    i_l_D4_D6_b_i = struct[0].y_ini[267,0]
    i_l_D4_D6_c_r = struct[0].y_ini[268,0]
    i_l_D4_D6_c_i = struct[0].y_ini[269,0]
    i_l_D4_D6_n_r = struct[0].y_ini[270,0]
    i_l_D4_D6_n_i = struct[0].y_ini[271,0]
    i_l_D6_D9_a_r = struct[0].y_ini[272,0]
    i_l_D6_D9_a_i = struct[0].y_ini[273,0]
    i_l_D6_D9_b_r = struct[0].y_ini[274,0]
    i_l_D6_D9_b_i = struct[0].y_ini[275,0]
    i_l_D6_D9_c_r = struct[0].y_ini[276,0]
    i_l_D6_D9_c_i = struct[0].y_ini[277,0]
    i_l_D6_D9_n_r = struct[0].y_ini[278,0]
    i_l_D6_D9_n_i = struct[0].y_ini[279,0]
    i_l_D9_D10_a_r = struct[0].y_ini[280,0]
    i_l_D9_D10_a_i = struct[0].y_ini[281,0]
    i_l_D9_D10_b_r = struct[0].y_ini[282,0]
    i_l_D9_D10_b_i = struct[0].y_ini[283,0]
    i_l_D9_D10_c_r = struct[0].y_ini[284,0]
    i_l_D9_D10_c_i = struct[0].y_ini[285,0]
    i_l_D9_D10_n_r = struct[0].y_ini[286,0]
    i_l_D9_D10_n_i = struct[0].y_ini[287,0]
    i_l_D3_D11_a_r = struct[0].y_ini[288,0]
    i_l_D3_D11_a_i = struct[0].y_ini[289,0]
    i_l_D3_D11_b_r = struct[0].y_ini[290,0]
    i_l_D3_D11_b_i = struct[0].y_ini[291,0]
    i_l_D3_D11_c_r = struct[0].y_ini[292,0]
    i_l_D3_D11_c_i = struct[0].y_ini[293,0]
    i_l_D3_D11_n_r = struct[0].y_ini[294,0]
    i_l_D3_D11_n_i = struct[0].y_ini[295,0]
    i_l_D6_D16_a_r = struct[0].y_ini[296,0]
    i_l_D6_D16_a_i = struct[0].y_ini[297,0]
    i_l_D6_D16_b_r = struct[0].y_ini[298,0]
    i_l_D6_D16_b_i = struct[0].y_ini[299,0]
    i_l_D6_D16_c_r = struct[0].y_ini[300,0]
    i_l_D6_D16_c_i = struct[0].y_ini[301,0]
    i_l_D6_D16_n_r = struct[0].y_ini[302,0]
    i_l_D6_D16_n_i = struct[0].y_ini[303,0]
    i_l_D9_D17_a_r = struct[0].y_ini[304,0]
    i_l_D9_D17_a_i = struct[0].y_ini[305,0]
    i_l_D9_D17_b_r = struct[0].y_ini[306,0]
    i_l_D9_D17_b_i = struct[0].y_ini[307,0]
    i_l_D9_D17_c_r = struct[0].y_ini[308,0]
    i_l_D9_D17_c_i = struct[0].y_ini[309,0]
    i_l_D9_D17_n_r = struct[0].y_ini[310,0]
    i_l_D9_D17_n_i = struct[0].y_ini[311,0]
    i_l_D10_D18_a_r = struct[0].y_ini[312,0]
    i_l_D10_D18_a_i = struct[0].y_ini[313,0]
    i_l_D10_D18_b_r = struct[0].y_ini[314,0]
    i_l_D10_D18_b_i = struct[0].y_ini[315,0]
    i_l_D10_D18_c_r = struct[0].y_ini[316,0]
    i_l_D10_D18_c_i = struct[0].y_ini[317,0]
    i_l_D10_D18_n_r = struct[0].y_ini[318,0]
    i_l_D10_D18_n_i = struct[0].y_ini[319,0]
    i_l_D4_D14_a_r = struct[0].y_ini[320,0]
    i_l_D4_D14_a_i = struct[0].y_ini[321,0]
    i_l_D4_D14_b_r = struct[0].y_ini[322,0]
    i_l_D4_D14_b_i = struct[0].y_ini[323,0]
    i_l_D4_D14_c_r = struct[0].y_ini[324,0]
    i_l_D4_D14_c_i = struct[0].y_ini[325,0]
    i_l_D4_D14_n_r = struct[0].y_ini[326,0]
    i_l_D4_D14_n_i = struct[0].y_ini[327,0]
    i_l_D14_D15_a_r = struct[0].y_ini[328,0]
    i_l_D14_D15_a_i = struct[0].y_ini[329,0]
    i_l_D14_D15_b_r = struct[0].y_ini[330,0]
    i_l_D14_D15_b_i = struct[0].y_ini[331,0]
    i_l_D14_D15_c_r = struct[0].y_ini[332,0]
    i_l_D14_D15_c_i = struct[0].y_ini[333,0]
    i_l_D14_D15_n_r = struct[0].y_ini[334,0]
    i_l_D14_D15_n_i = struct[0].y_ini[335,0]
    i_load_R1_a_r = struct[0].y_ini[336,0]
    i_load_R1_a_i = struct[0].y_ini[337,0]
    i_load_R1_b_r = struct[0].y_ini[338,0]
    i_load_R1_b_i = struct[0].y_ini[339,0]
    i_load_R1_c_r = struct[0].y_ini[340,0]
    i_load_R1_c_i = struct[0].y_ini[341,0]
    i_load_R1_n_r = struct[0].y_ini[342,0]
    i_load_R1_n_i = struct[0].y_ini[343,0]
    i_load_R11_a_r = struct[0].y_ini[344,0]
    i_load_R11_a_i = struct[0].y_ini[345,0]
    i_load_R11_b_r = struct[0].y_ini[346,0]
    i_load_R11_b_i = struct[0].y_ini[347,0]
    i_load_R11_c_r = struct[0].y_ini[348,0]
    i_load_R11_c_i = struct[0].y_ini[349,0]
    i_load_R11_n_r = struct[0].y_ini[350,0]
    i_load_R11_n_i = struct[0].y_ini[351,0]
    i_load_R15_a_r = struct[0].y_ini[352,0]
    i_load_R15_a_i = struct[0].y_ini[353,0]
    i_load_R15_b_r = struct[0].y_ini[354,0]
    i_load_R15_b_i = struct[0].y_ini[355,0]
    i_load_R15_c_r = struct[0].y_ini[356,0]
    i_load_R15_c_i = struct[0].y_ini[357,0]
    i_load_R15_n_r = struct[0].y_ini[358,0]
    i_load_R15_n_i = struct[0].y_ini[359,0]
    i_load_R16_a_r = struct[0].y_ini[360,0]
    i_load_R16_a_i = struct[0].y_ini[361,0]
    i_load_R16_b_r = struct[0].y_ini[362,0]
    i_load_R16_b_i = struct[0].y_ini[363,0]
    i_load_R16_c_r = struct[0].y_ini[364,0]
    i_load_R16_c_i = struct[0].y_ini[365,0]
    i_load_R16_n_r = struct[0].y_ini[366,0]
    i_load_R16_n_i = struct[0].y_ini[367,0]
    i_load_R17_a_r = struct[0].y_ini[368,0]
    i_load_R17_a_i = struct[0].y_ini[369,0]
    i_load_R17_b_r = struct[0].y_ini[370,0]
    i_load_R17_b_i = struct[0].y_ini[371,0]
    i_load_R17_c_r = struct[0].y_ini[372,0]
    i_load_R17_c_i = struct[0].y_ini[373,0]
    i_load_R17_n_r = struct[0].y_ini[374,0]
    i_load_R17_n_i = struct[0].y_ini[375,0]
    i_load_R18_a_r = struct[0].y_ini[376,0]
    i_load_R18_a_i = struct[0].y_ini[377,0]
    i_load_R18_b_r = struct[0].y_ini[378,0]
    i_load_R18_b_i = struct[0].y_ini[379,0]
    i_load_R18_c_r = struct[0].y_ini[380,0]
    i_load_R18_c_i = struct[0].y_ini[381,0]
    i_load_R18_n_r = struct[0].y_ini[382,0]
    i_load_R18_n_i = struct[0].y_ini[383,0]
    i_load_D15_a_r = struct[0].y_ini[384,0]
    i_load_D15_a_i = struct[0].y_ini[385,0]
    i_load_D15_n_r = struct[0].y_ini[386,0]
    i_load_D15_n_i = struct[0].y_ini[387,0]
    i_load_D11_a_r = struct[0].y_ini[388,0]
    i_load_D11_a_i = struct[0].y_ini[389,0]
    i_load_D11_n_r = struct[0].y_ini[390,0]
    i_load_D11_n_i = struct[0].y_ini[391,0]
    i_load_D16_a_r = struct[0].y_ini[392,0]
    i_load_D16_a_i = struct[0].y_ini[393,0]
    i_load_D16_n_r = struct[0].y_ini[394,0]
    i_load_D16_n_i = struct[0].y_ini[395,0]
    i_load_D17_a_r = struct[0].y_ini[396,0]
    i_load_D17_a_i = struct[0].y_ini[397,0]
    i_load_D17_n_r = struct[0].y_ini[398,0]
    i_load_D17_n_i = struct[0].y_ini[399,0]
    i_load_D18_a_r = struct[0].y_ini[400,0]
    i_load_D18_a_i = struct[0].y_ini[401,0]
    i_load_D18_n_r = struct[0].y_ini[402,0]
    i_load_D18_n_i = struct[0].y_ini[403,0]
    i_vsc_R1_a_r = struct[0].y_ini[404,0]
    i_vsc_R1_a_i = struct[0].y_ini[405,0]
    i_vsc_R1_b_r = struct[0].y_ini[406,0]
    i_vsc_R1_b_i = struct[0].y_ini[407,0]
    i_vsc_R1_c_r = struct[0].y_ini[408,0]
    i_vsc_R1_c_i = struct[0].y_ini[409,0]
    p_R1 = struct[0].y_ini[410,0]
    p_D1 = struct[0].y_ini[411,0]
    p_loss_R1 = struct[0].y_ini[412,0]
    i_vsc_R10_a_r = struct[0].y_ini[413,0]
    i_vsc_R10_a_i = struct[0].y_ini[414,0]
    i_vsc_R10_b_r = struct[0].y_ini[415,0]
    i_vsc_R10_b_i = struct[0].y_ini[416,0]
    i_vsc_R10_c_r = struct[0].y_ini[417,0]
    i_vsc_R10_c_i = struct[0].y_ini[418,0]
    i_vsc_D10_a_r = struct[0].y_ini[419,0]
    i_vsc_D10_n_r = struct[0].y_ini[420,0]
    p_D10 = struct[0].y_ini[421,0]
    p_loss_R10 = struct[0].y_ini[422,0]
    i_vsc_R14_a_r = struct[0].y_ini[423,0]
    i_vsc_R14_a_i = struct[0].y_ini[424,0]
    i_vsc_R14_b_r = struct[0].y_ini[425,0]
    i_vsc_R14_b_i = struct[0].y_ini[426,0]
    i_vsc_R14_c_r = struct[0].y_ini[427,0]
    i_vsc_R14_c_i = struct[0].y_ini[428,0]
    i_vsc_D14_a_r = struct[0].y_ini[429,0]
    i_vsc_D14_n_r = struct[0].y_ini[430,0]
    p_D14 = struct[0].y_ini[431,0]
    p_loss_R14 = struct[0].y_ini[432,0]
    
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = u_dummy - x_dummy
    
    # Algebraic equations:
    if mode == 3:

        struct[0].g[:,:] = np.ascontiguousarray(struct[0].Gy_ini) @ np.ascontiguousarray(struct[0].y_ini)

        struct[0].g[0,0] = i_load_R1_a_r + i_vsc_R1_a_r + 0.849044513514155*v_R0_a_i + 0.212261128378539*v_R0_a_r - 0.849044513514155*v_R0_c_i - 0.212261128378539*v_R0_c_r - 127.595184532966*v_R1_a_i - 123.954122254357*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r + 23.284964480954*v_R1_c_i + 24.9575997948692*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r + 54.0657727682604*v_R2_a_i + 105.57176931318*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r - 23.284964480954*v_R2_c_i - 24.9575997948692*v_R2_c_r - 10.2713736253513*v_R2_n_i - 39.6392229058202*v_R2_n_r
        struct[0].g[1,0] = i_load_R1_a_i + i_vsc_R1_a_i + 0.212261128378539*v_R0_a_i - 0.849044513514155*v_R0_a_r - 0.212261128378539*v_R0_c_i + 0.849044513514155*v_R0_c_r - 123.954122254357*v_R1_a_i + 127.595184532966*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r + 24.9575997948692*v_R1_c_i - 23.284964480954*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r + 105.57176931318*v_R2_a_i - 54.0657727682604*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r - 24.9575997948692*v_R2_c_i + 23.284964480954*v_R2_c_r - 39.6392229058202*v_R2_n_i + 10.2713736253513*v_R2_n_r
        struct[0].g[2,0] = i_load_R1_b_r + i_vsc_R1_b_r - 0.849044513514155*v_R0_a_i - 0.212261128378539*v_R0_a_r + 0.849044513514155*v_R0_b_i + 0.212261128378539*v_R0_b_r + 10.2713736253513*v_R1_a_i + 39.6392229058202*v_R1_a_r - 127.595184532966*v_R1_b_i - 123.954122254357*v_R1_b_r + 10.2713736253513*v_R1_c_i + 39.6392229058201*v_R1_c_r + 96.8143762456598*v_R1_n_i + 43.3399527360457*v_R1_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r + 54.0657727682604*v_R2_b_i + 105.57176931318*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058201*v_R2_c_r - 23.284964480954*v_R2_n_i - 24.9575997948692*v_R2_n_r
        struct[0].g[3,0] = i_load_R1_b_i + i_vsc_R1_b_i - 0.212261128378539*v_R0_a_i + 0.849044513514155*v_R0_a_r + 0.212261128378539*v_R0_b_i - 0.849044513514155*v_R0_b_r + 39.6392229058202*v_R1_a_i - 10.2713736253513*v_R1_a_r - 123.954122254357*v_R1_b_i + 127.595184532966*v_R1_b_r + 39.6392229058201*v_R1_c_i - 10.2713736253513*v_R1_c_r + 43.3399527360457*v_R1_n_i - 96.8143762456598*v_R1_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r + 105.57176931318*v_R2_b_i - 54.0657727682604*v_R2_b_r - 39.6392229058201*v_R2_c_i + 10.2713736253513*v_R2_c_r - 24.9575997948692*v_R2_n_i + 23.284964480954*v_R2_n_r
        struct[0].g[4,0] = i_load_R1_c_r + i_vsc_R1_c_r - 0.849044513514155*v_R0_b_i - 0.212261128378539*v_R0_b_r + 0.849044513514155*v_R0_c_i + 0.212261128378539*v_R0_c_r + 23.284964480954*v_R1_a_i + 24.9575997948692*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r - 127.595184532966*v_R1_c_i - 123.954122254357*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r - 23.284964480954*v_R2_a_i - 24.9575997948692*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r + 54.0657727682604*v_R2_c_i + 105.57176931318*v_R2_c_r - 10.2713736253514*v_R2_n_i - 39.6392229058201*v_R2_n_r
        struct[0].g[5,0] = i_load_R1_c_i + i_vsc_R1_c_i - 0.212261128378539*v_R0_b_i + 0.849044513514155*v_R0_b_r + 0.212261128378539*v_R0_c_i - 0.849044513514155*v_R0_c_r + 24.9575997948692*v_R1_a_i - 23.284964480954*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r - 123.954122254357*v_R1_c_i + 127.595184532966*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r - 24.9575997948692*v_R2_a_i + 23.284964480954*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r + 105.57176931318*v_R2_c_i - 54.0657727682604*v_R2_c_r - 39.6392229058201*v_R2_n_i + 10.2713736253514*v_R2_n_r
        struct[0].g[166,0] = 157.977883096366*v_D11_a_r + 67.7048070412999*v_D1_a_r - 361.092304220266*v_D3_a_r + 135.4096140826*v_D4_a_r
        struct[0].g[167,0] = 157.977883096366*v_D11_a_i + 67.7048070412999*v_D1_a_i - 361.092304220266*v_D3_a_i + 135.4096140826*v_D4_a_i
        struct[0].g[168,0] = 157.977883096366*v_D11_b_r + 67.7048070412999*v_D1_b_r - 361.092304220266*v_D3_b_r + 135.4096140826*v_D4_b_r
        struct[0].g[169,0] = 157.977883096366*v_D11_b_i + 67.7048070412999*v_D1_b_i - 361.092304220266*v_D3_b_i + 135.4096140826*v_D4_b_i
        struct[0].g[170,0] = 157.977883096366*v_D11_c_r + 67.7048070412999*v_D1_c_r - 361.092304220266*v_D3_c_r + 135.4096140826*v_D4_c_r
        struct[0].g[171,0] = 157.977883096366*v_D11_c_i + 67.7048070412999*v_D1_c_i - 361.092304220266*v_D3_c_i + 135.4096140826*v_D4_c_i
        struct[0].g[234,0] = -i_t_R0_R1_a_r + 0.0196078431372549*v_R0_a_i + 0.00490196078431373*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_a_i - 0.212261128378539*v_R1_a_r + 0.849044513514155*v_R1_b_i + 0.212261128378539*v_R1_b_r
        struct[0].g[235,0] = -i_t_R0_R1_a_i + 0.00490196078431373*v_R0_a_i - 0.0196078431372549*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_a_i + 0.849044513514155*v_R1_a_r + 0.212261128378539*v_R1_b_i - 0.849044513514155*v_R1_b_r
        struct[0].g[236,0] = -i_t_R0_R1_b_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r + 0.0196078431372549*v_R0_b_i + 0.00490196078431373*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_b_i - 0.212261128378539*v_R1_b_r + 0.849044513514155*v_R1_c_i + 0.212261128378539*v_R1_c_r
        struct[0].g[237,0] = -i_t_R0_R1_b_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r + 0.00490196078431373*v_R0_b_i - 0.0196078431372549*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_b_i + 0.849044513514155*v_R1_b_r + 0.212261128378539*v_R1_c_i - 0.849044513514155*v_R1_c_r
        struct[0].g[238,0] = -i_t_R0_R1_c_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r + 0.0196078431372549*v_R0_c_i + 0.00490196078431373*v_R0_c_r + 0.849044513514155*v_R1_a_i + 0.212261128378539*v_R1_a_r - 0.849044513514155*v_R1_c_i - 0.212261128378539*v_R1_c_r
        struct[0].g[239,0] = -i_t_R0_R1_c_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r + 0.00490196078431373*v_R0_c_i - 0.0196078431372549*v_R0_c_r + 0.212261128378539*v_R1_a_i - 0.849044513514155*v_R1_a_r - 0.212261128378539*v_R1_c_i + 0.849044513514155*v_R1_c_r
        struct[0].g[248,0] = -i_l_D1_D3_a_r + 67.7048070412999*v_D1_a_r - 67.7048070412999*v_D3_a_r
        struct[0].g[249,0] = -i_l_D1_D3_a_i + 67.7048070412999*v_D1_a_i - 67.7048070412999*v_D3_a_i
        struct[0].g[250,0] = -i_l_D1_D3_b_r + 67.7048070412999*v_D1_b_r - 67.7048070412999*v_D3_b_r
        struct[0].g[251,0] = -i_l_D1_D3_b_i + 67.7048070412999*v_D1_b_i - 67.7048070412999*v_D3_b_i
        struct[0].g[252,0] = -i_l_D1_D3_c_r + 67.7048070412999*v_D1_c_r - 67.7048070412999*v_D3_c_r
        struct[0].g[253,0] = -i_l_D1_D3_c_i + 67.7048070412999*v_D1_c_i - 67.7048070412999*v_D3_c_i
        struct[0].g[336,0] = i_load_R1_a_i*v_R1_a_i - i_load_R1_a_i*v_R1_n_i + i_load_R1_a_r*v_R1_a_r - i_load_R1_a_r*v_R1_n_r - p_R1_a
        struct[0].g[337,0] = i_load_R1_b_i*v_R1_b_i - i_load_R1_b_i*v_R1_n_i + i_load_R1_b_r*v_R1_b_r - i_load_R1_b_r*v_R1_n_r - p_R1_b
        struct[0].g[338,0] = i_load_R1_c_i*v_R1_c_i - i_load_R1_c_i*v_R1_n_i + i_load_R1_c_r*v_R1_c_r - i_load_R1_c_r*v_R1_n_r - p_R1_c
        struct[0].g[339,0] = -i_load_R1_a_i*v_R1_a_r + i_load_R1_a_i*v_R1_n_r + i_load_R1_a_r*v_R1_a_i - i_load_R1_a_r*v_R1_n_i - q_R1_a
        struct[0].g[340,0] = -i_load_R1_b_i*v_R1_b_r + i_load_R1_b_i*v_R1_n_r + i_load_R1_b_r*v_R1_b_i - i_load_R1_b_r*v_R1_n_i - q_R1_b
        struct[0].g[341,0] = -i_load_R1_c_i*v_R1_c_r + i_load_R1_c_i*v_R1_n_r + i_load_R1_c_r*v_R1_c_i - i_load_R1_c_r*v_R1_n_i - q_R1_c
        struct[0].g[344,0] = i_load_R11_a_i*v_R11_a_i - i_load_R11_a_i*v_R11_n_i + i_load_R11_a_r*v_R11_a_r - i_load_R11_a_r*v_R11_n_r - p_R11_a
        struct[0].g[345,0] = i_load_R11_b_i*v_R11_b_i - i_load_R11_b_i*v_R11_n_i + i_load_R11_b_r*v_R11_b_r - i_load_R11_b_r*v_R11_n_r - p_R11_b
        struct[0].g[346,0] = i_load_R11_c_i*v_R11_c_i - i_load_R11_c_i*v_R11_n_i + i_load_R11_c_r*v_R11_c_r - i_load_R11_c_r*v_R11_n_r - p_R11_c
        struct[0].g[347,0] = -i_load_R11_a_i*v_R11_a_r + i_load_R11_a_i*v_R11_n_r + i_load_R11_a_r*v_R11_a_i - i_load_R11_a_r*v_R11_n_i - q_R11_a
        struct[0].g[348,0] = -i_load_R11_b_i*v_R11_b_r + i_load_R11_b_i*v_R11_n_r + i_load_R11_b_r*v_R11_b_i - i_load_R11_b_r*v_R11_n_i - q_R11_b
        struct[0].g[349,0] = -i_load_R11_c_i*v_R11_c_r + i_load_R11_c_i*v_R11_n_r + i_load_R11_c_r*v_R11_c_i - i_load_R11_c_r*v_R11_n_i - q_R11_c
        struct[0].g[352,0] = i_load_R15_a_i*v_R15_a_i - i_load_R15_a_i*v_R15_n_i + i_load_R15_a_r*v_R15_a_r - i_load_R15_a_r*v_R15_n_r - p_R15_a
        struct[0].g[353,0] = i_load_R15_b_i*v_R15_b_i - i_load_R15_b_i*v_R15_n_i + i_load_R15_b_r*v_R15_b_r - i_load_R15_b_r*v_R15_n_r - p_R15_b
        struct[0].g[354,0] = i_load_R15_c_i*v_R15_c_i - i_load_R15_c_i*v_R15_n_i + i_load_R15_c_r*v_R15_c_r - i_load_R15_c_r*v_R15_n_r - p_R15_c
        struct[0].g[355,0] = -i_load_R15_a_i*v_R15_a_r + i_load_R15_a_i*v_R15_n_r + i_load_R15_a_r*v_R15_a_i - i_load_R15_a_r*v_R15_n_i - q_R15_a
        struct[0].g[356,0] = -i_load_R15_b_i*v_R15_b_r + i_load_R15_b_i*v_R15_n_r + i_load_R15_b_r*v_R15_b_i - i_load_R15_b_r*v_R15_n_i - q_R15_b
        struct[0].g[357,0] = -i_load_R15_c_i*v_R15_c_r + i_load_R15_c_i*v_R15_n_r + i_load_R15_c_r*v_R15_c_i - i_load_R15_c_r*v_R15_n_i - q_R15_c
        struct[0].g[360,0] = i_load_R16_a_i*v_R16_a_i - i_load_R16_a_i*v_R16_n_i + i_load_R16_a_r*v_R16_a_r - i_load_R16_a_r*v_R16_n_r - p_R16_a
        struct[0].g[361,0] = i_load_R16_b_i*v_R16_b_i - i_load_R16_b_i*v_R16_n_i + i_load_R16_b_r*v_R16_b_r - i_load_R16_b_r*v_R16_n_r - p_R16_b
        struct[0].g[362,0] = i_load_R16_c_i*v_R16_c_i - i_load_R16_c_i*v_R16_n_i + i_load_R16_c_r*v_R16_c_r - i_load_R16_c_r*v_R16_n_r - p_R16_c
        struct[0].g[363,0] = -i_load_R16_a_i*v_R16_a_r + i_load_R16_a_i*v_R16_n_r + i_load_R16_a_r*v_R16_a_i - i_load_R16_a_r*v_R16_n_i - q_R16_a
        struct[0].g[364,0] = -i_load_R16_b_i*v_R16_b_r + i_load_R16_b_i*v_R16_n_r + i_load_R16_b_r*v_R16_b_i - i_load_R16_b_r*v_R16_n_i - q_R16_b
        struct[0].g[365,0] = -i_load_R16_c_i*v_R16_c_r + i_load_R16_c_i*v_R16_n_r + i_load_R16_c_r*v_R16_c_i - i_load_R16_c_r*v_R16_n_i - q_R16_c
        struct[0].g[368,0] = i_load_R17_a_i*v_R17_a_i - i_load_R17_a_i*v_R17_n_i + i_load_R17_a_r*v_R17_a_r - i_load_R17_a_r*v_R17_n_r - p_R17_a
        struct[0].g[369,0] = i_load_R17_b_i*v_R17_b_i - i_load_R17_b_i*v_R17_n_i + i_load_R17_b_r*v_R17_b_r - i_load_R17_b_r*v_R17_n_r - p_R17_b
        struct[0].g[370,0] = i_load_R17_c_i*v_R17_c_i - i_load_R17_c_i*v_R17_n_i + i_load_R17_c_r*v_R17_c_r - i_load_R17_c_r*v_R17_n_r - p_R17_c
        struct[0].g[371,0] = -i_load_R17_a_i*v_R17_a_r + i_load_R17_a_i*v_R17_n_r + i_load_R17_a_r*v_R17_a_i - i_load_R17_a_r*v_R17_n_i - q_R17_a
        struct[0].g[372,0] = -i_load_R17_b_i*v_R17_b_r + i_load_R17_b_i*v_R17_n_r + i_load_R17_b_r*v_R17_b_i - i_load_R17_b_r*v_R17_n_i - q_R17_b
        struct[0].g[373,0] = -i_load_R17_c_i*v_R17_c_r + i_load_R17_c_i*v_R17_n_r + i_load_R17_c_r*v_R17_c_i - i_load_R17_c_r*v_R17_n_i - q_R17_c
        struct[0].g[376,0] = i_load_R18_a_i*v_R18_a_i - i_load_R18_a_i*v_R18_n_i + i_load_R18_a_r*v_R18_a_r - i_load_R18_a_r*v_R18_n_r - p_R18_a
        struct[0].g[377,0] = i_load_R18_b_i*v_R18_b_i - i_load_R18_b_i*v_R18_n_i + i_load_R18_b_r*v_R18_b_r - i_load_R18_b_r*v_R18_n_r - p_R18_b
        struct[0].g[378,0] = i_load_R18_c_i*v_R18_c_i - i_load_R18_c_i*v_R18_n_i + i_load_R18_c_r*v_R18_c_r - i_load_R18_c_r*v_R18_n_r - p_R18_c
        struct[0].g[379,0] = -i_load_R18_a_i*v_R18_a_r + i_load_R18_a_i*v_R18_n_r + i_load_R18_a_r*v_R18_a_i - i_load_R18_a_r*v_R18_n_i - q_R18_a
        struct[0].g[380,0] = -i_load_R18_b_i*v_R18_b_r + i_load_R18_b_i*v_R18_n_r + i_load_R18_b_r*v_R18_b_i - i_load_R18_b_r*v_R18_n_i - q_R18_b
        struct[0].g[381,0] = -i_load_R18_c_i*v_R18_c_r + i_load_R18_c_i*v_R18_n_r + i_load_R18_c_r*v_R18_c_i - i_load_R18_c_r*v_R18_n_i - q_R18_c
        struct[0].g[384,0] = 1.0*i_load_D15_a_i*v_D15_a_i - 1.0*i_load_D15_a_i*v_D15_n_i + i_load_D15_a_r*v_D15_a_r - i_load_D15_a_r*v_D15_n_r - p_D15_1
        struct[0].g[385,0] = -1.0*i_load_D15_a_i*v_D15_a_r + 1.0*i_load_D15_a_i*v_D15_n_r + 1.0*i_load_D15_a_r*v_D15_a_i - 1.0*i_load_D15_a_r*v_D15_n_i - q_D15_1
        struct[0].g[388,0] = 1.0*i_load_D11_a_i*v_D11_a_i - 1.0*i_load_D11_a_i*v_D11_n_i + i_load_D11_a_r*v_D11_a_r - i_load_D11_a_r*v_D11_n_r - p_D11_1
        struct[0].g[389,0] = -1.0*i_load_D11_a_i*v_D11_a_r + 1.0*i_load_D11_a_i*v_D11_n_r + 1.0*i_load_D11_a_r*v_D11_a_i - 1.0*i_load_D11_a_r*v_D11_n_i - q_D11_1
        struct[0].g[392,0] = 1.0*i_load_D16_a_i*v_D16_a_i - 1.0*i_load_D16_a_i*v_D16_n_i + i_load_D16_a_r*v_D16_a_r - i_load_D16_a_r*v_D16_n_r - p_D16_1
        struct[0].g[393,0] = -1.0*i_load_D16_a_i*v_D16_a_r + 1.0*i_load_D16_a_i*v_D16_n_r + 1.0*i_load_D16_a_r*v_D16_a_i - 1.0*i_load_D16_a_r*v_D16_n_i - q_D16_1
        struct[0].g[396,0] = 1.0*i_load_D17_a_i*v_D17_a_i - 1.0*i_load_D17_a_i*v_D17_n_i + i_load_D17_a_r*v_D17_a_r - i_load_D17_a_r*v_D17_n_r - p_D17_1
        struct[0].g[397,0] = -1.0*i_load_D17_a_i*v_D17_a_r + 1.0*i_load_D17_a_i*v_D17_n_r + 1.0*i_load_D17_a_r*v_D17_a_i - 1.0*i_load_D17_a_r*v_D17_n_i - q_D17_1
        struct[0].g[400,0] = 1.0*i_load_D18_a_i*v_D18_a_i - 1.0*i_load_D18_a_i*v_D18_n_i + i_load_D18_a_r*v_D18_a_r - i_load_D18_a_r*v_D18_n_r - p_D18_1
        struct[0].g[401,0] = -1.0*i_load_D18_a_i*v_D18_a_r + 1.0*i_load_D18_a_i*v_D18_n_r + 1.0*i_load_D18_a_r*v_D18_a_i - 1.0*i_load_D18_a_r*v_D18_n_i - q_D18_1
        struct[0].g[404,0] = 1.0*i_vsc_R1_a_i*v_R1_a_i - 1.0*i_vsc_R1_a_i*v_R1_n_i + i_vsc_R1_a_r*v_R1_a_r - i_vsc_R1_a_r*v_R1_n_r - p_R1/3
        struct[0].g[405,0] = -1.0*i_vsc_R1_a_i*v_R1_a_r + 1.0*i_vsc_R1_a_i*v_R1_n_r + 1.0*i_vsc_R1_a_r*v_R1_a_i - 1.0*i_vsc_R1_a_r*v_R1_n_i - q_R1/3
        struct[0].g[406,0] = 1.0*i_vsc_R1_b_i*v_R1_b_i - 1.0*i_vsc_R1_b_i*v_R1_n_i + i_vsc_R1_b_r*v_R1_b_r - i_vsc_R1_b_r*v_R1_n_r - p_R1/3
        struct[0].g[407,0] = -1.0*i_vsc_R1_b_i*v_R1_b_r + 1.0*i_vsc_R1_b_i*v_R1_n_r + 1.0*i_vsc_R1_b_r*v_R1_b_i - 1.0*i_vsc_R1_b_r*v_R1_n_i - q_R1/3
        struct[0].g[408,0] = 1.0*i_vsc_R1_c_i*v_R1_c_i - 1.0*i_vsc_R1_c_i*v_R1_n_i + i_vsc_R1_c_r*v_R1_c_r - i_vsc_R1_c_r*v_R1_n_r - p_R1/3
        struct[0].g[409,0] = -1.0*i_vsc_R1_c_i*v_R1_c_r + 1.0*i_vsc_R1_c_i*v_R1_n_r + 1.0*i_vsc_R1_c_r*v_R1_c_i - 1.0*i_vsc_R1_c_r*v_R1_n_i - q_R1/3
        struct[0].g[410,0] = p_D1 + p_R1 + Piecewise(np.array([(-p_loss_R1, p_D1 < 0), (p_loss_R1, True)]))
        struct[0].g[412,0] = -a_R1 - b_R1*sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - c_R1*(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) + p_loss_R1
        struct[0].g[413,0] = -coef_a_R10*p_R10 + 1.0*i_vsc_R10_a_i*v_R10_a_i - 1.0*i_vsc_R10_a_i*v_R10_n_i + i_vsc_R10_a_r*v_R10_a_r - i_vsc_R10_a_r*v_R10_n_r
        struct[0].g[414,0] = -coef_a_R10*q_R10 - 1.0*i_vsc_R10_a_i*v_R10_a_r + 1.0*i_vsc_R10_a_i*v_R10_n_r + 1.0*i_vsc_R10_a_r*v_R10_a_i - 1.0*i_vsc_R10_a_r*v_R10_n_i
        struct[0].g[415,0] = -coef_b_R10*p_R10 + 1.0*i_vsc_R10_b_i*v_R10_b_i - 1.0*i_vsc_R10_b_i*v_R10_n_i + i_vsc_R10_b_r*v_R10_b_r - i_vsc_R10_b_r*v_R10_n_r
        struct[0].g[416,0] = -coef_b_R10*q_R10 - 1.0*i_vsc_R10_b_i*v_R10_b_r + 1.0*i_vsc_R10_b_i*v_R10_n_r + 1.0*i_vsc_R10_b_r*v_R10_b_i - 1.0*i_vsc_R10_b_r*v_R10_n_i
        struct[0].g[417,0] = -coef_c_R10*p_R10 + 1.0*i_vsc_R10_c_i*v_R10_c_i - 1.0*i_vsc_R10_c_i*v_R10_n_i + i_vsc_R10_c_r*v_R10_c_r - i_vsc_R10_c_r*v_R10_n_r
        struct[0].g[418,0] = -coef_c_R10*q_R10 - 1.0*i_vsc_R10_c_i*v_R10_c_r + 1.0*i_vsc_R10_c_i*v_R10_n_r + 1.0*i_vsc_R10_c_r*v_R10_c_i - 1.0*i_vsc_R10_c_r*v_R10_n_i
        struct[0].g[419,0] = i_vsc_D10_a_r + p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].g[420,0] = i_vsc_D10_n_r + p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].g[421,0] = p_D10 - p_R10 - Piecewise(np.array([(-p_loss_R10, p_D10 < 0), (p_loss_R10, True)]))
        struct[0].g[422,0] = -a_R10 - b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + p_loss_R10
        struct[0].g[423,0] = -coef_a_R14*p_R14 + 1.0*i_vsc_R14_a_i*v_R14_a_i - 1.0*i_vsc_R14_a_i*v_R14_n_i + i_vsc_R14_a_r*v_R14_a_r - i_vsc_R14_a_r*v_R14_n_r
        struct[0].g[424,0] = -coef_a_R14*q_R14 - 1.0*i_vsc_R14_a_i*v_R14_a_r + 1.0*i_vsc_R14_a_i*v_R14_n_r + 1.0*i_vsc_R14_a_r*v_R14_a_i - 1.0*i_vsc_R14_a_r*v_R14_n_i
        struct[0].g[425,0] = -coef_b_R14*p_R14 + 1.0*i_vsc_R14_b_i*v_R14_b_i - 1.0*i_vsc_R14_b_i*v_R14_n_i + i_vsc_R14_b_r*v_R14_b_r - i_vsc_R14_b_r*v_R14_n_r
        struct[0].g[426,0] = -coef_b_R14*q_R14 - 1.0*i_vsc_R14_b_i*v_R14_b_r + 1.0*i_vsc_R14_b_i*v_R14_n_r + 1.0*i_vsc_R14_b_r*v_R14_b_i - 1.0*i_vsc_R14_b_r*v_R14_n_i
        struct[0].g[427,0] = -coef_c_R14*p_R14 + 1.0*i_vsc_R14_c_i*v_R14_c_i - 1.0*i_vsc_R14_c_i*v_R14_n_i + i_vsc_R14_c_r*v_R14_c_r - i_vsc_R14_c_r*v_R14_n_r
        struct[0].g[428,0] = -coef_c_R14*q_R14 - 1.0*i_vsc_R14_c_i*v_R14_c_r + 1.0*i_vsc_R14_c_i*v_R14_n_r + 1.0*i_vsc_R14_c_r*v_R14_c_i - 1.0*i_vsc_R14_c_r*v_R14_n_i
        struct[0].g[429,0] = i_vsc_D14_a_r + p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].g[430,0] = i_vsc_D14_n_r + p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].g[431,0] = p_D14 - p_R14 - Piecewise(np.array([(-p_loss_R14, p_D14 < 0), (p_loss_R14, True)]))
        struct[0].g[432,0] = -a_R14 - b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + p_loss_R14
    
    # Outputs:
    if mode == 3:

        struct[0].h[0,0] = (v_R0_a_i**2 + v_R0_a_r**2)**0.5
        struct[0].h[1,0] = (v_R0_b_i**2 + v_R0_b_r**2)**0.5
        struct[0].h[2,0] = (v_R0_c_i**2 + v_R0_c_r**2)**0.5
        struct[0].h[3,0] = (v_D1_a_i**2 + v_D1_a_r**2)**0.5
        struct[0].h[4,0] = (v_D1_b_i**2 + v_D1_b_r**2)**0.5
        struct[0].h[5,0] = (v_D1_c_i**2 + v_D1_c_r**2)**0.5
        struct[0].h[6,0] = (v_R1_a_i**2 + v_R1_a_r**2)**0.5
        struct[0].h[7,0] = (v_R1_b_i**2 + v_R1_b_r**2)**0.5
        struct[0].h[8,0] = (v_R1_c_i**2 + v_R1_c_r**2)**0.5
        struct[0].h[9,0] = (v_R1_n_i**2 + v_R1_n_r**2)**0.5
        struct[0].h[10,0] = (v_R11_a_i**2 + v_R11_a_r**2)**0.5
        struct[0].h[11,0] = (v_R11_b_i**2 + v_R11_b_r**2)**0.5
        struct[0].h[12,0] = (v_R11_c_i**2 + v_R11_c_r**2)**0.5
        struct[0].h[13,0] = (v_R11_n_i**2 + v_R11_n_r**2)**0.5
        struct[0].h[14,0] = (v_R15_a_i**2 + v_R15_a_r**2)**0.5
        struct[0].h[15,0] = (v_R15_b_i**2 + v_R15_b_r**2)**0.5
        struct[0].h[16,0] = (v_R15_c_i**2 + v_R15_c_r**2)**0.5
        struct[0].h[17,0] = (v_R15_n_i**2 + v_R15_n_r**2)**0.5
        struct[0].h[18,0] = (v_R16_a_i**2 + v_R16_a_r**2)**0.5
        struct[0].h[19,0] = (v_R16_b_i**2 + v_R16_b_r**2)**0.5
        struct[0].h[20,0] = (v_R16_c_i**2 + v_R16_c_r**2)**0.5
        struct[0].h[21,0] = (v_R16_n_i**2 + v_R16_n_r**2)**0.5
        struct[0].h[22,0] = (v_R17_a_i**2 + v_R17_a_r**2)**0.5
        struct[0].h[23,0] = (v_R17_b_i**2 + v_R17_b_r**2)**0.5
        struct[0].h[24,0] = (v_R17_c_i**2 + v_R17_c_r**2)**0.5
        struct[0].h[25,0] = (v_R17_n_i**2 + v_R17_n_r**2)**0.5
        struct[0].h[26,0] = (v_R18_a_i**2 + v_R18_a_r**2)**0.5
        struct[0].h[27,0] = (v_R18_b_i**2 + v_R18_b_r**2)**0.5
        struct[0].h[28,0] = (v_R18_c_i**2 + v_R18_c_r**2)**0.5
        struct[0].h[29,0] = (v_R18_n_i**2 + v_R18_n_r**2)**0.5
        struct[0].h[30,0] = (v_D15_a_i**2 + v_D15_a_r**2)**0.5
        struct[0].h[31,0] = (v_D15_n_i**2 + v_D15_n_r**2)**0.5
        struct[0].h[32,0] = (v_D11_a_i**2 + v_D11_a_r**2)**0.5
        struct[0].h[33,0] = (v_D11_n_i**2 + v_D11_n_r**2)**0.5
        struct[0].h[34,0] = (v_D16_a_i**2 + v_D16_a_r**2)**0.5
        struct[0].h[35,0] = (v_D16_n_i**2 + v_D16_n_r**2)**0.5
        struct[0].h[36,0] = (v_D17_a_i**2 + v_D17_a_r**2)**0.5
        struct[0].h[37,0] = (v_D17_n_i**2 + v_D17_n_r**2)**0.5
        struct[0].h[38,0] = (v_D18_a_i**2 + v_D18_a_r**2)**0.5
        struct[0].h[39,0] = (v_D18_n_i**2 + v_D18_n_r**2)**0.5
        struct[0].h[40,0] = (v_R2_a_i**2 + v_R2_a_r**2)**0.5
        struct[0].h[41,0] = (v_R2_b_i**2 + v_R2_b_r**2)**0.5
        struct[0].h[42,0] = (v_R2_c_i**2 + v_R2_c_r**2)**0.5
        struct[0].h[43,0] = (v_R2_n_i**2 + v_R2_n_r**2)**0.5
        struct[0].h[44,0] = (v_R3_a_i**2 + v_R3_a_r**2)**0.5
        struct[0].h[45,0] = (v_R3_b_i**2 + v_R3_b_r**2)**0.5
        struct[0].h[46,0] = (v_R3_c_i**2 + v_R3_c_r**2)**0.5
        struct[0].h[47,0] = (v_R3_n_i**2 + v_R3_n_r**2)**0.5
        struct[0].h[48,0] = (v_R4_a_i**2 + v_R4_a_r**2)**0.5
        struct[0].h[49,0] = (v_R4_b_i**2 + v_R4_b_r**2)**0.5
        struct[0].h[50,0] = (v_R4_c_i**2 + v_R4_c_r**2)**0.5
        struct[0].h[51,0] = (v_R4_n_i**2 + v_R4_n_r**2)**0.5
        struct[0].h[52,0] = (v_R5_a_i**2 + v_R5_a_r**2)**0.5
        struct[0].h[53,0] = (v_R5_b_i**2 + v_R5_b_r**2)**0.5
        struct[0].h[54,0] = (v_R5_c_i**2 + v_R5_c_r**2)**0.5
        struct[0].h[55,0] = (v_R5_n_i**2 + v_R5_n_r**2)**0.5
        struct[0].h[56,0] = (v_R6_a_i**2 + v_R6_a_r**2)**0.5
        struct[0].h[57,0] = (v_R6_b_i**2 + v_R6_b_r**2)**0.5
        struct[0].h[58,0] = (v_R6_c_i**2 + v_R6_c_r**2)**0.5
        struct[0].h[59,0] = (v_R6_n_i**2 + v_R6_n_r**2)**0.5
        struct[0].h[60,0] = (v_R7_a_i**2 + v_R7_a_r**2)**0.5
        struct[0].h[61,0] = (v_R7_b_i**2 + v_R7_b_r**2)**0.5
        struct[0].h[62,0] = (v_R7_c_i**2 + v_R7_c_r**2)**0.5
        struct[0].h[63,0] = (v_R7_n_i**2 + v_R7_n_r**2)**0.5
        struct[0].h[64,0] = (v_R8_a_i**2 + v_R8_a_r**2)**0.5
        struct[0].h[65,0] = (v_R8_b_i**2 + v_R8_b_r**2)**0.5
        struct[0].h[66,0] = (v_R8_c_i**2 + v_R8_c_r**2)**0.5
        struct[0].h[67,0] = (v_R8_n_i**2 + v_R8_n_r**2)**0.5
        struct[0].h[68,0] = (v_R9_a_i**2 + v_R9_a_r**2)**0.5
        struct[0].h[69,0] = (v_R9_b_i**2 + v_R9_b_r**2)**0.5
        struct[0].h[70,0] = (v_R9_c_i**2 + v_R9_c_r**2)**0.5
        struct[0].h[71,0] = (v_R9_n_i**2 + v_R9_n_r**2)**0.5
        struct[0].h[72,0] = (v_R10_a_i**2 + v_R10_a_r**2)**0.5
        struct[0].h[73,0] = (v_R10_b_i**2 + v_R10_b_r**2)**0.5
        struct[0].h[74,0] = (v_R10_c_i**2 + v_R10_c_r**2)**0.5
        struct[0].h[75,0] = (v_R10_n_i**2 + v_R10_n_r**2)**0.5
        struct[0].h[76,0] = (v_R12_a_i**2 + v_R12_a_r**2)**0.5
        struct[0].h[77,0] = (v_R12_b_i**2 + v_R12_b_r**2)**0.5
        struct[0].h[78,0] = (v_R12_c_i**2 + v_R12_c_r**2)**0.5
        struct[0].h[79,0] = (v_R12_n_i**2 + v_R12_n_r**2)**0.5
        struct[0].h[80,0] = (v_R13_a_i**2 + v_R13_a_r**2)**0.5
        struct[0].h[81,0] = (v_R13_b_i**2 + v_R13_b_r**2)**0.5
        struct[0].h[82,0] = (v_R13_c_i**2 + v_R13_c_r**2)**0.5
        struct[0].h[83,0] = (v_R13_n_i**2 + v_R13_n_r**2)**0.5
        struct[0].h[84,0] = (v_R14_a_i**2 + v_R14_a_r**2)**0.5
        struct[0].h[85,0] = (v_R14_b_i**2 + v_R14_b_r**2)**0.5
        struct[0].h[86,0] = (v_R14_c_i**2 + v_R14_c_r**2)**0.5
        struct[0].h[87,0] = (v_R14_n_i**2 + v_R14_n_r**2)**0.5
        struct[0].h[88,0] = (v_D1_n_i**2 + v_D1_n_r**2)**0.5
        struct[0].h[89,0] = (v_D3_a_i**2 + v_D3_a_r**2)**0.5
        struct[0].h[90,0] = (v_D3_b_i**2 + v_D3_b_r**2)**0.5
        struct[0].h[91,0] = (v_D3_c_i**2 + v_D3_c_r**2)**0.5
        struct[0].h[92,0] = (v_D3_n_i**2 + v_D3_n_r**2)**0.5
        struct[0].h[93,0] = (v_D4_a_i**2 + v_D4_a_r**2)**0.5
        struct[0].h[94,0] = (v_D4_b_i**2 + v_D4_b_r**2)**0.5
        struct[0].h[95,0] = (v_D4_c_i**2 + v_D4_c_r**2)**0.5
        struct[0].h[96,0] = (v_D4_n_i**2 + v_D4_n_r**2)**0.5
        struct[0].h[97,0] = (v_D6_a_i**2 + v_D6_a_r**2)**0.5
        struct[0].h[98,0] = (v_D6_b_i**2 + v_D6_b_r**2)**0.5
        struct[0].h[99,0] = (v_D6_c_i**2 + v_D6_c_r**2)**0.5
        struct[0].h[100,0] = (v_D6_n_i**2 + v_D6_n_r**2)**0.5
        struct[0].h[101,0] = (v_D9_a_i**2 + v_D9_a_r**2)**0.5
        struct[0].h[102,0] = (v_D9_b_i**2 + v_D9_b_r**2)**0.5
        struct[0].h[103,0] = (v_D9_c_i**2 + v_D9_c_r**2)**0.5
        struct[0].h[104,0] = (v_D9_n_i**2 + v_D9_n_r**2)**0.5
        struct[0].h[105,0] = (v_D10_a_i**2 + v_D10_a_r**2)**0.5
        struct[0].h[106,0] = (v_D10_b_i**2 + v_D10_b_r**2)**0.5
        struct[0].h[107,0] = (v_D10_c_i**2 + v_D10_c_r**2)**0.5
        struct[0].h[108,0] = (v_D10_n_i**2 + v_D10_n_r**2)**0.5
        struct[0].h[109,0] = (v_D11_b_i**2 + v_D11_b_r**2)**0.5
        struct[0].h[110,0] = (v_D11_c_i**2 + v_D11_c_r**2)**0.5
        struct[0].h[111,0] = (v_D16_b_i**2 + v_D16_b_r**2)**0.5
        struct[0].h[112,0] = (v_D16_c_i**2 + v_D16_c_r**2)**0.5
        struct[0].h[113,0] = (v_D17_b_i**2 + v_D17_b_r**2)**0.5
        struct[0].h[114,0] = (v_D17_c_i**2 + v_D17_c_r**2)**0.5
        struct[0].h[115,0] = (v_D18_b_i**2 + v_D18_b_r**2)**0.5
        struct[0].h[116,0] = (v_D18_c_i**2 + v_D18_c_r**2)**0.5
        struct[0].h[117,0] = (v_D14_a_i**2 + v_D14_a_r**2)**0.5
        struct[0].h[118,0] = (v_D14_b_i**2 + v_D14_b_r**2)**0.5
        struct[0].h[119,0] = (v_D14_c_i**2 + v_D14_c_r**2)**0.5
        struct[0].h[120,0] = (v_D14_n_i**2 + v_D14_n_r**2)**0.5
        struct[0].h[121,0] = (v_D15_b_i**2 + v_D15_b_r**2)**0.5
        struct[0].h[122,0] = (v_D15_c_i**2 + v_D15_c_r**2)**0.5
    

    if mode == 10:

        pass

    if mode == 11:



        struct[0].Gy_ini[336,0] = i_load_R1_a_r
        struct[0].Gy_ini[336,1] = i_load_R1_a_i
        struct[0].Gy_ini[336,6] = -i_load_R1_a_r
        struct[0].Gy_ini[336,7] = -i_load_R1_a_i
        struct[0].Gy_ini[336,336] = v_R1_a_r - v_R1_n_r
        struct[0].Gy_ini[336,337] = v_R1_a_i - v_R1_n_i
        struct[0].Gy_ini[337,2] = i_load_R1_b_r
        struct[0].Gy_ini[337,3] = i_load_R1_b_i
        struct[0].Gy_ini[337,6] = -i_load_R1_b_r
        struct[0].Gy_ini[337,7] = -i_load_R1_b_i
        struct[0].Gy_ini[337,338] = v_R1_b_r - v_R1_n_r
        struct[0].Gy_ini[337,339] = v_R1_b_i - v_R1_n_i
        struct[0].Gy_ini[338,4] = i_load_R1_c_r
        struct[0].Gy_ini[338,5] = i_load_R1_c_i
        struct[0].Gy_ini[338,6] = -i_load_R1_c_r
        struct[0].Gy_ini[338,7] = -i_load_R1_c_i
        struct[0].Gy_ini[338,340] = v_R1_c_r - v_R1_n_r
        struct[0].Gy_ini[338,341] = v_R1_c_i - v_R1_n_i
        struct[0].Gy_ini[339,0] = -i_load_R1_a_i
        struct[0].Gy_ini[339,1] = i_load_R1_a_r
        struct[0].Gy_ini[339,6] = i_load_R1_a_i
        struct[0].Gy_ini[339,7] = -i_load_R1_a_r
        struct[0].Gy_ini[339,336] = v_R1_a_i - v_R1_n_i
        struct[0].Gy_ini[339,337] = -v_R1_a_r + v_R1_n_r
        struct[0].Gy_ini[340,2] = -i_load_R1_b_i
        struct[0].Gy_ini[340,3] = i_load_R1_b_r
        struct[0].Gy_ini[340,6] = i_load_R1_b_i
        struct[0].Gy_ini[340,7] = -i_load_R1_b_r
        struct[0].Gy_ini[340,338] = v_R1_b_i - v_R1_n_i
        struct[0].Gy_ini[340,339] = -v_R1_b_r + v_R1_n_r
        struct[0].Gy_ini[341,4] = -i_load_R1_c_i
        struct[0].Gy_ini[341,5] = i_load_R1_c_r
        struct[0].Gy_ini[341,6] = i_load_R1_c_i
        struct[0].Gy_ini[341,7] = -i_load_R1_c_r
        struct[0].Gy_ini[341,340] = v_R1_c_i - v_R1_n_i
        struct[0].Gy_ini[341,341] = -v_R1_c_r + v_R1_n_r
        struct[0].Gy_ini[344,8] = i_load_R11_a_r
        struct[0].Gy_ini[344,9] = i_load_R11_a_i
        struct[0].Gy_ini[344,14] = -i_load_R11_a_r
        struct[0].Gy_ini[344,15] = -i_load_R11_a_i
        struct[0].Gy_ini[344,344] = v_R11_a_r - v_R11_n_r
        struct[0].Gy_ini[344,345] = v_R11_a_i - v_R11_n_i
        struct[0].Gy_ini[345,10] = i_load_R11_b_r
        struct[0].Gy_ini[345,11] = i_load_R11_b_i
        struct[0].Gy_ini[345,14] = -i_load_R11_b_r
        struct[0].Gy_ini[345,15] = -i_load_R11_b_i
        struct[0].Gy_ini[345,346] = v_R11_b_r - v_R11_n_r
        struct[0].Gy_ini[345,347] = v_R11_b_i - v_R11_n_i
        struct[0].Gy_ini[346,12] = i_load_R11_c_r
        struct[0].Gy_ini[346,13] = i_load_R11_c_i
        struct[0].Gy_ini[346,14] = -i_load_R11_c_r
        struct[0].Gy_ini[346,15] = -i_load_R11_c_i
        struct[0].Gy_ini[346,348] = v_R11_c_r - v_R11_n_r
        struct[0].Gy_ini[346,349] = v_R11_c_i - v_R11_n_i
        struct[0].Gy_ini[347,8] = -i_load_R11_a_i
        struct[0].Gy_ini[347,9] = i_load_R11_a_r
        struct[0].Gy_ini[347,14] = i_load_R11_a_i
        struct[0].Gy_ini[347,15] = -i_load_R11_a_r
        struct[0].Gy_ini[347,344] = v_R11_a_i - v_R11_n_i
        struct[0].Gy_ini[347,345] = -v_R11_a_r + v_R11_n_r
        struct[0].Gy_ini[348,10] = -i_load_R11_b_i
        struct[0].Gy_ini[348,11] = i_load_R11_b_r
        struct[0].Gy_ini[348,14] = i_load_R11_b_i
        struct[0].Gy_ini[348,15] = -i_load_R11_b_r
        struct[0].Gy_ini[348,346] = v_R11_b_i - v_R11_n_i
        struct[0].Gy_ini[348,347] = -v_R11_b_r + v_R11_n_r
        struct[0].Gy_ini[349,12] = -i_load_R11_c_i
        struct[0].Gy_ini[349,13] = i_load_R11_c_r
        struct[0].Gy_ini[349,14] = i_load_R11_c_i
        struct[0].Gy_ini[349,15] = -i_load_R11_c_r
        struct[0].Gy_ini[349,348] = v_R11_c_i - v_R11_n_i
        struct[0].Gy_ini[349,349] = -v_R11_c_r + v_R11_n_r
        struct[0].Gy_ini[352,16] = i_load_R15_a_r
        struct[0].Gy_ini[352,17] = i_load_R15_a_i
        struct[0].Gy_ini[352,22] = -i_load_R15_a_r
        struct[0].Gy_ini[352,23] = -i_load_R15_a_i
        struct[0].Gy_ini[352,352] = v_R15_a_r - v_R15_n_r
        struct[0].Gy_ini[352,353] = v_R15_a_i - v_R15_n_i
        struct[0].Gy_ini[353,18] = i_load_R15_b_r
        struct[0].Gy_ini[353,19] = i_load_R15_b_i
        struct[0].Gy_ini[353,22] = -i_load_R15_b_r
        struct[0].Gy_ini[353,23] = -i_load_R15_b_i
        struct[0].Gy_ini[353,354] = v_R15_b_r - v_R15_n_r
        struct[0].Gy_ini[353,355] = v_R15_b_i - v_R15_n_i
        struct[0].Gy_ini[354,20] = i_load_R15_c_r
        struct[0].Gy_ini[354,21] = i_load_R15_c_i
        struct[0].Gy_ini[354,22] = -i_load_R15_c_r
        struct[0].Gy_ini[354,23] = -i_load_R15_c_i
        struct[0].Gy_ini[354,356] = v_R15_c_r - v_R15_n_r
        struct[0].Gy_ini[354,357] = v_R15_c_i - v_R15_n_i
        struct[0].Gy_ini[355,16] = -i_load_R15_a_i
        struct[0].Gy_ini[355,17] = i_load_R15_a_r
        struct[0].Gy_ini[355,22] = i_load_R15_a_i
        struct[0].Gy_ini[355,23] = -i_load_R15_a_r
        struct[0].Gy_ini[355,352] = v_R15_a_i - v_R15_n_i
        struct[0].Gy_ini[355,353] = -v_R15_a_r + v_R15_n_r
        struct[0].Gy_ini[356,18] = -i_load_R15_b_i
        struct[0].Gy_ini[356,19] = i_load_R15_b_r
        struct[0].Gy_ini[356,22] = i_load_R15_b_i
        struct[0].Gy_ini[356,23] = -i_load_R15_b_r
        struct[0].Gy_ini[356,354] = v_R15_b_i - v_R15_n_i
        struct[0].Gy_ini[356,355] = -v_R15_b_r + v_R15_n_r
        struct[0].Gy_ini[357,20] = -i_load_R15_c_i
        struct[0].Gy_ini[357,21] = i_load_R15_c_r
        struct[0].Gy_ini[357,22] = i_load_R15_c_i
        struct[0].Gy_ini[357,23] = -i_load_R15_c_r
        struct[0].Gy_ini[357,356] = v_R15_c_i - v_R15_n_i
        struct[0].Gy_ini[357,357] = -v_R15_c_r + v_R15_n_r
        struct[0].Gy_ini[360,24] = i_load_R16_a_r
        struct[0].Gy_ini[360,25] = i_load_R16_a_i
        struct[0].Gy_ini[360,30] = -i_load_R16_a_r
        struct[0].Gy_ini[360,31] = -i_load_R16_a_i
        struct[0].Gy_ini[360,360] = v_R16_a_r - v_R16_n_r
        struct[0].Gy_ini[360,361] = v_R16_a_i - v_R16_n_i
        struct[0].Gy_ini[361,26] = i_load_R16_b_r
        struct[0].Gy_ini[361,27] = i_load_R16_b_i
        struct[0].Gy_ini[361,30] = -i_load_R16_b_r
        struct[0].Gy_ini[361,31] = -i_load_R16_b_i
        struct[0].Gy_ini[361,362] = v_R16_b_r - v_R16_n_r
        struct[0].Gy_ini[361,363] = v_R16_b_i - v_R16_n_i
        struct[0].Gy_ini[362,28] = i_load_R16_c_r
        struct[0].Gy_ini[362,29] = i_load_R16_c_i
        struct[0].Gy_ini[362,30] = -i_load_R16_c_r
        struct[0].Gy_ini[362,31] = -i_load_R16_c_i
        struct[0].Gy_ini[362,364] = v_R16_c_r - v_R16_n_r
        struct[0].Gy_ini[362,365] = v_R16_c_i - v_R16_n_i
        struct[0].Gy_ini[363,24] = -i_load_R16_a_i
        struct[0].Gy_ini[363,25] = i_load_R16_a_r
        struct[0].Gy_ini[363,30] = i_load_R16_a_i
        struct[0].Gy_ini[363,31] = -i_load_R16_a_r
        struct[0].Gy_ini[363,360] = v_R16_a_i - v_R16_n_i
        struct[0].Gy_ini[363,361] = -v_R16_a_r + v_R16_n_r
        struct[0].Gy_ini[364,26] = -i_load_R16_b_i
        struct[0].Gy_ini[364,27] = i_load_R16_b_r
        struct[0].Gy_ini[364,30] = i_load_R16_b_i
        struct[0].Gy_ini[364,31] = -i_load_R16_b_r
        struct[0].Gy_ini[364,362] = v_R16_b_i - v_R16_n_i
        struct[0].Gy_ini[364,363] = -v_R16_b_r + v_R16_n_r
        struct[0].Gy_ini[365,28] = -i_load_R16_c_i
        struct[0].Gy_ini[365,29] = i_load_R16_c_r
        struct[0].Gy_ini[365,30] = i_load_R16_c_i
        struct[0].Gy_ini[365,31] = -i_load_R16_c_r
        struct[0].Gy_ini[365,364] = v_R16_c_i - v_R16_n_i
        struct[0].Gy_ini[365,365] = -v_R16_c_r + v_R16_n_r
        struct[0].Gy_ini[368,32] = i_load_R17_a_r
        struct[0].Gy_ini[368,33] = i_load_R17_a_i
        struct[0].Gy_ini[368,38] = -i_load_R17_a_r
        struct[0].Gy_ini[368,39] = -i_load_R17_a_i
        struct[0].Gy_ini[368,368] = v_R17_a_r - v_R17_n_r
        struct[0].Gy_ini[368,369] = v_R17_a_i - v_R17_n_i
        struct[0].Gy_ini[369,34] = i_load_R17_b_r
        struct[0].Gy_ini[369,35] = i_load_R17_b_i
        struct[0].Gy_ini[369,38] = -i_load_R17_b_r
        struct[0].Gy_ini[369,39] = -i_load_R17_b_i
        struct[0].Gy_ini[369,370] = v_R17_b_r - v_R17_n_r
        struct[0].Gy_ini[369,371] = v_R17_b_i - v_R17_n_i
        struct[0].Gy_ini[370,36] = i_load_R17_c_r
        struct[0].Gy_ini[370,37] = i_load_R17_c_i
        struct[0].Gy_ini[370,38] = -i_load_R17_c_r
        struct[0].Gy_ini[370,39] = -i_load_R17_c_i
        struct[0].Gy_ini[370,372] = v_R17_c_r - v_R17_n_r
        struct[0].Gy_ini[370,373] = v_R17_c_i - v_R17_n_i
        struct[0].Gy_ini[371,32] = -i_load_R17_a_i
        struct[0].Gy_ini[371,33] = i_load_R17_a_r
        struct[0].Gy_ini[371,38] = i_load_R17_a_i
        struct[0].Gy_ini[371,39] = -i_load_R17_a_r
        struct[0].Gy_ini[371,368] = v_R17_a_i - v_R17_n_i
        struct[0].Gy_ini[371,369] = -v_R17_a_r + v_R17_n_r
        struct[0].Gy_ini[372,34] = -i_load_R17_b_i
        struct[0].Gy_ini[372,35] = i_load_R17_b_r
        struct[0].Gy_ini[372,38] = i_load_R17_b_i
        struct[0].Gy_ini[372,39] = -i_load_R17_b_r
        struct[0].Gy_ini[372,370] = v_R17_b_i - v_R17_n_i
        struct[0].Gy_ini[372,371] = -v_R17_b_r + v_R17_n_r
        struct[0].Gy_ini[373,36] = -i_load_R17_c_i
        struct[0].Gy_ini[373,37] = i_load_R17_c_r
        struct[0].Gy_ini[373,38] = i_load_R17_c_i
        struct[0].Gy_ini[373,39] = -i_load_R17_c_r
        struct[0].Gy_ini[373,372] = v_R17_c_i - v_R17_n_i
        struct[0].Gy_ini[373,373] = -v_R17_c_r + v_R17_n_r
        struct[0].Gy_ini[376,40] = i_load_R18_a_r
        struct[0].Gy_ini[376,41] = i_load_R18_a_i
        struct[0].Gy_ini[376,46] = -i_load_R18_a_r
        struct[0].Gy_ini[376,47] = -i_load_R18_a_i
        struct[0].Gy_ini[376,376] = v_R18_a_r - v_R18_n_r
        struct[0].Gy_ini[376,377] = v_R18_a_i - v_R18_n_i
        struct[0].Gy_ini[377,42] = i_load_R18_b_r
        struct[0].Gy_ini[377,43] = i_load_R18_b_i
        struct[0].Gy_ini[377,46] = -i_load_R18_b_r
        struct[0].Gy_ini[377,47] = -i_load_R18_b_i
        struct[0].Gy_ini[377,378] = v_R18_b_r - v_R18_n_r
        struct[0].Gy_ini[377,379] = v_R18_b_i - v_R18_n_i
        struct[0].Gy_ini[378,44] = i_load_R18_c_r
        struct[0].Gy_ini[378,45] = i_load_R18_c_i
        struct[0].Gy_ini[378,46] = -i_load_R18_c_r
        struct[0].Gy_ini[378,47] = -i_load_R18_c_i
        struct[0].Gy_ini[378,380] = v_R18_c_r - v_R18_n_r
        struct[0].Gy_ini[378,381] = v_R18_c_i - v_R18_n_i
        struct[0].Gy_ini[379,40] = -i_load_R18_a_i
        struct[0].Gy_ini[379,41] = i_load_R18_a_r
        struct[0].Gy_ini[379,46] = i_load_R18_a_i
        struct[0].Gy_ini[379,47] = -i_load_R18_a_r
        struct[0].Gy_ini[379,376] = v_R18_a_i - v_R18_n_i
        struct[0].Gy_ini[379,377] = -v_R18_a_r + v_R18_n_r
        struct[0].Gy_ini[380,42] = -i_load_R18_b_i
        struct[0].Gy_ini[380,43] = i_load_R18_b_r
        struct[0].Gy_ini[380,46] = i_load_R18_b_i
        struct[0].Gy_ini[380,47] = -i_load_R18_b_r
        struct[0].Gy_ini[380,378] = v_R18_b_i - v_R18_n_i
        struct[0].Gy_ini[380,379] = -v_R18_b_r + v_R18_n_r
        struct[0].Gy_ini[381,44] = -i_load_R18_c_i
        struct[0].Gy_ini[381,45] = i_load_R18_c_r
        struct[0].Gy_ini[381,46] = i_load_R18_c_i
        struct[0].Gy_ini[381,47] = -i_load_R18_c_r
        struct[0].Gy_ini[381,380] = v_R18_c_i - v_R18_n_i
        struct[0].Gy_ini[381,381] = -v_R18_c_r + v_R18_n_r
        struct[0].Gy_ini[384,48] = i_load_D15_a_r
        struct[0].Gy_ini[384,49] = 1.0*i_load_D15_a_i
        struct[0].Gy_ini[384,50] = -i_load_D15_a_r
        struct[0].Gy_ini[384,51] = -1.0*i_load_D15_a_i
        struct[0].Gy_ini[384,384] = v_D15_a_r - v_D15_n_r
        struct[0].Gy_ini[384,385] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy_ini[385,48] = -1.0*i_load_D15_a_i
        struct[0].Gy_ini[385,49] = 1.0*i_load_D15_a_r
        struct[0].Gy_ini[385,50] = 1.0*i_load_D15_a_i
        struct[0].Gy_ini[385,51] = -1.0*i_load_D15_a_r
        struct[0].Gy_ini[385,384] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy_ini[385,385] = -1.0*v_D15_a_r + 1.0*v_D15_n_r
        struct[0].Gy_ini[388,52] = i_load_D11_a_r
        struct[0].Gy_ini[388,53] = 1.0*i_load_D11_a_i
        struct[0].Gy_ini[388,54] = -i_load_D11_a_r
        struct[0].Gy_ini[388,55] = -1.0*i_load_D11_a_i
        struct[0].Gy_ini[388,388] = v_D11_a_r - v_D11_n_r
        struct[0].Gy_ini[388,389] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy_ini[389,52] = -1.0*i_load_D11_a_i
        struct[0].Gy_ini[389,53] = 1.0*i_load_D11_a_r
        struct[0].Gy_ini[389,54] = 1.0*i_load_D11_a_i
        struct[0].Gy_ini[389,55] = -1.0*i_load_D11_a_r
        struct[0].Gy_ini[389,388] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy_ini[389,389] = -1.0*v_D11_a_r + 1.0*v_D11_n_r
        struct[0].Gy_ini[392,56] = i_load_D16_a_r
        struct[0].Gy_ini[392,57] = 1.0*i_load_D16_a_i
        struct[0].Gy_ini[392,58] = -i_load_D16_a_r
        struct[0].Gy_ini[392,59] = -1.0*i_load_D16_a_i
        struct[0].Gy_ini[392,392] = v_D16_a_r - v_D16_n_r
        struct[0].Gy_ini[392,393] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy_ini[393,56] = -1.0*i_load_D16_a_i
        struct[0].Gy_ini[393,57] = 1.0*i_load_D16_a_r
        struct[0].Gy_ini[393,58] = 1.0*i_load_D16_a_i
        struct[0].Gy_ini[393,59] = -1.0*i_load_D16_a_r
        struct[0].Gy_ini[393,392] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy_ini[393,393] = -1.0*v_D16_a_r + 1.0*v_D16_n_r
        struct[0].Gy_ini[396,60] = i_load_D17_a_r
        struct[0].Gy_ini[396,61] = 1.0*i_load_D17_a_i
        struct[0].Gy_ini[396,62] = -i_load_D17_a_r
        struct[0].Gy_ini[396,63] = -1.0*i_load_D17_a_i
        struct[0].Gy_ini[396,396] = v_D17_a_r - v_D17_n_r
        struct[0].Gy_ini[396,397] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy_ini[397,60] = -1.0*i_load_D17_a_i
        struct[0].Gy_ini[397,61] = 1.0*i_load_D17_a_r
        struct[0].Gy_ini[397,62] = 1.0*i_load_D17_a_i
        struct[0].Gy_ini[397,63] = -1.0*i_load_D17_a_r
        struct[0].Gy_ini[397,396] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy_ini[397,397] = -1.0*v_D17_a_r + 1.0*v_D17_n_r
        struct[0].Gy_ini[400,64] = i_load_D18_a_r
        struct[0].Gy_ini[400,65] = 1.0*i_load_D18_a_i
        struct[0].Gy_ini[400,66] = -i_load_D18_a_r
        struct[0].Gy_ini[400,67] = -1.0*i_load_D18_a_i
        struct[0].Gy_ini[400,400] = v_D18_a_r - v_D18_n_r
        struct[0].Gy_ini[400,401] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy_ini[401,64] = -1.0*i_load_D18_a_i
        struct[0].Gy_ini[401,65] = 1.0*i_load_D18_a_r
        struct[0].Gy_ini[401,66] = 1.0*i_load_D18_a_i
        struct[0].Gy_ini[401,67] = -1.0*i_load_D18_a_r
        struct[0].Gy_ini[401,400] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy_ini[401,401] = -1.0*v_D18_a_r + 1.0*v_D18_n_r
        struct[0].Gy_ini[404,0] = i_vsc_R1_a_r
        struct[0].Gy_ini[404,1] = 1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[404,6] = -i_vsc_R1_a_r
        struct[0].Gy_ini[404,7] = -1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[404,404] = v_R1_a_r - v_R1_n_r
        struct[0].Gy_ini[404,405] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[405,0] = -1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[405,1] = 1.0*i_vsc_R1_a_r
        struct[0].Gy_ini[405,6] = 1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[405,7] = -1.0*i_vsc_R1_a_r
        struct[0].Gy_ini[405,404] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[405,405] = -1.0*v_R1_a_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[406,2] = i_vsc_R1_b_r
        struct[0].Gy_ini[406,3] = 1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[406,6] = -i_vsc_R1_b_r
        struct[0].Gy_ini[406,7] = -1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[406,406] = v_R1_b_r - v_R1_n_r
        struct[0].Gy_ini[406,407] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[407,2] = -1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[407,3] = 1.0*i_vsc_R1_b_r
        struct[0].Gy_ini[407,6] = 1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[407,7] = -1.0*i_vsc_R1_b_r
        struct[0].Gy_ini[407,406] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[407,407] = -1.0*v_R1_b_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[408,4] = i_vsc_R1_c_r
        struct[0].Gy_ini[408,5] = 1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[408,6] = -i_vsc_R1_c_r
        struct[0].Gy_ini[408,7] = -1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[408,408] = v_R1_c_r - v_R1_n_r
        struct[0].Gy_ini[408,409] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[409,4] = -1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[409,5] = 1.0*i_vsc_R1_c_r
        struct[0].Gy_ini[409,6] = 1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[409,7] = -1.0*i_vsc_R1_c_r
        struct[0].Gy_ini[409,408] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[409,409] = -1.0*v_R1_c_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[410,412] = Piecewise(np.array([(-1, p_D1 < 0), (1, True)]))
        struct[0].Gy_ini[411,248] = v_D1_a_r
        struct[0].Gy_ini[411,254] = v_D1_n_r
        struct[0].Gy_ini[412,404] = -b_R1*i_vsc_R1_a_r/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_r
        struct[0].Gy_ini[412,405] = -b_R1*i_vsc_R1_a_i/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_i
        struct[0].Gy_ini[413,132] = i_vsc_R10_a_r
        struct[0].Gy_ini[413,133] = 1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[413,138] = -i_vsc_R10_a_r
        struct[0].Gy_ini[413,139] = -1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[413,413] = v_R10_a_r - v_R10_n_r
        struct[0].Gy_ini[413,414] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[414,132] = -1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[414,133] = 1.0*i_vsc_R10_a_r
        struct[0].Gy_ini[414,138] = 1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[414,139] = -1.0*i_vsc_R10_a_r
        struct[0].Gy_ini[414,413] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[414,414] = -1.0*v_R10_a_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[415,134] = i_vsc_R10_b_r
        struct[0].Gy_ini[415,135] = 1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[415,138] = -i_vsc_R10_b_r
        struct[0].Gy_ini[415,139] = -1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[415,415] = v_R10_b_r - v_R10_n_r
        struct[0].Gy_ini[415,416] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[416,134] = -1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[416,135] = 1.0*i_vsc_R10_b_r
        struct[0].Gy_ini[416,138] = 1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[416,139] = -1.0*i_vsc_R10_b_r
        struct[0].Gy_ini[416,415] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[416,416] = -1.0*v_R10_b_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[417,136] = i_vsc_R10_c_r
        struct[0].Gy_ini[417,137] = 1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[417,138] = -i_vsc_R10_c_r
        struct[0].Gy_ini[417,139] = -1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[417,417] = v_R10_c_r - v_R10_n_r
        struct[0].Gy_ini[417,418] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[418,136] = -1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[418,137] = 1.0*i_vsc_R10_c_r
        struct[0].Gy_ini[418,138] = 1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[418,139] = -1.0*i_vsc_R10_c_r
        struct[0].Gy_ini[418,417] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[418,418] = -1.0*v_R10_c_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[419,198] = -p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[419,204] = p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[419,421] = 1/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].Gy_ini[420,198] = p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[420,204] = -p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[420,421] = 1/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].Gy_ini[421,422] = -Piecewise(np.array([(-1, p_D10 < 0), (1, True)]))
        struct[0].Gy_ini[422,413] = -b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_r
        struct[0].Gy_ini[422,414] = -b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_i
        struct[0].Gy_ini[423,156] = i_vsc_R14_a_r
        struct[0].Gy_ini[423,157] = 1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[423,162] = -i_vsc_R14_a_r
        struct[0].Gy_ini[423,163] = -1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[423,423] = v_R14_a_r - v_R14_n_r
        struct[0].Gy_ini[423,424] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[424,156] = -1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[424,157] = 1.0*i_vsc_R14_a_r
        struct[0].Gy_ini[424,162] = 1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[424,163] = -1.0*i_vsc_R14_a_r
        struct[0].Gy_ini[424,423] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[424,424] = -1.0*v_R14_a_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[425,158] = i_vsc_R14_b_r
        struct[0].Gy_ini[425,159] = 1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[425,162] = -i_vsc_R14_b_r
        struct[0].Gy_ini[425,163] = -1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[425,425] = v_R14_b_r - v_R14_n_r
        struct[0].Gy_ini[425,426] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[426,158] = -1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[426,159] = 1.0*i_vsc_R14_b_r
        struct[0].Gy_ini[426,162] = 1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[426,163] = -1.0*i_vsc_R14_b_r
        struct[0].Gy_ini[426,425] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[426,426] = -1.0*v_R14_b_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[427,160] = i_vsc_R14_c_r
        struct[0].Gy_ini[427,161] = 1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[427,162] = -i_vsc_R14_c_r
        struct[0].Gy_ini[427,163] = -1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[427,427] = v_R14_c_r - v_R14_n_r
        struct[0].Gy_ini[427,428] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[428,160] = -1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[428,161] = 1.0*i_vsc_R14_c_r
        struct[0].Gy_ini[428,162] = 1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[428,163] = -1.0*i_vsc_R14_c_r
        struct[0].Gy_ini[428,427] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[428,428] = -1.0*v_R14_c_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[429,222] = -p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[429,228] = p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[429,431] = 1/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].Gy_ini[430,222] = p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[430,228] = -p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[430,431] = 1/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].Gy_ini[431,432] = -Piecewise(np.array([(-1, p_D14 < 0), (1, True)]))
        struct[0].Gy_ini[432,423] = -b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_r
        struct[0].Gy_ini[432,424] = -b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_i



@numba.njit(cache=True)
def run(t,struct,mode):

    # Parameters:
    a_R1 = struct[0].a_R1
    b_R1 = struct[0].b_R1
    c_R1 = struct[0].c_R1
    a_R10 = struct[0].a_R10
    b_R10 = struct[0].b_R10
    c_R10 = struct[0].c_R10
    coef_a_R10 = struct[0].coef_a_R10
    coef_b_R10 = struct[0].coef_b_R10
    coef_c_R10 = struct[0].coef_c_R10
    a_R14 = struct[0].a_R14
    b_R14 = struct[0].b_R14
    c_R14 = struct[0].c_R14
    coef_a_R14 = struct[0].coef_a_R14
    coef_b_R14 = struct[0].coef_b_R14
    coef_c_R14 = struct[0].coef_c_R14
    
    # Inputs:
    v_R0_a_r = struct[0].v_R0_a_r
    v_R0_a_i = struct[0].v_R0_a_i
    v_R0_b_r = struct[0].v_R0_b_r
    v_R0_b_i = struct[0].v_R0_b_i
    v_R0_c_r = struct[0].v_R0_c_r
    v_R0_c_i = struct[0].v_R0_c_i
    v_D1_a_r = struct[0].v_D1_a_r
    v_D1_a_i = struct[0].v_D1_a_i
    v_D1_b_r = struct[0].v_D1_b_r
    v_D1_b_i = struct[0].v_D1_b_i
    v_D1_c_r = struct[0].v_D1_c_r
    v_D1_c_i = struct[0].v_D1_c_i
    i_R1_n_r = struct[0].i_R1_n_r
    i_R1_n_i = struct[0].i_R1_n_i
    i_R11_n_r = struct[0].i_R11_n_r
    i_R11_n_i = struct[0].i_R11_n_i
    i_R15_n_r = struct[0].i_R15_n_r
    i_R15_n_i = struct[0].i_R15_n_i
    i_R16_n_r = struct[0].i_R16_n_r
    i_R16_n_i = struct[0].i_R16_n_i
    i_R17_n_r = struct[0].i_R17_n_r
    i_R17_n_i = struct[0].i_R17_n_i
    i_R18_n_r = struct[0].i_R18_n_r
    i_R18_n_i = struct[0].i_R18_n_i
    i_R2_a_r = struct[0].i_R2_a_r
    i_R2_a_i = struct[0].i_R2_a_i
    i_R2_b_r = struct[0].i_R2_b_r
    i_R2_b_i = struct[0].i_R2_b_i
    i_R2_c_r = struct[0].i_R2_c_r
    i_R2_c_i = struct[0].i_R2_c_i
    i_R2_n_r = struct[0].i_R2_n_r
    i_R2_n_i = struct[0].i_R2_n_i
    i_R3_a_r = struct[0].i_R3_a_r
    i_R3_a_i = struct[0].i_R3_a_i
    i_R3_b_r = struct[0].i_R3_b_r
    i_R3_b_i = struct[0].i_R3_b_i
    i_R3_c_r = struct[0].i_R3_c_r
    i_R3_c_i = struct[0].i_R3_c_i
    i_R3_n_r = struct[0].i_R3_n_r
    i_R3_n_i = struct[0].i_R3_n_i
    i_R4_a_r = struct[0].i_R4_a_r
    i_R4_a_i = struct[0].i_R4_a_i
    i_R4_b_r = struct[0].i_R4_b_r
    i_R4_b_i = struct[0].i_R4_b_i
    i_R4_c_r = struct[0].i_R4_c_r
    i_R4_c_i = struct[0].i_R4_c_i
    i_R4_n_r = struct[0].i_R4_n_r
    i_R4_n_i = struct[0].i_R4_n_i
    i_R5_a_r = struct[0].i_R5_a_r
    i_R5_a_i = struct[0].i_R5_a_i
    i_R5_b_r = struct[0].i_R5_b_r
    i_R5_b_i = struct[0].i_R5_b_i
    i_R5_c_r = struct[0].i_R5_c_r
    i_R5_c_i = struct[0].i_R5_c_i
    i_R5_n_r = struct[0].i_R5_n_r
    i_R5_n_i = struct[0].i_R5_n_i
    i_R6_a_r = struct[0].i_R6_a_r
    i_R6_a_i = struct[0].i_R6_a_i
    i_R6_b_r = struct[0].i_R6_b_r
    i_R6_b_i = struct[0].i_R6_b_i
    i_R6_c_r = struct[0].i_R6_c_r
    i_R6_c_i = struct[0].i_R6_c_i
    i_R6_n_r = struct[0].i_R6_n_r
    i_R6_n_i = struct[0].i_R6_n_i
    i_R7_a_r = struct[0].i_R7_a_r
    i_R7_a_i = struct[0].i_R7_a_i
    i_R7_b_r = struct[0].i_R7_b_r
    i_R7_b_i = struct[0].i_R7_b_i
    i_R7_c_r = struct[0].i_R7_c_r
    i_R7_c_i = struct[0].i_R7_c_i
    i_R7_n_r = struct[0].i_R7_n_r
    i_R7_n_i = struct[0].i_R7_n_i
    i_R8_a_r = struct[0].i_R8_a_r
    i_R8_a_i = struct[0].i_R8_a_i
    i_R8_b_r = struct[0].i_R8_b_r
    i_R8_b_i = struct[0].i_R8_b_i
    i_R8_c_r = struct[0].i_R8_c_r
    i_R8_c_i = struct[0].i_R8_c_i
    i_R8_n_r = struct[0].i_R8_n_r
    i_R8_n_i = struct[0].i_R8_n_i
    i_R9_a_r = struct[0].i_R9_a_r
    i_R9_a_i = struct[0].i_R9_a_i
    i_R9_b_r = struct[0].i_R9_b_r
    i_R9_b_i = struct[0].i_R9_b_i
    i_R9_c_r = struct[0].i_R9_c_r
    i_R9_c_i = struct[0].i_R9_c_i
    i_R9_n_r = struct[0].i_R9_n_r
    i_R9_n_i = struct[0].i_R9_n_i
    i_R10_a_r = struct[0].i_R10_a_r
    i_R10_a_i = struct[0].i_R10_a_i
    i_R10_b_r = struct[0].i_R10_b_r
    i_R10_b_i = struct[0].i_R10_b_i
    i_R10_c_r = struct[0].i_R10_c_r
    i_R10_c_i = struct[0].i_R10_c_i
    i_R10_n_r = struct[0].i_R10_n_r
    i_R10_n_i = struct[0].i_R10_n_i
    i_R12_a_r = struct[0].i_R12_a_r
    i_R12_a_i = struct[0].i_R12_a_i
    i_R12_b_r = struct[0].i_R12_b_r
    i_R12_b_i = struct[0].i_R12_b_i
    i_R12_c_r = struct[0].i_R12_c_r
    i_R12_c_i = struct[0].i_R12_c_i
    i_R12_n_r = struct[0].i_R12_n_r
    i_R12_n_i = struct[0].i_R12_n_i
    i_R13_a_r = struct[0].i_R13_a_r
    i_R13_a_i = struct[0].i_R13_a_i
    i_R13_b_r = struct[0].i_R13_b_r
    i_R13_b_i = struct[0].i_R13_b_i
    i_R13_c_r = struct[0].i_R13_c_r
    i_R13_c_i = struct[0].i_R13_c_i
    i_R13_n_r = struct[0].i_R13_n_r
    i_R13_n_i = struct[0].i_R13_n_i
    i_R14_a_r = struct[0].i_R14_a_r
    i_R14_a_i = struct[0].i_R14_a_i
    i_R14_b_r = struct[0].i_R14_b_r
    i_R14_b_i = struct[0].i_R14_b_i
    i_R14_c_r = struct[0].i_R14_c_r
    i_R14_c_i = struct[0].i_R14_c_i
    i_R14_n_r = struct[0].i_R14_n_r
    i_R14_n_i = struct[0].i_R14_n_i
    i_D1_n_r = struct[0].i_D1_n_r
    i_D1_n_i = struct[0].i_D1_n_i
    i_D3_a_r = struct[0].i_D3_a_r
    i_D3_a_i = struct[0].i_D3_a_i
    i_D3_b_r = struct[0].i_D3_b_r
    i_D3_b_i = struct[0].i_D3_b_i
    i_D3_c_r = struct[0].i_D3_c_r
    i_D3_c_i = struct[0].i_D3_c_i
    i_D3_n_r = struct[0].i_D3_n_r
    i_D3_n_i = struct[0].i_D3_n_i
    i_D4_a_r = struct[0].i_D4_a_r
    i_D4_a_i = struct[0].i_D4_a_i
    i_D4_b_r = struct[0].i_D4_b_r
    i_D4_b_i = struct[0].i_D4_b_i
    i_D4_c_r = struct[0].i_D4_c_r
    i_D4_c_i = struct[0].i_D4_c_i
    i_D4_n_r = struct[0].i_D4_n_r
    i_D4_n_i = struct[0].i_D4_n_i
    i_D6_a_r = struct[0].i_D6_a_r
    i_D6_a_i = struct[0].i_D6_a_i
    i_D6_b_r = struct[0].i_D6_b_r
    i_D6_b_i = struct[0].i_D6_b_i
    i_D6_c_r = struct[0].i_D6_c_r
    i_D6_c_i = struct[0].i_D6_c_i
    i_D6_n_r = struct[0].i_D6_n_r
    i_D6_n_i = struct[0].i_D6_n_i
    i_D9_a_r = struct[0].i_D9_a_r
    i_D9_a_i = struct[0].i_D9_a_i
    i_D9_b_r = struct[0].i_D9_b_r
    i_D9_b_i = struct[0].i_D9_b_i
    i_D9_c_r = struct[0].i_D9_c_r
    i_D9_c_i = struct[0].i_D9_c_i
    i_D9_n_r = struct[0].i_D9_n_r
    i_D9_n_i = struct[0].i_D9_n_i
    i_D10_a_i = struct[0].i_D10_a_i
    i_D10_b_r = struct[0].i_D10_b_r
    i_D10_b_i = struct[0].i_D10_b_i
    i_D10_c_r = struct[0].i_D10_c_r
    i_D10_c_i = struct[0].i_D10_c_i
    i_D10_n_i = struct[0].i_D10_n_i
    i_D11_b_r = struct[0].i_D11_b_r
    i_D11_b_i = struct[0].i_D11_b_i
    i_D11_c_r = struct[0].i_D11_c_r
    i_D11_c_i = struct[0].i_D11_c_i
    i_D16_b_r = struct[0].i_D16_b_r
    i_D16_b_i = struct[0].i_D16_b_i
    i_D16_c_r = struct[0].i_D16_c_r
    i_D16_c_i = struct[0].i_D16_c_i
    i_D17_b_r = struct[0].i_D17_b_r
    i_D17_b_i = struct[0].i_D17_b_i
    i_D17_c_r = struct[0].i_D17_c_r
    i_D17_c_i = struct[0].i_D17_c_i
    i_D18_b_r = struct[0].i_D18_b_r
    i_D18_b_i = struct[0].i_D18_b_i
    i_D18_c_r = struct[0].i_D18_c_r
    i_D18_c_i = struct[0].i_D18_c_i
    i_D14_a_i = struct[0].i_D14_a_i
    i_D14_b_r = struct[0].i_D14_b_r
    i_D14_b_i = struct[0].i_D14_b_i
    i_D14_c_r = struct[0].i_D14_c_r
    i_D14_c_i = struct[0].i_D14_c_i
    i_D14_n_i = struct[0].i_D14_n_i
    i_D15_b_r = struct[0].i_D15_b_r
    i_D15_b_i = struct[0].i_D15_b_i
    i_D15_c_r = struct[0].i_D15_c_r
    i_D15_c_i = struct[0].i_D15_c_i
    p_R1_a = struct[0].p_R1_a
    q_R1_a = struct[0].q_R1_a
    p_R1_b = struct[0].p_R1_b
    q_R1_b = struct[0].q_R1_b
    p_R1_c = struct[0].p_R1_c
    q_R1_c = struct[0].q_R1_c
    p_R11_a = struct[0].p_R11_a
    q_R11_a = struct[0].q_R11_a
    p_R11_b = struct[0].p_R11_b
    q_R11_b = struct[0].q_R11_b
    p_R11_c = struct[0].p_R11_c
    q_R11_c = struct[0].q_R11_c
    p_R15_a = struct[0].p_R15_a
    q_R15_a = struct[0].q_R15_a
    p_R15_b = struct[0].p_R15_b
    q_R15_b = struct[0].q_R15_b
    p_R15_c = struct[0].p_R15_c
    q_R15_c = struct[0].q_R15_c
    p_R16_a = struct[0].p_R16_a
    q_R16_a = struct[0].q_R16_a
    p_R16_b = struct[0].p_R16_b
    q_R16_b = struct[0].q_R16_b
    p_R16_c = struct[0].p_R16_c
    q_R16_c = struct[0].q_R16_c
    p_R17_a = struct[0].p_R17_a
    q_R17_a = struct[0].q_R17_a
    p_R17_b = struct[0].p_R17_b
    q_R17_b = struct[0].q_R17_b
    p_R17_c = struct[0].p_R17_c
    q_R17_c = struct[0].q_R17_c
    p_R18_a = struct[0].p_R18_a
    q_R18_a = struct[0].q_R18_a
    p_R18_b = struct[0].p_R18_b
    q_R18_b = struct[0].q_R18_b
    p_R18_c = struct[0].p_R18_c
    q_R18_c = struct[0].q_R18_c
    p_D15_1 = struct[0].p_D15_1
    q_D15_1 = struct[0].q_D15_1
    p_D11_1 = struct[0].p_D11_1
    q_D11_1 = struct[0].q_D11_1
    p_D16_1 = struct[0].p_D16_1
    q_D16_1 = struct[0].q_D16_1
    p_D17_1 = struct[0].p_D17_1
    q_D17_1 = struct[0].q_D17_1
    p_D18_1 = struct[0].p_D18_1
    q_D18_1 = struct[0].q_D18_1
    v_dc_D1 = struct[0].v_dc_D1
    q_R1 = struct[0].q_R1
    p_R10 = struct[0].p_R10
    q_R10 = struct[0].q_R10
    p_R14 = struct[0].p_R14
    q_R14 = struct[0].q_R14
    u_dummy = struct[0].u_dummy
    
    # Dynamical states:
    x_dummy = struct[0].x[0,0]
    
    # Algebraic states:
    v_R1_a_r = struct[0].y_run[0,0]
    v_R1_a_i = struct[0].y_run[1,0]
    v_R1_b_r = struct[0].y_run[2,0]
    v_R1_b_i = struct[0].y_run[3,0]
    v_R1_c_r = struct[0].y_run[4,0]
    v_R1_c_i = struct[0].y_run[5,0]
    v_R1_n_r = struct[0].y_run[6,0]
    v_R1_n_i = struct[0].y_run[7,0]
    v_R11_a_r = struct[0].y_run[8,0]
    v_R11_a_i = struct[0].y_run[9,0]
    v_R11_b_r = struct[0].y_run[10,0]
    v_R11_b_i = struct[0].y_run[11,0]
    v_R11_c_r = struct[0].y_run[12,0]
    v_R11_c_i = struct[0].y_run[13,0]
    v_R11_n_r = struct[0].y_run[14,0]
    v_R11_n_i = struct[0].y_run[15,0]
    v_R15_a_r = struct[0].y_run[16,0]
    v_R15_a_i = struct[0].y_run[17,0]
    v_R15_b_r = struct[0].y_run[18,0]
    v_R15_b_i = struct[0].y_run[19,0]
    v_R15_c_r = struct[0].y_run[20,0]
    v_R15_c_i = struct[0].y_run[21,0]
    v_R15_n_r = struct[0].y_run[22,0]
    v_R15_n_i = struct[0].y_run[23,0]
    v_R16_a_r = struct[0].y_run[24,0]
    v_R16_a_i = struct[0].y_run[25,0]
    v_R16_b_r = struct[0].y_run[26,0]
    v_R16_b_i = struct[0].y_run[27,0]
    v_R16_c_r = struct[0].y_run[28,0]
    v_R16_c_i = struct[0].y_run[29,0]
    v_R16_n_r = struct[0].y_run[30,0]
    v_R16_n_i = struct[0].y_run[31,0]
    v_R17_a_r = struct[0].y_run[32,0]
    v_R17_a_i = struct[0].y_run[33,0]
    v_R17_b_r = struct[0].y_run[34,0]
    v_R17_b_i = struct[0].y_run[35,0]
    v_R17_c_r = struct[0].y_run[36,0]
    v_R17_c_i = struct[0].y_run[37,0]
    v_R17_n_r = struct[0].y_run[38,0]
    v_R17_n_i = struct[0].y_run[39,0]
    v_R18_a_r = struct[0].y_run[40,0]
    v_R18_a_i = struct[0].y_run[41,0]
    v_R18_b_r = struct[0].y_run[42,0]
    v_R18_b_i = struct[0].y_run[43,0]
    v_R18_c_r = struct[0].y_run[44,0]
    v_R18_c_i = struct[0].y_run[45,0]
    v_R18_n_r = struct[0].y_run[46,0]
    v_R18_n_i = struct[0].y_run[47,0]
    v_D15_a_r = struct[0].y_run[48,0]
    v_D15_a_i = struct[0].y_run[49,0]
    v_D15_n_r = struct[0].y_run[50,0]
    v_D15_n_i = struct[0].y_run[51,0]
    v_D11_a_r = struct[0].y_run[52,0]
    v_D11_a_i = struct[0].y_run[53,0]
    v_D11_n_r = struct[0].y_run[54,0]
    v_D11_n_i = struct[0].y_run[55,0]
    v_D16_a_r = struct[0].y_run[56,0]
    v_D16_a_i = struct[0].y_run[57,0]
    v_D16_n_r = struct[0].y_run[58,0]
    v_D16_n_i = struct[0].y_run[59,0]
    v_D17_a_r = struct[0].y_run[60,0]
    v_D17_a_i = struct[0].y_run[61,0]
    v_D17_n_r = struct[0].y_run[62,0]
    v_D17_n_i = struct[0].y_run[63,0]
    v_D18_a_r = struct[0].y_run[64,0]
    v_D18_a_i = struct[0].y_run[65,0]
    v_D18_n_r = struct[0].y_run[66,0]
    v_D18_n_i = struct[0].y_run[67,0]
    v_R2_a_r = struct[0].y_run[68,0]
    v_R2_a_i = struct[0].y_run[69,0]
    v_R2_b_r = struct[0].y_run[70,0]
    v_R2_b_i = struct[0].y_run[71,0]
    v_R2_c_r = struct[0].y_run[72,0]
    v_R2_c_i = struct[0].y_run[73,0]
    v_R2_n_r = struct[0].y_run[74,0]
    v_R2_n_i = struct[0].y_run[75,0]
    v_R3_a_r = struct[0].y_run[76,0]
    v_R3_a_i = struct[0].y_run[77,0]
    v_R3_b_r = struct[0].y_run[78,0]
    v_R3_b_i = struct[0].y_run[79,0]
    v_R3_c_r = struct[0].y_run[80,0]
    v_R3_c_i = struct[0].y_run[81,0]
    v_R3_n_r = struct[0].y_run[82,0]
    v_R3_n_i = struct[0].y_run[83,0]
    v_R4_a_r = struct[0].y_run[84,0]
    v_R4_a_i = struct[0].y_run[85,0]
    v_R4_b_r = struct[0].y_run[86,0]
    v_R4_b_i = struct[0].y_run[87,0]
    v_R4_c_r = struct[0].y_run[88,0]
    v_R4_c_i = struct[0].y_run[89,0]
    v_R4_n_r = struct[0].y_run[90,0]
    v_R4_n_i = struct[0].y_run[91,0]
    v_R5_a_r = struct[0].y_run[92,0]
    v_R5_a_i = struct[0].y_run[93,0]
    v_R5_b_r = struct[0].y_run[94,0]
    v_R5_b_i = struct[0].y_run[95,0]
    v_R5_c_r = struct[0].y_run[96,0]
    v_R5_c_i = struct[0].y_run[97,0]
    v_R5_n_r = struct[0].y_run[98,0]
    v_R5_n_i = struct[0].y_run[99,0]
    v_R6_a_r = struct[0].y_run[100,0]
    v_R6_a_i = struct[0].y_run[101,0]
    v_R6_b_r = struct[0].y_run[102,0]
    v_R6_b_i = struct[0].y_run[103,0]
    v_R6_c_r = struct[0].y_run[104,0]
    v_R6_c_i = struct[0].y_run[105,0]
    v_R6_n_r = struct[0].y_run[106,0]
    v_R6_n_i = struct[0].y_run[107,0]
    v_R7_a_r = struct[0].y_run[108,0]
    v_R7_a_i = struct[0].y_run[109,0]
    v_R7_b_r = struct[0].y_run[110,0]
    v_R7_b_i = struct[0].y_run[111,0]
    v_R7_c_r = struct[0].y_run[112,0]
    v_R7_c_i = struct[0].y_run[113,0]
    v_R7_n_r = struct[0].y_run[114,0]
    v_R7_n_i = struct[0].y_run[115,0]
    v_R8_a_r = struct[0].y_run[116,0]
    v_R8_a_i = struct[0].y_run[117,0]
    v_R8_b_r = struct[0].y_run[118,0]
    v_R8_b_i = struct[0].y_run[119,0]
    v_R8_c_r = struct[0].y_run[120,0]
    v_R8_c_i = struct[0].y_run[121,0]
    v_R8_n_r = struct[0].y_run[122,0]
    v_R8_n_i = struct[0].y_run[123,0]
    v_R9_a_r = struct[0].y_run[124,0]
    v_R9_a_i = struct[0].y_run[125,0]
    v_R9_b_r = struct[0].y_run[126,0]
    v_R9_b_i = struct[0].y_run[127,0]
    v_R9_c_r = struct[0].y_run[128,0]
    v_R9_c_i = struct[0].y_run[129,0]
    v_R9_n_r = struct[0].y_run[130,0]
    v_R9_n_i = struct[0].y_run[131,0]
    v_R10_a_r = struct[0].y_run[132,0]
    v_R10_a_i = struct[0].y_run[133,0]
    v_R10_b_r = struct[0].y_run[134,0]
    v_R10_b_i = struct[0].y_run[135,0]
    v_R10_c_r = struct[0].y_run[136,0]
    v_R10_c_i = struct[0].y_run[137,0]
    v_R10_n_r = struct[0].y_run[138,0]
    v_R10_n_i = struct[0].y_run[139,0]
    v_R12_a_r = struct[0].y_run[140,0]
    v_R12_a_i = struct[0].y_run[141,0]
    v_R12_b_r = struct[0].y_run[142,0]
    v_R12_b_i = struct[0].y_run[143,0]
    v_R12_c_r = struct[0].y_run[144,0]
    v_R12_c_i = struct[0].y_run[145,0]
    v_R12_n_r = struct[0].y_run[146,0]
    v_R12_n_i = struct[0].y_run[147,0]
    v_R13_a_r = struct[0].y_run[148,0]
    v_R13_a_i = struct[0].y_run[149,0]
    v_R13_b_r = struct[0].y_run[150,0]
    v_R13_b_i = struct[0].y_run[151,0]
    v_R13_c_r = struct[0].y_run[152,0]
    v_R13_c_i = struct[0].y_run[153,0]
    v_R13_n_r = struct[0].y_run[154,0]
    v_R13_n_i = struct[0].y_run[155,0]
    v_R14_a_r = struct[0].y_run[156,0]
    v_R14_a_i = struct[0].y_run[157,0]
    v_R14_b_r = struct[0].y_run[158,0]
    v_R14_b_i = struct[0].y_run[159,0]
    v_R14_c_r = struct[0].y_run[160,0]
    v_R14_c_i = struct[0].y_run[161,0]
    v_R14_n_r = struct[0].y_run[162,0]
    v_R14_n_i = struct[0].y_run[163,0]
    v_D1_n_r = struct[0].y_run[164,0]
    v_D1_n_i = struct[0].y_run[165,0]
    v_D3_a_r = struct[0].y_run[166,0]
    v_D3_a_i = struct[0].y_run[167,0]
    v_D3_b_r = struct[0].y_run[168,0]
    v_D3_b_i = struct[0].y_run[169,0]
    v_D3_c_r = struct[0].y_run[170,0]
    v_D3_c_i = struct[0].y_run[171,0]
    v_D3_n_r = struct[0].y_run[172,0]
    v_D3_n_i = struct[0].y_run[173,0]
    v_D4_a_r = struct[0].y_run[174,0]
    v_D4_a_i = struct[0].y_run[175,0]
    v_D4_b_r = struct[0].y_run[176,0]
    v_D4_b_i = struct[0].y_run[177,0]
    v_D4_c_r = struct[0].y_run[178,0]
    v_D4_c_i = struct[0].y_run[179,0]
    v_D4_n_r = struct[0].y_run[180,0]
    v_D4_n_i = struct[0].y_run[181,0]
    v_D6_a_r = struct[0].y_run[182,0]
    v_D6_a_i = struct[0].y_run[183,0]
    v_D6_b_r = struct[0].y_run[184,0]
    v_D6_b_i = struct[0].y_run[185,0]
    v_D6_c_r = struct[0].y_run[186,0]
    v_D6_c_i = struct[0].y_run[187,0]
    v_D6_n_r = struct[0].y_run[188,0]
    v_D6_n_i = struct[0].y_run[189,0]
    v_D9_a_r = struct[0].y_run[190,0]
    v_D9_a_i = struct[0].y_run[191,0]
    v_D9_b_r = struct[0].y_run[192,0]
    v_D9_b_i = struct[0].y_run[193,0]
    v_D9_c_r = struct[0].y_run[194,0]
    v_D9_c_i = struct[0].y_run[195,0]
    v_D9_n_r = struct[0].y_run[196,0]
    v_D9_n_i = struct[0].y_run[197,0]
    v_D10_a_r = struct[0].y_run[198,0]
    v_D10_a_i = struct[0].y_run[199,0]
    v_D10_b_r = struct[0].y_run[200,0]
    v_D10_b_i = struct[0].y_run[201,0]
    v_D10_c_r = struct[0].y_run[202,0]
    v_D10_c_i = struct[0].y_run[203,0]
    v_D10_n_r = struct[0].y_run[204,0]
    v_D10_n_i = struct[0].y_run[205,0]
    v_D11_b_r = struct[0].y_run[206,0]
    v_D11_b_i = struct[0].y_run[207,0]
    v_D11_c_r = struct[0].y_run[208,0]
    v_D11_c_i = struct[0].y_run[209,0]
    v_D16_b_r = struct[0].y_run[210,0]
    v_D16_b_i = struct[0].y_run[211,0]
    v_D16_c_r = struct[0].y_run[212,0]
    v_D16_c_i = struct[0].y_run[213,0]
    v_D17_b_r = struct[0].y_run[214,0]
    v_D17_b_i = struct[0].y_run[215,0]
    v_D17_c_r = struct[0].y_run[216,0]
    v_D17_c_i = struct[0].y_run[217,0]
    v_D18_b_r = struct[0].y_run[218,0]
    v_D18_b_i = struct[0].y_run[219,0]
    v_D18_c_r = struct[0].y_run[220,0]
    v_D18_c_i = struct[0].y_run[221,0]
    v_D14_a_r = struct[0].y_run[222,0]
    v_D14_a_i = struct[0].y_run[223,0]
    v_D14_b_r = struct[0].y_run[224,0]
    v_D14_b_i = struct[0].y_run[225,0]
    v_D14_c_r = struct[0].y_run[226,0]
    v_D14_c_i = struct[0].y_run[227,0]
    v_D14_n_r = struct[0].y_run[228,0]
    v_D14_n_i = struct[0].y_run[229,0]
    v_D15_b_r = struct[0].y_run[230,0]
    v_D15_b_i = struct[0].y_run[231,0]
    v_D15_c_r = struct[0].y_run[232,0]
    v_D15_c_i = struct[0].y_run[233,0]
    i_t_R0_R1_a_r = struct[0].y_run[234,0]
    i_t_R0_R1_a_i = struct[0].y_run[235,0]
    i_t_R0_R1_b_r = struct[0].y_run[236,0]
    i_t_R0_R1_b_i = struct[0].y_run[237,0]
    i_t_R0_R1_c_r = struct[0].y_run[238,0]
    i_t_R0_R1_c_i = struct[0].y_run[239,0]
    i_l_R1_R2_a_r = struct[0].y_run[240,0]
    i_l_R1_R2_a_i = struct[0].y_run[241,0]
    i_l_R1_R2_b_r = struct[0].y_run[242,0]
    i_l_R1_R2_b_i = struct[0].y_run[243,0]
    i_l_R1_R2_c_r = struct[0].y_run[244,0]
    i_l_R1_R2_c_i = struct[0].y_run[245,0]
    i_l_R1_R2_n_r = struct[0].y_run[246,0]
    i_l_R1_R2_n_i = struct[0].y_run[247,0]
    i_l_D1_D3_a_r = struct[0].y_run[248,0]
    i_l_D1_D3_a_i = struct[0].y_run[249,0]
    i_l_D1_D3_b_r = struct[0].y_run[250,0]
    i_l_D1_D3_b_i = struct[0].y_run[251,0]
    i_l_D1_D3_c_r = struct[0].y_run[252,0]
    i_l_D1_D3_c_i = struct[0].y_run[253,0]
    i_l_D1_D3_n_r = struct[0].y_run[254,0]
    i_l_D1_D3_n_i = struct[0].y_run[255,0]
    i_l_D3_D4_a_r = struct[0].y_run[256,0]
    i_l_D3_D4_a_i = struct[0].y_run[257,0]
    i_l_D3_D4_b_r = struct[0].y_run[258,0]
    i_l_D3_D4_b_i = struct[0].y_run[259,0]
    i_l_D3_D4_c_r = struct[0].y_run[260,0]
    i_l_D3_D4_c_i = struct[0].y_run[261,0]
    i_l_D3_D4_n_r = struct[0].y_run[262,0]
    i_l_D3_D4_n_i = struct[0].y_run[263,0]
    i_l_D4_D6_a_r = struct[0].y_run[264,0]
    i_l_D4_D6_a_i = struct[0].y_run[265,0]
    i_l_D4_D6_b_r = struct[0].y_run[266,0]
    i_l_D4_D6_b_i = struct[0].y_run[267,0]
    i_l_D4_D6_c_r = struct[0].y_run[268,0]
    i_l_D4_D6_c_i = struct[0].y_run[269,0]
    i_l_D4_D6_n_r = struct[0].y_run[270,0]
    i_l_D4_D6_n_i = struct[0].y_run[271,0]
    i_l_D6_D9_a_r = struct[0].y_run[272,0]
    i_l_D6_D9_a_i = struct[0].y_run[273,0]
    i_l_D6_D9_b_r = struct[0].y_run[274,0]
    i_l_D6_D9_b_i = struct[0].y_run[275,0]
    i_l_D6_D9_c_r = struct[0].y_run[276,0]
    i_l_D6_D9_c_i = struct[0].y_run[277,0]
    i_l_D6_D9_n_r = struct[0].y_run[278,0]
    i_l_D6_D9_n_i = struct[0].y_run[279,0]
    i_l_D9_D10_a_r = struct[0].y_run[280,0]
    i_l_D9_D10_a_i = struct[0].y_run[281,0]
    i_l_D9_D10_b_r = struct[0].y_run[282,0]
    i_l_D9_D10_b_i = struct[0].y_run[283,0]
    i_l_D9_D10_c_r = struct[0].y_run[284,0]
    i_l_D9_D10_c_i = struct[0].y_run[285,0]
    i_l_D9_D10_n_r = struct[0].y_run[286,0]
    i_l_D9_D10_n_i = struct[0].y_run[287,0]
    i_l_D3_D11_a_r = struct[0].y_run[288,0]
    i_l_D3_D11_a_i = struct[0].y_run[289,0]
    i_l_D3_D11_b_r = struct[0].y_run[290,0]
    i_l_D3_D11_b_i = struct[0].y_run[291,0]
    i_l_D3_D11_c_r = struct[0].y_run[292,0]
    i_l_D3_D11_c_i = struct[0].y_run[293,0]
    i_l_D3_D11_n_r = struct[0].y_run[294,0]
    i_l_D3_D11_n_i = struct[0].y_run[295,0]
    i_l_D6_D16_a_r = struct[0].y_run[296,0]
    i_l_D6_D16_a_i = struct[0].y_run[297,0]
    i_l_D6_D16_b_r = struct[0].y_run[298,0]
    i_l_D6_D16_b_i = struct[0].y_run[299,0]
    i_l_D6_D16_c_r = struct[0].y_run[300,0]
    i_l_D6_D16_c_i = struct[0].y_run[301,0]
    i_l_D6_D16_n_r = struct[0].y_run[302,0]
    i_l_D6_D16_n_i = struct[0].y_run[303,0]
    i_l_D9_D17_a_r = struct[0].y_run[304,0]
    i_l_D9_D17_a_i = struct[0].y_run[305,0]
    i_l_D9_D17_b_r = struct[0].y_run[306,0]
    i_l_D9_D17_b_i = struct[0].y_run[307,0]
    i_l_D9_D17_c_r = struct[0].y_run[308,0]
    i_l_D9_D17_c_i = struct[0].y_run[309,0]
    i_l_D9_D17_n_r = struct[0].y_run[310,0]
    i_l_D9_D17_n_i = struct[0].y_run[311,0]
    i_l_D10_D18_a_r = struct[0].y_run[312,0]
    i_l_D10_D18_a_i = struct[0].y_run[313,0]
    i_l_D10_D18_b_r = struct[0].y_run[314,0]
    i_l_D10_D18_b_i = struct[0].y_run[315,0]
    i_l_D10_D18_c_r = struct[0].y_run[316,0]
    i_l_D10_D18_c_i = struct[0].y_run[317,0]
    i_l_D10_D18_n_r = struct[0].y_run[318,0]
    i_l_D10_D18_n_i = struct[0].y_run[319,0]
    i_l_D4_D14_a_r = struct[0].y_run[320,0]
    i_l_D4_D14_a_i = struct[0].y_run[321,0]
    i_l_D4_D14_b_r = struct[0].y_run[322,0]
    i_l_D4_D14_b_i = struct[0].y_run[323,0]
    i_l_D4_D14_c_r = struct[0].y_run[324,0]
    i_l_D4_D14_c_i = struct[0].y_run[325,0]
    i_l_D4_D14_n_r = struct[0].y_run[326,0]
    i_l_D4_D14_n_i = struct[0].y_run[327,0]
    i_l_D14_D15_a_r = struct[0].y_run[328,0]
    i_l_D14_D15_a_i = struct[0].y_run[329,0]
    i_l_D14_D15_b_r = struct[0].y_run[330,0]
    i_l_D14_D15_b_i = struct[0].y_run[331,0]
    i_l_D14_D15_c_r = struct[0].y_run[332,0]
    i_l_D14_D15_c_i = struct[0].y_run[333,0]
    i_l_D14_D15_n_r = struct[0].y_run[334,0]
    i_l_D14_D15_n_i = struct[0].y_run[335,0]
    i_load_R1_a_r = struct[0].y_run[336,0]
    i_load_R1_a_i = struct[0].y_run[337,0]
    i_load_R1_b_r = struct[0].y_run[338,0]
    i_load_R1_b_i = struct[0].y_run[339,0]
    i_load_R1_c_r = struct[0].y_run[340,0]
    i_load_R1_c_i = struct[0].y_run[341,0]
    i_load_R1_n_r = struct[0].y_run[342,0]
    i_load_R1_n_i = struct[0].y_run[343,0]
    i_load_R11_a_r = struct[0].y_run[344,0]
    i_load_R11_a_i = struct[0].y_run[345,0]
    i_load_R11_b_r = struct[0].y_run[346,0]
    i_load_R11_b_i = struct[0].y_run[347,0]
    i_load_R11_c_r = struct[0].y_run[348,0]
    i_load_R11_c_i = struct[0].y_run[349,0]
    i_load_R11_n_r = struct[0].y_run[350,0]
    i_load_R11_n_i = struct[0].y_run[351,0]
    i_load_R15_a_r = struct[0].y_run[352,0]
    i_load_R15_a_i = struct[0].y_run[353,0]
    i_load_R15_b_r = struct[0].y_run[354,0]
    i_load_R15_b_i = struct[0].y_run[355,0]
    i_load_R15_c_r = struct[0].y_run[356,0]
    i_load_R15_c_i = struct[0].y_run[357,0]
    i_load_R15_n_r = struct[0].y_run[358,0]
    i_load_R15_n_i = struct[0].y_run[359,0]
    i_load_R16_a_r = struct[0].y_run[360,0]
    i_load_R16_a_i = struct[0].y_run[361,0]
    i_load_R16_b_r = struct[0].y_run[362,0]
    i_load_R16_b_i = struct[0].y_run[363,0]
    i_load_R16_c_r = struct[0].y_run[364,0]
    i_load_R16_c_i = struct[0].y_run[365,0]
    i_load_R16_n_r = struct[0].y_run[366,0]
    i_load_R16_n_i = struct[0].y_run[367,0]
    i_load_R17_a_r = struct[0].y_run[368,0]
    i_load_R17_a_i = struct[0].y_run[369,0]
    i_load_R17_b_r = struct[0].y_run[370,0]
    i_load_R17_b_i = struct[0].y_run[371,0]
    i_load_R17_c_r = struct[0].y_run[372,0]
    i_load_R17_c_i = struct[0].y_run[373,0]
    i_load_R17_n_r = struct[0].y_run[374,0]
    i_load_R17_n_i = struct[0].y_run[375,0]
    i_load_R18_a_r = struct[0].y_run[376,0]
    i_load_R18_a_i = struct[0].y_run[377,0]
    i_load_R18_b_r = struct[0].y_run[378,0]
    i_load_R18_b_i = struct[0].y_run[379,0]
    i_load_R18_c_r = struct[0].y_run[380,0]
    i_load_R18_c_i = struct[0].y_run[381,0]
    i_load_R18_n_r = struct[0].y_run[382,0]
    i_load_R18_n_i = struct[0].y_run[383,0]
    i_load_D15_a_r = struct[0].y_run[384,0]
    i_load_D15_a_i = struct[0].y_run[385,0]
    i_load_D15_n_r = struct[0].y_run[386,0]
    i_load_D15_n_i = struct[0].y_run[387,0]
    i_load_D11_a_r = struct[0].y_run[388,0]
    i_load_D11_a_i = struct[0].y_run[389,0]
    i_load_D11_n_r = struct[0].y_run[390,0]
    i_load_D11_n_i = struct[0].y_run[391,0]
    i_load_D16_a_r = struct[0].y_run[392,0]
    i_load_D16_a_i = struct[0].y_run[393,0]
    i_load_D16_n_r = struct[0].y_run[394,0]
    i_load_D16_n_i = struct[0].y_run[395,0]
    i_load_D17_a_r = struct[0].y_run[396,0]
    i_load_D17_a_i = struct[0].y_run[397,0]
    i_load_D17_n_r = struct[0].y_run[398,0]
    i_load_D17_n_i = struct[0].y_run[399,0]
    i_load_D18_a_r = struct[0].y_run[400,0]
    i_load_D18_a_i = struct[0].y_run[401,0]
    i_load_D18_n_r = struct[0].y_run[402,0]
    i_load_D18_n_i = struct[0].y_run[403,0]
    i_vsc_R1_a_r = struct[0].y_run[404,0]
    i_vsc_R1_a_i = struct[0].y_run[405,0]
    i_vsc_R1_b_r = struct[0].y_run[406,0]
    i_vsc_R1_b_i = struct[0].y_run[407,0]
    i_vsc_R1_c_r = struct[0].y_run[408,0]
    i_vsc_R1_c_i = struct[0].y_run[409,0]
    p_R1 = struct[0].y_run[410,0]
    p_D1 = struct[0].y_run[411,0]
    p_loss_R1 = struct[0].y_run[412,0]
    i_vsc_R10_a_r = struct[0].y_run[413,0]
    i_vsc_R10_a_i = struct[0].y_run[414,0]
    i_vsc_R10_b_r = struct[0].y_run[415,0]
    i_vsc_R10_b_i = struct[0].y_run[416,0]
    i_vsc_R10_c_r = struct[0].y_run[417,0]
    i_vsc_R10_c_i = struct[0].y_run[418,0]
    i_vsc_D10_a_r = struct[0].y_run[419,0]
    i_vsc_D10_n_r = struct[0].y_run[420,0]
    p_D10 = struct[0].y_run[421,0]
    p_loss_R10 = struct[0].y_run[422,0]
    i_vsc_R14_a_r = struct[0].y_run[423,0]
    i_vsc_R14_a_i = struct[0].y_run[424,0]
    i_vsc_R14_b_r = struct[0].y_run[425,0]
    i_vsc_R14_b_i = struct[0].y_run[426,0]
    i_vsc_R14_c_r = struct[0].y_run[427,0]
    i_vsc_R14_c_i = struct[0].y_run[428,0]
    i_vsc_D14_a_r = struct[0].y_run[429,0]
    i_vsc_D14_n_r = struct[0].y_run[430,0]
    p_D14 = struct[0].y_run[431,0]
    p_loss_R14 = struct[0].y_run[432,0]
    
    struct[0].u_run[0,0] = v_R0_a_r
    struct[0].u_run[1,0] = v_R0_a_i
    struct[0].u_run[2,0] = v_R0_b_r
    struct[0].u_run[3,0] = v_R0_b_i
    struct[0].u_run[4,0] = v_R0_c_r
    struct[0].u_run[5,0] = v_R0_c_i
    struct[0].u_run[6,0] = v_D1_a_r
    struct[0].u_run[7,0] = v_D1_a_i
    struct[0].u_run[8,0] = v_D1_b_r
    struct[0].u_run[9,0] = v_D1_b_i
    struct[0].u_run[10,0] = v_D1_c_r
    struct[0].u_run[11,0] = v_D1_c_i
    struct[0].u_run[12,0] = i_R1_n_r
    struct[0].u_run[13,0] = i_R1_n_i
    struct[0].u_run[14,0] = i_R11_n_r
    struct[0].u_run[15,0] = i_R11_n_i
    struct[0].u_run[16,0] = i_R15_n_r
    struct[0].u_run[17,0] = i_R15_n_i
    struct[0].u_run[18,0] = i_R16_n_r
    struct[0].u_run[19,0] = i_R16_n_i
    struct[0].u_run[20,0] = i_R17_n_r
    struct[0].u_run[21,0] = i_R17_n_i
    struct[0].u_run[22,0] = i_R18_n_r
    struct[0].u_run[23,0] = i_R18_n_i
    struct[0].u_run[24,0] = i_R2_a_r
    struct[0].u_run[25,0] = i_R2_a_i
    struct[0].u_run[26,0] = i_R2_b_r
    struct[0].u_run[27,0] = i_R2_b_i
    struct[0].u_run[28,0] = i_R2_c_r
    struct[0].u_run[29,0] = i_R2_c_i
    struct[0].u_run[30,0] = i_R2_n_r
    struct[0].u_run[31,0] = i_R2_n_i
    struct[0].u_run[32,0] = i_R3_a_r
    struct[0].u_run[33,0] = i_R3_a_i
    struct[0].u_run[34,0] = i_R3_b_r
    struct[0].u_run[35,0] = i_R3_b_i
    struct[0].u_run[36,0] = i_R3_c_r
    struct[0].u_run[37,0] = i_R3_c_i
    struct[0].u_run[38,0] = i_R3_n_r
    struct[0].u_run[39,0] = i_R3_n_i
    struct[0].u_run[40,0] = i_R4_a_r
    struct[0].u_run[41,0] = i_R4_a_i
    struct[0].u_run[42,0] = i_R4_b_r
    struct[0].u_run[43,0] = i_R4_b_i
    struct[0].u_run[44,0] = i_R4_c_r
    struct[0].u_run[45,0] = i_R4_c_i
    struct[0].u_run[46,0] = i_R4_n_r
    struct[0].u_run[47,0] = i_R4_n_i
    struct[0].u_run[48,0] = i_R5_a_r
    struct[0].u_run[49,0] = i_R5_a_i
    struct[0].u_run[50,0] = i_R5_b_r
    struct[0].u_run[51,0] = i_R5_b_i
    struct[0].u_run[52,0] = i_R5_c_r
    struct[0].u_run[53,0] = i_R5_c_i
    struct[0].u_run[54,0] = i_R5_n_r
    struct[0].u_run[55,0] = i_R5_n_i
    struct[0].u_run[56,0] = i_R6_a_r
    struct[0].u_run[57,0] = i_R6_a_i
    struct[0].u_run[58,0] = i_R6_b_r
    struct[0].u_run[59,0] = i_R6_b_i
    struct[0].u_run[60,0] = i_R6_c_r
    struct[0].u_run[61,0] = i_R6_c_i
    struct[0].u_run[62,0] = i_R6_n_r
    struct[0].u_run[63,0] = i_R6_n_i
    struct[0].u_run[64,0] = i_R7_a_r
    struct[0].u_run[65,0] = i_R7_a_i
    struct[0].u_run[66,0] = i_R7_b_r
    struct[0].u_run[67,0] = i_R7_b_i
    struct[0].u_run[68,0] = i_R7_c_r
    struct[0].u_run[69,0] = i_R7_c_i
    struct[0].u_run[70,0] = i_R7_n_r
    struct[0].u_run[71,0] = i_R7_n_i
    struct[0].u_run[72,0] = i_R8_a_r
    struct[0].u_run[73,0] = i_R8_a_i
    struct[0].u_run[74,0] = i_R8_b_r
    struct[0].u_run[75,0] = i_R8_b_i
    struct[0].u_run[76,0] = i_R8_c_r
    struct[0].u_run[77,0] = i_R8_c_i
    struct[0].u_run[78,0] = i_R8_n_r
    struct[0].u_run[79,0] = i_R8_n_i
    struct[0].u_run[80,0] = i_R9_a_r
    struct[0].u_run[81,0] = i_R9_a_i
    struct[0].u_run[82,0] = i_R9_b_r
    struct[0].u_run[83,0] = i_R9_b_i
    struct[0].u_run[84,0] = i_R9_c_r
    struct[0].u_run[85,0] = i_R9_c_i
    struct[0].u_run[86,0] = i_R9_n_r
    struct[0].u_run[87,0] = i_R9_n_i
    struct[0].u_run[88,0] = i_R10_a_r
    struct[0].u_run[89,0] = i_R10_a_i
    struct[0].u_run[90,0] = i_R10_b_r
    struct[0].u_run[91,0] = i_R10_b_i
    struct[0].u_run[92,0] = i_R10_c_r
    struct[0].u_run[93,0] = i_R10_c_i
    struct[0].u_run[94,0] = i_R10_n_r
    struct[0].u_run[95,0] = i_R10_n_i
    struct[0].u_run[96,0] = i_R12_a_r
    struct[0].u_run[97,0] = i_R12_a_i
    struct[0].u_run[98,0] = i_R12_b_r
    struct[0].u_run[99,0] = i_R12_b_i
    struct[0].u_run[100,0] = i_R12_c_r
    struct[0].u_run[101,0] = i_R12_c_i
    struct[0].u_run[102,0] = i_R12_n_r
    struct[0].u_run[103,0] = i_R12_n_i
    struct[0].u_run[104,0] = i_R13_a_r
    struct[0].u_run[105,0] = i_R13_a_i
    struct[0].u_run[106,0] = i_R13_b_r
    struct[0].u_run[107,0] = i_R13_b_i
    struct[0].u_run[108,0] = i_R13_c_r
    struct[0].u_run[109,0] = i_R13_c_i
    struct[0].u_run[110,0] = i_R13_n_r
    struct[0].u_run[111,0] = i_R13_n_i
    struct[0].u_run[112,0] = i_R14_a_r
    struct[0].u_run[113,0] = i_R14_a_i
    struct[0].u_run[114,0] = i_R14_b_r
    struct[0].u_run[115,0] = i_R14_b_i
    struct[0].u_run[116,0] = i_R14_c_r
    struct[0].u_run[117,0] = i_R14_c_i
    struct[0].u_run[118,0] = i_R14_n_r
    struct[0].u_run[119,0] = i_R14_n_i
    struct[0].u_run[120,0] = i_D1_n_r
    struct[0].u_run[121,0] = i_D1_n_i
    struct[0].u_run[122,0] = i_D3_a_r
    struct[0].u_run[123,0] = i_D3_a_i
    struct[0].u_run[124,0] = i_D3_b_r
    struct[0].u_run[125,0] = i_D3_b_i
    struct[0].u_run[126,0] = i_D3_c_r
    struct[0].u_run[127,0] = i_D3_c_i
    struct[0].u_run[128,0] = i_D3_n_r
    struct[0].u_run[129,0] = i_D3_n_i
    struct[0].u_run[130,0] = i_D4_a_r
    struct[0].u_run[131,0] = i_D4_a_i
    struct[0].u_run[132,0] = i_D4_b_r
    struct[0].u_run[133,0] = i_D4_b_i
    struct[0].u_run[134,0] = i_D4_c_r
    struct[0].u_run[135,0] = i_D4_c_i
    struct[0].u_run[136,0] = i_D4_n_r
    struct[0].u_run[137,0] = i_D4_n_i
    struct[0].u_run[138,0] = i_D6_a_r
    struct[0].u_run[139,0] = i_D6_a_i
    struct[0].u_run[140,0] = i_D6_b_r
    struct[0].u_run[141,0] = i_D6_b_i
    struct[0].u_run[142,0] = i_D6_c_r
    struct[0].u_run[143,0] = i_D6_c_i
    struct[0].u_run[144,0] = i_D6_n_r
    struct[0].u_run[145,0] = i_D6_n_i
    struct[0].u_run[146,0] = i_D9_a_r
    struct[0].u_run[147,0] = i_D9_a_i
    struct[0].u_run[148,0] = i_D9_b_r
    struct[0].u_run[149,0] = i_D9_b_i
    struct[0].u_run[150,0] = i_D9_c_r
    struct[0].u_run[151,0] = i_D9_c_i
    struct[0].u_run[152,0] = i_D9_n_r
    struct[0].u_run[153,0] = i_D9_n_i
    struct[0].u_run[154,0] = i_D10_a_i
    struct[0].u_run[155,0] = i_D10_b_r
    struct[0].u_run[156,0] = i_D10_b_i
    struct[0].u_run[157,0] = i_D10_c_r
    struct[0].u_run[158,0] = i_D10_c_i
    struct[0].u_run[159,0] = i_D10_n_i
    struct[0].u_run[160,0] = i_D11_b_r
    struct[0].u_run[161,0] = i_D11_b_i
    struct[0].u_run[162,0] = i_D11_c_r
    struct[0].u_run[163,0] = i_D11_c_i
    struct[0].u_run[164,0] = i_D16_b_r
    struct[0].u_run[165,0] = i_D16_b_i
    struct[0].u_run[166,0] = i_D16_c_r
    struct[0].u_run[167,0] = i_D16_c_i
    struct[0].u_run[168,0] = i_D17_b_r
    struct[0].u_run[169,0] = i_D17_b_i
    struct[0].u_run[170,0] = i_D17_c_r
    struct[0].u_run[171,0] = i_D17_c_i
    struct[0].u_run[172,0] = i_D18_b_r
    struct[0].u_run[173,0] = i_D18_b_i
    struct[0].u_run[174,0] = i_D18_c_r
    struct[0].u_run[175,0] = i_D18_c_i
    struct[0].u_run[176,0] = i_D14_a_i
    struct[0].u_run[177,0] = i_D14_b_r
    struct[0].u_run[178,0] = i_D14_b_i
    struct[0].u_run[179,0] = i_D14_c_r
    struct[0].u_run[180,0] = i_D14_c_i
    struct[0].u_run[181,0] = i_D14_n_i
    struct[0].u_run[182,0] = i_D15_b_r
    struct[0].u_run[183,0] = i_D15_b_i
    struct[0].u_run[184,0] = i_D15_c_r
    struct[0].u_run[185,0] = i_D15_c_i
    struct[0].u_run[186,0] = p_R1_a
    struct[0].u_run[187,0] = q_R1_a
    struct[0].u_run[188,0] = p_R1_b
    struct[0].u_run[189,0] = q_R1_b
    struct[0].u_run[190,0] = p_R1_c
    struct[0].u_run[191,0] = q_R1_c
    struct[0].u_run[192,0] = p_R11_a
    struct[0].u_run[193,0] = q_R11_a
    struct[0].u_run[194,0] = p_R11_b
    struct[0].u_run[195,0] = q_R11_b
    struct[0].u_run[196,0] = p_R11_c
    struct[0].u_run[197,0] = q_R11_c
    struct[0].u_run[198,0] = p_R15_a
    struct[0].u_run[199,0] = q_R15_a
    struct[0].u_run[200,0] = p_R15_b
    struct[0].u_run[201,0] = q_R15_b
    struct[0].u_run[202,0] = p_R15_c
    struct[0].u_run[203,0] = q_R15_c
    struct[0].u_run[204,0] = p_R16_a
    struct[0].u_run[205,0] = q_R16_a
    struct[0].u_run[206,0] = p_R16_b
    struct[0].u_run[207,0] = q_R16_b
    struct[0].u_run[208,0] = p_R16_c
    struct[0].u_run[209,0] = q_R16_c
    struct[0].u_run[210,0] = p_R17_a
    struct[0].u_run[211,0] = q_R17_a
    struct[0].u_run[212,0] = p_R17_b
    struct[0].u_run[213,0] = q_R17_b
    struct[0].u_run[214,0] = p_R17_c
    struct[0].u_run[215,0] = q_R17_c
    struct[0].u_run[216,0] = p_R18_a
    struct[0].u_run[217,0] = q_R18_a
    struct[0].u_run[218,0] = p_R18_b
    struct[0].u_run[219,0] = q_R18_b
    struct[0].u_run[220,0] = p_R18_c
    struct[0].u_run[221,0] = q_R18_c
    struct[0].u_run[222,0] = p_D15_1
    struct[0].u_run[223,0] = q_D15_1
    struct[0].u_run[224,0] = p_D11_1
    struct[0].u_run[225,0] = q_D11_1
    struct[0].u_run[226,0] = p_D16_1
    struct[0].u_run[227,0] = q_D16_1
    struct[0].u_run[228,0] = p_D17_1
    struct[0].u_run[229,0] = q_D17_1
    struct[0].u_run[230,0] = p_D18_1
    struct[0].u_run[231,0] = q_D18_1
    struct[0].u_run[232,0] = v_dc_D1
    struct[0].u_run[233,0] = q_R1
    struct[0].u_run[234,0] = p_R10
    struct[0].u_run[235,0] = q_R10
    struct[0].u_run[236,0] = p_R14
    struct[0].u_run[237,0] = q_R14
    struct[0].u_run[238,0] = u_dummy
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = u_dummy - x_dummy
    
    # Algebraic equations:
    if mode == 3:

        struct[0].g[:,:] = np.ascontiguousarray(struct[0].Gy) @ np.ascontiguousarray(struct[0].y_run) + np.ascontiguousarray(struct[0].Gu) @ np.ascontiguousarray(struct[0].u_run)

        struct[0].g[336,0] = i_load_R1_a_i*v_R1_a_i - i_load_R1_a_i*v_R1_n_i + i_load_R1_a_r*v_R1_a_r - i_load_R1_a_r*v_R1_n_r - p_R1_a
        struct[0].g[337,0] = i_load_R1_b_i*v_R1_b_i - i_load_R1_b_i*v_R1_n_i + i_load_R1_b_r*v_R1_b_r - i_load_R1_b_r*v_R1_n_r - p_R1_b
        struct[0].g[338,0] = i_load_R1_c_i*v_R1_c_i - i_load_R1_c_i*v_R1_n_i + i_load_R1_c_r*v_R1_c_r - i_load_R1_c_r*v_R1_n_r - p_R1_c
        struct[0].g[339,0] = -i_load_R1_a_i*v_R1_a_r + i_load_R1_a_i*v_R1_n_r + i_load_R1_a_r*v_R1_a_i - i_load_R1_a_r*v_R1_n_i - q_R1_a
        struct[0].g[340,0] = -i_load_R1_b_i*v_R1_b_r + i_load_R1_b_i*v_R1_n_r + i_load_R1_b_r*v_R1_b_i - i_load_R1_b_r*v_R1_n_i - q_R1_b
        struct[0].g[341,0] = -i_load_R1_c_i*v_R1_c_r + i_load_R1_c_i*v_R1_n_r + i_load_R1_c_r*v_R1_c_i - i_load_R1_c_r*v_R1_n_i - q_R1_c
        struct[0].g[344,0] = i_load_R11_a_i*v_R11_a_i - i_load_R11_a_i*v_R11_n_i + i_load_R11_a_r*v_R11_a_r - i_load_R11_a_r*v_R11_n_r - p_R11_a
        struct[0].g[345,0] = i_load_R11_b_i*v_R11_b_i - i_load_R11_b_i*v_R11_n_i + i_load_R11_b_r*v_R11_b_r - i_load_R11_b_r*v_R11_n_r - p_R11_b
        struct[0].g[346,0] = i_load_R11_c_i*v_R11_c_i - i_load_R11_c_i*v_R11_n_i + i_load_R11_c_r*v_R11_c_r - i_load_R11_c_r*v_R11_n_r - p_R11_c
        struct[0].g[347,0] = -i_load_R11_a_i*v_R11_a_r + i_load_R11_a_i*v_R11_n_r + i_load_R11_a_r*v_R11_a_i - i_load_R11_a_r*v_R11_n_i - q_R11_a
        struct[0].g[348,0] = -i_load_R11_b_i*v_R11_b_r + i_load_R11_b_i*v_R11_n_r + i_load_R11_b_r*v_R11_b_i - i_load_R11_b_r*v_R11_n_i - q_R11_b
        struct[0].g[349,0] = -i_load_R11_c_i*v_R11_c_r + i_load_R11_c_i*v_R11_n_r + i_load_R11_c_r*v_R11_c_i - i_load_R11_c_r*v_R11_n_i - q_R11_c
        struct[0].g[352,0] = i_load_R15_a_i*v_R15_a_i - i_load_R15_a_i*v_R15_n_i + i_load_R15_a_r*v_R15_a_r - i_load_R15_a_r*v_R15_n_r - p_R15_a
        struct[0].g[353,0] = i_load_R15_b_i*v_R15_b_i - i_load_R15_b_i*v_R15_n_i + i_load_R15_b_r*v_R15_b_r - i_load_R15_b_r*v_R15_n_r - p_R15_b
        struct[0].g[354,0] = i_load_R15_c_i*v_R15_c_i - i_load_R15_c_i*v_R15_n_i + i_load_R15_c_r*v_R15_c_r - i_load_R15_c_r*v_R15_n_r - p_R15_c
        struct[0].g[355,0] = -i_load_R15_a_i*v_R15_a_r + i_load_R15_a_i*v_R15_n_r + i_load_R15_a_r*v_R15_a_i - i_load_R15_a_r*v_R15_n_i - q_R15_a
        struct[0].g[356,0] = -i_load_R15_b_i*v_R15_b_r + i_load_R15_b_i*v_R15_n_r + i_load_R15_b_r*v_R15_b_i - i_load_R15_b_r*v_R15_n_i - q_R15_b
        struct[0].g[357,0] = -i_load_R15_c_i*v_R15_c_r + i_load_R15_c_i*v_R15_n_r + i_load_R15_c_r*v_R15_c_i - i_load_R15_c_r*v_R15_n_i - q_R15_c
        struct[0].g[360,0] = i_load_R16_a_i*v_R16_a_i - i_load_R16_a_i*v_R16_n_i + i_load_R16_a_r*v_R16_a_r - i_load_R16_a_r*v_R16_n_r - p_R16_a
        struct[0].g[361,0] = i_load_R16_b_i*v_R16_b_i - i_load_R16_b_i*v_R16_n_i + i_load_R16_b_r*v_R16_b_r - i_load_R16_b_r*v_R16_n_r - p_R16_b
        struct[0].g[362,0] = i_load_R16_c_i*v_R16_c_i - i_load_R16_c_i*v_R16_n_i + i_load_R16_c_r*v_R16_c_r - i_load_R16_c_r*v_R16_n_r - p_R16_c
        struct[0].g[363,0] = -i_load_R16_a_i*v_R16_a_r + i_load_R16_a_i*v_R16_n_r + i_load_R16_a_r*v_R16_a_i - i_load_R16_a_r*v_R16_n_i - q_R16_a
        struct[0].g[364,0] = -i_load_R16_b_i*v_R16_b_r + i_load_R16_b_i*v_R16_n_r + i_load_R16_b_r*v_R16_b_i - i_load_R16_b_r*v_R16_n_i - q_R16_b
        struct[0].g[365,0] = -i_load_R16_c_i*v_R16_c_r + i_load_R16_c_i*v_R16_n_r + i_load_R16_c_r*v_R16_c_i - i_load_R16_c_r*v_R16_n_i - q_R16_c
        struct[0].g[368,0] = i_load_R17_a_i*v_R17_a_i - i_load_R17_a_i*v_R17_n_i + i_load_R17_a_r*v_R17_a_r - i_load_R17_a_r*v_R17_n_r - p_R17_a
        struct[0].g[369,0] = i_load_R17_b_i*v_R17_b_i - i_load_R17_b_i*v_R17_n_i + i_load_R17_b_r*v_R17_b_r - i_load_R17_b_r*v_R17_n_r - p_R17_b
        struct[0].g[370,0] = i_load_R17_c_i*v_R17_c_i - i_load_R17_c_i*v_R17_n_i + i_load_R17_c_r*v_R17_c_r - i_load_R17_c_r*v_R17_n_r - p_R17_c
        struct[0].g[371,0] = -i_load_R17_a_i*v_R17_a_r + i_load_R17_a_i*v_R17_n_r + i_load_R17_a_r*v_R17_a_i - i_load_R17_a_r*v_R17_n_i - q_R17_a
        struct[0].g[372,0] = -i_load_R17_b_i*v_R17_b_r + i_load_R17_b_i*v_R17_n_r + i_load_R17_b_r*v_R17_b_i - i_load_R17_b_r*v_R17_n_i - q_R17_b
        struct[0].g[373,0] = -i_load_R17_c_i*v_R17_c_r + i_load_R17_c_i*v_R17_n_r + i_load_R17_c_r*v_R17_c_i - i_load_R17_c_r*v_R17_n_i - q_R17_c
        struct[0].g[376,0] = i_load_R18_a_i*v_R18_a_i - i_load_R18_a_i*v_R18_n_i + i_load_R18_a_r*v_R18_a_r - i_load_R18_a_r*v_R18_n_r - p_R18_a
        struct[0].g[377,0] = i_load_R18_b_i*v_R18_b_i - i_load_R18_b_i*v_R18_n_i + i_load_R18_b_r*v_R18_b_r - i_load_R18_b_r*v_R18_n_r - p_R18_b
        struct[0].g[378,0] = i_load_R18_c_i*v_R18_c_i - i_load_R18_c_i*v_R18_n_i + i_load_R18_c_r*v_R18_c_r - i_load_R18_c_r*v_R18_n_r - p_R18_c
        struct[0].g[379,0] = -i_load_R18_a_i*v_R18_a_r + i_load_R18_a_i*v_R18_n_r + i_load_R18_a_r*v_R18_a_i - i_load_R18_a_r*v_R18_n_i - q_R18_a
        struct[0].g[380,0] = -i_load_R18_b_i*v_R18_b_r + i_load_R18_b_i*v_R18_n_r + i_load_R18_b_r*v_R18_b_i - i_load_R18_b_r*v_R18_n_i - q_R18_b
        struct[0].g[381,0] = -i_load_R18_c_i*v_R18_c_r + i_load_R18_c_i*v_R18_n_r + i_load_R18_c_r*v_R18_c_i - i_load_R18_c_r*v_R18_n_i - q_R18_c
        struct[0].g[384,0] = 1.0*i_load_D15_a_i*v_D15_a_i - 1.0*i_load_D15_a_i*v_D15_n_i + i_load_D15_a_r*v_D15_a_r - i_load_D15_a_r*v_D15_n_r - p_D15_1
        struct[0].g[385,0] = -1.0*i_load_D15_a_i*v_D15_a_r + 1.0*i_load_D15_a_i*v_D15_n_r + 1.0*i_load_D15_a_r*v_D15_a_i - 1.0*i_load_D15_a_r*v_D15_n_i - q_D15_1
        struct[0].g[388,0] = 1.0*i_load_D11_a_i*v_D11_a_i - 1.0*i_load_D11_a_i*v_D11_n_i + i_load_D11_a_r*v_D11_a_r - i_load_D11_a_r*v_D11_n_r - p_D11_1
        struct[0].g[389,0] = -1.0*i_load_D11_a_i*v_D11_a_r + 1.0*i_load_D11_a_i*v_D11_n_r + 1.0*i_load_D11_a_r*v_D11_a_i - 1.0*i_load_D11_a_r*v_D11_n_i - q_D11_1
        struct[0].g[392,0] = 1.0*i_load_D16_a_i*v_D16_a_i - 1.0*i_load_D16_a_i*v_D16_n_i + i_load_D16_a_r*v_D16_a_r - i_load_D16_a_r*v_D16_n_r - p_D16_1
        struct[0].g[393,0] = -1.0*i_load_D16_a_i*v_D16_a_r + 1.0*i_load_D16_a_i*v_D16_n_r + 1.0*i_load_D16_a_r*v_D16_a_i - 1.0*i_load_D16_a_r*v_D16_n_i - q_D16_1
        struct[0].g[396,0] = 1.0*i_load_D17_a_i*v_D17_a_i - 1.0*i_load_D17_a_i*v_D17_n_i + i_load_D17_a_r*v_D17_a_r - i_load_D17_a_r*v_D17_n_r - p_D17_1
        struct[0].g[397,0] = -1.0*i_load_D17_a_i*v_D17_a_r + 1.0*i_load_D17_a_i*v_D17_n_r + 1.0*i_load_D17_a_r*v_D17_a_i - 1.0*i_load_D17_a_r*v_D17_n_i - q_D17_1
        struct[0].g[400,0] = 1.0*i_load_D18_a_i*v_D18_a_i - 1.0*i_load_D18_a_i*v_D18_n_i + i_load_D18_a_r*v_D18_a_r - i_load_D18_a_r*v_D18_n_r - p_D18_1
        struct[0].g[401,0] = -1.0*i_load_D18_a_i*v_D18_a_r + 1.0*i_load_D18_a_i*v_D18_n_r + 1.0*i_load_D18_a_r*v_D18_a_i - 1.0*i_load_D18_a_r*v_D18_n_i - q_D18_1
        struct[0].g[404,0] = 1.0*i_vsc_R1_a_i*v_R1_a_i - 1.0*i_vsc_R1_a_i*v_R1_n_i + i_vsc_R1_a_r*v_R1_a_r - i_vsc_R1_a_r*v_R1_n_r - p_R1/3
        struct[0].g[405,0] = -1.0*i_vsc_R1_a_i*v_R1_a_r + 1.0*i_vsc_R1_a_i*v_R1_n_r + 1.0*i_vsc_R1_a_r*v_R1_a_i - 1.0*i_vsc_R1_a_r*v_R1_n_i - q_R1/3
        struct[0].g[406,0] = 1.0*i_vsc_R1_b_i*v_R1_b_i - 1.0*i_vsc_R1_b_i*v_R1_n_i + i_vsc_R1_b_r*v_R1_b_r - i_vsc_R1_b_r*v_R1_n_r - p_R1/3
        struct[0].g[407,0] = -1.0*i_vsc_R1_b_i*v_R1_b_r + 1.0*i_vsc_R1_b_i*v_R1_n_r + 1.0*i_vsc_R1_b_r*v_R1_b_i - 1.0*i_vsc_R1_b_r*v_R1_n_i - q_R1/3
        struct[0].g[408,0] = 1.0*i_vsc_R1_c_i*v_R1_c_i - 1.0*i_vsc_R1_c_i*v_R1_n_i + i_vsc_R1_c_r*v_R1_c_r - i_vsc_R1_c_r*v_R1_n_r - p_R1/3
        struct[0].g[409,0] = -1.0*i_vsc_R1_c_i*v_R1_c_r + 1.0*i_vsc_R1_c_i*v_R1_n_r + 1.0*i_vsc_R1_c_r*v_R1_c_i - 1.0*i_vsc_R1_c_r*v_R1_n_i - q_R1/3
        struct[0].g[410,0] = p_D1 + p_R1 + Piecewise(np.array([(-p_loss_R1, p_D1 < 0), (p_loss_R1, True)]))
        struct[0].g[412,0] = -a_R1 - b_R1*sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - c_R1*(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) + p_loss_R1
        struct[0].g[413,0] = -coef_a_R10*p_R10 + 1.0*i_vsc_R10_a_i*v_R10_a_i - 1.0*i_vsc_R10_a_i*v_R10_n_i + i_vsc_R10_a_r*v_R10_a_r - i_vsc_R10_a_r*v_R10_n_r
        struct[0].g[414,0] = -coef_a_R10*q_R10 - 1.0*i_vsc_R10_a_i*v_R10_a_r + 1.0*i_vsc_R10_a_i*v_R10_n_r + 1.0*i_vsc_R10_a_r*v_R10_a_i - 1.0*i_vsc_R10_a_r*v_R10_n_i
        struct[0].g[415,0] = -coef_b_R10*p_R10 + 1.0*i_vsc_R10_b_i*v_R10_b_i - 1.0*i_vsc_R10_b_i*v_R10_n_i + i_vsc_R10_b_r*v_R10_b_r - i_vsc_R10_b_r*v_R10_n_r
        struct[0].g[416,0] = -coef_b_R10*q_R10 - 1.0*i_vsc_R10_b_i*v_R10_b_r + 1.0*i_vsc_R10_b_i*v_R10_n_r + 1.0*i_vsc_R10_b_r*v_R10_b_i - 1.0*i_vsc_R10_b_r*v_R10_n_i
        struct[0].g[417,0] = -coef_c_R10*p_R10 + 1.0*i_vsc_R10_c_i*v_R10_c_i - 1.0*i_vsc_R10_c_i*v_R10_n_i + i_vsc_R10_c_r*v_R10_c_r - i_vsc_R10_c_r*v_R10_n_r
        struct[0].g[418,0] = -coef_c_R10*q_R10 - 1.0*i_vsc_R10_c_i*v_R10_c_r + 1.0*i_vsc_R10_c_i*v_R10_n_r + 1.0*i_vsc_R10_c_r*v_R10_c_i - 1.0*i_vsc_R10_c_r*v_R10_n_i
        struct[0].g[419,0] = i_vsc_D10_a_r + p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].g[420,0] = i_vsc_D10_n_r + p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].g[421,0] = p_D10 - p_R10 - Piecewise(np.array([(-p_loss_R10, p_D10 < 0), (p_loss_R10, True)]))
        struct[0].g[422,0] = -a_R10 - b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + p_loss_R10
        struct[0].g[423,0] = -coef_a_R14*p_R14 + 1.0*i_vsc_R14_a_i*v_R14_a_i - 1.0*i_vsc_R14_a_i*v_R14_n_i + i_vsc_R14_a_r*v_R14_a_r - i_vsc_R14_a_r*v_R14_n_r
        struct[0].g[424,0] = -coef_a_R14*q_R14 - 1.0*i_vsc_R14_a_i*v_R14_a_r + 1.0*i_vsc_R14_a_i*v_R14_n_r + 1.0*i_vsc_R14_a_r*v_R14_a_i - 1.0*i_vsc_R14_a_r*v_R14_n_i
        struct[0].g[425,0] = -coef_b_R14*p_R14 + 1.0*i_vsc_R14_b_i*v_R14_b_i - 1.0*i_vsc_R14_b_i*v_R14_n_i + i_vsc_R14_b_r*v_R14_b_r - i_vsc_R14_b_r*v_R14_n_r
        struct[0].g[426,0] = -coef_b_R14*q_R14 - 1.0*i_vsc_R14_b_i*v_R14_b_r + 1.0*i_vsc_R14_b_i*v_R14_n_r + 1.0*i_vsc_R14_b_r*v_R14_b_i - 1.0*i_vsc_R14_b_r*v_R14_n_i
        struct[0].g[427,0] = -coef_c_R14*p_R14 + 1.0*i_vsc_R14_c_i*v_R14_c_i - 1.0*i_vsc_R14_c_i*v_R14_n_i + i_vsc_R14_c_r*v_R14_c_r - i_vsc_R14_c_r*v_R14_n_r
        struct[0].g[428,0] = -coef_c_R14*q_R14 - 1.0*i_vsc_R14_c_i*v_R14_c_r + 1.0*i_vsc_R14_c_i*v_R14_n_r + 1.0*i_vsc_R14_c_r*v_R14_c_i - 1.0*i_vsc_R14_c_r*v_R14_n_i
        struct[0].g[429,0] = i_vsc_D14_a_r + p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].g[430,0] = i_vsc_D14_n_r + p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].g[431,0] = p_D14 - p_R14 - Piecewise(np.array([(-p_loss_R14, p_D14 < 0), (p_loss_R14, True)]))
        struct[0].g[432,0] = -a_R14 - b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + p_loss_R14
    
    # Outputs:
    if mode == 3:

        struct[0].h[0,0] = (v_R0_a_i**2 + v_R0_a_r**2)**0.5
        struct[0].h[1,0] = (v_R0_b_i**2 + v_R0_b_r**2)**0.5
        struct[0].h[2,0] = (v_R0_c_i**2 + v_R0_c_r**2)**0.5
        struct[0].h[3,0] = (v_D1_a_i**2 + v_D1_a_r**2)**0.5
        struct[0].h[4,0] = (v_D1_b_i**2 + v_D1_b_r**2)**0.5
        struct[0].h[5,0] = (v_D1_c_i**2 + v_D1_c_r**2)**0.5
        struct[0].h[6,0] = (v_R1_a_i**2 + v_R1_a_r**2)**0.5
        struct[0].h[7,0] = (v_R1_b_i**2 + v_R1_b_r**2)**0.5
        struct[0].h[8,0] = (v_R1_c_i**2 + v_R1_c_r**2)**0.5
        struct[0].h[9,0] = (v_R1_n_i**2 + v_R1_n_r**2)**0.5
        struct[0].h[10,0] = (v_R11_a_i**2 + v_R11_a_r**2)**0.5
        struct[0].h[11,0] = (v_R11_b_i**2 + v_R11_b_r**2)**0.5
        struct[0].h[12,0] = (v_R11_c_i**2 + v_R11_c_r**2)**0.5
        struct[0].h[13,0] = (v_R11_n_i**2 + v_R11_n_r**2)**0.5
        struct[0].h[14,0] = (v_R15_a_i**2 + v_R15_a_r**2)**0.5
        struct[0].h[15,0] = (v_R15_b_i**2 + v_R15_b_r**2)**0.5
        struct[0].h[16,0] = (v_R15_c_i**2 + v_R15_c_r**2)**0.5
        struct[0].h[17,0] = (v_R15_n_i**2 + v_R15_n_r**2)**0.5
        struct[0].h[18,0] = (v_R16_a_i**2 + v_R16_a_r**2)**0.5
        struct[0].h[19,0] = (v_R16_b_i**2 + v_R16_b_r**2)**0.5
        struct[0].h[20,0] = (v_R16_c_i**2 + v_R16_c_r**2)**0.5
        struct[0].h[21,0] = (v_R16_n_i**2 + v_R16_n_r**2)**0.5
        struct[0].h[22,0] = (v_R17_a_i**2 + v_R17_a_r**2)**0.5
        struct[0].h[23,0] = (v_R17_b_i**2 + v_R17_b_r**2)**0.5
        struct[0].h[24,0] = (v_R17_c_i**2 + v_R17_c_r**2)**0.5
        struct[0].h[25,0] = (v_R17_n_i**2 + v_R17_n_r**2)**0.5
        struct[0].h[26,0] = (v_R18_a_i**2 + v_R18_a_r**2)**0.5
        struct[0].h[27,0] = (v_R18_b_i**2 + v_R18_b_r**2)**0.5
        struct[0].h[28,0] = (v_R18_c_i**2 + v_R18_c_r**2)**0.5
        struct[0].h[29,0] = (v_R18_n_i**2 + v_R18_n_r**2)**0.5
        struct[0].h[30,0] = (v_D15_a_i**2 + v_D15_a_r**2)**0.5
        struct[0].h[31,0] = (v_D15_n_i**2 + v_D15_n_r**2)**0.5
        struct[0].h[32,0] = (v_D11_a_i**2 + v_D11_a_r**2)**0.5
        struct[0].h[33,0] = (v_D11_n_i**2 + v_D11_n_r**2)**0.5
        struct[0].h[34,0] = (v_D16_a_i**2 + v_D16_a_r**2)**0.5
        struct[0].h[35,0] = (v_D16_n_i**2 + v_D16_n_r**2)**0.5
        struct[0].h[36,0] = (v_D17_a_i**2 + v_D17_a_r**2)**0.5
        struct[0].h[37,0] = (v_D17_n_i**2 + v_D17_n_r**2)**0.5
        struct[0].h[38,0] = (v_D18_a_i**2 + v_D18_a_r**2)**0.5
        struct[0].h[39,0] = (v_D18_n_i**2 + v_D18_n_r**2)**0.5
        struct[0].h[40,0] = (v_R2_a_i**2 + v_R2_a_r**2)**0.5
        struct[0].h[41,0] = (v_R2_b_i**2 + v_R2_b_r**2)**0.5
        struct[0].h[42,0] = (v_R2_c_i**2 + v_R2_c_r**2)**0.5
        struct[0].h[43,0] = (v_R2_n_i**2 + v_R2_n_r**2)**0.5
        struct[0].h[44,0] = (v_R3_a_i**2 + v_R3_a_r**2)**0.5
        struct[0].h[45,0] = (v_R3_b_i**2 + v_R3_b_r**2)**0.5
        struct[0].h[46,0] = (v_R3_c_i**2 + v_R3_c_r**2)**0.5
        struct[0].h[47,0] = (v_R3_n_i**2 + v_R3_n_r**2)**0.5
        struct[0].h[48,0] = (v_R4_a_i**2 + v_R4_a_r**2)**0.5
        struct[0].h[49,0] = (v_R4_b_i**2 + v_R4_b_r**2)**0.5
        struct[0].h[50,0] = (v_R4_c_i**2 + v_R4_c_r**2)**0.5
        struct[0].h[51,0] = (v_R4_n_i**2 + v_R4_n_r**2)**0.5
        struct[0].h[52,0] = (v_R5_a_i**2 + v_R5_a_r**2)**0.5
        struct[0].h[53,0] = (v_R5_b_i**2 + v_R5_b_r**2)**0.5
        struct[0].h[54,0] = (v_R5_c_i**2 + v_R5_c_r**2)**0.5
        struct[0].h[55,0] = (v_R5_n_i**2 + v_R5_n_r**2)**0.5
        struct[0].h[56,0] = (v_R6_a_i**2 + v_R6_a_r**2)**0.5
        struct[0].h[57,0] = (v_R6_b_i**2 + v_R6_b_r**2)**0.5
        struct[0].h[58,0] = (v_R6_c_i**2 + v_R6_c_r**2)**0.5
        struct[0].h[59,0] = (v_R6_n_i**2 + v_R6_n_r**2)**0.5
        struct[0].h[60,0] = (v_R7_a_i**2 + v_R7_a_r**2)**0.5
        struct[0].h[61,0] = (v_R7_b_i**2 + v_R7_b_r**2)**0.5
        struct[0].h[62,0] = (v_R7_c_i**2 + v_R7_c_r**2)**0.5
        struct[0].h[63,0] = (v_R7_n_i**2 + v_R7_n_r**2)**0.5
        struct[0].h[64,0] = (v_R8_a_i**2 + v_R8_a_r**2)**0.5
        struct[0].h[65,0] = (v_R8_b_i**2 + v_R8_b_r**2)**0.5
        struct[0].h[66,0] = (v_R8_c_i**2 + v_R8_c_r**2)**0.5
        struct[0].h[67,0] = (v_R8_n_i**2 + v_R8_n_r**2)**0.5
        struct[0].h[68,0] = (v_R9_a_i**2 + v_R9_a_r**2)**0.5
        struct[0].h[69,0] = (v_R9_b_i**2 + v_R9_b_r**2)**0.5
        struct[0].h[70,0] = (v_R9_c_i**2 + v_R9_c_r**2)**0.5
        struct[0].h[71,0] = (v_R9_n_i**2 + v_R9_n_r**2)**0.5
        struct[0].h[72,0] = (v_R10_a_i**2 + v_R10_a_r**2)**0.5
        struct[0].h[73,0] = (v_R10_b_i**2 + v_R10_b_r**2)**0.5
        struct[0].h[74,0] = (v_R10_c_i**2 + v_R10_c_r**2)**0.5
        struct[0].h[75,0] = (v_R10_n_i**2 + v_R10_n_r**2)**0.5
        struct[0].h[76,0] = (v_R12_a_i**2 + v_R12_a_r**2)**0.5
        struct[0].h[77,0] = (v_R12_b_i**2 + v_R12_b_r**2)**0.5
        struct[0].h[78,0] = (v_R12_c_i**2 + v_R12_c_r**2)**0.5
        struct[0].h[79,0] = (v_R12_n_i**2 + v_R12_n_r**2)**0.5
        struct[0].h[80,0] = (v_R13_a_i**2 + v_R13_a_r**2)**0.5
        struct[0].h[81,0] = (v_R13_b_i**2 + v_R13_b_r**2)**0.5
        struct[0].h[82,0] = (v_R13_c_i**2 + v_R13_c_r**2)**0.5
        struct[0].h[83,0] = (v_R13_n_i**2 + v_R13_n_r**2)**0.5
        struct[0].h[84,0] = (v_R14_a_i**2 + v_R14_a_r**2)**0.5
        struct[0].h[85,0] = (v_R14_b_i**2 + v_R14_b_r**2)**0.5
        struct[0].h[86,0] = (v_R14_c_i**2 + v_R14_c_r**2)**0.5
        struct[0].h[87,0] = (v_R14_n_i**2 + v_R14_n_r**2)**0.5
        struct[0].h[88,0] = (v_D1_n_i**2 + v_D1_n_r**2)**0.5
        struct[0].h[89,0] = (v_D3_a_i**2 + v_D3_a_r**2)**0.5
        struct[0].h[90,0] = (v_D3_b_i**2 + v_D3_b_r**2)**0.5
        struct[0].h[91,0] = (v_D3_c_i**2 + v_D3_c_r**2)**0.5
        struct[0].h[92,0] = (v_D3_n_i**2 + v_D3_n_r**2)**0.5
        struct[0].h[93,0] = (v_D4_a_i**2 + v_D4_a_r**2)**0.5
        struct[0].h[94,0] = (v_D4_b_i**2 + v_D4_b_r**2)**0.5
        struct[0].h[95,0] = (v_D4_c_i**2 + v_D4_c_r**2)**0.5
        struct[0].h[96,0] = (v_D4_n_i**2 + v_D4_n_r**2)**0.5
        struct[0].h[97,0] = (v_D6_a_i**2 + v_D6_a_r**2)**0.5
        struct[0].h[98,0] = (v_D6_b_i**2 + v_D6_b_r**2)**0.5
        struct[0].h[99,0] = (v_D6_c_i**2 + v_D6_c_r**2)**0.5
        struct[0].h[100,0] = (v_D6_n_i**2 + v_D6_n_r**2)**0.5
        struct[0].h[101,0] = (v_D9_a_i**2 + v_D9_a_r**2)**0.5
        struct[0].h[102,0] = (v_D9_b_i**2 + v_D9_b_r**2)**0.5
        struct[0].h[103,0] = (v_D9_c_i**2 + v_D9_c_r**2)**0.5
        struct[0].h[104,0] = (v_D9_n_i**2 + v_D9_n_r**2)**0.5
        struct[0].h[105,0] = (v_D10_a_i**2 + v_D10_a_r**2)**0.5
        struct[0].h[106,0] = (v_D10_b_i**2 + v_D10_b_r**2)**0.5
        struct[0].h[107,0] = (v_D10_c_i**2 + v_D10_c_r**2)**0.5
        struct[0].h[108,0] = (v_D10_n_i**2 + v_D10_n_r**2)**0.5
        struct[0].h[109,0] = (v_D11_b_i**2 + v_D11_b_r**2)**0.5
        struct[0].h[110,0] = (v_D11_c_i**2 + v_D11_c_r**2)**0.5
        struct[0].h[111,0] = (v_D16_b_i**2 + v_D16_b_r**2)**0.5
        struct[0].h[112,0] = (v_D16_c_i**2 + v_D16_c_r**2)**0.5
        struct[0].h[113,0] = (v_D17_b_i**2 + v_D17_b_r**2)**0.5
        struct[0].h[114,0] = (v_D17_c_i**2 + v_D17_c_r**2)**0.5
        struct[0].h[115,0] = (v_D18_b_i**2 + v_D18_b_r**2)**0.5
        struct[0].h[116,0] = (v_D18_c_i**2 + v_D18_c_r**2)**0.5
        struct[0].h[117,0] = (v_D14_a_i**2 + v_D14_a_r**2)**0.5
        struct[0].h[118,0] = (v_D14_b_i**2 + v_D14_b_r**2)**0.5
        struct[0].h[119,0] = (v_D14_c_i**2 + v_D14_c_r**2)**0.5
        struct[0].h[120,0] = (v_D14_n_i**2 + v_D14_n_r**2)**0.5
        struct[0].h[121,0] = (v_D15_b_i**2 + v_D15_b_r**2)**0.5
        struct[0].h[122,0] = (v_D15_c_i**2 + v_D15_c_r**2)**0.5
    

    if mode == 10:

        pass

    if mode == 11:



        struct[0].Gy[336,0] = i_load_R1_a_r
        struct[0].Gy[336,1] = i_load_R1_a_i
        struct[0].Gy[336,6] = -i_load_R1_a_r
        struct[0].Gy[336,7] = -i_load_R1_a_i
        struct[0].Gy[336,336] = v_R1_a_r - v_R1_n_r
        struct[0].Gy[336,337] = v_R1_a_i - v_R1_n_i
        struct[0].Gy[337,2] = i_load_R1_b_r
        struct[0].Gy[337,3] = i_load_R1_b_i
        struct[0].Gy[337,6] = -i_load_R1_b_r
        struct[0].Gy[337,7] = -i_load_R1_b_i
        struct[0].Gy[337,338] = v_R1_b_r - v_R1_n_r
        struct[0].Gy[337,339] = v_R1_b_i - v_R1_n_i
        struct[0].Gy[338,4] = i_load_R1_c_r
        struct[0].Gy[338,5] = i_load_R1_c_i
        struct[0].Gy[338,6] = -i_load_R1_c_r
        struct[0].Gy[338,7] = -i_load_R1_c_i
        struct[0].Gy[338,340] = v_R1_c_r - v_R1_n_r
        struct[0].Gy[338,341] = v_R1_c_i - v_R1_n_i
        struct[0].Gy[339,0] = -i_load_R1_a_i
        struct[0].Gy[339,1] = i_load_R1_a_r
        struct[0].Gy[339,6] = i_load_R1_a_i
        struct[0].Gy[339,7] = -i_load_R1_a_r
        struct[0].Gy[339,336] = v_R1_a_i - v_R1_n_i
        struct[0].Gy[339,337] = -v_R1_a_r + v_R1_n_r
        struct[0].Gy[340,2] = -i_load_R1_b_i
        struct[0].Gy[340,3] = i_load_R1_b_r
        struct[0].Gy[340,6] = i_load_R1_b_i
        struct[0].Gy[340,7] = -i_load_R1_b_r
        struct[0].Gy[340,338] = v_R1_b_i - v_R1_n_i
        struct[0].Gy[340,339] = -v_R1_b_r + v_R1_n_r
        struct[0].Gy[341,4] = -i_load_R1_c_i
        struct[0].Gy[341,5] = i_load_R1_c_r
        struct[0].Gy[341,6] = i_load_R1_c_i
        struct[0].Gy[341,7] = -i_load_R1_c_r
        struct[0].Gy[341,340] = v_R1_c_i - v_R1_n_i
        struct[0].Gy[341,341] = -v_R1_c_r + v_R1_n_r
        struct[0].Gy[344,8] = i_load_R11_a_r
        struct[0].Gy[344,9] = i_load_R11_a_i
        struct[0].Gy[344,14] = -i_load_R11_a_r
        struct[0].Gy[344,15] = -i_load_R11_a_i
        struct[0].Gy[344,344] = v_R11_a_r - v_R11_n_r
        struct[0].Gy[344,345] = v_R11_a_i - v_R11_n_i
        struct[0].Gy[345,10] = i_load_R11_b_r
        struct[0].Gy[345,11] = i_load_R11_b_i
        struct[0].Gy[345,14] = -i_load_R11_b_r
        struct[0].Gy[345,15] = -i_load_R11_b_i
        struct[0].Gy[345,346] = v_R11_b_r - v_R11_n_r
        struct[0].Gy[345,347] = v_R11_b_i - v_R11_n_i
        struct[0].Gy[346,12] = i_load_R11_c_r
        struct[0].Gy[346,13] = i_load_R11_c_i
        struct[0].Gy[346,14] = -i_load_R11_c_r
        struct[0].Gy[346,15] = -i_load_R11_c_i
        struct[0].Gy[346,348] = v_R11_c_r - v_R11_n_r
        struct[0].Gy[346,349] = v_R11_c_i - v_R11_n_i
        struct[0].Gy[347,8] = -i_load_R11_a_i
        struct[0].Gy[347,9] = i_load_R11_a_r
        struct[0].Gy[347,14] = i_load_R11_a_i
        struct[0].Gy[347,15] = -i_load_R11_a_r
        struct[0].Gy[347,344] = v_R11_a_i - v_R11_n_i
        struct[0].Gy[347,345] = -v_R11_a_r + v_R11_n_r
        struct[0].Gy[348,10] = -i_load_R11_b_i
        struct[0].Gy[348,11] = i_load_R11_b_r
        struct[0].Gy[348,14] = i_load_R11_b_i
        struct[0].Gy[348,15] = -i_load_R11_b_r
        struct[0].Gy[348,346] = v_R11_b_i - v_R11_n_i
        struct[0].Gy[348,347] = -v_R11_b_r + v_R11_n_r
        struct[0].Gy[349,12] = -i_load_R11_c_i
        struct[0].Gy[349,13] = i_load_R11_c_r
        struct[0].Gy[349,14] = i_load_R11_c_i
        struct[0].Gy[349,15] = -i_load_R11_c_r
        struct[0].Gy[349,348] = v_R11_c_i - v_R11_n_i
        struct[0].Gy[349,349] = -v_R11_c_r + v_R11_n_r
        struct[0].Gy[352,16] = i_load_R15_a_r
        struct[0].Gy[352,17] = i_load_R15_a_i
        struct[0].Gy[352,22] = -i_load_R15_a_r
        struct[0].Gy[352,23] = -i_load_R15_a_i
        struct[0].Gy[352,352] = v_R15_a_r - v_R15_n_r
        struct[0].Gy[352,353] = v_R15_a_i - v_R15_n_i
        struct[0].Gy[353,18] = i_load_R15_b_r
        struct[0].Gy[353,19] = i_load_R15_b_i
        struct[0].Gy[353,22] = -i_load_R15_b_r
        struct[0].Gy[353,23] = -i_load_R15_b_i
        struct[0].Gy[353,354] = v_R15_b_r - v_R15_n_r
        struct[0].Gy[353,355] = v_R15_b_i - v_R15_n_i
        struct[0].Gy[354,20] = i_load_R15_c_r
        struct[0].Gy[354,21] = i_load_R15_c_i
        struct[0].Gy[354,22] = -i_load_R15_c_r
        struct[0].Gy[354,23] = -i_load_R15_c_i
        struct[0].Gy[354,356] = v_R15_c_r - v_R15_n_r
        struct[0].Gy[354,357] = v_R15_c_i - v_R15_n_i
        struct[0].Gy[355,16] = -i_load_R15_a_i
        struct[0].Gy[355,17] = i_load_R15_a_r
        struct[0].Gy[355,22] = i_load_R15_a_i
        struct[0].Gy[355,23] = -i_load_R15_a_r
        struct[0].Gy[355,352] = v_R15_a_i - v_R15_n_i
        struct[0].Gy[355,353] = -v_R15_a_r + v_R15_n_r
        struct[0].Gy[356,18] = -i_load_R15_b_i
        struct[0].Gy[356,19] = i_load_R15_b_r
        struct[0].Gy[356,22] = i_load_R15_b_i
        struct[0].Gy[356,23] = -i_load_R15_b_r
        struct[0].Gy[356,354] = v_R15_b_i - v_R15_n_i
        struct[0].Gy[356,355] = -v_R15_b_r + v_R15_n_r
        struct[0].Gy[357,20] = -i_load_R15_c_i
        struct[0].Gy[357,21] = i_load_R15_c_r
        struct[0].Gy[357,22] = i_load_R15_c_i
        struct[0].Gy[357,23] = -i_load_R15_c_r
        struct[0].Gy[357,356] = v_R15_c_i - v_R15_n_i
        struct[0].Gy[357,357] = -v_R15_c_r + v_R15_n_r
        struct[0].Gy[360,24] = i_load_R16_a_r
        struct[0].Gy[360,25] = i_load_R16_a_i
        struct[0].Gy[360,30] = -i_load_R16_a_r
        struct[0].Gy[360,31] = -i_load_R16_a_i
        struct[0].Gy[360,360] = v_R16_a_r - v_R16_n_r
        struct[0].Gy[360,361] = v_R16_a_i - v_R16_n_i
        struct[0].Gy[361,26] = i_load_R16_b_r
        struct[0].Gy[361,27] = i_load_R16_b_i
        struct[0].Gy[361,30] = -i_load_R16_b_r
        struct[0].Gy[361,31] = -i_load_R16_b_i
        struct[0].Gy[361,362] = v_R16_b_r - v_R16_n_r
        struct[0].Gy[361,363] = v_R16_b_i - v_R16_n_i
        struct[0].Gy[362,28] = i_load_R16_c_r
        struct[0].Gy[362,29] = i_load_R16_c_i
        struct[0].Gy[362,30] = -i_load_R16_c_r
        struct[0].Gy[362,31] = -i_load_R16_c_i
        struct[0].Gy[362,364] = v_R16_c_r - v_R16_n_r
        struct[0].Gy[362,365] = v_R16_c_i - v_R16_n_i
        struct[0].Gy[363,24] = -i_load_R16_a_i
        struct[0].Gy[363,25] = i_load_R16_a_r
        struct[0].Gy[363,30] = i_load_R16_a_i
        struct[0].Gy[363,31] = -i_load_R16_a_r
        struct[0].Gy[363,360] = v_R16_a_i - v_R16_n_i
        struct[0].Gy[363,361] = -v_R16_a_r + v_R16_n_r
        struct[0].Gy[364,26] = -i_load_R16_b_i
        struct[0].Gy[364,27] = i_load_R16_b_r
        struct[0].Gy[364,30] = i_load_R16_b_i
        struct[0].Gy[364,31] = -i_load_R16_b_r
        struct[0].Gy[364,362] = v_R16_b_i - v_R16_n_i
        struct[0].Gy[364,363] = -v_R16_b_r + v_R16_n_r
        struct[0].Gy[365,28] = -i_load_R16_c_i
        struct[0].Gy[365,29] = i_load_R16_c_r
        struct[0].Gy[365,30] = i_load_R16_c_i
        struct[0].Gy[365,31] = -i_load_R16_c_r
        struct[0].Gy[365,364] = v_R16_c_i - v_R16_n_i
        struct[0].Gy[365,365] = -v_R16_c_r + v_R16_n_r
        struct[0].Gy[368,32] = i_load_R17_a_r
        struct[0].Gy[368,33] = i_load_R17_a_i
        struct[0].Gy[368,38] = -i_load_R17_a_r
        struct[0].Gy[368,39] = -i_load_R17_a_i
        struct[0].Gy[368,368] = v_R17_a_r - v_R17_n_r
        struct[0].Gy[368,369] = v_R17_a_i - v_R17_n_i
        struct[0].Gy[369,34] = i_load_R17_b_r
        struct[0].Gy[369,35] = i_load_R17_b_i
        struct[0].Gy[369,38] = -i_load_R17_b_r
        struct[0].Gy[369,39] = -i_load_R17_b_i
        struct[0].Gy[369,370] = v_R17_b_r - v_R17_n_r
        struct[0].Gy[369,371] = v_R17_b_i - v_R17_n_i
        struct[0].Gy[370,36] = i_load_R17_c_r
        struct[0].Gy[370,37] = i_load_R17_c_i
        struct[0].Gy[370,38] = -i_load_R17_c_r
        struct[0].Gy[370,39] = -i_load_R17_c_i
        struct[0].Gy[370,372] = v_R17_c_r - v_R17_n_r
        struct[0].Gy[370,373] = v_R17_c_i - v_R17_n_i
        struct[0].Gy[371,32] = -i_load_R17_a_i
        struct[0].Gy[371,33] = i_load_R17_a_r
        struct[0].Gy[371,38] = i_load_R17_a_i
        struct[0].Gy[371,39] = -i_load_R17_a_r
        struct[0].Gy[371,368] = v_R17_a_i - v_R17_n_i
        struct[0].Gy[371,369] = -v_R17_a_r + v_R17_n_r
        struct[0].Gy[372,34] = -i_load_R17_b_i
        struct[0].Gy[372,35] = i_load_R17_b_r
        struct[0].Gy[372,38] = i_load_R17_b_i
        struct[0].Gy[372,39] = -i_load_R17_b_r
        struct[0].Gy[372,370] = v_R17_b_i - v_R17_n_i
        struct[0].Gy[372,371] = -v_R17_b_r + v_R17_n_r
        struct[0].Gy[373,36] = -i_load_R17_c_i
        struct[0].Gy[373,37] = i_load_R17_c_r
        struct[0].Gy[373,38] = i_load_R17_c_i
        struct[0].Gy[373,39] = -i_load_R17_c_r
        struct[0].Gy[373,372] = v_R17_c_i - v_R17_n_i
        struct[0].Gy[373,373] = -v_R17_c_r + v_R17_n_r
        struct[0].Gy[376,40] = i_load_R18_a_r
        struct[0].Gy[376,41] = i_load_R18_a_i
        struct[0].Gy[376,46] = -i_load_R18_a_r
        struct[0].Gy[376,47] = -i_load_R18_a_i
        struct[0].Gy[376,376] = v_R18_a_r - v_R18_n_r
        struct[0].Gy[376,377] = v_R18_a_i - v_R18_n_i
        struct[0].Gy[377,42] = i_load_R18_b_r
        struct[0].Gy[377,43] = i_load_R18_b_i
        struct[0].Gy[377,46] = -i_load_R18_b_r
        struct[0].Gy[377,47] = -i_load_R18_b_i
        struct[0].Gy[377,378] = v_R18_b_r - v_R18_n_r
        struct[0].Gy[377,379] = v_R18_b_i - v_R18_n_i
        struct[0].Gy[378,44] = i_load_R18_c_r
        struct[0].Gy[378,45] = i_load_R18_c_i
        struct[0].Gy[378,46] = -i_load_R18_c_r
        struct[0].Gy[378,47] = -i_load_R18_c_i
        struct[0].Gy[378,380] = v_R18_c_r - v_R18_n_r
        struct[0].Gy[378,381] = v_R18_c_i - v_R18_n_i
        struct[0].Gy[379,40] = -i_load_R18_a_i
        struct[0].Gy[379,41] = i_load_R18_a_r
        struct[0].Gy[379,46] = i_load_R18_a_i
        struct[0].Gy[379,47] = -i_load_R18_a_r
        struct[0].Gy[379,376] = v_R18_a_i - v_R18_n_i
        struct[0].Gy[379,377] = -v_R18_a_r + v_R18_n_r
        struct[0].Gy[380,42] = -i_load_R18_b_i
        struct[0].Gy[380,43] = i_load_R18_b_r
        struct[0].Gy[380,46] = i_load_R18_b_i
        struct[0].Gy[380,47] = -i_load_R18_b_r
        struct[0].Gy[380,378] = v_R18_b_i - v_R18_n_i
        struct[0].Gy[380,379] = -v_R18_b_r + v_R18_n_r
        struct[0].Gy[381,44] = -i_load_R18_c_i
        struct[0].Gy[381,45] = i_load_R18_c_r
        struct[0].Gy[381,46] = i_load_R18_c_i
        struct[0].Gy[381,47] = -i_load_R18_c_r
        struct[0].Gy[381,380] = v_R18_c_i - v_R18_n_i
        struct[0].Gy[381,381] = -v_R18_c_r + v_R18_n_r
        struct[0].Gy[384,48] = i_load_D15_a_r
        struct[0].Gy[384,49] = 1.0*i_load_D15_a_i
        struct[0].Gy[384,50] = -i_load_D15_a_r
        struct[0].Gy[384,51] = -1.0*i_load_D15_a_i
        struct[0].Gy[384,384] = v_D15_a_r - v_D15_n_r
        struct[0].Gy[384,385] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy[385,48] = -1.0*i_load_D15_a_i
        struct[0].Gy[385,49] = 1.0*i_load_D15_a_r
        struct[0].Gy[385,50] = 1.0*i_load_D15_a_i
        struct[0].Gy[385,51] = -1.0*i_load_D15_a_r
        struct[0].Gy[385,384] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy[385,385] = -1.0*v_D15_a_r + 1.0*v_D15_n_r
        struct[0].Gy[388,52] = i_load_D11_a_r
        struct[0].Gy[388,53] = 1.0*i_load_D11_a_i
        struct[0].Gy[388,54] = -i_load_D11_a_r
        struct[0].Gy[388,55] = -1.0*i_load_D11_a_i
        struct[0].Gy[388,388] = v_D11_a_r - v_D11_n_r
        struct[0].Gy[388,389] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy[389,52] = -1.0*i_load_D11_a_i
        struct[0].Gy[389,53] = 1.0*i_load_D11_a_r
        struct[0].Gy[389,54] = 1.0*i_load_D11_a_i
        struct[0].Gy[389,55] = -1.0*i_load_D11_a_r
        struct[0].Gy[389,388] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy[389,389] = -1.0*v_D11_a_r + 1.0*v_D11_n_r
        struct[0].Gy[392,56] = i_load_D16_a_r
        struct[0].Gy[392,57] = 1.0*i_load_D16_a_i
        struct[0].Gy[392,58] = -i_load_D16_a_r
        struct[0].Gy[392,59] = -1.0*i_load_D16_a_i
        struct[0].Gy[392,392] = v_D16_a_r - v_D16_n_r
        struct[0].Gy[392,393] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy[393,56] = -1.0*i_load_D16_a_i
        struct[0].Gy[393,57] = 1.0*i_load_D16_a_r
        struct[0].Gy[393,58] = 1.0*i_load_D16_a_i
        struct[0].Gy[393,59] = -1.0*i_load_D16_a_r
        struct[0].Gy[393,392] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy[393,393] = -1.0*v_D16_a_r + 1.0*v_D16_n_r
        struct[0].Gy[396,60] = i_load_D17_a_r
        struct[0].Gy[396,61] = 1.0*i_load_D17_a_i
        struct[0].Gy[396,62] = -i_load_D17_a_r
        struct[0].Gy[396,63] = -1.0*i_load_D17_a_i
        struct[0].Gy[396,396] = v_D17_a_r - v_D17_n_r
        struct[0].Gy[396,397] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy[397,60] = -1.0*i_load_D17_a_i
        struct[0].Gy[397,61] = 1.0*i_load_D17_a_r
        struct[0].Gy[397,62] = 1.0*i_load_D17_a_i
        struct[0].Gy[397,63] = -1.0*i_load_D17_a_r
        struct[0].Gy[397,396] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy[397,397] = -1.0*v_D17_a_r + 1.0*v_D17_n_r
        struct[0].Gy[400,64] = i_load_D18_a_r
        struct[0].Gy[400,65] = 1.0*i_load_D18_a_i
        struct[0].Gy[400,66] = -i_load_D18_a_r
        struct[0].Gy[400,67] = -1.0*i_load_D18_a_i
        struct[0].Gy[400,400] = v_D18_a_r - v_D18_n_r
        struct[0].Gy[400,401] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy[401,64] = -1.0*i_load_D18_a_i
        struct[0].Gy[401,65] = 1.0*i_load_D18_a_r
        struct[0].Gy[401,66] = 1.0*i_load_D18_a_i
        struct[0].Gy[401,67] = -1.0*i_load_D18_a_r
        struct[0].Gy[401,400] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy[401,401] = -1.0*v_D18_a_r + 1.0*v_D18_n_r
        struct[0].Gy[404,0] = i_vsc_R1_a_r
        struct[0].Gy[404,1] = 1.0*i_vsc_R1_a_i
        struct[0].Gy[404,6] = -i_vsc_R1_a_r
        struct[0].Gy[404,7] = -1.0*i_vsc_R1_a_i
        struct[0].Gy[404,404] = v_R1_a_r - v_R1_n_r
        struct[0].Gy[404,405] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy[405,0] = -1.0*i_vsc_R1_a_i
        struct[0].Gy[405,1] = 1.0*i_vsc_R1_a_r
        struct[0].Gy[405,6] = 1.0*i_vsc_R1_a_i
        struct[0].Gy[405,7] = -1.0*i_vsc_R1_a_r
        struct[0].Gy[405,404] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy[405,405] = -1.0*v_R1_a_r + 1.0*v_R1_n_r
        struct[0].Gy[406,2] = i_vsc_R1_b_r
        struct[0].Gy[406,3] = 1.0*i_vsc_R1_b_i
        struct[0].Gy[406,6] = -i_vsc_R1_b_r
        struct[0].Gy[406,7] = -1.0*i_vsc_R1_b_i
        struct[0].Gy[406,406] = v_R1_b_r - v_R1_n_r
        struct[0].Gy[406,407] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy[407,2] = -1.0*i_vsc_R1_b_i
        struct[0].Gy[407,3] = 1.0*i_vsc_R1_b_r
        struct[0].Gy[407,6] = 1.0*i_vsc_R1_b_i
        struct[0].Gy[407,7] = -1.0*i_vsc_R1_b_r
        struct[0].Gy[407,406] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy[407,407] = -1.0*v_R1_b_r + 1.0*v_R1_n_r
        struct[0].Gy[408,4] = i_vsc_R1_c_r
        struct[0].Gy[408,5] = 1.0*i_vsc_R1_c_i
        struct[0].Gy[408,6] = -i_vsc_R1_c_r
        struct[0].Gy[408,7] = -1.0*i_vsc_R1_c_i
        struct[0].Gy[408,408] = v_R1_c_r - v_R1_n_r
        struct[0].Gy[408,409] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy[409,4] = -1.0*i_vsc_R1_c_i
        struct[0].Gy[409,5] = 1.0*i_vsc_R1_c_r
        struct[0].Gy[409,6] = 1.0*i_vsc_R1_c_i
        struct[0].Gy[409,7] = -1.0*i_vsc_R1_c_r
        struct[0].Gy[409,408] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy[409,409] = -1.0*v_R1_c_r + 1.0*v_R1_n_r
        struct[0].Gy[410,412] = Piecewise(np.array([(-1, p_D1 < 0), (1, True)]))
        struct[0].Gy[411,248] = v_D1_a_r
        struct[0].Gy[411,254] = v_D1_n_r
        struct[0].Gy[412,404] = -b_R1*i_vsc_R1_a_r/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_r
        struct[0].Gy[412,405] = -b_R1*i_vsc_R1_a_i/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_i
        struct[0].Gy[413,132] = i_vsc_R10_a_r
        struct[0].Gy[413,133] = 1.0*i_vsc_R10_a_i
        struct[0].Gy[413,138] = -i_vsc_R10_a_r
        struct[0].Gy[413,139] = -1.0*i_vsc_R10_a_i
        struct[0].Gy[413,413] = v_R10_a_r - v_R10_n_r
        struct[0].Gy[413,414] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy[414,132] = -1.0*i_vsc_R10_a_i
        struct[0].Gy[414,133] = 1.0*i_vsc_R10_a_r
        struct[0].Gy[414,138] = 1.0*i_vsc_R10_a_i
        struct[0].Gy[414,139] = -1.0*i_vsc_R10_a_r
        struct[0].Gy[414,413] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy[414,414] = -1.0*v_R10_a_r + 1.0*v_R10_n_r
        struct[0].Gy[415,134] = i_vsc_R10_b_r
        struct[0].Gy[415,135] = 1.0*i_vsc_R10_b_i
        struct[0].Gy[415,138] = -i_vsc_R10_b_r
        struct[0].Gy[415,139] = -1.0*i_vsc_R10_b_i
        struct[0].Gy[415,415] = v_R10_b_r - v_R10_n_r
        struct[0].Gy[415,416] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy[416,134] = -1.0*i_vsc_R10_b_i
        struct[0].Gy[416,135] = 1.0*i_vsc_R10_b_r
        struct[0].Gy[416,138] = 1.0*i_vsc_R10_b_i
        struct[0].Gy[416,139] = -1.0*i_vsc_R10_b_r
        struct[0].Gy[416,415] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy[416,416] = -1.0*v_R10_b_r + 1.0*v_R10_n_r
        struct[0].Gy[417,136] = i_vsc_R10_c_r
        struct[0].Gy[417,137] = 1.0*i_vsc_R10_c_i
        struct[0].Gy[417,138] = -i_vsc_R10_c_r
        struct[0].Gy[417,139] = -1.0*i_vsc_R10_c_i
        struct[0].Gy[417,417] = v_R10_c_r - v_R10_n_r
        struct[0].Gy[417,418] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy[418,136] = -1.0*i_vsc_R10_c_i
        struct[0].Gy[418,137] = 1.0*i_vsc_R10_c_r
        struct[0].Gy[418,138] = 1.0*i_vsc_R10_c_i
        struct[0].Gy[418,139] = -1.0*i_vsc_R10_c_r
        struct[0].Gy[418,417] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy[418,418] = -1.0*v_R10_c_r + 1.0*v_R10_n_r
        struct[0].Gy[419,198] = -p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[419,204] = p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[419,421] = 1/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].Gy[420,198] = p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[420,204] = -p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[420,421] = 1/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].Gy[421,422] = -Piecewise(np.array([(-1, p_D10 < 0), (1, True)]))
        struct[0].Gy[422,413] = -b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_r
        struct[0].Gy[422,414] = -b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_i
        struct[0].Gy[423,156] = i_vsc_R14_a_r
        struct[0].Gy[423,157] = 1.0*i_vsc_R14_a_i
        struct[0].Gy[423,162] = -i_vsc_R14_a_r
        struct[0].Gy[423,163] = -1.0*i_vsc_R14_a_i
        struct[0].Gy[423,423] = v_R14_a_r - v_R14_n_r
        struct[0].Gy[423,424] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy[424,156] = -1.0*i_vsc_R14_a_i
        struct[0].Gy[424,157] = 1.0*i_vsc_R14_a_r
        struct[0].Gy[424,162] = 1.0*i_vsc_R14_a_i
        struct[0].Gy[424,163] = -1.0*i_vsc_R14_a_r
        struct[0].Gy[424,423] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy[424,424] = -1.0*v_R14_a_r + 1.0*v_R14_n_r
        struct[0].Gy[425,158] = i_vsc_R14_b_r
        struct[0].Gy[425,159] = 1.0*i_vsc_R14_b_i
        struct[0].Gy[425,162] = -i_vsc_R14_b_r
        struct[0].Gy[425,163] = -1.0*i_vsc_R14_b_i
        struct[0].Gy[425,425] = v_R14_b_r - v_R14_n_r
        struct[0].Gy[425,426] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy[426,158] = -1.0*i_vsc_R14_b_i
        struct[0].Gy[426,159] = 1.0*i_vsc_R14_b_r
        struct[0].Gy[426,162] = 1.0*i_vsc_R14_b_i
        struct[0].Gy[426,163] = -1.0*i_vsc_R14_b_r
        struct[0].Gy[426,425] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy[426,426] = -1.0*v_R14_b_r + 1.0*v_R14_n_r
        struct[0].Gy[427,160] = i_vsc_R14_c_r
        struct[0].Gy[427,161] = 1.0*i_vsc_R14_c_i
        struct[0].Gy[427,162] = -i_vsc_R14_c_r
        struct[0].Gy[427,163] = -1.0*i_vsc_R14_c_i
        struct[0].Gy[427,427] = v_R14_c_r - v_R14_n_r
        struct[0].Gy[427,428] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy[428,160] = -1.0*i_vsc_R14_c_i
        struct[0].Gy[428,161] = 1.0*i_vsc_R14_c_r
        struct[0].Gy[428,162] = 1.0*i_vsc_R14_c_i
        struct[0].Gy[428,163] = -1.0*i_vsc_R14_c_r
        struct[0].Gy[428,427] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy[428,428] = -1.0*v_R14_c_r + 1.0*v_R14_n_r
        struct[0].Gy[429,222] = -p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[429,228] = p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[429,431] = 1/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].Gy[430,222] = p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[430,228] = -p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[430,431] = 1/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].Gy[431,432] = -Piecewise(np.array([(-1, p_D14 < 0), (1, True)]))
        struct[0].Gy[432,423] = -b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_r
        struct[0].Gy[432,424] = -b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_i

    if mode > 12:


        struct[0].Gu[413,234] = -coef_a_R10
        struct[0].Gu[414,235] = -coef_a_R10
        struct[0].Gu[415,234] = -coef_b_R10
        struct[0].Gu[416,235] = -coef_b_R10
        struct[0].Gu[417,234] = -coef_c_R10
        struct[0].Gu[418,235] = -coef_c_R10
        struct[0].Gu[423,236] = -coef_a_R14
        struct[0].Gu[424,237] = -coef_a_R14
        struct[0].Gu[425,236] = -coef_b_R14
        struct[0].Gu[426,237] = -coef_b_R14
        struct[0].Gu[427,236] = -coef_c_R14
        struct[0].Gu[428,237] = -coef_c_R14


        struct[0].Hy[6,0] = 1.0*v_R1_a_r*(v_R1_a_i**2 + v_R1_a_r**2)**(-0.5)
        struct[0].Hy[6,1] = 1.0*v_R1_a_i*(v_R1_a_i**2 + v_R1_a_r**2)**(-0.5)
        struct[0].Hy[7,2] = 1.0*v_R1_b_r*(v_R1_b_i**2 + v_R1_b_r**2)**(-0.5)
        struct[0].Hy[7,3] = 1.0*v_R1_b_i*(v_R1_b_i**2 + v_R1_b_r**2)**(-0.5)
        struct[0].Hy[8,4] = 1.0*v_R1_c_r*(v_R1_c_i**2 + v_R1_c_r**2)**(-0.5)
        struct[0].Hy[8,5] = 1.0*v_R1_c_i*(v_R1_c_i**2 + v_R1_c_r**2)**(-0.5)
        struct[0].Hy[9,6] = 1.0*v_R1_n_r*(v_R1_n_i**2 + v_R1_n_r**2)**(-0.5)
        struct[0].Hy[9,7] = 1.0*v_R1_n_i*(v_R1_n_i**2 + v_R1_n_r**2)**(-0.5)
        struct[0].Hy[10,8] = 1.0*v_R11_a_r*(v_R11_a_i**2 + v_R11_a_r**2)**(-0.5)
        struct[0].Hy[10,9] = 1.0*v_R11_a_i*(v_R11_a_i**2 + v_R11_a_r**2)**(-0.5)
        struct[0].Hy[11,10] = 1.0*v_R11_b_r*(v_R11_b_i**2 + v_R11_b_r**2)**(-0.5)
        struct[0].Hy[11,11] = 1.0*v_R11_b_i*(v_R11_b_i**2 + v_R11_b_r**2)**(-0.5)
        struct[0].Hy[12,12] = 1.0*v_R11_c_r*(v_R11_c_i**2 + v_R11_c_r**2)**(-0.5)
        struct[0].Hy[12,13] = 1.0*v_R11_c_i*(v_R11_c_i**2 + v_R11_c_r**2)**(-0.5)
        struct[0].Hy[13,14] = 1.0*v_R11_n_r*(v_R11_n_i**2 + v_R11_n_r**2)**(-0.5)
        struct[0].Hy[13,15] = 1.0*v_R11_n_i*(v_R11_n_i**2 + v_R11_n_r**2)**(-0.5)
        struct[0].Hy[14,16] = 1.0*v_R15_a_r*(v_R15_a_i**2 + v_R15_a_r**2)**(-0.5)
        struct[0].Hy[14,17] = 1.0*v_R15_a_i*(v_R15_a_i**2 + v_R15_a_r**2)**(-0.5)
        struct[0].Hy[15,18] = 1.0*v_R15_b_r*(v_R15_b_i**2 + v_R15_b_r**2)**(-0.5)
        struct[0].Hy[15,19] = 1.0*v_R15_b_i*(v_R15_b_i**2 + v_R15_b_r**2)**(-0.5)
        struct[0].Hy[16,20] = 1.0*v_R15_c_r*(v_R15_c_i**2 + v_R15_c_r**2)**(-0.5)
        struct[0].Hy[16,21] = 1.0*v_R15_c_i*(v_R15_c_i**2 + v_R15_c_r**2)**(-0.5)
        struct[0].Hy[17,22] = 1.0*v_R15_n_r*(v_R15_n_i**2 + v_R15_n_r**2)**(-0.5)
        struct[0].Hy[17,23] = 1.0*v_R15_n_i*(v_R15_n_i**2 + v_R15_n_r**2)**(-0.5)
        struct[0].Hy[18,24] = 1.0*v_R16_a_r*(v_R16_a_i**2 + v_R16_a_r**2)**(-0.5)
        struct[0].Hy[18,25] = 1.0*v_R16_a_i*(v_R16_a_i**2 + v_R16_a_r**2)**(-0.5)
        struct[0].Hy[19,26] = 1.0*v_R16_b_r*(v_R16_b_i**2 + v_R16_b_r**2)**(-0.5)
        struct[0].Hy[19,27] = 1.0*v_R16_b_i*(v_R16_b_i**2 + v_R16_b_r**2)**(-0.5)
        struct[0].Hy[20,28] = 1.0*v_R16_c_r*(v_R16_c_i**2 + v_R16_c_r**2)**(-0.5)
        struct[0].Hy[20,29] = 1.0*v_R16_c_i*(v_R16_c_i**2 + v_R16_c_r**2)**(-0.5)
        struct[0].Hy[21,30] = 1.0*v_R16_n_r*(v_R16_n_i**2 + v_R16_n_r**2)**(-0.5)
        struct[0].Hy[21,31] = 1.0*v_R16_n_i*(v_R16_n_i**2 + v_R16_n_r**2)**(-0.5)
        struct[0].Hy[22,32] = 1.0*v_R17_a_r*(v_R17_a_i**2 + v_R17_a_r**2)**(-0.5)
        struct[0].Hy[22,33] = 1.0*v_R17_a_i*(v_R17_a_i**2 + v_R17_a_r**2)**(-0.5)
        struct[0].Hy[23,34] = 1.0*v_R17_b_r*(v_R17_b_i**2 + v_R17_b_r**2)**(-0.5)
        struct[0].Hy[23,35] = 1.0*v_R17_b_i*(v_R17_b_i**2 + v_R17_b_r**2)**(-0.5)
        struct[0].Hy[24,36] = 1.0*v_R17_c_r*(v_R17_c_i**2 + v_R17_c_r**2)**(-0.5)
        struct[0].Hy[24,37] = 1.0*v_R17_c_i*(v_R17_c_i**2 + v_R17_c_r**2)**(-0.5)
        struct[0].Hy[25,38] = 1.0*v_R17_n_r*(v_R17_n_i**2 + v_R17_n_r**2)**(-0.5)
        struct[0].Hy[25,39] = 1.0*v_R17_n_i*(v_R17_n_i**2 + v_R17_n_r**2)**(-0.5)
        struct[0].Hy[26,40] = 1.0*v_R18_a_r*(v_R18_a_i**2 + v_R18_a_r**2)**(-0.5)
        struct[0].Hy[26,41] = 1.0*v_R18_a_i*(v_R18_a_i**2 + v_R18_a_r**2)**(-0.5)
        struct[0].Hy[27,42] = 1.0*v_R18_b_r*(v_R18_b_i**2 + v_R18_b_r**2)**(-0.5)
        struct[0].Hy[27,43] = 1.0*v_R18_b_i*(v_R18_b_i**2 + v_R18_b_r**2)**(-0.5)
        struct[0].Hy[28,44] = 1.0*v_R18_c_r*(v_R18_c_i**2 + v_R18_c_r**2)**(-0.5)
        struct[0].Hy[28,45] = 1.0*v_R18_c_i*(v_R18_c_i**2 + v_R18_c_r**2)**(-0.5)
        struct[0].Hy[29,46] = 1.0*v_R18_n_r*(v_R18_n_i**2 + v_R18_n_r**2)**(-0.5)
        struct[0].Hy[29,47] = 1.0*v_R18_n_i*(v_R18_n_i**2 + v_R18_n_r**2)**(-0.5)
        struct[0].Hy[30,48] = 1.0*v_D15_a_r*(v_D15_a_i**2 + v_D15_a_r**2)**(-0.5)
        struct[0].Hy[30,49] = 1.0*v_D15_a_i*(v_D15_a_i**2 + v_D15_a_r**2)**(-0.5)
        struct[0].Hy[31,50] = 1.0*v_D15_n_r*(v_D15_n_i**2 + v_D15_n_r**2)**(-0.5)
        struct[0].Hy[31,51] = 1.0*v_D15_n_i*(v_D15_n_i**2 + v_D15_n_r**2)**(-0.5)
        struct[0].Hy[32,52] = 1.0*v_D11_a_r*(v_D11_a_i**2 + v_D11_a_r**2)**(-0.5)
        struct[0].Hy[32,53] = 1.0*v_D11_a_i*(v_D11_a_i**2 + v_D11_a_r**2)**(-0.5)
        struct[0].Hy[33,54] = 1.0*v_D11_n_r*(v_D11_n_i**2 + v_D11_n_r**2)**(-0.5)
        struct[0].Hy[33,55] = 1.0*v_D11_n_i*(v_D11_n_i**2 + v_D11_n_r**2)**(-0.5)
        struct[0].Hy[34,56] = 1.0*v_D16_a_r*(v_D16_a_i**2 + v_D16_a_r**2)**(-0.5)
        struct[0].Hy[34,57] = 1.0*v_D16_a_i*(v_D16_a_i**2 + v_D16_a_r**2)**(-0.5)
        struct[0].Hy[35,58] = 1.0*v_D16_n_r*(v_D16_n_i**2 + v_D16_n_r**2)**(-0.5)
        struct[0].Hy[35,59] = 1.0*v_D16_n_i*(v_D16_n_i**2 + v_D16_n_r**2)**(-0.5)
        struct[0].Hy[36,60] = 1.0*v_D17_a_r*(v_D17_a_i**2 + v_D17_a_r**2)**(-0.5)
        struct[0].Hy[36,61] = 1.0*v_D17_a_i*(v_D17_a_i**2 + v_D17_a_r**2)**(-0.5)
        struct[0].Hy[37,62] = 1.0*v_D17_n_r*(v_D17_n_i**2 + v_D17_n_r**2)**(-0.5)
        struct[0].Hy[37,63] = 1.0*v_D17_n_i*(v_D17_n_i**2 + v_D17_n_r**2)**(-0.5)
        struct[0].Hy[38,64] = 1.0*v_D18_a_r*(v_D18_a_i**2 + v_D18_a_r**2)**(-0.5)
        struct[0].Hy[38,65] = 1.0*v_D18_a_i*(v_D18_a_i**2 + v_D18_a_r**2)**(-0.5)
        struct[0].Hy[39,66] = 1.0*v_D18_n_r*(v_D18_n_i**2 + v_D18_n_r**2)**(-0.5)
        struct[0].Hy[39,67] = 1.0*v_D18_n_i*(v_D18_n_i**2 + v_D18_n_r**2)**(-0.5)
        struct[0].Hy[40,68] = 1.0*v_R2_a_r*(v_R2_a_i**2 + v_R2_a_r**2)**(-0.5)
        struct[0].Hy[40,69] = 1.0*v_R2_a_i*(v_R2_a_i**2 + v_R2_a_r**2)**(-0.5)
        struct[0].Hy[41,70] = 1.0*v_R2_b_r*(v_R2_b_i**2 + v_R2_b_r**2)**(-0.5)
        struct[0].Hy[41,71] = 1.0*v_R2_b_i*(v_R2_b_i**2 + v_R2_b_r**2)**(-0.5)
        struct[0].Hy[42,72] = 1.0*v_R2_c_r*(v_R2_c_i**2 + v_R2_c_r**2)**(-0.5)
        struct[0].Hy[42,73] = 1.0*v_R2_c_i*(v_R2_c_i**2 + v_R2_c_r**2)**(-0.5)
        struct[0].Hy[43,74] = 1.0*v_R2_n_r*(v_R2_n_i**2 + v_R2_n_r**2)**(-0.5)
        struct[0].Hy[43,75] = 1.0*v_R2_n_i*(v_R2_n_i**2 + v_R2_n_r**2)**(-0.5)
        struct[0].Hy[44,76] = 1.0*v_R3_a_r*(v_R3_a_i**2 + v_R3_a_r**2)**(-0.5)
        struct[0].Hy[44,77] = 1.0*v_R3_a_i*(v_R3_a_i**2 + v_R3_a_r**2)**(-0.5)
        struct[0].Hy[45,78] = 1.0*v_R3_b_r*(v_R3_b_i**2 + v_R3_b_r**2)**(-0.5)
        struct[0].Hy[45,79] = 1.0*v_R3_b_i*(v_R3_b_i**2 + v_R3_b_r**2)**(-0.5)
        struct[0].Hy[46,80] = 1.0*v_R3_c_r*(v_R3_c_i**2 + v_R3_c_r**2)**(-0.5)
        struct[0].Hy[46,81] = 1.0*v_R3_c_i*(v_R3_c_i**2 + v_R3_c_r**2)**(-0.5)
        struct[0].Hy[47,82] = 1.0*v_R3_n_r*(v_R3_n_i**2 + v_R3_n_r**2)**(-0.5)
        struct[0].Hy[47,83] = 1.0*v_R3_n_i*(v_R3_n_i**2 + v_R3_n_r**2)**(-0.5)
        struct[0].Hy[48,84] = 1.0*v_R4_a_r*(v_R4_a_i**2 + v_R4_a_r**2)**(-0.5)
        struct[0].Hy[48,85] = 1.0*v_R4_a_i*(v_R4_a_i**2 + v_R4_a_r**2)**(-0.5)
        struct[0].Hy[49,86] = 1.0*v_R4_b_r*(v_R4_b_i**2 + v_R4_b_r**2)**(-0.5)
        struct[0].Hy[49,87] = 1.0*v_R4_b_i*(v_R4_b_i**2 + v_R4_b_r**2)**(-0.5)
        struct[0].Hy[50,88] = 1.0*v_R4_c_r*(v_R4_c_i**2 + v_R4_c_r**2)**(-0.5)
        struct[0].Hy[50,89] = 1.0*v_R4_c_i*(v_R4_c_i**2 + v_R4_c_r**2)**(-0.5)
        struct[0].Hy[51,90] = 1.0*v_R4_n_r*(v_R4_n_i**2 + v_R4_n_r**2)**(-0.5)
        struct[0].Hy[51,91] = 1.0*v_R4_n_i*(v_R4_n_i**2 + v_R4_n_r**2)**(-0.5)
        struct[0].Hy[52,92] = 1.0*v_R5_a_r*(v_R5_a_i**2 + v_R5_a_r**2)**(-0.5)
        struct[0].Hy[52,93] = 1.0*v_R5_a_i*(v_R5_a_i**2 + v_R5_a_r**2)**(-0.5)
        struct[0].Hy[53,94] = 1.0*v_R5_b_r*(v_R5_b_i**2 + v_R5_b_r**2)**(-0.5)
        struct[0].Hy[53,95] = 1.0*v_R5_b_i*(v_R5_b_i**2 + v_R5_b_r**2)**(-0.5)
        struct[0].Hy[54,96] = 1.0*v_R5_c_r*(v_R5_c_i**2 + v_R5_c_r**2)**(-0.5)
        struct[0].Hy[54,97] = 1.0*v_R5_c_i*(v_R5_c_i**2 + v_R5_c_r**2)**(-0.5)
        struct[0].Hy[55,98] = 1.0*v_R5_n_r*(v_R5_n_i**2 + v_R5_n_r**2)**(-0.5)
        struct[0].Hy[55,99] = 1.0*v_R5_n_i*(v_R5_n_i**2 + v_R5_n_r**2)**(-0.5)
        struct[0].Hy[56,100] = 1.0*v_R6_a_r*(v_R6_a_i**2 + v_R6_a_r**2)**(-0.5)
        struct[0].Hy[56,101] = 1.0*v_R6_a_i*(v_R6_a_i**2 + v_R6_a_r**2)**(-0.5)
        struct[0].Hy[57,102] = 1.0*v_R6_b_r*(v_R6_b_i**2 + v_R6_b_r**2)**(-0.5)
        struct[0].Hy[57,103] = 1.0*v_R6_b_i*(v_R6_b_i**2 + v_R6_b_r**2)**(-0.5)
        struct[0].Hy[58,104] = 1.0*v_R6_c_r*(v_R6_c_i**2 + v_R6_c_r**2)**(-0.5)
        struct[0].Hy[58,105] = 1.0*v_R6_c_i*(v_R6_c_i**2 + v_R6_c_r**2)**(-0.5)
        struct[0].Hy[59,106] = 1.0*v_R6_n_r*(v_R6_n_i**2 + v_R6_n_r**2)**(-0.5)
        struct[0].Hy[59,107] = 1.0*v_R6_n_i*(v_R6_n_i**2 + v_R6_n_r**2)**(-0.5)
        struct[0].Hy[60,108] = 1.0*v_R7_a_r*(v_R7_a_i**2 + v_R7_a_r**2)**(-0.5)
        struct[0].Hy[60,109] = 1.0*v_R7_a_i*(v_R7_a_i**2 + v_R7_a_r**2)**(-0.5)
        struct[0].Hy[61,110] = 1.0*v_R7_b_r*(v_R7_b_i**2 + v_R7_b_r**2)**(-0.5)
        struct[0].Hy[61,111] = 1.0*v_R7_b_i*(v_R7_b_i**2 + v_R7_b_r**2)**(-0.5)
        struct[0].Hy[62,112] = 1.0*v_R7_c_r*(v_R7_c_i**2 + v_R7_c_r**2)**(-0.5)
        struct[0].Hy[62,113] = 1.0*v_R7_c_i*(v_R7_c_i**2 + v_R7_c_r**2)**(-0.5)
        struct[0].Hy[63,114] = 1.0*v_R7_n_r*(v_R7_n_i**2 + v_R7_n_r**2)**(-0.5)
        struct[0].Hy[63,115] = 1.0*v_R7_n_i*(v_R7_n_i**2 + v_R7_n_r**2)**(-0.5)
        struct[0].Hy[64,116] = 1.0*v_R8_a_r*(v_R8_a_i**2 + v_R8_a_r**2)**(-0.5)
        struct[0].Hy[64,117] = 1.0*v_R8_a_i*(v_R8_a_i**2 + v_R8_a_r**2)**(-0.5)
        struct[0].Hy[65,118] = 1.0*v_R8_b_r*(v_R8_b_i**2 + v_R8_b_r**2)**(-0.5)
        struct[0].Hy[65,119] = 1.0*v_R8_b_i*(v_R8_b_i**2 + v_R8_b_r**2)**(-0.5)
        struct[0].Hy[66,120] = 1.0*v_R8_c_r*(v_R8_c_i**2 + v_R8_c_r**2)**(-0.5)
        struct[0].Hy[66,121] = 1.0*v_R8_c_i*(v_R8_c_i**2 + v_R8_c_r**2)**(-0.5)
        struct[0].Hy[67,122] = 1.0*v_R8_n_r*(v_R8_n_i**2 + v_R8_n_r**2)**(-0.5)
        struct[0].Hy[67,123] = 1.0*v_R8_n_i*(v_R8_n_i**2 + v_R8_n_r**2)**(-0.5)
        struct[0].Hy[68,124] = 1.0*v_R9_a_r*(v_R9_a_i**2 + v_R9_a_r**2)**(-0.5)
        struct[0].Hy[68,125] = 1.0*v_R9_a_i*(v_R9_a_i**2 + v_R9_a_r**2)**(-0.5)
        struct[0].Hy[69,126] = 1.0*v_R9_b_r*(v_R9_b_i**2 + v_R9_b_r**2)**(-0.5)
        struct[0].Hy[69,127] = 1.0*v_R9_b_i*(v_R9_b_i**2 + v_R9_b_r**2)**(-0.5)
        struct[0].Hy[70,128] = 1.0*v_R9_c_r*(v_R9_c_i**2 + v_R9_c_r**2)**(-0.5)
        struct[0].Hy[70,129] = 1.0*v_R9_c_i*(v_R9_c_i**2 + v_R9_c_r**2)**(-0.5)
        struct[0].Hy[71,130] = 1.0*v_R9_n_r*(v_R9_n_i**2 + v_R9_n_r**2)**(-0.5)
        struct[0].Hy[71,131] = 1.0*v_R9_n_i*(v_R9_n_i**2 + v_R9_n_r**2)**(-0.5)
        struct[0].Hy[72,132] = 1.0*v_R10_a_r*(v_R10_a_i**2 + v_R10_a_r**2)**(-0.5)
        struct[0].Hy[72,133] = 1.0*v_R10_a_i*(v_R10_a_i**2 + v_R10_a_r**2)**(-0.5)
        struct[0].Hy[73,134] = 1.0*v_R10_b_r*(v_R10_b_i**2 + v_R10_b_r**2)**(-0.5)
        struct[0].Hy[73,135] = 1.0*v_R10_b_i*(v_R10_b_i**2 + v_R10_b_r**2)**(-0.5)
        struct[0].Hy[74,136] = 1.0*v_R10_c_r*(v_R10_c_i**2 + v_R10_c_r**2)**(-0.5)
        struct[0].Hy[74,137] = 1.0*v_R10_c_i*(v_R10_c_i**2 + v_R10_c_r**2)**(-0.5)
        struct[0].Hy[75,138] = 1.0*v_R10_n_r*(v_R10_n_i**2 + v_R10_n_r**2)**(-0.5)
        struct[0].Hy[75,139] = 1.0*v_R10_n_i*(v_R10_n_i**2 + v_R10_n_r**2)**(-0.5)
        struct[0].Hy[76,140] = 1.0*v_R12_a_r*(v_R12_a_i**2 + v_R12_a_r**2)**(-0.5)
        struct[0].Hy[76,141] = 1.0*v_R12_a_i*(v_R12_a_i**2 + v_R12_a_r**2)**(-0.5)
        struct[0].Hy[77,142] = 1.0*v_R12_b_r*(v_R12_b_i**2 + v_R12_b_r**2)**(-0.5)
        struct[0].Hy[77,143] = 1.0*v_R12_b_i*(v_R12_b_i**2 + v_R12_b_r**2)**(-0.5)
        struct[0].Hy[78,144] = 1.0*v_R12_c_r*(v_R12_c_i**2 + v_R12_c_r**2)**(-0.5)
        struct[0].Hy[78,145] = 1.0*v_R12_c_i*(v_R12_c_i**2 + v_R12_c_r**2)**(-0.5)
        struct[0].Hy[79,146] = 1.0*v_R12_n_r*(v_R12_n_i**2 + v_R12_n_r**2)**(-0.5)
        struct[0].Hy[79,147] = 1.0*v_R12_n_i*(v_R12_n_i**2 + v_R12_n_r**2)**(-0.5)
        struct[0].Hy[80,148] = 1.0*v_R13_a_r*(v_R13_a_i**2 + v_R13_a_r**2)**(-0.5)
        struct[0].Hy[80,149] = 1.0*v_R13_a_i*(v_R13_a_i**2 + v_R13_a_r**2)**(-0.5)
        struct[0].Hy[81,150] = 1.0*v_R13_b_r*(v_R13_b_i**2 + v_R13_b_r**2)**(-0.5)
        struct[0].Hy[81,151] = 1.0*v_R13_b_i*(v_R13_b_i**2 + v_R13_b_r**2)**(-0.5)
        struct[0].Hy[82,152] = 1.0*v_R13_c_r*(v_R13_c_i**2 + v_R13_c_r**2)**(-0.5)
        struct[0].Hy[82,153] = 1.0*v_R13_c_i*(v_R13_c_i**2 + v_R13_c_r**2)**(-0.5)
        struct[0].Hy[83,154] = 1.0*v_R13_n_r*(v_R13_n_i**2 + v_R13_n_r**2)**(-0.5)
        struct[0].Hy[83,155] = 1.0*v_R13_n_i*(v_R13_n_i**2 + v_R13_n_r**2)**(-0.5)
        struct[0].Hy[84,156] = 1.0*v_R14_a_r*(v_R14_a_i**2 + v_R14_a_r**2)**(-0.5)
        struct[0].Hy[84,157] = 1.0*v_R14_a_i*(v_R14_a_i**2 + v_R14_a_r**2)**(-0.5)
        struct[0].Hy[85,158] = 1.0*v_R14_b_r*(v_R14_b_i**2 + v_R14_b_r**2)**(-0.5)
        struct[0].Hy[85,159] = 1.0*v_R14_b_i*(v_R14_b_i**2 + v_R14_b_r**2)**(-0.5)
        struct[0].Hy[86,160] = 1.0*v_R14_c_r*(v_R14_c_i**2 + v_R14_c_r**2)**(-0.5)
        struct[0].Hy[86,161] = 1.0*v_R14_c_i*(v_R14_c_i**2 + v_R14_c_r**2)**(-0.5)
        struct[0].Hy[87,162] = 1.0*v_R14_n_r*(v_R14_n_i**2 + v_R14_n_r**2)**(-0.5)
        struct[0].Hy[87,163] = 1.0*v_R14_n_i*(v_R14_n_i**2 + v_R14_n_r**2)**(-0.5)
        struct[0].Hy[88,164] = 1.0*v_D1_n_r*(v_D1_n_i**2 + v_D1_n_r**2)**(-0.5)
        struct[0].Hy[88,165] = 1.0*v_D1_n_i*(v_D1_n_i**2 + v_D1_n_r**2)**(-0.5)
        struct[0].Hy[89,166] = 1.0*v_D3_a_r*(v_D3_a_i**2 + v_D3_a_r**2)**(-0.5)
        struct[0].Hy[89,167] = 1.0*v_D3_a_i*(v_D3_a_i**2 + v_D3_a_r**2)**(-0.5)
        struct[0].Hy[90,168] = 1.0*v_D3_b_r*(v_D3_b_i**2 + v_D3_b_r**2)**(-0.5)
        struct[0].Hy[90,169] = 1.0*v_D3_b_i*(v_D3_b_i**2 + v_D3_b_r**2)**(-0.5)
        struct[0].Hy[91,170] = 1.0*v_D3_c_r*(v_D3_c_i**2 + v_D3_c_r**2)**(-0.5)
        struct[0].Hy[91,171] = 1.0*v_D3_c_i*(v_D3_c_i**2 + v_D3_c_r**2)**(-0.5)
        struct[0].Hy[92,172] = 1.0*v_D3_n_r*(v_D3_n_i**2 + v_D3_n_r**2)**(-0.5)
        struct[0].Hy[92,173] = 1.0*v_D3_n_i*(v_D3_n_i**2 + v_D3_n_r**2)**(-0.5)
        struct[0].Hy[93,174] = 1.0*v_D4_a_r*(v_D4_a_i**2 + v_D4_a_r**2)**(-0.5)
        struct[0].Hy[93,175] = 1.0*v_D4_a_i*(v_D4_a_i**2 + v_D4_a_r**2)**(-0.5)
        struct[0].Hy[94,176] = 1.0*v_D4_b_r*(v_D4_b_i**2 + v_D4_b_r**2)**(-0.5)
        struct[0].Hy[94,177] = 1.0*v_D4_b_i*(v_D4_b_i**2 + v_D4_b_r**2)**(-0.5)
        struct[0].Hy[95,178] = 1.0*v_D4_c_r*(v_D4_c_i**2 + v_D4_c_r**2)**(-0.5)
        struct[0].Hy[95,179] = 1.0*v_D4_c_i*(v_D4_c_i**2 + v_D4_c_r**2)**(-0.5)
        struct[0].Hy[96,180] = 1.0*v_D4_n_r*(v_D4_n_i**2 + v_D4_n_r**2)**(-0.5)
        struct[0].Hy[96,181] = 1.0*v_D4_n_i*(v_D4_n_i**2 + v_D4_n_r**2)**(-0.5)
        struct[0].Hy[97,182] = 1.0*v_D6_a_r*(v_D6_a_i**2 + v_D6_a_r**2)**(-0.5)
        struct[0].Hy[97,183] = 1.0*v_D6_a_i*(v_D6_a_i**2 + v_D6_a_r**2)**(-0.5)
        struct[0].Hy[98,184] = 1.0*v_D6_b_r*(v_D6_b_i**2 + v_D6_b_r**2)**(-0.5)
        struct[0].Hy[98,185] = 1.0*v_D6_b_i*(v_D6_b_i**2 + v_D6_b_r**2)**(-0.5)
        struct[0].Hy[99,186] = 1.0*v_D6_c_r*(v_D6_c_i**2 + v_D6_c_r**2)**(-0.5)
        struct[0].Hy[99,187] = 1.0*v_D6_c_i*(v_D6_c_i**2 + v_D6_c_r**2)**(-0.5)
        struct[0].Hy[100,188] = 1.0*v_D6_n_r*(v_D6_n_i**2 + v_D6_n_r**2)**(-0.5)
        struct[0].Hy[100,189] = 1.0*v_D6_n_i*(v_D6_n_i**2 + v_D6_n_r**2)**(-0.5)
        struct[0].Hy[101,190] = 1.0*v_D9_a_r*(v_D9_a_i**2 + v_D9_a_r**2)**(-0.5)
        struct[0].Hy[101,191] = 1.0*v_D9_a_i*(v_D9_a_i**2 + v_D9_a_r**2)**(-0.5)
        struct[0].Hy[102,192] = 1.0*v_D9_b_r*(v_D9_b_i**2 + v_D9_b_r**2)**(-0.5)
        struct[0].Hy[102,193] = 1.0*v_D9_b_i*(v_D9_b_i**2 + v_D9_b_r**2)**(-0.5)
        struct[0].Hy[103,194] = 1.0*v_D9_c_r*(v_D9_c_i**2 + v_D9_c_r**2)**(-0.5)
        struct[0].Hy[103,195] = 1.0*v_D9_c_i*(v_D9_c_i**2 + v_D9_c_r**2)**(-0.5)
        struct[0].Hy[104,196] = 1.0*v_D9_n_r*(v_D9_n_i**2 + v_D9_n_r**2)**(-0.5)
        struct[0].Hy[104,197] = 1.0*v_D9_n_i*(v_D9_n_i**2 + v_D9_n_r**2)**(-0.5)
        struct[0].Hy[105,198] = 1.0*v_D10_a_r*(v_D10_a_i**2 + v_D10_a_r**2)**(-0.5)
        struct[0].Hy[105,199] = 1.0*v_D10_a_i*(v_D10_a_i**2 + v_D10_a_r**2)**(-0.5)
        struct[0].Hy[106,200] = 1.0*v_D10_b_r*(v_D10_b_i**2 + v_D10_b_r**2)**(-0.5)
        struct[0].Hy[106,201] = 1.0*v_D10_b_i*(v_D10_b_i**2 + v_D10_b_r**2)**(-0.5)
        struct[0].Hy[107,202] = 1.0*v_D10_c_r*(v_D10_c_i**2 + v_D10_c_r**2)**(-0.5)
        struct[0].Hy[107,203] = 1.0*v_D10_c_i*(v_D10_c_i**2 + v_D10_c_r**2)**(-0.5)
        struct[0].Hy[108,204] = 1.0*v_D10_n_r*(v_D10_n_i**2 + v_D10_n_r**2)**(-0.5)
        struct[0].Hy[108,205] = 1.0*v_D10_n_i*(v_D10_n_i**2 + v_D10_n_r**2)**(-0.5)
        struct[0].Hy[109,206] = 1.0*v_D11_b_r*(v_D11_b_i**2 + v_D11_b_r**2)**(-0.5)
        struct[0].Hy[109,207] = 1.0*v_D11_b_i*(v_D11_b_i**2 + v_D11_b_r**2)**(-0.5)
        struct[0].Hy[110,208] = 1.0*v_D11_c_r*(v_D11_c_i**2 + v_D11_c_r**2)**(-0.5)
        struct[0].Hy[110,209] = 1.0*v_D11_c_i*(v_D11_c_i**2 + v_D11_c_r**2)**(-0.5)
        struct[0].Hy[111,210] = 1.0*v_D16_b_r*(v_D16_b_i**2 + v_D16_b_r**2)**(-0.5)
        struct[0].Hy[111,211] = 1.0*v_D16_b_i*(v_D16_b_i**2 + v_D16_b_r**2)**(-0.5)
        struct[0].Hy[112,212] = 1.0*v_D16_c_r*(v_D16_c_i**2 + v_D16_c_r**2)**(-0.5)
        struct[0].Hy[112,213] = 1.0*v_D16_c_i*(v_D16_c_i**2 + v_D16_c_r**2)**(-0.5)
        struct[0].Hy[113,214] = 1.0*v_D17_b_r*(v_D17_b_i**2 + v_D17_b_r**2)**(-0.5)
        struct[0].Hy[113,215] = 1.0*v_D17_b_i*(v_D17_b_i**2 + v_D17_b_r**2)**(-0.5)
        struct[0].Hy[114,216] = 1.0*v_D17_c_r*(v_D17_c_i**2 + v_D17_c_r**2)**(-0.5)
        struct[0].Hy[114,217] = 1.0*v_D17_c_i*(v_D17_c_i**2 + v_D17_c_r**2)**(-0.5)
        struct[0].Hy[115,218] = 1.0*v_D18_b_r*(v_D18_b_i**2 + v_D18_b_r**2)**(-0.5)
        struct[0].Hy[115,219] = 1.0*v_D18_b_i*(v_D18_b_i**2 + v_D18_b_r**2)**(-0.5)
        struct[0].Hy[116,220] = 1.0*v_D18_c_r*(v_D18_c_i**2 + v_D18_c_r**2)**(-0.5)
        struct[0].Hy[116,221] = 1.0*v_D18_c_i*(v_D18_c_i**2 + v_D18_c_r**2)**(-0.5)
        struct[0].Hy[117,222] = 1.0*v_D14_a_r*(v_D14_a_i**2 + v_D14_a_r**2)**(-0.5)
        struct[0].Hy[117,223] = 1.0*v_D14_a_i*(v_D14_a_i**2 + v_D14_a_r**2)**(-0.5)
        struct[0].Hy[118,224] = 1.0*v_D14_b_r*(v_D14_b_i**2 + v_D14_b_r**2)**(-0.5)
        struct[0].Hy[118,225] = 1.0*v_D14_b_i*(v_D14_b_i**2 + v_D14_b_r**2)**(-0.5)
        struct[0].Hy[119,226] = 1.0*v_D14_c_r*(v_D14_c_i**2 + v_D14_c_r**2)**(-0.5)
        struct[0].Hy[119,227] = 1.0*v_D14_c_i*(v_D14_c_i**2 + v_D14_c_r**2)**(-0.5)
        struct[0].Hy[120,228] = 1.0*v_D14_n_r*(v_D14_n_i**2 + v_D14_n_r**2)**(-0.5)
        struct[0].Hy[120,229] = 1.0*v_D14_n_i*(v_D14_n_i**2 + v_D14_n_r**2)**(-0.5)
        struct[0].Hy[121,230] = 1.0*v_D15_b_r*(v_D15_b_i**2 + v_D15_b_r**2)**(-0.5)
        struct[0].Hy[121,231] = 1.0*v_D15_b_i*(v_D15_b_i**2 + v_D15_b_r**2)**(-0.5)
        struct[0].Hy[122,232] = 1.0*v_D15_c_r*(v_D15_c_i**2 + v_D15_c_r**2)**(-0.5)
        struct[0].Hy[122,233] = 1.0*v_D15_c_i*(v_D15_c_i**2 + v_D15_c_r**2)**(-0.5)

        struct[0].Hu[0,0] = 1.0*v_R0_a_r*(v_R0_a_i**2 + v_R0_a_r**2)**(-0.5)
        struct[0].Hu[0,1] = 1.0*v_R0_a_i*(v_R0_a_i**2 + v_R0_a_r**2)**(-0.5)
        struct[0].Hu[1,2] = 1.0*v_R0_b_r*(v_R0_b_i**2 + v_R0_b_r**2)**(-0.5)
        struct[0].Hu[1,3] = 1.0*v_R0_b_i*(v_R0_b_i**2 + v_R0_b_r**2)**(-0.5)
        struct[0].Hu[2,4] = 1.0*v_R0_c_r*(v_R0_c_i**2 + v_R0_c_r**2)**(-0.5)
        struct[0].Hu[2,5] = 1.0*v_R0_c_i*(v_R0_c_i**2 + v_R0_c_r**2)**(-0.5)
        struct[0].Hu[3,6] = 1.0*v_D1_a_r*(v_D1_a_i**2 + v_D1_a_r**2)**(-0.5)
        struct[0].Hu[3,7] = 1.0*v_D1_a_i*(v_D1_a_i**2 + v_D1_a_r**2)**(-0.5)
        struct[0].Hu[4,8] = 1.0*v_D1_b_r*(v_D1_b_i**2 + v_D1_b_r**2)**(-0.5)
        struct[0].Hu[4,9] = 1.0*v_D1_b_i*(v_D1_b_i**2 + v_D1_b_r**2)**(-0.5)
        struct[0].Hu[5,10] = 1.0*v_D1_c_r*(v_D1_c_i**2 + v_D1_c_r**2)**(-0.5)
        struct[0].Hu[5,11] = 1.0*v_D1_c_i*(v_D1_c_i**2 + v_D1_c_r**2)**(-0.5)



def ini_nn(struct,mode):

    # Parameters:
    a_R1 = struct[0].a_R1
    b_R1 = struct[0].b_R1
    c_R1 = struct[0].c_R1
    a_R10 = struct[0].a_R10
    b_R10 = struct[0].b_R10
    c_R10 = struct[0].c_R10
    coef_a_R10 = struct[0].coef_a_R10
    coef_b_R10 = struct[0].coef_b_R10
    coef_c_R10 = struct[0].coef_c_R10
    a_R14 = struct[0].a_R14
    b_R14 = struct[0].b_R14
    c_R14 = struct[0].c_R14
    coef_a_R14 = struct[0].coef_a_R14
    coef_b_R14 = struct[0].coef_b_R14
    coef_c_R14 = struct[0].coef_c_R14
    
    # Inputs:
    v_R0_a_r = struct[0].v_R0_a_r
    v_R0_a_i = struct[0].v_R0_a_i
    v_R0_b_r = struct[0].v_R0_b_r
    v_R0_b_i = struct[0].v_R0_b_i
    v_R0_c_r = struct[0].v_R0_c_r
    v_R0_c_i = struct[0].v_R0_c_i
    v_D1_a_r = struct[0].v_D1_a_r
    v_D1_a_i = struct[0].v_D1_a_i
    v_D1_b_r = struct[0].v_D1_b_r
    v_D1_b_i = struct[0].v_D1_b_i
    v_D1_c_r = struct[0].v_D1_c_r
    v_D1_c_i = struct[0].v_D1_c_i
    i_R1_n_r = struct[0].i_R1_n_r
    i_R1_n_i = struct[0].i_R1_n_i
    i_R11_n_r = struct[0].i_R11_n_r
    i_R11_n_i = struct[0].i_R11_n_i
    i_R15_n_r = struct[0].i_R15_n_r
    i_R15_n_i = struct[0].i_R15_n_i
    i_R16_n_r = struct[0].i_R16_n_r
    i_R16_n_i = struct[0].i_R16_n_i
    i_R17_n_r = struct[0].i_R17_n_r
    i_R17_n_i = struct[0].i_R17_n_i
    i_R18_n_r = struct[0].i_R18_n_r
    i_R18_n_i = struct[0].i_R18_n_i
    i_R2_a_r = struct[0].i_R2_a_r
    i_R2_a_i = struct[0].i_R2_a_i
    i_R2_b_r = struct[0].i_R2_b_r
    i_R2_b_i = struct[0].i_R2_b_i
    i_R2_c_r = struct[0].i_R2_c_r
    i_R2_c_i = struct[0].i_R2_c_i
    i_R2_n_r = struct[0].i_R2_n_r
    i_R2_n_i = struct[0].i_R2_n_i
    i_R3_a_r = struct[0].i_R3_a_r
    i_R3_a_i = struct[0].i_R3_a_i
    i_R3_b_r = struct[0].i_R3_b_r
    i_R3_b_i = struct[0].i_R3_b_i
    i_R3_c_r = struct[0].i_R3_c_r
    i_R3_c_i = struct[0].i_R3_c_i
    i_R3_n_r = struct[0].i_R3_n_r
    i_R3_n_i = struct[0].i_R3_n_i
    i_R4_a_r = struct[0].i_R4_a_r
    i_R4_a_i = struct[0].i_R4_a_i
    i_R4_b_r = struct[0].i_R4_b_r
    i_R4_b_i = struct[0].i_R4_b_i
    i_R4_c_r = struct[0].i_R4_c_r
    i_R4_c_i = struct[0].i_R4_c_i
    i_R4_n_r = struct[0].i_R4_n_r
    i_R4_n_i = struct[0].i_R4_n_i
    i_R5_a_r = struct[0].i_R5_a_r
    i_R5_a_i = struct[0].i_R5_a_i
    i_R5_b_r = struct[0].i_R5_b_r
    i_R5_b_i = struct[0].i_R5_b_i
    i_R5_c_r = struct[0].i_R5_c_r
    i_R5_c_i = struct[0].i_R5_c_i
    i_R5_n_r = struct[0].i_R5_n_r
    i_R5_n_i = struct[0].i_R5_n_i
    i_R6_a_r = struct[0].i_R6_a_r
    i_R6_a_i = struct[0].i_R6_a_i
    i_R6_b_r = struct[0].i_R6_b_r
    i_R6_b_i = struct[0].i_R6_b_i
    i_R6_c_r = struct[0].i_R6_c_r
    i_R6_c_i = struct[0].i_R6_c_i
    i_R6_n_r = struct[0].i_R6_n_r
    i_R6_n_i = struct[0].i_R6_n_i
    i_R7_a_r = struct[0].i_R7_a_r
    i_R7_a_i = struct[0].i_R7_a_i
    i_R7_b_r = struct[0].i_R7_b_r
    i_R7_b_i = struct[0].i_R7_b_i
    i_R7_c_r = struct[0].i_R7_c_r
    i_R7_c_i = struct[0].i_R7_c_i
    i_R7_n_r = struct[0].i_R7_n_r
    i_R7_n_i = struct[0].i_R7_n_i
    i_R8_a_r = struct[0].i_R8_a_r
    i_R8_a_i = struct[0].i_R8_a_i
    i_R8_b_r = struct[0].i_R8_b_r
    i_R8_b_i = struct[0].i_R8_b_i
    i_R8_c_r = struct[0].i_R8_c_r
    i_R8_c_i = struct[0].i_R8_c_i
    i_R8_n_r = struct[0].i_R8_n_r
    i_R8_n_i = struct[0].i_R8_n_i
    i_R9_a_r = struct[0].i_R9_a_r
    i_R9_a_i = struct[0].i_R9_a_i
    i_R9_b_r = struct[0].i_R9_b_r
    i_R9_b_i = struct[0].i_R9_b_i
    i_R9_c_r = struct[0].i_R9_c_r
    i_R9_c_i = struct[0].i_R9_c_i
    i_R9_n_r = struct[0].i_R9_n_r
    i_R9_n_i = struct[0].i_R9_n_i
    i_R10_a_r = struct[0].i_R10_a_r
    i_R10_a_i = struct[0].i_R10_a_i
    i_R10_b_r = struct[0].i_R10_b_r
    i_R10_b_i = struct[0].i_R10_b_i
    i_R10_c_r = struct[0].i_R10_c_r
    i_R10_c_i = struct[0].i_R10_c_i
    i_R10_n_r = struct[0].i_R10_n_r
    i_R10_n_i = struct[0].i_R10_n_i
    i_R12_a_r = struct[0].i_R12_a_r
    i_R12_a_i = struct[0].i_R12_a_i
    i_R12_b_r = struct[0].i_R12_b_r
    i_R12_b_i = struct[0].i_R12_b_i
    i_R12_c_r = struct[0].i_R12_c_r
    i_R12_c_i = struct[0].i_R12_c_i
    i_R12_n_r = struct[0].i_R12_n_r
    i_R12_n_i = struct[0].i_R12_n_i
    i_R13_a_r = struct[0].i_R13_a_r
    i_R13_a_i = struct[0].i_R13_a_i
    i_R13_b_r = struct[0].i_R13_b_r
    i_R13_b_i = struct[0].i_R13_b_i
    i_R13_c_r = struct[0].i_R13_c_r
    i_R13_c_i = struct[0].i_R13_c_i
    i_R13_n_r = struct[0].i_R13_n_r
    i_R13_n_i = struct[0].i_R13_n_i
    i_R14_a_r = struct[0].i_R14_a_r
    i_R14_a_i = struct[0].i_R14_a_i
    i_R14_b_r = struct[0].i_R14_b_r
    i_R14_b_i = struct[0].i_R14_b_i
    i_R14_c_r = struct[0].i_R14_c_r
    i_R14_c_i = struct[0].i_R14_c_i
    i_R14_n_r = struct[0].i_R14_n_r
    i_R14_n_i = struct[0].i_R14_n_i
    i_D1_n_r = struct[0].i_D1_n_r
    i_D1_n_i = struct[0].i_D1_n_i
    i_D3_a_r = struct[0].i_D3_a_r
    i_D3_a_i = struct[0].i_D3_a_i
    i_D3_b_r = struct[0].i_D3_b_r
    i_D3_b_i = struct[0].i_D3_b_i
    i_D3_c_r = struct[0].i_D3_c_r
    i_D3_c_i = struct[0].i_D3_c_i
    i_D3_n_r = struct[0].i_D3_n_r
    i_D3_n_i = struct[0].i_D3_n_i
    i_D4_a_r = struct[0].i_D4_a_r
    i_D4_a_i = struct[0].i_D4_a_i
    i_D4_b_r = struct[0].i_D4_b_r
    i_D4_b_i = struct[0].i_D4_b_i
    i_D4_c_r = struct[0].i_D4_c_r
    i_D4_c_i = struct[0].i_D4_c_i
    i_D4_n_r = struct[0].i_D4_n_r
    i_D4_n_i = struct[0].i_D4_n_i
    i_D6_a_r = struct[0].i_D6_a_r
    i_D6_a_i = struct[0].i_D6_a_i
    i_D6_b_r = struct[0].i_D6_b_r
    i_D6_b_i = struct[0].i_D6_b_i
    i_D6_c_r = struct[0].i_D6_c_r
    i_D6_c_i = struct[0].i_D6_c_i
    i_D6_n_r = struct[0].i_D6_n_r
    i_D6_n_i = struct[0].i_D6_n_i
    i_D9_a_r = struct[0].i_D9_a_r
    i_D9_a_i = struct[0].i_D9_a_i
    i_D9_b_r = struct[0].i_D9_b_r
    i_D9_b_i = struct[0].i_D9_b_i
    i_D9_c_r = struct[0].i_D9_c_r
    i_D9_c_i = struct[0].i_D9_c_i
    i_D9_n_r = struct[0].i_D9_n_r
    i_D9_n_i = struct[0].i_D9_n_i
    i_D10_a_i = struct[0].i_D10_a_i
    i_D10_b_r = struct[0].i_D10_b_r
    i_D10_b_i = struct[0].i_D10_b_i
    i_D10_c_r = struct[0].i_D10_c_r
    i_D10_c_i = struct[0].i_D10_c_i
    i_D10_n_i = struct[0].i_D10_n_i
    i_D11_b_r = struct[0].i_D11_b_r
    i_D11_b_i = struct[0].i_D11_b_i
    i_D11_c_r = struct[0].i_D11_c_r
    i_D11_c_i = struct[0].i_D11_c_i
    i_D16_b_r = struct[0].i_D16_b_r
    i_D16_b_i = struct[0].i_D16_b_i
    i_D16_c_r = struct[0].i_D16_c_r
    i_D16_c_i = struct[0].i_D16_c_i
    i_D17_b_r = struct[0].i_D17_b_r
    i_D17_b_i = struct[0].i_D17_b_i
    i_D17_c_r = struct[0].i_D17_c_r
    i_D17_c_i = struct[0].i_D17_c_i
    i_D18_b_r = struct[0].i_D18_b_r
    i_D18_b_i = struct[0].i_D18_b_i
    i_D18_c_r = struct[0].i_D18_c_r
    i_D18_c_i = struct[0].i_D18_c_i
    i_D14_a_i = struct[0].i_D14_a_i
    i_D14_b_r = struct[0].i_D14_b_r
    i_D14_b_i = struct[0].i_D14_b_i
    i_D14_c_r = struct[0].i_D14_c_r
    i_D14_c_i = struct[0].i_D14_c_i
    i_D14_n_i = struct[0].i_D14_n_i
    i_D15_b_r = struct[0].i_D15_b_r
    i_D15_b_i = struct[0].i_D15_b_i
    i_D15_c_r = struct[0].i_D15_c_r
    i_D15_c_i = struct[0].i_D15_c_i
    p_R1_a = struct[0].p_R1_a
    q_R1_a = struct[0].q_R1_a
    p_R1_b = struct[0].p_R1_b
    q_R1_b = struct[0].q_R1_b
    p_R1_c = struct[0].p_R1_c
    q_R1_c = struct[0].q_R1_c
    p_R11_a = struct[0].p_R11_a
    q_R11_a = struct[0].q_R11_a
    p_R11_b = struct[0].p_R11_b
    q_R11_b = struct[0].q_R11_b
    p_R11_c = struct[0].p_R11_c
    q_R11_c = struct[0].q_R11_c
    p_R15_a = struct[0].p_R15_a
    q_R15_a = struct[0].q_R15_a
    p_R15_b = struct[0].p_R15_b
    q_R15_b = struct[0].q_R15_b
    p_R15_c = struct[0].p_R15_c
    q_R15_c = struct[0].q_R15_c
    p_R16_a = struct[0].p_R16_a
    q_R16_a = struct[0].q_R16_a
    p_R16_b = struct[0].p_R16_b
    q_R16_b = struct[0].q_R16_b
    p_R16_c = struct[0].p_R16_c
    q_R16_c = struct[0].q_R16_c
    p_R17_a = struct[0].p_R17_a
    q_R17_a = struct[0].q_R17_a
    p_R17_b = struct[0].p_R17_b
    q_R17_b = struct[0].q_R17_b
    p_R17_c = struct[0].p_R17_c
    q_R17_c = struct[0].q_R17_c
    p_R18_a = struct[0].p_R18_a
    q_R18_a = struct[0].q_R18_a
    p_R18_b = struct[0].p_R18_b
    q_R18_b = struct[0].q_R18_b
    p_R18_c = struct[0].p_R18_c
    q_R18_c = struct[0].q_R18_c
    p_D15_1 = struct[0].p_D15_1
    q_D15_1 = struct[0].q_D15_1
    p_D11_1 = struct[0].p_D11_1
    q_D11_1 = struct[0].q_D11_1
    p_D16_1 = struct[0].p_D16_1
    q_D16_1 = struct[0].q_D16_1
    p_D17_1 = struct[0].p_D17_1
    q_D17_1 = struct[0].q_D17_1
    p_D18_1 = struct[0].p_D18_1
    q_D18_1 = struct[0].q_D18_1
    v_dc_D1 = struct[0].v_dc_D1
    q_R1 = struct[0].q_R1
    p_R10 = struct[0].p_R10
    q_R10 = struct[0].q_R10
    p_R14 = struct[0].p_R14
    q_R14 = struct[0].q_R14
    u_dummy = struct[0].u_dummy
    
    # Dynamical states:
    x_dummy = struct[0].x[0,0]
    
    # Algebraic states:
    v_R1_a_r = struct[0].y_ini[0,0]
    v_R1_a_i = struct[0].y_ini[1,0]
    v_R1_b_r = struct[0].y_ini[2,0]
    v_R1_b_i = struct[0].y_ini[3,0]
    v_R1_c_r = struct[0].y_ini[4,0]
    v_R1_c_i = struct[0].y_ini[5,0]
    v_R1_n_r = struct[0].y_ini[6,0]
    v_R1_n_i = struct[0].y_ini[7,0]
    v_R11_a_r = struct[0].y_ini[8,0]
    v_R11_a_i = struct[0].y_ini[9,0]
    v_R11_b_r = struct[0].y_ini[10,0]
    v_R11_b_i = struct[0].y_ini[11,0]
    v_R11_c_r = struct[0].y_ini[12,0]
    v_R11_c_i = struct[0].y_ini[13,0]
    v_R11_n_r = struct[0].y_ini[14,0]
    v_R11_n_i = struct[0].y_ini[15,0]
    v_R15_a_r = struct[0].y_ini[16,0]
    v_R15_a_i = struct[0].y_ini[17,0]
    v_R15_b_r = struct[0].y_ini[18,0]
    v_R15_b_i = struct[0].y_ini[19,0]
    v_R15_c_r = struct[0].y_ini[20,0]
    v_R15_c_i = struct[0].y_ini[21,0]
    v_R15_n_r = struct[0].y_ini[22,0]
    v_R15_n_i = struct[0].y_ini[23,0]
    v_R16_a_r = struct[0].y_ini[24,0]
    v_R16_a_i = struct[0].y_ini[25,0]
    v_R16_b_r = struct[0].y_ini[26,0]
    v_R16_b_i = struct[0].y_ini[27,0]
    v_R16_c_r = struct[0].y_ini[28,0]
    v_R16_c_i = struct[0].y_ini[29,0]
    v_R16_n_r = struct[0].y_ini[30,0]
    v_R16_n_i = struct[0].y_ini[31,0]
    v_R17_a_r = struct[0].y_ini[32,0]
    v_R17_a_i = struct[0].y_ini[33,0]
    v_R17_b_r = struct[0].y_ini[34,0]
    v_R17_b_i = struct[0].y_ini[35,0]
    v_R17_c_r = struct[0].y_ini[36,0]
    v_R17_c_i = struct[0].y_ini[37,0]
    v_R17_n_r = struct[0].y_ini[38,0]
    v_R17_n_i = struct[0].y_ini[39,0]
    v_R18_a_r = struct[0].y_ini[40,0]
    v_R18_a_i = struct[0].y_ini[41,0]
    v_R18_b_r = struct[0].y_ini[42,0]
    v_R18_b_i = struct[0].y_ini[43,0]
    v_R18_c_r = struct[0].y_ini[44,0]
    v_R18_c_i = struct[0].y_ini[45,0]
    v_R18_n_r = struct[0].y_ini[46,0]
    v_R18_n_i = struct[0].y_ini[47,0]
    v_D15_a_r = struct[0].y_ini[48,0]
    v_D15_a_i = struct[0].y_ini[49,0]
    v_D15_n_r = struct[0].y_ini[50,0]
    v_D15_n_i = struct[0].y_ini[51,0]
    v_D11_a_r = struct[0].y_ini[52,0]
    v_D11_a_i = struct[0].y_ini[53,0]
    v_D11_n_r = struct[0].y_ini[54,0]
    v_D11_n_i = struct[0].y_ini[55,0]
    v_D16_a_r = struct[0].y_ini[56,0]
    v_D16_a_i = struct[0].y_ini[57,0]
    v_D16_n_r = struct[0].y_ini[58,0]
    v_D16_n_i = struct[0].y_ini[59,0]
    v_D17_a_r = struct[0].y_ini[60,0]
    v_D17_a_i = struct[0].y_ini[61,0]
    v_D17_n_r = struct[0].y_ini[62,0]
    v_D17_n_i = struct[0].y_ini[63,0]
    v_D18_a_r = struct[0].y_ini[64,0]
    v_D18_a_i = struct[0].y_ini[65,0]
    v_D18_n_r = struct[0].y_ini[66,0]
    v_D18_n_i = struct[0].y_ini[67,0]
    v_R2_a_r = struct[0].y_ini[68,0]
    v_R2_a_i = struct[0].y_ini[69,0]
    v_R2_b_r = struct[0].y_ini[70,0]
    v_R2_b_i = struct[0].y_ini[71,0]
    v_R2_c_r = struct[0].y_ini[72,0]
    v_R2_c_i = struct[0].y_ini[73,0]
    v_R2_n_r = struct[0].y_ini[74,0]
    v_R2_n_i = struct[0].y_ini[75,0]
    v_R3_a_r = struct[0].y_ini[76,0]
    v_R3_a_i = struct[0].y_ini[77,0]
    v_R3_b_r = struct[0].y_ini[78,0]
    v_R3_b_i = struct[0].y_ini[79,0]
    v_R3_c_r = struct[0].y_ini[80,0]
    v_R3_c_i = struct[0].y_ini[81,0]
    v_R3_n_r = struct[0].y_ini[82,0]
    v_R3_n_i = struct[0].y_ini[83,0]
    v_R4_a_r = struct[0].y_ini[84,0]
    v_R4_a_i = struct[0].y_ini[85,0]
    v_R4_b_r = struct[0].y_ini[86,0]
    v_R4_b_i = struct[0].y_ini[87,0]
    v_R4_c_r = struct[0].y_ini[88,0]
    v_R4_c_i = struct[0].y_ini[89,0]
    v_R4_n_r = struct[0].y_ini[90,0]
    v_R4_n_i = struct[0].y_ini[91,0]
    v_R5_a_r = struct[0].y_ini[92,0]
    v_R5_a_i = struct[0].y_ini[93,0]
    v_R5_b_r = struct[0].y_ini[94,0]
    v_R5_b_i = struct[0].y_ini[95,0]
    v_R5_c_r = struct[0].y_ini[96,0]
    v_R5_c_i = struct[0].y_ini[97,0]
    v_R5_n_r = struct[0].y_ini[98,0]
    v_R5_n_i = struct[0].y_ini[99,0]
    v_R6_a_r = struct[0].y_ini[100,0]
    v_R6_a_i = struct[0].y_ini[101,0]
    v_R6_b_r = struct[0].y_ini[102,0]
    v_R6_b_i = struct[0].y_ini[103,0]
    v_R6_c_r = struct[0].y_ini[104,0]
    v_R6_c_i = struct[0].y_ini[105,0]
    v_R6_n_r = struct[0].y_ini[106,0]
    v_R6_n_i = struct[0].y_ini[107,0]
    v_R7_a_r = struct[0].y_ini[108,0]
    v_R7_a_i = struct[0].y_ini[109,0]
    v_R7_b_r = struct[0].y_ini[110,0]
    v_R7_b_i = struct[0].y_ini[111,0]
    v_R7_c_r = struct[0].y_ini[112,0]
    v_R7_c_i = struct[0].y_ini[113,0]
    v_R7_n_r = struct[0].y_ini[114,0]
    v_R7_n_i = struct[0].y_ini[115,0]
    v_R8_a_r = struct[0].y_ini[116,0]
    v_R8_a_i = struct[0].y_ini[117,0]
    v_R8_b_r = struct[0].y_ini[118,0]
    v_R8_b_i = struct[0].y_ini[119,0]
    v_R8_c_r = struct[0].y_ini[120,0]
    v_R8_c_i = struct[0].y_ini[121,0]
    v_R8_n_r = struct[0].y_ini[122,0]
    v_R8_n_i = struct[0].y_ini[123,0]
    v_R9_a_r = struct[0].y_ini[124,0]
    v_R9_a_i = struct[0].y_ini[125,0]
    v_R9_b_r = struct[0].y_ini[126,0]
    v_R9_b_i = struct[0].y_ini[127,0]
    v_R9_c_r = struct[0].y_ini[128,0]
    v_R9_c_i = struct[0].y_ini[129,0]
    v_R9_n_r = struct[0].y_ini[130,0]
    v_R9_n_i = struct[0].y_ini[131,0]
    v_R10_a_r = struct[0].y_ini[132,0]
    v_R10_a_i = struct[0].y_ini[133,0]
    v_R10_b_r = struct[0].y_ini[134,0]
    v_R10_b_i = struct[0].y_ini[135,0]
    v_R10_c_r = struct[0].y_ini[136,0]
    v_R10_c_i = struct[0].y_ini[137,0]
    v_R10_n_r = struct[0].y_ini[138,0]
    v_R10_n_i = struct[0].y_ini[139,0]
    v_R12_a_r = struct[0].y_ini[140,0]
    v_R12_a_i = struct[0].y_ini[141,0]
    v_R12_b_r = struct[0].y_ini[142,0]
    v_R12_b_i = struct[0].y_ini[143,0]
    v_R12_c_r = struct[0].y_ini[144,0]
    v_R12_c_i = struct[0].y_ini[145,0]
    v_R12_n_r = struct[0].y_ini[146,0]
    v_R12_n_i = struct[0].y_ini[147,0]
    v_R13_a_r = struct[0].y_ini[148,0]
    v_R13_a_i = struct[0].y_ini[149,0]
    v_R13_b_r = struct[0].y_ini[150,0]
    v_R13_b_i = struct[0].y_ini[151,0]
    v_R13_c_r = struct[0].y_ini[152,0]
    v_R13_c_i = struct[0].y_ini[153,0]
    v_R13_n_r = struct[0].y_ini[154,0]
    v_R13_n_i = struct[0].y_ini[155,0]
    v_R14_a_r = struct[0].y_ini[156,0]
    v_R14_a_i = struct[0].y_ini[157,0]
    v_R14_b_r = struct[0].y_ini[158,0]
    v_R14_b_i = struct[0].y_ini[159,0]
    v_R14_c_r = struct[0].y_ini[160,0]
    v_R14_c_i = struct[0].y_ini[161,0]
    v_R14_n_r = struct[0].y_ini[162,0]
    v_R14_n_i = struct[0].y_ini[163,0]
    v_D1_n_r = struct[0].y_ini[164,0]
    v_D1_n_i = struct[0].y_ini[165,0]
    v_D3_a_r = struct[0].y_ini[166,0]
    v_D3_a_i = struct[0].y_ini[167,0]
    v_D3_b_r = struct[0].y_ini[168,0]
    v_D3_b_i = struct[0].y_ini[169,0]
    v_D3_c_r = struct[0].y_ini[170,0]
    v_D3_c_i = struct[0].y_ini[171,0]
    v_D3_n_r = struct[0].y_ini[172,0]
    v_D3_n_i = struct[0].y_ini[173,0]
    v_D4_a_r = struct[0].y_ini[174,0]
    v_D4_a_i = struct[0].y_ini[175,0]
    v_D4_b_r = struct[0].y_ini[176,0]
    v_D4_b_i = struct[0].y_ini[177,0]
    v_D4_c_r = struct[0].y_ini[178,0]
    v_D4_c_i = struct[0].y_ini[179,0]
    v_D4_n_r = struct[0].y_ini[180,0]
    v_D4_n_i = struct[0].y_ini[181,0]
    v_D6_a_r = struct[0].y_ini[182,0]
    v_D6_a_i = struct[0].y_ini[183,0]
    v_D6_b_r = struct[0].y_ini[184,0]
    v_D6_b_i = struct[0].y_ini[185,0]
    v_D6_c_r = struct[0].y_ini[186,0]
    v_D6_c_i = struct[0].y_ini[187,0]
    v_D6_n_r = struct[0].y_ini[188,0]
    v_D6_n_i = struct[0].y_ini[189,0]
    v_D9_a_r = struct[0].y_ini[190,0]
    v_D9_a_i = struct[0].y_ini[191,0]
    v_D9_b_r = struct[0].y_ini[192,0]
    v_D9_b_i = struct[0].y_ini[193,0]
    v_D9_c_r = struct[0].y_ini[194,0]
    v_D9_c_i = struct[0].y_ini[195,0]
    v_D9_n_r = struct[0].y_ini[196,0]
    v_D9_n_i = struct[0].y_ini[197,0]
    v_D10_a_r = struct[0].y_ini[198,0]
    v_D10_a_i = struct[0].y_ini[199,0]
    v_D10_b_r = struct[0].y_ini[200,0]
    v_D10_b_i = struct[0].y_ini[201,0]
    v_D10_c_r = struct[0].y_ini[202,0]
    v_D10_c_i = struct[0].y_ini[203,0]
    v_D10_n_r = struct[0].y_ini[204,0]
    v_D10_n_i = struct[0].y_ini[205,0]
    v_D11_b_r = struct[0].y_ini[206,0]
    v_D11_b_i = struct[0].y_ini[207,0]
    v_D11_c_r = struct[0].y_ini[208,0]
    v_D11_c_i = struct[0].y_ini[209,0]
    v_D16_b_r = struct[0].y_ini[210,0]
    v_D16_b_i = struct[0].y_ini[211,0]
    v_D16_c_r = struct[0].y_ini[212,0]
    v_D16_c_i = struct[0].y_ini[213,0]
    v_D17_b_r = struct[0].y_ini[214,0]
    v_D17_b_i = struct[0].y_ini[215,0]
    v_D17_c_r = struct[0].y_ini[216,0]
    v_D17_c_i = struct[0].y_ini[217,0]
    v_D18_b_r = struct[0].y_ini[218,0]
    v_D18_b_i = struct[0].y_ini[219,0]
    v_D18_c_r = struct[0].y_ini[220,0]
    v_D18_c_i = struct[0].y_ini[221,0]
    v_D14_a_r = struct[0].y_ini[222,0]
    v_D14_a_i = struct[0].y_ini[223,0]
    v_D14_b_r = struct[0].y_ini[224,0]
    v_D14_b_i = struct[0].y_ini[225,0]
    v_D14_c_r = struct[0].y_ini[226,0]
    v_D14_c_i = struct[0].y_ini[227,0]
    v_D14_n_r = struct[0].y_ini[228,0]
    v_D14_n_i = struct[0].y_ini[229,0]
    v_D15_b_r = struct[0].y_ini[230,0]
    v_D15_b_i = struct[0].y_ini[231,0]
    v_D15_c_r = struct[0].y_ini[232,0]
    v_D15_c_i = struct[0].y_ini[233,0]
    i_t_R0_R1_a_r = struct[0].y_ini[234,0]
    i_t_R0_R1_a_i = struct[0].y_ini[235,0]
    i_t_R0_R1_b_r = struct[0].y_ini[236,0]
    i_t_R0_R1_b_i = struct[0].y_ini[237,0]
    i_t_R0_R1_c_r = struct[0].y_ini[238,0]
    i_t_R0_R1_c_i = struct[0].y_ini[239,0]
    i_l_R1_R2_a_r = struct[0].y_ini[240,0]
    i_l_R1_R2_a_i = struct[0].y_ini[241,0]
    i_l_R1_R2_b_r = struct[0].y_ini[242,0]
    i_l_R1_R2_b_i = struct[0].y_ini[243,0]
    i_l_R1_R2_c_r = struct[0].y_ini[244,0]
    i_l_R1_R2_c_i = struct[0].y_ini[245,0]
    i_l_R1_R2_n_r = struct[0].y_ini[246,0]
    i_l_R1_R2_n_i = struct[0].y_ini[247,0]
    i_l_D1_D3_a_r = struct[0].y_ini[248,0]
    i_l_D1_D3_a_i = struct[0].y_ini[249,0]
    i_l_D1_D3_b_r = struct[0].y_ini[250,0]
    i_l_D1_D3_b_i = struct[0].y_ini[251,0]
    i_l_D1_D3_c_r = struct[0].y_ini[252,0]
    i_l_D1_D3_c_i = struct[0].y_ini[253,0]
    i_l_D1_D3_n_r = struct[0].y_ini[254,0]
    i_l_D1_D3_n_i = struct[0].y_ini[255,0]
    i_l_D3_D4_a_r = struct[0].y_ini[256,0]
    i_l_D3_D4_a_i = struct[0].y_ini[257,0]
    i_l_D3_D4_b_r = struct[0].y_ini[258,0]
    i_l_D3_D4_b_i = struct[0].y_ini[259,0]
    i_l_D3_D4_c_r = struct[0].y_ini[260,0]
    i_l_D3_D4_c_i = struct[0].y_ini[261,0]
    i_l_D3_D4_n_r = struct[0].y_ini[262,0]
    i_l_D3_D4_n_i = struct[0].y_ini[263,0]
    i_l_D4_D6_a_r = struct[0].y_ini[264,0]
    i_l_D4_D6_a_i = struct[0].y_ini[265,0]
    i_l_D4_D6_b_r = struct[0].y_ini[266,0]
    i_l_D4_D6_b_i = struct[0].y_ini[267,0]
    i_l_D4_D6_c_r = struct[0].y_ini[268,0]
    i_l_D4_D6_c_i = struct[0].y_ini[269,0]
    i_l_D4_D6_n_r = struct[0].y_ini[270,0]
    i_l_D4_D6_n_i = struct[0].y_ini[271,0]
    i_l_D6_D9_a_r = struct[0].y_ini[272,0]
    i_l_D6_D9_a_i = struct[0].y_ini[273,0]
    i_l_D6_D9_b_r = struct[0].y_ini[274,0]
    i_l_D6_D9_b_i = struct[0].y_ini[275,0]
    i_l_D6_D9_c_r = struct[0].y_ini[276,0]
    i_l_D6_D9_c_i = struct[0].y_ini[277,0]
    i_l_D6_D9_n_r = struct[0].y_ini[278,0]
    i_l_D6_D9_n_i = struct[0].y_ini[279,0]
    i_l_D9_D10_a_r = struct[0].y_ini[280,0]
    i_l_D9_D10_a_i = struct[0].y_ini[281,0]
    i_l_D9_D10_b_r = struct[0].y_ini[282,0]
    i_l_D9_D10_b_i = struct[0].y_ini[283,0]
    i_l_D9_D10_c_r = struct[0].y_ini[284,0]
    i_l_D9_D10_c_i = struct[0].y_ini[285,0]
    i_l_D9_D10_n_r = struct[0].y_ini[286,0]
    i_l_D9_D10_n_i = struct[0].y_ini[287,0]
    i_l_D3_D11_a_r = struct[0].y_ini[288,0]
    i_l_D3_D11_a_i = struct[0].y_ini[289,0]
    i_l_D3_D11_b_r = struct[0].y_ini[290,0]
    i_l_D3_D11_b_i = struct[0].y_ini[291,0]
    i_l_D3_D11_c_r = struct[0].y_ini[292,0]
    i_l_D3_D11_c_i = struct[0].y_ini[293,0]
    i_l_D3_D11_n_r = struct[0].y_ini[294,0]
    i_l_D3_D11_n_i = struct[0].y_ini[295,0]
    i_l_D6_D16_a_r = struct[0].y_ini[296,0]
    i_l_D6_D16_a_i = struct[0].y_ini[297,0]
    i_l_D6_D16_b_r = struct[0].y_ini[298,0]
    i_l_D6_D16_b_i = struct[0].y_ini[299,0]
    i_l_D6_D16_c_r = struct[0].y_ini[300,0]
    i_l_D6_D16_c_i = struct[0].y_ini[301,0]
    i_l_D6_D16_n_r = struct[0].y_ini[302,0]
    i_l_D6_D16_n_i = struct[0].y_ini[303,0]
    i_l_D9_D17_a_r = struct[0].y_ini[304,0]
    i_l_D9_D17_a_i = struct[0].y_ini[305,0]
    i_l_D9_D17_b_r = struct[0].y_ini[306,0]
    i_l_D9_D17_b_i = struct[0].y_ini[307,0]
    i_l_D9_D17_c_r = struct[0].y_ini[308,0]
    i_l_D9_D17_c_i = struct[0].y_ini[309,0]
    i_l_D9_D17_n_r = struct[0].y_ini[310,0]
    i_l_D9_D17_n_i = struct[0].y_ini[311,0]
    i_l_D10_D18_a_r = struct[0].y_ini[312,0]
    i_l_D10_D18_a_i = struct[0].y_ini[313,0]
    i_l_D10_D18_b_r = struct[0].y_ini[314,0]
    i_l_D10_D18_b_i = struct[0].y_ini[315,0]
    i_l_D10_D18_c_r = struct[0].y_ini[316,0]
    i_l_D10_D18_c_i = struct[0].y_ini[317,0]
    i_l_D10_D18_n_r = struct[0].y_ini[318,0]
    i_l_D10_D18_n_i = struct[0].y_ini[319,0]
    i_l_D4_D14_a_r = struct[0].y_ini[320,0]
    i_l_D4_D14_a_i = struct[0].y_ini[321,0]
    i_l_D4_D14_b_r = struct[0].y_ini[322,0]
    i_l_D4_D14_b_i = struct[0].y_ini[323,0]
    i_l_D4_D14_c_r = struct[0].y_ini[324,0]
    i_l_D4_D14_c_i = struct[0].y_ini[325,0]
    i_l_D4_D14_n_r = struct[0].y_ini[326,0]
    i_l_D4_D14_n_i = struct[0].y_ini[327,0]
    i_l_D14_D15_a_r = struct[0].y_ini[328,0]
    i_l_D14_D15_a_i = struct[0].y_ini[329,0]
    i_l_D14_D15_b_r = struct[0].y_ini[330,0]
    i_l_D14_D15_b_i = struct[0].y_ini[331,0]
    i_l_D14_D15_c_r = struct[0].y_ini[332,0]
    i_l_D14_D15_c_i = struct[0].y_ini[333,0]
    i_l_D14_D15_n_r = struct[0].y_ini[334,0]
    i_l_D14_D15_n_i = struct[0].y_ini[335,0]
    i_load_R1_a_r = struct[0].y_ini[336,0]
    i_load_R1_a_i = struct[0].y_ini[337,0]
    i_load_R1_b_r = struct[0].y_ini[338,0]
    i_load_R1_b_i = struct[0].y_ini[339,0]
    i_load_R1_c_r = struct[0].y_ini[340,0]
    i_load_R1_c_i = struct[0].y_ini[341,0]
    i_load_R1_n_r = struct[0].y_ini[342,0]
    i_load_R1_n_i = struct[0].y_ini[343,0]
    i_load_R11_a_r = struct[0].y_ini[344,0]
    i_load_R11_a_i = struct[0].y_ini[345,0]
    i_load_R11_b_r = struct[0].y_ini[346,0]
    i_load_R11_b_i = struct[0].y_ini[347,0]
    i_load_R11_c_r = struct[0].y_ini[348,0]
    i_load_R11_c_i = struct[0].y_ini[349,0]
    i_load_R11_n_r = struct[0].y_ini[350,0]
    i_load_R11_n_i = struct[0].y_ini[351,0]
    i_load_R15_a_r = struct[0].y_ini[352,0]
    i_load_R15_a_i = struct[0].y_ini[353,0]
    i_load_R15_b_r = struct[0].y_ini[354,0]
    i_load_R15_b_i = struct[0].y_ini[355,0]
    i_load_R15_c_r = struct[0].y_ini[356,0]
    i_load_R15_c_i = struct[0].y_ini[357,0]
    i_load_R15_n_r = struct[0].y_ini[358,0]
    i_load_R15_n_i = struct[0].y_ini[359,0]
    i_load_R16_a_r = struct[0].y_ini[360,0]
    i_load_R16_a_i = struct[0].y_ini[361,0]
    i_load_R16_b_r = struct[0].y_ini[362,0]
    i_load_R16_b_i = struct[0].y_ini[363,0]
    i_load_R16_c_r = struct[0].y_ini[364,0]
    i_load_R16_c_i = struct[0].y_ini[365,0]
    i_load_R16_n_r = struct[0].y_ini[366,0]
    i_load_R16_n_i = struct[0].y_ini[367,0]
    i_load_R17_a_r = struct[0].y_ini[368,0]
    i_load_R17_a_i = struct[0].y_ini[369,0]
    i_load_R17_b_r = struct[0].y_ini[370,0]
    i_load_R17_b_i = struct[0].y_ini[371,0]
    i_load_R17_c_r = struct[0].y_ini[372,0]
    i_load_R17_c_i = struct[0].y_ini[373,0]
    i_load_R17_n_r = struct[0].y_ini[374,0]
    i_load_R17_n_i = struct[0].y_ini[375,0]
    i_load_R18_a_r = struct[0].y_ini[376,0]
    i_load_R18_a_i = struct[0].y_ini[377,0]
    i_load_R18_b_r = struct[0].y_ini[378,0]
    i_load_R18_b_i = struct[0].y_ini[379,0]
    i_load_R18_c_r = struct[0].y_ini[380,0]
    i_load_R18_c_i = struct[0].y_ini[381,0]
    i_load_R18_n_r = struct[0].y_ini[382,0]
    i_load_R18_n_i = struct[0].y_ini[383,0]
    i_load_D15_a_r = struct[0].y_ini[384,0]
    i_load_D15_a_i = struct[0].y_ini[385,0]
    i_load_D15_n_r = struct[0].y_ini[386,0]
    i_load_D15_n_i = struct[0].y_ini[387,0]
    i_load_D11_a_r = struct[0].y_ini[388,0]
    i_load_D11_a_i = struct[0].y_ini[389,0]
    i_load_D11_n_r = struct[0].y_ini[390,0]
    i_load_D11_n_i = struct[0].y_ini[391,0]
    i_load_D16_a_r = struct[0].y_ini[392,0]
    i_load_D16_a_i = struct[0].y_ini[393,0]
    i_load_D16_n_r = struct[0].y_ini[394,0]
    i_load_D16_n_i = struct[0].y_ini[395,0]
    i_load_D17_a_r = struct[0].y_ini[396,0]
    i_load_D17_a_i = struct[0].y_ini[397,0]
    i_load_D17_n_r = struct[0].y_ini[398,0]
    i_load_D17_n_i = struct[0].y_ini[399,0]
    i_load_D18_a_r = struct[0].y_ini[400,0]
    i_load_D18_a_i = struct[0].y_ini[401,0]
    i_load_D18_n_r = struct[0].y_ini[402,0]
    i_load_D18_n_i = struct[0].y_ini[403,0]
    i_vsc_R1_a_r = struct[0].y_ini[404,0]
    i_vsc_R1_a_i = struct[0].y_ini[405,0]
    i_vsc_R1_b_r = struct[0].y_ini[406,0]
    i_vsc_R1_b_i = struct[0].y_ini[407,0]
    i_vsc_R1_c_r = struct[0].y_ini[408,0]
    i_vsc_R1_c_i = struct[0].y_ini[409,0]
    p_R1 = struct[0].y_ini[410,0]
    p_D1 = struct[0].y_ini[411,0]
    p_loss_R1 = struct[0].y_ini[412,0]
    i_vsc_R10_a_r = struct[0].y_ini[413,0]
    i_vsc_R10_a_i = struct[0].y_ini[414,0]
    i_vsc_R10_b_r = struct[0].y_ini[415,0]
    i_vsc_R10_b_i = struct[0].y_ini[416,0]
    i_vsc_R10_c_r = struct[0].y_ini[417,0]
    i_vsc_R10_c_i = struct[0].y_ini[418,0]
    i_vsc_D10_a_r = struct[0].y_ini[419,0]
    i_vsc_D10_n_r = struct[0].y_ini[420,0]
    p_D10 = struct[0].y_ini[421,0]
    p_loss_R10 = struct[0].y_ini[422,0]
    i_vsc_R14_a_r = struct[0].y_ini[423,0]
    i_vsc_R14_a_i = struct[0].y_ini[424,0]
    i_vsc_R14_b_r = struct[0].y_ini[425,0]
    i_vsc_R14_b_i = struct[0].y_ini[426,0]
    i_vsc_R14_c_r = struct[0].y_ini[427,0]
    i_vsc_R14_c_i = struct[0].y_ini[428,0]
    i_vsc_D14_a_r = struct[0].y_ini[429,0]
    i_vsc_D14_n_r = struct[0].y_ini[430,0]
    p_D14 = struct[0].y_ini[431,0]
    p_loss_R14 = struct[0].y_ini[432,0]
    
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = u_dummy - x_dummy
    
    # Algebraic equations:
    if mode == 3:


        struct[0].g[0,0] = i_load_R1_a_r + i_vsc_R1_a_r + 0.849044513514155*v_R0_a_i + 0.212261128378539*v_R0_a_r - 0.849044513514155*v_R0_c_i - 0.212261128378539*v_R0_c_r - 127.595184532966*v_R1_a_i - 123.954122254357*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r + 23.284964480954*v_R1_c_i + 24.9575997948692*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r + 54.0657727682604*v_R2_a_i + 105.57176931318*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r - 23.284964480954*v_R2_c_i - 24.9575997948692*v_R2_c_r - 10.2713736253513*v_R2_n_i - 39.6392229058202*v_R2_n_r
        struct[0].g[1,0] = i_load_R1_a_i + i_vsc_R1_a_i + 0.212261128378539*v_R0_a_i - 0.849044513514155*v_R0_a_r - 0.212261128378539*v_R0_c_i + 0.849044513514155*v_R0_c_r - 123.954122254357*v_R1_a_i + 127.595184532966*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r + 24.9575997948692*v_R1_c_i - 23.284964480954*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r + 105.57176931318*v_R2_a_i - 54.0657727682604*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r - 24.9575997948692*v_R2_c_i + 23.284964480954*v_R2_c_r - 39.6392229058202*v_R2_n_i + 10.2713736253513*v_R2_n_r
        struct[0].g[2,0] = i_load_R1_b_r + i_vsc_R1_b_r - 0.849044513514155*v_R0_a_i - 0.212261128378539*v_R0_a_r + 0.849044513514155*v_R0_b_i + 0.212261128378539*v_R0_b_r + 10.2713736253513*v_R1_a_i + 39.6392229058202*v_R1_a_r - 127.595184532966*v_R1_b_i - 123.954122254357*v_R1_b_r + 10.2713736253513*v_R1_c_i + 39.6392229058201*v_R1_c_r + 96.8143762456598*v_R1_n_i + 43.3399527360457*v_R1_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r + 54.0657727682604*v_R2_b_i + 105.57176931318*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058201*v_R2_c_r - 23.284964480954*v_R2_n_i - 24.9575997948692*v_R2_n_r
        struct[0].g[3,0] = i_load_R1_b_i + i_vsc_R1_b_i - 0.212261128378539*v_R0_a_i + 0.849044513514155*v_R0_a_r + 0.212261128378539*v_R0_b_i - 0.849044513514155*v_R0_b_r + 39.6392229058202*v_R1_a_i - 10.2713736253513*v_R1_a_r - 123.954122254357*v_R1_b_i + 127.595184532966*v_R1_b_r + 39.6392229058201*v_R1_c_i - 10.2713736253513*v_R1_c_r + 43.3399527360457*v_R1_n_i - 96.8143762456598*v_R1_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r + 105.57176931318*v_R2_b_i - 54.0657727682604*v_R2_b_r - 39.6392229058201*v_R2_c_i + 10.2713736253513*v_R2_c_r - 24.9575997948692*v_R2_n_i + 23.284964480954*v_R2_n_r
        struct[0].g[4,0] = i_load_R1_c_r + i_vsc_R1_c_r - 0.849044513514155*v_R0_b_i - 0.212261128378539*v_R0_b_r + 0.849044513514155*v_R0_c_i + 0.212261128378539*v_R0_c_r + 23.284964480954*v_R1_a_i + 24.9575997948692*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r - 127.595184532966*v_R1_c_i - 123.954122254357*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r - 23.284964480954*v_R2_a_i - 24.9575997948692*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r + 54.0657727682604*v_R2_c_i + 105.57176931318*v_R2_c_r - 10.2713736253514*v_R2_n_i - 39.6392229058201*v_R2_n_r
        struct[0].g[5,0] = i_load_R1_c_i + i_vsc_R1_c_i - 0.212261128378539*v_R0_b_i + 0.849044513514155*v_R0_b_r + 0.212261128378539*v_R0_c_i - 0.849044513514155*v_R0_c_r + 24.9575997948692*v_R1_a_i - 23.284964480954*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r - 123.954122254357*v_R1_c_i + 127.595184532966*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r - 24.9575997948692*v_R2_a_i + 23.284964480954*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r + 105.57176931318*v_R2_c_i - 54.0657727682604*v_R2_c_r - 39.6392229058201*v_R2_n_i + 10.2713736253514*v_R2_n_r
        struct[0].g[6,0] = 83.8007853900572*v_R1_a_i + 58.0215758469966*v_R1_a_r + 96.8143762456598*v_R1_b_i + 43.3399527360457*v_R1_b_r + 83.8007853900572*v_R1_c_i + 58.0215758469966*v_R1_c_r - 274.654008062378*v_R1_n_i - 161.052161470043*v_R1_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r - 23.284964480954*v_R2_b_i - 24.9575997948692*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058202*v_R2_c_r + 54.0657727682604*v_R2_n_i + 105.57176931318*v_R2_n_r
        struct[0].g[7,0] = 58.0215758469966*v_R1_a_i - 83.8007853900572*v_R1_a_r + 43.3399527360457*v_R1_b_i - 96.8143762456598*v_R1_b_r + 58.0215758469966*v_R1_c_i - 83.8007853900572*v_R1_c_r - 161.052161470043*v_R1_n_i + 274.654008062378*v_R1_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r - 24.9575997948692*v_R2_b_i + 23.284964480954*v_R2_b_r - 39.6392229058202*v_R2_c_i + 10.2713736253513*v_R2_c_r + 105.57176931318*v_R2_n_i - 54.0657727682604*v_R2_n_r
        struct[0].g[8,0] = i_load_R11_a_r - 4.84676915585801*v_R11_a_i - 26.5300693004806*v_R11_a_r - 1.58482814504483*v_R11_b_i + 7.8946133751477*v_R11_b_r - 0.67991845328531*v_R11_c_i + 7.72144347466701*v_R11_c_r - 1.58482814504483*v_R11_n_i + 7.89461337514771*v_R11_n_r + 4.84676915585801*v_R3_a_i + 26.5300693004806*v_R3_a_r + 1.58482814504483*v_R3_b_i - 7.8946133751477*v_R3_b_r + 0.67991845328531*v_R3_c_i - 7.72144347466701*v_R3_c_r + 1.58482814504483*v_R3_n_i - 7.89461337514771*v_R3_n_r
        struct[0].g[9,0] = i_load_R11_a_i - 26.5300693004806*v_R11_a_i + 4.84676915585801*v_R11_a_r + 7.8946133751477*v_R11_b_i + 1.58482814504483*v_R11_b_r + 7.72144347466701*v_R11_c_i + 0.67991845328531*v_R11_c_r + 7.89461337514771*v_R11_n_i + 1.58482814504483*v_R11_n_r + 26.5300693004806*v_R3_a_i - 4.84676915585801*v_R3_a_r - 7.8946133751477*v_R3_b_i - 1.58482814504483*v_R3_b_r - 7.72144347466701*v_R3_c_i - 0.67991845328531*v_R3_c_r - 7.89461337514771*v_R3_n_i - 1.58482814504483*v_R3_n_r
        struct[0].g[10,0] = i_load_R11_b_r - 1.58482814504483*v_R11_a_i + 7.89461337514771*v_R11_a_r - 4.84676915585801*v_R11_b_i - 26.5300693004806*v_R11_b_r - 1.58482814504483*v_R11_c_i + 7.89461337514771*v_R11_c_r - 0.679918453285308*v_R11_n_i + 7.72144347466701*v_R11_n_r + 1.58482814504483*v_R3_a_i - 7.89461337514771*v_R3_a_r + 4.84676915585801*v_R3_b_i + 26.5300693004806*v_R3_b_r + 1.58482814504483*v_R3_c_i - 7.89461337514771*v_R3_c_r + 0.679918453285308*v_R3_n_i - 7.72144347466701*v_R3_n_r
        struct[0].g[11,0] = i_load_R11_b_i + 7.89461337514771*v_R11_a_i + 1.58482814504483*v_R11_a_r - 26.5300693004806*v_R11_b_i + 4.84676915585801*v_R11_b_r + 7.89461337514771*v_R11_c_i + 1.58482814504483*v_R11_c_r + 7.72144347466701*v_R11_n_i + 0.679918453285308*v_R11_n_r - 7.89461337514771*v_R3_a_i - 1.58482814504483*v_R3_a_r + 26.5300693004806*v_R3_b_i - 4.84676915585801*v_R3_b_r - 7.89461337514771*v_R3_c_i - 1.58482814504483*v_R3_c_r - 7.72144347466701*v_R3_n_i - 0.679918453285308*v_R3_n_r
        struct[0].g[12,0] = i_load_R11_c_r - 0.67991845328531*v_R11_a_i + 7.72144347466701*v_R11_a_r - 1.58482814504483*v_R11_b_i + 7.8946133751477*v_R11_b_r - 4.84676915585801*v_R11_c_i - 26.5300693004806*v_R11_c_r - 1.58482814504483*v_R11_n_i + 7.89461337514771*v_R11_n_r + 0.67991845328531*v_R3_a_i - 7.72144347466701*v_R3_a_r + 1.58482814504483*v_R3_b_i - 7.8946133751477*v_R3_b_r + 4.84676915585801*v_R3_c_i + 26.5300693004806*v_R3_c_r + 1.58482814504483*v_R3_n_i - 7.89461337514771*v_R3_n_r
        struct[0].g[13,0] = i_load_R11_c_i + 7.72144347466701*v_R11_a_i + 0.67991845328531*v_R11_a_r + 7.8946133751477*v_R11_b_i + 1.58482814504483*v_R11_b_r - 26.5300693004806*v_R11_c_i + 4.84676915585801*v_R11_c_r + 7.89461337514771*v_R11_n_i + 1.58482814504483*v_R11_n_r - 7.72144347466701*v_R3_a_i - 0.67991845328531*v_R3_a_r - 7.8946133751477*v_R3_b_i - 1.58482814504483*v_R3_b_r + 26.5300693004806*v_R3_c_i - 4.84676915585801*v_R3_c_r - 7.89461337514771*v_R3_n_i - 1.58482814504483*v_R3_n_r
        struct[0].g[14,0] = -1.58482814504483*v_R11_a_i + 7.89461337514771*v_R11_a_r - 0.679918453285308*v_R11_b_i + 7.72144347466701*v_R11_b_r - 1.58482814504483*v_R11_c_i + 7.89461337514771*v_R11_c_r - 4.84676915585801*v_R11_n_i - 26.5550693004806*v_R11_n_r + 1.58482814504483*v_R3_a_i - 7.89461337514771*v_R3_a_r + 0.679918453285308*v_R3_b_i - 7.72144347466701*v_R3_b_r + 1.58482814504483*v_R3_c_i - 7.89461337514771*v_R3_c_r + 4.84676915585801*v_R3_n_i + 26.5300693004806*v_R3_n_r
        struct[0].g[15,0] = 7.89461337514771*v_R11_a_i + 1.58482814504483*v_R11_a_r + 7.72144347466701*v_R11_b_i + 0.679918453285308*v_R11_b_r + 7.89461337514771*v_R11_c_i + 1.58482814504483*v_R11_c_r - 26.5550693004806*v_R11_n_i + 4.84676915585801*v_R11_n_r - 7.89461337514771*v_R3_a_i - 1.58482814504483*v_R3_a_r - 7.72144347466701*v_R3_b_i - 0.679918453285308*v_R3_b_r - 7.89461337514771*v_R3_c_i - 1.58482814504483*v_R3_c_r + 26.5300693004806*v_R3_n_i - 4.84676915585801*v_R3_n_r
        struct[0].g[16,0] = i_load_R15_a_r + 4.84676915585801*v_R14_a_i + 26.5300693004806*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 0.67991845328531*v_R14_c_i - 7.72144347466701*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r - 4.84676915585801*v_R15_a_i - 26.5300693004806*v_R15_a_r - 1.58482814504483*v_R15_b_i + 7.8946133751477*v_R15_b_r - 0.67991845328531*v_R15_c_i + 7.72144347466701*v_R15_c_r - 1.58482814504483*v_R15_n_i + 7.89461337514771*v_R15_n_r
        struct[0].g[17,0] = i_load_R15_a_i + 26.5300693004806*v_R14_a_i - 4.84676915585801*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r - 7.72144347466701*v_R14_c_i - 0.67991845328531*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r - 26.5300693004806*v_R15_a_i + 4.84676915585801*v_R15_a_r + 7.8946133751477*v_R15_b_i + 1.58482814504483*v_R15_b_r + 7.72144347466701*v_R15_c_i + 0.67991845328531*v_R15_c_r + 7.89461337514771*v_R15_n_i + 1.58482814504483*v_R15_n_r
        struct[0].g[18,0] = i_load_R15_b_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 4.84676915585801*v_R14_b_i + 26.5300693004806*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 0.679918453285308*v_R14_n_i - 7.72144347466701*v_R14_n_r - 1.58482814504483*v_R15_a_i + 7.89461337514771*v_R15_a_r - 4.84676915585801*v_R15_b_i - 26.5300693004806*v_R15_b_r - 1.58482814504483*v_R15_c_i + 7.89461337514771*v_R15_c_r - 0.679918453285308*v_R15_n_i + 7.72144347466701*v_R15_n_r
        struct[0].g[19,0] = i_load_R15_b_i - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r + 26.5300693004806*v_R14_b_i - 4.84676915585801*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r - 7.72144347466701*v_R14_n_i - 0.679918453285308*v_R14_n_r + 7.89461337514771*v_R15_a_i + 1.58482814504483*v_R15_a_r - 26.5300693004806*v_R15_b_i + 4.84676915585801*v_R15_b_r + 7.89461337514771*v_R15_c_i + 1.58482814504483*v_R15_c_r + 7.72144347466701*v_R15_n_i + 0.679918453285308*v_R15_n_r
        struct[0].g[20,0] = i_load_R15_c_r + 0.67991845328531*v_R14_a_i - 7.72144347466701*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 4.84676915585801*v_R14_c_i + 26.5300693004806*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r - 0.67991845328531*v_R15_a_i + 7.72144347466701*v_R15_a_r - 1.58482814504483*v_R15_b_i + 7.8946133751477*v_R15_b_r - 4.84676915585801*v_R15_c_i - 26.5300693004806*v_R15_c_r - 1.58482814504483*v_R15_n_i + 7.89461337514771*v_R15_n_r
        struct[0].g[21,0] = i_load_R15_c_i - 7.72144347466701*v_R14_a_i - 0.67991845328531*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r + 26.5300693004806*v_R14_c_i - 4.84676915585801*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r + 7.72144347466701*v_R15_a_i + 0.67991845328531*v_R15_a_r + 7.8946133751477*v_R15_b_i + 1.58482814504483*v_R15_b_r - 26.5300693004806*v_R15_c_i + 4.84676915585801*v_R15_c_r + 7.89461337514771*v_R15_n_i + 1.58482814504483*v_R15_n_r
        struct[0].g[22,0] = 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 0.679918453285308*v_R14_b_i - 7.72144347466701*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 4.84676915585801*v_R14_n_i + 26.5300693004806*v_R14_n_r - 1.58482814504483*v_R15_a_i + 7.89461337514771*v_R15_a_r - 0.679918453285308*v_R15_b_i + 7.72144347466701*v_R15_b_r - 1.58482814504483*v_R15_c_i + 7.89461337514771*v_R15_c_r - 4.84676915585801*v_R15_n_i - 26.5550693004806*v_R15_n_r
        struct[0].g[23,0] = -7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r - 7.72144347466701*v_R14_b_i - 0.679918453285308*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r + 26.5300693004806*v_R14_n_i - 4.84676915585801*v_R14_n_r + 7.89461337514771*v_R15_a_i + 1.58482814504483*v_R15_a_r + 7.72144347466701*v_R15_b_i + 0.679918453285308*v_R15_b_r + 7.89461337514771*v_R15_c_i + 1.58482814504483*v_R15_c_r - 26.5550693004806*v_R15_n_i + 4.84676915585801*v_R15_n_r
        struct[0].g[24,0] = i_load_R16_a_r - 5.65456401516768*v_R16_a_i - 30.9517475172273*v_R16_a_r - 1.84896616921897*v_R16_b_i + 9.21038227100566*v_R16_b_r - 0.793238195499529*v_R16_c_i + 9.00835072044485*v_R16_c_r - 1.84896616921897*v_R16_n_i + 9.21038227100566*v_R16_n_r + 5.65456401516768*v_R6_a_i + 30.9517475172273*v_R6_a_r + 1.84896616921897*v_R6_b_i - 9.21038227100566*v_R6_b_r + 0.793238195499529*v_R6_c_i - 9.00835072044485*v_R6_c_r + 1.84896616921897*v_R6_n_i - 9.21038227100566*v_R6_n_r
        struct[0].g[25,0] = i_load_R16_a_i - 30.9517475172273*v_R16_a_i + 5.65456401516768*v_R16_a_r + 9.21038227100566*v_R16_b_i + 1.84896616921897*v_R16_b_r + 9.00835072044485*v_R16_c_i + 0.793238195499529*v_R16_c_r + 9.21038227100566*v_R16_n_i + 1.84896616921897*v_R16_n_r + 30.9517475172273*v_R6_a_i - 5.65456401516768*v_R6_a_r - 9.21038227100566*v_R6_b_i - 1.84896616921897*v_R6_b_r - 9.00835072044485*v_R6_c_i - 0.793238195499529*v_R6_c_r - 9.21038227100566*v_R6_n_i - 1.84896616921897*v_R6_n_r
        struct[0].g[26,0] = i_load_R16_b_r - 1.84896616921897*v_R16_a_i + 9.21038227100566*v_R16_a_r - 5.65456401516768*v_R16_b_i - 30.9517475172273*v_R16_b_r - 1.84896616921897*v_R16_c_i + 9.21038227100566*v_R16_c_r - 0.793238195499528*v_R16_n_i + 9.00835072044485*v_R16_n_r + 1.84896616921897*v_R6_a_i - 9.21038227100566*v_R6_a_r + 5.65456401516768*v_R6_b_i + 30.9517475172273*v_R6_b_r + 1.84896616921897*v_R6_c_i - 9.21038227100566*v_R6_c_r + 0.793238195499528*v_R6_n_i - 9.00835072044485*v_R6_n_r
        struct[0].g[27,0] = i_load_R16_b_i + 9.21038227100566*v_R16_a_i + 1.84896616921897*v_R16_a_r - 30.9517475172273*v_R16_b_i + 5.65456401516768*v_R16_b_r + 9.21038227100566*v_R16_c_i + 1.84896616921897*v_R16_c_r + 9.00835072044485*v_R16_n_i + 0.793238195499528*v_R16_n_r - 9.21038227100566*v_R6_a_i - 1.84896616921897*v_R6_a_r + 30.9517475172273*v_R6_b_i - 5.65456401516768*v_R6_b_r - 9.21038227100566*v_R6_c_i - 1.84896616921897*v_R6_c_r - 9.00835072044485*v_R6_n_i - 0.793238195499528*v_R6_n_r
        struct[0].g[28,0] = i_load_R16_c_r - 0.793238195499527*v_R16_a_i + 9.00835072044484*v_R16_a_r - 1.84896616921897*v_R16_b_i + 9.21038227100566*v_R16_b_r - 5.65456401516768*v_R16_c_i - 30.9517475172273*v_R16_c_r - 1.84896616921897*v_R16_n_i + 9.21038227100566*v_R16_n_r + 0.793238195499527*v_R6_a_i - 9.00835072044484*v_R6_a_r + 1.84896616921897*v_R6_b_i - 9.21038227100566*v_R6_b_r + 5.65456401516768*v_R6_c_i + 30.9517475172273*v_R6_c_r + 1.84896616921897*v_R6_n_i - 9.21038227100566*v_R6_n_r
        struct[0].g[29,0] = i_load_R16_c_i + 9.00835072044484*v_R16_a_i + 0.793238195499527*v_R16_a_r + 9.21038227100566*v_R16_b_i + 1.84896616921897*v_R16_b_r - 30.9517475172273*v_R16_c_i + 5.65456401516768*v_R16_c_r + 9.21038227100566*v_R16_n_i + 1.84896616921897*v_R16_n_r - 9.00835072044484*v_R6_a_i - 0.793238195499527*v_R6_a_r - 9.21038227100566*v_R6_b_i - 1.84896616921897*v_R6_b_r + 30.9517475172273*v_R6_c_i - 5.65456401516768*v_R6_c_r - 9.21038227100566*v_R6_n_i - 1.84896616921897*v_R6_n_r
        struct[0].g[30,0] = -1.84896616921897*v_R16_a_i + 9.21038227100566*v_R16_a_r - 0.793238195499527*v_R16_b_i + 9.00835072044485*v_R16_b_r - 1.84896616921897*v_R16_c_i + 9.21038227100566*v_R16_c_r - 5.65456401516768*v_R16_n_i - 30.9767475172273*v_R16_n_r + 1.84896616921897*v_R6_a_i - 9.21038227100566*v_R6_a_r + 0.793238195499527*v_R6_b_i - 9.00835072044485*v_R6_b_r + 1.84896616921897*v_R6_c_i - 9.21038227100566*v_R6_c_r + 5.65456401516768*v_R6_n_i + 30.9517475172273*v_R6_n_r
        struct[0].g[31,0] = 9.21038227100566*v_R16_a_i + 1.84896616921897*v_R16_a_r + 9.00835072044485*v_R16_b_i + 0.793238195499527*v_R16_b_r + 9.21038227100566*v_R16_c_i + 1.84896616921897*v_R16_c_r - 30.9767475172273*v_R16_n_i + 5.65456401516768*v_R16_n_r - 9.21038227100566*v_R6_a_i - 1.84896616921897*v_R6_a_r - 9.00835072044485*v_R6_b_i - 0.793238195499527*v_R6_b_r - 9.21038227100566*v_R6_c_i - 1.84896616921897*v_R6_c_r + 30.9517475172273*v_R6_n_i - 5.65456401516768*v_R6_n_r
        struct[0].g[32,0] = i_load_R17_a_r - 5.65456401516768*v_R17_a_i - 30.9517475172273*v_R17_a_r - 1.84896616921897*v_R17_b_i + 9.21038227100566*v_R17_b_r - 0.793238195499529*v_R17_c_i + 9.00835072044485*v_R17_c_r - 1.84896616921897*v_R17_n_i + 9.21038227100566*v_R17_n_r + 5.65456401516768*v_R9_a_i + 30.9517475172273*v_R9_a_r + 1.84896616921897*v_R9_b_i - 9.21038227100566*v_R9_b_r + 0.793238195499529*v_R9_c_i - 9.00835072044485*v_R9_c_r + 1.84896616921897*v_R9_n_i - 9.21038227100566*v_R9_n_r
        struct[0].g[33,0] = i_load_R17_a_i - 30.9517475172273*v_R17_a_i + 5.65456401516768*v_R17_a_r + 9.21038227100566*v_R17_b_i + 1.84896616921897*v_R17_b_r + 9.00835072044485*v_R17_c_i + 0.793238195499529*v_R17_c_r + 9.21038227100566*v_R17_n_i + 1.84896616921897*v_R17_n_r + 30.9517475172273*v_R9_a_i - 5.65456401516768*v_R9_a_r - 9.21038227100566*v_R9_b_i - 1.84896616921897*v_R9_b_r - 9.00835072044485*v_R9_c_i - 0.793238195499529*v_R9_c_r - 9.21038227100566*v_R9_n_i - 1.84896616921897*v_R9_n_r
        struct[0].g[34,0] = i_load_R17_b_r - 1.84896616921897*v_R17_a_i + 9.21038227100566*v_R17_a_r - 5.65456401516768*v_R17_b_i - 30.9517475172273*v_R17_b_r - 1.84896616921897*v_R17_c_i + 9.21038227100566*v_R17_c_r - 0.793238195499528*v_R17_n_i + 9.00835072044485*v_R17_n_r + 1.84896616921897*v_R9_a_i - 9.21038227100566*v_R9_a_r + 5.65456401516768*v_R9_b_i + 30.9517475172273*v_R9_b_r + 1.84896616921897*v_R9_c_i - 9.21038227100566*v_R9_c_r + 0.793238195499528*v_R9_n_i - 9.00835072044485*v_R9_n_r
        struct[0].g[35,0] = i_load_R17_b_i + 9.21038227100566*v_R17_a_i + 1.84896616921897*v_R17_a_r - 30.9517475172273*v_R17_b_i + 5.65456401516768*v_R17_b_r + 9.21038227100566*v_R17_c_i + 1.84896616921897*v_R17_c_r + 9.00835072044485*v_R17_n_i + 0.793238195499528*v_R17_n_r - 9.21038227100566*v_R9_a_i - 1.84896616921897*v_R9_a_r + 30.9517475172273*v_R9_b_i - 5.65456401516768*v_R9_b_r - 9.21038227100566*v_R9_c_i - 1.84896616921897*v_R9_c_r - 9.00835072044485*v_R9_n_i - 0.793238195499528*v_R9_n_r
        struct[0].g[36,0] = i_load_R17_c_r - 0.793238195499527*v_R17_a_i + 9.00835072044484*v_R17_a_r - 1.84896616921897*v_R17_b_i + 9.21038227100566*v_R17_b_r - 5.65456401516768*v_R17_c_i - 30.9517475172273*v_R17_c_r - 1.84896616921897*v_R17_n_i + 9.21038227100566*v_R17_n_r + 0.793238195499527*v_R9_a_i - 9.00835072044484*v_R9_a_r + 1.84896616921897*v_R9_b_i - 9.21038227100566*v_R9_b_r + 5.65456401516768*v_R9_c_i + 30.9517475172273*v_R9_c_r + 1.84896616921897*v_R9_n_i - 9.21038227100566*v_R9_n_r
        struct[0].g[37,0] = i_load_R17_c_i + 9.00835072044484*v_R17_a_i + 0.793238195499527*v_R17_a_r + 9.21038227100566*v_R17_b_i + 1.84896616921897*v_R17_b_r - 30.9517475172273*v_R17_c_i + 5.65456401516768*v_R17_c_r + 9.21038227100566*v_R17_n_i + 1.84896616921897*v_R17_n_r - 9.00835072044484*v_R9_a_i - 0.793238195499527*v_R9_a_r - 9.21038227100566*v_R9_b_i - 1.84896616921897*v_R9_b_r + 30.9517475172273*v_R9_c_i - 5.65456401516768*v_R9_c_r - 9.21038227100566*v_R9_n_i - 1.84896616921897*v_R9_n_r
        struct[0].g[38,0] = -1.84896616921897*v_R17_a_i + 9.21038227100566*v_R17_a_r - 0.793238195499527*v_R17_b_i + 9.00835072044485*v_R17_b_r - 1.84896616921897*v_R17_c_i + 9.21038227100566*v_R17_c_r - 5.65456401516768*v_R17_n_i - 30.9767475172273*v_R17_n_r + 1.84896616921897*v_R9_a_i - 9.21038227100566*v_R9_a_r + 0.793238195499527*v_R9_b_i - 9.00835072044485*v_R9_b_r + 1.84896616921897*v_R9_c_i - 9.21038227100566*v_R9_c_r + 5.65456401516768*v_R9_n_i + 30.9517475172273*v_R9_n_r
        struct[0].g[39,0] = 9.21038227100566*v_R17_a_i + 1.84896616921897*v_R17_a_r + 9.00835072044485*v_R17_b_i + 0.793238195499527*v_R17_b_r + 9.21038227100566*v_R17_c_i + 1.84896616921897*v_R17_c_r - 30.9767475172273*v_R17_n_i + 5.65456401516768*v_R17_n_r - 9.21038227100566*v_R9_a_i - 1.84896616921897*v_R9_a_r - 9.00835072044485*v_R9_b_i - 0.793238195499527*v_R9_b_r - 9.21038227100566*v_R9_c_i - 1.84896616921897*v_R9_c_r + 30.9517475172273*v_R9_n_i - 5.65456401516768*v_R9_n_r
        struct[0].g[40,0] = i_load_R18_a_r + 5.65456401516768*v_R10_a_i + 30.9517475172273*v_R10_a_r + 1.84896616921897*v_R10_b_i - 9.21038227100566*v_R10_b_r + 0.793238195499529*v_R10_c_i - 9.00835072044485*v_R10_c_r + 1.84896616921897*v_R10_n_i - 9.21038227100566*v_R10_n_r - 5.65456401516768*v_R18_a_i - 30.9517475172273*v_R18_a_r - 1.84896616921897*v_R18_b_i + 9.21038227100566*v_R18_b_r - 0.793238195499529*v_R18_c_i + 9.00835072044485*v_R18_c_r - 1.84896616921897*v_R18_n_i + 9.21038227100566*v_R18_n_r
        struct[0].g[41,0] = i_load_R18_a_i + 30.9517475172273*v_R10_a_i - 5.65456401516768*v_R10_a_r - 9.21038227100566*v_R10_b_i - 1.84896616921897*v_R10_b_r - 9.00835072044485*v_R10_c_i - 0.793238195499529*v_R10_c_r - 9.21038227100566*v_R10_n_i - 1.84896616921897*v_R10_n_r - 30.9517475172273*v_R18_a_i + 5.65456401516768*v_R18_a_r + 9.21038227100566*v_R18_b_i + 1.84896616921897*v_R18_b_r + 9.00835072044485*v_R18_c_i + 0.793238195499529*v_R18_c_r + 9.21038227100566*v_R18_n_i + 1.84896616921897*v_R18_n_r
        struct[0].g[42,0] = i_load_R18_b_r + 1.84896616921897*v_R10_a_i - 9.21038227100566*v_R10_a_r + 5.65456401516768*v_R10_b_i + 30.9517475172273*v_R10_b_r + 1.84896616921897*v_R10_c_i - 9.21038227100566*v_R10_c_r + 0.793238195499528*v_R10_n_i - 9.00835072044485*v_R10_n_r - 1.84896616921897*v_R18_a_i + 9.21038227100566*v_R18_a_r - 5.65456401516768*v_R18_b_i - 30.9517475172273*v_R18_b_r - 1.84896616921897*v_R18_c_i + 9.21038227100566*v_R18_c_r - 0.793238195499528*v_R18_n_i + 9.00835072044485*v_R18_n_r
        struct[0].g[43,0] = i_load_R18_b_i - 9.21038227100566*v_R10_a_i - 1.84896616921897*v_R10_a_r + 30.9517475172273*v_R10_b_i - 5.65456401516768*v_R10_b_r - 9.21038227100566*v_R10_c_i - 1.84896616921897*v_R10_c_r - 9.00835072044485*v_R10_n_i - 0.793238195499528*v_R10_n_r + 9.21038227100566*v_R18_a_i + 1.84896616921897*v_R18_a_r - 30.9517475172273*v_R18_b_i + 5.65456401516768*v_R18_b_r + 9.21038227100566*v_R18_c_i + 1.84896616921897*v_R18_c_r + 9.00835072044485*v_R18_n_i + 0.793238195499528*v_R18_n_r
        struct[0].g[44,0] = i_load_R18_c_r + 0.793238195499527*v_R10_a_i - 9.00835072044484*v_R10_a_r + 1.84896616921897*v_R10_b_i - 9.21038227100566*v_R10_b_r + 5.65456401516768*v_R10_c_i + 30.9517475172273*v_R10_c_r + 1.84896616921897*v_R10_n_i - 9.21038227100566*v_R10_n_r - 0.793238195499527*v_R18_a_i + 9.00835072044484*v_R18_a_r - 1.84896616921897*v_R18_b_i + 9.21038227100566*v_R18_b_r - 5.65456401516768*v_R18_c_i - 30.9517475172273*v_R18_c_r - 1.84896616921897*v_R18_n_i + 9.21038227100566*v_R18_n_r
        struct[0].g[45,0] = i_load_R18_c_i - 9.00835072044484*v_R10_a_i - 0.793238195499527*v_R10_a_r - 9.21038227100566*v_R10_b_i - 1.84896616921897*v_R10_b_r + 30.9517475172273*v_R10_c_i - 5.65456401516768*v_R10_c_r - 9.21038227100566*v_R10_n_i - 1.84896616921897*v_R10_n_r + 9.00835072044484*v_R18_a_i + 0.793238195499527*v_R18_a_r + 9.21038227100566*v_R18_b_i + 1.84896616921897*v_R18_b_r - 30.9517475172273*v_R18_c_i + 5.65456401516768*v_R18_c_r + 9.21038227100566*v_R18_n_i + 1.84896616921897*v_R18_n_r
        struct[0].g[46,0] = 1.84896616921897*v_R10_a_i - 9.21038227100566*v_R10_a_r + 0.793238195499527*v_R10_b_i - 9.00835072044485*v_R10_b_r + 1.84896616921897*v_R10_c_i - 9.21038227100566*v_R10_c_r + 5.65456401516768*v_R10_n_i + 30.9517475172273*v_R10_n_r - 1.84896616921897*v_R18_a_i + 9.21038227100566*v_R18_a_r - 0.793238195499527*v_R18_b_i + 9.00835072044485*v_R18_b_r - 1.84896616921897*v_R18_c_i + 9.21038227100566*v_R18_c_r - 5.65456401516768*v_R18_n_i - 30.9767475172273*v_R18_n_r
        struct[0].g[47,0] = -9.21038227100566*v_R10_a_i - 1.84896616921897*v_R10_a_r - 9.00835072044485*v_R10_b_i - 0.793238195499527*v_R10_b_r - 9.21038227100566*v_R10_c_i - 1.84896616921897*v_R10_c_r + 30.9517475172273*v_R10_n_i - 5.65456401516768*v_R10_n_r + 9.21038227100566*v_R18_a_i + 1.84896616921897*v_R18_a_r + 9.00835072044485*v_R18_b_i + 0.793238195499527*v_R18_b_r + 9.21038227100566*v_R18_c_i + 1.84896616921897*v_R18_c_r - 30.9767475172273*v_R18_n_i + 5.65456401516768*v_R18_n_r
        struct[0].g[48,0] = i_load_D15_a_r + 135.4096140826*v_D14_a_r - 135.4096140826*v_D15_a_r
        struct[0].g[49,0] = i_load_D15_a_i + 135.4096140826*v_D14_a_i - 135.4096140826*v_D15_a_i
        struct[0].g[50,0] = i_load_D15_n_r + 135.4096140826*v_D14_n_r - 135.4096140826*v_D15_n_r
        struct[0].g[51,0] = i_load_D15_n_i + 135.4096140826*v_D14_n_i - 135.4096140826*v_D15_n_i
        struct[0].g[52,0] = i_load_D11_a_r - 157.977883096366*v_D11_a_r + 157.977883096366*v_D3_a_r
        struct[0].g[53,0] = i_load_D11_a_i - 157.977883096366*v_D11_a_i + 157.977883096366*v_D3_a_i
        struct[0].g[54,0] = i_load_D11_n_r - 157.977883096366*v_D11_n_r + 157.977883096366*v_D3_n_r
        struct[0].g[55,0] = i_load_D11_n_i - 157.977883096366*v_D11_n_i + 157.977883096366*v_D3_n_i
        struct[0].g[56,0] = i_load_D16_a_r - 157.977883096366*v_D16_a_r + 157.977883096366*v_D6_a_r
        struct[0].g[57,0] = i_load_D16_a_i - 157.977883096366*v_D16_a_i + 157.977883096366*v_D6_a_i
        struct[0].g[58,0] = i_load_D16_n_r - 157.977883096366*v_D16_n_r + 157.977883096366*v_D6_n_r
        struct[0].g[59,0] = i_load_D16_n_i - 157.977883096366*v_D16_n_i + 157.977883096366*v_D6_n_i
        struct[0].g[60,0] = i_load_D17_a_r - 157.977883096366*v_D17_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[61,0] = i_load_D17_a_i - 157.977883096366*v_D17_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[62,0] = i_load_D17_n_r - 157.977883096366*v_D17_n_r + 157.977883096366*v_D9_n_r
        struct[0].g[63,0] = i_load_D17_n_i - 157.977883096366*v_D17_n_i + 157.977883096366*v_D9_n_i
        struct[0].g[64,0] = i_load_D18_a_r + 157.977883096366*v_D10_a_r - 157.977883096366*v_D18_a_r
        struct[0].g[65,0] = i_load_D18_a_i + 157.977883096366*v_D10_a_i - 157.977883096366*v_D18_a_i
        struct[0].g[66,0] = i_load_D18_n_r + 157.977883096366*v_D10_n_r - 157.977883096366*v_D18_n_r
        struct[0].g[67,0] = i_load_D18_n_i + 157.977883096366*v_D10_n_i - 157.977883096366*v_D18_n_i
        struct[0].g[68,0] = 54.0657727682604*v_R1_a_i + 105.57176931318*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r - 23.284964480954*v_R1_c_i - 24.9575997948692*v_R1_c_r - 10.2713736253513*v_R1_n_i - 39.6392229058202*v_R1_n_r - 108.131545536521*v_R2_a_i - 211.14353862636*v_R2_a_r + 20.5427472507027*v_R2_b_i + 79.2784458116403*v_R2_b_r + 46.569928961908*v_R2_c_i + 49.9151995897384*v_R2_c_r + 20.5427472507027*v_R2_n_i + 79.2784458116403*v_R2_n_r + 54.0657727682604*v_R3_a_i + 105.57176931318*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r - 23.284964480954*v_R3_c_i - 24.9575997948692*v_R3_c_r - 10.2713736253513*v_R3_n_i - 39.6392229058202*v_R3_n_r
        struct[0].g[69,0] = 105.57176931318*v_R1_a_i - 54.0657727682604*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r - 24.9575997948692*v_R1_c_i + 23.284964480954*v_R1_c_r - 39.6392229058202*v_R1_n_i + 10.2713736253513*v_R1_n_r - 211.14353862636*v_R2_a_i + 108.131545536521*v_R2_a_r + 79.2784458116403*v_R2_b_i - 20.5427472507027*v_R2_b_r + 49.9151995897384*v_R2_c_i - 46.569928961908*v_R2_c_r + 79.2784458116403*v_R2_n_i - 20.5427472507027*v_R2_n_r + 105.57176931318*v_R3_a_i - 54.0657727682604*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r - 24.9575997948692*v_R3_c_i + 23.284964480954*v_R3_c_r - 39.6392229058202*v_R3_n_i + 10.2713736253513*v_R3_n_r
        struct[0].g[70,0] = -10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r + 54.0657727682604*v_R1_b_i + 105.57176931318*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058201*v_R1_c_r - 23.284964480954*v_R1_n_i - 24.9575997948692*v_R1_n_r + 20.5427472507027*v_R2_a_i + 79.2784458116403*v_R2_a_r - 108.131545536521*v_R2_b_i - 211.14353862636*v_R2_b_r + 20.5427472507027*v_R2_c_i + 79.2784458116403*v_R2_c_r + 46.569928961908*v_R2_n_i + 49.9151995897384*v_R2_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r + 54.0657727682604*v_R3_b_i + 105.57176931318*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058201*v_R3_c_r - 23.284964480954*v_R3_n_i - 24.9575997948692*v_R3_n_r
        struct[0].g[71,0] = -39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r + 105.57176931318*v_R1_b_i - 54.0657727682604*v_R1_b_r - 39.6392229058201*v_R1_c_i + 10.2713736253513*v_R1_c_r - 24.9575997948692*v_R1_n_i + 23.284964480954*v_R1_n_r + 79.2784458116403*v_R2_a_i - 20.5427472507027*v_R2_a_r - 211.14353862636*v_R2_b_i + 108.131545536521*v_R2_b_r + 79.2784458116403*v_R2_c_i - 20.5427472507027*v_R2_c_r + 49.9151995897384*v_R2_n_i - 46.569928961908*v_R2_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r + 105.57176931318*v_R3_b_i - 54.0657727682604*v_R3_b_r - 39.6392229058201*v_R3_c_i + 10.2713736253513*v_R3_c_r - 24.9575997948692*v_R3_n_i + 23.284964480954*v_R3_n_r
        struct[0].g[72,0] = -23.284964480954*v_R1_a_i - 24.9575997948692*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r + 54.0657727682604*v_R1_c_i + 105.57176931318*v_R1_c_r - 10.2713736253514*v_R1_n_i - 39.6392229058201*v_R1_n_r + 46.569928961908*v_R2_a_i + 49.9151995897384*v_R2_a_r + 20.5427472507027*v_R2_b_i + 79.2784458116404*v_R2_b_r - 108.131545536521*v_R2_c_i - 211.14353862636*v_R2_c_r + 20.5427472507027*v_R2_n_i + 79.2784458116403*v_R2_n_r - 23.284964480954*v_R3_a_i - 24.9575997948692*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r + 54.0657727682604*v_R3_c_i + 105.57176931318*v_R3_c_r - 10.2713736253514*v_R3_n_i - 39.6392229058201*v_R3_n_r
        struct[0].g[73,0] = -24.9575997948692*v_R1_a_i + 23.284964480954*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r + 105.57176931318*v_R1_c_i - 54.0657727682604*v_R1_c_r - 39.6392229058201*v_R1_n_i + 10.2713736253514*v_R1_n_r + 49.9151995897384*v_R2_a_i - 46.569928961908*v_R2_a_r + 79.2784458116404*v_R2_b_i - 20.5427472507027*v_R2_b_r - 211.14353862636*v_R2_c_i + 108.131545536521*v_R2_c_r + 79.2784458116403*v_R2_n_i - 20.5427472507027*v_R2_n_r - 24.9575997948692*v_R3_a_i + 23.284964480954*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r + 105.57176931318*v_R3_c_i - 54.0657727682604*v_R3_c_r - 39.6392229058201*v_R3_n_i + 10.2713736253514*v_R3_n_r
        struct[0].g[74,0] = -10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r - 23.284964480954*v_R1_b_i - 24.9575997948692*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058202*v_R1_c_r + 54.0657727682604*v_R1_n_i + 105.57176931318*v_R1_n_r + 20.5427472507027*v_R2_a_i + 79.2784458116403*v_R2_a_r + 46.569928961908*v_R2_b_i + 49.9151995897384*v_R2_b_r + 20.5427472507027*v_R2_c_i + 79.2784458116403*v_R2_c_r - 108.131545536521*v_R2_n_i - 211.16853862636*v_R2_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r - 23.284964480954*v_R3_b_i - 24.9575997948692*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058202*v_R3_c_r + 54.0657727682604*v_R3_n_i + 105.57176931318*v_R3_n_r
        struct[0].g[75,0] = -39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r - 24.9575997948692*v_R1_b_i + 23.284964480954*v_R1_b_r - 39.6392229058202*v_R1_c_i + 10.2713736253513*v_R1_c_r + 105.57176931318*v_R1_n_i - 54.0657727682604*v_R1_n_r + 79.2784458116403*v_R2_a_i - 20.5427472507027*v_R2_a_r + 49.9151995897384*v_R2_b_i - 46.569928961908*v_R2_b_r + 79.2784458116403*v_R2_c_i - 20.5427472507027*v_R2_c_r - 211.16853862636*v_R2_n_i + 108.131545536521*v_R2_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r - 24.9575997948692*v_R3_b_i + 23.284964480954*v_R3_b_r - 39.6392229058202*v_R3_c_i + 10.2713736253513*v_R3_c_r + 105.57176931318*v_R3_n_i - 54.0657727682604*v_R3_n_r
        struct[0].g[76,0] = 4.84676915585801*v_R11_a_i + 26.5300693004806*v_R11_a_r + 1.58482814504483*v_R11_b_i - 7.8946133751477*v_R11_b_r + 0.67991845328531*v_R11_c_i - 7.72144347466701*v_R11_c_r + 1.58482814504483*v_R11_n_i - 7.89461337514771*v_R11_n_r + 54.0657727682604*v_R2_a_i + 105.57176931318*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r - 23.284964480954*v_R2_c_i - 24.9575997948692*v_R2_c_r - 10.2713736253513*v_R2_n_i - 39.6392229058202*v_R2_n_r - 112.978314692379*v_R3_a_i - 237.673607926841*v_R3_a_r + 18.9579191056578*v_R3_b_i + 87.173059186788*v_R3_b_r + 45.8900105086227*v_R3_c_i + 57.6366430644055*v_R3_c_r + 18.9579191056579*v_R3_n_i + 87.173059186788*v_R3_n_r + 54.0657727682604*v_R4_a_i + 105.57176931318*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r - 23.284964480954*v_R4_c_i - 24.9575997948692*v_R4_c_r - 10.2713736253513*v_R4_n_i - 39.6392229058202*v_R4_n_r
        struct[0].g[77,0] = 26.5300693004806*v_R11_a_i - 4.84676915585801*v_R11_a_r - 7.8946133751477*v_R11_b_i - 1.58482814504483*v_R11_b_r - 7.72144347466701*v_R11_c_i - 0.67991845328531*v_R11_c_r - 7.89461337514771*v_R11_n_i - 1.58482814504483*v_R11_n_r + 105.57176931318*v_R2_a_i - 54.0657727682604*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r - 24.9575997948692*v_R2_c_i + 23.284964480954*v_R2_c_r - 39.6392229058202*v_R2_n_i + 10.2713736253513*v_R2_n_r - 237.673607926841*v_R3_a_i + 112.978314692379*v_R3_a_r + 87.173059186788*v_R3_b_i - 18.9579191056578*v_R3_b_r + 57.6366430644055*v_R3_c_i - 45.8900105086227*v_R3_c_r + 87.173059186788*v_R3_n_i - 18.9579191056579*v_R3_n_r + 105.57176931318*v_R4_a_i - 54.0657727682604*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r - 24.9575997948692*v_R4_c_i + 23.284964480954*v_R4_c_r - 39.6392229058202*v_R4_n_i + 10.2713736253513*v_R4_n_r
        struct[0].g[78,0] = 1.58482814504483*v_R11_a_i - 7.89461337514771*v_R11_a_r + 4.84676915585801*v_R11_b_i + 26.5300693004806*v_R11_b_r + 1.58482814504483*v_R11_c_i - 7.89461337514771*v_R11_c_r + 0.679918453285308*v_R11_n_i - 7.72144347466701*v_R11_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r + 54.0657727682604*v_R2_b_i + 105.57176931318*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058201*v_R2_c_r - 23.284964480954*v_R2_n_i - 24.9575997948692*v_R2_n_r + 18.9579191056579*v_R3_a_i + 87.173059186788*v_R3_a_r - 112.978314692379*v_R3_b_i - 237.673607926841*v_R3_b_r + 18.9579191056579*v_R3_c_i + 87.173059186788*v_R3_c_r + 45.8900105086227*v_R3_n_i + 57.6366430644054*v_R3_n_r - 10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r + 54.0657727682604*v_R4_b_i + 105.57176931318*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058201*v_R4_c_r - 23.284964480954*v_R4_n_i - 24.9575997948692*v_R4_n_r
        struct[0].g[79,0] = -7.89461337514771*v_R11_a_i - 1.58482814504483*v_R11_a_r + 26.5300693004806*v_R11_b_i - 4.84676915585801*v_R11_b_r - 7.89461337514771*v_R11_c_i - 1.58482814504483*v_R11_c_r - 7.72144347466701*v_R11_n_i - 0.679918453285308*v_R11_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r + 105.57176931318*v_R2_b_i - 54.0657727682604*v_R2_b_r - 39.6392229058201*v_R2_c_i + 10.2713736253513*v_R2_c_r - 24.9575997948692*v_R2_n_i + 23.284964480954*v_R2_n_r + 87.173059186788*v_R3_a_i - 18.9579191056579*v_R3_a_r - 237.673607926841*v_R3_b_i + 112.978314692379*v_R3_b_r + 87.173059186788*v_R3_c_i - 18.9579191056579*v_R3_c_r + 57.6366430644054*v_R3_n_i - 45.8900105086227*v_R3_n_r - 39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r + 105.57176931318*v_R4_b_i - 54.0657727682604*v_R4_b_r - 39.6392229058201*v_R4_c_i + 10.2713736253513*v_R4_c_r - 24.9575997948692*v_R4_n_i + 23.284964480954*v_R4_n_r
        struct[0].g[80,0] = 0.67991845328531*v_R11_a_i - 7.72144347466701*v_R11_a_r + 1.58482814504483*v_R11_b_i - 7.8946133751477*v_R11_b_r + 4.84676915585801*v_R11_c_i + 26.5300693004806*v_R11_c_r + 1.58482814504483*v_R11_n_i - 7.89461337514771*v_R11_n_r - 23.284964480954*v_R2_a_i - 24.9575997948692*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r + 54.0657727682604*v_R2_c_i + 105.57176931318*v_R2_c_r - 10.2713736253514*v_R2_n_i - 39.6392229058201*v_R2_n_r + 45.8900105086227*v_R3_a_i + 57.6366430644054*v_R3_a_r + 18.9579191056578*v_R3_b_i + 87.1730591867881*v_R3_b_r - 112.978314692379*v_R3_c_i - 237.673607926841*v_R3_c_r + 18.9579191056579*v_R3_n_i + 87.173059186788*v_R3_n_r - 23.284964480954*v_R4_a_i - 24.9575997948692*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r + 54.0657727682604*v_R4_c_i + 105.57176931318*v_R4_c_r - 10.2713736253514*v_R4_n_i - 39.6392229058201*v_R4_n_r
        struct[0].g[81,0] = -7.72144347466701*v_R11_a_i - 0.67991845328531*v_R11_a_r - 7.8946133751477*v_R11_b_i - 1.58482814504483*v_R11_b_r + 26.5300693004806*v_R11_c_i - 4.84676915585801*v_R11_c_r - 7.89461337514771*v_R11_n_i - 1.58482814504483*v_R11_n_r - 24.9575997948692*v_R2_a_i + 23.284964480954*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r + 105.57176931318*v_R2_c_i - 54.0657727682604*v_R2_c_r - 39.6392229058201*v_R2_n_i + 10.2713736253514*v_R2_n_r + 57.6366430644054*v_R3_a_i - 45.8900105086227*v_R3_a_r + 87.1730591867881*v_R3_b_i - 18.9579191056578*v_R3_b_r - 237.673607926841*v_R3_c_i + 112.978314692379*v_R3_c_r + 87.173059186788*v_R3_n_i - 18.9579191056579*v_R3_n_r - 24.9575997948692*v_R4_a_i + 23.284964480954*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r + 105.57176931318*v_R4_c_i - 54.0657727682604*v_R4_c_r - 39.6392229058201*v_R4_n_i + 10.2713736253514*v_R4_n_r
        struct[0].g[82,0] = 1.58482814504483*v_R11_a_i - 7.89461337514771*v_R11_a_r + 0.679918453285308*v_R11_b_i - 7.72144347466701*v_R11_b_r + 1.58482814504483*v_R11_c_i - 7.89461337514771*v_R11_c_r + 4.84676915585801*v_R11_n_i + 26.5300693004806*v_R11_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r - 23.284964480954*v_R2_b_i - 24.9575997948692*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058202*v_R2_c_r + 54.0657727682604*v_R2_n_i + 105.57176931318*v_R2_n_r + 18.9579191056578*v_R3_a_i + 87.173059186788*v_R3_a_r + 45.8900105086227*v_R3_b_i + 57.6366430644054*v_R3_b_r + 18.9579191056579*v_R3_c_i + 87.173059186788*v_R3_c_r - 112.978314692379*v_R3_n_i - 237.673607926841*v_R3_n_r - 10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r - 23.284964480954*v_R4_b_i - 24.9575997948692*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058202*v_R4_c_r + 54.0657727682604*v_R4_n_i + 105.57176931318*v_R4_n_r
        struct[0].g[83,0] = -7.89461337514771*v_R11_a_i - 1.58482814504483*v_R11_a_r - 7.72144347466701*v_R11_b_i - 0.679918453285308*v_R11_b_r - 7.89461337514771*v_R11_c_i - 1.58482814504483*v_R11_c_r + 26.5300693004806*v_R11_n_i - 4.84676915585801*v_R11_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r - 24.9575997948692*v_R2_b_i + 23.284964480954*v_R2_b_r - 39.6392229058202*v_R2_c_i + 10.2713736253513*v_R2_c_r + 105.57176931318*v_R2_n_i - 54.0657727682604*v_R2_n_r + 87.173059186788*v_R3_a_i - 18.9579191056578*v_R3_a_r + 57.6366430644054*v_R3_b_i - 45.8900105086227*v_R3_b_r + 87.173059186788*v_R3_c_i - 18.9579191056579*v_R3_c_r - 237.673607926841*v_R3_n_i + 112.978314692379*v_R3_n_r - 39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r - 24.9575997948692*v_R4_b_i + 23.284964480954*v_R4_b_r - 39.6392229058202*v_R4_c_i + 10.2713736253513*v_R4_c_r + 105.57176931318*v_R4_n_i - 54.0657727682604*v_R4_n_r
        struct[0].g[84,0] = 4.84676915585801*v_R12_a_i + 26.5300693004806*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 0.67991845328531*v_R12_c_i - 7.72144347466701*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r + 54.0657727682604*v_R3_a_i + 105.57176931318*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r - 23.284964480954*v_R3_c_i - 24.9575997948692*v_R3_c_r - 10.2713736253513*v_R3_n_i - 39.6392229058202*v_R3_n_r - 112.978314692379*v_R4_a_i - 237.673607926841*v_R4_a_r + 18.9579191056578*v_R4_b_i + 87.173059186788*v_R4_b_r + 45.8900105086227*v_R4_c_i + 57.6366430644055*v_R4_c_r + 18.9579191056579*v_R4_n_i + 87.173059186788*v_R4_n_r + 54.0657727682604*v_R5_a_i + 105.57176931318*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r - 23.284964480954*v_R5_c_i - 24.9575997948692*v_R5_c_r - 10.2713736253513*v_R5_n_i - 39.6392229058202*v_R5_n_r
        struct[0].g[85,0] = 26.5300693004806*v_R12_a_i - 4.84676915585801*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r - 7.72144347466701*v_R12_c_i - 0.67991845328531*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r + 105.57176931318*v_R3_a_i - 54.0657727682604*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r - 24.9575997948692*v_R3_c_i + 23.284964480954*v_R3_c_r - 39.6392229058202*v_R3_n_i + 10.2713736253513*v_R3_n_r - 237.673607926841*v_R4_a_i + 112.978314692379*v_R4_a_r + 87.173059186788*v_R4_b_i - 18.9579191056578*v_R4_b_r + 57.6366430644055*v_R4_c_i - 45.8900105086227*v_R4_c_r + 87.173059186788*v_R4_n_i - 18.9579191056579*v_R4_n_r + 105.57176931318*v_R5_a_i - 54.0657727682604*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r - 24.9575997948692*v_R5_c_i + 23.284964480954*v_R5_c_r - 39.6392229058202*v_R5_n_i + 10.2713736253513*v_R5_n_r
        struct[0].g[86,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 4.84676915585801*v_R12_b_i + 26.5300693004806*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 0.679918453285308*v_R12_n_i - 7.72144347466701*v_R12_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r + 54.0657727682604*v_R3_b_i + 105.57176931318*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058201*v_R3_c_r - 23.284964480954*v_R3_n_i - 24.9575997948692*v_R3_n_r + 18.9579191056579*v_R4_a_i + 87.173059186788*v_R4_a_r - 112.978314692379*v_R4_b_i - 237.673607926841*v_R4_b_r + 18.9579191056579*v_R4_c_i + 87.173059186788*v_R4_c_r + 45.8900105086227*v_R4_n_i + 57.6366430644054*v_R4_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r + 54.0657727682604*v_R5_b_i + 105.57176931318*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058201*v_R5_c_r - 23.284964480954*v_R5_n_i - 24.9575997948692*v_R5_n_r
        struct[0].g[87,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r + 26.5300693004806*v_R12_b_i - 4.84676915585801*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r - 7.72144347466701*v_R12_n_i - 0.679918453285308*v_R12_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r + 105.57176931318*v_R3_b_i - 54.0657727682604*v_R3_b_r - 39.6392229058201*v_R3_c_i + 10.2713736253513*v_R3_c_r - 24.9575997948692*v_R3_n_i + 23.284964480954*v_R3_n_r + 87.173059186788*v_R4_a_i - 18.9579191056579*v_R4_a_r - 237.673607926841*v_R4_b_i + 112.978314692379*v_R4_b_r + 87.173059186788*v_R4_c_i - 18.9579191056579*v_R4_c_r + 57.6366430644054*v_R4_n_i - 45.8900105086227*v_R4_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r + 105.57176931318*v_R5_b_i - 54.0657727682604*v_R5_b_r - 39.6392229058201*v_R5_c_i + 10.2713736253513*v_R5_c_r - 24.9575997948692*v_R5_n_i + 23.284964480954*v_R5_n_r
        struct[0].g[88,0] = 0.67991845328531*v_R12_a_i - 7.72144347466701*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 4.84676915585801*v_R12_c_i + 26.5300693004806*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 23.284964480954*v_R3_a_i - 24.9575997948692*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r + 54.0657727682604*v_R3_c_i + 105.57176931318*v_R3_c_r - 10.2713736253514*v_R3_n_i - 39.6392229058201*v_R3_n_r + 45.8900105086227*v_R4_a_i + 57.6366430644054*v_R4_a_r + 18.9579191056578*v_R4_b_i + 87.1730591867881*v_R4_b_r - 112.978314692379*v_R4_c_i - 237.673607926841*v_R4_c_r + 18.9579191056579*v_R4_n_i + 87.173059186788*v_R4_n_r - 23.284964480954*v_R5_a_i - 24.9575997948692*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r + 54.0657727682604*v_R5_c_i + 105.57176931318*v_R5_c_r - 10.2713736253514*v_R5_n_i - 39.6392229058201*v_R5_n_r
        struct[0].g[89,0] = -7.72144347466701*v_R12_a_i - 0.67991845328531*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r + 26.5300693004806*v_R12_c_i - 4.84676915585801*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r - 24.9575997948692*v_R3_a_i + 23.284964480954*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r + 105.57176931318*v_R3_c_i - 54.0657727682604*v_R3_c_r - 39.6392229058201*v_R3_n_i + 10.2713736253514*v_R3_n_r + 57.6366430644054*v_R4_a_i - 45.8900105086227*v_R4_a_r + 87.1730591867881*v_R4_b_i - 18.9579191056578*v_R4_b_r - 237.673607926841*v_R4_c_i + 112.978314692379*v_R4_c_r + 87.173059186788*v_R4_n_i - 18.9579191056579*v_R4_n_r - 24.9575997948692*v_R5_a_i + 23.284964480954*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r + 105.57176931318*v_R5_c_i - 54.0657727682604*v_R5_c_r - 39.6392229058201*v_R5_n_i + 10.2713736253514*v_R5_n_r
        struct[0].g[90,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 0.679918453285308*v_R12_b_i - 7.72144347466701*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 4.84676915585801*v_R12_n_i + 26.5300693004806*v_R12_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r - 23.284964480954*v_R3_b_i - 24.9575997948692*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058202*v_R3_c_r + 54.0657727682604*v_R3_n_i + 105.57176931318*v_R3_n_r + 18.9579191056578*v_R4_a_i + 87.173059186788*v_R4_a_r + 45.8900105086227*v_R4_b_i + 57.6366430644054*v_R4_b_r + 18.9579191056579*v_R4_c_i + 87.173059186788*v_R4_c_r - 112.978314692379*v_R4_n_i - 237.698607926841*v_R4_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r - 23.284964480954*v_R5_b_i - 24.9575997948692*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058202*v_R5_c_r + 54.0657727682604*v_R5_n_i + 105.57176931318*v_R5_n_r
        struct[0].g[91,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r - 7.72144347466701*v_R12_b_i - 0.679918453285308*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r + 26.5300693004806*v_R12_n_i - 4.84676915585801*v_R12_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r - 24.9575997948692*v_R3_b_i + 23.284964480954*v_R3_b_r - 39.6392229058202*v_R3_c_i + 10.2713736253513*v_R3_c_r + 105.57176931318*v_R3_n_i - 54.0657727682604*v_R3_n_r + 87.173059186788*v_R4_a_i - 18.9579191056578*v_R4_a_r + 57.6366430644054*v_R4_b_i - 45.8900105086227*v_R4_b_r + 87.173059186788*v_R4_c_i - 18.9579191056579*v_R4_c_r - 237.698607926841*v_R4_n_i + 112.978314692379*v_R4_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r - 24.9575997948692*v_R5_b_i + 23.284964480954*v_R5_b_r - 39.6392229058202*v_R5_c_i + 10.2713736253513*v_R5_c_r + 105.57176931318*v_R5_n_i - 54.0657727682604*v_R5_n_r
        struct[0].g[92,0] = 54.0657727682604*v_R4_a_i + 105.57176931318*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r - 23.284964480954*v_R4_c_i - 24.9575997948692*v_R4_c_r - 10.2713736253513*v_R4_n_i - 39.6392229058202*v_R4_n_r - 108.131545536521*v_R5_a_i - 211.14353862636*v_R5_a_r + 20.5427472507027*v_R5_b_i + 79.2784458116403*v_R5_b_r + 46.569928961908*v_R5_c_i + 49.9151995897384*v_R5_c_r + 20.5427472507027*v_R5_n_i + 79.2784458116403*v_R5_n_r + 54.0657727682604*v_R6_a_i + 105.57176931318*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r - 23.284964480954*v_R6_c_i - 24.9575997948692*v_R6_c_r - 10.2713736253513*v_R6_n_i - 39.6392229058202*v_R6_n_r
        struct[0].g[93,0] = 105.57176931318*v_R4_a_i - 54.0657727682604*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r - 24.9575997948692*v_R4_c_i + 23.284964480954*v_R4_c_r - 39.6392229058202*v_R4_n_i + 10.2713736253513*v_R4_n_r - 211.14353862636*v_R5_a_i + 108.131545536521*v_R5_a_r + 79.2784458116403*v_R5_b_i - 20.5427472507027*v_R5_b_r + 49.9151995897384*v_R5_c_i - 46.569928961908*v_R5_c_r + 79.2784458116403*v_R5_n_i - 20.5427472507027*v_R5_n_r + 105.57176931318*v_R6_a_i - 54.0657727682604*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r - 24.9575997948692*v_R6_c_i + 23.284964480954*v_R6_c_r - 39.6392229058202*v_R6_n_i + 10.2713736253513*v_R6_n_r
        struct[0].g[94,0] = -10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r + 54.0657727682604*v_R4_b_i + 105.57176931318*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058201*v_R4_c_r - 23.284964480954*v_R4_n_i - 24.9575997948692*v_R4_n_r + 20.5427472507027*v_R5_a_i + 79.2784458116403*v_R5_a_r - 108.131545536521*v_R5_b_i - 211.14353862636*v_R5_b_r + 20.5427472507027*v_R5_c_i + 79.2784458116403*v_R5_c_r + 46.569928961908*v_R5_n_i + 49.9151995897384*v_R5_n_r - 10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r + 54.0657727682604*v_R6_b_i + 105.57176931318*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058201*v_R6_c_r - 23.284964480954*v_R6_n_i - 24.9575997948692*v_R6_n_r
        struct[0].g[95,0] = -39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r + 105.57176931318*v_R4_b_i - 54.0657727682604*v_R4_b_r - 39.6392229058201*v_R4_c_i + 10.2713736253513*v_R4_c_r - 24.9575997948692*v_R4_n_i + 23.284964480954*v_R4_n_r + 79.2784458116403*v_R5_a_i - 20.5427472507027*v_R5_a_r - 211.14353862636*v_R5_b_i + 108.131545536521*v_R5_b_r + 79.2784458116403*v_R5_c_i - 20.5427472507027*v_R5_c_r + 49.9151995897384*v_R5_n_i - 46.569928961908*v_R5_n_r - 39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r + 105.57176931318*v_R6_b_i - 54.0657727682604*v_R6_b_r - 39.6392229058201*v_R6_c_i + 10.2713736253513*v_R6_c_r - 24.9575997948692*v_R6_n_i + 23.284964480954*v_R6_n_r
        struct[0].g[96,0] = -23.284964480954*v_R4_a_i - 24.9575997948692*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r + 54.0657727682604*v_R4_c_i + 105.57176931318*v_R4_c_r - 10.2713736253514*v_R4_n_i - 39.6392229058201*v_R4_n_r + 46.569928961908*v_R5_a_i + 49.9151995897384*v_R5_a_r + 20.5427472507027*v_R5_b_i + 79.2784458116404*v_R5_b_r - 108.131545536521*v_R5_c_i - 211.14353862636*v_R5_c_r + 20.5427472507027*v_R5_n_i + 79.2784458116403*v_R5_n_r - 23.284964480954*v_R6_a_i - 24.9575997948692*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r + 54.0657727682604*v_R6_c_i + 105.57176931318*v_R6_c_r - 10.2713736253514*v_R6_n_i - 39.6392229058201*v_R6_n_r
        struct[0].g[97,0] = -24.9575997948692*v_R4_a_i + 23.284964480954*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r + 105.57176931318*v_R4_c_i - 54.0657727682604*v_R4_c_r - 39.6392229058201*v_R4_n_i + 10.2713736253514*v_R4_n_r + 49.9151995897384*v_R5_a_i - 46.569928961908*v_R5_a_r + 79.2784458116404*v_R5_b_i - 20.5427472507027*v_R5_b_r - 211.14353862636*v_R5_c_i + 108.131545536521*v_R5_c_r + 79.2784458116403*v_R5_n_i - 20.5427472507027*v_R5_n_r - 24.9575997948692*v_R6_a_i + 23.284964480954*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r + 105.57176931318*v_R6_c_i - 54.0657727682604*v_R6_c_r - 39.6392229058201*v_R6_n_i + 10.2713736253514*v_R6_n_r
        struct[0].g[98,0] = -10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r - 23.284964480954*v_R4_b_i - 24.9575997948692*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058202*v_R4_c_r + 54.0657727682604*v_R4_n_i + 105.57176931318*v_R4_n_r + 20.5427472507027*v_R5_a_i + 79.2784458116403*v_R5_a_r + 46.569928961908*v_R5_b_i + 49.9151995897384*v_R5_b_r + 20.5427472507027*v_R5_c_i + 79.2784458116403*v_R5_c_r - 108.131545536521*v_R5_n_i - 211.14353862636*v_R5_n_r - 10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r - 23.284964480954*v_R6_b_i - 24.9575997948692*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058202*v_R6_c_r + 54.0657727682604*v_R6_n_i + 105.57176931318*v_R6_n_r
        struct[0].g[99,0] = -39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r - 24.9575997948692*v_R4_b_i + 23.284964480954*v_R4_b_r - 39.6392229058202*v_R4_c_i + 10.2713736253513*v_R4_c_r + 105.57176931318*v_R4_n_i - 54.0657727682604*v_R4_n_r + 79.2784458116403*v_R5_a_i - 20.5427472507027*v_R5_a_r + 49.9151995897384*v_R5_b_i - 46.569928961908*v_R5_b_r + 79.2784458116403*v_R5_c_i - 20.5427472507027*v_R5_c_r - 211.14353862636*v_R5_n_i + 108.131545536521*v_R5_n_r - 39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r - 24.9575997948692*v_R6_b_i + 23.284964480954*v_R6_b_r - 39.6392229058202*v_R6_c_i + 10.2713736253513*v_R6_c_r + 105.57176931318*v_R6_n_i - 54.0657727682604*v_R6_n_r
        struct[0].g[100,0] = 5.65456401516768*v_R16_a_i + 30.9517475172273*v_R16_a_r + 1.84896616921897*v_R16_b_i - 9.21038227100566*v_R16_b_r + 0.793238195499529*v_R16_c_i - 9.00835072044485*v_R16_c_r + 1.84896616921897*v_R16_n_i - 9.21038227100566*v_R16_n_r + 54.0657727682604*v_R5_a_i + 105.57176931318*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r - 23.284964480954*v_R5_c_i - 24.9575997948692*v_R5_c_r - 10.2713736253513*v_R5_n_i - 39.6392229058202*v_R5_n_r - 113.786109551688*v_R6_a_i - 242.095286143588*v_R6_a_r + 18.6937810814837*v_R6_b_i + 88.488828082646*v_R6_b_r + 45.7766907664085*v_R6_c_i + 58.9235503101833*v_R6_c_r + 18.6937810814837*v_R6_n_i + 88.488828082646*v_R6_n_r + 54.0657727682604*v_R7_a_i + 105.57176931318*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r - 23.284964480954*v_R7_c_i - 24.9575997948692*v_R7_c_r - 10.2713736253513*v_R7_n_i - 39.6392229058202*v_R7_n_r
        struct[0].g[101,0] = 30.9517475172273*v_R16_a_i - 5.65456401516768*v_R16_a_r - 9.21038227100566*v_R16_b_i - 1.84896616921897*v_R16_b_r - 9.00835072044485*v_R16_c_i - 0.793238195499529*v_R16_c_r - 9.21038227100566*v_R16_n_i - 1.84896616921897*v_R16_n_r + 105.57176931318*v_R5_a_i - 54.0657727682604*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r - 24.9575997948692*v_R5_c_i + 23.284964480954*v_R5_c_r - 39.6392229058202*v_R5_n_i + 10.2713736253513*v_R5_n_r - 242.095286143588*v_R6_a_i + 113.786109551688*v_R6_a_r + 88.488828082646*v_R6_b_i - 18.6937810814837*v_R6_b_r + 58.9235503101833*v_R6_c_i - 45.7766907664085*v_R6_c_r + 88.488828082646*v_R6_n_i - 18.6937810814837*v_R6_n_r + 105.57176931318*v_R7_a_i - 54.0657727682604*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r - 24.9575997948692*v_R7_c_i + 23.284964480954*v_R7_c_r - 39.6392229058202*v_R7_n_i + 10.2713736253513*v_R7_n_r
        struct[0].g[102,0] = 1.84896616921897*v_R16_a_i - 9.21038227100566*v_R16_a_r + 5.65456401516768*v_R16_b_i + 30.9517475172273*v_R16_b_r + 1.84896616921897*v_R16_c_i - 9.21038227100566*v_R16_c_r + 0.793238195499528*v_R16_n_i - 9.00835072044485*v_R16_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r + 54.0657727682604*v_R5_b_i + 105.57176931318*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058201*v_R5_c_r - 23.284964480954*v_R5_n_i - 24.9575997948692*v_R5_n_r + 18.6937810814837*v_R6_a_i + 88.488828082646*v_R6_a_r - 113.786109551688*v_R6_b_i - 242.095286143588*v_R6_b_r + 18.6937810814837*v_R6_c_i + 88.488828082646*v_R6_c_r + 45.7766907664085*v_R6_n_i + 58.9235503101833*v_R6_n_r - 10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r + 54.0657727682604*v_R7_b_i + 105.57176931318*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058201*v_R7_c_r - 23.284964480954*v_R7_n_i - 24.9575997948692*v_R7_n_r
        struct[0].g[103,0] = -9.21038227100566*v_R16_a_i - 1.84896616921897*v_R16_a_r + 30.9517475172273*v_R16_b_i - 5.65456401516768*v_R16_b_r - 9.21038227100566*v_R16_c_i - 1.84896616921897*v_R16_c_r - 9.00835072044485*v_R16_n_i - 0.793238195499528*v_R16_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r + 105.57176931318*v_R5_b_i - 54.0657727682604*v_R5_b_r - 39.6392229058201*v_R5_c_i + 10.2713736253513*v_R5_c_r - 24.9575997948692*v_R5_n_i + 23.284964480954*v_R5_n_r + 88.488828082646*v_R6_a_i - 18.6937810814837*v_R6_a_r - 242.095286143588*v_R6_b_i + 113.786109551688*v_R6_b_r + 88.488828082646*v_R6_c_i - 18.6937810814837*v_R6_c_r + 58.9235503101833*v_R6_n_i - 45.7766907664085*v_R6_n_r - 39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r + 105.57176931318*v_R7_b_i - 54.0657727682604*v_R7_b_r - 39.6392229058201*v_R7_c_i + 10.2713736253513*v_R7_c_r - 24.9575997948692*v_R7_n_i + 23.284964480954*v_R7_n_r
        struct[0].g[104,0] = 0.793238195499527*v_R16_a_i - 9.00835072044484*v_R16_a_r + 1.84896616921897*v_R16_b_i - 9.21038227100566*v_R16_b_r + 5.65456401516768*v_R16_c_i + 30.9517475172273*v_R16_c_r + 1.84896616921897*v_R16_n_i - 9.21038227100566*v_R16_n_r - 23.284964480954*v_R5_a_i - 24.9575997948692*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r + 54.0657727682604*v_R5_c_i + 105.57176931318*v_R5_c_r - 10.2713736253514*v_R5_n_i - 39.6392229058201*v_R5_n_r + 45.7766907664085*v_R6_a_i + 58.9235503101833*v_R6_a_r + 18.6937810814837*v_R6_b_i + 88.4888280826461*v_R6_b_r - 113.786109551688*v_R6_c_i - 242.095286143588*v_R6_c_r + 18.6937810814837*v_R6_n_i + 88.4888280826459*v_R6_n_r - 23.284964480954*v_R7_a_i - 24.9575997948692*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r + 54.0657727682604*v_R7_c_i + 105.57176931318*v_R7_c_r - 10.2713736253514*v_R7_n_i - 39.6392229058201*v_R7_n_r
        struct[0].g[105,0] = -9.00835072044484*v_R16_a_i - 0.793238195499527*v_R16_a_r - 9.21038227100566*v_R16_b_i - 1.84896616921897*v_R16_b_r + 30.9517475172273*v_R16_c_i - 5.65456401516768*v_R16_c_r - 9.21038227100566*v_R16_n_i - 1.84896616921897*v_R16_n_r - 24.9575997948692*v_R5_a_i + 23.284964480954*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r + 105.57176931318*v_R5_c_i - 54.0657727682604*v_R5_c_r - 39.6392229058201*v_R5_n_i + 10.2713736253514*v_R5_n_r + 58.9235503101833*v_R6_a_i - 45.7766907664085*v_R6_a_r + 88.4888280826461*v_R6_b_i - 18.6937810814837*v_R6_b_r - 242.095286143588*v_R6_c_i + 113.786109551688*v_R6_c_r + 88.4888280826459*v_R6_n_i - 18.6937810814837*v_R6_n_r - 24.9575997948692*v_R7_a_i + 23.284964480954*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r + 105.57176931318*v_R7_c_i - 54.0657727682604*v_R7_c_r - 39.6392229058201*v_R7_n_i + 10.2713736253514*v_R7_n_r
        struct[0].g[106,0] = 1.84896616921897*v_R16_a_i - 9.21038227100566*v_R16_a_r + 0.793238195499527*v_R16_b_i - 9.00835072044485*v_R16_b_r + 1.84896616921897*v_R16_c_i - 9.21038227100566*v_R16_c_r + 5.65456401516768*v_R16_n_i + 30.9517475172273*v_R16_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r - 23.284964480954*v_R5_b_i - 24.9575997948692*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058202*v_R5_c_r + 54.0657727682604*v_R5_n_i + 105.57176931318*v_R5_n_r + 18.6937810814837*v_R6_a_i + 88.488828082646*v_R6_a_r + 45.7766907664085*v_R6_b_i + 58.9235503101832*v_R6_b_r + 18.6937810814837*v_R6_c_i + 88.488828082646*v_R6_c_r - 113.786109551688*v_R6_n_i - 242.120286143588*v_R6_n_r - 10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r - 23.284964480954*v_R7_b_i - 24.9575997948692*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058202*v_R7_c_r + 54.0657727682604*v_R7_n_i + 105.57176931318*v_R7_n_r
        struct[0].g[107,0] = -9.21038227100566*v_R16_a_i - 1.84896616921897*v_R16_a_r - 9.00835072044485*v_R16_b_i - 0.793238195499527*v_R16_b_r - 9.21038227100566*v_R16_c_i - 1.84896616921897*v_R16_c_r + 30.9517475172273*v_R16_n_i - 5.65456401516768*v_R16_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r - 24.9575997948692*v_R5_b_i + 23.284964480954*v_R5_b_r - 39.6392229058202*v_R5_c_i + 10.2713736253513*v_R5_c_r + 105.57176931318*v_R5_n_i - 54.0657727682604*v_R5_n_r + 88.488828082646*v_R6_a_i - 18.6937810814837*v_R6_a_r + 58.9235503101832*v_R6_b_i - 45.7766907664085*v_R6_b_r + 88.488828082646*v_R6_c_i - 18.6937810814837*v_R6_c_r - 242.120286143588*v_R6_n_i + 113.786109551688*v_R6_n_r - 39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r - 24.9575997948692*v_R7_b_i + 23.284964480954*v_R7_b_r - 39.6392229058202*v_R7_c_i + 10.2713736253513*v_R7_c_r + 105.57176931318*v_R7_n_i - 54.0657727682604*v_R7_n_r
        struct[0].g[108,0] = 54.0657727682604*v_R6_a_i + 105.57176931318*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r - 23.284964480954*v_R6_c_i - 24.9575997948692*v_R6_c_r - 10.2713736253513*v_R6_n_i - 39.6392229058202*v_R6_n_r - 108.131545536521*v_R7_a_i - 211.14353862636*v_R7_a_r + 20.5427472507027*v_R7_b_i + 79.2784458116403*v_R7_b_r + 46.569928961908*v_R7_c_i + 49.9151995897384*v_R7_c_r + 20.5427472507027*v_R7_n_i + 79.2784458116403*v_R7_n_r + 54.0657727682604*v_R8_a_i + 105.57176931318*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r - 23.284964480954*v_R8_c_i - 24.9575997948692*v_R8_c_r - 10.2713736253513*v_R8_n_i - 39.6392229058202*v_R8_n_r
        struct[0].g[109,0] = 105.57176931318*v_R6_a_i - 54.0657727682604*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r - 24.9575997948692*v_R6_c_i + 23.284964480954*v_R6_c_r - 39.6392229058202*v_R6_n_i + 10.2713736253513*v_R6_n_r - 211.14353862636*v_R7_a_i + 108.131545536521*v_R7_a_r + 79.2784458116403*v_R7_b_i - 20.5427472507027*v_R7_b_r + 49.9151995897384*v_R7_c_i - 46.569928961908*v_R7_c_r + 79.2784458116403*v_R7_n_i - 20.5427472507027*v_R7_n_r + 105.57176931318*v_R8_a_i - 54.0657727682604*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r - 24.9575997948692*v_R8_c_i + 23.284964480954*v_R8_c_r - 39.6392229058202*v_R8_n_i + 10.2713736253513*v_R8_n_r
        struct[0].g[110,0] = -10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r + 54.0657727682604*v_R6_b_i + 105.57176931318*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058201*v_R6_c_r - 23.284964480954*v_R6_n_i - 24.9575997948692*v_R6_n_r + 20.5427472507027*v_R7_a_i + 79.2784458116403*v_R7_a_r - 108.131545536521*v_R7_b_i - 211.14353862636*v_R7_b_r + 20.5427472507027*v_R7_c_i + 79.2784458116403*v_R7_c_r + 46.569928961908*v_R7_n_i + 49.9151995897384*v_R7_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r + 54.0657727682604*v_R8_b_i + 105.57176931318*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058201*v_R8_c_r - 23.284964480954*v_R8_n_i - 24.9575997948692*v_R8_n_r
        struct[0].g[111,0] = -39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r + 105.57176931318*v_R6_b_i - 54.0657727682604*v_R6_b_r - 39.6392229058201*v_R6_c_i + 10.2713736253513*v_R6_c_r - 24.9575997948692*v_R6_n_i + 23.284964480954*v_R6_n_r + 79.2784458116403*v_R7_a_i - 20.5427472507027*v_R7_a_r - 211.14353862636*v_R7_b_i + 108.131545536521*v_R7_b_r + 79.2784458116403*v_R7_c_i - 20.5427472507027*v_R7_c_r + 49.9151995897384*v_R7_n_i - 46.569928961908*v_R7_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r + 105.57176931318*v_R8_b_i - 54.0657727682604*v_R8_b_r - 39.6392229058201*v_R8_c_i + 10.2713736253513*v_R8_c_r - 24.9575997948692*v_R8_n_i + 23.284964480954*v_R8_n_r
        struct[0].g[112,0] = -23.284964480954*v_R6_a_i - 24.9575997948692*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r + 54.0657727682604*v_R6_c_i + 105.57176931318*v_R6_c_r - 10.2713736253514*v_R6_n_i - 39.6392229058201*v_R6_n_r + 46.569928961908*v_R7_a_i + 49.9151995897384*v_R7_a_r + 20.5427472507027*v_R7_b_i + 79.2784458116404*v_R7_b_r - 108.131545536521*v_R7_c_i - 211.14353862636*v_R7_c_r + 20.5427472507027*v_R7_n_i + 79.2784458116403*v_R7_n_r - 23.284964480954*v_R8_a_i - 24.9575997948692*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r + 54.0657727682604*v_R8_c_i + 105.57176931318*v_R8_c_r - 10.2713736253514*v_R8_n_i - 39.6392229058201*v_R8_n_r
        struct[0].g[113,0] = -24.9575997948692*v_R6_a_i + 23.284964480954*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r + 105.57176931318*v_R6_c_i - 54.0657727682604*v_R6_c_r - 39.6392229058201*v_R6_n_i + 10.2713736253514*v_R6_n_r + 49.9151995897384*v_R7_a_i - 46.569928961908*v_R7_a_r + 79.2784458116404*v_R7_b_i - 20.5427472507027*v_R7_b_r - 211.14353862636*v_R7_c_i + 108.131545536521*v_R7_c_r + 79.2784458116403*v_R7_n_i - 20.5427472507027*v_R7_n_r - 24.9575997948692*v_R8_a_i + 23.284964480954*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r + 105.57176931318*v_R8_c_i - 54.0657727682604*v_R8_c_r - 39.6392229058201*v_R8_n_i + 10.2713736253514*v_R8_n_r
        struct[0].g[114,0] = -10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r - 23.284964480954*v_R6_b_i - 24.9575997948692*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058202*v_R6_c_r + 54.0657727682604*v_R6_n_i + 105.57176931318*v_R6_n_r + 20.5427472507027*v_R7_a_i + 79.2784458116403*v_R7_a_r + 46.569928961908*v_R7_b_i + 49.9151995897384*v_R7_b_r + 20.5427472507027*v_R7_c_i + 79.2784458116403*v_R7_c_r - 108.131545536521*v_R7_n_i - 211.14353862636*v_R7_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r - 23.284964480954*v_R8_b_i - 24.9575997948692*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058202*v_R8_c_r + 54.0657727682604*v_R8_n_i + 105.57176931318*v_R8_n_r
        struct[0].g[115,0] = -39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r - 24.9575997948692*v_R6_b_i + 23.284964480954*v_R6_b_r - 39.6392229058202*v_R6_c_i + 10.2713736253513*v_R6_c_r + 105.57176931318*v_R6_n_i - 54.0657727682604*v_R6_n_r + 79.2784458116403*v_R7_a_i - 20.5427472507027*v_R7_a_r + 49.9151995897384*v_R7_b_i - 46.569928961908*v_R7_b_r + 79.2784458116403*v_R7_c_i - 20.5427472507027*v_R7_c_r - 211.14353862636*v_R7_n_i + 108.131545536521*v_R7_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r - 24.9575997948692*v_R8_b_i + 23.284964480954*v_R8_b_r - 39.6392229058202*v_R8_c_i + 10.2713736253513*v_R8_c_r + 105.57176931318*v_R8_n_i - 54.0657727682604*v_R8_n_r
        struct[0].g[116,0] = 54.0657727682604*v_R7_a_i + 105.57176931318*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r - 23.284964480954*v_R7_c_i - 24.9575997948692*v_R7_c_r - 10.2713736253513*v_R7_n_i - 39.6392229058202*v_R7_n_r - 108.131545536521*v_R8_a_i - 211.14353862636*v_R8_a_r + 20.5427472507027*v_R8_b_i + 79.2784458116403*v_R8_b_r + 46.569928961908*v_R8_c_i + 49.9151995897384*v_R8_c_r + 20.5427472507027*v_R8_n_i + 79.2784458116403*v_R8_n_r + 54.0657727682604*v_R9_a_i + 105.57176931318*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r - 23.284964480954*v_R9_c_i - 24.9575997948692*v_R9_c_r - 10.2713736253513*v_R9_n_i - 39.6392229058202*v_R9_n_r
        struct[0].g[117,0] = 105.57176931318*v_R7_a_i - 54.0657727682604*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r - 24.9575997948692*v_R7_c_i + 23.284964480954*v_R7_c_r - 39.6392229058202*v_R7_n_i + 10.2713736253513*v_R7_n_r - 211.14353862636*v_R8_a_i + 108.131545536521*v_R8_a_r + 79.2784458116403*v_R8_b_i - 20.5427472507027*v_R8_b_r + 49.9151995897384*v_R8_c_i - 46.569928961908*v_R8_c_r + 79.2784458116403*v_R8_n_i - 20.5427472507027*v_R8_n_r + 105.57176931318*v_R9_a_i - 54.0657727682604*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r - 24.9575997948692*v_R9_c_i + 23.284964480954*v_R9_c_r - 39.6392229058202*v_R9_n_i + 10.2713736253513*v_R9_n_r
        struct[0].g[118,0] = -10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r + 54.0657727682604*v_R7_b_i + 105.57176931318*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058201*v_R7_c_r - 23.284964480954*v_R7_n_i - 24.9575997948692*v_R7_n_r + 20.5427472507027*v_R8_a_i + 79.2784458116403*v_R8_a_r - 108.131545536521*v_R8_b_i - 211.14353862636*v_R8_b_r + 20.5427472507027*v_R8_c_i + 79.2784458116403*v_R8_c_r + 46.569928961908*v_R8_n_i + 49.9151995897384*v_R8_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r + 54.0657727682604*v_R9_b_i + 105.57176931318*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058201*v_R9_c_r - 23.284964480954*v_R9_n_i - 24.9575997948692*v_R9_n_r
        struct[0].g[119,0] = -39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r + 105.57176931318*v_R7_b_i - 54.0657727682604*v_R7_b_r - 39.6392229058201*v_R7_c_i + 10.2713736253513*v_R7_c_r - 24.9575997948692*v_R7_n_i + 23.284964480954*v_R7_n_r + 79.2784458116403*v_R8_a_i - 20.5427472507027*v_R8_a_r - 211.14353862636*v_R8_b_i + 108.131545536521*v_R8_b_r + 79.2784458116403*v_R8_c_i - 20.5427472507027*v_R8_c_r + 49.9151995897384*v_R8_n_i - 46.569928961908*v_R8_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r + 105.57176931318*v_R9_b_i - 54.0657727682604*v_R9_b_r - 39.6392229058201*v_R9_c_i + 10.2713736253513*v_R9_c_r - 24.9575997948692*v_R9_n_i + 23.284964480954*v_R9_n_r
        struct[0].g[120,0] = -23.284964480954*v_R7_a_i - 24.9575997948692*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r + 54.0657727682604*v_R7_c_i + 105.57176931318*v_R7_c_r - 10.2713736253514*v_R7_n_i - 39.6392229058201*v_R7_n_r + 46.569928961908*v_R8_a_i + 49.9151995897384*v_R8_a_r + 20.5427472507027*v_R8_b_i + 79.2784458116404*v_R8_b_r - 108.131545536521*v_R8_c_i - 211.14353862636*v_R8_c_r + 20.5427472507027*v_R8_n_i + 79.2784458116403*v_R8_n_r - 23.284964480954*v_R9_a_i - 24.9575997948692*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r + 54.0657727682604*v_R9_c_i + 105.57176931318*v_R9_c_r - 10.2713736253514*v_R9_n_i - 39.6392229058201*v_R9_n_r
        struct[0].g[121,0] = -24.9575997948692*v_R7_a_i + 23.284964480954*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r + 105.57176931318*v_R7_c_i - 54.0657727682604*v_R7_c_r - 39.6392229058201*v_R7_n_i + 10.2713736253514*v_R7_n_r + 49.9151995897384*v_R8_a_i - 46.569928961908*v_R8_a_r + 79.2784458116404*v_R8_b_i - 20.5427472507027*v_R8_b_r - 211.14353862636*v_R8_c_i + 108.131545536521*v_R8_c_r + 79.2784458116403*v_R8_n_i - 20.5427472507027*v_R8_n_r - 24.9575997948692*v_R9_a_i + 23.284964480954*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r + 105.57176931318*v_R9_c_i - 54.0657727682604*v_R9_c_r - 39.6392229058201*v_R9_n_i + 10.2713736253514*v_R9_n_r
        struct[0].g[122,0] = -10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r - 23.284964480954*v_R7_b_i - 24.9575997948692*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058202*v_R7_c_r + 54.0657727682604*v_R7_n_i + 105.57176931318*v_R7_n_r + 20.5427472507027*v_R8_a_i + 79.2784458116403*v_R8_a_r + 46.569928961908*v_R8_b_i + 49.9151995897384*v_R8_b_r + 20.5427472507027*v_R8_c_i + 79.2784458116403*v_R8_c_r - 108.131545536521*v_R8_n_i - 211.16853862636*v_R8_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r - 23.284964480954*v_R9_b_i - 24.9575997948692*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058202*v_R9_c_r + 54.0657727682604*v_R9_n_i + 105.57176931318*v_R9_n_r
        struct[0].g[123,0] = -39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r - 24.9575997948692*v_R7_b_i + 23.284964480954*v_R7_b_r - 39.6392229058202*v_R7_c_i + 10.2713736253513*v_R7_c_r + 105.57176931318*v_R7_n_i - 54.0657727682604*v_R7_n_r + 79.2784458116403*v_R8_a_i - 20.5427472507027*v_R8_a_r + 49.9151995897384*v_R8_b_i - 46.569928961908*v_R8_b_r + 79.2784458116403*v_R8_c_i - 20.5427472507027*v_R8_c_r - 211.16853862636*v_R8_n_i + 108.131545536521*v_R8_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r - 24.9575997948692*v_R9_b_i + 23.284964480954*v_R9_b_r - 39.6392229058202*v_R9_c_i + 10.2713736253513*v_R9_c_r + 105.57176931318*v_R9_n_i - 54.0657727682604*v_R9_n_r
        struct[0].g[124,0] = 54.0657727682604*v_R10_a_i + 105.57176931318*v_R10_a_r - 10.2713736253513*v_R10_b_i - 39.6392229058202*v_R10_b_r - 23.284964480954*v_R10_c_i - 24.9575997948692*v_R10_c_r - 10.2713736253513*v_R10_n_i - 39.6392229058202*v_R10_n_r + 5.65456401516768*v_R17_a_i + 30.9517475172273*v_R17_a_r + 1.84896616921897*v_R17_b_i - 9.21038227100566*v_R17_b_r + 0.793238195499529*v_R17_c_i - 9.00835072044485*v_R17_c_r + 1.84896616921897*v_R17_n_i - 9.21038227100566*v_R17_n_r + 54.0657727682604*v_R8_a_i + 105.57176931318*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r - 23.284964480954*v_R8_c_i - 24.9575997948692*v_R8_c_r - 10.2713736253513*v_R8_n_i - 39.6392229058202*v_R8_n_r - 113.786109551688*v_R9_a_i - 242.095286143588*v_R9_a_r + 18.6937810814837*v_R9_b_i + 88.488828082646*v_R9_b_r + 45.7766907664085*v_R9_c_i + 58.9235503101833*v_R9_c_r + 18.6937810814837*v_R9_n_i + 88.488828082646*v_R9_n_r
        struct[0].g[125,0] = 105.57176931318*v_R10_a_i - 54.0657727682604*v_R10_a_r - 39.6392229058202*v_R10_b_i + 10.2713736253513*v_R10_b_r - 24.9575997948692*v_R10_c_i + 23.284964480954*v_R10_c_r - 39.6392229058202*v_R10_n_i + 10.2713736253513*v_R10_n_r + 30.9517475172273*v_R17_a_i - 5.65456401516768*v_R17_a_r - 9.21038227100566*v_R17_b_i - 1.84896616921897*v_R17_b_r - 9.00835072044485*v_R17_c_i - 0.793238195499529*v_R17_c_r - 9.21038227100566*v_R17_n_i - 1.84896616921897*v_R17_n_r + 105.57176931318*v_R8_a_i - 54.0657727682604*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r - 24.9575997948692*v_R8_c_i + 23.284964480954*v_R8_c_r - 39.6392229058202*v_R8_n_i + 10.2713736253513*v_R8_n_r - 242.095286143588*v_R9_a_i + 113.786109551688*v_R9_a_r + 88.488828082646*v_R9_b_i - 18.6937810814837*v_R9_b_r + 58.9235503101833*v_R9_c_i - 45.7766907664085*v_R9_c_r + 88.488828082646*v_R9_n_i - 18.6937810814837*v_R9_n_r
        struct[0].g[126,0] = -10.2713736253513*v_R10_a_i - 39.6392229058202*v_R10_a_r + 54.0657727682604*v_R10_b_i + 105.57176931318*v_R10_b_r - 10.2713736253513*v_R10_c_i - 39.6392229058201*v_R10_c_r - 23.284964480954*v_R10_n_i - 24.9575997948692*v_R10_n_r + 1.84896616921897*v_R17_a_i - 9.21038227100566*v_R17_a_r + 5.65456401516768*v_R17_b_i + 30.9517475172273*v_R17_b_r + 1.84896616921897*v_R17_c_i - 9.21038227100566*v_R17_c_r + 0.793238195499528*v_R17_n_i - 9.00835072044485*v_R17_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r + 54.0657727682604*v_R8_b_i + 105.57176931318*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058201*v_R8_c_r - 23.284964480954*v_R8_n_i - 24.9575997948692*v_R8_n_r + 18.6937810814837*v_R9_a_i + 88.488828082646*v_R9_a_r - 113.786109551688*v_R9_b_i - 242.095286143588*v_R9_b_r + 18.6937810814837*v_R9_c_i + 88.488828082646*v_R9_c_r + 45.7766907664085*v_R9_n_i + 58.9235503101833*v_R9_n_r
        struct[0].g[127,0] = -39.6392229058202*v_R10_a_i + 10.2713736253513*v_R10_a_r + 105.57176931318*v_R10_b_i - 54.0657727682604*v_R10_b_r - 39.6392229058201*v_R10_c_i + 10.2713736253513*v_R10_c_r - 24.9575997948692*v_R10_n_i + 23.284964480954*v_R10_n_r - 9.21038227100566*v_R17_a_i - 1.84896616921897*v_R17_a_r + 30.9517475172273*v_R17_b_i - 5.65456401516768*v_R17_b_r - 9.21038227100566*v_R17_c_i - 1.84896616921897*v_R17_c_r - 9.00835072044485*v_R17_n_i - 0.793238195499528*v_R17_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r + 105.57176931318*v_R8_b_i - 54.0657727682604*v_R8_b_r - 39.6392229058201*v_R8_c_i + 10.2713736253513*v_R8_c_r - 24.9575997948692*v_R8_n_i + 23.284964480954*v_R8_n_r + 88.488828082646*v_R9_a_i - 18.6937810814837*v_R9_a_r - 242.095286143588*v_R9_b_i + 113.786109551688*v_R9_b_r + 88.488828082646*v_R9_c_i - 18.6937810814837*v_R9_c_r + 58.9235503101833*v_R9_n_i - 45.7766907664085*v_R9_n_r
        struct[0].g[128,0] = -23.284964480954*v_R10_a_i - 24.9575997948692*v_R10_a_r - 10.2713736253513*v_R10_b_i - 39.6392229058202*v_R10_b_r + 54.0657727682604*v_R10_c_i + 105.57176931318*v_R10_c_r - 10.2713736253514*v_R10_n_i - 39.6392229058201*v_R10_n_r + 0.793238195499527*v_R17_a_i - 9.00835072044484*v_R17_a_r + 1.84896616921897*v_R17_b_i - 9.21038227100566*v_R17_b_r + 5.65456401516768*v_R17_c_i + 30.9517475172273*v_R17_c_r + 1.84896616921897*v_R17_n_i - 9.21038227100566*v_R17_n_r - 23.284964480954*v_R8_a_i - 24.9575997948692*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r + 54.0657727682604*v_R8_c_i + 105.57176931318*v_R8_c_r - 10.2713736253514*v_R8_n_i - 39.6392229058201*v_R8_n_r + 45.7766907664085*v_R9_a_i + 58.9235503101833*v_R9_a_r + 18.6937810814837*v_R9_b_i + 88.4888280826461*v_R9_b_r - 113.786109551688*v_R9_c_i - 242.095286143588*v_R9_c_r + 18.6937810814837*v_R9_n_i + 88.4888280826459*v_R9_n_r
        struct[0].g[129,0] = -24.9575997948692*v_R10_a_i + 23.284964480954*v_R10_a_r - 39.6392229058202*v_R10_b_i + 10.2713736253513*v_R10_b_r + 105.57176931318*v_R10_c_i - 54.0657727682604*v_R10_c_r - 39.6392229058201*v_R10_n_i + 10.2713736253514*v_R10_n_r - 9.00835072044484*v_R17_a_i - 0.793238195499527*v_R17_a_r - 9.21038227100566*v_R17_b_i - 1.84896616921897*v_R17_b_r + 30.9517475172273*v_R17_c_i - 5.65456401516768*v_R17_c_r - 9.21038227100566*v_R17_n_i - 1.84896616921897*v_R17_n_r - 24.9575997948692*v_R8_a_i + 23.284964480954*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r + 105.57176931318*v_R8_c_i - 54.0657727682604*v_R8_c_r - 39.6392229058201*v_R8_n_i + 10.2713736253514*v_R8_n_r + 58.9235503101833*v_R9_a_i - 45.7766907664085*v_R9_a_r + 88.4888280826461*v_R9_b_i - 18.6937810814837*v_R9_b_r - 242.095286143588*v_R9_c_i + 113.786109551688*v_R9_c_r + 88.4888280826459*v_R9_n_i - 18.6937810814837*v_R9_n_r
        struct[0].g[130,0] = -10.2713736253513*v_R10_a_i - 39.6392229058202*v_R10_a_r - 23.284964480954*v_R10_b_i - 24.9575997948692*v_R10_b_r - 10.2713736253513*v_R10_c_i - 39.6392229058202*v_R10_c_r + 54.0657727682604*v_R10_n_i + 105.57176931318*v_R10_n_r + 1.84896616921897*v_R17_a_i - 9.21038227100566*v_R17_a_r + 0.793238195499527*v_R17_b_i - 9.00835072044485*v_R17_b_r + 1.84896616921897*v_R17_c_i - 9.21038227100566*v_R17_c_r + 5.65456401516768*v_R17_n_i + 30.9517475172273*v_R17_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r - 23.284964480954*v_R8_b_i - 24.9575997948692*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058202*v_R8_c_r + 54.0657727682604*v_R8_n_i + 105.57176931318*v_R8_n_r + 18.6937810814837*v_R9_a_i + 88.488828082646*v_R9_a_r + 45.7766907664085*v_R9_b_i + 58.9235503101832*v_R9_b_r + 18.6937810814837*v_R9_c_i + 88.488828082646*v_R9_c_r - 113.786109551688*v_R9_n_i - 242.095286143588*v_R9_n_r
        struct[0].g[131,0] = -39.6392229058202*v_R10_a_i + 10.2713736253513*v_R10_a_r - 24.9575997948692*v_R10_b_i + 23.284964480954*v_R10_b_r - 39.6392229058202*v_R10_c_i + 10.2713736253513*v_R10_c_r + 105.57176931318*v_R10_n_i - 54.0657727682604*v_R10_n_r - 9.21038227100566*v_R17_a_i - 1.84896616921897*v_R17_a_r - 9.00835072044485*v_R17_b_i - 0.793238195499527*v_R17_b_r - 9.21038227100566*v_R17_c_i - 1.84896616921897*v_R17_c_r + 30.9517475172273*v_R17_n_i - 5.65456401516768*v_R17_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r - 24.9575997948692*v_R8_b_i + 23.284964480954*v_R8_b_r - 39.6392229058202*v_R8_c_i + 10.2713736253513*v_R8_c_r + 105.57176931318*v_R8_n_i - 54.0657727682604*v_R8_n_r + 88.488828082646*v_R9_a_i - 18.6937810814837*v_R9_a_r + 58.9235503101832*v_R9_b_i - 45.7766907664085*v_R9_b_r + 88.488828082646*v_R9_c_i - 18.6937810814837*v_R9_c_r - 242.095286143588*v_R9_n_i + 113.786109551688*v_R9_n_r
        struct[0].g[132,0] = i_vsc_R10_a_r - 59.7203367834281*v_R10_a_i - 136.523516830407*v_R10_a_r + 8.42240745613237*v_R10_b_i + 48.8496051768258*v_R10_b_r + 22.4917262854545*v_R10_c_i + 33.9659505153141*v_R10_c_r + 8.42240745613237*v_R10_n_i + 48.8496051768258*v_R10_n_r + 5.65456401516768*v_R18_a_i + 30.9517475172273*v_R18_a_r + 1.84896616921897*v_R18_b_i - 9.21038227100566*v_R18_b_r + 0.793238195499529*v_R18_c_i - 9.00835072044485*v_R18_c_r + 1.84896616921897*v_R18_n_i - 9.21038227100566*v_R18_n_r + 54.0657727682604*v_R9_a_i + 105.57176931318*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r - 23.284964480954*v_R9_c_i - 24.9575997948692*v_R9_c_r - 10.2713736253513*v_R9_n_i - 39.6392229058202*v_R9_n_r
        struct[0].g[133,0] = i_vsc_R10_a_i - 136.523516830407*v_R10_a_i + 59.7203367834281*v_R10_a_r + 48.8496051768258*v_R10_b_i - 8.42240745613237*v_R10_b_r + 33.9659505153141*v_R10_c_i - 22.4917262854545*v_R10_c_r + 48.8496051768258*v_R10_n_i - 8.42240745613237*v_R10_n_r + 30.9517475172273*v_R18_a_i - 5.65456401516768*v_R18_a_r - 9.21038227100566*v_R18_b_i - 1.84896616921897*v_R18_b_r - 9.00835072044485*v_R18_c_i - 0.793238195499529*v_R18_c_r - 9.21038227100566*v_R18_n_i - 1.84896616921897*v_R18_n_r + 105.57176931318*v_R9_a_i - 54.0657727682604*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r - 24.9575997948692*v_R9_c_i + 23.284964480954*v_R9_c_r - 39.6392229058202*v_R9_n_i + 10.2713736253513*v_R9_n_r
        struct[0].g[134,0] = i_vsc_R10_b_r + 8.42240745613237*v_R10_a_i + 48.8496051768258*v_R10_a_r - 59.720336783428*v_R10_b_i - 136.523516830407*v_R10_b_r + 8.42240745613238*v_R10_c_i + 48.8496051768258*v_R10_c_r + 22.4917262854545*v_R10_n_i + 33.9659505153141*v_R10_n_r + 1.84896616921897*v_R18_a_i - 9.21038227100566*v_R18_a_r + 5.65456401516768*v_R18_b_i + 30.9517475172273*v_R18_b_r + 1.84896616921897*v_R18_c_i - 9.21038227100566*v_R18_c_r + 0.793238195499528*v_R18_n_i - 9.00835072044485*v_R18_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r + 54.0657727682604*v_R9_b_i + 105.57176931318*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058201*v_R9_c_r - 23.284964480954*v_R9_n_i - 24.9575997948692*v_R9_n_r
        struct[0].g[135,0] = i_vsc_R10_b_i + 48.8496051768258*v_R10_a_i - 8.42240745613237*v_R10_a_r - 136.523516830407*v_R10_b_i + 59.720336783428*v_R10_b_r + 48.8496051768258*v_R10_c_i - 8.42240745613238*v_R10_c_r + 33.9659505153141*v_R10_n_i - 22.4917262854545*v_R10_n_r - 9.21038227100566*v_R18_a_i - 1.84896616921897*v_R18_a_r + 30.9517475172273*v_R18_b_i - 5.65456401516768*v_R18_b_r - 9.21038227100566*v_R18_c_i - 1.84896616921897*v_R18_c_r - 9.00835072044485*v_R18_n_i - 0.793238195499528*v_R18_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r + 105.57176931318*v_R9_b_i - 54.0657727682604*v_R9_b_r - 39.6392229058201*v_R9_c_i + 10.2713736253513*v_R9_c_r - 24.9575997948692*v_R9_n_i + 23.284964480954*v_R9_n_r
        struct[0].g[136,0] = i_vsc_R10_c_r + 22.4917262854545*v_R10_a_i + 33.9659505153141*v_R10_a_r + 8.42240745613236*v_R10_b_i + 48.8496051768259*v_R10_b_r - 59.7203367834281*v_R10_c_i - 136.523516830407*v_R10_c_r + 8.42240745613239*v_R10_n_i + 48.8496051768258*v_R10_n_r + 0.793238195499527*v_R18_a_i - 9.00835072044484*v_R18_a_r + 1.84896616921897*v_R18_b_i - 9.21038227100566*v_R18_b_r + 5.65456401516768*v_R18_c_i + 30.9517475172273*v_R18_c_r + 1.84896616921897*v_R18_n_i - 9.21038227100566*v_R18_n_r - 23.284964480954*v_R9_a_i - 24.9575997948692*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r + 54.0657727682604*v_R9_c_i + 105.57176931318*v_R9_c_r - 10.2713736253514*v_R9_n_i - 39.6392229058201*v_R9_n_r
        struct[0].g[137,0] = i_vsc_R10_c_i + 33.9659505153141*v_R10_a_i - 22.4917262854545*v_R10_a_r + 48.8496051768259*v_R10_b_i - 8.42240745613236*v_R10_b_r - 136.523516830407*v_R10_c_i + 59.7203367834281*v_R10_c_r + 48.8496051768258*v_R10_n_i - 8.42240745613239*v_R10_n_r - 9.00835072044484*v_R18_a_i - 0.793238195499527*v_R18_a_r - 9.21038227100566*v_R18_b_i - 1.84896616921897*v_R18_b_r + 30.9517475172273*v_R18_c_i - 5.65456401516768*v_R18_c_r - 9.21038227100566*v_R18_n_i - 1.84896616921897*v_R18_n_r - 24.9575997948692*v_R9_a_i + 23.284964480954*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r + 105.57176931318*v_R9_c_i - 54.0657727682604*v_R9_c_r - 39.6392229058201*v_R9_n_i + 10.2713736253514*v_R9_n_r
        struct[0].g[138,0] = 8.42240745613237*v_R10_a_i + 48.8496051768258*v_R10_a_r + 22.4917262854545*v_R10_b_i + 33.965950515314*v_R10_b_r + 8.42240745613237*v_R10_c_i + 48.8496051768258*v_R10_c_r - 59.7203367834281*v_R10_n_i - 136.548516830407*v_R10_n_r + 1.84896616921897*v_R18_a_i - 9.21038227100566*v_R18_a_r + 0.793238195499527*v_R18_b_i - 9.00835072044485*v_R18_b_r + 1.84896616921897*v_R18_c_i - 9.21038227100566*v_R18_c_r + 5.65456401516768*v_R18_n_i + 30.9517475172273*v_R18_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r - 23.284964480954*v_R9_b_i - 24.9575997948692*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058202*v_R9_c_r + 54.0657727682604*v_R9_n_i + 105.57176931318*v_R9_n_r
        struct[0].g[139,0] = 48.8496051768258*v_R10_a_i - 8.42240745613237*v_R10_a_r + 33.965950515314*v_R10_b_i - 22.4917262854545*v_R10_b_r + 48.8496051768258*v_R10_c_i - 8.42240745613237*v_R10_c_r - 136.548516830407*v_R10_n_i + 59.7203367834281*v_R10_n_r - 9.21038227100566*v_R18_a_i - 1.84896616921897*v_R18_a_r - 9.00835072044485*v_R18_b_i - 0.793238195499527*v_R18_b_r - 9.21038227100566*v_R18_c_i - 1.84896616921897*v_R18_c_r + 30.9517475172273*v_R18_n_i - 5.65456401516768*v_R18_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r - 24.9575997948692*v_R9_b_i + 23.284964480954*v_R9_b_r - 39.6392229058202*v_R9_c_i + 10.2713736253513*v_R9_c_r + 105.57176931318*v_R9_n_i - 54.0657727682604*v_R9_n_r
        struct[0].g[140,0] = -9.69353831171601*v_R12_a_i - 53.0601386009611*v_R12_a_r - 3.16965629008966*v_R12_b_i + 15.7892267502954*v_R12_b_r - 1.35983690657062*v_R12_c_i + 15.442886949334*v_R12_c_r - 3.16965629008966*v_R12_n_i + 15.7892267502954*v_R12_n_r + 4.84676915585801*v_R13_a_i + 26.5300693004806*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 0.67991845328531*v_R13_c_i - 7.72144347466701*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r + 4.84676915585801*v_R4_a_i + 26.5300693004806*v_R4_a_r + 1.58482814504483*v_R4_b_i - 7.8946133751477*v_R4_b_r + 0.67991845328531*v_R4_c_i - 7.72144347466701*v_R4_c_r + 1.58482814504483*v_R4_n_i - 7.89461337514771*v_R4_n_r
        struct[0].g[141,0] = -53.0601386009611*v_R12_a_i + 9.69353831171601*v_R12_a_r + 15.7892267502954*v_R12_b_i + 3.16965629008966*v_R12_b_r + 15.442886949334*v_R12_c_i + 1.35983690657062*v_R12_c_r + 15.7892267502954*v_R12_n_i + 3.16965629008966*v_R12_n_r + 26.5300693004806*v_R13_a_i - 4.84676915585801*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r - 7.72144347466701*v_R13_c_i - 0.67991845328531*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r + 26.5300693004806*v_R4_a_i - 4.84676915585801*v_R4_a_r - 7.8946133751477*v_R4_b_i - 1.58482814504483*v_R4_b_r - 7.72144347466701*v_R4_c_i - 0.67991845328531*v_R4_c_r - 7.89461337514771*v_R4_n_i - 1.58482814504483*v_R4_n_r
        struct[0].g[142,0] = -3.16965629008966*v_R12_a_i + 15.7892267502954*v_R12_a_r - 9.69353831171602*v_R12_b_i - 53.0601386009611*v_R12_b_r - 3.16965629008967*v_R12_c_i + 15.7892267502954*v_R12_c_r - 1.35983690657062*v_R12_n_i + 15.442886949334*v_R12_n_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 4.84676915585801*v_R13_b_i + 26.5300693004806*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 0.679918453285308*v_R13_n_i - 7.72144347466701*v_R13_n_r + 1.58482814504483*v_R4_a_i - 7.89461337514771*v_R4_a_r + 4.84676915585801*v_R4_b_i + 26.5300693004806*v_R4_b_r + 1.58482814504483*v_R4_c_i - 7.89461337514771*v_R4_c_r + 0.679918453285308*v_R4_n_i - 7.72144347466701*v_R4_n_r
        struct[0].g[143,0] = 15.7892267502954*v_R12_a_i + 3.16965629008966*v_R12_a_r - 53.0601386009611*v_R12_b_i + 9.69353831171602*v_R12_b_r + 15.7892267502954*v_R12_c_i + 3.16965629008967*v_R12_c_r + 15.442886949334*v_R12_n_i + 1.35983690657062*v_R12_n_r - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r + 26.5300693004806*v_R13_b_i - 4.84676915585801*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r - 7.72144347466701*v_R13_n_i - 0.679918453285308*v_R13_n_r - 7.89461337514771*v_R4_a_i - 1.58482814504483*v_R4_a_r + 26.5300693004806*v_R4_b_i - 4.84676915585801*v_R4_b_r - 7.89461337514771*v_R4_c_i - 1.58482814504483*v_R4_c_r - 7.72144347466701*v_R4_n_i - 0.679918453285308*v_R4_n_r
        struct[0].g[144,0] = -1.35983690657062*v_R12_a_i + 15.442886949334*v_R12_a_r - 3.16965629008966*v_R12_b_i + 15.7892267502954*v_R12_b_r - 9.69353831171602*v_R12_c_i - 53.0601386009611*v_R12_c_r - 3.16965629008967*v_R12_n_i + 15.7892267502954*v_R12_n_r + 0.67991845328531*v_R13_a_i - 7.72144347466701*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 4.84676915585801*v_R13_c_i + 26.5300693004806*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r + 0.67991845328531*v_R4_a_i - 7.72144347466701*v_R4_a_r + 1.58482814504483*v_R4_b_i - 7.8946133751477*v_R4_b_r + 4.84676915585801*v_R4_c_i + 26.5300693004806*v_R4_c_r + 1.58482814504483*v_R4_n_i - 7.89461337514771*v_R4_n_r
        struct[0].g[145,0] = 15.442886949334*v_R12_a_i + 1.35983690657062*v_R12_a_r + 15.7892267502954*v_R12_b_i + 3.16965629008966*v_R12_b_r - 53.0601386009611*v_R12_c_i + 9.69353831171602*v_R12_c_r + 15.7892267502954*v_R12_n_i + 3.16965629008967*v_R12_n_r - 7.72144347466701*v_R13_a_i - 0.67991845328531*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r + 26.5300693004806*v_R13_c_i - 4.84676915585801*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r - 7.72144347466701*v_R4_a_i - 0.67991845328531*v_R4_a_r - 7.8946133751477*v_R4_b_i - 1.58482814504483*v_R4_b_r + 26.5300693004806*v_R4_c_i - 4.84676915585801*v_R4_c_r - 7.89461337514771*v_R4_n_i - 1.58482814504483*v_R4_n_r
        struct[0].g[146,0] = -3.16965629008966*v_R12_a_i + 15.7892267502954*v_R12_a_r - 1.35983690657062*v_R12_b_i + 15.442886949334*v_R12_b_r - 3.16965629008966*v_R12_c_i + 15.7892267502954*v_R12_c_r - 9.69353831171602*v_R12_n_i - 53.0601386009611*v_R12_n_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 0.679918453285308*v_R13_b_i - 7.72144347466701*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 4.84676915585801*v_R13_n_i + 26.5300693004806*v_R13_n_r + 1.58482814504483*v_R4_a_i - 7.89461337514771*v_R4_a_r + 0.679918453285308*v_R4_b_i - 7.72144347466701*v_R4_b_r + 1.58482814504483*v_R4_c_i - 7.89461337514771*v_R4_c_r + 4.84676915585801*v_R4_n_i + 26.5300693004806*v_R4_n_r
        struct[0].g[147,0] = 15.7892267502954*v_R12_a_i + 3.16965629008966*v_R12_a_r + 15.442886949334*v_R12_b_i + 1.35983690657062*v_R12_b_r + 15.7892267502954*v_R12_c_i + 3.16965629008966*v_R12_c_r - 53.0601386009611*v_R12_n_i + 9.69353831171602*v_R12_n_r - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r - 7.72144347466701*v_R13_b_i - 0.679918453285308*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r + 26.5300693004806*v_R13_n_i - 4.84676915585801*v_R13_n_r - 7.89461337514771*v_R4_a_i - 1.58482814504483*v_R4_a_r - 7.72144347466701*v_R4_b_i - 0.679918453285308*v_R4_b_r - 7.89461337514771*v_R4_c_i - 1.58482814504483*v_R4_c_r + 26.5300693004806*v_R4_n_i - 4.84676915585801*v_R4_n_r
        struct[0].g[148,0] = 4.84676915585801*v_R12_a_i + 26.5300693004806*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 0.67991845328531*v_R12_c_i - 7.72144347466701*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 9.69353831171601*v_R13_a_i - 53.0601386009611*v_R13_a_r - 3.16965629008966*v_R13_b_i + 15.7892267502954*v_R13_b_r - 1.35983690657062*v_R13_c_i + 15.442886949334*v_R13_c_r - 3.16965629008966*v_R13_n_i + 15.7892267502954*v_R13_n_r + 4.84676915585801*v_R14_a_i + 26.5300693004806*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 0.67991845328531*v_R14_c_i - 7.72144347466701*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r
        struct[0].g[149,0] = 26.5300693004806*v_R12_a_i - 4.84676915585801*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r - 7.72144347466701*v_R12_c_i - 0.67991845328531*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r - 53.0601386009611*v_R13_a_i + 9.69353831171601*v_R13_a_r + 15.7892267502954*v_R13_b_i + 3.16965629008966*v_R13_b_r + 15.442886949334*v_R13_c_i + 1.35983690657062*v_R13_c_r + 15.7892267502954*v_R13_n_i + 3.16965629008966*v_R13_n_r + 26.5300693004806*v_R14_a_i - 4.84676915585801*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r - 7.72144347466701*v_R14_c_i - 0.67991845328531*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r
        struct[0].g[150,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 4.84676915585801*v_R12_b_i + 26.5300693004806*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 0.679918453285308*v_R12_n_i - 7.72144347466701*v_R12_n_r - 3.16965629008966*v_R13_a_i + 15.7892267502954*v_R13_a_r - 9.69353831171602*v_R13_b_i - 53.0601386009611*v_R13_b_r - 3.16965629008967*v_R13_c_i + 15.7892267502954*v_R13_c_r - 1.35983690657062*v_R13_n_i + 15.442886949334*v_R13_n_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 4.84676915585801*v_R14_b_i + 26.5300693004806*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 0.679918453285308*v_R14_n_i - 7.72144347466701*v_R14_n_r
        struct[0].g[151,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r + 26.5300693004806*v_R12_b_i - 4.84676915585801*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r - 7.72144347466701*v_R12_n_i - 0.679918453285308*v_R12_n_r + 15.7892267502954*v_R13_a_i + 3.16965629008966*v_R13_a_r - 53.0601386009611*v_R13_b_i + 9.69353831171602*v_R13_b_r + 15.7892267502954*v_R13_c_i + 3.16965629008967*v_R13_c_r + 15.442886949334*v_R13_n_i + 1.35983690657062*v_R13_n_r - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r + 26.5300693004806*v_R14_b_i - 4.84676915585801*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r - 7.72144347466701*v_R14_n_i - 0.679918453285308*v_R14_n_r
        struct[0].g[152,0] = 0.67991845328531*v_R12_a_i - 7.72144347466701*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 4.84676915585801*v_R12_c_i + 26.5300693004806*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 1.35983690657062*v_R13_a_i + 15.442886949334*v_R13_a_r - 3.16965629008966*v_R13_b_i + 15.7892267502954*v_R13_b_r - 9.69353831171602*v_R13_c_i - 53.0601386009611*v_R13_c_r - 3.16965629008967*v_R13_n_i + 15.7892267502954*v_R13_n_r + 0.67991845328531*v_R14_a_i - 7.72144347466701*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 4.84676915585801*v_R14_c_i + 26.5300693004806*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r
        struct[0].g[153,0] = -7.72144347466701*v_R12_a_i - 0.67991845328531*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r + 26.5300693004806*v_R12_c_i - 4.84676915585801*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r + 15.442886949334*v_R13_a_i + 1.35983690657062*v_R13_a_r + 15.7892267502954*v_R13_b_i + 3.16965629008966*v_R13_b_r - 53.0601386009611*v_R13_c_i + 9.69353831171602*v_R13_c_r + 15.7892267502954*v_R13_n_i + 3.16965629008967*v_R13_n_r - 7.72144347466701*v_R14_a_i - 0.67991845328531*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r + 26.5300693004806*v_R14_c_i - 4.84676915585801*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r
        struct[0].g[154,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 0.679918453285308*v_R12_b_i - 7.72144347466701*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 4.84676915585801*v_R12_n_i + 26.5300693004806*v_R12_n_r - 3.16965629008966*v_R13_a_i + 15.7892267502954*v_R13_a_r - 1.35983690657062*v_R13_b_i + 15.442886949334*v_R13_b_r - 3.16965629008966*v_R13_c_i + 15.7892267502954*v_R13_c_r - 9.69353831171602*v_R13_n_i - 53.0851386009611*v_R13_n_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 0.679918453285308*v_R14_b_i - 7.72144347466701*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 4.84676915585801*v_R14_n_i + 26.5300693004806*v_R14_n_r
        struct[0].g[155,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r - 7.72144347466701*v_R12_b_i - 0.679918453285308*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r + 26.5300693004806*v_R12_n_i - 4.84676915585801*v_R12_n_r + 15.7892267502954*v_R13_a_i + 3.16965629008966*v_R13_a_r + 15.442886949334*v_R13_b_i + 1.35983690657062*v_R13_b_r + 15.7892267502954*v_R13_c_i + 3.16965629008966*v_R13_c_r - 53.0851386009611*v_R13_n_i + 9.69353831171602*v_R13_n_r - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r - 7.72144347466701*v_R14_b_i - 0.679918453285308*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r + 26.5300693004806*v_R14_n_i - 4.84676915585801*v_R14_n_r
        struct[0].g[156,0] = i_vsc_R14_a_r + 4.84676915585801*v_R13_a_i + 26.5300693004806*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 0.67991845328531*v_R13_c_i - 7.72144347466701*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r - 9.69353831171601*v_R14_a_i - 53.0601386009611*v_R14_a_r - 3.16965629008966*v_R14_b_i + 15.7892267502954*v_R14_b_r - 1.35983690657062*v_R14_c_i + 15.442886949334*v_R14_c_r - 3.16965629008966*v_R14_n_i + 15.7892267502954*v_R14_n_r + 4.84676915585801*v_R15_a_i + 26.5300693004806*v_R15_a_r + 1.58482814504483*v_R15_b_i - 7.8946133751477*v_R15_b_r + 0.67991845328531*v_R15_c_i - 7.72144347466701*v_R15_c_r + 1.58482814504483*v_R15_n_i - 7.89461337514771*v_R15_n_r
        struct[0].g[157,0] = i_vsc_R14_a_i + 26.5300693004806*v_R13_a_i - 4.84676915585801*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r - 7.72144347466701*v_R13_c_i - 0.67991845328531*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r - 53.0601386009611*v_R14_a_i + 9.69353831171601*v_R14_a_r + 15.7892267502954*v_R14_b_i + 3.16965629008966*v_R14_b_r + 15.442886949334*v_R14_c_i + 1.35983690657062*v_R14_c_r + 15.7892267502954*v_R14_n_i + 3.16965629008966*v_R14_n_r + 26.5300693004806*v_R15_a_i - 4.84676915585801*v_R15_a_r - 7.8946133751477*v_R15_b_i - 1.58482814504483*v_R15_b_r - 7.72144347466701*v_R15_c_i - 0.67991845328531*v_R15_c_r - 7.89461337514771*v_R15_n_i - 1.58482814504483*v_R15_n_r
        struct[0].g[158,0] = i_vsc_R14_b_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 4.84676915585801*v_R13_b_i + 26.5300693004806*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 0.679918453285308*v_R13_n_i - 7.72144347466701*v_R13_n_r - 3.16965629008966*v_R14_a_i + 15.7892267502954*v_R14_a_r - 9.69353831171602*v_R14_b_i - 53.0601386009611*v_R14_b_r - 3.16965629008967*v_R14_c_i + 15.7892267502954*v_R14_c_r - 1.35983690657062*v_R14_n_i + 15.442886949334*v_R14_n_r + 1.58482814504483*v_R15_a_i - 7.89461337514771*v_R15_a_r + 4.84676915585801*v_R15_b_i + 26.5300693004806*v_R15_b_r + 1.58482814504483*v_R15_c_i - 7.89461337514771*v_R15_c_r + 0.679918453285308*v_R15_n_i - 7.72144347466701*v_R15_n_r
        struct[0].g[159,0] = i_vsc_R14_b_i - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r + 26.5300693004806*v_R13_b_i - 4.84676915585801*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r - 7.72144347466701*v_R13_n_i - 0.679918453285308*v_R13_n_r + 15.7892267502954*v_R14_a_i + 3.16965629008966*v_R14_a_r - 53.0601386009611*v_R14_b_i + 9.69353831171602*v_R14_b_r + 15.7892267502954*v_R14_c_i + 3.16965629008967*v_R14_c_r + 15.442886949334*v_R14_n_i + 1.35983690657062*v_R14_n_r - 7.89461337514771*v_R15_a_i - 1.58482814504483*v_R15_a_r + 26.5300693004806*v_R15_b_i - 4.84676915585801*v_R15_b_r - 7.89461337514771*v_R15_c_i - 1.58482814504483*v_R15_c_r - 7.72144347466701*v_R15_n_i - 0.679918453285308*v_R15_n_r
        struct[0].g[160,0] = i_vsc_R14_c_r + 0.67991845328531*v_R13_a_i - 7.72144347466701*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 4.84676915585801*v_R13_c_i + 26.5300693004806*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r - 1.35983690657062*v_R14_a_i + 15.442886949334*v_R14_a_r - 3.16965629008966*v_R14_b_i + 15.7892267502954*v_R14_b_r - 9.69353831171602*v_R14_c_i - 53.0601386009611*v_R14_c_r - 3.16965629008967*v_R14_n_i + 15.7892267502954*v_R14_n_r + 0.67991845328531*v_R15_a_i - 7.72144347466701*v_R15_a_r + 1.58482814504483*v_R15_b_i - 7.8946133751477*v_R15_b_r + 4.84676915585801*v_R15_c_i + 26.5300693004806*v_R15_c_r + 1.58482814504483*v_R15_n_i - 7.89461337514771*v_R15_n_r
        struct[0].g[161,0] = i_vsc_R14_c_i - 7.72144347466701*v_R13_a_i - 0.67991845328531*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r + 26.5300693004806*v_R13_c_i - 4.84676915585801*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r + 15.442886949334*v_R14_a_i + 1.35983690657062*v_R14_a_r + 15.7892267502954*v_R14_b_i + 3.16965629008966*v_R14_b_r - 53.0601386009611*v_R14_c_i + 9.69353831171602*v_R14_c_r + 15.7892267502954*v_R14_n_i + 3.16965629008967*v_R14_n_r - 7.72144347466701*v_R15_a_i - 0.67991845328531*v_R15_a_r - 7.8946133751477*v_R15_b_i - 1.58482814504483*v_R15_b_r + 26.5300693004806*v_R15_c_i - 4.84676915585801*v_R15_c_r - 7.89461337514771*v_R15_n_i - 1.58482814504483*v_R15_n_r
        struct[0].g[162,0] = 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 0.679918453285308*v_R13_b_i - 7.72144347466701*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 4.84676915585801*v_R13_n_i + 26.5300693004806*v_R13_n_r - 3.16965629008966*v_R14_a_i + 15.7892267502954*v_R14_a_r - 1.35983690657062*v_R14_b_i + 15.442886949334*v_R14_b_r - 3.16965629008966*v_R14_c_i + 15.7892267502954*v_R14_c_r - 9.69353831171602*v_R14_n_i - 53.0601386009611*v_R14_n_r + 1.58482814504483*v_R15_a_i - 7.89461337514771*v_R15_a_r + 0.679918453285308*v_R15_b_i - 7.72144347466701*v_R15_b_r + 1.58482814504483*v_R15_c_i - 7.89461337514771*v_R15_c_r + 4.84676915585801*v_R15_n_i + 26.5300693004806*v_R15_n_r
        struct[0].g[163,0] = -7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r - 7.72144347466701*v_R13_b_i - 0.679918453285308*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r + 26.5300693004806*v_R13_n_i - 4.84676915585801*v_R13_n_r + 15.7892267502954*v_R14_a_i + 3.16965629008966*v_R14_a_r + 15.442886949334*v_R14_b_i + 1.35983690657062*v_R14_b_r + 15.7892267502954*v_R14_c_i + 3.16965629008966*v_R14_c_r - 53.0601386009611*v_R14_n_i + 9.69353831171602*v_R14_n_r - 7.89461337514771*v_R15_a_i - 1.58482814504483*v_R15_a_r - 7.72144347466701*v_R15_b_i - 0.679918453285308*v_R15_b_r - 7.89461337514771*v_R15_c_i - 1.58482814504483*v_R15_c_r + 26.5300693004806*v_R15_n_i - 4.84676915585801*v_R15_n_r
        struct[0].g[164,0] = -1067.7048070413*v_D1_n_r + 67.7048070412999*v_D3_n_r
        struct[0].g[165,0] = -1067.7048070413*v_D1_n_i + 67.7048070412999*v_D3_n_i
        struct[0].g[166,0] = 157.977883096366*v_D11_a_r + 67.7048070412999*v_D1_a_r - 361.092304220266*v_D3_a_r + 135.4096140826*v_D4_a_r
        struct[0].g[167,0] = 157.977883096366*v_D11_a_i + 67.7048070412999*v_D1_a_i - 361.092304220266*v_D3_a_i + 135.4096140826*v_D4_a_i
        struct[0].g[168,0] = 157.977883096366*v_D11_b_r + 67.7048070412999*v_D1_b_r - 361.092304220266*v_D3_b_r + 135.4096140826*v_D4_b_r
        struct[0].g[169,0] = 157.977883096366*v_D11_b_i + 67.7048070412999*v_D1_b_i - 361.092304220266*v_D3_b_i + 135.4096140826*v_D4_b_i
        struct[0].g[170,0] = 157.977883096366*v_D11_c_r + 67.7048070412999*v_D1_c_r - 361.092304220266*v_D3_c_r + 135.4096140826*v_D4_c_r
        struct[0].g[171,0] = 157.977883096366*v_D11_c_i + 67.7048070412999*v_D1_c_i - 361.092304220266*v_D3_c_i + 135.4096140826*v_D4_c_i
        struct[0].g[172,0] = 157.977883096366*v_D11_n_r + 67.7048070412999*v_D1_n_r - 361.092304220266*v_D3_n_r + 135.4096140826*v_D4_n_r
        struct[0].g[173,0] = 157.977883096366*v_D11_n_i + 67.7048070412999*v_D1_n_i - 361.092304220266*v_D3_n_i + 135.4096140826*v_D4_n_i
        struct[0].g[174,0] = 45.1365380275333*v_D14_a_r + 135.4096140826*v_D3_a_r - 248.250959151433*v_D4_a_r + 67.7048070412999*v_D6_a_r
        struct[0].g[175,0] = 45.1365380275333*v_D14_a_i + 135.4096140826*v_D3_a_i - 248.250959151433*v_D4_a_i + 67.7048070412999*v_D6_a_i
        struct[0].g[176,0] = 45.1365380275333*v_D14_b_r + 135.4096140826*v_D3_b_r - 248.250959151433*v_D4_b_r + 67.7048070412999*v_D6_b_r
        struct[0].g[177,0] = 45.1365380275333*v_D14_b_i + 135.4096140826*v_D3_b_i - 248.250959151433*v_D4_b_i + 67.7048070412999*v_D6_b_i
        struct[0].g[178,0] = 45.1365380275333*v_D14_c_r + 135.4096140826*v_D3_c_r - 248.250959151433*v_D4_c_r + 67.7048070412999*v_D6_c_r
        struct[0].g[179,0] = 45.1365380275333*v_D14_c_i + 135.4096140826*v_D3_c_i - 248.250959151433*v_D4_c_i + 67.7048070412999*v_D6_c_i
        struct[0].g[180,0] = 45.1365380275333*v_D14_n_r + 135.4096140826*v_D3_n_r - 248.250959151433*v_D4_n_r + 67.7048070412999*v_D6_n_r
        struct[0].g[181,0] = 45.1365380275333*v_D14_n_i + 135.4096140826*v_D3_n_i - 248.250959151433*v_D4_n_i + 67.7048070412999*v_D6_n_i
        struct[0].g[182,0] = 157.977883096366*v_D16_a_r + 67.7048070412999*v_D4_a_r - 270.8192281652*v_D6_a_r + 45.1365380275333*v_D9_a_r
        struct[0].g[183,0] = 157.977883096366*v_D16_a_i + 67.7048070412999*v_D4_a_i - 270.8192281652*v_D6_a_i + 45.1365380275333*v_D9_a_i
        struct[0].g[184,0] = 157.977883096366*v_D16_b_r + 67.7048070412999*v_D4_b_r - 270.8192281652*v_D6_b_r + 45.1365380275333*v_D9_b_r
        struct[0].g[185,0] = 157.977883096366*v_D16_b_i + 67.7048070412999*v_D4_b_i - 270.8192281652*v_D6_b_i + 45.1365380275333*v_D9_b_i
        struct[0].g[186,0] = 157.977883096366*v_D16_c_r + 67.7048070412999*v_D4_c_r - 270.8192281652*v_D6_c_r + 45.1365380275333*v_D9_c_r
        struct[0].g[187,0] = 157.977883096366*v_D16_c_i + 67.7048070412999*v_D4_c_i - 270.8192281652*v_D6_c_i + 45.1365380275333*v_D9_c_i
        struct[0].g[188,0] = 157.977883096366*v_D16_n_r + 67.7048070412999*v_D4_n_r - 270.8192281652*v_D6_n_r + 45.1365380275333*v_D9_n_r
        struct[0].g[189,0] = 157.977883096366*v_D16_n_i + 67.7048070412999*v_D4_n_i - 270.8192281652*v_D6_n_i + 45.1365380275333*v_D9_n_i
        struct[0].g[190,0] = 157.977883096366*v_D10_a_r + 157.977883096366*v_D17_a_r + 45.1365380275333*v_D6_a_r - 361.092304220266*v_D9_a_r
        struct[0].g[191,0] = 157.977883096366*v_D10_a_i + 157.977883096366*v_D17_a_i + 45.1365380275333*v_D6_a_i - 361.092304220266*v_D9_a_i
        struct[0].g[192,0] = 157.977883096366*v_D10_b_r + 157.977883096366*v_D17_b_r + 45.1365380275333*v_D6_b_r - 361.092304220266*v_D9_b_r
        struct[0].g[193,0] = 157.977883096366*v_D10_b_i + 157.977883096366*v_D17_b_i + 45.1365380275333*v_D6_b_i - 361.092304220266*v_D9_b_i
        struct[0].g[194,0] = 157.977883096366*v_D10_c_r + 157.977883096366*v_D17_c_r + 45.1365380275333*v_D6_c_r - 361.092304220266*v_D9_c_r
        struct[0].g[195,0] = 157.977883096366*v_D10_c_i + 157.977883096366*v_D17_c_i + 45.1365380275333*v_D6_c_i - 361.092304220266*v_D9_c_i
        struct[0].g[196,0] = 157.977883096366*v_D10_n_r + 157.977883096366*v_D17_n_r + 45.1365380275333*v_D6_n_r - 361.092304220266*v_D9_n_r
        struct[0].g[197,0] = 157.977883096366*v_D10_n_i + 157.977883096366*v_D17_n_i + 45.1365380275333*v_D6_n_i - 361.092304220266*v_D9_n_i
        struct[0].g[198,0] = i_vsc_D10_a_r - 315.955766192733*v_D10_a_r + 157.977883096366*v_D18_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[199,0] = -315.955766192733*v_D10_a_i + 157.977883096366*v_D18_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[200,0] = -315.955766192733*v_D10_b_r + 157.977883096366*v_D18_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[201,0] = -315.955766192733*v_D10_b_i + 157.977883096366*v_D18_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[202,0] = -315.955766192733*v_D10_c_r + 157.977883096366*v_D18_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[203,0] = -315.955766192733*v_D10_c_i + 157.977883096366*v_D18_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[204,0] = i_vsc_D10_n_r - 315.955766192733*v_D10_n_r + 157.977883096366*v_D18_n_r + 157.977883096366*v_D9_n_r
        struct[0].g[205,0] = -315.955766192733*v_D10_n_i + 157.977883096366*v_D18_n_i + 157.977883096366*v_D9_n_i
        struct[0].g[206,0] = -157.977883096366*v_D11_b_r + 157.977883096366*v_D3_b_r
        struct[0].g[207,0] = -157.977883096366*v_D11_b_i + 157.977883096366*v_D3_b_i
        struct[0].g[208,0] = -157.977883096366*v_D11_c_r + 157.977883096366*v_D3_c_r
        struct[0].g[209,0] = -157.977883096366*v_D11_c_i + 157.977883096366*v_D3_c_i
        struct[0].g[210,0] = -157.977883096366*v_D16_b_r + 157.977883096366*v_D6_b_r
        struct[0].g[211,0] = -157.977883096366*v_D16_b_i + 157.977883096366*v_D6_b_i
        struct[0].g[212,0] = -157.977883096366*v_D16_c_r + 157.977883096366*v_D6_c_r
        struct[0].g[213,0] = -157.977883096366*v_D16_c_i + 157.977883096366*v_D6_c_i
        struct[0].g[214,0] = -157.977883096366*v_D17_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[215,0] = -157.977883096366*v_D17_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[216,0] = -157.977883096366*v_D17_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[217,0] = -157.977883096366*v_D17_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[218,0] = 157.977883096366*v_D10_b_r - 157.977883096366*v_D18_b_r
        struct[0].g[219,0] = 157.977883096366*v_D10_b_i - 157.977883096366*v_D18_b_i
        struct[0].g[220,0] = 157.977883096366*v_D10_c_r - 157.977883096366*v_D18_c_r
        struct[0].g[221,0] = 157.977883096366*v_D10_c_i - 157.977883096366*v_D18_c_i
        struct[0].g[222,0] = i_vsc_D14_a_r - 180.546152110133*v_D14_a_r + 135.4096140826*v_D15_a_r + 45.1365380275333*v_D4_a_r
        struct[0].g[223,0] = -180.546152110133*v_D14_a_i + 135.4096140826*v_D15_a_i + 45.1365380275333*v_D4_a_i
        struct[0].g[224,0] = -180.546152110133*v_D14_b_r + 135.4096140826*v_D15_b_r + 45.1365380275333*v_D4_b_r
        struct[0].g[225,0] = -180.546152110133*v_D14_b_i + 135.4096140826*v_D15_b_i + 45.1365380275333*v_D4_b_i
        struct[0].g[226,0] = -180.546152110133*v_D14_c_r + 135.4096140826*v_D15_c_r + 45.1365380275333*v_D4_c_r
        struct[0].g[227,0] = -180.546152110133*v_D14_c_i + 135.4096140826*v_D15_c_i + 45.1365380275333*v_D4_c_i
        struct[0].g[228,0] = i_vsc_D14_n_r - 180.546152110133*v_D14_n_r + 135.4096140826*v_D15_n_r + 45.1365380275333*v_D4_n_r
        struct[0].g[229,0] = -180.546152110133*v_D14_n_i + 135.4096140826*v_D15_n_i + 45.1365380275333*v_D4_n_i
        struct[0].g[230,0] = 135.4096140826*v_D14_b_r - 135.4096140826*v_D15_b_r
        struct[0].g[231,0] = 135.4096140826*v_D14_b_i - 135.4096140826*v_D15_b_i
        struct[0].g[232,0] = 135.4096140826*v_D14_c_r - 135.4096140826*v_D15_c_r
        struct[0].g[233,0] = 135.4096140826*v_D14_c_i - 135.4096140826*v_D15_c_i
        struct[0].g[234,0] = -i_t_R0_R1_a_r + 0.0196078431372549*v_R0_a_i + 0.00490196078431373*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_a_i - 0.212261128378539*v_R1_a_r + 0.849044513514155*v_R1_b_i + 0.212261128378539*v_R1_b_r
        struct[0].g[235,0] = -i_t_R0_R1_a_i + 0.00490196078431373*v_R0_a_i - 0.0196078431372549*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_a_i + 0.849044513514155*v_R1_a_r + 0.212261128378539*v_R1_b_i - 0.849044513514155*v_R1_b_r
        struct[0].g[236,0] = -i_t_R0_R1_b_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r + 0.0196078431372549*v_R0_b_i + 0.00490196078431373*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_b_i - 0.212261128378539*v_R1_b_r + 0.849044513514155*v_R1_c_i + 0.212261128378539*v_R1_c_r
        struct[0].g[237,0] = -i_t_R0_R1_b_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r + 0.00490196078431373*v_R0_b_i - 0.0196078431372549*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_b_i + 0.849044513514155*v_R1_b_r + 0.212261128378539*v_R1_c_i - 0.849044513514155*v_R1_c_r
        struct[0].g[238,0] = -i_t_R0_R1_c_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r + 0.0196078431372549*v_R0_c_i + 0.00490196078431373*v_R0_c_r + 0.849044513514155*v_R1_a_i + 0.212261128378539*v_R1_a_r - 0.849044513514155*v_R1_c_i - 0.212261128378539*v_R1_c_r
        struct[0].g[239,0] = -i_t_R0_R1_c_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r + 0.00490196078431373*v_R0_c_i - 0.0196078431372549*v_R0_c_r + 0.212261128378539*v_R1_a_i - 0.849044513514155*v_R1_a_r - 0.212261128378539*v_R1_c_i + 0.849044513514155*v_R1_c_r
        struct[0].g[240,0] = -i_l_R1_R2_a_r + 54.0657727682604*v_R1_a_i + 105.57176931318*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r - 23.284964480954*v_R1_c_i - 24.9575997948692*v_R1_c_r - 10.2713736253513*v_R1_n_i - 39.6392229058202*v_R1_n_r - 54.0657727682604*v_R2_a_i - 105.57176931318*v_R2_a_r + 10.2713736253513*v_R2_b_i + 39.6392229058202*v_R2_b_r + 23.284964480954*v_R2_c_i + 24.9575997948692*v_R2_c_r + 10.2713736253513*v_R2_n_i + 39.6392229058202*v_R2_n_r
        struct[0].g[241,0] = -i_l_R1_R2_a_i + 105.57176931318*v_R1_a_i - 54.0657727682604*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r - 24.9575997948692*v_R1_c_i + 23.284964480954*v_R1_c_r - 39.6392229058202*v_R1_n_i + 10.2713736253513*v_R1_n_r - 105.57176931318*v_R2_a_i + 54.0657727682604*v_R2_a_r + 39.6392229058202*v_R2_b_i - 10.2713736253513*v_R2_b_r + 24.9575997948692*v_R2_c_i - 23.284964480954*v_R2_c_r + 39.6392229058202*v_R2_n_i - 10.2713736253513*v_R2_n_r
        struct[0].g[242,0] = -i_l_R1_R2_b_r - 10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r + 54.0657727682604*v_R1_b_i + 105.57176931318*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058201*v_R1_c_r - 23.284964480954*v_R1_n_i - 24.9575997948692*v_R1_n_r + 10.2713736253513*v_R2_a_i + 39.6392229058202*v_R2_a_r - 54.0657727682604*v_R2_b_i - 105.57176931318*v_R2_b_r + 10.2713736253513*v_R2_c_i + 39.6392229058201*v_R2_c_r + 23.284964480954*v_R2_n_i + 24.9575997948692*v_R2_n_r
        struct[0].g[243,0] = -i_l_R1_R2_b_i - 39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r + 105.57176931318*v_R1_b_i - 54.0657727682604*v_R1_b_r - 39.6392229058201*v_R1_c_i + 10.2713736253513*v_R1_c_r - 24.9575997948692*v_R1_n_i + 23.284964480954*v_R1_n_r + 39.6392229058202*v_R2_a_i - 10.2713736253513*v_R2_a_r - 105.57176931318*v_R2_b_i + 54.0657727682604*v_R2_b_r + 39.6392229058201*v_R2_c_i - 10.2713736253513*v_R2_c_r + 24.9575997948692*v_R2_n_i - 23.284964480954*v_R2_n_r
        struct[0].g[244,0] = -i_l_R1_R2_c_r - 23.284964480954*v_R1_a_i - 24.9575997948692*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r + 54.0657727682604*v_R1_c_i + 105.57176931318*v_R1_c_r - 10.2713736253514*v_R1_n_i - 39.6392229058201*v_R1_n_r + 23.284964480954*v_R2_a_i + 24.9575997948692*v_R2_a_r + 10.2713736253513*v_R2_b_i + 39.6392229058202*v_R2_b_r - 54.0657727682604*v_R2_c_i - 105.57176931318*v_R2_c_r + 10.2713736253514*v_R2_n_i + 39.6392229058201*v_R2_n_r
        struct[0].g[245,0] = -i_l_R1_R2_c_i - 24.9575997948692*v_R1_a_i + 23.284964480954*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r + 105.57176931318*v_R1_c_i - 54.0657727682604*v_R1_c_r - 39.6392229058201*v_R1_n_i + 10.2713736253514*v_R1_n_r + 24.9575997948692*v_R2_a_i - 23.284964480954*v_R2_a_r + 39.6392229058202*v_R2_b_i - 10.2713736253513*v_R2_b_r - 105.57176931318*v_R2_c_i + 54.0657727682604*v_R2_c_r + 39.6392229058201*v_R2_n_i - 10.2713736253514*v_R2_n_r
        struct[0].g[246,0] = i_l_R1_R2_a_r + i_l_R1_R2_b_r + i_l_R1_R2_c_r - i_l_R1_R2_n_r
        struct[0].g[247,0] = i_l_R1_R2_a_i + i_l_R1_R2_b_i + i_l_R1_R2_c_i - i_l_R1_R2_n_i
        struct[0].g[248,0] = -i_l_D1_D3_a_r + 67.7048070412999*v_D1_a_r - 67.7048070412999*v_D3_a_r
        struct[0].g[249,0] = -i_l_D1_D3_a_i + 67.7048070412999*v_D1_a_i - 67.7048070412999*v_D3_a_i
        struct[0].g[250,0] = -i_l_D1_D3_b_r + 67.7048070412999*v_D1_b_r - 67.7048070412999*v_D3_b_r
        struct[0].g[251,0] = -i_l_D1_D3_b_i + 67.7048070412999*v_D1_b_i - 67.7048070412999*v_D3_b_i
        struct[0].g[252,0] = -i_l_D1_D3_c_r + 67.7048070412999*v_D1_c_r - 67.7048070412999*v_D3_c_r
        struct[0].g[253,0] = -i_l_D1_D3_c_i + 67.7048070412999*v_D1_c_i - 67.7048070412999*v_D3_c_i
        struct[0].g[254,0] = i_l_D1_D3_a_r + i_l_D1_D3_b_r + i_l_D1_D3_c_r - i_l_D1_D3_n_r
        struct[0].g[255,0] = i_l_D1_D3_a_i + i_l_D1_D3_b_i + i_l_D1_D3_c_i - i_l_D1_D3_n_i
        struct[0].g[256,0] = -i_l_D3_D4_a_r + 135.4096140826*v_D3_a_r - 135.4096140826*v_D4_a_r
        struct[0].g[257,0] = -i_l_D3_D4_a_i + 135.4096140826*v_D3_a_i - 135.4096140826*v_D4_a_i
        struct[0].g[258,0] = -i_l_D3_D4_b_r + 135.4096140826*v_D3_b_r - 135.4096140826*v_D4_b_r
        struct[0].g[259,0] = -i_l_D3_D4_b_i + 135.4096140826*v_D3_b_i - 135.4096140826*v_D4_b_i
        struct[0].g[260,0] = -i_l_D3_D4_c_r + 135.4096140826*v_D3_c_r - 135.4096140826*v_D4_c_r
        struct[0].g[261,0] = -i_l_D3_D4_c_i + 135.4096140826*v_D3_c_i - 135.4096140826*v_D4_c_i
        struct[0].g[262,0] = i_l_D3_D4_a_r + i_l_D3_D4_b_r + i_l_D3_D4_c_r - i_l_D3_D4_n_r
        struct[0].g[263,0] = i_l_D3_D4_a_i + i_l_D3_D4_b_i + i_l_D3_D4_c_i - i_l_D3_D4_n_i
        struct[0].g[264,0] = -i_l_D4_D6_a_r + 67.7048070412999*v_D4_a_r - 67.7048070412999*v_D6_a_r
        struct[0].g[265,0] = -i_l_D4_D6_a_i + 67.7048070412999*v_D4_a_i - 67.7048070412999*v_D6_a_i
        struct[0].g[266,0] = -i_l_D4_D6_b_r + 67.7048070412999*v_D4_b_r - 67.7048070412999*v_D6_b_r
        struct[0].g[267,0] = -i_l_D4_D6_b_i + 67.7048070412999*v_D4_b_i - 67.7048070412999*v_D6_b_i
        struct[0].g[268,0] = -i_l_D4_D6_c_r + 67.7048070412999*v_D4_c_r - 67.7048070412999*v_D6_c_r
        struct[0].g[269,0] = -i_l_D4_D6_c_i + 67.7048070412999*v_D4_c_i - 67.7048070412999*v_D6_c_i
        struct[0].g[270,0] = i_l_D4_D6_a_r + i_l_D4_D6_b_r + i_l_D4_D6_c_r - i_l_D4_D6_n_r
        struct[0].g[271,0] = i_l_D4_D6_a_i + i_l_D4_D6_b_i + i_l_D4_D6_c_i - i_l_D4_D6_n_i
        struct[0].g[272,0] = -i_l_D6_D9_a_r + 45.1365380275333*v_D6_a_r - 45.1365380275333*v_D9_a_r
        struct[0].g[273,0] = -i_l_D6_D9_a_i + 45.1365380275333*v_D6_a_i - 45.1365380275333*v_D9_a_i
        struct[0].g[274,0] = -i_l_D6_D9_b_r + 45.1365380275333*v_D6_b_r - 45.1365380275333*v_D9_b_r
        struct[0].g[275,0] = -i_l_D6_D9_b_i + 45.1365380275333*v_D6_b_i - 45.1365380275333*v_D9_b_i
        struct[0].g[276,0] = -i_l_D6_D9_c_r + 45.1365380275333*v_D6_c_r - 45.1365380275333*v_D9_c_r
        struct[0].g[277,0] = -i_l_D6_D9_c_i + 45.1365380275333*v_D6_c_i - 45.1365380275333*v_D9_c_i
        struct[0].g[278,0] = i_l_D6_D9_a_r + i_l_D6_D9_b_r + i_l_D6_D9_c_r - i_l_D6_D9_n_r
        struct[0].g[279,0] = i_l_D6_D9_a_i + i_l_D6_D9_b_i + i_l_D6_D9_c_i - i_l_D6_D9_n_i
        struct[0].g[280,0] = -i_l_D9_D10_a_r - 157.977883096366*v_D10_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[281,0] = -i_l_D9_D10_a_i - 157.977883096366*v_D10_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[282,0] = -i_l_D9_D10_b_r - 157.977883096366*v_D10_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[283,0] = -i_l_D9_D10_b_i - 157.977883096366*v_D10_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[284,0] = -i_l_D9_D10_c_r - 157.977883096366*v_D10_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[285,0] = -i_l_D9_D10_c_i - 157.977883096366*v_D10_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[286,0] = i_l_D9_D10_a_r + i_l_D9_D10_b_r + i_l_D9_D10_c_r - i_l_D9_D10_n_r
        struct[0].g[287,0] = i_l_D9_D10_a_i + i_l_D9_D10_b_i + i_l_D9_D10_c_i - i_l_D9_D10_n_i
        struct[0].g[288,0] = -i_l_D3_D11_a_r - 157.977883096366*v_D11_a_r + 157.977883096366*v_D3_a_r
        struct[0].g[289,0] = -i_l_D3_D11_a_i - 157.977883096366*v_D11_a_i + 157.977883096366*v_D3_a_i
        struct[0].g[290,0] = -i_l_D3_D11_b_r - 157.977883096366*v_D11_b_r + 157.977883096366*v_D3_b_r
        struct[0].g[291,0] = -i_l_D3_D11_b_i - 157.977883096366*v_D11_b_i + 157.977883096366*v_D3_b_i
        struct[0].g[292,0] = -i_l_D3_D11_c_r - 157.977883096366*v_D11_c_r + 157.977883096366*v_D3_c_r
        struct[0].g[293,0] = -i_l_D3_D11_c_i - 157.977883096366*v_D11_c_i + 157.977883096366*v_D3_c_i
        struct[0].g[294,0] = i_l_D3_D11_a_r + i_l_D3_D11_b_r + i_l_D3_D11_c_r - i_l_D3_D11_n_r
        struct[0].g[295,0] = i_l_D3_D11_a_i + i_l_D3_D11_b_i + i_l_D3_D11_c_i - i_l_D3_D11_n_i
        struct[0].g[296,0] = -i_l_D6_D16_a_r - 157.977883096366*v_D16_a_r + 157.977883096366*v_D6_a_r
        struct[0].g[297,0] = -i_l_D6_D16_a_i - 157.977883096366*v_D16_a_i + 157.977883096366*v_D6_a_i
        struct[0].g[298,0] = -i_l_D6_D16_b_r - 157.977883096366*v_D16_b_r + 157.977883096366*v_D6_b_r
        struct[0].g[299,0] = -i_l_D6_D16_b_i - 157.977883096366*v_D16_b_i + 157.977883096366*v_D6_b_i
        struct[0].g[300,0] = -i_l_D6_D16_c_r - 157.977883096366*v_D16_c_r + 157.977883096366*v_D6_c_r
        struct[0].g[301,0] = -i_l_D6_D16_c_i - 157.977883096366*v_D16_c_i + 157.977883096366*v_D6_c_i
        struct[0].g[302,0] = i_l_D6_D16_a_r + i_l_D6_D16_b_r + i_l_D6_D16_c_r - i_l_D6_D16_n_r
        struct[0].g[303,0] = i_l_D6_D16_a_i + i_l_D6_D16_b_i + i_l_D6_D16_c_i - i_l_D6_D16_n_i
        struct[0].g[304,0] = -i_l_D9_D17_a_r - 157.977883096366*v_D17_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[305,0] = -i_l_D9_D17_a_i - 157.977883096366*v_D17_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[306,0] = -i_l_D9_D17_b_r - 157.977883096366*v_D17_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[307,0] = -i_l_D9_D17_b_i - 157.977883096366*v_D17_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[308,0] = -i_l_D9_D17_c_r - 157.977883096366*v_D17_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[309,0] = -i_l_D9_D17_c_i - 157.977883096366*v_D17_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[310,0] = i_l_D9_D17_a_r + i_l_D9_D17_b_r + i_l_D9_D17_c_r - i_l_D9_D17_n_r
        struct[0].g[311,0] = i_l_D9_D17_a_i + i_l_D9_D17_b_i + i_l_D9_D17_c_i - i_l_D9_D17_n_i
        struct[0].g[312,0] = -i_l_D10_D18_a_r + 157.977883096366*v_D10_a_r - 157.977883096366*v_D18_a_r
        struct[0].g[313,0] = -i_l_D10_D18_a_i + 157.977883096366*v_D10_a_i - 157.977883096366*v_D18_a_i
        struct[0].g[314,0] = -i_l_D10_D18_b_r + 157.977883096366*v_D10_b_r - 157.977883096366*v_D18_b_r
        struct[0].g[315,0] = -i_l_D10_D18_b_i + 157.977883096366*v_D10_b_i - 157.977883096366*v_D18_b_i
        struct[0].g[316,0] = -i_l_D10_D18_c_r + 157.977883096366*v_D10_c_r - 157.977883096366*v_D18_c_r
        struct[0].g[317,0] = -i_l_D10_D18_c_i + 157.977883096366*v_D10_c_i - 157.977883096366*v_D18_c_i
        struct[0].g[318,0] = i_l_D10_D18_a_r + i_l_D10_D18_b_r + i_l_D10_D18_c_r - i_l_D10_D18_n_r
        struct[0].g[319,0] = i_l_D10_D18_a_i + i_l_D10_D18_b_i + i_l_D10_D18_c_i - i_l_D10_D18_n_i
        struct[0].g[320,0] = -i_l_D4_D14_a_r - 45.1365380275333*v_D14_a_r + 45.1365380275333*v_D4_a_r
        struct[0].g[321,0] = -i_l_D4_D14_a_i - 45.1365380275333*v_D14_a_i + 45.1365380275333*v_D4_a_i
        struct[0].g[322,0] = -i_l_D4_D14_b_r - 45.1365380275333*v_D14_b_r + 45.1365380275333*v_D4_b_r
        struct[0].g[323,0] = -i_l_D4_D14_b_i - 45.1365380275333*v_D14_b_i + 45.1365380275333*v_D4_b_i
        struct[0].g[324,0] = -i_l_D4_D14_c_r - 45.1365380275333*v_D14_c_r + 45.1365380275333*v_D4_c_r
        struct[0].g[325,0] = -i_l_D4_D14_c_i - 45.1365380275333*v_D14_c_i + 45.1365380275333*v_D4_c_i
        struct[0].g[326,0] = i_l_D4_D14_a_r + i_l_D4_D14_b_r + i_l_D4_D14_c_r - i_l_D4_D14_n_r
        struct[0].g[327,0] = i_l_D4_D14_a_i + i_l_D4_D14_b_i + i_l_D4_D14_c_i - i_l_D4_D14_n_i
        struct[0].g[328,0] = -i_l_D14_D15_a_r + 135.4096140826*v_D14_a_r - 135.4096140826*v_D15_a_r
        struct[0].g[329,0] = -i_l_D14_D15_a_i + 135.4096140826*v_D14_a_i - 135.4096140826*v_D15_a_i
        struct[0].g[330,0] = -i_l_D14_D15_b_r + 135.4096140826*v_D14_b_r - 135.4096140826*v_D15_b_r
        struct[0].g[331,0] = -i_l_D14_D15_b_i + 135.4096140826*v_D14_b_i - 135.4096140826*v_D15_b_i
        struct[0].g[332,0] = -i_l_D14_D15_c_r + 135.4096140826*v_D14_c_r - 135.4096140826*v_D15_c_r
        struct[0].g[333,0] = -i_l_D14_D15_c_i + 135.4096140826*v_D14_c_i - 135.4096140826*v_D15_c_i
        struct[0].g[334,0] = i_l_D14_D15_a_r + i_l_D14_D15_b_r + i_l_D14_D15_c_r - i_l_D14_D15_n_r
        struct[0].g[335,0] = i_l_D14_D15_a_i + i_l_D14_D15_b_i + i_l_D14_D15_c_i - i_l_D14_D15_n_i
        struct[0].g[336,0] = i_load_R1_a_i*v_R1_a_i - i_load_R1_a_i*v_R1_n_i + i_load_R1_a_r*v_R1_a_r - i_load_R1_a_r*v_R1_n_r - p_R1_a
        struct[0].g[337,0] = i_load_R1_b_i*v_R1_b_i - i_load_R1_b_i*v_R1_n_i + i_load_R1_b_r*v_R1_b_r - i_load_R1_b_r*v_R1_n_r - p_R1_b
        struct[0].g[338,0] = i_load_R1_c_i*v_R1_c_i - i_load_R1_c_i*v_R1_n_i + i_load_R1_c_r*v_R1_c_r - i_load_R1_c_r*v_R1_n_r - p_R1_c
        struct[0].g[339,0] = -i_load_R1_a_i*v_R1_a_r + i_load_R1_a_i*v_R1_n_r + i_load_R1_a_r*v_R1_a_i - i_load_R1_a_r*v_R1_n_i - q_R1_a
        struct[0].g[340,0] = -i_load_R1_b_i*v_R1_b_r + i_load_R1_b_i*v_R1_n_r + i_load_R1_b_r*v_R1_b_i - i_load_R1_b_r*v_R1_n_i - q_R1_b
        struct[0].g[341,0] = -i_load_R1_c_i*v_R1_c_r + i_load_R1_c_i*v_R1_n_r + i_load_R1_c_r*v_R1_c_i - i_load_R1_c_r*v_R1_n_i - q_R1_c
        struct[0].g[342,0] = i_load_R1_a_r + i_load_R1_b_r + i_load_R1_c_r + i_load_R1_n_r
        struct[0].g[343,0] = i_load_R1_a_i + i_load_R1_b_i + i_load_R1_c_i + i_load_R1_n_i
        struct[0].g[344,0] = i_load_R11_a_i*v_R11_a_i - i_load_R11_a_i*v_R11_n_i + i_load_R11_a_r*v_R11_a_r - i_load_R11_a_r*v_R11_n_r - p_R11_a
        struct[0].g[345,0] = i_load_R11_b_i*v_R11_b_i - i_load_R11_b_i*v_R11_n_i + i_load_R11_b_r*v_R11_b_r - i_load_R11_b_r*v_R11_n_r - p_R11_b
        struct[0].g[346,0] = i_load_R11_c_i*v_R11_c_i - i_load_R11_c_i*v_R11_n_i + i_load_R11_c_r*v_R11_c_r - i_load_R11_c_r*v_R11_n_r - p_R11_c
        struct[0].g[347,0] = -i_load_R11_a_i*v_R11_a_r + i_load_R11_a_i*v_R11_n_r + i_load_R11_a_r*v_R11_a_i - i_load_R11_a_r*v_R11_n_i - q_R11_a
        struct[0].g[348,0] = -i_load_R11_b_i*v_R11_b_r + i_load_R11_b_i*v_R11_n_r + i_load_R11_b_r*v_R11_b_i - i_load_R11_b_r*v_R11_n_i - q_R11_b
        struct[0].g[349,0] = -i_load_R11_c_i*v_R11_c_r + i_load_R11_c_i*v_R11_n_r + i_load_R11_c_r*v_R11_c_i - i_load_R11_c_r*v_R11_n_i - q_R11_c
        struct[0].g[350,0] = i_load_R11_a_r + i_load_R11_b_r + i_load_R11_c_r + i_load_R11_n_r
        struct[0].g[351,0] = i_load_R11_a_i + i_load_R11_b_i + i_load_R11_c_i + i_load_R11_n_i
        struct[0].g[352,0] = i_load_R15_a_i*v_R15_a_i - i_load_R15_a_i*v_R15_n_i + i_load_R15_a_r*v_R15_a_r - i_load_R15_a_r*v_R15_n_r - p_R15_a
        struct[0].g[353,0] = i_load_R15_b_i*v_R15_b_i - i_load_R15_b_i*v_R15_n_i + i_load_R15_b_r*v_R15_b_r - i_load_R15_b_r*v_R15_n_r - p_R15_b
        struct[0].g[354,0] = i_load_R15_c_i*v_R15_c_i - i_load_R15_c_i*v_R15_n_i + i_load_R15_c_r*v_R15_c_r - i_load_R15_c_r*v_R15_n_r - p_R15_c
        struct[0].g[355,0] = -i_load_R15_a_i*v_R15_a_r + i_load_R15_a_i*v_R15_n_r + i_load_R15_a_r*v_R15_a_i - i_load_R15_a_r*v_R15_n_i - q_R15_a
        struct[0].g[356,0] = -i_load_R15_b_i*v_R15_b_r + i_load_R15_b_i*v_R15_n_r + i_load_R15_b_r*v_R15_b_i - i_load_R15_b_r*v_R15_n_i - q_R15_b
        struct[0].g[357,0] = -i_load_R15_c_i*v_R15_c_r + i_load_R15_c_i*v_R15_n_r + i_load_R15_c_r*v_R15_c_i - i_load_R15_c_r*v_R15_n_i - q_R15_c
        struct[0].g[358,0] = i_load_R15_a_r + i_load_R15_b_r + i_load_R15_c_r + i_load_R15_n_r
        struct[0].g[359,0] = i_load_R15_a_i + i_load_R15_b_i + i_load_R15_c_i + i_load_R15_n_i
        struct[0].g[360,0] = i_load_R16_a_i*v_R16_a_i - i_load_R16_a_i*v_R16_n_i + i_load_R16_a_r*v_R16_a_r - i_load_R16_a_r*v_R16_n_r - p_R16_a
        struct[0].g[361,0] = i_load_R16_b_i*v_R16_b_i - i_load_R16_b_i*v_R16_n_i + i_load_R16_b_r*v_R16_b_r - i_load_R16_b_r*v_R16_n_r - p_R16_b
        struct[0].g[362,0] = i_load_R16_c_i*v_R16_c_i - i_load_R16_c_i*v_R16_n_i + i_load_R16_c_r*v_R16_c_r - i_load_R16_c_r*v_R16_n_r - p_R16_c
        struct[0].g[363,0] = -i_load_R16_a_i*v_R16_a_r + i_load_R16_a_i*v_R16_n_r + i_load_R16_a_r*v_R16_a_i - i_load_R16_a_r*v_R16_n_i - q_R16_a
        struct[0].g[364,0] = -i_load_R16_b_i*v_R16_b_r + i_load_R16_b_i*v_R16_n_r + i_load_R16_b_r*v_R16_b_i - i_load_R16_b_r*v_R16_n_i - q_R16_b
        struct[0].g[365,0] = -i_load_R16_c_i*v_R16_c_r + i_load_R16_c_i*v_R16_n_r + i_load_R16_c_r*v_R16_c_i - i_load_R16_c_r*v_R16_n_i - q_R16_c
        struct[0].g[366,0] = i_load_R16_a_r + i_load_R16_b_r + i_load_R16_c_r + i_load_R16_n_r
        struct[0].g[367,0] = i_load_R16_a_i + i_load_R16_b_i + i_load_R16_c_i + i_load_R16_n_i
        struct[0].g[368,0] = i_load_R17_a_i*v_R17_a_i - i_load_R17_a_i*v_R17_n_i + i_load_R17_a_r*v_R17_a_r - i_load_R17_a_r*v_R17_n_r - p_R17_a
        struct[0].g[369,0] = i_load_R17_b_i*v_R17_b_i - i_load_R17_b_i*v_R17_n_i + i_load_R17_b_r*v_R17_b_r - i_load_R17_b_r*v_R17_n_r - p_R17_b
        struct[0].g[370,0] = i_load_R17_c_i*v_R17_c_i - i_load_R17_c_i*v_R17_n_i + i_load_R17_c_r*v_R17_c_r - i_load_R17_c_r*v_R17_n_r - p_R17_c
        struct[0].g[371,0] = -i_load_R17_a_i*v_R17_a_r + i_load_R17_a_i*v_R17_n_r + i_load_R17_a_r*v_R17_a_i - i_load_R17_a_r*v_R17_n_i - q_R17_a
        struct[0].g[372,0] = -i_load_R17_b_i*v_R17_b_r + i_load_R17_b_i*v_R17_n_r + i_load_R17_b_r*v_R17_b_i - i_load_R17_b_r*v_R17_n_i - q_R17_b
        struct[0].g[373,0] = -i_load_R17_c_i*v_R17_c_r + i_load_R17_c_i*v_R17_n_r + i_load_R17_c_r*v_R17_c_i - i_load_R17_c_r*v_R17_n_i - q_R17_c
        struct[0].g[374,0] = i_load_R17_a_r + i_load_R17_b_r + i_load_R17_c_r + i_load_R17_n_r
        struct[0].g[375,0] = i_load_R17_a_i + i_load_R17_b_i + i_load_R17_c_i + i_load_R17_n_i
        struct[0].g[376,0] = i_load_R18_a_i*v_R18_a_i - i_load_R18_a_i*v_R18_n_i + i_load_R18_a_r*v_R18_a_r - i_load_R18_a_r*v_R18_n_r - p_R18_a
        struct[0].g[377,0] = i_load_R18_b_i*v_R18_b_i - i_load_R18_b_i*v_R18_n_i + i_load_R18_b_r*v_R18_b_r - i_load_R18_b_r*v_R18_n_r - p_R18_b
        struct[0].g[378,0] = i_load_R18_c_i*v_R18_c_i - i_load_R18_c_i*v_R18_n_i + i_load_R18_c_r*v_R18_c_r - i_load_R18_c_r*v_R18_n_r - p_R18_c
        struct[0].g[379,0] = -i_load_R18_a_i*v_R18_a_r + i_load_R18_a_i*v_R18_n_r + i_load_R18_a_r*v_R18_a_i - i_load_R18_a_r*v_R18_n_i - q_R18_a
        struct[0].g[380,0] = -i_load_R18_b_i*v_R18_b_r + i_load_R18_b_i*v_R18_n_r + i_load_R18_b_r*v_R18_b_i - i_load_R18_b_r*v_R18_n_i - q_R18_b
        struct[0].g[381,0] = -i_load_R18_c_i*v_R18_c_r + i_load_R18_c_i*v_R18_n_r + i_load_R18_c_r*v_R18_c_i - i_load_R18_c_r*v_R18_n_i - q_R18_c
        struct[0].g[382,0] = i_load_R18_a_r + i_load_R18_b_r + i_load_R18_c_r + i_load_R18_n_r
        struct[0].g[383,0] = i_load_R18_a_i + i_load_R18_b_i + i_load_R18_c_i + i_load_R18_n_i
        struct[0].g[384,0] = 1.0*i_load_D15_a_i*v_D15_a_i - 1.0*i_load_D15_a_i*v_D15_n_i + i_load_D15_a_r*v_D15_a_r - i_load_D15_a_r*v_D15_n_r - p_D15_1
        struct[0].g[385,0] = -1.0*i_load_D15_a_i*v_D15_a_r + 1.0*i_load_D15_a_i*v_D15_n_r + 1.0*i_load_D15_a_r*v_D15_a_i - 1.0*i_load_D15_a_r*v_D15_n_i - q_D15_1
        struct[0].g[386,0] = i_load_D15_a_r + i_load_D15_n_r
        struct[0].g[387,0] = 1.0*i_load_D15_a_i + 1.0*i_load_D15_n_i
        struct[0].g[388,0] = 1.0*i_load_D11_a_i*v_D11_a_i - 1.0*i_load_D11_a_i*v_D11_n_i + i_load_D11_a_r*v_D11_a_r - i_load_D11_a_r*v_D11_n_r - p_D11_1
        struct[0].g[389,0] = -1.0*i_load_D11_a_i*v_D11_a_r + 1.0*i_load_D11_a_i*v_D11_n_r + 1.0*i_load_D11_a_r*v_D11_a_i - 1.0*i_load_D11_a_r*v_D11_n_i - q_D11_1
        struct[0].g[390,0] = i_load_D11_a_r + i_load_D11_n_r
        struct[0].g[391,0] = 1.0*i_load_D11_a_i + 1.0*i_load_D11_n_i
        struct[0].g[392,0] = 1.0*i_load_D16_a_i*v_D16_a_i - 1.0*i_load_D16_a_i*v_D16_n_i + i_load_D16_a_r*v_D16_a_r - i_load_D16_a_r*v_D16_n_r - p_D16_1
        struct[0].g[393,0] = -1.0*i_load_D16_a_i*v_D16_a_r + 1.0*i_load_D16_a_i*v_D16_n_r + 1.0*i_load_D16_a_r*v_D16_a_i - 1.0*i_load_D16_a_r*v_D16_n_i - q_D16_1
        struct[0].g[394,0] = i_load_D16_a_r + i_load_D16_n_r
        struct[0].g[395,0] = 1.0*i_load_D16_a_i + 1.0*i_load_D16_n_i
        struct[0].g[396,0] = 1.0*i_load_D17_a_i*v_D17_a_i - 1.0*i_load_D17_a_i*v_D17_n_i + i_load_D17_a_r*v_D17_a_r - i_load_D17_a_r*v_D17_n_r - p_D17_1
        struct[0].g[397,0] = -1.0*i_load_D17_a_i*v_D17_a_r + 1.0*i_load_D17_a_i*v_D17_n_r + 1.0*i_load_D17_a_r*v_D17_a_i - 1.0*i_load_D17_a_r*v_D17_n_i - q_D17_1
        struct[0].g[398,0] = i_load_D17_a_r + i_load_D17_n_r
        struct[0].g[399,0] = 1.0*i_load_D17_a_i + 1.0*i_load_D17_n_i
        struct[0].g[400,0] = 1.0*i_load_D18_a_i*v_D18_a_i - 1.0*i_load_D18_a_i*v_D18_n_i + i_load_D18_a_r*v_D18_a_r - i_load_D18_a_r*v_D18_n_r - p_D18_1
        struct[0].g[401,0] = -1.0*i_load_D18_a_i*v_D18_a_r + 1.0*i_load_D18_a_i*v_D18_n_r + 1.0*i_load_D18_a_r*v_D18_a_i - 1.0*i_load_D18_a_r*v_D18_n_i - q_D18_1
        struct[0].g[402,0] = i_load_D18_a_r + i_load_D18_n_r
        struct[0].g[403,0] = 1.0*i_load_D18_a_i + 1.0*i_load_D18_n_i
        struct[0].g[404,0] = 1.0*i_vsc_R1_a_i*v_R1_a_i - 1.0*i_vsc_R1_a_i*v_R1_n_i + i_vsc_R1_a_r*v_R1_a_r - i_vsc_R1_a_r*v_R1_n_r - p_R1/3
        struct[0].g[405,0] = -1.0*i_vsc_R1_a_i*v_R1_a_r + 1.0*i_vsc_R1_a_i*v_R1_n_r + 1.0*i_vsc_R1_a_r*v_R1_a_i - 1.0*i_vsc_R1_a_r*v_R1_n_i - q_R1/3
        struct[0].g[406,0] = 1.0*i_vsc_R1_b_i*v_R1_b_i - 1.0*i_vsc_R1_b_i*v_R1_n_i + i_vsc_R1_b_r*v_R1_b_r - i_vsc_R1_b_r*v_R1_n_r - p_R1/3
        struct[0].g[407,0] = -1.0*i_vsc_R1_b_i*v_R1_b_r + 1.0*i_vsc_R1_b_i*v_R1_n_r + 1.0*i_vsc_R1_b_r*v_R1_b_i - 1.0*i_vsc_R1_b_r*v_R1_n_i - q_R1/3
        struct[0].g[408,0] = 1.0*i_vsc_R1_c_i*v_R1_c_i - 1.0*i_vsc_R1_c_i*v_R1_n_i + i_vsc_R1_c_r*v_R1_c_r - i_vsc_R1_c_r*v_R1_n_r - p_R1/3
        struct[0].g[409,0] = -1.0*i_vsc_R1_c_i*v_R1_c_r + 1.0*i_vsc_R1_c_i*v_R1_n_r + 1.0*i_vsc_R1_c_r*v_R1_c_i - 1.0*i_vsc_R1_c_r*v_R1_n_i - q_R1/3
        struct[0].g[410,0] = p_D1 + p_R1 + Piecewise(np.array([(-p_loss_R1, p_D1 < 0), (p_loss_R1, True)]))
        struct[0].g[411,0] = i_l_D1_D3_a_r*v_D1_a_r + i_l_D1_D3_n_r*v_D1_n_r - p_D1
        struct[0].g[412,0] = -a_R1 - b_R1*sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - c_R1*(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) + p_loss_R1
        struct[0].g[413,0] = -coef_a_R10*p_R10 + 1.0*i_vsc_R10_a_i*v_R10_a_i - 1.0*i_vsc_R10_a_i*v_R10_n_i + i_vsc_R10_a_r*v_R10_a_r - i_vsc_R10_a_r*v_R10_n_r
        struct[0].g[414,0] = -coef_a_R10*q_R10 - 1.0*i_vsc_R10_a_i*v_R10_a_r + 1.0*i_vsc_R10_a_i*v_R10_n_r + 1.0*i_vsc_R10_a_r*v_R10_a_i - 1.0*i_vsc_R10_a_r*v_R10_n_i
        struct[0].g[415,0] = -coef_b_R10*p_R10 + 1.0*i_vsc_R10_b_i*v_R10_b_i - 1.0*i_vsc_R10_b_i*v_R10_n_i + i_vsc_R10_b_r*v_R10_b_r - i_vsc_R10_b_r*v_R10_n_r
        struct[0].g[416,0] = -coef_b_R10*q_R10 - 1.0*i_vsc_R10_b_i*v_R10_b_r + 1.0*i_vsc_R10_b_i*v_R10_n_r + 1.0*i_vsc_R10_b_r*v_R10_b_i - 1.0*i_vsc_R10_b_r*v_R10_n_i
        struct[0].g[417,0] = -coef_c_R10*p_R10 + 1.0*i_vsc_R10_c_i*v_R10_c_i - 1.0*i_vsc_R10_c_i*v_R10_n_i + i_vsc_R10_c_r*v_R10_c_r - i_vsc_R10_c_r*v_R10_n_r
        struct[0].g[418,0] = -coef_c_R10*q_R10 - 1.0*i_vsc_R10_c_i*v_R10_c_r + 1.0*i_vsc_R10_c_i*v_R10_n_r + 1.0*i_vsc_R10_c_r*v_R10_c_i - 1.0*i_vsc_R10_c_r*v_R10_n_i
        struct[0].g[419,0] = i_vsc_D10_a_r + p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].g[420,0] = i_vsc_D10_n_r + p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].g[421,0] = p_D10 - p_R10 - Piecewise(np.array([(-p_loss_R10, p_D10 < 0), (p_loss_R10, True)]))
        struct[0].g[422,0] = -a_R10 - b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + p_loss_R10
        struct[0].g[423,0] = -coef_a_R14*p_R14 + 1.0*i_vsc_R14_a_i*v_R14_a_i - 1.0*i_vsc_R14_a_i*v_R14_n_i + i_vsc_R14_a_r*v_R14_a_r - i_vsc_R14_a_r*v_R14_n_r
        struct[0].g[424,0] = -coef_a_R14*q_R14 - 1.0*i_vsc_R14_a_i*v_R14_a_r + 1.0*i_vsc_R14_a_i*v_R14_n_r + 1.0*i_vsc_R14_a_r*v_R14_a_i - 1.0*i_vsc_R14_a_r*v_R14_n_i
        struct[0].g[425,0] = -coef_b_R14*p_R14 + 1.0*i_vsc_R14_b_i*v_R14_b_i - 1.0*i_vsc_R14_b_i*v_R14_n_i + i_vsc_R14_b_r*v_R14_b_r - i_vsc_R14_b_r*v_R14_n_r
        struct[0].g[426,0] = -coef_b_R14*q_R14 - 1.0*i_vsc_R14_b_i*v_R14_b_r + 1.0*i_vsc_R14_b_i*v_R14_n_r + 1.0*i_vsc_R14_b_r*v_R14_b_i - 1.0*i_vsc_R14_b_r*v_R14_n_i
        struct[0].g[427,0] = -coef_c_R14*p_R14 + 1.0*i_vsc_R14_c_i*v_R14_c_i - 1.0*i_vsc_R14_c_i*v_R14_n_i + i_vsc_R14_c_r*v_R14_c_r - i_vsc_R14_c_r*v_R14_n_r
        struct[0].g[428,0] = -coef_c_R14*q_R14 - 1.0*i_vsc_R14_c_i*v_R14_c_r + 1.0*i_vsc_R14_c_i*v_R14_n_r + 1.0*i_vsc_R14_c_r*v_R14_c_i - 1.0*i_vsc_R14_c_r*v_R14_n_i
        struct[0].g[429,0] = i_vsc_D14_a_r + p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].g[430,0] = i_vsc_D14_n_r + p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].g[431,0] = p_D14 - p_R14 - Piecewise(np.array([(-p_loss_R14, p_D14 < 0), (p_loss_R14, True)]))
        struct[0].g[432,0] = -a_R14 - b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + p_loss_R14
    
    # Outputs:
    if mode == 3:

        struct[0].h[0,0] = (v_R0_a_i**2 + v_R0_a_r**2)**0.5
        struct[0].h[1,0] = (v_R0_b_i**2 + v_R0_b_r**2)**0.5
        struct[0].h[2,0] = (v_R0_c_i**2 + v_R0_c_r**2)**0.5
        struct[0].h[3,0] = (v_D1_a_i**2 + v_D1_a_r**2)**0.5
        struct[0].h[4,0] = (v_D1_b_i**2 + v_D1_b_r**2)**0.5
        struct[0].h[5,0] = (v_D1_c_i**2 + v_D1_c_r**2)**0.5
        struct[0].h[6,0] = (v_R1_a_i**2 + v_R1_a_r**2)**0.5
        struct[0].h[7,0] = (v_R1_b_i**2 + v_R1_b_r**2)**0.5
        struct[0].h[8,0] = (v_R1_c_i**2 + v_R1_c_r**2)**0.5
        struct[0].h[9,0] = (v_R1_n_i**2 + v_R1_n_r**2)**0.5
        struct[0].h[10,0] = (v_R11_a_i**2 + v_R11_a_r**2)**0.5
        struct[0].h[11,0] = (v_R11_b_i**2 + v_R11_b_r**2)**0.5
        struct[0].h[12,0] = (v_R11_c_i**2 + v_R11_c_r**2)**0.5
        struct[0].h[13,0] = (v_R11_n_i**2 + v_R11_n_r**2)**0.5
        struct[0].h[14,0] = (v_R15_a_i**2 + v_R15_a_r**2)**0.5
        struct[0].h[15,0] = (v_R15_b_i**2 + v_R15_b_r**2)**0.5
        struct[0].h[16,0] = (v_R15_c_i**2 + v_R15_c_r**2)**0.5
        struct[0].h[17,0] = (v_R15_n_i**2 + v_R15_n_r**2)**0.5
        struct[0].h[18,0] = (v_R16_a_i**2 + v_R16_a_r**2)**0.5
        struct[0].h[19,0] = (v_R16_b_i**2 + v_R16_b_r**2)**0.5
        struct[0].h[20,0] = (v_R16_c_i**2 + v_R16_c_r**2)**0.5
        struct[0].h[21,0] = (v_R16_n_i**2 + v_R16_n_r**2)**0.5
        struct[0].h[22,0] = (v_R17_a_i**2 + v_R17_a_r**2)**0.5
        struct[0].h[23,0] = (v_R17_b_i**2 + v_R17_b_r**2)**0.5
        struct[0].h[24,0] = (v_R17_c_i**2 + v_R17_c_r**2)**0.5
        struct[0].h[25,0] = (v_R17_n_i**2 + v_R17_n_r**2)**0.5
        struct[0].h[26,0] = (v_R18_a_i**2 + v_R18_a_r**2)**0.5
        struct[0].h[27,0] = (v_R18_b_i**2 + v_R18_b_r**2)**0.5
        struct[0].h[28,0] = (v_R18_c_i**2 + v_R18_c_r**2)**0.5
        struct[0].h[29,0] = (v_R18_n_i**2 + v_R18_n_r**2)**0.5
        struct[0].h[30,0] = (v_D15_a_i**2 + v_D15_a_r**2)**0.5
        struct[0].h[31,0] = (v_D15_n_i**2 + v_D15_n_r**2)**0.5
        struct[0].h[32,0] = (v_D11_a_i**2 + v_D11_a_r**2)**0.5
        struct[0].h[33,0] = (v_D11_n_i**2 + v_D11_n_r**2)**0.5
        struct[0].h[34,0] = (v_D16_a_i**2 + v_D16_a_r**2)**0.5
        struct[0].h[35,0] = (v_D16_n_i**2 + v_D16_n_r**2)**0.5
        struct[0].h[36,0] = (v_D17_a_i**2 + v_D17_a_r**2)**0.5
        struct[0].h[37,0] = (v_D17_n_i**2 + v_D17_n_r**2)**0.5
        struct[0].h[38,0] = (v_D18_a_i**2 + v_D18_a_r**2)**0.5
        struct[0].h[39,0] = (v_D18_n_i**2 + v_D18_n_r**2)**0.5
        struct[0].h[40,0] = (v_R2_a_i**2 + v_R2_a_r**2)**0.5
        struct[0].h[41,0] = (v_R2_b_i**2 + v_R2_b_r**2)**0.5
        struct[0].h[42,0] = (v_R2_c_i**2 + v_R2_c_r**2)**0.5
        struct[0].h[43,0] = (v_R2_n_i**2 + v_R2_n_r**2)**0.5
        struct[0].h[44,0] = (v_R3_a_i**2 + v_R3_a_r**2)**0.5
        struct[0].h[45,0] = (v_R3_b_i**2 + v_R3_b_r**2)**0.5
        struct[0].h[46,0] = (v_R3_c_i**2 + v_R3_c_r**2)**0.5
        struct[0].h[47,0] = (v_R3_n_i**2 + v_R3_n_r**2)**0.5
        struct[0].h[48,0] = (v_R4_a_i**2 + v_R4_a_r**2)**0.5
        struct[0].h[49,0] = (v_R4_b_i**2 + v_R4_b_r**2)**0.5
        struct[0].h[50,0] = (v_R4_c_i**2 + v_R4_c_r**2)**0.5
        struct[0].h[51,0] = (v_R4_n_i**2 + v_R4_n_r**2)**0.5
        struct[0].h[52,0] = (v_R5_a_i**2 + v_R5_a_r**2)**0.5
        struct[0].h[53,0] = (v_R5_b_i**2 + v_R5_b_r**2)**0.5
        struct[0].h[54,0] = (v_R5_c_i**2 + v_R5_c_r**2)**0.5
        struct[0].h[55,0] = (v_R5_n_i**2 + v_R5_n_r**2)**0.5
        struct[0].h[56,0] = (v_R6_a_i**2 + v_R6_a_r**2)**0.5
        struct[0].h[57,0] = (v_R6_b_i**2 + v_R6_b_r**2)**0.5
        struct[0].h[58,0] = (v_R6_c_i**2 + v_R6_c_r**2)**0.5
        struct[0].h[59,0] = (v_R6_n_i**2 + v_R6_n_r**2)**0.5
        struct[0].h[60,0] = (v_R7_a_i**2 + v_R7_a_r**2)**0.5
        struct[0].h[61,0] = (v_R7_b_i**2 + v_R7_b_r**2)**0.5
        struct[0].h[62,0] = (v_R7_c_i**2 + v_R7_c_r**2)**0.5
        struct[0].h[63,0] = (v_R7_n_i**2 + v_R7_n_r**2)**0.5
        struct[0].h[64,0] = (v_R8_a_i**2 + v_R8_a_r**2)**0.5
        struct[0].h[65,0] = (v_R8_b_i**2 + v_R8_b_r**2)**0.5
        struct[0].h[66,0] = (v_R8_c_i**2 + v_R8_c_r**2)**0.5
        struct[0].h[67,0] = (v_R8_n_i**2 + v_R8_n_r**2)**0.5
        struct[0].h[68,0] = (v_R9_a_i**2 + v_R9_a_r**2)**0.5
        struct[0].h[69,0] = (v_R9_b_i**2 + v_R9_b_r**2)**0.5
        struct[0].h[70,0] = (v_R9_c_i**2 + v_R9_c_r**2)**0.5
        struct[0].h[71,0] = (v_R9_n_i**2 + v_R9_n_r**2)**0.5
        struct[0].h[72,0] = (v_R10_a_i**2 + v_R10_a_r**2)**0.5
        struct[0].h[73,0] = (v_R10_b_i**2 + v_R10_b_r**2)**0.5
        struct[0].h[74,0] = (v_R10_c_i**2 + v_R10_c_r**2)**0.5
        struct[0].h[75,0] = (v_R10_n_i**2 + v_R10_n_r**2)**0.5
        struct[0].h[76,0] = (v_R12_a_i**2 + v_R12_a_r**2)**0.5
        struct[0].h[77,0] = (v_R12_b_i**2 + v_R12_b_r**2)**0.5
        struct[0].h[78,0] = (v_R12_c_i**2 + v_R12_c_r**2)**0.5
        struct[0].h[79,0] = (v_R12_n_i**2 + v_R12_n_r**2)**0.5
        struct[0].h[80,0] = (v_R13_a_i**2 + v_R13_a_r**2)**0.5
        struct[0].h[81,0] = (v_R13_b_i**2 + v_R13_b_r**2)**0.5
        struct[0].h[82,0] = (v_R13_c_i**2 + v_R13_c_r**2)**0.5
        struct[0].h[83,0] = (v_R13_n_i**2 + v_R13_n_r**2)**0.5
        struct[0].h[84,0] = (v_R14_a_i**2 + v_R14_a_r**2)**0.5
        struct[0].h[85,0] = (v_R14_b_i**2 + v_R14_b_r**2)**0.5
        struct[0].h[86,0] = (v_R14_c_i**2 + v_R14_c_r**2)**0.5
        struct[0].h[87,0] = (v_R14_n_i**2 + v_R14_n_r**2)**0.5
        struct[0].h[88,0] = (v_D1_n_i**2 + v_D1_n_r**2)**0.5
        struct[0].h[89,0] = (v_D3_a_i**2 + v_D3_a_r**2)**0.5
        struct[0].h[90,0] = (v_D3_b_i**2 + v_D3_b_r**2)**0.5
        struct[0].h[91,0] = (v_D3_c_i**2 + v_D3_c_r**2)**0.5
        struct[0].h[92,0] = (v_D3_n_i**2 + v_D3_n_r**2)**0.5
        struct[0].h[93,0] = (v_D4_a_i**2 + v_D4_a_r**2)**0.5
        struct[0].h[94,0] = (v_D4_b_i**2 + v_D4_b_r**2)**0.5
        struct[0].h[95,0] = (v_D4_c_i**2 + v_D4_c_r**2)**0.5
        struct[0].h[96,0] = (v_D4_n_i**2 + v_D4_n_r**2)**0.5
        struct[0].h[97,0] = (v_D6_a_i**2 + v_D6_a_r**2)**0.5
        struct[0].h[98,0] = (v_D6_b_i**2 + v_D6_b_r**2)**0.5
        struct[0].h[99,0] = (v_D6_c_i**2 + v_D6_c_r**2)**0.5
        struct[0].h[100,0] = (v_D6_n_i**2 + v_D6_n_r**2)**0.5
        struct[0].h[101,0] = (v_D9_a_i**2 + v_D9_a_r**2)**0.5
        struct[0].h[102,0] = (v_D9_b_i**2 + v_D9_b_r**2)**0.5
        struct[0].h[103,0] = (v_D9_c_i**2 + v_D9_c_r**2)**0.5
        struct[0].h[104,0] = (v_D9_n_i**2 + v_D9_n_r**2)**0.5
        struct[0].h[105,0] = (v_D10_a_i**2 + v_D10_a_r**2)**0.5
        struct[0].h[106,0] = (v_D10_b_i**2 + v_D10_b_r**2)**0.5
        struct[0].h[107,0] = (v_D10_c_i**2 + v_D10_c_r**2)**0.5
        struct[0].h[108,0] = (v_D10_n_i**2 + v_D10_n_r**2)**0.5
        struct[0].h[109,0] = (v_D11_b_i**2 + v_D11_b_r**2)**0.5
        struct[0].h[110,0] = (v_D11_c_i**2 + v_D11_c_r**2)**0.5
        struct[0].h[111,0] = (v_D16_b_i**2 + v_D16_b_r**2)**0.5
        struct[0].h[112,0] = (v_D16_c_i**2 + v_D16_c_r**2)**0.5
        struct[0].h[113,0] = (v_D17_b_i**2 + v_D17_b_r**2)**0.5
        struct[0].h[114,0] = (v_D17_c_i**2 + v_D17_c_r**2)**0.5
        struct[0].h[115,0] = (v_D18_b_i**2 + v_D18_b_r**2)**0.5
        struct[0].h[116,0] = (v_D18_c_i**2 + v_D18_c_r**2)**0.5
        struct[0].h[117,0] = (v_D14_a_i**2 + v_D14_a_r**2)**0.5
        struct[0].h[118,0] = (v_D14_b_i**2 + v_D14_b_r**2)**0.5
        struct[0].h[119,0] = (v_D14_c_i**2 + v_D14_c_r**2)**0.5
        struct[0].h[120,0] = (v_D14_n_i**2 + v_D14_n_r**2)**0.5
        struct[0].h[121,0] = (v_D15_b_i**2 + v_D15_b_r**2)**0.5
        struct[0].h[122,0] = (v_D15_c_i**2 + v_D15_c_r**2)**0.5
    

    if mode == 10:

        struct[0].Fx_ini[0,0] = -1

    if mode == 11:


        struct[0].Gy_ini[0,0] = -123.954122254357
        struct[0].Gy_ini[0,1] = -127.595184532966
        struct[0].Gy_ini[0,2] = 39.6392229058202
        struct[0].Gy_ini[0,3] = 10.2713736253513
        struct[0].Gy_ini[0,4] = 24.9575997948692
        struct[0].Gy_ini[0,5] = 23.2849644809540
        struct[0].Gy_ini[0,6] = 58.0215758469966
        struct[0].Gy_ini[0,7] = 83.8007853900572
        struct[0].Gy_ini[0,68] = 105.571769313180
        struct[0].Gy_ini[0,69] = 54.0657727682604
        struct[0].Gy_ini[0,70] = -39.6392229058202
        struct[0].Gy_ini[0,71] = -10.2713736253513
        struct[0].Gy_ini[0,72] = -24.9575997948692
        struct[0].Gy_ini[0,73] = -23.2849644809540
        struct[0].Gy_ini[0,74] = -39.6392229058202
        struct[0].Gy_ini[0,75] = -10.2713736253513
        struct[0].Gy_ini[0,336] = 1
        struct[0].Gy_ini[0,404] = 1
        struct[0].Gy_ini[1,0] = 127.595184532966
        struct[0].Gy_ini[1,1] = -123.954122254357
        struct[0].Gy_ini[1,2] = -10.2713736253513
        struct[0].Gy_ini[1,3] = 39.6392229058202
        struct[0].Gy_ini[1,4] = -23.2849644809540
        struct[0].Gy_ini[1,5] = 24.9575997948692
        struct[0].Gy_ini[1,6] = -83.8007853900572
        struct[0].Gy_ini[1,7] = 58.0215758469966
        struct[0].Gy_ini[1,68] = -54.0657727682604
        struct[0].Gy_ini[1,69] = 105.571769313180
        struct[0].Gy_ini[1,70] = 10.2713736253513
        struct[0].Gy_ini[1,71] = -39.6392229058202
        struct[0].Gy_ini[1,72] = 23.2849644809540
        struct[0].Gy_ini[1,73] = -24.9575997948692
        struct[0].Gy_ini[1,74] = 10.2713736253513
        struct[0].Gy_ini[1,75] = -39.6392229058202
        struct[0].Gy_ini[1,337] = 1
        struct[0].Gy_ini[1,405] = 1
        struct[0].Gy_ini[2,0] = 39.6392229058202
        struct[0].Gy_ini[2,1] = 10.2713736253513
        struct[0].Gy_ini[2,2] = -123.954122254357
        struct[0].Gy_ini[2,3] = -127.595184532966
        struct[0].Gy_ini[2,4] = 39.6392229058201
        struct[0].Gy_ini[2,5] = 10.2713736253513
        struct[0].Gy_ini[2,6] = 43.3399527360457
        struct[0].Gy_ini[2,7] = 96.8143762456598
        struct[0].Gy_ini[2,68] = -39.6392229058202
        struct[0].Gy_ini[2,69] = -10.2713736253513
        struct[0].Gy_ini[2,70] = 105.571769313180
        struct[0].Gy_ini[2,71] = 54.0657727682604
        struct[0].Gy_ini[2,72] = -39.6392229058201
        struct[0].Gy_ini[2,73] = -10.2713736253513
        struct[0].Gy_ini[2,74] = -24.9575997948692
        struct[0].Gy_ini[2,75] = -23.2849644809540
        struct[0].Gy_ini[2,338] = 1
        struct[0].Gy_ini[2,406] = 1
        struct[0].Gy_ini[3,0] = -10.2713736253513
        struct[0].Gy_ini[3,1] = 39.6392229058202
        struct[0].Gy_ini[3,2] = 127.595184532966
        struct[0].Gy_ini[3,3] = -123.954122254357
        struct[0].Gy_ini[3,4] = -10.2713736253513
        struct[0].Gy_ini[3,5] = 39.6392229058201
        struct[0].Gy_ini[3,6] = -96.8143762456598
        struct[0].Gy_ini[3,7] = 43.3399527360457
        struct[0].Gy_ini[3,68] = 10.2713736253513
        struct[0].Gy_ini[3,69] = -39.6392229058202
        struct[0].Gy_ini[3,70] = -54.0657727682604
        struct[0].Gy_ini[3,71] = 105.571769313180
        struct[0].Gy_ini[3,72] = 10.2713736253513
        struct[0].Gy_ini[3,73] = -39.6392229058201
        struct[0].Gy_ini[3,74] = 23.2849644809540
        struct[0].Gy_ini[3,75] = -24.9575997948692
        struct[0].Gy_ini[3,339] = 1
        struct[0].Gy_ini[3,407] = 1
        struct[0].Gy_ini[4,0] = 24.9575997948692
        struct[0].Gy_ini[4,1] = 23.2849644809540
        struct[0].Gy_ini[4,2] = 39.6392229058202
        struct[0].Gy_ini[4,3] = 10.2713736253513
        struct[0].Gy_ini[4,4] = -123.954122254357
        struct[0].Gy_ini[4,5] = -127.595184532966
        struct[0].Gy_ini[4,6] = 58.0215758469966
        struct[0].Gy_ini[4,7] = 83.8007853900572
        struct[0].Gy_ini[4,68] = -24.9575997948692
        struct[0].Gy_ini[4,69] = -23.2849644809540
        struct[0].Gy_ini[4,70] = -39.6392229058202
        struct[0].Gy_ini[4,71] = -10.2713736253513
        struct[0].Gy_ini[4,72] = 105.571769313180
        struct[0].Gy_ini[4,73] = 54.0657727682604
        struct[0].Gy_ini[4,74] = -39.6392229058201
        struct[0].Gy_ini[4,75] = -10.2713736253514
        struct[0].Gy_ini[4,340] = 1
        struct[0].Gy_ini[4,408] = 1
        struct[0].Gy_ini[5,0] = -23.2849644809540
        struct[0].Gy_ini[5,1] = 24.9575997948692
        struct[0].Gy_ini[5,2] = -10.2713736253513
        struct[0].Gy_ini[5,3] = 39.6392229058202
        struct[0].Gy_ini[5,4] = 127.595184532966
        struct[0].Gy_ini[5,5] = -123.954122254357
        struct[0].Gy_ini[5,6] = -83.8007853900572
        struct[0].Gy_ini[5,7] = 58.0215758469966
        struct[0].Gy_ini[5,68] = 23.2849644809540
        struct[0].Gy_ini[5,69] = -24.9575997948692
        struct[0].Gy_ini[5,70] = 10.2713736253513
        struct[0].Gy_ini[5,71] = -39.6392229058202
        struct[0].Gy_ini[5,72] = -54.0657727682604
        struct[0].Gy_ini[5,73] = 105.571769313180
        struct[0].Gy_ini[5,74] = 10.2713736253514
        struct[0].Gy_ini[5,75] = -39.6392229058201
        struct[0].Gy_ini[5,341] = 1
        struct[0].Gy_ini[5,409] = 1
        struct[0].Gy_ini[6,0] = 58.0215758469966
        struct[0].Gy_ini[6,1] = 83.8007853900572
        struct[0].Gy_ini[6,2] = 43.3399527360457
        struct[0].Gy_ini[6,3] = 96.8143762456598
        struct[0].Gy_ini[6,4] = 58.0215758469966
        struct[0].Gy_ini[6,5] = 83.8007853900572
        struct[0].Gy_ini[6,6] = -161.052161470043
        struct[0].Gy_ini[6,7] = -274.654008062378
        struct[0].Gy_ini[6,68] = -39.6392229058202
        struct[0].Gy_ini[6,69] = -10.2713736253513
        struct[0].Gy_ini[6,70] = -24.9575997948692
        struct[0].Gy_ini[6,71] = -23.2849644809540
        struct[0].Gy_ini[6,72] = -39.6392229058202
        struct[0].Gy_ini[6,73] = -10.2713736253513
        struct[0].Gy_ini[6,74] = 105.571769313180
        struct[0].Gy_ini[6,75] = 54.0657727682604
        struct[0].Gy_ini[7,0] = -83.8007853900572
        struct[0].Gy_ini[7,1] = 58.0215758469966
        struct[0].Gy_ini[7,2] = -96.8143762456598
        struct[0].Gy_ini[7,3] = 43.3399527360457
        struct[0].Gy_ini[7,4] = -83.8007853900572
        struct[0].Gy_ini[7,5] = 58.0215758469966
        struct[0].Gy_ini[7,6] = 274.654008062378
        struct[0].Gy_ini[7,7] = -161.052161470043
        struct[0].Gy_ini[7,68] = 10.2713736253513
        struct[0].Gy_ini[7,69] = -39.6392229058202
        struct[0].Gy_ini[7,70] = 23.2849644809540
        struct[0].Gy_ini[7,71] = -24.9575997948692
        struct[0].Gy_ini[7,72] = 10.2713736253513
        struct[0].Gy_ini[7,73] = -39.6392229058202
        struct[0].Gy_ini[7,74] = -54.0657727682604
        struct[0].Gy_ini[7,75] = 105.571769313180
        struct[0].Gy_ini[8,8] = -26.5300693004806
        struct[0].Gy_ini[8,9] = -4.84676915585801
        struct[0].Gy_ini[8,10] = 7.89461337514770
        struct[0].Gy_ini[8,11] = -1.58482814504483
        struct[0].Gy_ini[8,12] = 7.72144347466701
        struct[0].Gy_ini[8,13] = -0.679918453285310
        struct[0].Gy_ini[8,14] = 7.89461337514771
        struct[0].Gy_ini[8,15] = -1.58482814504483
        struct[0].Gy_ini[8,76] = 26.5300693004806
        struct[0].Gy_ini[8,77] = 4.84676915585801
        struct[0].Gy_ini[8,78] = -7.89461337514770
        struct[0].Gy_ini[8,79] = 1.58482814504483
        struct[0].Gy_ini[8,80] = -7.72144347466701
        struct[0].Gy_ini[8,81] = 0.679918453285310
        struct[0].Gy_ini[8,82] = -7.89461337514771
        struct[0].Gy_ini[8,83] = 1.58482814504483
        struct[0].Gy_ini[8,344] = 1
        struct[0].Gy_ini[9,8] = 4.84676915585801
        struct[0].Gy_ini[9,9] = -26.5300693004806
        struct[0].Gy_ini[9,10] = 1.58482814504483
        struct[0].Gy_ini[9,11] = 7.89461337514770
        struct[0].Gy_ini[9,12] = 0.679918453285310
        struct[0].Gy_ini[9,13] = 7.72144347466701
        struct[0].Gy_ini[9,14] = 1.58482814504483
        struct[0].Gy_ini[9,15] = 7.89461337514771
        struct[0].Gy_ini[9,76] = -4.84676915585801
        struct[0].Gy_ini[9,77] = 26.5300693004806
        struct[0].Gy_ini[9,78] = -1.58482814504483
        struct[0].Gy_ini[9,79] = -7.89461337514770
        struct[0].Gy_ini[9,80] = -0.679918453285310
        struct[0].Gy_ini[9,81] = -7.72144347466701
        struct[0].Gy_ini[9,82] = -1.58482814504483
        struct[0].Gy_ini[9,83] = -7.89461337514771
        struct[0].Gy_ini[9,345] = 1
        struct[0].Gy_ini[10,8] = 7.89461337514771
        struct[0].Gy_ini[10,9] = -1.58482814504483
        struct[0].Gy_ini[10,10] = -26.5300693004806
        struct[0].Gy_ini[10,11] = -4.84676915585801
        struct[0].Gy_ini[10,12] = 7.89461337514771
        struct[0].Gy_ini[10,13] = -1.58482814504483
        struct[0].Gy_ini[10,14] = 7.72144347466701
        struct[0].Gy_ini[10,15] = -0.679918453285308
        struct[0].Gy_ini[10,76] = -7.89461337514771
        struct[0].Gy_ini[10,77] = 1.58482814504483
        struct[0].Gy_ini[10,78] = 26.5300693004806
        struct[0].Gy_ini[10,79] = 4.84676915585801
        struct[0].Gy_ini[10,80] = -7.89461337514771
        struct[0].Gy_ini[10,81] = 1.58482814504483
        struct[0].Gy_ini[10,82] = -7.72144347466701
        struct[0].Gy_ini[10,83] = 0.679918453285308
        struct[0].Gy_ini[10,346] = 1
        struct[0].Gy_ini[11,8] = 1.58482814504483
        struct[0].Gy_ini[11,9] = 7.89461337514771
        struct[0].Gy_ini[11,10] = 4.84676915585801
        struct[0].Gy_ini[11,11] = -26.5300693004806
        struct[0].Gy_ini[11,12] = 1.58482814504483
        struct[0].Gy_ini[11,13] = 7.89461337514771
        struct[0].Gy_ini[11,14] = 0.679918453285308
        struct[0].Gy_ini[11,15] = 7.72144347466701
        struct[0].Gy_ini[11,76] = -1.58482814504483
        struct[0].Gy_ini[11,77] = -7.89461337514771
        struct[0].Gy_ini[11,78] = -4.84676915585801
        struct[0].Gy_ini[11,79] = 26.5300693004806
        struct[0].Gy_ini[11,80] = -1.58482814504483
        struct[0].Gy_ini[11,81] = -7.89461337514771
        struct[0].Gy_ini[11,82] = -0.679918453285308
        struct[0].Gy_ini[11,83] = -7.72144347466701
        struct[0].Gy_ini[11,347] = 1
        struct[0].Gy_ini[12,8] = 7.72144347466701
        struct[0].Gy_ini[12,9] = -0.679918453285310
        struct[0].Gy_ini[12,10] = 7.89461337514770
        struct[0].Gy_ini[12,11] = -1.58482814504483
        struct[0].Gy_ini[12,12] = -26.5300693004806
        struct[0].Gy_ini[12,13] = -4.84676915585801
        struct[0].Gy_ini[12,14] = 7.89461337514771
        struct[0].Gy_ini[12,15] = -1.58482814504483
        struct[0].Gy_ini[12,76] = -7.72144347466701
        struct[0].Gy_ini[12,77] = 0.679918453285310
        struct[0].Gy_ini[12,78] = -7.89461337514770
        struct[0].Gy_ini[12,79] = 1.58482814504483
        struct[0].Gy_ini[12,80] = 26.5300693004806
        struct[0].Gy_ini[12,81] = 4.84676915585801
        struct[0].Gy_ini[12,82] = -7.89461337514771
        struct[0].Gy_ini[12,83] = 1.58482814504483
        struct[0].Gy_ini[12,348] = 1
        struct[0].Gy_ini[13,8] = 0.679918453285310
        struct[0].Gy_ini[13,9] = 7.72144347466701
        struct[0].Gy_ini[13,10] = 1.58482814504483
        struct[0].Gy_ini[13,11] = 7.89461337514770
        struct[0].Gy_ini[13,12] = 4.84676915585801
        struct[0].Gy_ini[13,13] = -26.5300693004806
        struct[0].Gy_ini[13,14] = 1.58482814504483
        struct[0].Gy_ini[13,15] = 7.89461337514771
        struct[0].Gy_ini[13,76] = -0.679918453285310
        struct[0].Gy_ini[13,77] = -7.72144347466701
        struct[0].Gy_ini[13,78] = -1.58482814504483
        struct[0].Gy_ini[13,79] = -7.89461337514770
        struct[0].Gy_ini[13,80] = -4.84676915585801
        struct[0].Gy_ini[13,81] = 26.5300693004806
        struct[0].Gy_ini[13,82] = -1.58482814504483
        struct[0].Gy_ini[13,83] = -7.89461337514771
        struct[0].Gy_ini[13,349] = 1
        struct[0].Gy_ini[14,8] = 7.89461337514771
        struct[0].Gy_ini[14,9] = -1.58482814504483
        struct[0].Gy_ini[14,10] = 7.72144347466701
        struct[0].Gy_ini[14,11] = -0.679918453285308
        struct[0].Gy_ini[14,12] = 7.89461337514771
        struct[0].Gy_ini[14,13] = -1.58482814504483
        struct[0].Gy_ini[14,14] = -26.5550693004806
        struct[0].Gy_ini[14,15] = -4.84676915585801
        struct[0].Gy_ini[14,76] = -7.89461337514771
        struct[0].Gy_ini[14,77] = 1.58482814504483
        struct[0].Gy_ini[14,78] = -7.72144347466701
        struct[0].Gy_ini[14,79] = 0.679918453285308
        struct[0].Gy_ini[14,80] = -7.89461337514771
        struct[0].Gy_ini[14,81] = 1.58482814504483
        struct[0].Gy_ini[14,82] = 26.5300693004806
        struct[0].Gy_ini[14,83] = 4.84676915585801
        struct[0].Gy_ini[15,8] = 1.58482814504483
        struct[0].Gy_ini[15,9] = 7.89461337514771
        struct[0].Gy_ini[15,10] = 0.679918453285308
        struct[0].Gy_ini[15,11] = 7.72144347466701
        struct[0].Gy_ini[15,12] = 1.58482814504483
        struct[0].Gy_ini[15,13] = 7.89461337514771
        struct[0].Gy_ini[15,14] = 4.84676915585801
        struct[0].Gy_ini[15,15] = -26.5550693004806
        struct[0].Gy_ini[15,76] = -1.58482814504483
        struct[0].Gy_ini[15,77] = -7.89461337514771
        struct[0].Gy_ini[15,78] = -0.679918453285308
        struct[0].Gy_ini[15,79] = -7.72144347466701
        struct[0].Gy_ini[15,80] = -1.58482814504483
        struct[0].Gy_ini[15,81] = -7.89461337514771
        struct[0].Gy_ini[15,82] = -4.84676915585801
        struct[0].Gy_ini[15,83] = 26.5300693004806
        struct[0].Gy_ini[16,16] = -26.5300693004806
        struct[0].Gy_ini[16,17] = -4.84676915585801
        struct[0].Gy_ini[16,18] = 7.89461337514770
        struct[0].Gy_ini[16,19] = -1.58482814504483
        struct[0].Gy_ini[16,20] = 7.72144347466701
        struct[0].Gy_ini[16,21] = -0.679918453285310
        struct[0].Gy_ini[16,22] = 7.89461337514771
        struct[0].Gy_ini[16,23] = -1.58482814504483
        struct[0].Gy_ini[16,156] = 26.5300693004806
        struct[0].Gy_ini[16,157] = 4.84676915585801
        struct[0].Gy_ini[16,158] = -7.89461337514770
        struct[0].Gy_ini[16,159] = 1.58482814504483
        struct[0].Gy_ini[16,160] = -7.72144347466701
        struct[0].Gy_ini[16,161] = 0.679918453285310
        struct[0].Gy_ini[16,162] = -7.89461337514771
        struct[0].Gy_ini[16,163] = 1.58482814504483
        struct[0].Gy_ini[16,352] = 1
        struct[0].Gy_ini[17,16] = 4.84676915585801
        struct[0].Gy_ini[17,17] = -26.5300693004806
        struct[0].Gy_ini[17,18] = 1.58482814504483
        struct[0].Gy_ini[17,19] = 7.89461337514770
        struct[0].Gy_ini[17,20] = 0.679918453285310
        struct[0].Gy_ini[17,21] = 7.72144347466701
        struct[0].Gy_ini[17,22] = 1.58482814504483
        struct[0].Gy_ini[17,23] = 7.89461337514771
        struct[0].Gy_ini[17,156] = -4.84676915585801
        struct[0].Gy_ini[17,157] = 26.5300693004806
        struct[0].Gy_ini[17,158] = -1.58482814504483
        struct[0].Gy_ini[17,159] = -7.89461337514770
        struct[0].Gy_ini[17,160] = -0.679918453285310
        struct[0].Gy_ini[17,161] = -7.72144347466701
        struct[0].Gy_ini[17,162] = -1.58482814504483
        struct[0].Gy_ini[17,163] = -7.89461337514771
        struct[0].Gy_ini[17,353] = 1
        struct[0].Gy_ini[18,16] = 7.89461337514771
        struct[0].Gy_ini[18,17] = -1.58482814504483
        struct[0].Gy_ini[18,18] = -26.5300693004806
        struct[0].Gy_ini[18,19] = -4.84676915585801
        struct[0].Gy_ini[18,20] = 7.89461337514771
        struct[0].Gy_ini[18,21] = -1.58482814504483
        struct[0].Gy_ini[18,22] = 7.72144347466701
        struct[0].Gy_ini[18,23] = -0.679918453285308
        struct[0].Gy_ini[18,156] = -7.89461337514771
        struct[0].Gy_ini[18,157] = 1.58482814504483
        struct[0].Gy_ini[18,158] = 26.5300693004806
        struct[0].Gy_ini[18,159] = 4.84676915585801
        struct[0].Gy_ini[18,160] = -7.89461337514771
        struct[0].Gy_ini[18,161] = 1.58482814504483
        struct[0].Gy_ini[18,162] = -7.72144347466701
        struct[0].Gy_ini[18,163] = 0.679918453285308
        struct[0].Gy_ini[18,354] = 1
        struct[0].Gy_ini[19,16] = 1.58482814504483
        struct[0].Gy_ini[19,17] = 7.89461337514771
        struct[0].Gy_ini[19,18] = 4.84676915585801
        struct[0].Gy_ini[19,19] = -26.5300693004806
        struct[0].Gy_ini[19,20] = 1.58482814504483
        struct[0].Gy_ini[19,21] = 7.89461337514771
        struct[0].Gy_ini[19,22] = 0.679918453285308
        struct[0].Gy_ini[19,23] = 7.72144347466701
        struct[0].Gy_ini[19,156] = -1.58482814504483
        struct[0].Gy_ini[19,157] = -7.89461337514771
        struct[0].Gy_ini[19,158] = -4.84676915585801
        struct[0].Gy_ini[19,159] = 26.5300693004806
        struct[0].Gy_ini[19,160] = -1.58482814504483
        struct[0].Gy_ini[19,161] = -7.89461337514771
        struct[0].Gy_ini[19,162] = -0.679918453285308
        struct[0].Gy_ini[19,163] = -7.72144347466701
        struct[0].Gy_ini[19,355] = 1
        struct[0].Gy_ini[20,16] = 7.72144347466701
        struct[0].Gy_ini[20,17] = -0.679918453285310
        struct[0].Gy_ini[20,18] = 7.89461337514770
        struct[0].Gy_ini[20,19] = -1.58482814504483
        struct[0].Gy_ini[20,20] = -26.5300693004806
        struct[0].Gy_ini[20,21] = -4.84676915585801
        struct[0].Gy_ini[20,22] = 7.89461337514771
        struct[0].Gy_ini[20,23] = -1.58482814504483
        struct[0].Gy_ini[20,156] = -7.72144347466701
        struct[0].Gy_ini[20,157] = 0.679918453285310
        struct[0].Gy_ini[20,158] = -7.89461337514770
        struct[0].Gy_ini[20,159] = 1.58482814504483
        struct[0].Gy_ini[20,160] = 26.5300693004806
        struct[0].Gy_ini[20,161] = 4.84676915585801
        struct[0].Gy_ini[20,162] = -7.89461337514771
        struct[0].Gy_ini[20,163] = 1.58482814504483
        struct[0].Gy_ini[20,356] = 1
        struct[0].Gy_ini[21,16] = 0.679918453285310
        struct[0].Gy_ini[21,17] = 7.72144347466701
        struct[0].Gy_ini[21,18] = 1.58482814504483
        struct[0].Gy_ini[21,19] = 7.89461337514770
        struct[0].Gy_ini[21,20] = 4.84676915585801
        struct[0].Gy_ini[21,21] = -26.5300693004806
        struct[0].Gy_ini[21,22] = 1.58482814504483
        struct[0].Gy_ini[21,23] = 7.89461337514771
        struct[0].Gy_ini[21,156] = -0.679918453285310
        struct[0].Gy_ini[21,157] = -7.72144347466701
        struct[0].Gy_ini[21,158] = -1.58482814504483
        struct[0].Gy_ini[21,159] = -7.89461337514770
        struct[0].Gy_ini[21,160] = -4.84676915585801
        struct[0].Gy_ini[21,161] = 26.5300693004806
        struct[0].Gy_ini[21,162] = -1.58482814504483
        struct[0].Gy_ini[21,163] = -7.89461337514771
        struct[0].Gy_ini[21,357] = 1
        struct[0].Gy_ini[22,16] = 7.89461337514771
        struct[0].Gy_ini[22,17] = -1.58482814504483
        struct[0].Gy_ini[22,18] = 7.72144347466701
        struct[0].Gy_ini[22,19] = -0.679918453285308
        struct[0].Gy_ini[22,20] = 7.89461337514771
        struct[0].Gy_ini[22,21] = -1.58482814504483
        struct[0].Gy_ini[22,22] = -26.5550693004806
        struct[0].Gy_ini[22,23] = -4.84676915585801
        struct[0].Gy_ini[22,156] = -7.89461337514771
        struct[0].Gy_ini[22,157] = 1.58482814504483
        struct[0].Gy_ini[22,158] = -7.72144347466701
        struct[0].Gy_ini[22,159] = 0.679918453285308
        struct[0].Gy_ini[22,160] = -7.89461337514771
        struct[0].Gy_ini[22,161] = 1.58482814504483
        struct[0].Gy_ini[22,162] = 26.5300693004806
        struct[0].Gy_ini[22,163] = 4.84676915585801
        struct[0].Gy_ini[23,16] = 1.58482814504483
        struct[0].Gy_ini[23,17] = 7.89461337514771
        struct[0].Gy_ini[23,18] = 0.679918453285308
        struct[0].Gy_ini[23,19] = 7.72144347466701
        struct[0].Gy_ini[23,20] = 1.58482814504483
        struct[0].Gy_ini[23,21] = 7.89461337514771
        struct[0].Gy_ini[23,22] = 4.84676915585801
        struct[0].Gy_ini[23,23] = -26.5550693004806
        struct[0].Gy_ini[23,156] = -1.58482814504483
        struct[0].Gy_ini[23,157] = -7.89461337514771
        struct[0].Gy_ini[23,158] = -0.679918453285308
        struct[0].Gy_ini[23,159] = -7.72144347466701
        struct[0].Gy_ini[23,160] = -1.58482814504483
        struct[0].Gy_ini[23,161] = -7.89461337514771
        struct[0].Gy_ini[23,162] = -4.84676915585801
        struct[0].Gy_ini[23,163] = 26.5300693004806
        struct[0].Gy_ini[24,24] = -30.9517475172273
        struct[0].Gy_ini[24,25] = -5.65456401516768
        struct[0].Gy_ini[24,26] = 9.21038227100566
        struct[0].Gy_ini[24,27] = -1.84896616921897
        struct[0].Gy_ini[24,28] = 9.00835072044485
        struct[0].Gy_ini[24,29] = -0.793238195499529
        struct[0].Gy_ini[24,30] = 9.21038227100566
        struct[0].Gy_ini[24,31] = -1.84896616921897
        struct[0].Gy_ini[24,100] = 30.9517475172273
        struct[0].Gy_ini[24,101] = 5.65456401516768
        struct[0].Gy_ini[24,102] = -9.21038227100566
        struct[0].Gy_ini[24,103] = 1.84896616921897
        struct[0].Gy_ini[24,104] = -9.00835072044485
        struct[0].Gy_ini[24,105] = 0.793238195499529
        struct[0].Gy_ini[24,106] = -9.21038227100566
        struct[0].Gy_ini[24,107] = 1.84896616921897
        struct[0].Gy_ini[24,360] = 1
        struct[0].Gy_ini[25,24] = 5.65456401516768
        struct[0].Gy_ini[25,25] = -30.9517475172273
        struct[0].Gy_ini[25,26] = 1.84896616921897
        struct[0].Gy_ini[25,27] = 9.21038227100566
        struct[0].Gy_ini[25,28] = 0.793238195499529
        struct[0].Gy_ini[25,29] = 9.00835072044485
        struct[0].Gy_ini[25,30] = 1.84896616921897
        struct[0].Gy_ini[25,31] = 9.21038227100566
        struct[0].Gy_ini[25,100] = -5.65456401516768
        struct[0].Gy_ini[25,101] = 30.9517475172273
        struct[0].Gy_ini[25,102] = -1.84896616921897
        struct[0].Gy_ini[25,103] = -9.21038227100566
        struct[0].Gy_ini[25,104] = -0.793238195499529
        struct[0].Gy_ini[25,105] = -9.00835072044485
        struct[0].Gy_ini[25,106] = -1.84896616921897
        struct[0].Gy_ini[25,107] = -9.21038227100566
        struct[0].Gy_ini[25,361] = 1
        struct[0].Gy_ini[26,24] = 9.21038227100566
        struct[0].Gy_ini[26,25] = -1.84896616921897
        struct[0].Gy_ini[26,26] = -30.9517475172273
        struct[0].Gy_ini[26,27] = -5.65456401516768
        struct[0].Gy_ini[26,28] = 9.21038227100566
        struct[0].Gy_ini[26,29] = -1.84896616921897
        struct[0].Gy_ini[26,30] = 9.00835072044485
        struct[0].Gy_ini[26,31] = -0.793238195499528
        struct[0].Gy_ini[26,100] = -9.21038227100566
        struct[0].Gy_ini[26,101] = 1.84896616921897
        struct[0].Gy_ini[26,102] = 30.9517475172273
        struct[0].Gy_ini[26,103] = 5.65456401516768
        struct[0].Gy_ini[26,104] = -9.21038227100566
        struct[0].Gy_ini[26,105] = 1.84896616921897
        struct[0].Gy_ini[26,106] = -9.00835072044485
        struct[0].Gy_ini[26,107] = 0.793238195499528
        struct[0].Gy_ini[26,362] = 1
        struct[0].Gy_ini[27,24] = 1.84896616921897
        struct[0].Gy_ini[27,25] = 9.21038227100566
        struct[0].Gy_ini[27,26] = 5.65456401516768
        struct[0].Gy_ini[27,27] = -30.9517475172273
        struct[0].Gy_ini[27,28] = 1.84896616921897
        struct[0].Gy_ini[27,29] = 9.21038227100566
        struct[0].Gy_ini[27,30] = 0.793238195499528
        struct[0].Gy_ini[27,31] = 9.00835072044485
        struct[0].Gy_ini[27,100] = -1.84896616921897
        struct[0].Gy_ini[27,101] = -9.21038227100566
        struct[0].Gy_ini[27,102] = -5.65456401516768
        struct[0].Gy_ini[27,103] = 30.9517475172273
        struct[0].Gy_ini[27,104] = -1.84896616921897
        struct[0].Gy_ini[27,105] = -9.21038227100566
        struct[0].Gy_ini[27,106] = -0.793238195499528
        struct[0].Gy_ini[27,107] = -9.00835072044485
        struct[0].Gy_ini[27,363] = 1
        struct[0].Gy_ini[28,24] = 9.00835072044484
        struct[0].Gy_ini[28,25] = -0.793238195499527
        struct[0].Gy_ini[28,26] = 9.21038227100566
        struct[0].Gy_ini[28,27] = -1.84896616921897
        struct[0].Gy_ini[28,28] = -30.9517475172273
        struct[0].Gy_ini[28,29] = -5.65456401516768
        struct[0].Gy_ini[28,30] = 9.21038227100566
        struct[0].Gy_ini[28,31] = -1.84896616921897
        struct[0].Gy_ini[28,100] = -9.00835072044484
        struct[0].Gy_ini[28,101] = 0.793238195499527
        struct[0].Gy_ini[28,102] = -9.21038227100566
        struct[0].Gy_ini[28,103] = 1.84896616921897
        struct[0].Gy_ini[28,104] = 30.9517475172273
        struct[0].Gy_ini[28,105] = 5.65456401516768
        struct[0].Gy_ini[28,106] = -9.21038227100566
        struct[0].Gy_ini[28,107] = 1.84896616921897
        struct[0].Gy_ini[28,364] = 1
        struct[0].Gy_ini[29,24] = 0.793238195499527
        struct[0].Gy_ini[29,25] = 9.00835072044484
        struct[0].Gy_ini[29,26] = 1.84896616921897
        struct[0].Gy_ini[29,27] = 9.21038227100566
        struct[0].Gy_ini[29,28] = 5.65456401516768
        struct[0].Gy_ini[29,29] = -30.9517475172273
        struct[0].Gy_ini[29,30] = 1.84896616921897
        struct[0].Gy_ini[29,31] = 9.21038227100566
        struct[0].Gy_ini[29,100] = -0.793238195499527
        struct[0].Gy_ini[29,101] = -9.00835072044484
        struct[0].Gy_ini[29,102] = -1.84896616921897
        struct[0].Gy_ini[29,103] = -9.21038227100566
        struct[0].Gy_ini[29,104] = -5.65456401516768
        struct[0].Gy_ini[29,105] = 30.9517475172273
        struct[0].Gy_ini[29,106] = -1.84896616921897
        struct[0].Gy_ini[29,107] = -9.21038227100566
        struct[0].Gy_ini[29,365] = 1
        struct[0].Gy_ini[30,24] = 9.21038227100566
        struct[0].Gy_ini[30,25] = -1.84896616921897
        struct[0].Gy_ini[30,26] = 9.00835072044485
        struct[0].Gy_ini[30,27] = -0.793238195499527
        struct[0].Gy_ini[30,28] = 9.21038227100566
        struct[0].Gy_ini[30,29] = -1.84896616921897
        struct[0].Gy_ini[30,30] = -30.9767475172273
        struct[0].Gy_ini[30,31] = -5.65456401516768
        struct[0].Gy_ini[30,100] = -9.21038227100566
        struct[0].Gy_ini[30,101] = 1.84896616921897
        struct[0].Gy_ini[30,102] = -9.00835072044485
        struct[0].Gy_ini[30,103] = 0.793238195499527
        struct[0].Gy_ini[30,104] = -9.21038227100566
        struct[0].Gy_ini[30,105] = 1.84896616921897
        struct[0].Gy_ini[30,106] = 30.9517475172273
        struct[0].Gy_ini[30,107] = 5.65456401516768
        struct[0].Gy_ini[31,24] = 1.84896616921897
        struct[0].Gy_ini[31,25] = 9.21038227100566
        struct[0].Gy_ini[31,26] = 0.793238195499527
        struct[0].Gy_ini[31,27] = 9.00835072044485
        struct[0].Gy_ini[31,28] = 1.84896616921897
        struct[0].Gy_ini[31,29] = 9.21038227100566
        struct[0].Gy_ini[31,30] = 5.65456401516768
        struct[0].Gy_ini[31,31] = -30.9767475172273
        struct[0].Gy_ini[31,100] = -1.84896616921897
        struct[0].Gy_ini[31,101] = -9.21038227100566
        struct[0].Gy_ini[31,102] = -0.793238195499527
        struct[0].Gy_ini[31,103] = -9.00835072044485
        struct[0].Gy_ini[31,104] = -1.84896616921897
        struct[0].Gy_ini[31,105] = -9.21038227100566
        struct[0].Gy_ini[31,106] = -5.65456401516768
        struct[0].Gy_ini[31,107] = 30.9517475172273
        struct[0].Gy_ini[32,32] = -30.9517475172273
        struct[0].Gy_ini[32,33] = -5.65456401516768
        struct[0].Gy_ini[32,34] = 9.21038227100566
        struct[0].Gy_ini[32,35] = -1.84896616921897
        struct[0].Gy_ini[32,36] = 9.00835072044485
        struct[0].Gy_ini[32,37] = -0.793238195499529
        struct[0].Gy_ini[32,38] = 9.21038227100566
        struct[0].Gy_ini[32,39] = -1.84896616921897
        struct[0].Gy_ini[32,124] = 30.9517475172273
        struct[0].Gy_ini[32,125] = 5.65456401516768
        struct[0].Gy_ini[32,126] = -9.21038227100566
        struct[0].Gy_ini[32,127] = 1.84896616921897
        struct[0].Gy_ini[32,128] = -9.00835072044485
        struct[0].Gy_ini[32,129] = 0.793238195499529
        struct[0].Gy_ini[32,130] = -9.21038227100566
        struct[0].Gy_ini[32,131] = 1.84896616921897
        struct[0].Gy_ini[32,368] = 1
        struct[0].Gy_ini[33,32] = 5.65456401516768
        struct[0].Gy_ini[33,33] = -30.9517475172273
        struct[0].Gy_ini[33,34] = 1.84896616921897
        struct[0].Gy_ini[33,35] = 9.21038227100566
        struct[0].Gy_ini[33,36] = 0.793238195499529
        struct[0].Gy_ini[33,37] = 9.00835072044485
        struct[0].Gy_ini[33,38] = 1.84896616921897
        struct[0].Gy_ini[33,39] = 9.21038227100566
        struct[0].Gy_ini[33,124] = -5.65456401516768
        struct[0].Gy_ini[33,125] = 30.9517475172273
        struct[0].Gy_ini[33,126] = -1.84896616921897
        struct[0].Gy_ini[33,127] = -9.21038227100566
        struct[0].Gy_ini[33,128] = -0.793238195499529
        struct[0].Gy_ini[33,129] = -9.00835072044485
        struct[0].Gy_ini[33,130] = -1.84896616921897
        struct[0].Gy_ini[33,131] = -9.21038227100566
        struct[0].Gy_ini[33,369] = 1
        struct[0].Gy_ini[34,32] = 9.21038227100566
        struct[0].Gy_ini[34,33] = -1.84896616921897
        struct[0].Gy_ini[34,34] = -30.9517475172273
        struct[0].Gy_ini[34,35] = -5.65456401516768
        struct[0].Gy_ini[34,36] = 9.21038227100566
        struct[0].Gy_ini[34,37] = -1.84896616921897
        struct[0].Gy_ini[34,38] = 9.00835072044485
        struct[0].Gy_ini[34,39] = -0.793238195499528
        struct[0].Gy_ini[34,124] = -9.21038227100566
        struct[0].Gy_ini[34,125] = 1.84896616921897
        struct[0].Gy_ini[34,126] = 30.9517475172273
        struct[0].Gy_ini[34,127] = 5.65456401516768
        struct[0].Gy_ini[34,128] = -9.21038227100566
        struct[0].Gy_ini[34,129] = 1.84896616921897
        struct[0].Gy_ini[34,130] = -9.00835072044485
        struct[0].Gy_ini[34,131] = 0.793238195499528
        struct[0].Gy_ini[34,370] = 1
        struct[0].Gy_ini[35,32] = 1.84896616921897
        struct[0].Gy_ini[35,33] = 9.21038227100566
        struct[0].Gy_ini[35,34] = 5.65456401516768
        struct[0].Gy_ini[35,35] = -30.9517475172273
        struct[0].Gy_ini[35,36] = 1.84896616921897
        struct[0].Gy_ini[35,37] = 9.21038227100566
        struct[0].Gy_ini[35,38] = 0.793238195499528
        struct[0].Gy_ini[35,39] = 9.00835072044485
        struct[0].Gy_ini[35,124] = -1.84896616921897
        struct[0].Gy_ini[35,125] = -9.21038227100566
        struct[0].Gy_ini[35,126] = -5.65456401516768
        struct[0].Gy_ini[35,127] = 30.9517475172273
        struct[0].Gy_ini[35,128] = -1.84896616921897
        struct[0].Gy_ini[35,129] = -9.21038227100566
        struct[0].Gy_ini[35,130] = -0.793238195499528
        struct[0].Gy_ini[35,131] = -9.00835072044485
        struct[0].Gy_ini[35,371] = 1
        struct[0].Gy_ini[36,32] = 9.00835072044484
        struct[0].Gy_ini[36,33] = -0.793238195499527
        struct[0].Gy_ini[36,34] = 9.21038227100566
        struct[0].Gy_ini[36,35] = -1.84896616921897
        struct[0].Gy_ini[36,36] = -30.9517475172273
        struct[0].Gy_ini[36,37] = -5.65456401516768
        struct[0].Gy_ini[36,38] = 9.21038227100566
        struct[0].Gy_ini[36,39] = -1.84896616921897
        struct[0].Gy_ini[36,124] = -9.00835072044484
        struct[0].Gy_ini[36,125] = 0.793238195499527
        struct[0].Gy_ini[36,126] = -9.21038227100566
        struct[0].Gy_ini[36,127] = 1.84896616921897
        struct[0].Gy_ini[36,128] = 30.9517475172273
        struct[0].Gy_ini[36,129] = 5.65456401516768
        struct[0].Gy_ini[36,130] = -9.21038227100566
        struct[0].Gy_ini[36,131] = 1.84896616921897
        struct[0].Gy_ini[36,372] = 1
        struct[0].Gy_ini[37,32] = 0.793238195499527
        struct[0].Gy_ini[37,33] = 9.00835072044484
        struct[0].Gy_ini[37,34] = 1.84896616921897
        struct[0].Gy_ini[37,35] = 9.21038227100566
        struct[0].Gy_ini[37,36] = 5.65456401516768
        struct[0].Gy_ini[37,37] = -30.9517475172273
        struct[0].Gy_ini[37,38] = 1.84896616921897
        struct[0].Gy_ini[37,39] = 9.21038227100566
        struct[0].Gy_ini[37,124] = -0.793238195499527
        struct[0].Gy_ini[37,125] = -9.00835072044484
        struct[0].Gy_ini[37,126] = -1.84896616921897
        struct[0].Gy_ini[37,127] = -9.21038227100566
        struct[0].Gy_ini[37,128] = -5.65456401516768
        struct[0].Gy_ini[37,129] = 30.9517475172273
        struct[0].Gy_ini[37,130] = -1.84896616921897
        struct[0].Gy_ini[37,131] = -9.21038227100566
        struct[0].Gy_ini[37,373] = 1
        struct[0].Gy_ini[38,32] = 9.21038227100566
        struct[0].Gy_ini[38,33] = -1.84896616921897
        struct[0].Gy_ini[38,34] = 9.00835072044485
        struct[0].Gy_ini[38,35] = -0.793238195499527
        struct[0].Gy_ini[38,36] = 9.21038227100566
        struct[0].Gy_ini[38,37] = -1.84896616921897
        struct[0].Gy_ini[38,38] = -30.9767475172273
        struct[0].Gy_ini[38,39] = -5.65456401516768
        struct[0].Gy_ini[38,124] = -9.21038227100566
        struct[0].Gy_ini[38,125] = 1.84896616921897
        struct[0].Gy_ini[38,126] = -9.00835072044485
        struct[0].Gy_ini[38,127] = 0.793238195499527
        struct[0].Gy_ini[38,128] = -9.21038227100566
        struct[0].Gy_ini[38,129] = 1.84896616921897
        struct[0].Gy_ini[38,130] = 30.9517475172273
        struct[0].Gy_ini[38,131] = 5.65456401516768
        struct[0].Gy_ini[39,32] = 1.84896616921897
        struct[0].Gy_ini[39,33] = 9.21038227100566
        struct[0].Gy_ini[39,34] = 0.793238195499527
        struct[0].Gy_ini[39,35] = 9.00835072044485
        struct[0].Gy_ini[39,36] = 1.84896616921897
        struct[0].Gy_ini[39,37] = 9.21038227100566
        struct[0].Gy_ini[39,38] = 5.65456401516768
        struct[0].Gy_ini[39,39] = -30.9767475172273
        struct[0].Gy_ini[39,124] = -1.84896616921897
        struct[0].Gy_ini[39,125] = -9.21038227100566
        struct[0].Gy_ini[39,126] = -0.793238195499527
        struct[0].Gy_ini[39,127] = -9.00835072044485
        struct[0].Gy_ini[39,128] = -1.84896616921897
        struct[0].Gy_ini[39,129] = -9.21038227100566
        struct[0].Gy_ini[39,130] = -5.65456401516768
        struct[0].Gy_ini[39,131] = 30.9517475172273
        struct[0].Gy_ini[40,40] = -30.9517475172273
        struct[0].Gy_ini[40,41] = -5.65456401516768
        struct[0].Gy_ini[40,42] = 9.21038227100566
        struct[0].Gy_ini[40,43] = -1.84896616921897
        struct[0].Gy_ini[40,44] = 9.00835072044485
        struct[0].Gy_ini[40,45] = -0.793238195499529
        struct[0].Gy_ini[40,46] = 9.21038227100566
        struct[0].Gy_ini[40,47] = -1.84896616921897
        struct[0].Gy_ini[40,132] = 30.9517475172273
        struct[0].Gy_ini[40,133] = 5.65456401516768
        struct[0].Gy_ini[40,134] = -9.21038227100566
        struct[0].Gy_ini[40,135] = 1.84896616921897
        struct[0].Gy_ini[40,136] = -9.00835072044485
        struct[0].Gy_ini[40,137] = 0.793238195499529
        struct[0].Gy_ini[40,138] = -9.21038227100566
        struct[0].Gy_ini[40,139] = 1.84896616921897
        struct[0].Gy_ini[40,376] = 1
        struct[0].Gy_ini[41,40] = 5.65456401516768
        struct[0].Gy_ini[41,41] = -30.9517475172273
        struct[0].Gy_ini[41,42] = 1.84896616921897
        struct[0].Gy_ini[41,43] = 9.21038227100566
        struct[0].Gy_ini[41,44] = 0.793238195499529
        struct[0].Gy_ini[41,45] = 9.00835072044485
        struct[0].Gy_ini[41,46] = 1.84896616921897
        struct[0].Gy_ini[41,47] = 9.21038227100566
        struct[0].Gy_ini[41,132] = -5.65456401516768
        struct[0].Gy_ini[41,133] = 30.9517475172273
        struct[0].Gy_ini[41,134] = -1.84896616921897
        struct[0].Gy_ini[41,135] = -9.21038227100566
        struct[0].Gy_ini[41,136] = -0.793238195499529
        struct[0].Gy_ini[41,137] = -9.00835072044485
        struct[0].Gy_ini[41,138] = -1.84896616921897
        struct[0].Gy_ini[41,139] = -9.21038227100566
        struct[0].Gy_ini[41,377] = 1
        struct[0].Gy_ini[42,40] = 9.21038227100566
        struct[0].Gy_ini[42,41] = -1.84896616921897
        struct[0].Gy_ini[42,42] = -30.9517475172273
        struct[0].Gy_ini[42,43] = -5.65456401516768
        struct[0].Gy_ini[42,44] = 9.21038227100566
        struct[0].Gy_ini[42,45] = -1.84896616921897
        struct[0].Gy_ini[42,46] = 9.00835072044485
        struct[0].Gy_ini[42,47] = -0.793238195499528
        struct[0].Gy_ini[42,132] = -9.21038227100566
        struct[0].Gy_ini[42,133] = 1.84896616921897
        struct[0].Gy_ini[42,134] = 30.9517475172273
        struct[0].Gy_ini[42,135] = 5.65456401516768
        struct[0].Gy_ini[42,136] = -9.21038227100566
        struct[0].Gy_ini[42,137] = 1.84896616921897
        struct[0].Gy_ini[42,138] = -9.00835072044485
        struct[0].Gy_ini[42,139] = 0.793238195499528
        struct[0].Gy_ini[42,378] = 1
        struct[0].Gy_ini[43,40] = 1.84896616921897
        struct[0].Gy_ini[43,41] = 9.21038227100566
        struct[0].Gy_ini[43,42] = 5.65456401516768
        struct[0].Gy_ini[43,43] = -30.9517475172273
        struct[0].Gy_ini[43,44] = 1.84896616921897
        struct[0].Gy_ini[43,45] = 9.21038227100566
        struct[0].Gy_ini[43,46] = 0.793238195499528
        struct[0].Gy_ini[43,47] = 9.00835072044485
        struct[0].Gy_ini[43,132] = -1.84896616921897
        struct[0].Gy_ini[43,133] = -9.21038227100566
        struct[0].Gy_ini[43,134] = -5.65456401516768
        struct[0].Gy_ini[43,135] = 30.9517475172273
        struct[0].Gy_ini[43,136] = -1.84896616921897
        struct[0].Gy_ini[43,137] = -9.21038227100566
        struct[0].Gy_ini[43,138] = -0.793238195499528
        struct[0].Gy_ini[43,139] = -9.00835072044485
        struct[0].Gy_ini[43,379] = 1
        struct[0].Gy_ini[44,40] = 9.00835072044484
        struct[0].Gy_ini[44,41] = -0.793238195499527
        struct[0].Gy_ini[44,42] = 9.21038227100566
        struct[0].Gy_ini[44,43] = -1.84896616921897
        struct[0].Gy_ini[44,44] = -30.9517475172273
        struct[0].Gy_ini[44,45] = -5.65456401516768
        struct[0].Gy_ini[44,46] = 9.21038227100566
        struct[0].Gy_ini[44,47] = -1.84896616921897
        struct[0].Gy_ini[44,132] = -9.00835072044484
        struct[0].Gy_ini[44,133] = 0.793238195499527
        struct[0].Gy_ini[44,134] = -9.21038227100566
        struct[0].Gy_ini[44,135] = 1.84896616921897
        struct[0].Gy_ini[44,136] = 30.9517475172273
        struct[0].Gy_ini[44,137] = 5.65456401516768
        struct[0].Gy_ini[44,138] = -9.21038227100566
        struct[0].Gy_ini[44,139] = 1.84896616921897
        struct[0].Gy_ini[44,380] = 1
        struct[0].Gy_ini[45,40] = 0.793238195499527
        struct[0].Gy_ini[45,41] = 9.00835072044484
        struct[0].Gy_ini[45,42] = 1.84896616921897
        struct[0].Gy_ini[45,43] = 9.21038227100566
        struct[0].Gy_ini[45,44] = 5.65456401516768
        struct[0].Gy_ini[45,45] = -30.9517475172273
        struct[0].Gy_ini[45,46] = 1.84896616921897
        struct[0].Gy_ini[45,47] = 9.21038227100566
        struct[0].Gy_ini[45,132] = -0.793238195499527
        struct[0].Gy_ini[45,133] = -9.00835072044484
        struct[0].Gy_ini[45,134] = -1.84896616921897
        struct[0].Gy_ini[45,135] = -9.21038227100566
        struct[0].Gy_ini[45,136] = -5.65456401516768
        struct[0].Gy_ini[45,137] = 30.9517475172273
        struct[0].Gy_ini[45,138] = -1.84896616921897
        struct[0].Gy_ini[45,139] = -9.21038227100566
        struct[0].Gy_ini[45,381] = 1
        struct[0].Gy_ini[46,40] = 9.21038227100566
        struct[0].Gy_ini[46,41] = -1.84896616921897
        struct[0].Gy_ini[46,42] = 9.00835072044485
        struct[0].Gy_ini[46,43] = -0.793238195499527
        struct[0].Gy_ini[46,44] = 9.21038227100566
        struct[0].Gy_ini[46,45] = -1.84896616921897
        struct[0].Gy_ini[46,46] = -30.9767475172273
        struct[0].Gy_ini[46,47] = -5.65456401516768
        struct[0].Gy_ini[46,132] = -9.21038227100566
        struct[0].Gy_ini[46,133] = 1.84896616921897
        struct[0].Gy_ini[46,134] = -9.00835072044485
        struct[0].Gy_ini[46,135] = 0.793238195499527
        struct[0].Gy_ini[46,136] = -9.21038227100566
        struct[0].Gy_ini[46,137] = 1.84896616921897
        struct[0].Gy_ini[46,138] = 30.9517475172273
        struct[0].Gy_ini[46,139] = 5.65456401516768
        struct[0].Gy_ini[47,40] = 1.84896616921897
        struct[0].Gy_ini[47,41] = 9.21038227100566
        struct[0].Gy_ini[47,42] = 0.793238195499527
        struct[0].Gy_ini[47,43] = 9.00835072044485
        struct[0].Gy_ini[47,44] = 1.84896616921897
        struct[0].Gy_ini[47,45] = 9.21038227100566
        struct[0].Gy_ini[47,46] = 5.65456401516768
        struct[0].Gy_ini[47,47] = -30.9767475172273
        struct[0].Gy_ini[47,132] = -1.84896616921897
        struct[0].Gy_ini[47,133] = -9.21038227100566
        struct[0].Gy_ini[47,134] = -0.793238195499527
        struct[0].Gy_ini[47,135] = -9.00835072044485
        struct[0].Gy_ini[47,136] = -1.84896616921897
        struct[0].Gy_ini[47,137] = -9.21038227100566
        struct[0].Gy_ini[47,138] = -5.65456401516768
        struct[0].Gy_ini[47,139] = 30.9517475172273
        struct[0].Gy_ini[48,48] = -135.409614082600
        struct[0].Gy_ini[48,222] = 135.409614082600
        struct[0].Gy_ini[48,384] = 1
        struct[0].Gy_ini[49,49] = -135.409614082600
        struct[0].Gy_ini[49,223] = 135.409614082600
        struct[0].Gy_ini[49,385] = 1
        struct[0].Gy_ini[50,50] = -135.409614082600
        struct[0].Gy_ini[50,228] = 135.409614082600
        struct[0].Gy_ini[50,386] = 1
        struct[0].Gy_ini[51,51] = -135.409614082600
        struct[0].Gy_ini[51,229] = 135.409614082600
        struct[0].Gy_ini[51,387] = 1
        struct[0].Gy_ini[52,52] = -157.977883096366
        struct[0].Gy_ini[52,166] = 157.977883096366
        struct[0].Gy_ini[52,388] = 1
        struct[0].Gy_ini[53,53] = -157.977883096366
        struct[0].Gy_ini[53,167] = 157.977883096366
        struct[0].Gy_ini[53,389] = 1
        struct[0].Gy_ini[54,54] = -157.977883096366
        struct[0].Gy_ini[54,172] = 157.977883096366
        struct[0].Gy_ini[54,390] = 1
        struct[0].Gy_ini[55,55] = -157.977883096366
        struct[0].Gy_ini[55,173] = 157.977883096366
        struct[0].Gy_ini[55,391] = 1
        struct[0].Gy_ini[56,56] = -157.977883096366
        struct[0].Gy_ini[56,182] = 157.977883096366
        struct[0].Gy_ini[56,392] = 1
        struct[0].Gy_ini[57,57] = -157.977883096366
        struct[0].Gy_ini[57,183] = 157.977883096366
        struct[0].Gy_ini[57,393] = 1
        struct[0].Gy_ini[58,58] = -157.977883096366
        struct[0].Gy_ini[58,188] = 157.977883096366
        struct[0].Gy_ini[58,394] = 1
        struct[0].Gy_ini[59,59] = -157.977883096366
        struct[0].Gy_ini[59,189] = 157.977883096366
        struct[0].Gy_ini[59,395] = 1
        struct[0].Gy_ini[60,60] = -157.977883096366
        struct[0].Gy_ini[60,190] = 157.977883096366
        struct[0].Gy_ini[60,396] = 1
        struct[0].Gy_ini[61,61] = -157.977883096366
        struct[0].Gy_ini[61,191] = 157.977883096366
        struct[0].Gy_ini[61,397] = 1
        struct[0].Gy_ini[62,62] = -157.977883096366
        struct[0].Gy_ini[62,196] = 157.977883096366
        struct[0].Gy_ini[62,398] = 1
        struct[0].Gy_ini[63,63] = -157.977883096366
        struct[0].Gy_ini[63,197] = 157.977883096366
        struct[0].Gy_ini[63,399] = 1
        struct[0].Gy_ini[64,64] = -157.977883096366
        struct[0].Gy_ini[64,198] = 157.977883096366
        struct[0].Gy_ini[64,400] = 1
        struct[0].Gy_ini[65,65] = -157.977883096366
        struct[0].Gy_ini[65,199] = 157.977883096366
        struct[0].Gy_ini[65,401] = 1
        struct[0].Gy_ini[66,66] = -157.977883096366
        struct[0].Gy_ini[66,204] = 157.977883096366
        struct[0].Gy_ini[66,402] = 1
        struct[0].Gy_ini[67,67] = -157.977883096366
        struct[0].Gy_ini[67,205] = 157.977883096366
        struct[0].Gy_ini[67,403] = 1
        struct[0].Gy_ini[68,0] = 105.571769313180
        struct[0].Gy_ini[68,1] = 54.0657727682604
        struct[0].Gy_ini[68,2] = -39.6392229058202
        struct[0].Gy_ini[68,3] = -10.2713736253513
        struct[0].Gy_ini[68,4] = -24.9575997948692
        struct[0].Gy_ini[68,5] = -23.2849644809540
        struct[0].Gy_ini[68,6] = -39.6392229058202
        struct[0].Gy_ini[68,7] = -10.2713736253513
        struct[0].Gy_ini[68,68] = -211.143538626360
        struct[0].Gy_ini[68,69] = -108.131545536521
        struct[0].Gy_ini[68,70] = 79.2784458116403
        struct[0].Gy_ini[68,71] = 20.5427472507027
        struct[0].Gy_ini[68,72] = 49.9151995897384
        struct[0].Gy_ini[68,73] = 46.5699289619080
        struct[0].Gy_ini[68,74] = 79.2784458116403
        struct[0].Gy_ini[68,75] = 20.5427472507027
        struct[0].Gy_ini[68,76] = 105.571769313180
        struct[0].Gy_ini[68,77] = 54.0657727682604
        struct[0].Gy_ini[68,78] = -39.6392229058202
        struct[0].Gy_ini[68,79] = -10.2713736253513
        struct[0].Gy_ini[68,80] = -24.9575997948692
        struct[0].Gy_ini[68,81] = -23.2849644809540
        struct[0].Gy_ini[68,82] = -39.6392229058202
        struct[0].Gy_ini[68,83] = -10.2713736253513
        struct[0].Gy_ini[69,0] = -54.0657727682604
        struct[0].Gy_ini[69,1] = 105.571769313180
        struct[0].Gy_ini[69,2] = 10.2713736253513
        struct[0].Gy_ini[69,3] = -39.6392229058202
        struct[0].Gy_ini[69,4] = 23.2849644809540
        struct[0].Gy_ini[69,5] = -24.9575997948692
        struct[0].Gy_ini[69,6] = 10.2713736253513
        struct[0].Gy_ini[69,7] = -39.6392229058202
        struct[0].Gy_ini[69,68] = 108.131545536521
        struct[0].Gy_ini[69,69] = -211.143538626360
        struct[0].Gy_ini[69,70] = -20.5427472507027
        struct[0].Gy_ini[69,71] = 79.2784458116403
        struct[0].Gy_ini[69,72] = -46.5699289619080
        struct[0].Gy_ini[69,73] = 49.9151995897384
        struct[0].Gy_ini[69,74] = -20.5427472507027
        struct[0].Gy_ini[69,75] = 79.2784458116403
        struct[0].Gy_ini[69,76] = -54.0657727682604
        struct[0].Gy_ini[69,77] = 105.571769313180
        struct[0].Gy_ini[69,78] = 10.2713736253513
        struct[0].Gy_ini[69,79] = -39.6392229058202
        struct[0].Gy_ini[69,80] = 23.2849644809540
        struct[0].Gy_ini[69,81] = -24.9575997948692
        struct[0].Gy_ini[69,82] = 10.2713736253513
        struct[0].Gy_ini[69,83] = -39.6392229058202
        struct[0].Gy_ini[70,0] = -39.6392229058202
        struct[0].Gy_ini[70,1] = -10.2713736253513
        struct[0].Gy_ini[70,2] = 105.571769313180
        struct[0].Gy_ini[70,3] = 54.0657727682604
        struct[0].Gy_ini[70,4] = -39.6392229058201
        struct[0].Gy_ini[70,5] = -10.2713736253513
        struct[0].Gy_ini[70,6] = -24.9575997948692
        struct[0].Gy_ini[70,7] = -23.2849644809540
        struct[0].Gy_ini[70,68] = 79.2784458116403
        struct[0].Gy_ini[70,69] = 20.5427472507027
        struct[0].Gy_ini[70,70] = -211.143538626360
        struct[0].Gy_ini[70,71] = -108.131545536521
        struct[0].Gy_ini[70,72] = 79.2784458116403
        struct[0].Gy_ini[70,73] = 20.5427472507027
        struct[0].Gy_ini[70,74] = 49.9151995897384
        struct[0].Gy_ini[70,75] = 46.5699289619080
        struct[0].Gy_ini[70,76] = -39.6392229058202
        struct[0].Gy_ini[70,77] = -10.2713736253513
        struct[0].Gy_ini[70,78] = 105.571769313180
        struct[0].Gy_ini[70,79] = 54.0657727682604
        struct[0].Gy_ini[70,80] = -39.6392229058201
        struct[0].Gy_ini[70,81] = -10.2713736253513
        struct[0].Gy_ini[70,82] = -24.9575997948692
        struct[0].Gy_ini[70,83] = -23.2849644809540
        struct[0].Gy_ini[71,0] = 10.2713736253513
        struct[0].Gy_ini[71,1] = -39.6392229058202
        struct[0].Gy_ini[71,2] = -54.0657727682604
        struct[0].Gy_ini[71,3] = 105.571769313180
        struct[0].Gy_ini[71,4] = 10.2713736253513
        struct[0].Gy_ini[71,5] = -39.6392229058201
        struct[0].Gy_ini[71,6] = 23.2849644809540
        struct[0].Gy_ini[71,7] = -24.9575997948692
        struct[0].Gy_ini[71,68] = -20.5427472507027
        struct[0].Gy_ini[71,69] = 79.2784458116403
        struct[0].Gy_ini[71,70] = 108.131545536521
        struct[0].Gy_ini[71,71] = -211.143538626360
        struct[0].Gy_ini[71,72] = -20.5427472507027
        struct[0].Gy_ini[71,73] = 79.2784458116403
        struct[0].Gy_ini[71,74] = -46.5699289619080
        struct[0].Gy_ini[71,75] = 49.9151995897384
        struct[0].Gy_ini[71,76] = 10.2713736253513
        struct[0].Gy_ini[71,77] = -39.6392229058202
        struct[0].Gy_ini[71,78] = -54.0657727682604
        struct[0].Gy_ini[71,79] = 105.571769313180
        struct[0].Gy_ini[71,80] = 10.2713736253513
        struct[0].Gy_ini[71,81] = -39.6392229058201
        struct[0].Gy_ini[71,82] = 23.2849644809540
        struct[0].Gy_ini[71,83] = -24.9575997948692
        struct[0].Gy_ini[72,0] = -24.9575997948692
        struct[0].Gy_ini[72,1] = -23.2849644809540
        struct[0].Gy_ini[72,2] = -39.6392229058202
        struct[0].Gy_ini[72,3] = -10.2713736253513
        struct[0].Gy_ini[72,4] = 105.571769313180
        struct[0].Gy_ini[72,5] = 54.0657727682604
        struct[0].Gy_ini[72,6] = -39.6392229058201
        struct[0].Gy_ini[72,7] = -10.2713736253514
        struct[0].Gy_ini[72,68] = 49.9151995897384
        struct[0].Gy_ini[72,69] = 46.5699289619080
        struct[0].Gy_ini[72,70] = 79.2784458116404
        struct[0].Gy_ini[72,71] = 20.5427472507027
        struct[0].Gy_ini[72,72] = -211.143538626360
        struct[0].Gy_ini[72,73] = -108.131545536521
        struct[0].Gy_ini[72,74] = 79.2784458116403
        struct[0].Gy_ini[72,75] = 20.5427472507027
        struct[0].Gy_ini[72,76] = -24.9575997948692
        struct[0].Gy_ini[72,77] = -23.2849644809540
        struct[0].Gy_ini[72,78] = -39.6392229058202
        struct[0].Gy_ini[72,79] = -10.2713736253513
        struct[0].Gy_ini[72,80] = 105.571769313180
        struct[0].Gy_ini[72,81] = 54.0657727682604
        struct[0].Gy_ini[72,82] = -39.6392229058201
        struct[0].Gy_ini[72,83] = -10.2713736253514
        struct[0].Gy_ini[73,0] = 23.2849644809540
        struct[0].Gy_ini[73,1] = -24.9575997948692
        struct[0].Gy_ini[73,2] = 10.2713736253513
        struct[0].Gy_ini[73,3] = -39.6392229058202
        struct[0].Gy_ini[73,4] = -54.0657727682604
        struct[0].Gy_ini[73,5] = 105.571769313180
        struct[0].Gy_ini[73,6] = 10.2713736253514
        struct[0].Gy_ini[73,7] = -39.6392229058201
        struct[0].Gy_ini[73,68] = -46.5699289619080
        struct[0].Gy_ini[73,69] = 49.9151995897384
        struct[0].Gy_ini[73,70] = -20.5427472507027
        struct[0].Gy_ini[73,71] = 79.2784458116404
        struct[0].Gy_ini[73,72] = 108.131545536521
        struct[0].Gy_ini[73,73] = -211.143538626360
        struct[0].Gy_ini[73,74] = -20.5427472507027
        struct[0].Gy_ini[73,75] = 79.2784458116403
        struct[0].Gy_ini[73,76] = 23.2849644809540
        struct[0].Gy_ini[73,77] = -24.9575997948692
        struct[0].Gy_ini[73,78] = 10.2713736253513
        struct[0].Gy_ini[73,79] = -39.6392229058202
        struct[0].Gy_ini[73,80] = -54.0657727682604
        struct[0].Gy_ini[73,81] = 105.571769313180
        struct[0].Gy_ini[73,82] = 10.2713736253514
        struct[0].Gy_ini[73,83] = -39.6392229058201
        struct[0].Gy_ini[74,0] = -39.6392229058202
        struct[0].Gy_ini[74,1] = -10.2713736253513
        struct[0].Gy_ini[74,2] = -24.9575997948692
        struct[0].Gy_ini[74,3] = -23.2849644809540
        struct[0].Gy_ini[74,4] = -39.6392229058202
        struct[0].Gy_ini[74,5] = -10.2713736253513
        struct[0].Gy_ini[74,6] = 105.571769313180
        struct[0].Gy_ini[74,7] = 54.0657727682604
        struct[0].Gy_ini[74,68] = 79.2784458116403
        struct[0].Gy_ini[74,69] = 20.5427472507027
        struct[0].Gy_ini[74,70] = 49.9151995897384
        struct[0].Gy_ini[74,71] = 46.5699289619080
        struct[0].Gy_ini[74,72] = 79.2784458116403
        struct[0].Gy_ini[74,73] = 20.5427472507027
        struct[0].Gy_ini[74,74] = -211.168538626360
        struct[0].Gy_ini[74,75] = -108.131545536521
        struct[0].Gy_ini[74,76] = -39.6392229058202
        struct[0].Gy_ini[74,77] = -10.2713736253513
        struct[0].Gy_ini[74,78] = -24.9575997948692
        struct[0].Gy_ini[74,79] = -23.2849644809540
        struct[0].Gy_ini[74,80] = -39.6392229058202
        struct[0].Gy_ini[74,81] = -10.2713736253513
        struct[0].Gy_ini[74,82] = 105.571769313180
        struct[0].Gy_ini[74,83] = 54.0657727682604
        struct[0].Gy_ini[75,0] = 10.2713736253513
        struct[0].Gy_ini[75,1] = -39.6392229058202
        struct[0].Gy_ini[75,2] = 23.2849644809540
        struct[0].Gy_ini[75,3] = -24.9575997948692
        struct[0].Gy_ini[75,4] = 10.2713736253513
        struct[0].Gy_ini[75,5] = -39.6392229058202
        struct[0].Gy_ini[75,6] = -54.0657727682604
        struct[0].Gy_ini[75,7] = 105.571769313180
        struct[0].Gy_ini[75,68] = -20.5427472507027
        struct[0].Gy_ini[75,69] = 79.2784458116403
        struct[0].Gy_ini[75,70] = -46.5699289619080
        struct[0].Gy_ini[75,71] = 49.9151995897384
        struct[0].Gy_ini[75,72] = -20.5427472507027
        struct[0].Gy_ini[75,73] = 79.2784458116403
        struct[0].Gy_ini[75,74] = 108.131545536521
        struct[0].Gy_ini[75,75] = -211.168538626360
        struct[0].Gy_ini[75,76] = 10.2713736253513
        struct[0].Gy_ini[75,77] = -39.6392229058202
        struct[0].Gy_ini[75,78] = 23.2849644809540
        struct[0].Gy_ini[75,79] = -24.9575997948692
        struct[0].Gy_ini[75,80] = 10.2713736253513
        struct[0].Gy_ini[75,81] = -39.6392229058202
        struct[0].Gy_ini[75,82] = -54.0657727682604
        struct[0].Gy_ini[75,83] = 105.571769313180
        struct[0].Gy_ini[76,8] = 26.5300693004806
        struct[0].Gy_ini[76,9] = 4.84676915585801
        struct[0].Gy_ini[76,10] = -7.89461337514770
        struct[0].Gy_ini[76,11] = 1.58482814504483
        struct[0].Gy_ini[76,12] = -7.72144347466701
        struct[0].Gy_ini[76,13] = 0.679918453285310
        struct[0].Gy_ini[76,14] = -7.89461337514771
        struct[0].Gy_ini[76,15] = 1.58482814504483
        struct[0].Gy_ini[76,68] = 105.571769313180
        struct[0].Gy_ini[76,69] = 54.0657727682604
        struct[0].Gy_ini[76,70] = -39.6392229058202
        struct[0].Gy_ini[76,71] = -10.2713736253513
        struct[0].Gy_ini[76,72] = -24.9575997948692
        struct[0].Gy_ini[76,73] = -23.2849644809540
        struct[0].Gy_ini[76,74] = -39.6392229058202
        struct[0].Gy_ini[76,75] = -10.2713736253513
        struct[0].Gy_ini[76,76] = -237.673607926841
        struct[0].Gy_ini[76,77] = -112.978314692379
        struct[0].Gy_ini[76,78] = 87.1730591867880
        struct[0].Gy_ini[76,79] = 18.9579191056578
        struct[0].Gy_ini[76,80] = 57.6366430644055
        struct[0].Gy_ini[76,81] = 45.8900105086227
        struct[0].Gy_ini[76,82] = 87.1730591867880
        struct[0].Gy_ini[76,83] = 18.9579191056579
        struct[0].Gy_ini[76,84] = 105.571769313180
        struct[0].Gy_ini[76,85] = 54.0657727682604
        struct[0].Gy_ini[76,86] = -39.6392229058202
        struct[0].Gy_ini[76,87] = -10.2713736253513
        struct[0].Gy_ini[76,88] = -24.9575997948692
        struct[0].Gy_ini[76,89] = -23.2849644809540
        struct[0].Gy_ini[76,90] = -39.6392229058202
        struct[0].Gy_ini[76,91] = -10.2713736253513
        struct[0].Gy_ini[77,8] = -4.84676915585801
        struct[0].Gy_ini[77,9] = 26.5300693004806
        struct[0].Gy_ini[77,10] = -1.58482814504483
        struct[0].Gy_ini[77,11] = -7.89461337514770
        struct[0].Gy_ini[77,12] = -0.679918453285310
        struct[0].Gy_ini[77,13] = -7.72144347466701
        struct[0].Gy_ini[77,14] = -1.58482814504483
        struct[0].Gy_ini[77,15] = -7.89461337514771
        struct[0].Gy_ini[77,68] = -54.0657727682604
        struct[0].Gy_ini[77,69] = 105.571769313180
        struct[0].Gy_ini[77,70] = 10.2713736253513
        struct[0].Gy_ini[77,71] = -39.6392229058202
        struct[0].Gy_ini[77,72] = 23.2849644809540
        struct[0].Gy_ini[77,73] = -24.9575997948692
        struct[0].Gy_ini[77,74] = 10.2713736253513
        struct[0].Gy_ini[77,75] = -39.6392229058202
        struct[0].Gy_ini[77,76] = 112.978314692379
        struct[0].Gy_ini[77,77] = -237.673607926841
        struct[0].Gy_ini[77,78] = -18.9579191056578
        struct[0].Gy_ini[77,79] = 87.1730591867880
        struct[0].Gy_ini[77,80] = -45.8900105086227
        struct[0].Gy_ini[77,81] = 57.6366430644055
        struct[0].Gy_ini[77,82] = -18.9579191056579
        struct[0].Gy_ini[77,83] = 87.1730591867880
        struct[0].Gy_ini[77,84] = -54.0657727682604
        struct[0].Gy_ini[77,85] = 105.571769313180
        struct[0].Gy_ini[77,86] = 10.2713736253513
        struct[0].Gy_ini[77,87] = -39.6392229058202
        struct[0].Gy_ini[77,88] = 23.2849644809540
        struct[0].Gy_ini[77,89] = -24.9575997948692
        struct[0].Gy_ini[77,90] = 10.2713736253513
        struct[0].Gy_ini[77,91] = -39.6392229058202
        struct[0].Gy_ini[78,8] = -7.89461337514771
        struct[0].Gy_ini[78,9] = 1.58482814504483
        struct[0].Gy_ini[78,10] = 26.5300693004806
        struct[0].Gy_ini[78,11] = 4.84676915585801
        struct[0].Gy_ini[78,12] = -7.89461337514771
        struct[0].Gy_ini[78,13] = 1.58482814504483
        struct[0].Gy_ini[78,14] = -7.72144347466701
        struct[0].Gy_ini[78,15] = 0.679918453285308
        struct[0].Gy_ini[78,68] = -39.6392229058202
        struct[0].Gy_ini[78,69] = -10.2713736253513
        struct[0].Gy_ini[78,70] = 105.571769313180
        struct[0].Gy_ini[78,71] = 54.0657727682604
        struct[0].Gy_ini[78,72] = -39.6392229058201
        struct[0].Gy_ini[78,73] = -10.2713736253513
        struct[0].Gy_ini[78,74] = -24.9575997948692
        struct[0].Gy_ini[78,75] = -23.2849644809540
        struct[0].Gy_ini[78,76] = 87.1730591867880
        struct[0].Gy_ini[78,77] = 18.9579191056579
        struct[0].Gy_ini[78,78] = -237.673607926841
        struct[0].Gy_ini[78,79] = -112.978314692379
        struct[0].Gy_ini[78,80] = 87.1730591867880
        struct[0].Gy_ini[78,81] = 18.9579191056579
        struct[0].Gy_ini[78,82] = 57.6366430644054
        struct[0].Gy_ini[78,83] = 45.8900105086227
        struct[0].Gy_ini[78,84] = -39.6392229058202
        struct[0].Gy_ini[78,85] = -10.2713736253513
        struct[0].Gy_ini[78,86] = 105.571769313180
        struct[0].Gy_ini[78,87] = 54.0657727682604
        struct[0].Gy_ini[78,88] = -39.6392229058201
        struct[0].Gy_ini[78,89] = -10.2713736253513
        struct[0].Gy_ini[78,90] = -24.9575997948692
        struct[0].Gy_ini[78,91] = -23.2849644809540
        struct[0].Gy_ini[79,8] = -1.58482814504483
        struct[0].Gy_ini[79,9] = -7.89461337514771
        struct[0].Gy_ini[79,10] = -4.84676915585801
        struct[0].Gy_ini[79,11] = 26.5300693004806
        struct[0].Gy_ini[79,12] = -1.58482814504483
        struct[0].Gy_ini[79,13] = -7.89461337514771
        struct[0].Gy_ini[79,14] = -0.679918453285308
        struct[0].Gy_ini[79,15] = -7.72144347466701
        struct[0].Gy_ini[79,68] = 10.2713736253513
        struct[0].Gy_ini[79,69] = -39.6392229058202
        struct[0].Gy_ini[79,70] = -54.0657727682604
        struct[0].Gy_ini[79,71] = 105.571769313180
        struct[0].Gy_ini[79,72] = 10.2713736253513
        struct[0].Gy_ini[79,73] = -39.6392229058201
        struct[0].Gy_ini[79,74] = 23.2849644809540
        struct[0].Gy_ini[79,75] = -24.9575997948692
        struct[0].Gy_ini[79,76] = -18.9579191056579
        struct[0].Gy_ini[79,77] = 87.1730591867880
        struct[0].Gy_ini[79,78] = 112.978314692379
        struct[0].Gy_ini[79,79] = -237.673607926841
        struct[0].Gy_ini[79,80] = -18.9579191056579
        struct[0].Gy_ini[79,81] = 87.1730591867880
        struct[0].Gy_ini[79,82] = -45.8900105086227
        struct[0].Gy_ini[79,83] = 57.6366430644054
        struct[0].Gy_ini[79,84] = 10.2713736253513
        struct[0].Gy_ini[79,85] = -39.6392229058202
        struct[0].Gy_ini[79,86] = -54.0657727682604
        struct[0].Gy_ini[79,87] = 105.571769313180
        struct[0].Gy_ini[79,88] = 10.2713736253513
        struct[0].Gy_ini[79,89] = -39.6392229058201
        struct[0].Gy_ini[79,90] = 23.2849644809540
        struct[0].Gy_ini[79,91] = -24.9575997948692
        struct[0].Gy_ini[80,8] = -7.72144347466701
        struct[0].Gy_ini[80,9] = 0.679918453285310
        struct[0].Gy_ini[80,10] = -7.89461337514770
        struct[0].Gy_ini[80,11] = 1.58482814504483
        struct[0].Gy_ini[80,12] = 26.5300693004806
        struct[0].Gy_ini[80,13] = 4.84676915585801
        struct[0].Gy_ini[80,14] = -7.89461337514771
        struct[0].Gy_ini[80,15] = 1.58482814504483
        struct[0].Gy_ini[80,68] = -24.9575997948692
        struct[0].Gy_ini[80,69] = -23.2849644809540
        struct[0].Gy_ini[80,70] = -39.6392229058202
        struct[0].Gy_ini[80,71] = -10.2713736253513
        struct[0].Gy_ini[80,72] = 105.571769313180
        struct[0].Gy_ini[80,73] = 54.0657727682604
        struct[0].Gy_ini[80,74] = -39.6392229058201
        struct[0].Gy_ini[80,75] = -10.2713736253514
        struct[0].Gy_ini[80,76] = 57.6366430644054
        struct[0].Gy_ini[80,77] = 45.8900105086227
        struct[0].Gy_ini[80,78] = 87.1730591867881
        struct[0].Gy_ini[80,79] = 18.9579191056578
        struct[0].Gy_ini[80,80] = -237.673607926841
        struct[0].Gy_ini[80,81] = -112.978314692379
        struct[0].Gy_ini[80,82] = 87.1730591867880
        struct[0].Gy_ini[80,83] = 18.9579191056579
        struct[0].Gy_ini[80,84] = -24.9575997948692
        struct[0].Gy_ini[80,85] = -23.2849644809540
        struct[0].Gy_ini[80,86] = -39.6392229058202
        struct[0].Gy_ini[80,87] = -10.2713736253513
        struct[0].Gy_ini[80,88] = 105.571769313180
        struct[0].Gy_ini[80,89] = 54.0657727682604
        struct[0].Gy_ini[80,90] = -39.6392229058201
        struct[0].Gy_ini[80,91] = -10.2713736253514
        struct[0].Gy_ini[81,8] = -0.679918453285310
        struct[0].Gy_ini[81,9] = -7.72144347466701
        struct[0].Gy_ini[81,10] = -1.58482814504483
        struct[0].Gy_ini[81,11] = -7.89461337514770
        struct[0].Gy_ini[81,12] = -4.84676915585801
        struct[0].Gy_ini[81,13] = 26.5300693004806
        struct[0].Gy_ini[81,14] = -1.58482814504483
        struct[0].Gy_ini[81,15] = -7.89461337514771
        struct[0].Gy_ini[81,68] = 23.2849644809540
        struct[0].Gy_ini[81,69] = -24.9575997948692
        struct[0].Gy_ini[81,70] = 10.2713736253513
        struct[0].Gy_ini[81,71] = -39.6392229058202
        struct[0].Gy_ini[81,72] = -54.0657727682604
        struct[0].Gy_ini[81,73] = 105.571769313180
        struct[0].Gy_ini[81,74] = 10.2713736253514
        struct[0].Gy_ini[81,75] = -39.6392229058201
        struct[0].Gy_ini[81,76] = -45.8900105086227
        struct[0].Gy_ini[81,77] = 57.6366430644054
        struct[0].Gy_ini[81,78] = -18.9579191056578
        struct[0].Gy_ini[81,79] = 87.1730591867881
        struct[0].Gy_ini[81,80] = 112.978314692379
        struct[0].Gy_ini[81,81] = -237.673607926841
        struct[0].Gy_ini[81,82] = -18.9579191056579
        struct[0].Gy_ini[81,83] = 87.1730591867880
        struct[0].Gy_ini[81,84] = 23.2849644809540
        struct[0].Gy_ini[81,85] = -24.9575997948692
        struct[0].Gy_ini[81,86] = 10.2713736253513
        struct[0].Gy_ini[81,87] = -39.6392229058202
        struct[0].Gy_ini[81,88] = -54.0657727682604
        struct[0].Gy_ini[81,89] = 105.571769313180
        struct[0].Gy_ini[81,90] = 10.2713736253514
        struct[0].Gy_ini[81,91] = -39.6392229058201
        struct[0].Gy_ini[82,8] = -7.89461337514771
        struct[0].Gy_ini[82,9] = 1.58482814504483
        struct[0].Gy_ini[82,10] = -7.72144347466701
        struct[0].Gy_ini[82,11] = 0.679918453285308
        struct[0].Gy_ini[82,12] = -7.89461337514771
        struct[0].Gy_ini[82,13] = 1.58482814504483
        struct[0].Gy_ini[82,14] = 26.5300693004806
        struct[0].Gy_ini[82,15] = 4.84676915585801
        struct[0].Gy_ini[82,68] = -39.6392229058202
        struct[0].Gy_ini[82,69] = -10.2713736253513
        struct[0].Gy_ini[82,70] = -24.9575997948692
        struct[0].Gy_ini[82,71] = -23.2849644809540
        struct[0].Gy_ini[82,72] = -39.6392229058202
        struct[0].Gy_ini[82,73] = -10.2713736253513
        struct[0].Gy_ini[82,74] = 105.571769313180
        struct[0].Gy_ini[82,75] = 54.0657727682604
        struct[0].Gy_ini[82,76] = 87.1730591867880
        struct[0].Gy_ini[82,77] = 18.9579191056578
        struct[0].Gy_ini[82,78] = 57.6366430644054
        struct[0].Gy_ini[82,79] = 45.8900105086227
        struct[0].Gy_ini[82,80] = 87.1730591867880
        struct[0].Gy_ini[82,81] = 18.9579191056579
        struct[0].Gy_ini[82,82] = -237.673607926841
        struct[0].Gy_ini[82,83] = -112.978314692379
        struct[0].Gy_ini[82,84] = -39.6392229058202
        struct[0].Gy_ini[82,85] = -10.2713736253513
        struct[0].Gy_ini[82,86] = -24.9575997948692
        struct[0].Gy_ini[82,87] = -23.2849644809540
        struct[0].Gy_ini[82,88] = -39.6392229058202
        struct[0].Gy_ini[82,89] = -10.2713736253513
        struct[0].Gy_ini[82,90] = 105.571769313180
        struct[0].Gy_ini[82,91] = 54.0657727682604
        struct[0].Gy_ini[83,8] = -1.58482814504483
        struct[0].Gy_ini[83,9] = -7.89461337514771
        struct[0].Gy_ini[83,10] = -0.679918453285308
        struct[0].Gy_ini[83,11] = -7.72144347466701
        struct[0].Gy_ini[83,12] = -1.58482814504483
        struct[0].Gy_ini[83,13] = -7.89461337514771
        struct[0].Gy_ini[83,14] = -4.84676915585801
        struct[0].Gy_ini[83,15] = 26.5300693004806
        struct[0].Gy_ini[83,68] = 10.2713736253513
        struct[0].Gy_ini[83,69] = -39.6392229058202
        struct[0].Gy_ini[83,70] = 23.2849644809540
        struct[0].Gy_ini[83,71] = -24.9575997948692
        struct[0].Gy_ini[83,72] = 10.2713736253513
        struct[0].Gy_ini[83,73] = -39.6392229058202
        struct[0].Gy_ini[83,74] = -54.0657727682604
        struct[0].Gy_ini[83,75] = 105.571769313180
        struct[0].Gy_ini[83,76] = -18.9579191056578
        struct[0].Gy_ini[83,77] = 87.1730591867880
        struct[0].Gy_ini[83,78] = -45.8900105086227
        struct[0].Gy_ini[83,79] = 57.6366430644054
        struct[0].Gy_ini[83,80] = -18.9579191056579
        struct[0].Gy_ini[83,81] = 87.1730591867880
        struct[0].Gy_ini[83,82] = 112.978314692379
        struct[0].Gy_ini[83,83] = -237.673607926841
        struct[0].Gy_ini[83,84] = 10.2713736253513
        struct[0].Gy_ini[83,85] = -39.6392229058202
        struct[0].Gy_ini[83,86] = 23.2849644809540
        struct[0].Gy_ini[83,87] = -24.9575997948692
        struct[0].Gy_ini[83,88] = 10.2713736253513
        struct[0].Gy_ini[83,89] = -39.6392229058202
        struct[0].Gy_ini[83,90] = -54.0657727682604
        struct[0].Gy_ini[83,91] = 105.571769313180
        struct[0].Gy_ini[84,76] = 105.571769313180
        struct[0].Gy_ini[84,77] = 54.0657727682604
        struct[0].Gy_ini[84,78] = -39.6392229058202
        struct[0].Gy_ini[84,79] = -10.2713736253513
        struct[0].Gy_ini[84,80] = -24.9575997948692
        struct[0].Gy_ini[84,81] = -23.2849644809540
        struct[0].Gy_ini[84,82] = -39.6392229058202
        struct[0].Gy_ini[84,83] = -10.2713736253513
        struct[0].Gy_ini[84,84] = -237.673607926841
        struct[0].Gy_ini[84,85] = -112.978314692379
        struct[0].Gy_ini[84,86] = 87.1730591867880
        struct[0].Gy_ini[84,87] = 18.9579191056578
        struct[0].Gy_ini[84,88] = 57.6366430644055
        struct[0].Gy_ini[84,89] = 45.8900105086227
        struct[0].Gy_ini[84,90] = 87.1730591867880
        struct[0].Gy_ini[84,91] = 18.9579191056579
        struct[0].Gy_ini[84,92] = 105.571769313180
        struct[0].Gy_ini[84,93] = 54.0657727682604
        struct[0].Gy_ini[84,94] = -39.6392229058202
        struct[0].Gy_ini[84,95] = -10.2713736253513
        struct[0].Gy_ini[84,96] = -24.9575997948692
        struct[0].Gy_ini[84,97] = -23.2849644809540
        struct[0].Gy_ini[84,98] = -39.6392229058202
        struct[0].Gy_ini[84,99] = -10.2713736253513
        struct[0].Gy_ini[84,140] = 26.5300693004806
        struct[0].Gy_ini[84,141] = 4.84676915585801
        struct[0].Gy_ini[84,142] = -7.89461337514770
        struct[0].Gy_ini[84,143] = 1.58482814504483
        struct[0].Gy_ini[84,144] = -7.72144347466701
        struct[0].Gy_ini[84,145] = 0.679918453285310
        struct[0].Gy_ini[84,146] = -7.89461337514771
        struct[0].Gy_ini[84,147] = 1.58482814504483
        struct[0].Gy_ini[85,76] = -54.0657727682604
        struct[0].Gy_ini[85,77] = 105.571769313180
        struct[0].Gy_ini[85,78] = 10.2713736253513
        struct[0].Gy_ini[85,79] = -39.6392229058202
        struct[0].Gy_ini[85,80] = 23.2849644809540
        struct[0].Gy_ini[85,81] = -24.9575997948692
        struct[0].Gy_ini[85,82] = 10.2713736253513
        struct[0].Gy_ini[85,83] = -39.6392229058202
        struct[0].Gy_ini[85,84] = 112.978314692379
        struct[0].Gy_ini[85,85] = -237.673607926841
        struct[0].Gy_ini[85,86] = -18.9579191056578
        struct[0].Gy_ini[85,87] = 87.1730591867880
        struct[0].Gy_ini[85,88] = -45.8900105086227
        struct[0].Gy_ini[85,89] = 57.6366430644055
        struct[0].Gy_ini[85,90] = -18.9579191056579
        struct[0].Gy_ini[85,91] = 87.1730591867880
        struct[0].Gy_ini[85,92] = -54.0657727682604
        struct[0].Gy_ini[85,93] = 105.571769313180
        struct[0].Gy_ini[85,94] = 10.2713736253513
        struct[0].Gy_ini[85,95] = -39.6392229058202
        struct[0].Gy_ini[85,96] = 23.2849644809540
        struct[0].Gy_ini[85,97] = -24.9575997948692
        struct[0].Gy_ini[85,98] = 10.2713736253513
        struct[0].Gy_ini[85,99] = -39.6392229058202
        struct[0].Gy_ini[85,140] = -4.84676915585801
        struct[0].Gy_ini[85,141] = 26.5300693004806
        struct[0].Gy_ini[85,142] = -1.58482814504483
        struct[0].Gy_ini[85,143] = -7.89461337514770
        struct[0].Gy_ini[85,144] = -0.679918453285310
        struct[0].Gy_ini[85,145] = -7.72144347466701
        struct[0].Gy_ini[85,146] = -1.58482814504483
        struct[0].Gy_ini[85,147] = -7.89461337514771
        struct[0].Gy_ini[86,76] = -39.6392229058202
        struct[0].Gy_ini[86,77] = -10.2713736253513
        struct[0].Gy_ini[86,78] = 105.571769313180
        struct[0].Gy_ini[86,79] = 54.0657727682604
        struct[0].Gy_ini[86,80] = -39.6392229058201
        struct[0].Gy_ini[86,81] = -10.2713736253513
        struct[0].Gy_ini[86,82] = -24.9575997948692
        struct[0].Gy_ini[86,83] = -23.2849644809540
        struct[0].Gy_ini[86,84] = 87.1730591867880
        struct[0].Gy_ini[86,85] = 18.9579191056579
        struct[0].Gy_ini[86,86] = -237.673607926841
        struct[0].Gy_ini[86,87] = -112.978314692379
        struct[0].Gy_ini[86,88] = 87.1730591867880
        struct[0].Gy_ini[86,89] = 18.9579191056579
        struct[0].Gy_ini[86,90] = 57.6366430644054
        struct[0].Gy_ini[86,91] = 45.8900105086227
        struct[0].Gy_ini[86,92] = -39.6392229058202
        struct[0].Gy_ini[86,93] = -10.2713736253513
        struct[0].Gy_ini[86,94] = 105.571769313180
        struct[0].Gy_ini[86,95] = 54.0657727682604
        struct[0].Gy_ini[86,96] = -39.6392229058201
        struct[0].Gy_ini[86,97] = -10.2713736253513
        struct[0].Gy_ini[86,98] = -24.9575997948692
        struct[0].Gy_ini[86,99] = -23.2849644809540
        struct[0].Gy_ini[86,140] = -7.89461337514771
        struct[0].Gy_ini[86,141] = 1.58482814504483
        struct[0].Gy_ini[86,142] = 26.5300693004806
        struct[0].Gy_ini[86,143] = 4.84676915585801
        struct[0].Gy_ini[86,144] = -7.89461337514771
        struct[0].Gy_ini[86,145] = 1.58482814504483
        struct[0].Gy_ini[86,146] = -7.72144347466701
        struct[0].Gy_ini[86,147] = 0.679918453285308
        struct[0].Gy_ini[87,76] = 10.2713736253513
        struct[0].Gy_ini[87,77] = -39.6392229058202
        struct[0].Gy_ini[87,78] = -54.0657727682604
        struct[0].Gy_ini[87,79] = 105.571769313180
        struct[0].Gy_ini[87,80] = 10.2713736253513
        struct[0].Gy_ini[87,81] = -39.6392229058201
        struct[0].Gy_ini[87,82] = 23.2849644809540
        struct[0].Gy_ini[87,83] = -24.9575997948692
        struct[0].Gy_ini[87,84] = -18.9579191056579
        struct[0].Gy_ini[87,85] = 87.1730591867880
        struct[0].Gy_ini[87,86] = 112.978314692379
        struct[0].Gy_ini[87,87] = -237.673607926841
        struct[0].Gy_ini[87,88] = -18.9579191056579
        struct[0].Gy_ini[87,89] = 87.1730591867880
        struct[0].Gy_ini[87,90] = -45.8900105086227
        struct[0].Gy_ini[87,91] = 57.6366430644054
        struct[0].Gy_ini[87,92] = 10.2713736253513
        struct[0].Gy_ini[87,93] = -39.6392229058202
        struct[0].Gy_ini[87,94] = -54.0657727682604
        struct[0].Gy_ini[87,95] = 105.571769313180
        struct[0].Gy_ini[87,96] = 10.2713736253513
        struct[0].Gy_ini[87,97] = -39.6392229058201
        struct[0].Gy_ini[87,98] = 23.2849644809540
        struct[0].Gy_ini[87,99] = -24.9575997948692
        struct[0].Gy_ini[87,140] = -1.58482814504483
        struct[0].Gy_ini[87,141] = -7.89461337514771
        struct[0].Gy_ini[87,142] = -4.84676915585801
        struct[0].Gy_ini[87,143] = 26.5300693004806
        struct[0].Gy_ini[87,144] = -1.58482814504483
        struct[0].Gy_ini[87,145] = -7.89461337514771
        struct[0].Gy_ini[87,146] = -0.679918453285308
        struct[0].Gy_ini[87,147] = -7.72144347466701
        struct[0].Gy_ini[88,76] = -24.9575997948692
        struct[0].Gy_ini[88,77] = -23.2849644809540
        struct[0].Gy_ini[88,78] = -39.6392229058202
        struct[0].Gy_ini[88,79] = -10.2713736253513
        struct[0].Gy_ini[88,80] = 105.571769313180
        struct[0].Gy_ini[88,81] = 54.0657727682604
        struct[0].Gy_ini[88,82] = -39.6392229058201
        struct[0].Gy_ini[88,83] = -10.2713736253514
        struct[0].Gy_ini[88,84] = 57.6366430644054
        struct[0].Gy_ini[88,85] = 45.8900105086227
        struct[0].Gy_ini[88,86] = 87.1730591867881
        struct[0].Gy_ini[88,87] = 18.9579191056578
        struct[0].Gy_ini[88,88] = -237.673607926841
        struct[0].Gy_ini[88,89] = -112.978314692379
        struct[0].Gy_ini[88,90] = 87.1730591867880
        struct[0].Gy_ini[88,91] = 18.9579191056579
        struct[0].Gy_ini[88,92] = -24.9575997948692
        struct[0].Gy_ini[88,93] = -23.2849644809540
        struct[0].Gy_ini[88,94] = -39.6392229058202
        struct[0].Gy_ini[88,95] = -10.2713736253513
        struct[0].Gy_ini[88,96] = 105.571769313180
        struct[0].Gy_ini[88,97] = 54.0657727682604
        struct[0].Gy_ini[88,98] = -39.6392229058201
        struct[0].Gy_ini[88,99] = -10.2713736253514
        struct[0].Gy_ini[88,140] = -7.72144347466701
        struct[0].Gy_ini[88,141] = 0.679918453285310
        struct[0].Gy_ini[88,142] = -7.89461337514770
        struct[0].Gy_ini[88,143] = 1.58482814504483
        struct[0].Gy_ini[88,144] = 26.5300693004806
        struct[0].Gy_ini[88,145] = 4.84676915585801
        struct[0].Gy_ini[88,146] = -7.89461337514771
        struct[0].Gy_ini[88,147] = 1.58482814504483
        struct[0].Gy_ini[89,76] = 23.2849644809540
        struct[0].Gy_ini[89,77] = -24.9575997948692
        struct[0].Gy_ini[89,78] = 10.2713736253513
        struct[0].Gy_ini[89,79] = -39.6392229058202
        struct[0].Gy_ini[89,80] = -54.0657727682604
        struct[0].Gy_ini[89,81] = 105.571769313180
        struct[0].Gy_ini[89,82] = 10.2713736253514
        struct[0].Gy_ini[89,83] = -39.6392229058201
        struct[0].Gy_ini[89,84] = -45.8900105086227
        struct[0].Gy_ini[89,85] = 57.6366430644054
        struct[0].Gy_ini[89,86] = -18.9579191056578
        struct[0].Gy_ini[89,87] = 87.1730591867881
        struct[0].Gy_ini[89,88] = 112.978314692379
        struct[0].Gy_ini[89,89] = -237.673607926841
        struct[0].Gy_ini[89,90] = -18.9579191056579
        struct[0].Gy_ini[89,91] = 87.1730591867880
        struct[0].Gy_ini[89,92] = 23.2849644809540
        struct[0].Gy_ini[89,93] = -24.9575997948692
        struct[0].Gy_ini[89,94] = 10.2713736253513
        struct[0].Gy_ini[89,95] = -39.6392229058202
        struct[0].Gy_ini[89,96] = -54.0657727682604
        struct[0].Gy_ini[89,97] = 105.571769313180
        struct[0].Gy_ini[89,98] = 10.2713736253514
        struct[0].Gy_ini[89,99] = -39.6392229058201
        struct[0].Gy_ini[89,140] = -0.679918453285310
        struct[0].Gy_ini[89,141] = -7.72144347466701
        struct[0].Gy_ini[89,142] = -1.58482814504483
        struct[0].Gy_ini[89,143] = -7.89461337514770
        struct[0].Gy_ini[89,144] = -4.84676915585801
        struct[0].Gy_ini[89,145] = 26.5300693004806
        struct[0].Gy_ini[89,146] = -1.58482814504483
        struct[0].Gy_ini[89,147] = -7.89461337514771
        struct[0].Gy_ini[90,76] = -39.6392229058202
        struct[0].Gy_ini[90,77] = -10.2713736253513
        struct[0].Gy_ini[90,78] = -24.9575997948692
        struct[0].Gy_ini[90,79] = -23.2849644809540
        struct[0].Gy_ini[90,80] = -39.6392229058202
        struct[0].Gy_ini[90,81] = -10.2713736253513
        struct[0].Gy_ini[90,82] = 105.571769313180
        struct[0].Gy_ini[90,83] = 54.0657727682604
        struct[0].Gy_ini[90,84] = 87.1730591867880
        struct[0].Gy_ini[90,85] = 18.9579191056578
        struct[0].Gy_ini[90,86] = 57.6366430644054
        struct[0].Gy_ini[90,87] = 45.8900105086227
        struct[0].Gy_ini[90,88] = 87.1730591867880
        struct[0].Gy_ini[90,89] = 18.9579191056579
        struct[0].Gy_ini[90,90] = -237.698607926841
        struct[0].Gy_ini[90,91] = -112.978314692379
        struct[0].Gy_ini[90,92] = -39.6392229058202
        struct[0].Gy_ini[90,93] = -10.2713736253513
        struct[0].Gy_ini[90,94] = -24.9575997948692
        struct[0].Gy_ini[90,95] = -23.2849644809540
        struct[0].Gy_ini[90,96] = -39.6392229058202
        struct[0].Gy_ini[90,97] = -10.2713736253513
        struct[0].Gy_ini[90,98] = 105.571769313180
        struct[0].Gy_ini[90,99] = 54.0657727682604
        struct[0].Gy_ini[90,140] = -7.89461337514771
        struct[0].Gy_ini[90,141] = 1.58482814504483
        struct[0].Gy_ini[90,142] = -7.72144347466701
        struct[0].Gy_ini[90,143] = 0.679918453285308
        struct[0].Gy_ini[90,144] = -7.89461337514771
        struct[0].Gy_ini[90,145] = 1.58482814504483
        struct[0].Gy_ini[90,146] = 26.5300693004806
        struct[0].Gy_ini[90,147] = 4.84676915585801
        struct[0].Gy_ini[91,76] = 10.2713736253513
        struct[0].Gy_ini[91,77] = -39.6392229058202
        struct[0].Gy_ini[91,78] = 23.2849644809540
        struct[0].Gy_ini[91,79] = -24.9575997948692
        struct[0].Gy_ini[91,80] = 10.2713736253513
        struct[0].Gy_ini[91,81] = -39.6392229058202
        struct[0].Gy_ini[91,82] = -54.0657727682604
        struct[0].Gy_ini[91,83] = 105.571769313180
        struct[0].Gy_ini[91,84] = -18.9579191056578
        struct[0].Gy_ini[91,85] = 87.1730591867880
        struct[0].Gy_ini[91,86] = -45.8900105086227
        struct[0].Gy_ini[91,87] = 57.6366430644054
        struct[0].Gy_ini[91,88] = -18.9579191056579
        struct[0].Gy_ini[91,89] = 87.1730591867880
        struct[0].Gy_ini[91,90] = 112.978314692379
        struct[0].Gy_ini[91,91] = -237.698607926841
        struct[0].Gy_ini[91,92] = 10.2713736253513
        struct[0].Gy_ini[91,93] = -39.6392229058202
        struct[0].Gy_ini[91,94] = 23.2849644809540
        struct[0].Gy_ini[91,95] = -24.9575997948692
        struct[0].Gy_ini[91,96] = 10.2713736253513
        struct[0].Gy_ini[91,97] = -39.6392229058202
        struct[0].Gy_ini[91,98] = -54.0657727682604
        struct[0].Gy_ini[91,99] = 105.571769313180
        struct[0].Gy_ini[91,140] = -1.58482814504483
        struct[0].Gy_ini[91,141] = -7.89461337514771
        struct[0].Gy_ini[91,142] = -0.679918453285308
        struct[0].Gy_ini[91,143] = -7.72144347466701
        struct[0].Gy_ini[91,144] = -1.58482814504483
        struct[0].Gy_ini[91,145] = -7.89461337514771
        struct[0].Gy_ini[91,146] = -4.84676915585801
        struct[0].Gy_ini[91,147] = 26.5300693004806
        struct[0].Gy_ini[92,84] = 105.571769313180
        struct[0].Gy_ini[92,85] = 54.0657727682604
        struct[0].Gy_ini[92,86] = -39.6392229058202
        struct[0].Gy_ini[92,87] = -10.2713736253513
        struct[0].Gy_ini[92,88] = -24.9575997948692
        struct[0].Gy_ini[92,89] = -23.2849644809540
        struct[0].Gy_ini[92,90] = -39.6392229058202
        struct[0].Gy_ini[92,91] = -10.2713736253513
        struct[0].Gy_ini[92,92] = -211.143538626360
        struct[0].Gy_ini[92,93] = -108.131545536521
        struct[0].Gy_ini[92,94] = 79.2784458116403
        struct[0].Gy_ini[92,95] = 20.5427472507027
        struct[0].Gy_ini[92,96] = 49.9151995897384
        struct[0].Gy_ini[92,97] = 46.5699289619080
        struct[0].Gy_ini[92,98] = 79.2784458116403
        struct[0].Gy_ini[92,99] = 20.5427472507027
        struct[0].Gy_ini[92,100] = 105.571769313180
        struct[0].Gy_ini[92,101] = 54.0657727682604
        struct[0].Gy_ini[92,102] = -39.6392229058202
        struct[0].Gy_ini[92,103] = -10.2713736253513
        struct[0].Gy_ini[92,104] = -24.9575997948692
        struct[0].Gy_ini[92,105] = -23.2849644809540
        struct[0].Gy_ini[92,106] = -39.6392229058202
        struct[0].Gy_ini[92,107] = -10.2713736253513
        struct[0].Gy_ini[93,84] = -54.0657727682604
        struct[0].Gy_ini[93,85] = 105.571769313180
        struct[0].Gy_ini[93,86] = 10.2713736253513
        struct[0].Gy_ini[93,87] = -39.6392229058202
        struct[0].Gy_ini[93,88] = 23.2849644809540
        struct[0].Gy_ini[93,89] = -24.9575997948692
        struct[0].Gy_ini[93,90] = 10.2713736253513
        struct[0].Gy_ini[93,91] = -39.6392229058202
        struct[0].Gy_ini[93,92] = 108.131545536521
        struct[0].Gy_ini[93,93] = -211.143538626360
        struct[0].Gy_ini[93,94] = -20.5427472507027
        struct[0].Gy_ini[93,95] = 79.2784458116403
        struct[0].Gy_ini[93,96] = -46.5699289619080
        struct[0].Gy_ini[93,97] = 49.9151995897384
        struct[0].Gy_ini[93,98] = -20.5427472507027
        struct[0].Gy_ini[93,99] = 79.2784458116403
        struct[0].Gy_ini[93,100] = -54.0657727682604
        struct[0].Gy_ini[93,101] = 105.571769313180
        struct[0].Gy_ini[93,102] = 10.2713736253513
        struct[0].Gy_ini[93,103] = -39.6392229058202
        struct[0].Gy_ini[93,104] = 23.2849644809540
        struct[0].Gy_ini[93,105] = -24.9575997948692
        struct[0].Gy_ini[93,106] = 10.2713736253513
        struct[0].Gy_ini[93,107] = -39.6392229058202
        struct[0].Gy_ini[94,84] = -39.6392229058202
        struct[0].Gy_ini[94,85] = -10.2713736253513
        struct[0].Gy_ini[94,86] = 105.571769313180
        struct[0].Gy_ini[94,87] = 54.0657727682604
        struct[0].Gy_ini[94,88] = -39.6392229058201
        struct[0].Gy_ini[94,89] = -10.2713736253513
        struct[0].Gy_ini[94,90] = -24.9575997948692
        struct[0].Gy_ini[94,91] = -23.2849644809540
        struct[0].Gy_ini[94,92] = 79.2784458116403
        struct[0].Gy_ini[94,93] = 20.5427472507027
        struct[0].Gy_ini[94,94] = -211.143538626360
        struct[0].Gy_ini[94,95] = -108.131545536521
        struct[0].Gy_ini[94,96] = 79.2784458116403
        struct[0].Gy_ini[94,97] = 20.5427472507027
        struct[0].Gy_ini[94,98] = 49.9151995897384
        struct[0].Gy_ini[94,99] = 46.5699289619080
        struct[0].Gy_ini[94,100] = -39.6392229058202
        struct[0].Gy_ini[94,101] = -10.2713736253513
        struct[0].Gy_ini[94,102] = 105.571769313180
        struct[0].Gy_ini[94,103] = 54.0657727682604
        struct[0].Gy_ini[94,104] = -39.6392229058201
        struct[0].Gy_ini[94,105] = -10.2713736253513
        struct[0].Gy_ini[94,106] = -24.9575997948692
        struct[0].Gy_ini[94,107] = -23.2849644809540
        struct[0].Gy_ini[95,84] = 10.2713736253513
        struct[0].Gy_ini[95,85] = -39.6392229058202
        struct[0].Gy_ini[95,86] = -54.0657727682604
        struct[0].Gy_ini[95,87] = 105.571769313180
        struct[0].Gy_ini[95,88] = 10.2713736253513
        struct[0].Gy_ini[95,89] = -39.6392229058201
        struct[0].Gy_ini[95,90] = 23.2849644809540
        struct[0].Gy_ini[95,91] = -24.9575997948692
        struct[0].Gy_ini[95,92] = -20.5427472507027
        struct[0].Gy_ini[95,93] = 79.2784458116403
        struct[0].Gy_ini[95,94] = 108.131545536521
        struct[0].Gy_ini[95,95] = -211.143538626360
        struct[0].Gy_ini[95,96] = -20.5427472507027
        struct[0].Gy_ini[95,97] = 79.2784458116403
        struct[0].Gy_ini[95,98] = -46.5699289619080
        struct[0].Gy_ini[95,99] = 49.9151995897384
        struct[0].Gy_ini[95,100] = 10.2713736253513
        struct[0].Gy_ini[95,101] = -39.6392229058202
        struct[0].Gy_ini[95,102] = -54.0657727682604
        struct[0].Gy_ini[95,103] = 105.571769313180
        struct[0].Gy_ini[95,104] = 10.2713736253513
        struct[0].Gy_ini[95,105] = -39.6392229058201
        struct[0].Gy_ini[95,106] = 23.2849644809540
        struct[0].Gy_ini[95,107] = -24.9575997948692
        struct[0].Gy_ini[96,84] = -24.9575997948692
        struct[0].Gy_ini[96,85] = -23.2849644809540
        struct[0].Gy_ini[96,86] = -39.6392229058202
        struct[0].Gy_ini[96,87] = -10.2713736253513
        struct[0].Gy_ini[96,88] = 105.571769313180
        struct[0].Gy_ini[96,89] = 54.0657727682604
        struct[0].Gy_ini[96,90] = -39.6392229058201
        struct[0].Gy_ini[96,91] = -10.2713736253514
        struct[0].Gy_ini[96,92] = 49.9151995897384
        struct[0].Gy_ini[96,93] = 46.5699289619080
        struct[0].Gy_ini[96,94] = 79.2784458116404
        struct[0].Gy_ini[96,95] = 20.5427472507027
        struct[0].Gy_ini[96,96] = -211.143538626360
        struct[0].Gy_ini[96,97] = -108.131545536521
        struct[0].Gy_ini[96,98] = 79.2784458116403
        struct[0].Gy_ini[96,99] = 20.5427472507027
        struct[0].Gy_ini[96,100] = -24.9575997948692
        struct[0].Gy_ini[96,101] = -23.2849644809540
        struct[0].Gy_ini[96,102] = -39.6392229058202
        struct[0].Gy_ini[96,103] = -10.2713736253513
        struct[0].Gy_ini[96,104] = 105.571769313180
        struct[0].Gy_ini[96,105] = 54.0657727682604
        struct[0].Gy_ini[96,106] = -39.6392229058201
        struct[0].Gy_ini[96,107] = -10.2713736253514
        struct[0].Gy_ini[97,84] = 23.2849644809540
        struct[0].Gy_ini[97,85] = -24.9575997948692
        struct[0].Gy_ini[97,86] = 10.2713736253513
        struct[0].Gy_ini[97,87] = -39.6392229058202
        struct[0].Gy_ini[97,88] = -54.0657727682604
        struct[0].Gy_ini[97,89] = 105.571769313180
        struct[0].Gy_ini[97,90] = 10.2713736253514
        struct[0].Gy_ini[97,91] = -39.6392229058201
        struct[0].Gy_ini[97,92] = -46.5699289619080
        struct[0].Gy_ini[97,93] = 49.9151995897384
        struct[0].Gy_ini[97,94] = -20.5427472507027
        struct[0].Gy_ini[97,95] = 79.2784458116404
        struct[0].Gy_ini[97,96] = 108.131545536521
        struct[0].Gy_ini[97,97] = -211.143538626360
        struct[0].Gy_ini[97,98] = -20.5427472507027
        struct[0].Gy_ini[97,99] = 79.2784458116403
        struct[0].Gy_ini[97,100] = 23.2849644809540
        struct[0].Gy_ini[97,101] = -24.9575997948692
        struct[0].Gy_ini[97,102] = 10.2713736253513
        struct[0].Gy_ini[97,103] = -39.6392229058202
        struct[0].Gy_ini[97,104] = -54.0657727682604
        struct[0].Gy_ini[97,105] = 105.571769313180
        struct[0].Gy_ini[97,106] = 10.2713736253514
        struct[0].Gy_ini[97,107] = -39.6392229058201
        struct[0].Gy_ini[98,84] = -39.6392229058202
        struct[0].Gy_ini[98,85] = -10.2713736253513
        struct[0].Gy_ini[98,86] = -24.9575997948692
        struct[0].Gy_ini[98,87] = -23.2849644809540
        struct[0].Gy_ini[98,88] = -39.6392229058202
        struct[0].Gy_ini[98,89] = -10.2713736253513
        struct[0].Gy_ini[98,90] = 105.571769313180
        struct[0].Gy_ini[98,91] = 54.0657727682604
        struct[0].Gy_ini[98,92] = 79.2784458116403
        struct[0].Gy_ini[98,93] = 20.5427472507027
        struct[0].Gy_ini[98,94] = 49.9151995897384
        struct[0].Gy_ini[98,95] = 46.5699289619080
        struct[0].Gy_ini[98,96] = 79.2784458116403
        struct[0].Gy_ini[98,97] = 20.5427472507027
        struct[0].Gy_ini[98,98] = -211.143538626360
        struct[0].Gy_ini[98,99] = -108.131545536521
        struct[0].Gy_ini[98,100] = -39.6392229058202
        struct[0].Gy_ini[98,101] = -10.2713736253513
        struct[0].Gy_ini[98,102] = -24.9575997948692
        struct[0].Gy_ini[98,103] = -23.2849644809540
        struct[0].Gy_ini[98,104] = -39.6392229058202
        struct[0].Gy_ini[98,105] = -10.2713736253513
        struct[0].Gy_ini[98,106] = 105.571769313180
        struct[0].Gy_ini[98,107] = 54.0657727682604
        struct[0].Gy_ini[99,84] = 10.2713736253513
        struct[0].Gy_ini[99,85] = -39.6392229058202
        struct[0].Gy_ini[99,86] = 23.2849644809540
        struct[0].Gy_ini[99,87] = -24.9575997948692
        struct[0].Gy_ini[99,88] = 10.2713736253513
        struct[0].Gy_ini[99,89] = -39.6392229058202
        struct[0].Gy_ini[99,90] = -54.0657727682604
        struct[0].Gy_ini[99,91] = 105.571769313180
        struct[0].Gy_ini[99,92] = -20.5427472507027
        struct[0].Gy_ini[99,93] = 79.2784458116403
        struct[0].Gy_ini[99,94] = -46.5699289619080
        struct[0].Gy_ini[99,95] = 49.9151995897384
        struct[0].Gy_ini[99,96] = -20.5427472507027
        struct[0].Gy_ini[99,97] = 79.2784458116403
        struct[0].Gy_ini[99,98] = 108.131545536521
        struct[0].Gy_ini[99,99] = -211.143538626360
        struct[0].Gy_ini[99,100] = 10.2713736253513
        struct[0].Gy_ini[99,101] = -39.6392229058202
        struct[0].Gy_ini[99,102] = 23.2849644809540
        struct[0].Gy_ini[99,103] = -24.9575997948692
        struct[0].Gy_ini[99,104] = 10.2713736253513
        struct[0].Gy_ini[99,105] = -39.6392229058202
        struct[0].Gy_ini[99,106] = -54.0657727682604
        struct[0].Gy_ini[99,107] = 105.571769313180
        struct[0].Gy_ini[100,24] = 30.9517475172273
        struct[0].Gy_ini[100,25] = 5.65456401516768
        struct[0].Gy_ini[100,26] = -9.21038227100566
        struct[0].Gy_ini[100,27] = 1.84896616921897
        struct[0].Gy_ini[100,28] = -9.00835072044485
        struct[0].Gy_ini[100,29] = 0.793238195499529
        struct[0].Gy_ini[100,30] = -9.21038227100566
        struct[0].Gy_ini[100,31] = 1.84896616921897
        struct[0].Gy_ini[100,92] = 105.571769313180
        struct[0].Gy_ini[100,93] = 54.0657727682604
        struct[0].Gy_ini[100,94] = -39.6392229058202
        struct[0].Gy_ini[100,95] = -10.2713736253513
        struct[0].Gy_ini[100,96] = -24.9575997948692
        struct[0].Gy_ini[100,97] = -23.2849644809540
        struct[0].Gy_ini[100,98] = -39.6392229058202
        struct[0].Gy_ini[100,99] = -10.2713736253513
        struct[0].Gy_ini[100,100] = -242.095286143588
        struct[0].Gy_ini[100,101] = -113.786109551688
        struct[0].Gy_ini[100,102] = 88.4888280826460
        struct[0].Gy_ini[100,103] = 18.6937810814837
        struct[0].Gy_ini[100,104] = 58.9235503101833
        struct[0].Gy_ini[100,105] = 45.7766907664085
        struct[0].Gy_ini[100,106] = 88.4888280826460
        struct[0].Gy_ini[100,107] = 18.6937810814837
        struct[0].Gy_ini[100,108] = 105.571769313180
        struct[0].Gy_ini[100,109] = 54.0657727682604
        struct[0].Gy_ini[100,110] = -39.6392229058202
        struct[0].Gy_ini[100,111] = -10.2713736253513
        struct[0].Gy_ini[100,112] = -24.9575997948692
        struct[0].Gy_ini[100,113] = -23.2849644809540
        struct[0].Gy_ini[100,114] = -39.6392229058202
        struct[0].Gy_ini[100,115] = -10.2713736253513
        struct[0].Gy_ini[101,24] = -5.65456401516768
        struct[0].Gy_ini[101,25] = 30.9517475172273
        struct[0].Gy_ini[101,26] = -1.84896616921897
        struct[0].Gy_ini[101,27] = -9.21038227100566
        struct[0].Gy_ini[101,28] = -0.793238195499529
        struct[0].Gy_ini[101,29] = -9.00835072044485
        struct[0].Gy_ini[101,30] = -1.84896616921897
        struct[0].Gy_ini[101,31] = -9.21038227100566
        struct[0].Gy_ini[101,92] = -54.0657727682604
        struct[0].Gy_ini[101,93] = 105.571769313180
        struct[0].Gy_ini[101,94] = 10.2713736253513
        struct[0].Gy_ini[101,95] = -39.6392229058202
        struct[0].Gy_ini[101,96] = 23.2849644809540
        struct[0].Gy_ini[101,97] = -24.9575997948692
        struct[0].Gy_ini[101,98] = 10.2713736253513
        struct[0].Gy_ini[101,99] = -39.6392229058202
        struct[0].Gy_ini[101,100] = 113.786109551688
        struct[0].Gy_ini[101,101] = -242.095286143588
        struct[0].Gy_ini[101,102] = -18.6937810814837
        struct[0].Gy_ini[101,103] = 88.4888280826460
        struct[0].Gy_ini[101,104] = -45.7766907664085
        struct[0].Gy_ini[101,105] = 58.9235503101833
        struct[0].Gy_ini[101,106] = -18.6937810814837
        struct[0].Gy_ini[101,107] = 88.4888280826460
        struct[0].Gy_ini[101,108] = -54.0657727682604
        struct[0].Gy_ini[101,109] = 105.571769313180
        struct[0].Gy_ini[101,110] = 10.2713736253513
        struct[0].Gy_ini[101,111] = -39.6392229058202
        struct[0].Gy_ini[101,112] = 23.2849644809540
        struct[0].Gy_ini[101,113] = -24.9575997948692
        struct[0].Gy_ini[101,114] = 10.2713736253513
        struct[0].Gy_ini[101,115] = -39.6392229058202
        struct[0].Gy_ini[102,24] = -9.21038227100566
        struct[0].Gy_ini[102,25] = 1.84896616921897
        struct[0].Gy_ini[102,26] = 30.9517475172273
        struct[0].Gy_ini[102,27] = 5.65456401516768
        struct[0].Gy_ini[102,28] = -9.21038227100566
        struct[0].Gy_ini[102,29] = 1.84896616921897
        struct[0].Gy_ini[102,30] = -9.00835072044485
        struct[0].Gy_ini[102,31] = 0.793238195499528
        struct[0].Gy_ini[102,92] = -39.6392229058202
        struct[0].Gy_ini[102,93] = -10.2713736253513
        struct[0].Gy_ini[102,94] = 105.571769313180
        struct[0].Gy_ini[102,95] = 54.0657727682604
        struct[0].Gy_ini[102,96] = -39.6392229058201
        struct[0].Gy_ini[102,97] = -10.2713736253513
        struct[0].Gy_ini[102,98] = -24.9575997948692
        struct[0].Gy_ini[102,99] = -23.2849644809540
        struct[0].Gy_ini[102,100] = 88.4888280826460
        struct[0].Gy_ini[102,101] = 18.6937810814837
        struct[0].Gy_ini[102,102] = -242.095286143588
        struct[0].Gy_ini[102,103] = -113.786109551688
        struct[0].Gy_ini[102,104] = 88.4888280826460
        struct[0].Gy_ini[102,105] = 18.6937810814837
        struct[0].Gy_ini[102,106] = 58.9235503101833
        struct[0].Gy_ini[102,107] = 45.7766907664085
        struct[0].Gy_ini[102,108] = -39.6392229058202
        struct[0].Gy_ini[102,109] = -10.2713736253513
        struct[0].Gy_ini[102,110] = 105.571769313180
        struct[0].Gy_ini[102,111] = 54.0657727682604
        struct[0].Gy_ini[102,112] = -39.6392229058201
        struct[0].Gy_ini[102,113] = -10.2713736253513
        struct[0].Gy_ini[102,114] = -24.9575997948692
        struct[0].Gy_ini[102,115] = -23.2849644809540
        struct[0].Gy_ini[103,24] = -1.84896616921897
        struct[0].Gy_ini[103,25] = -9.21038227100566
        struct[0].Gy_ini[103,26] = -5.65456401516768
        struct[0].Gy_ini[103,27] = 30.9517475172273
        struct[0].Gy_ini[103,28] = -1.84896616921897
        struct[0].Gy_ini[103,29] = -9.21038227100566
        struct[0].Gy_ini[103,30] = -0.793238195499528
        struct[0].Gy_ini[103,31] = -9.00835072044485
        struct[0].Gy_ini[103,92] = 10.2713736253513
        struct[0].Gy_ini[103,93] = -39.6392229058202
        struct[0].Gy_ini[103,94] = -54.0657727682604
        struct[0].Gy_ini[103,95] = 105.571769313180
        struct[0].Gy_ini[103,96] = 10.2713736253513
        struct[0].Gy_ini[103,97] = -39.6392229058201
        struct[0].Gy_ini[103,98] = 23.2849644809540
        struct[0].Gy_ini[103,99] = -24.9575997948692
        struct[0].Gy_ini[103,100] = -18.6937810814837
        struct[0].Gy_ini[103,101] = 88.4888280826460
        struct[0].Gy_ini[103,102] = 113.786109551688
        struct[0].Gy_ini[103,103] = -242.095286143588
        struct[0].Gy_ini[103,104] = -18.6937810814837
        struct[0].Gy_ini[103,105] = 88.4888280826460
        struct[0].Gy_ini[103,106] = -45.7766907664085
        struct[0].Gy_ini[103,107] = 58.9235503101833
        struct[0].Gy_ini[103,108] = 10.2713736253513
        struct[0].Gy_ini[103,109] = -39.6392229058202
        struct[0].Gy_ini[103,110] = -54.0657727682604
        struct[0].Gy_ini[103,111] = 105.571769313180
        struct[0].Gy_ini[103,112] = 10.2713736253513
        struct[0].Gy_ini[103,113] = -39.6392229058201
        struct[0].Gy_ini[103,114] = 23.2849644809540
        struct[0].Gy_ini[103,115] = -24.9575997948692
        struct[0].Gy_ini[104,24] = -9.00835072044484
        struct[0].Gy_ini[104,25] = 0.793238195499527
        struct[0].Gy_ini[104,26] = -9.21038227100566
        struct[0].Gy_ini[104,27] = 1.84896616921897
        struct[0].Gy_ini[104,28] = 30.9517475172273
        struct[0].Gy_ini[104,29] = 5.65456401516768
        struct[0].Gy_ini[104,30] = -9.21038227100566
        struct[0].Gy_ini[104,31] = 1.84896616921897
        struct[0].Gy_ini[104,92] = -24.9575997948692
        struct[0].Gy_ini[104,93] = -23.2849644809540
        struct[0].Gy_ini[104,94] = -39.6392229058202
        struct[0].Gy_ini[104,95] = -10.2713736253513
        struct[0].Gy_ini[104,96] = 105.571769313180
        struct[0].Gy_ini[104,97] = 54.0657727682604
        struct[0].Gy_ini[104,98] = -39.6392229058201
        struct[0].Gy_ini[104,99] = -10.2713736253514
        struct[0].Gy_ini[104,100] = 58.9235503101833
        struct[0].Gy_ini[104,101] = 45.7766907664085
        struct[0].Gy_ini[104,102] = 88.4888280826461
        struct[0].Gy_ini[104,103] = 18.6937810814837
        struct[0].Gy_ini[104,104] = -242.095286143588
        struct[0].Gy_ini[104,105] = -113.786109551688
        struct[0].Gy_ini[104,106] = 88.4888280826459
        struct[0].Gy_ini[104,107] = 18.6937810814837
        struct[0].Gy_ini[104,108] = -24.9575997948692
        struct[0].Gy_ini[104,109] = -23.2849644809540
        struct[0].Gy_ini[104,110] = -39.6392229058202
        struct[0].Gy_ini[104,111] = -10.2713736253513
        struct[0].Gy_ini[104,112] = 105.571769313180
        struct[0].Gy_ini[104,113] = 54.0657727682604
        struct[0].Gy_ini[104,114] = -39.6392229058201
        struct[0].Gy_ini[104,115] = -10.2713736253514
        struct[0].Gy_ini[105,24] = -0.793238195499527
        struct[0].Gy_ini[105,25] = -9.00835072044484
        struct[0].Gy_ini[105,26] = -1.84896616921897
        struct[0].Gy_ini[105,27] = -9.21038227100566
        struct[0].Gy_ini[105,28] = -5.65456401516768
        struct[0].Gy_ini[105,29] = 30.9517475172273
        struct[0].Gy_ini[105,30] = -1.84896616921897
        struct[0].Gy_ini[105,31] = -9.21038227100566
        struct[0].Gy_ini[105,92] = 23.2849644809540
        struct[0].Gy_ini[105,93] = -24.9575997948692
        struct[0].Gy_ini[105,94] = 10.2713736253513
        struct[0].Gy_ini[105,95] = -39.6392229058202
        struct[0].Gy_ini[105,96] = -54.0657727682604
        struct[0].Gy_ini[105,97] = 105.571769313180
        struct[0].Gy_ini[105,98] = 10.2713736253514
        struct[0].Gy_ini[105,99] = -39.6392229058201
        struct[0].Gy_ini[105,100] = -45.7766907664085
        struct[0].Gy_ini[105,101] = 58.9235503101833
        struct[0].Gy_ini[105,102] = -18.6937810814837
        struct[0].Gy_ini[105,103] = 88.4888280826461
        struct[0].Gy_ini[105,104] = 113.786109551688
        struct[0].Gy_ini[105,105] = -242.095286143588
        struct[0].Gy_ini[105,106] = -18.6937810814837
        struct[0].Gy_ini[105,107] = 88.4888280826459
        struct[0].Gy_ini[105,108] = 23.2849644809540
        struct[0].Gy_ini[105,109] = -24.9575997948692
        struct[0].Gy_ini[105,110] = 10.2713736253513
        struct[0].Gy_ini[105,111] = -39.6392229058202
        struct[0].Gy_ini[105,112] = -54.0657727682604
        struct[0].Gy_ini[105,113] = 105.571769313180
        struct[0].Gy_ini[105,114] = 10.2713736253514
        struct[0].Gy_ini[105,115] = -39.6392229058201
        struct[0].Gy_ini[106,24] = -9.21038227100566
        struct[0].Gy_ini[106,25] = 1.84896616921897
        struct[0].Gy_ini[106,26] = -9.00835072044485
        struct[0].Gy_ini[106,27] = 0.793238195499527
        struct[0].Gy_ini[106,28] = -9.21038227100566
        struct[0].Gy_ini[106,29] = 1.84896616921897
        struct[0].Gy_ini[106,30] = 30.9517475172273
        struct[0].Gy_ini[106,31] = 5.65456401516768
        struct[0].Gy_ini[106,92] = -39.6392229058202
        struct[0].Gy_ini[106,93] = -10.2713736253513
        struct[0].Gy_ini[106,94] = -24.9575997948692
        struct[0].Gy_ini[106,95] = -23.2849644809540
        struct[0].Gy_ini[106,96] = -39.6392229058202
        struct[0].Gy_ini[106,97] = -10.2713736253513
        struct[0].Gy_ini[106,98] = 105.571769313180
        struct[0].Gy_ini[106,99] = 54.0657727682604
        struct[0].Gy_ini[106,100] = 88.4888280826460
        struct[0].Gy_ini[106,101] = 18.6937810814837
        struct[0].Gy_ini[106,102] = 58.9235503101832
        struct[0].Gy_ini[106,103] = 45.7766907664085
        struct[0].Gy_ini[106,104] = 88.4888280826460
        struct[0].Gy_ini[106,105] = 18.6937810814837
        struct[0].Gy_ini[106,106] = -242.120286143588
        struct[0].Gy_ini[106,107] = -113.786109551688
        struct[0].Gy_ini[106,108] = -39.6392229058202
        struct[0].Gy_ini[106,109] = -10.2713736253513
        struct[0].Gy_ini[106,110] = -24.9575997948692
        struct[0].Gy_ini[106,111] = -23.2849644809540
        struct[0].Gy_ini[106,112] = -39.6392229058202
        struct[0].Gy_ini[106,113] = -10.2713736253513
        struct[0].Gy_ini[106,114] = 105.571769313180
        struct[0].Gy_ini[106,115] = 54.0657727682604
        struct[0].Gy_ini[107,24] = -1.84896616921897
        struct[0].Gy_ini[107,25] = -9.21038227100566
        struct[0].Gy_ini[107,26] = -0.793238195499527
        struct[0].Gy_ini[107,27] = -9.00835072044485
        struct[0].Gy_ini[107,28] = -1.84896616921897
        struct[0].Gy_ini[107,29] = -9.21038227100566
        struct[0].Gy_ini[107,30] = -5.65456401516768
        struct[0].Gy_ini[107,31] = 30.9517475172273
        struct[0].Gy_ini[107,92] = 10.2713736253513
        struct[0].Gy_ini[107,93] = -39.6392229058202
        struct[0].Gy_ini[107,94] = 23.2849644809540
        struct[0].Gy_ini[107,95] = -24.9575997948692
        struct[0].Gy_ini[107,96] = 10.2713736253513
        struct[0].Gy_ini[107,97] = -39.6392229058202
        struct[0].Gy_ini[107,98] = -54.0657727682604
        struct[0].Gy_ini[107,99] = 105.571769313180
        struct[0].Gy_ini[107,100] = -18.6937810814837
        struct[0].Gy_ini[107,101] = 88.4888280826460
        struct[0].Gy_ini[107,102] = -45.7766907664085
        struct[0].Gy_ini[107,103] = 58.9235503101832
        struct[0].Gy_ini[107,104] = -18.6937810814837
        struct[0].Gy_ini[107,105] = 88.4888280826460
        struct[0].Gy_ini[107,106] = 113.786109551688
        struct[0].Gy_ini[107,107] = -242.120286143588
        struct[0].Gy_ini[107,108] = 10.2713736253513
        struct[0].Gy_ini[107,109] = -39.6392229058202
        struct[0].Gy_ini[107,110] = 23.2849644809540
        struct[0].Gy_ini[107,111] = -24.9575997948692
        struct[0].Gy_ini[107,112] = 10.2713736253513
        struct[0].Gy_ini[107,113] = -39.6392229058202
        struct[0].Gy_ini[107,114] = -54.0657727682604
        struct[0].Gy_ini[107,115] = 105.571769313180
        struct[0].Gy_ini[108,100] = 105.571769313180
        struct[0].Gy_ini[108,101] = 54.0657727682604
        struct[0].Gy_ini[108,102] = -39.6392229058202
        struct[0].Gy_ini[108,103] = -10.2713736253513
        struct[0].Gy_ini[108,104] = -24.9575997948692
        struct[0].Gy_ini[108,105] = -23.2849644809540
        struct[0].Gy_ini[108,106] = -39.6392229058202
        struct[0].Gy_ini[108,107] = -10.2713736253513
        struct[0].Gy_ini[108,108] = -211.143538626360
        struct[0].Gy_ini[108,109] = -108.131545536521
        struct[0].Gy_ini[108,110] = 79.2784458116403
        struct[0].Gy_ini[108,111] = 20.5427472507027
        struct[0].Gy_ini[108,112] = 49.9151995897384
        struct[0].Gy_ini[108,113] = 46.5699289619080
        struct[0].Gy_ini[108,114] = 79.2784458116403
        struct[0].Gy_ini[108,115] = 20.5427472507027
        struct[0].Gy_ini[108,116] = 105.571769313180
        struct[0].Gy_ini[108,117] = 54.0657727682604
        struct[0].Gy_ini[108,118] = -39.6392229058202
        struct[0].Gy_ini[108,119] = -10.2713736253513
        struct[0].Gy_ini[108,120] = -24.9575997948692
        struct[0].Gy_ini[108,121] = -23.2849644809540
        struct[0].Gy_ini[108,122] = -39.6392229058202
        struct[0].Gy_ini[108,123] = -10.2713736253513
        struct[0].Gy_ini[109,100] = -54.0657727682604
        struct[0].Gy_ini[109,101] = 105.571769313180
        struct[0].Gy_ini[109,102] = 10.2713736253513
        struct[0].Gy_ini[109,103] = -39.6392229058202
        struct[0].Gy_ini[109,104] = 23.2849644809540
        struct[0].Gy_ini[109,105] = -24.9575997948692
        struct[0].Gy_ini[109,106] = 10.2713736253513
        struct[0].Gy_ini[109,107] = -39.6392229058202
        struct[0].Gy_ini[109,108] = 108.131545536521
        struct[0].Gy_ini[109,109] = -211.143538626360
        struct[0].Gy_ini[109,110] = -20.5427472507027
        struct[0].Gy_ini[109,111] = 79.2784458116403
        struct[0].Gy_ini[109,112] = -46.5699289619080
        struct[0].Gy_ini[109,113] = 49.9151995897384
        struct[0].Gy_ini[109,114] = -20.5427472507027
        struct[0].Gy_ini[109,115] = 79.2784458116403
        struct[0].Gy_ini[109,116] = -54.0657727682604
        struct[0].Gy_ini[109,117] = 105.571769313180
        struct[0].Gy_ini[109,118] = 10.2713736253513
        struct[0].Gy_ini[109,119] = -39.6392229058202
        struct[0].Gy_ini[109,120] = 23.2849644809540
        struct[0].Gy_ini[109,121] = -24.9575997948692
        struct[0].Gy_ini[109,122] = 10.2713736253513
        struct[0].Gy_ini[109,123] = -39.6392229058202
        struct[0].Gy_ini[110,100] = -39.6392229058202
        struct[0].Gy_ini[110,101] = -10.2713736253513
        struct[0].Gy_ini[110,102] = 105.571769313180
        struct[0].Gy_ini[110,103] = 54.0657727682604
        struct[0].Gy_ini[110,104] = -39.6392229058201
        struct[0].Gy_ini[110,105] = -10.2713736253513
        struct[0].Gy_ini[110,106] = -24.9575997948692
        struct[0].Gy_ini[110,107] = -23.2849644809540
        struct[0].Gy_ini[110,108] = 79.2784458116403
        struct[0].Gy_ini[110,109] = 20.5427472507027
        struct[0].Gy_ini[110,110] = -211.143538626360
        struct[0].Gy_ini[110,111] = -108.131545536521
        struct[0].Gy_ini[110,112] = 79.2784458116403
        struct[0].Gy_ini[110,113] = 20.5427472507027
        struct[0].Gy_ini[110,114] = 49.9151995897384
        struct[0].Gy_ini[110,115] = 46.5699289619080
        struct[0].Gy_ini[110,116] = -39.6392229058202
        struct[0].Gy_ini[110,117] = -10.2713736253513
        struct[0].Gy_ini[110,118] = 105.571769313180
        struct[0].Gy_ini[110,119] = 54.0657727682604
        struct[0].Gy_ini[110,120] = -39.6392229058201
        struct[0].Gy_ini[110,121] = -10.2713736253513
        struct[0].Gy_ini[110,122] = -24.9575997948692
        struct[0].Gy_ini[110,123] = -23.2849644809540
        struct[0].Gy_ini[111,100] = 10.2713736253513
        struct[0].Gy_ini[111,101] = -39.6392229058202
        struct[0].Gy_ini[111,102] = -54.0657727682604
        struct[0].Gy_ini[111,103] = 105.571769313180
        struct[0].Gy_ini[111,104] = 10.2713736253513
        struct[0].Gy_ini[111,105] = -39.6392229058201
        struct[0].Gy_ini[111,106] = 23.2849644809540
        struct[0].Gy_ini[111,107] = -24.9575997948692
        struct[0].Gy_ini[111,108] = -20.5427472507027
        struct[0].Gy_ini[111,109] = 79.2784458116403
        struct[0].Gy_ini[111,110] = 108.131545536521
        struct[0].Gy_ini[111,111] = -211.143538626360
        struct[0].Gy_ini[111,112] = -20.5427472507027
        struct[0].Gy_ini[111,113] = 79.2784458116403
        struct[0].Gy_ini[111,114] = -46.5699289619080
        struct[0].Gy_ini[111,115] = 49.9151995897384
        struct[0].Gy_ini[111,116] = 10.2713736253513
        struct[0].Gy_ini[111,117] = -39.6392229058202
        struct[0].Gy_ini[111,118] = -54.0657727682604
        struct[0].Gy_ini[111,119] = 105.571769313180
        struct[0].Gy_ini[111,120] = 10.2713736253513
        struct[0].Gy_ini[111,121] = -39.6392229058201
        struct[0].Gy_ini[111,122] = 23.2849644809540
        struct[0].Gy_ini[111,123] = -24.9575997948692
        struct[0].Gy_ini[112,100] = -24.9575997948692
        struct[0].Gy_ini[112,101] = -23.2849644809540
        struct[0].Gy_ini[112,102] = -39.6392229058202
        struct[0].Gy_ini[112,103] = -10.2713736253513
        struct[0].Gy_ini[112,104] = 105.571769313180
        struct[0].Gy_ini[112,105] = 54.0657727682604
        struct[0].Gy_ini[112,106] = -39.6392229058201
        struct[0].Gy_ini[112,107] = -10.2713736253514
        struct[0].Gy_ini[112,108] = 49.9151995897384
        struct[0].Gy_ini[112,109] = 46.5699289619080
        struct[0].Gy_ini[112,110] = 79.2784458116404
        struct[0].Gy_ini[112,111] = 20.5427472507027
        struct[0].Gy_ini[112,112] = -211.143538626360
        struct[0].Gy_ini[112,113] = -108.131545536521
        struct[0].Gy_ini[112,114] = 79.2784458116403
        struct[0].Gy_ini[112,115] = 20.5427472507027
        struct[0].Gy_ini[112,116] = -24.9575997948692
        struct[0].Gy_ini[112,117] = -23.2849644809540
        struct[0].Gy_ini[112,118] = -39.6392229058202
        struct[0].Gy_ini[112,119] = -10.2713736253513
        struct[0].Gy_ini[112,120] = 105.571769313180
        struct[0].Gy_ini[112,121] = 54.0657727682604
        struct[0].Gy_ini[112,122] = -39.6392229058201
        struct[0].Gy_ini[112,123] = -10.2713736253514
        struct[0].Gy_ini[113,100] = 23.2849644809540
        struct[0].Gy_ini[113,101] = -24.9575997948692
        struct[0].Gy_ini[113,102] = 10.2713736253513
        struct[0].Gy_ini[113,103] = -39.6392229058202
        struct[0].Gy_ini[113,104] = -54.0657727682604
        struct[0].Gy_ini[113,105] = 105.571769313180
        struct[0].Gy_ini[113,106] = 10.2713736253514
        struct[0].Gy_ini[113,107] = -39.6392229058201
        struct[0].Gy_ini[113,108] = -46.5699289619080
        struct[0].Gy_ini[113,109] = 49.9151995897384
        struct[0].Gy_ini[113,110] = -20.5427472507027
        struct[0].Gy_ini[113,111] = 79.2784458116404
        struct[0].Gy_ini[113,112] = 108.131545536521
        struct[0].Gy_ini[113,113] = -211.143538626360
        struct[0].Gy_ini[113,114] = -20.5427472507027
        struct[0].Gy_ini[113,115] = 79.2784458116403
        struct[0].Gy_ini[113,116] = 23.2849644809540
        struct[0].Gy_ini[113,117] = -24.9575997948692
        struct[0].Gy_ini[113,118] = 10.2713736253513
        struct[0].Gy_ini[113,119] = -39.6392229058202
        struct[0].Gy_ini[113,120] = -54.0657727682604
        struct[0].Gy_ini[113,121] = 105.571769313180
        struct[0].Gy_ini[113,122] = 10.2713736253514
        struct[0].Gy_ini[113,123] = -39.6392229058201
        struct[0].Gy_ini[114,100] = -39.6392229058202
        struct[0].Gy_ini[114,101] = -10.2713736253513
        struct[0].Gy_ini[114,102] = -24.9575997948692
        struct[0].Gy_ini[114,103] = -23.2849644809540
        struct[0].Gy_ini[114,104] = -39.6392229058202
        struct[0].Gy_ini[114,105] = -10.2713736253513
        struct[0].Gy_ini[114,106] = 105.571769313180
        struct[0].Gy_ini[114,107] = 54.0657727682604
        struct[0].Gy_ini[114,108] = 79.2784458116403
        struct[0].Gy_ini[114,109] = 20.5427472507027
        struct[0].Gy_ini[114,110] = 49.9151995897384
        struct[0].Gy_ini[114,111] = 46.5699289619080
        struct[0].Gy_ini[114,112] = 79.2784458116403
        struct[0].Gy_ini[114,113] = 20.5427472507027
        struct[0].Gy_ini[114,114] = -211.143538626360
        struct[0].Gy_ini[114,115] = -108.131545536521
        struct[0].Gy_ini[114,116] = -39.6392229058202
        struct[0].Gy_ini[114,117] = -10.2713736253513
        struct[0].Gy_ini[114,118] = -24.9575997948692
        struct[0].Gy_ini[114,119] = -23.2849644809540
        struct[0].Gy_ini[114,120] = -39.6392229058202
        struct[0].Gy_ini[114,121] = -10.2713736253513
        struct[0].Gy_ini[114,122] = 105.571769313180
        struct[0].Gy_ini[114,123] = 54.0657727682604
        struct[0].Gy_ini[115,100] = 10.2713736253513
        struct[0].Gy_ini[115,101] = -39.6392229058202
        struct[0].Gy_ini[115,102] = 23.2849644809540
        struct[0].Gy_ini[115,103] = -24.9575997948692
        struct[0].Gy_ini[115,104] = 10.2713736253513
        struct[0].Gy_ini[115,105] = -39.6392229058202
        struct[0].Gy_ini[115,106] = -54.0657727682604
        struct[0].Gy_ini[115,107] = 105.571769313180
        struct[0].Gy_ini[115,108] = -20.5427472507027
        struct[0].Gy_ini[115,109] = 79.2784458116403
        struct[0].Gy_ini[115,110] = -46.5699289619080
        struct[0].Gy_ini[115,111] = 49.9151995897384
        struct[0].Gy_ini[115,112] = -20.5427472507027
        struct[0].Gy_ini[115,113] = 79.2784458116403
        struct[0].Gy_ini[115,114] = 108.131545536521
        struct[0].Gy_ini[115,115] = -211.143538626360
        struct[0].Gy_ini[115,116] = 10.2713736253513
        struct[0].Gy_ini[115,117] = -39.6392229058202
        struct[0].Gy_ini[115,118] = 23.2849644809540
        struct[0].Gy_ini[115,119] = -24.9575997948692
        struct[0].Gy_ini[115,120] = 10.2713736253513
        struct[0].Gy_ini[115,121] = -39.6392229058202
        struct[0].Gy_ini[115,122] = -54.0657727682604
        struct[0].Gy_ini[115,123] = 105.571769313180
        struct[0].Gy_ini[116,108] = 105.571769313180
        struct[0].Gy_ini[116,109] = 54.0657727682604
        struct[0].Gy_ini[116,110] = -39.6392229058202
        struct[0].Gy_ini[116,111] = -10.2713736253513
        struct[0].Gy_ini[116,112] = -24.9575997948692
        struct[0].Gy_ini[116,113] = -23.2849644809540
        struct[0].Gy_ini[116,114] = -39.6392229058202
        struct[0].Gy_ini[116,115] = -10.2713736253513
        struct[0].Gy_ini[116,116] = -211.143538626360
        struct[0].Gy_ini[116,117] = -108.131545536521
        struct[0].Gy_ini[116,118] = 79.2784458116403
        struct[0].Gy_ini[116,119] = 20.5427472507027
        struct[0].Gy_ini[116,120] = 49.9151995897384
        struct[0].Gy_ini[116,121] = 46.5699289619080
        struct[0].Gy_ini[116,122] = 79.2784458116403
        struct[0].Gy_ini[116,123] = 20.5427472507027
        struct[0].Gy_ini[116,124] = 105.571769313180
        struct[0].Gy_ini[116,125] = 54.0657727682604
        struct[0].Gy_ini[116,126] = -39.6392229058202
        struct[0].Gy_ini[116,127] = -10.2713736253513
        struct[0].Gy_ini[116,128] = -24.9575997948692
        struct[0].Gy_ini[116,129] = -23.2849644809540
        struct[0].Gy_ini[116,130] = -39.6392229058202
        struct[0].Gy_ini[116,131] = -10.2713736253513
        struct[0].Gy_ini[117,108] = -54.0657727682604
        struct[0].Gy_ini[117,109] = 105.571769313180
        struct[0].Gy_ini[117,110] = 10.2713736253513
        struct[0].Gy_ini[117,111] = -39.6392229058202
        struct[0].Gy_ini[117,112] = 23.2849644809540
        struct[0].Gy_ini[117,113] = -24.9575997948692
        struct[0].Gy_ini[117,114] = 10.2713736253513
        struct[0].Gy_ini[117,115] = -39.6392229058202
        struct[0].Gy_ini[117,116] = 108.131545536521
        struct[0].Gy_ini[117,117] = -211.143538626360
        struct[0].Gy_ini[117,118] = -20.5427472507027
        struct[0].Gy_ini[117,119] = 79.2784458116403
        struct[0].Gy_ini[117,120] = -46.5699289619080
        struct[0].Gy_ini[117,121] = 49.9151995897384
        struct[0].Gy_ini[117,122] = -20.5427472507027
        struct[0].Gy_ini[117,123] = 79.2784458116403
        struct[0].Gy_ini[117,124] = -54.0657727682604
        struct[0].Gy_ini[117,125] = 105.571769313180
        struct[0].Gy_ini[117,126] = 10.2713736253513
        struct[0].Gy_ini[117,127] = -39.6392229058202
        struct[0].Gy_ini[117,128] = 23.2849644809540
        struct[0].Gy_ini[117,129] = -24.9575997948692
        struct[0].Gy_ini[117,130] = 10.2713736253513
        struct[0].Gy_ini[117,131] = -39.6392229058202
        struct[0].Gy_ini[118,108] = -39.6392229058202
        struct[0].Gy_ini[118,109] = -10.2713736253513
        struct[0].Gy_ini[118,110] = 105.571769313180
        struct[0].Gy_ini[118,111] = 54.0657727682604
        struct[0].Gy_ini[118,112] = -39.6392229058201
        struct[0].Gy_ini[118,113] = -10.2713736253513
        struct[0].Gy_ini[118,114] = -24.9575997948692
        struct[0].Gy_ini[118,115] = -23.2849644809540
        struct[0].Gy_ini[118,116] = 79.2784458116403
        struct[0].Gy_ini[118,117] = 20.5427472507027
        struct[0].Gy_ini[118,118] = -211.143538626360
        struct[0].Gy_ini[118,119] = -108.131545536521
        struct[0].Gy_ini[118,120] = 79.2784458116403
        struct[0].Gy_ini[118,121] = 20.5427472507027
        struct[0].Gy_ini[118,122] = 49.9151995897384
        struct[0].Gy_ini[118,123] = 46.5699289619080
        struct[0].Gy_ini[118,124] = -39.6392229058202
        struct[0].Gy_ini[118,125] = -10.2713736253513
        struct[0].Gy_ini[118,126] = 105.571769313180
        struct[0].Gy_ini[118,127] = 54.0657727682604
        struct[0].Gy_ini[118,128] = -39.6392229058201
        struct[0].Gy_ini[118,129] = -10.2713736253513
        struct[0].Gy_ini[118,130] = -24.9575997948692
        struct[0].Gy_ini[118,131] = -23.2849644809540
        struct[0].Gy_ini[119,108] = 10.2713736253513
        struct[0].Gy_ini[119,109] = -39.6392229058202
        struct[0].Gy_ini[119,110] = -54.0657727682604
        struct[0].Gy_ini[119,111] = 105.571769313180
        struct[0].Gy_ini[119,112] = 10.2713736253513
        struct[0].Gy_ini[119,113] = -39.6392229058201
        struct[0].Gy_ini[119,114] = 23.2849644809540
        struct[0].Gy_ini[119,115] = -24.9575997948692
        struct[0].Gy_ini[119,116] = -20.5427472507027
        struct[0].Gy_ini[119,117] = 79.2784458116403
        struct[0].Gy_ini[119,118] = 108.131545536521
        struct[0].Gy_ini[119,119] = -211.143538626360
        struct[0].Gy_ini[119,120] = -20.5427472507027
        struct[0].Gy_ini[119,121] = 79.2784458116403
        struct[0].Gy_ini[119,122] = -46.5699289619080
        struct[0].Gy_ini[119,123] = 49.9151995897384
        struct[0].Gy_ini[119,124] = 10.2713736253513
        struct[0].Gy_ini[119,125] = -39.6392229058202
        struct[0].Gy_ini[119,126] = -54.0657727682604
        struct[0].Gy_ini[119,127] = 105.571769313180
        struct[0].Gy_ini[119,128] = 10.2713736253513
        struct[0].Gy_ini[119,129] = -39.6392229058201
        struct[0].Gy_ini[119,130] = 23.2849644809540
        struct[0].Gy_ini[119,131] = -24.9575997948692
        struct[0].Gy_ini[120,108] = -24.9575997948692
        struct[0].Gy_ini[120,109] = -23.2849644809540
        struct[0].Gy_ini[120,110] = -39.6392229058202
        struct[0].Gy_ini[120,111] = -10.2713736253513
        struct[0].Gy_ini[120,112] = 105.571769313180
        struct[0].Gy_ini[120,113] = 54.0657727682604
        struct[0].Gy_ini[120,114] = -39.6392229058201
        struct[0].Gy_ini[120,115] = -10.2713736253514
        struct[0].Gy_ini[120,116] = 49.9151995897384
        struct[0].Gy_ini[120,117] = 46.5699289619080
        struct[0].Gy_ini[120,118] = 79.2784458116404
        struct[0].Gy_ini[120,119] = 20.5427472507027
        struct[0].Gy_ini[120,120] = -211.143538626360
        struct[0].Gy_ini[120,121] = -108.131545536521
        struct[0].Gy_ini[120,122] = 79.2784458116403
        struct[0].Gy_ini[120,123] = 20.5427472507027
        struct[0].Gy_ini[120,124] = -24.9575997948692
        struct[0].Gy_ini[120,125] = -23.2849644809540
        struct[0].Gy_ini[120,126] = -39.6392229058202
        struct[0].Gy_ini[120,127] = -10.2713736253513
        struct[0].Gy_ini[120,128] = 105.571769313180
        struct[0].Gy_ini[120,129] = 54.0657727682604
        struct[0].Gy_ini[120,130] = -39.6392229058201
        struct[0].Gy_ini[120,131] = -10.2713736253514
        struct[0].Gy_ini[121,108] = 23.2849644809540
        struct[0].Gy_ini[121,109] = -24.9575997948692
        struct[0].Gy_ini[121,110] = 10.2713736253513
        struct[0].Gy_ini[121,111] = -39.6392229058202
        struct[0].Gy_ini[121,112] = -54.0657727682604
        struct[0].Gy_ini[121,113] = 105.571769313180
        struct[0].Gy_ini[121,114] = 10.2713736253514
        struct[0].Gy_ini[121,115] = -39.6392229058201
        struct[0].Gy_ini[121,116] = -46.5699289619080
        struct[0].Gy_ini[121,117] = 49.9151995897384
        struct[0].Gy_ini[121,118] = -20.5427472507027
        struct[0].Gy_ini[121,119] = 79.2784458116404
        struct[0].Gy_ini[121,120] = 108.131545536521
        struct[0].Gy_ini[121,121] = -211.143538626360
        struct[0].Gy_ini[121,122] = -20.5427472507027
        struct[0].Gy_ini[121,123] = 79.2784458116403
        struct[0].Gy_ini[121,124] = 23.2849644809540
        struct[0].Gy_ini[121,125] = -24.9575997948692
        struct[0].Gy_ini[121,126] = 10.2713736253513
        struct[0].Gy_ini[121,127] = -39.6392229058202
        struct[0].Gy_ini[121,128] = -54.0657727682604
        struct[0].Gy_ini[121,129] = 105.571769313180
        struct[0].Gy_ini[121,130] = 10.2713736253514
        struct[0].Gy_ini[121,131] = -39.6392229058201
        struct[0].Gy_ini[122,108] = -39.6392229058202
        struct[0].Gy_ini[122,109] = -10.2713736253513
        struct[0].Gy_ini[122,110] = -24.9575997948692
        struct[0].Gy_ini[122,111] = -23.2849644809540
        struct[0].Gy_ini[122,112] = -39.6392229058202
        struct[0].Gy_ini[122,113] = -10.2713736253513
        struct[0].Gy_ini[122,114] = 105.571769313180
        struct[0].Gy_ini[122,115] = 54.0657727682604
        struct[0].Gy_ini[122,116] = 79.2784458116403
        struct[0].Gy_ini[122,117] = 20.5427472507027
        struct[0].Gy_ini[122,118] = 49.9151995897384
        struct[0].Gy_ini[122,119] = 46.5699289619080
        struct[0].Gy_ini[122,120] = 79.2784458116403
        struct[0].Gy_ini[122,121] = 20.5427472507027
        struct[0].Gy_ini[122,122] = -211.168538626360
        struct[0].Gy_ini[122,123] = -108.131545536521
        struct[0].Gy_ini[122,124] = -39.6392229058202
        struct[0].Gy_ini[122,125] = -10.2713736253513
        struct[0].Gy_ini[122,126] = -24.9575997948692
        struct[0].Gy_ini[122,127] = -23.2849644809540
        struct[0].Gy_ini[122,128] = -39.6392229058202
        struct[0].Gy_ini[122,129] = -10.2713736253513
        struct[0].Gy_ini[122,130] = 105.571769313180
        struct[0].Gy_ini[122,131] = 54.0657727682604
        struct[0].Gy_ini[123,108] = 10.2713736253513
        struct[0].Gy_ini[123,109] = -39.6392229058202
        struct[0].Gy_ini[123,110] = 23.2849644809540
        struct[0].Gy_ini[123,111] = -24.9575997948692
        struct[0].Gy_ini[123,112] = 10.2713736253513
        struct[0].Gy_ini[123,113] = -39.6392229058202
        struct[0].Gy_ini[123,114] = -54.0657727682604
        struct[0].Gy_ini[123,115] = 105.571769313180
        struct[0].Gy_ini[123,116] = -20.5427472507027
        struct[0].Gy_ini[123,117] = 79.2784458116403
        struct[0].Gy_ini[123,118] = -46.5699289619080
        struct[0].Gy_ini[123,119] = 49.9151995897384
        struct[0].Gy_ini[123,120] = -20.5427472507027
        struct[0].Gy_ini[123,121] = 79.2784458116403
        struct[0].Gy_ini[123,122] = 108.131545536521
        struct[0].Gy_ini[123,123] = -211.168538626360
        struct[0].Gy_ini[123,124] = 10.2713736253513
        struct[0].Gy_ini[123,125] = -39.6392229058202
        struct[0].Gy_ini[123,126] = 23.2849644809540
        struct[0].Gy_ini[123,127] = -24.9575997948692
        struct[0].Gy_ini[123,128] = 10.2713736253513
        struct[0].Gy_ini[123,129] = -39.6392229058202
        struct[0].Gy_ini[123,130] = -54.0657727682604
        struct[0].Gy_ini[123,131] = 105.571769313180
        struct[0].Gy_ini[124,32] = 30.9517475172273
        struct[0].Gy_ini[124,33] = 5.65456401516768
        struct[0].Gy_ini[124,34] = -9.21038227100566
        struct[0].Gy_ini[124,35] = 1.84896616921897
        struct[0].Gy_ini[124,36] = -9.00835072044485
        struct[0].Gy_ini[124,37] = 0.793238195499529
        struct[0].Gy_ini[124,38] = -9.21038227100566
        struct[0].Gy_ini[124,39] = 1.84896616921897
        struct[0].Gy_ini[124,116] = 105.571769313180
        struct[0].Gy_ini[124,117] = 54.0657727682604
        struct[0].Gy_ini[124,118] = -39.6392229058202
        struct[0].Gy_ini[124,119] = -10.2713736253513
        struct[0].Gy_ini[124,120] = -24.9575997948692
        struct[0].Gy_ini[124,121] = -23.2849644809540
        struct[0].Gy_ini[124,122] = -39.6392229058202
        struct[0].Gy_ini[124,123] = -10.2713736253513
        struct[0].Gy_ini[124,124] = -242.095286143588
        struct[0].Gy_ini[124,125] = -113.786109551688
        struct[0].Gy_ini[124,126] = 88.4888280826460
        struct[0].Gy_ini[124,127] = 18.6937810814837
        struct[0].Gy_ini[124,128] = 58.9235503101833
        struct[0].Gy_ini[124,129] = 45.7766907664085
        struct[0].Gy_ini[124,130] = 88.4888280826460
        struct[0].Gy_ini[124,131] = 18.6937810814837
        struct[0].Gy_ini[124,132] = 105.571769313180
        struct[0].Gy_ini[124,133] = 54.0657727682604
        struct[0].Gy_ini[124,134] = -39.6392229058202
        struct[0].Gy_ini[124,135] = -10.2713736253513
        struct[0].Gy_ini[124,136] = -24.9575997948692
        struct[0].Gy_ini[124,137] = -23.2849644809540
        struct[0].Gy_ini[124,138] = -39.6392229058202
        struct[0].Gy_ini[124,139] = -10.2713736253513
        struct[0].Gy_ini[125,32] = -5.65456401516768
        struct[0].Gy_ini[125,33] = 30.9517475172273
        struct[0].Gy_ini[125,34] = -1.84896616921897
        struct[0].Gy_ini[125,35] = -9.21038227100566
        struct[0].Gy_ini[125,36] = -0.793238195499529
        struct[0].Gy_ini[125,37] = -9.00835072044485
        struct[0].Gy_ini[125,38] = -1.84896616921897
        struct[0].Gy_ini[125,39] = -9.21038227100566
        struct[0].Gy_ini[125,116] = -54.0657727682604
        struct[0].Gy_ini[125,117] = 105.571769313180
        struct[0].Gy_ini[125,118] = 10.2713736253513
        struct[0].Gy_ini[125,119] = -39.6392229058202
        struct[0].Gy_ini[125,120] = 23.2849644809540
        struct[0].Gy_ini[125,121] = -24.9575997948692
        struct[0].Gy_ini[125,122] = 10.2713736253513
        struct[0].Gy_ini[125,123] = -39.6392229058202
        struct[0].Gy_ini[125,124] = 113.786109551688
        struct[0].Gy_ini[125,125] = -242.095286143588
        struct[0].Gy_ini[125,126] = -18.6937810814837
        struct[0].Gy_ini[125,127] = 88.4888280826460
        struct[0].Gy_ini[125,128] = -45.7766907664085
        struct[0].Gy_ini[125,129] = 58.9235503101833
        struct[0].Gy_ini[125,130] = -18.6937810814837
        struct[0].Gy_ini[125,131] = 88.4888280826460
        struct[0].Gy_ini[125,132] = -54.0657727682604
        struct[0].Gy_ini[125,133] = 105.571769313180
        struct[0].Gy_ini[125,134] = 10.2713736253513
        struct[0].Gy_ini[125,135] = -39.6392229058202
        struct[0].Gy_ini[125,136] = 23.2849644809540
        struct[0].Gy_ini[125,137] = -24.9575997948692
        struct[0].Gy_ini[125,138] = 10.2713736253513
        struct[0].Gy_ini[125,139] = -39.6392229058202
        struct[0].Gy_ini[126,32] = -9.21038227100566
        struct[0].Gy_ini[126,33] = 1.84896616921897
        struct[0].Gy_ini[126,34] = 30.9517475172273
        struct[0].Gy_ini[126,35] = 5.65456401516768
        struct[0].Gy_ini[126,36] = -9.21038227100566
        struct[0].Gy_ini[126,37] = 1.84896616921897
        struct[0].Gy_ini[126,38] = -9.00835072044485
        struct[0].Gy_ini[126,39] = 0.793238195499528
        struct[0].Gy_ini[126,116] = -39.6392229058202
        struct[0].Gy_ini[126,117] = -10.2713736253513
        struct[0].Gy_ini[126,118] = 105.571769313180
        struct[0].Gy_ini[126,119] = 54.0657727682604
        struct[0].Gy_ini[126,120] = -39.6392229058201
        struct[0].Gy_ini[126,121] = -10.2713736253513
        struct[0].Gy_ini[126,122] = -24.9575997948692
        struct[0].Gy_ini[126,123] = -23.2849644809540
        struct[0].Gy_ini[126,124] = 88.4888280826460
        struct[0].Gy_ini[126,125] = 18.6937810814837
        struct[0].Gy_ini[126,126] = -242.095286143588
        struct[0].Gy_ini[126,127] = -113.786109551688
        struct[0].Gy_ini[126,128] = 88.4888280826460
        struct[0].Gy_ini[126,129] = 18.6937810814837
        struct[0].Gy_ini[126,130] = 58.9235503101833
        struct[0].Gy_ini[126,131] = 45.7766907664085
        struct[0].Gy_ini[126,132] = -39.6392229058202
        struct[0].Gy_ini[126,133] = -10.2713736253513
        struct[0].Gy_ini[126,134] = 105.571769313180
        struct[0].Gy_ini[126,135] = 54.0657727682604
        struct[0].Gy_ini[126,136] = -39.6392229058201
        struct[0].Gy_ini[126,137] = -10.2713736253513
        struct[0].Gy_ini[126,138] = -24.9575997948692
        struct[0].Gy_ini[126,139] = -23.2849644809540
        struct[0].Gy_ini[127,32] = -1.84896616921897
        struct[0].Gy_ini[127,33] = -9.21038227100566
        struct[0].Gy_ini[127,34] = -5.65456401516768
        struct[0].Gy_ini[127,35] = 30.9517475172273
        struct[0].Gy_ini[127,36] = -1.84896616921897
        struct[0].Gy_ini[127,37] = -9.21038227100566
        struct[0].Gy_ini[127,38] = -0.793238195499528
        struct[0].Gy_ini[127,39] = -9.00835072044485
        struct[0].Gy_ini[127,116] = 10.2713736253513
        struct[0].Gy_ini[127,117] = -39.6392229058202
        struct[0].Gy_ini[127,118] = -54.0657727682604
        struct[0].Gy_ini[127,119] = 105.571769313180
        struct[0].Gy_ini[127,120] = 10.2713736253513
        struct[0].Gy_ini[127,121] = -39.6392229058201
        struct[0].Gy_ini[127,122] = 23.2849644809540
        struct[0].Gy_ini[127,123] = -24.9575997948692
        struct[0].Gy_ini[127,124] = -18.6937810814837
        struct[0].Gy_ini[127,125] = 88.4888280826460
        struct[0].Gy_ini[127,126] = 113.786109551688
        struct[0].Gy_ini[127,127] = -242.095286143588
        struct[0].Gy_ini[127,128] = -18.6937810814837
        struct[0].Gy_ini[127,129] = 88.4888280826460
        struct[0].Gy_ini[127,130] = -45.7766907664085
        struct[0].Gy_ini[127,131] = 58.9235503101833
        struct[0].Gy_ini[127,132] = 10.2713736253513
        struct[0].Gy_ini[127,133] = -39.6392229058202
        struct[0].Gy_ini[127,134] = -54.0657727682604
        struct[0].Gy_ini[127,135] = 105.571769313180
        struct[0].Gy_ini[127,136] = 10.2713736253513
        struct[0].Gy_ini[127,137] = -39.6392229058201
        struct[0].Gy_ini[127,138] = 23.2849644809540
        struct[0].Gy_ini[127,139] = -24.9575997948692
        struct[0].Gy_ini[128,32] = -9.00835072044484
        struct[0].Gy_ini[128,33] = 0.793238195499527
        struct[0].Gy_ini[128,34] = -9.21038227100566
        struct[0].Gy_ini[128,35] = 1.84896616921897
        struct[0].Gy_ini[128,36] = 30.9517475172273
        struct[0].Gy_ini[128,37] = 5.65456401516768
        struct[0].Gy_ini[128,38] = -9.21038227100566
        struct[0].Gy_ini[128,39] = 1.84896616921897
        struct[0].Gy_ini[128,116] = -24.9575997948692
        struct[0].Gy_ini[128,117] = -23.2849644809540
        struct[0].Gy_ini[128,118] = -39.6392229058202
        struct[0].Gy_ini[128,119] = -10.2713736253513
        struct[0].Gy_ini[128,120] = 105.571769313180
        struct[0].Gy_ini[128,121] = 54.0657727682604
        struct[0].Gy_ini[128,122] = -39.6392229058201
        struct[0].Gy_ini[128,123] = -10.2713736253514
        struct[0].Gy_ini[128,124] = 58.9235503101833
        struct[0].Gy_ini[128,125] = 45.7766907664085
        struct[0].Gy_ini[128,126] = 88.4888280826461
        struct[0].Gy_ini[128,127] = 18.6937810814837
        struct[0].Gy_ini[128,128] = -242.095286143588
        struct[0].Gy_ini[128,129] = -113.786109551688
        struct[0].Gy_ini[128,130] = 88.4888280826459
        struct[0].Gy_ini[128,131] = 18.6937810814837
        struct[0].Gy_ini[128,132] = -24.9575997948692
        struct[0].Gy_ini[128,133] = -23.2849644809540
        struct[0].Gy_ini[128,134] = -39.6392229058202
        struct[0].Gy_ini[128,135] = -10.2713736253513
        struct[0].Gy_ini[128,136] = 105.571769313180
        struct[0].Gy_ini[128,137] = 54.0657727682604
        struct[0].Gy_ini[128,138] = -39.6392229058201
        struct[0].Gy_ini[128,139] = -10.2713736253514
        struct[0].Gy_ini[129,32] = -0.793238195499527
        struct[0].Gy_ini[129,33] = -9.00835072044484
        struct[0].Gy_ini[129,34] = -1.84896616921897
        struct[0].Gy_ini[129,35] = -9.21038227100566
        struct[0].Gy_ini[129,36] = -5.65456401516768
        struct[0].Gy_ini[129,37] = 30.9517475172273
        struct[0].Gy_ini[129,38] = -1.84896616921897
        struct[0].Gy_ini[129,39] = -9.21038227100566
        struct[0].Gy_ini[129,116] = 23.2849644809540
        struct[0].Gy_ini[129,117] = -24.9575997948692
        struct[0].Gy_ini[129,118] = 10.2713736253513
        struct[0].Gy_ini[129,119] = -39.6392229058202
        struct[0].Gy_ini[129,120] = -54.0657727682604
        struct[0].Gy_ini[129,121] = 105.571769313180
        struct[0].Gy_ini[129,122] = 10.2713736253514
        struct[0].Gy_ini[129,123] = -39.6392229058201
        struct[0].Gy_ini[129,124] = -45.7766907664085
        struct[0].Gy_ini[129,125] = 58.9235503101833
        struct[0].Gy_ini[129,126] = -18.6937810814837
        struct[0].Gy_ini[129,127] = 88.4888280826461
        struct[0].Gy_ini[129,128] = 113.786109551688
        struct[0].Gy_ini[129,129] = -242.095286143588
        struct[0].Gy_ini[129,130] = -18.6937810814837
        struct[0].Gy_ini[129,131] = 88.4888280826459
        struct[0].Gy_ini[129,132] = 23.2849644809540
        struct[0].Gy_ini[129,133] = -24.9575997948692
        struct[0].Gy_ini[129,134] = 10.2713736253513
        struct[0].Gy_ini[129,135] = -39.6392229058202
        struct[0].Gy_ini[129,136] = -54.0657727682604
        struct[0].Gy_ini[129,137] = 105.571769313180
        struct[0].Gy_ini[129,138] = 10.2713736253514
        struct[0].Gy_ini[129,139] = -39.6392229058201
        struct[0].Gy_ini[130,32] = -9.21038227100566
        struct[0].Gy_ini[130,33] = 1.84896616921897
        struct[0].Gy_ini[130,34] = -9.00835072044485
        struct[0].Gy_ini[130,35] = 0.793238195499527
        struct[0].Gy_ini[130,36] = -9.21038227100566
        struct[0].Gy_ini[130,37] = 1.84896616921897
        struct[0].Gy_ini[130,38] = 30.9517475172273
        struct[0].Gy_ini[130,39] = 5.65456401516768
        struct[0].Gy_ini[130,116] = -39.6392229058202
        struct[0].Gy_ini[130,117] = -10.2713736253513
        struct[0].Gy_ini[130,118] = -24.9575997948692
        struct[0].Gy_ini[130,119] = -23.2849644809540
        struct[0].Gy_ini[130,120] = -39.6392229058202
        struct[0].Gy_ini[130,121] = -10.2713736253513
        struct[0].Gy_ini[130,122] = 105.571769313180
        struct[0].Gy_ini[130,123] = 54.0657727682604
        struct[0].Gy_ini[130,124] = 88.4888280826460
        struct[0].Gy_ini[130,125] = 18.6937810814837
        struct[0].Gy_ini[130,126] = 58.9235503101832
        struct[0].Gy_ini[130,127] = 45.7766907664085
        struct[0].Gy_ini[130,128] = 88.4888280826460
        struct[0].Gy_ini[130,129] = 18.6937810814837
        struct[0].Gy_ini[130,130] = -242.095286143588
        struct[0].Gy_ini[130,131] = -113.786109551688
        struct[0].Gy_ini[130,132] = -39.6392229058202
        struct[0].Gy_ini[130,133] = -10.2713736253513
        struct[0].Gy_ini[130,134] = -24.9575997948692
        struct[0].Gy_ini[130,135] = -23.2849644809540
        struct[0].Gy_ini[130,136] = -39.6392229058202
        struct[0].Gy_ini[130,137] = -10.2713736253513
        struct[0].Gy_ini[130,138] = 105.571769313180
        struct[0].Gy_ini[130,139] = 54.0657727682604
        struct[0].Gy_ini[131,32] = -1.84896616921897
        struct[0].Gy_ini[131,33] = -9.21038227100566
        struct[0].Gy_ini[131,34] = -0.793238195499527
        struct[0].Gy_ini[131,35] = -9.00835072044485
        struct[0].Gy_ini[131,36] = -1.84896616921897
        struct[0].Gy_ini[131,37] = -9.21038227100566
        struct[0].Gy_ini[131,38] = -5.65456401516768
        struct[0].Gy_ini[131,39] = 30.9517475172273
        struct[0].Gy_ini[131,116] = 10.2713736253513
        struct[0].Gy_ini[131,117] = -39.6392229058202
        struct[0].Gy_ini[131,118] = 23.2849644809540
        struct[0].Gy_ini[131,119] = -24.9575997948692
        struct[0].Gy_ini[131,120] = 10.2713736253513
        struct[0].Gy_ini[131,121] = -39.6392229058202
        struct[0].Gy_ini[131,122] = -54.0657727682604
        struct[0].Gy_ini[131,123] = 105.571769313180
        struct[0].Gy_ini[131,124] = -18.6937810814837
        struct[0].Gy_ini[131,125] = 88.4888280826460
        struct[0].Gy_ini[131,126] = -45.7766907664085
        struct[0].Gy_ini[131,127] = 58.9235503101832
        struct[0].Gy_ini[131,128] = -18.6937810814837
        struct[0].Gy_ini[131,129] = 88.4888280826460
        struct[0].Gy_ini[131,130] = 113.786109551688
        struct[0].Gy_ini[131,131] = -242.095286143588
        struct[0].Gy_ini[131,132] = 10.2713736253513
        struct[0].Gy_ini[131,133] = -39.6392229058202
        struct[0].Gy_ini[131,134] = 23.2849644809540
        struct[0].Gy_ini[131,135] = -24.9575997948692
        struct[0].Gy_ini[131,136] = 10.2713736253513
        struct[0].Gy_ini[131,137] = -39.6392229058202
        struct[0].Gy_ini[131,138] = -54.0657727682604
        struct[0].Gy_ini[131,139] = 105.571769313180
        struct[0].Gy_ini[132,40] = 30.9517475172273
        struct[0].Gy_ini[132,41] = 5.65456401516768
        struct[0].Gy_ini[132,42] = -9.21038227100566
        struct[0].Gy_ini[132,43] = 1.84896616921897
        struct[0].Gy_ini[132,44] = -9.00835072044485
        struct[0].Gy_ini[132,45] = 0.793238195499529
        struct[0].Gy_ini[132,46] = -9.21038227100566
        struct[0].Gy_ini[132,47] = 1.84896616921897
        struct[0].Gy_ini[132,124] = 105.571769313180
        struct[0].Gy_ini[132,125] = 54.0657727682604
        struct[0].Gy_ini[132,126] = -39.6392229058202
        struct[0].Gy_ini[132,127] = -10.2713736253513
        struct[0].Gy_ini[132,128] = -24.9575997948692
        struct[0].Gy_ini[132,129] = -23.2849644809540
        struct[0].Gy_ini[132,130] = -39.6392229058202
        struct[0].Gy_ini[132,131] = -10.2713736253513
        struct[0].Gy_ini[132,132] = -136.523516830407
        struct[0].Gy_ini[132,133] = -59.7203367834281
        struct[0].Gy_ini[132,134] = 48.8496051768258
        struct[0].Gy_ini[132,135] = 8.42240745613237
        struct[0].Gy_ini[132,136] = 33.9659505153141
        struct[0].Gy_ini[132,137] = 22.4917262854545
        struct[0].Gy_ini[132,138] = 48.8496051768258
        struct[0].Gy_ini[132,139] = 8.42240745613237
        struct[0].Gy_ini[132,413] = 1
        struct[0].Gy_ini[133,40] = -5.65456401516768
        struct[0].Gy_ini[133,41] = 30.9517475172273
        struct[0].Gy_ini[133,42] = -1.84896616921897
        struct[0].Gy_ini[133,43] = -9.21038227100566
        struct[0].Gy_ini[133,44] = -0.793238195499529
        struct[0].Gy_ini[133,45] = -9.00835072044485
        struct[0].Gy_ini[133,46] = -1.84896616921897
        struct[0].Gy_ini[133,47] = -9.21038227100566
        struct[0].Gy_ini[133,124] = -54.0657727682604
        struct[0].Gy_ini[133,125] = 105.571769313180
        struct[0].Gy_ini[133,126] = 10.2713736253513
        struct[0].Gy_ini[133,127] = -39.6392229058202
        struct[0].Gy_ini[133,128] = 23.2849644809540
        struct[0].Gy_ini[133,129] = -24.9575997948692
        struct[0].Gy_ini[133,130] = 10.2713736253513
        struct[0].Gy_ini[133,131] = -39.6392229058202
        struct[0].Gy_ini[133,132] = 59.7203367834281
        struct[0].Gy_ini[133,133] = -136.523516830407
        struct[0].Gy_ini[133,134] = -8.42240745613237
        struct[0].Gy_ini[133,135] = 48.8496051768258
        struct[0].Gy_ini[133,136] = -22.4917262854545
        struct[0].Gy_ini[133,137] = 33.9659505153141
        struct[0].Gy_ini[133,138] = -8.42240745613237
        struct[0].Gy_ini[133,139] = 48.8496051768258
        struct[0].Gy_ini[133,414] = 1
        struct[0].Gy_ini[134,40] = -9.21038227100566
        struct[0].Gy_ini[134,41] = 1.84896616921897
        struct[0].Gy_ini[134,42] = 30.9517475172273
        struct[0].Gy_ini[134,43] = 5.65456401516768
        struct[0].Gy_ini[134,44] = -9.21038227100566
        struct[0].Gy_ini[134,45] = 1.84896616921897
        struct[0].Gy_ini[134,46] = -9.00835072044485
        struct[0].Gy_ini[134,47] = 0.793238195499528
        struct[0].Gy_ini[134,124] = -39.6392229058202
        struct[0].Gy_ini[134,125] = -10.2713736253513
        struct[0].Gy_ini[134,126] = 105.571769313180
        struct[0].Gy_ini[134,127] = 54.0657727682604
        struct[0].Gy_ini[134,128] = -39.6392229058201
        struct[0].Gy_ini[134,129] = -10.2713736253513
        struct[0].Gy_ini[134,130] = -24.9575997948692
        struct[0].Gy_ini[134,131] = -23.2849644809540
        struct[0].Gy_ini[134,132] = 48.8496051768258
        struct[0].Gy_ini[134,133] = 8.42240745613237
        struct[0].Gy_ini[134,134] = -136.523516830407
        struct[0].Gy_ini[134,135] = -59.7203367834280
        struct[0].Gy_ini[134,136] = 48.8496051768258
        struct[0].Gy_ini[134,137] = 8.42240745613238
        struct[0].Gy_ini[134,138] = 33.9659505153141
        struct[0].Gy_ini[134,139] = 22.4917262854545
        struct[0].Gy_ini[134,415] = 1
        struct[0].Gy_ini[135,40] = -1.84896616921897
        struct[0].Gy_ini[135,41] = -9.21038227100566
        struct[0].Gy_ini[135,42] = -5.65456401516768
        struct[0].Gy_ini[135,43] = 30.9517475172273
        struct[0].Gy_ini[135,44] = -1.84896616921897
        struct[0].Gy_ini[135,45] = -9.21038227100566
        struct[0].Gy_ini[135,46] = -0.793238195499528
        struct[0].Gy_ini[135,47] = -9.00835072044485
        struct[0].Gy_ini[135,124] = 10.2713736253513
        struct[0].Gy_ini[135,125] = -39.6392229058202
        struct[0].Gy_ini[135,126] = -54.0657727682604
        struct[0].Gy_ini[135,127] = 105.571769313180
        struct[0].Gy_ini[135,128] = 10.2713736253513
        struct[0].Gy_ini[135,129] = -39.6392229058201
        struct[0].Gy_ini[135,130] = 23.2849644809540
        struct[0].Gy_ini[135,131] = -24.9575997948692
        struct[0].Gy_ini[135,132] = -8.42240745613237
        struct[0].Gy_ini[135,133] = 48.8496051768258
        struct[0].Gy_ini[135,134] = 59.7203367834280
        struct[0].Gy_ini[135,135] = -136.523516830407
        struct[0].Gy_ini[135,136] = -8.42240745613238
        struct[0].Gy_ini[135,137] = 48.8496051768258
        struct[0].Gy_ini[135,138] = -22.4917262854545
        struct[0].Gy_ini[135,139] = 33.9659505153141
        struct[0].Gy_ini[135,416] = 1
        struct[0].Gy_ini[136,40] = -9.00835072044484
        struct[0].Gy_ini[136,41] = 0.793238195499527
        struct[0].Gy_ini[136,42] = -9.21038227100566
        struct[0].Gy_ini[136,43] = 1.84896616921897
        struct[0].Gy_ini[136,44] = 30.9517475172273
        struct[0].Gy_ini[136,45] = 5.65456401516768
        struct[0].Gy_ini[136,46] = -9.21038227100566
        struct[0].Gy_ini[136,47] = 1.84896616921897
        struct[0].Gy_ini[136,124] = -24.9575997948692
        struct[0].Gy_ini[136,125] = -23.2849644809540
        struct[0].Gy_ini[136,126] = -39.6392229058202
        struct[0].Gy_ini[136,127] = -10.2713736253513
        struct[0].Gy_ini[136,128] = 105.571769313180
        struct[0].Gy_ini[136,129] = 54.0657727682604
        struct[0].Gy_ini[136,130] = -39.6392229058201
        struct[0].Gy_ini[136,131] = -10.2713736253514
        struct[0].Gy_ini[136,132] = 33.9659505153141
        struct[0].Gy_ini[136,133] = 22.4917262854545
        struct[0].Gy_ini[136,134] = 48.8496051768259
        struct[0].Gy_ini[136,135] = 8.42240745613236
        struct[0].Gy_ini[136,136] = -136.523516830407
        struct[0].Gy_ini[136,137] = -59.7203367834281
        struct[0].Gy_ini[136,138] = 48.8496051768258
        struct[0].Gy_ini[136,139] = 8.42240745613239
        struct[0].Gy_ini[136,417] = 1
        struct[0].Gy_ini[137,40] = -0.793238195499527
        struct[0].Gy_ini[137,41] = -9.00835072044484
        struct[0].Gy_ini[137,42] = -1.84896616921897
        struct[0].Gy_ini[137,43] = -9.21038227100566
        struct[0].Gy_ini[137,44] = -5.65456401516768
        struct[0].Gy_ini[137,45] = 30.9517475172273
        struct[0].Gy_ini[137,46] = -1.84896616921897
        struct[0].Gy_ini[137,47] = -9.21038227100566
        struct[0].Gy_ini[137,124] = 23.2849644809540
        struct[0].Gy_ini[137,125] = -24.9575997948692
        struct[0].Gy_ini[137,126] = 10.2713736253513
        struct[0].Gy_ini[137,127] = -39.6392229058202
        struct[0].Gy_ini[137,128] = -54.0657727682604
        struct[0].Gy_ini[137,129] = 105.571769313180
        struct[0].Gy_ini[137,130] = 10.2713736253514
        struct[0].Gy_ini[137,131] = -39.6392229058201
        struct[0].Gy_ini[137,132] = -22.4917262854545
        struct[0].Gy_ini[137,133] = 33.9659505153141
        struct[0].Gy_ini[137,134] = -8.42240745613236
        struct[0].Gy_ini[137,135] = 48.8496051768259
        struct[0].Gy_ini[137,136] = 59.7203367834281
        struct[0].Gy_ini[137,137] = -136.523516830407
        struct[0].Gy_ini[137,138] = -8.42240745613239
        struct[0].Gy_ini[137,139] = 48.8496051768258
        struct[0].Gy_ini[137,418] = 1
        struct[0].Gy_ini[138,40] = -9.21038227100566
        struct[0].Gy_ini[138,41] = 1.84896616921897
        struct[0].Gy_ini[138,42] = -9.00835072044485
        struct[0].Gy_ini[138,43] = 0.793238195499527
        struct[0].Gy_ini[138,44] = -9.21038227100566
        struct[0].Gy_ini[138,45] = 1.84896616921897
        struct[0].Gy_ini[138,46] = 30.9517475172273
        struct[0].Gy_ini[138,47] = 5.65456401516768
        struct[0].Gy_ini[138,124] = -39.6392229058202
        struct[0].Gy_ini[138,125] = -10.2713736253513
        struct[0].Gy_ini[138,126] = -24.9575997948692
        struct[0].Gy_ini[138,127] = -23.2849644809540
        struct[0].Gy_ini[138,128] = -39.6392229058202
        struct[0].Gy_ini[138,129] = -10.2713736253513
        struct[0].Gy_ini[138,130] = 105.571769313180
        struct[0].Gy_ini[138,131] = 54.0657727682604
        struct[0].Gy_ini[138,132] = 48.8496051768258
        struct[0].Gy_ini[138,133] = 8.42240745613237
        struct[0].Gy_ini[138,134] = 33.9659505153140
        struct[0].Gy_ini[138,135] = 22.4917262854545
        struct[0].Gy_ini[138,136] = 48.8496051768258
        struct[0].Gy_ini[138,137] = 8.42240745613237
        struct[0].Gy_ini[138,138] = -136.548516830407
        struct[0].Gy_ini[138,139] = -59.7203367834281
        struct[0].Gy_ini[139,40] = -1.84896616921897
        struct[0].Gy_ini[139,41] = -9.21038227100566
        struct[0].Gy_ini[139,42] = -0.793238195499527
        struct[0].Gy_ini[139,43] = -9.00835072044485
        struct[0].Gy_ini[139,44] = -1.84896616921897
        struct[0].Gy_ini[139,45] = -9.21038227100566
        struct[0].Gy_ini[139,46] = -5.65456401516768
        struct[0].Gy_ini[139,47] = 30.9517475172273
        struct[0].Gy_ini[139,124] = 10.2713736253513
        struct[0].Gy_ini[139,125] = -39.6392229058202
        struct[0].Gy_ini[139,126] = 23.2849644809540
        struct[0].Gy_ini[139,127] = -24.9575997948692
        struct[0].Gy_ini[139,128] = 10.2713736253513
        struct[0].Gy_ini[139,129] = -39.6392229058202
        struct[0].Gy_ini[139,130] = -54.0657727682604
        struct[0].Gy_ini[139,131] = 105.571769313180
        struct[0].Gy_ini[139,132] = -8.42240745613237
        struct[0].Gy_ini[139,133] = 48.8496051768258
        struct[0].Gy_ini[139,134] = -22.4917262854545
        struct[0].Gy_ini[139,135] = 33.9659505153140
        struct[0].Gy_ini[139,136] = -8.42240745613237
        struct[0].Gy_ini[139,137] = 48.8496051768258
        struct[0].Gy_ini[139,138] = 59.7203367834281
        struct[0].Gy_ini[139,139] = -136.548516830407
        struct[0].Gy_ini[140,84] = 26.5300693004806
        struct[0].Gy_ini[140,85] = 4.84676915585801
        struct[0].Gy_ini[140,86] = -7.89461337514770
        struct[0].Gy_ini[140,87] = 1.58482814504483
        struct[0].Gy_ini[140,88] = -7.72144347466701
        struct[0].Gy_ini[140,89] = 0.679918453285310
        struct[0].Gy_ini[140,90] = -7.89461337514771
        struct[0].Gy_ini[140,91] = 1.58482814504483
        struct[0].Gy_ini[140,140] = -53.0601386009611
        struct[0].Gy_ini[140,141] = -9.69353831171601
        struct[0].Gy_ini[140,142] = 15.7892267502954
        struct[0].Gy_ini[140,143] = -3.16965629008966
        struct[0].Gy_ini[140,144] = 15.4428869493340
        struct[0].Gy_ini[140,145] = -1.35983690657062
        struct[0].Gy_ini[140,146] = 15.7892267502954
        struct[0].Gy_ini[140,147] = -3.16965629008966
        struct[0].Gy_ini[140,148] = 26.5300693004806
        struct[0].Gy_ini[140,149] = 4.84676915585801
        struct[0].Gy_ini[140,150] = -7.89461337514770
        struct[0].Gy_ini[140,151] = 1.58482814504483
        struct[0].Gy_ini[140,152] = -7.72144347466701
        struct[0].Gy_ini[140,153] = 0.679918453285310
        struct[0].Gy_ini[140,154] = -7.89461337514771
        struct[0].Gy_ini[140,155] = 1.58482814504483
        struct[0].Gy_ini[141,84] = -4.84676915585801
        struct[0].Gy_ini[141,85] = 26.5300693004806
        struct[0].Gy_ini[141,86] = -1.58482814504483
        struct[0].Gy_ini[141,87] = -7.89461337514770
        struct[0].Gy_ini[141,88] = -0.679918453285310
        struct[0].Gy_ini[141,89] = -7.72144347466701
        struct[0].Gy_ini[141,90] = -1.58482814504483
        struct[0].Gy_ini[141,91] = -7.89461337514771
        struct[0].Gy_ini[141,140] = 9.69353831171601
        struct[0].Gy_ini[141,141] = -53.0601386009611
        struct[0].Gy_ini[141,142] = 3.16965629008966
        struct[0].Gy_ini[141,143] = 15.7892267502954
        struct[0].Gy_ini[141,144] = 1.35983690657062
        struct[0].Gy_ini[141,145] = 15.4428869493340
        struct[0].Gy_ini[141,146] = 3.16965629008966
        struct[0].Gy_ini[141,147] = 15.7892267502954
        struct[0].Gy_ini[141,148] = -4.84676915585801
        struct[0].Gy_ini[141,149] = 26.5300693004806
        struct[0].Gy_ini[141,150] = -1.58482814504483
        struct[0].Gy_ini[141,151] = -7.89461337514770
        struct[0].Gy_ini[141,152] = -0.679918453285310
        struct[0].Gy_ini[141,153] = -7.72144347466701
        struct[0].Gy_ini[141,154] = -1.58482814504483
        struct[0].Gy_ini[141,155] = -7.89461337514771
        struct[0].Gy_ini[142,84] = -7.89461337514771
        struct[0].Gy_ini[142,85] = 1.58482814504483
        struct[0].Gy_ini[142,86] = 26.5300693004806
        struct[0].Gy_ini[142,87] = 4.84676915585801
        struct[0].Gy_ini[142,88] = -7.89461337514771
        struct[0].Gy_ini[142,89] = 1.58482814504483
        struct[0].Gy_ini[142,90] = -7.72144347466701
        struct[0].Gy_ini[142,91] = 0.679918453285308
        struct[0].Gy_ini[142,140] = 15.7892267502954
        struct[0].Gy_ini[142,141] = -3.16965629008966
        struct[0].Gy_ini[142,142] = -53.0601386009611
        struct[0].Gy_ini[142,143] = -9.69353831171602
        struct[0].Gy_ini[142,144] = 15.7892267502954
        struct[0].Gy_ini[142,145] = -3.16965629008967
        struct[0].Gy_ini[142,146] = 15.4428869493340
        struct[0].Gy_ini[142,147] = -1.35983690657062
        struct[0].Gy_ini[142,148] = -7.89461337514771
        struct[0].Gy_ini[142,149] = 1.58482814504483
        struct[0].Gy_ini[142,150] = 26.5300693004806
        struct[0].Gy_ini[142,151] = 4.84676915585801
        struct[0].Gy_ini[142,152] = -7.89461337514771
        struct[0].Gy_ini[142,153] = 1.58482814504483
        struct[0].Gy_ini[142,154] = -7.72144347466701
        struct[0].Gy_ini[142,155] = 0.679918453285308
        struct[0].Gy_ini[143,84] = -1.58482814504483
        struct[0].Gy_ini[143,85] = -7.89461337514771
        struct[0].Gy_ini[143,86] = -4.84676915585801
        struct[0].Gy_ini[143,87] = 26.5300693004806
        struct[0].Gy_ini[143,88] = -1.58482814504483
        struct[0].Gy_ini[143,89] = -7.89461337514771
        struct[0].Gy_ini[143,90] = -0.679918453285308
        struct[0].Gy_ini[143,91] = -7.72144347466701
        struct[0].Gy_ini[143,140] = 3.16965629008966
        struct[0].Gy_ini[143,141] = 15.7892267502954
        struct[0].Gy_ini[143,142] = 9.69353831171602
        struct[0].Gy_ini[143,143] = -53.0601386009611
        struct[0].Gy_ini[143,144] = 3.16965629008967
        struct[0].Gy_ini[143,145] = 15.7892267502954
        struct[0].Gy_ini[143,146] = 1.35983690657062
        struct[0].Gy_ini[143,147] = 15.4428869493340
        struct[0].Gy_ini[143,148] = -1.58482814504483
        struct[0].Gy_ini[143,149] = -7.89461337514771
        struct[0].Gy_ini[143,150] = -4.84676915585801
        struct[0].Gy_ini[143,151] = 26.5300693004806
        struct[0].Gy_ini[143,152] = -1.58482814504483
        struct[0].Gy_ini[143,153] = -7.89461337514771
        struct[0].Gy_ini[143,154] = -0.679918453285308
        struct[0].Gy_ini[143,155] = -7.72144347466701
        struct[0].Gy_ini[144,84] = -7.72144347466701
        struct[0].Gy_ini[144,85] = 0.679918453285310
        struct[0].Gy_ini[144,86] = -7.89461337514770
        struct[0].Gy_ini[144,87] = 1.58482814504483
        struct[0].Gy_ini[144,88] = 26.5300693004806
        struct[0].Gy_ini[144,89] = 4.84676915585801
        struct[0].Gy_ini[144,90] = -7.89461337514771
        struct[0].Gy_ini[144,91] = 1.58482814504483
        struct[0].Gy_ini[144,140] = 15.4428869493340
        struct[0].Gy_ini[144,141] = -1.35983690657062
        struct[0].Gy_ini[144,142] = 15.7892267502954
        struct[0].Gy_ini[144,143] = -3.16965629008966
        struct[0].Gy_ini[144,144] = -53.0601386009611
        struct[0].Gy_ini[144,145] = -9.69353831171602
        struct[0].Gy_ini[144,146] = 15.7892267502954
        struct[0].Gy_ini[144,147] = -3.16965629008967
        struct[0].Gy_ini[144,148] = -7.72144347466701
        struct[0].Gy_ini[144,149] = 0.679918453285310
        struct[0].Gy_ini[144,150] = -7.89461337514770
        struct[0].Gy_ini[144,151] = 1.58482814504483
        struct[0].Gy_ini[144,152] = 26.5300693004806
        struct[0].Gy_ini[144,153] = 4.84676915585801
        struct[0].Gy_ini[144,154] = -7.89461337514771
        struct[0].Gy_ini[144,155] = 1.58482814504483
        struct[0].Gy_ini[145,84] = -0.679918453285310
        struct[0].Gy_ini[145,85] = -7.72144347466701
        struct[0].Gy_ini[145,86] = -1.58482814504483
        struct[0].Gy_ini[145,87] = -7.89461337514770
        struct[0].Gy_ini[145,88] = -4.84676915585801
        struct[0].Gy_ini[145,89] = 26.5300693004806
        struct[0].Gy_ini[145,90] = -1.58482814504483
        struct[0].Gy_ini[145,91] = -7.89461337514771
        struct[0].Gy_ini[145,140] = 1.35983690657062
        struct[0].Gy_ini[145,141] = 15.4428869493340
        struct[0].Gy_ini[145,142] = 3.16965629008966
        struct[0].Gy_ini[145,143] = 15.7892267502954
        struct[0].Gy_ini[145,144] = 9.69353831171602
        struct[0].Gy_ini[145,145] = -53.0601386009611
        struct[0].Gy_ini[145,146] = 3.16965629008967
        struct[0].Gy_ini[145,147] = 15.7892267502954
        struct[0].Gy_ini[145,148] = -0.679918453285310
        struct[0].Gy_ini[145,149] = -7.72144347466701
        struct[0].Gy_ini[145,150] = -1.58482814504483
        struct[0].Gy_ini[145,151] = -7.89461337514770
        struct[0].Gy_ini[145,152] = -4.84676915585801
        struct[0].Gy_ini[145,153] = 26.5300693004806
        struct[0].Gy_ini[145,154] = -1.58482814504483
        struct[0].Gy_ini[145,155] = -7.89461337514771
        struct[0].Gy_ini[146,84] = -7.89461337514771
        struct[0].Gy_ini[146,85] = 1.58482814504483
        struct[0].Gy_ini[146,86] = -7.72144347466701
        struct[0].Gy_ini[146,87] = 0.679918453285308
        struct[0].Gy_ini[146,88] = -7.89461337514771
        struct[0].Gy_ini[146,89] = 1.58482814504483
        struct[0].Gy_ini[146,90] = 26.5300693004806
        struct[0].Gy_ini[146,91] = 4.84676915585801
        struct[0].Gy_ini[146,140] = 15.7892267502954
        struct[0].Gy_ini[146,141] = -3.16965629008966
        struct[0].Gy_ini[146,142] = 15.4428869493340
        struct[0].Gy_ini[146,143] = -1.35983690657062
        struct[0].Gy_ini[146,144] = 15.7892267502954
        struct[0].Gy_ini[146,145] = -3.16965629008966
        struct[0].Gy_ini[146,146] = -53.0601386009611
        struct[0].Gy_ini[146,147] = -9.69353831171602
        struct[0].Gy_ini[146,148] = -7.89461337514771
        struct[0].Gy_ini[146,149] = 1.58482814504483
        struct[0].Gy_ini[146,150] = -7.72144347466701
        struct[0].Gy_ini[146,151] = 0.679918453285308
        struct[0].Gy_ini[146,152] = -7.89461337514771
        struct[0].Gy_ini[146,153] = 1.58482814504483
        struct[0].Gy_ini[146,154] = 26.5300693004806
        struct[0].Gy_ini[146,155] = 4.84676915585801
        struct[0].Gy_ini[147,84] = -1.58482814504483
        struct[0].Gy_ini[147,85] = -7.89461337514771
        struct[0].Gy_ini[147,86] = -0.679918453285308
        struct[0].Gy_ini[147,87] = -7.72144347466701
        struct[0].Gy_ini[147,88] = -1.58482814504483
        struct[0].Gy_ini[147,89] = -7.89461337514771
        struct[0].Gy_ini[147,90] = -4.84676915585801
        struct[0].Gy_ini[147,91] = 26.5300693004806
        struct[0].Gy_ini[147,140] = 3.16965629008966
        struct[0].Gy_ini[147,141] = 15.7892267502954
        struct[0].Gy_ini[147,142] = 1.35983690657062
        struct[0].Gy_ini[147,143] = 15.4428869493340
        struct[0].Gy_ini[147,144] = 3.16965629008966
        struct[0].Gy_ini[147,145] = 15.7892267502954
        struct[0].Gy_ini[147,146] = 9.69353831171602
        struct[0].Gy_ini[147,147] = -53.0601386009611
        struct[0].Gy_ini[147,148] = -1.58482814504483
        struct[0].Gy_ini[147,149] = -7.89461337514771
        struct[0].Gy_ini[147,150] = -0.679918453285308
        struct[0].Gy_ini[147,151] = -7.72144347466701
        struct[0].Gy_ini[147,152] = -1.58482814504483
        struct[0].Gy_ini[147,153] = -7.89461337514771
        struct[0].Gy_ini[147,154] = -4.84676915585801
        struct[0].Gy_ini[147,155] = 26.5300693004806
        struct[0].Gy_ini[148,140] = 26.5300693004806
        struct[0].Gy_ini[148,141] = 4.84676915585801
        struct[0].Gy_ini[148,142] = -7.89461337514770
        struct[0].Gy_ini[148,143] = 1.58482814504483
        struct[0].Gy_ini[148,144] = -7.72144347466701
        struct[0].Gy_ini[148,145] = 0.679918453285310
        struct[0].Gy_ini[148,146] = -7.89461337514771
        struct[0].Gy_ini[148,147] = 1.58482814504483
        struct[0].Gy_ini[148,148] = -53.0601386009611
        struct[0].Gy_ini[148,149] = -9.69353831171601
        struct[0].Gy_ini[148,150] = 15.7892267502954
        struct[0].Gy_ini[148,151] = -3.16965629008966
        struct[0].Gy_ini[148,152] = 15.4428869493340
        struct[0].Gy_ini[148,153] = -1.35983690657062
        struct[0].Gy_ini[148,154] = 15.7892267502954
        struct[0].Gy_ini[148,155] = -3.16965629008966
        struct[0].Gy_ini[148,156] = 26.5300693004806
        struct[0].Gy_ini[148,157] = 4.84676915585801
        struct[0].Gy_ini[148,158] = -7.89461337514770
        struct[0].Gy_ini[148,159] = 1.58482814504483
        struct[0].Gy_ini[148,160] = -7.72144347466701
        struct[0].Gy_ini[148,161] = 0.679918453285310
        struct[0].Gy_ini[148,162] = -7.89461337514771
        struct[0].Gy_ini[148,163] = 1.58482814504483
        struct[0].Gy_ini[149,140] = -4.84676915585801
        struct[0].Gy_ini[149,141] = 26.5300693004806
        struct[0].Gy_ini[149,142] = -1.58482814504483
        struct[0].Gy_ini[149,143] = -7.89461337514770
        struct[0].Gy_ini[149,144] = -0.679918453285310
        struct[0].Gy_ini[149,145] = -7.72144347466701
        struct[0].Gy_ini[149,146] = -1.58482814504483
        struct[0].Gy_ini[149,147] = -7.89461337514771
        struct[0].Gy_ini[149,148] = 9.69353831171601
        struct[0].Gy_ini[149,149] = -53.0601386009611
        struct[0].Gy_ini[149,150] = 3.16965629008966
        struct[0].Gy_ini[149,151] = 15.7892267502954
        struct[0].Gy_ini[149,152] = 1.35983690657062
        struct[0].Gy_ini[149,153] = 15.4428869493340
        struct[0].Gy_ini[149,154] = 3.16965629008966
        struct[0].Gy_ini[149,155] = 15.7892267502954
        struct[0].Gy_ini[149,156] = -4.84676915585801
        struct[0].Gy_ini[149,157] = 26.5300693004806
        struct[0].Gy_ini[149,158] = -1.58482814504483
        struct[0].Gy_ini[149,159] = -7.89461337514770
        struct[0].Gy_ini[149,160] = -0.679918453285310
        struct[0].Gy_ini[149,161] = -7.72144347466701
        struct[0].Gy_ini[149,162] = -1.58482814504483
        struct[0].Gy_ini[149,163] = -7.89461337514771
        struct[0].Gy_ini[150,140] = -7.89461337514771
        struct[0].Gy_ini[150,141] = 1.58482814504483
        struct[0].Gy_ini[150,142] = 26.5300693004806
        struct[0].Gy_ini[150,143] = 4.84676915585801
        struct[0].Gy_ini[150,144] = -7.89461337514771
        struct[0].Gy_ini[150,145] = 1.58482814504483
        struct[0].Gy_ini[150,146] = -7.72144347466701
        struct[0].Gy_ini[150,147] = 0.679918453285308
        struct[0].Gy_ini[150,148] = 15.7892267502954
        struct[0].Gy_ini[150,149] = -3.16965629008966
        struct[0].Gy_ini[150,150] = -53.0601386009611
        struct[0].Gy_ini[150,151] = -9.69353831171602
        struct[0].Gy_ini[150,152] = 15.7892267502954
        struct[0].Gy_ini[150,153] = -3.16965629008967
        struct[0].Gy_ini[150,154] = 15.4428869493340
        struct[0].Gy_ini[150,155] = -1.35983690657062
        struct[0].Gy_ini[150,156] = -7.89461337514771
        struct[0].Gy_ini[150,157] = 1.58482814504483
        struct[0].Gy_ini[150,158] = 26.5300693004806
        struct[0].Gy_ini[150,159] = 4.84676915585801
        struct[0].Gy_ini[150,160] = -7.89461337514771
        struct[0].Gy_ini[150,161] = 1.58482814504483
        struct[0].Gy_ini[150,162] = -7.72144347466701
        struct[0].Gy_ini[150,163] = 0.679918453285308
        struct[0].Gy_ini[151,140] = -1.58482814504483
        struct[0].Gy_ini[151,141] = -7.89461337514771
        struct[0].Gy_ini[151,142] = -4.84676915585801
        struct[0].Gy_ini[151,143] = 26.5300693004806
        struct[0].Gy_ini[151,144] = -1.58482814504483
        struct[0].Gy_ini[151,145] = -7.89461337514771
        struct[0].Gy_ini[151,146] = -0.679918453285308
        struct[0].Gy_ini[151,147] = -7.72144347466701
        struct[0].Gy_ini[151,148] = 3.16965629008966
        struct[0].Gy_ini[151,149] = 15.7892267502954
        struct[0].Gy_ini[151,150] = 9.69353831171602
        struct[0].Gy_ini[151,151] = -53.0601386009611
        struct[0].Gy_ini[151,152] = 3.16965629008967
        struct[0].Gy_ini[151,153] = 15.7892267502954
        struct[0].Gy_ini[151,154] = 1.35983690657062
        struct[0].Gy_ini[151,155] = 15.4428869493340
        struct[0].Gy_ini[151,156] = -1.58482814504483
        struct[0].Gy_ini[151,157] = -7.89461337514771
        struct[0].Gy_ini[151,158] = -4.84676915585801
        struct[0].Gy_ini[151,159] = 26.5300693004806
        struct[0].Gy_ini[151,160] = -1.58482814504483
        struct[0].Gy_ini[151,161] = -7.89461337514771
        struct[0].Gy_ini[151,162] = -0.679918453285308
        struct[0].Gy_ini[151,163] = -7.72144347466701
        struct[0].Gy_ini[152,140] = -7.72144347466701
        struct[0].Gy_ini[152,141] = 0.679918453285310
        struct[0].Gy_ini[152,142] = -7.89461337514770
        struct[0].Gy_ini[152,143] = 1.58482814504483
        struct[0].Gy_ini[152,144] = 26.5300693004806
        struct[0].Gy_ini[152,145] = 4.84676915585801
        struct[0].Gy_ini[152,146] = -7.89461337514771
        struct[0].Gy_ini[152,147] = 1.58482814504483
        struct[0].Gy_ini[152,148] = 15.4428869493340
        struct[0].Gy_ini[152,149] = -1.35983690657062
        struct[0].Gy_ini[152,150] = 15.7892267502954
        struct[0].Gy_ini[152,151] = -3.16965629008966
        struct[0].Gy_ini[152,152] = -53.0601386009611
        struct[0].Gy_ini[152,153] = -9.69353831171602
        struct[0].Gy_ini[152,154] = 15.7892267502954
        struct[0].Gy_ini[152,155] = -3.16965629008967
        struct[0].Gy_ini[152,156] = -7.72144347466701
        struct[0].Gy_ini[152,157] = 0.679918453285310
        struct[0].Gy_ini[152,158] = -7.89461337514770
        struct[0].Gy_ini[152,159] = 1.58482814504483
        struct[0].Gy_ini[152,160] = 26.5300693004806
        struct[0].Gy_ini[152,161] = 4.84676915585801
        struct[0].Gy_ini[152,162] = -7.89461337514771
        struct[0].Gy_ini[152,163] = 1.58482814504483
        struct[0].Gy_ini[153,140] = -0.679918453285310
        struct[0].Gy_ini[153,141] = -7.72144347466701
        struct[0].Gy_ini[153,142] = -1.58482814504483
        struct[0].Gy_ini[153,143] = -7.89461337514770
        struct[0].Gy_ini[153,144] = -4.84676915585801
        struct[0].Gy_ini[153,145] = 26.5300693004806
        struct[0].Gy_ini[153,146] = -1.58482814504483
        struct[0].Gy_ini[153,147] = -7.89461337514771
        struct[0].Gy_ini[153,148] = 1.35983690657062
        struct[0].Gy_ini[153,149] = 15.4428869493340
        struct[0].Gy_ini[153,150] = 3.16965629008966
        struct[0].Gy_ini[153,151] = 15.7892267502954
        struct[0].Gy_ini[153,152] = 9.69353831171602
        struct[0].Gy_ini[153,153] = -53.0601386009611
        struct[0].Gy_ini[153,154] = 3.16965629008967
        struct[0].Gy_ini[153,155] = 15.7892267502954
        struct[0].Gy_ini[153,156] = -0.679918453285310
        struct[0].Gy_ini[153,157] = -7.72144347466701
        struct[0].Gy_ini[153,158] = -1.58482814504483
        struct[0].Gy_ini[153,159] = -7.89461337514770
        struct[0].Gy_ini[153,160] = -4.84676915585801
        struct[0].Gy_ini[153,161] = 26.5300693004806
        struct[0].Gy_ini[153,162] = -1.58482814504483
        struct[0].Gy_ini[153,163] = -7.89461337514771
        struct[0].Gy_ini[154,140] = -7.89461337514771
        struct[0].Gy_ini[154,141] = 1.58482814504483
        struct[0].Gy_ini[154,142] = -7.72144347466701
        struct[0].Gy_ini[154,143] = 0.679918453285308
        struct[0].Gy_ini[154,144] = -7.89461337514771
        struct[0].Gy_ini[154,145] = 1.58482814504483
        struct[0].Gy_ini[154,146] = 26.5300693004806
        struct[0].Gy_ini[154,147] = 4.84676915585801
        struct[0].Gy_ini[154,148] = 15.7892267502954
        struct[0].Gy_ini[154,149] = -3.16965629008966
        struct[0].Gy_ini[154,150] = 15.4428869493340
        struct[0].Gy_ini[154,151] = -1.35983690657062
        struct[0].Gy_ini[154,152] = 15.7892267502954
        struct[0].Gy_ini[154,153] = -3.16965629008966
        struct[0].Gy_ini[154,154] = -53.0851386009611
        struct[0].Gy_ini[154,155] = -9.69353831171602
        struct[0].Gy_ini[154,156] = -7.89461337514771
        struct[0].Gy_ini[154,157] = 1.58482814504483
        struct[0].Gy_ini[154,158] = -7.72144347466701
        struct[0].Gy_ini[154,159] = 0.679918453285308
        struct[0].Gy_ini[154,160] = -7.89461337514771
        struct[0].Gy_ini[154,161] = 1.58482814504483
        struct[0].Gy_ini[154,162] = 26.5300693004806
        struct[0].Gy_ini[154,163] = 4.84676915585801
        struct[0].Gy_ini[155,140] = -1.58482814504483
        struct[0].Gy_ini[155,141] = -7.89461337514771
        struct[0].Gy_ini[155,142] = -0.679918453285308
        struct[0].Gy_ini[155,143] = -7.72144347466701
        struct[0].Gy_ini[155,144] = -1.58482814504483
        struct[0].Gy_ini[155,145] = -7.89461337514771
        struct[0].Gy_ini[155,146] = -4.84676915585801
        struct[0].Gy_ini[155,147] = 26.5300693004806
        struct[0].Gy_ini[155,148] = 3.16965629008966
        struct[0].Gy_ini[155,149] = 15.7892267502954
        struct[0].Gy_ini[155,150] = 1.35983690657062
        struct[0].Gy_ini[155,151] = 15.4428869493340
        struct[0].Gy_ini[155,152] = 3.16965629008966
        struct[0].Gy_ini[155,153] = 15.7892267502954
        struct[0].Gy_ini[155,154] = 9.69353831171602
        struct[0].Gy_ini[155,155] = -53.0851386009611
        struct[0].Gy_ini[155,156] = -1.58482814504483
        struct[0].Gy_ini[155,157] = -7.89461337514771
        struct[0].Gy_ini[155,158] = -0.679918453285308
        struct[0].Gy_ini[155,159] = -7.72144347466701
        struct[0].Gy_ini[155,160] = -1.58482814504483
        struct[0].Gy_ini[155,161] = -7.89461337514771
        struct[0].Gy_ini[155,162] = -4.84676915585801
        struct[0].Gy_ini[155,163] = 26.5300693004806
        struct[0].Gy_ini[156,16] = 26.5300693004806
        struct[0].Gy_ini[156,17] = 4.84676915585801
        struct[0].Gy_ini[156,18] = -7.89461337514770
        struct[0].Gy_ini[156,19] = 1.58482814504483
        struct[0].Gy_ini[156,20] = -7.72144347466701
        struct[0].Gy_ini[156,21] = 0.679918453285310
        struct[0].Gy_ini[156,22] = -7.89461337514771
        struct[0].Gy_ini[156,23] = 1.58482814504483
        struct[0].Gy_ini[156,148] = 26.5300693004806
        struct[0].Gy_ini[156,149] = 4.84676915585801
        struct[0].Gy_ini[156,150] = -7.89461337514770
        struct[0].Gy_ini[156,151] = 1.58482814504483
        struct[0].Gy_ini[156,152] = -7.72144347466701
        struct[0].Gy_ini[156,153] = 0.679918453285310
        struct[0].Gy_ini[156,154] = -7.89461337514771
        struct[0].Gy_ini[156,155] = 1.58482814504483
        struct[0].Gy_ini[156,156] = -53.0601386009611
        struct[0].Gy_ini[156,157] = -9.69353831171601
        struct[0].Gy_ini[156,158] = 15.7892267502954
        struct[0].Gy_ini[156,159] = -3.16965629008966
        struct[0].Gy_ini[156,160] = 15.4428869493340
        struct[0].Gy_ini[156,161] = -1.35983690657062
        struct[0].Gy_ini[156,162] = 15.7892267502954
        struct[0].Gy_ini[156,163] = -3.16965629008966
        struct[0].Gy_ini[156,423] = 1
        struct[0].Gy_ini[157,16] = -4.84676915585801
        struct[0].Gy_ini[157,17] = 26.5300693004806
        struct[0].Gy_ini[157,18] = -1.58482814504483
        struct[0].Gy_ini[157,19] = -7.89461337514770
        struct[0].Gy_ini[157,20] = -0.679918453285310
        struct[0].Gy_ini[157,21] = -7.72144347466701
        struct[0].Gy_ini[157,22] = -1.58482814504483
        struct[0].Gy_ini[157,23] = -7.89461337514771
        struct[0].Gy_ini[157,148] = -4.84676915585801
        struct[0].Gy_ini[157,149] = 26.5300693004806
        struct[0].Gy_ini[157,150] = -1.58482814504483
        struct[0].Gy_ini[157,151] = -7.89461337514770
        struct[0].Gy_ini[157,152] = -0.679918453285310
        struct[0].Gy_ini[157,153] = -7.72144347466701
        struct[0].Gy_ini[157,154] = -1.58482814504483
        struct[0].Gy_ini[157,155] = -7.89461337514771
        struct[0].Gy_ini[157,156] = 9.69353831171601
        struct[0].Gy_ini[157,157] = -53.0601386009611
        struct[0].Gy_ini[157,158] = 3.16965629008966
        struct[0].Gy_ini[157,159] = 15.7892267502954
        struct[0].Gy_ini[157,160] = 1.35983690657062
        struct[0].Gy_ini[157,161] = 15.4428869493340
        struct[0].Gy_ini[157,162] = 3.16965629008966
        struct[0].Gy_ini[157,163] = 15.7892267502954
        struct[0].Gy_ini[157,424] = 1
        struct[0].Gy_ini[158,16] = -7.89461337514771
        struct[0].Gy_ini[158,17] = 1.58482814504483
        struct[0].Gy_ini[158,18] = 26.5300693004806
        struct[0].Gy_ini[158,19] = 4.84676915585801
        struct[0].Gy_ini[158,20] = -7.89461337514771
        struct[0].Gy_ini[158,21] = 1.58482814504483
        struct[0].Gy_ini[158,22] = -7.72144347466701
        struct[0].Gy_ini[158,23] = 0.679918453285308
        struct[0].Gy_ini[158,148] = -7.89461337514771
        struct[0].Gy_ini[158,149] = 1.58482814504483
        struct[0].Gy_ini[158,150] = 26.5300693004806
        struct[0].Gy_ini[158,151] = 4.84676915585801
        struct[0].Gy_ini[158,152] = -7.89461337514771
        struct[0].Gy_ini[158,153] = 1.58482814504483
        struct[0].Gy_ini[158,154] = -7.72144347466701
        struct[0].Gy_ini[158,155] = 0.679918453285308
        struct[0].Gy_ini[158,156] = 15.7892267502954
        struct[0].Gy_ini[158,157] = -3.16965629008966
        struct[0].Gy_ini[158,158] = -53.0601386009611
        struct[0].Gy_ini[158,159] = -9.69353831171602
        struct[0].Gy_ini[158,160] = 15.7892267502954
        struct[0].Gy_ini[158,161] = -3.16965629008967
        struct[0].Gy_ini[158,162] = 15.4428869493340
        struct[0].Gy_ini[158,163] = -1.35983690657062
        struct[0].Gy_ini[158,425] = 1
        struct[0].Gy_ini[159,16] = -1.58482814504483
        struct[0].Gy_ini[159,17] = -7.89461337514771
        struct[0].Gy_ini[159,18] = -4.84676915585801
        struct[0].Gy_ini[159,19] = 26.5300693004806
        struct[0].Gy_ini[159,20] = -1.58482814504483
        struct[0].Gy_ini[159,21] = -7.89461337514771
        struct[0].Gy_ini[159,22] = -0.679918453285308
        struct[0].Gy_ini[159,23] = -7.72144347466701
        struct[0].Gy_ini[159,148] = -1.58482814504483
        struct[0].Gy_ini[159,149] = -7.89461337514771
        struct[0].Gy_ini[159,150] = -4.84676915585801
        struct[0].Gy_ini[159,151] = 26.5300693004806
        struct[0].Gy_ini[159,152] = -1.58482814504483
        struct[0].Gy_ini[159,153] = -7.89461337514771
        struct[0].Gy_ini[159,154] = -0.679918453285308
        struct[0].Gy_ini[159,155] = -7.72144347466701
        struct[0].Gy_ini[159,156] = 3.16965629008966
        struct[0].Gy_ini[159,157] = 15.7892267502954
        struct[0].Gy_ini[159,158] = 9.69353831171602
        struct[0].Gy_ini[159,159] = -53.0601386009611
        struct[0].Gy_ini[159,160] = 3.16965629008967
        struct[0].Gy_ini[159,161] = 15.7892267502954
        struct[0].Gy_ini[159,162] = 1.35983690657062
        struct[0].Gy_ini[159,163] = 15.4428869493340
        struct[0].Gy_ini[159,426] = 1
        struct[0].Gy_ini[160,16] = -7.72144347466701
        struct[0].Gy_ini[160,17] = 0.679918453285310
        struct[0].Gy_ini[160,18] = -7.89461337514770
        struct[0].Gy_ini[160,19] = 1.58482814504483
        struct[0].Gy_ini[160,20] = 26.5300693004806
        struct[0].Gy_ini[160,21] = 4.84676915585801
        struct[0].Gy_ini[160,22] = -7.89461337514771
        struct[0].Gy_ini[160,23] = 1.58482814504483
        struct[0].Gy_ini[160,148] = -7.72144347466701
        struct[0].Gy_ini[160,149] = 0.679918453285310
        struct[0].Gy_ini[160,150] = -7.89461337514770
        struct[0].Gy_ini[160,151] = 1.58482814504483
        struct[0].Gy_ini[160,152] = 26.5300693004806
        struct[0].Gy_ini[160,153] = 4.84676915585801
        struct[0].Gy_ini[160,154] = -7.89461337514771
        struct[0].Gy_ini[160,155] = 1.58482814504483
        struct[0].Gy_ini[160,156] = 15.4428869493340
        struct[0].Gy_ini[160,157] = -1.35983690657062
        struct[0].Gy_ini[160,158] = 15.7892267502954
        struct[0].Gy_ini[160,159] = -3.16965629008966
        struct[0].Gy_ini[160,160] = -53.0601386009611
        struct[0].Gy_ini[160,161] = -9.69353831171602
        struct[0].Gy_ini[160,162] = 15.7892267502954
        struct[0].Gy_ini[160,163] = -3.16965629008967
        struct[0].Gy_ini[160,427] = 1
        struct[0].Gy_ini[161,16] = -0.679918453285310
        struct[0].Gy_ini[161,17] = -7.72144347466701
        struct[0].Gy_ini[161,18] = -1.58482814504483
        struct[0].Gy_ini[161,19] = -7.89461337514770
        struct[0].Gy_ini[161,20] = -4.84676915585801
        struct[0].Gy_ini[161,21] = 26.5300693004806
        struct[0].Gy_ini[161,22] = -1.58482814504483
        struct[0].Gy_ini[161,23] = -7.89461337514771
        struct[0].Gy_ini[161,148] = -0.679918453285310
        struct[0].Gy_ini[161,149] = -7.72144347466701
        struct[0].Gy_ini[161,150] = -1.58482814504483
        struct[0].Gy_ini[161,151] = -7.89461337514770
        struct[0].Gy_ini[161,152] = -4.84676915585801
        struct[0].Gy_ini[161,153] = 26.5300693004806
        struct[0].Gy_ini[161,154] = -1.58482814504483
        struct[0].Gy_ini[161,155] = -7.89461337514771
        struct[0].Gy_ini[161,156] = 1.35983690657062
        struct[0].Gy_ini[161,157] = 15.4428869493340
        struct[0].Gy_ini[161,158] = 3.16965629008966
        struct[0].Gy_ini[161,159] = 15.7892267502954
        struct[0].Gy_ini[161,160] = 9.69353831171602
        struct[0].Gy_ini[161,161] = -53.0601386009611
        struct[0].Gy_ini[161,162] = 3.16965629008967
        struct[0].Gy_ini[161,163] = 15.7892267502954
        struct[0].Gy_ini[161,428] = 1
        struct[0].Gy_ini[162,16] = -7.89461337514771
        struct[0].Gy_ini[162,17] = 1.58482814504483
        struct[0].Gy_ini[162,18] = -7.72144347466701
        struct[0].Gy_ini[162,19] = 0.679918453285308
        struct[0].Gy_ini[162,20] = -7.89461337514771
        struct[0].Gy_ini[162,21] = 1.58482814504483
        struct[0].Gy_ini[162,22] = 26.5300693004806
        struct[0].Gy_ini[162,23] = 4.84676915585801
        struct[0].Gy_ini[162,148] = -7.89461337514771
        struct[0].Gy_ini[162,149] = 1.58482814504483
        struct[0].Gy_ini[162,150] = -7.72144347466701
        struct[0].Gy_ini[162,151] = 0.679918453285308
        struct[0].Gy_ini[162,152] = -7.89461337514771
        struct[0].Gy_ini[162,153] = 1.58482814504483
        struct[0].Gy_ini[162,154] = 26.5300693004806
        struct[0].Gy_ini[162,155] = 4.84676915585801
        struct[0].Gy_ini[162,156] = 15.7892267502954
        struct[0].Gy_ini[162,157] = -3.16965629008966
        struct[0].Gy_ini[162,158] = 15.4428869493340
        struct[0].Gy_ini[162,159] = -1.35983690657062
        struct[0].Gy_ini[162,160] = 15.7892267502954
        struct[0].Gy_ini[162,161] = -3.16965629008966
        struct[0].Gy_ini[162,162] = -53.0601386009611
        struct[0].Gy_ini[162,163] = -9.69353831171602
        struct[0].Gy_ini[163,16] = -1.58482814504483
        struct[0].Gy_ini[163,17] = -7.89461337514771
        struct[0].Gy_ini[163,18] = -0.679918453285308
        struct[0].Gy_ini[163,19] = -7.72144347466701
        struct[0].Gy_ini[163,20] = -1.58482814504483
        struct[0].Gy_ini[163,21] = -7.89461337514771
        struct[0].Gy_ini[163,22] = -4.84676915585801
        struct[0].Gy_ini[163,23] = 26.5300693004806
        struct[0].Gy_ini[163,148] = -1.58482814504483
        struct[0].Gy_ini[163,149] = -7.89461337514771
        struct[0].Gy_ini[163,150] = -0.679918453285308
        struct[0].Gy_ini[163,151] = -7.72144347466701
        struct[0].Gy_ini[163,152] = -1.58482814504483
        struct[0].Gy_ini[163,153] = -7.89461337514771
        struct[0].Gy_ini[163,154] = -4.84676915585801
        struct[0].Gy_ini[163,155] = 26.5300693004806
        struct[0].Gy_ini[163,156] = 3.16965629008966
        struct[0].Gy_ini[163,157] = 15.7892267502954
        struct[0].Gy_ini[163,158] = 1.35983690657062
        struct[0].Gy_ini[163,159] = 15.4428869493340
        struct[0].Gy_ini[163,160] = 3.16965629008966
        struct[0].Gy_ini[163,161] = 15.7892267502954
        struct[0].Gy_ini[163,162] = 9.69353831171602
        struct[0].Gy_ini[163,163] = -53.0601386009611
        struct[0].Gy_ini[164,164] = -1067.70480704130
        struct[0].Gy_ini[164,172] = 67.7048070412999
        struct[0].Gy_ini[165,165] = -1067.70480704130
        struct[0].Gy_ini[165,173] = 67.7048070412999
        struct[0].Gy_ini[166,52] = 157.977883096366
        struct[0].Gy_ini[166,166] = -361.092304220266
        struct[0].Gy_ini[166,174] = 135.409614082600
        struct[0].Gy_ini[167,53] = 157.977883096366
        struct[0].Gy_ini[167,167] = -361.092304220266
        struct[0].Gy_ini[167,175] = 135.409614082600
        struct[0].Gy_ini[168,168] = -361.092304220266
        struct[0].Gy_ini[168,176] = 135.409614082600
        struct[0].Gy_ini[168,206] = 157.977883096366
        struct[0].Gy_ini[169,169] = -361.092304220266
        struct[0].Gy_ini[169,177] = 135.409614082600
        struct[0].Gy_ini[169,207] = 157.977883096366
        struct[0].Gy_ini[170,170] = -361.092304220266
        struct[0].Gy_ini[170,178] = 135.409614082600
        struct[0].Gy_ini[170,208] = 157.977883096366
        struct[0].Gy_ini[171,171] = -361.092304220266
        struct[0].Gy_ini[171,179] = 135.409614082600
        struct[0].Gy_ini[171,209] = 157.977883096366
        struct[0].Gy_ini[172,54] = 157.977883096366
        struct[0].Gy_ini[172,164] = 67.7048070412999
        struct[0].Gy_ini[172,172] = -361.092304220266
        struct[0].Gy_ini[172,180] = 135.409614082600
        struct[0].Gy_ini[173,55] = 157.977883096366
        struct[0].Gy_ini[173,165] = 67.7048070412999
        struct[0].Gy_ini[173,173] = -361.092304220266
        struct[0].Gy_ini[173,181] = 135.409614082600
        struct[0].Gy_ini[174,166] = 135.409614082600
        struct[0].Gy_ini[174,174] = -248.250959151433
        struct[0].Gy_ini[174,182] = 67.7048070412999
        struct[0].Gy_ini[174,222] = 45.1365380275333
        struct[0].Gy_ini[175,167] = 135.409614082600
        struct[0].Gy_ini[175,175] = -248.250959151433
        struct[0].Gy_ini[175,183] = 67.7048070412999
        struct[0].Gy_ini[175,223] = 45.1365380275333
        struct[0].Gy_ini[176,168] = 135.409614082600
        struct[0].Gy_ini[176,176] = -248.250959151433
        struct[0].Gy_ini[176,184] = 67.7048070412999
        struct[0].Gy_ini[176,224] = 45.1365380275333
        struct[0].Gy_ini[177,169] = 135.409614082600
        struct[0].Gy_ini[177,177] = -248.250959151433
        struct[0].Gy_ini[177,185] = 67.7048070412999
        struct[0].Gy_ini[177,225] = 45.1365380275333
        struct[0].Gy_ini[178,170] = 135.409614082600
        struct[0].Gy_ini[178,178] = -248.250959151433
        struct[0].Gy_ini[178,186] = 67.7048070412999
        struct[0].Gy_ini[178,226] = 45.1365380275333
        struct[0].Gy_ini[179,171] = 135.409614082600
        struct[0].Gy_ini[179,179] = -248.250959151433
        struct[0].Gy_ini[179,187] = 67.7048070412999
        struct[0].Gy_ini[179,227] = 45.1365380275333
        struct[0].Gy_ini[180,172] = 135.409614082600
        struct[0].Gy_ini[180,180] = -248.250959151433
        struct[0].Gy_ini[180,188] = 67.7048070412999
        struct[0].Gy_ini[180,228] = 45.1365380275333
        struct[0].Gy_ini[181,173] = 135.409614082600
        struct[0].Gy_ini[181,181] = -248.250959151433
        struct[0].Gy_ini[181,189] = 67.7048070412999
        struct[0].Gy_ini[181,229] = 45.1365380275333
        struct[0].Gy_ini[182,56] = 157.977883096366
        struct[0].Gy_ini[182,174] = 67.7048070412999
        struct[0].Gy_ini[182,182] = -270.819228165200
        struct[0].Gy_ini[182,190] = 45.1365380275333
        struct[0].Gy_ini[183,57] = 157.977883096366
        struct[0].Gy_ini[183,175] = 67.7048070412999
        struct[0].Gy_ini[183,183] = -270.819228165200
        struct[0].Gy_ini[183,191] = 45.1365380275333
        struct[0].Gy_ini[184,176] = 67.7048070412999
        struct[0].Gy_ini[184,184] = -270.819228165200
        struct[0].Gy_ini[184,192] = 45.1365380275333
        struct[0].Gy_ini[184,210] = 157.977883096366
        struct[0].Gy_ini[185,177] = 67.7048070412999
        struct[0].Gy_ini[185,185] = -270.819228165200
        struct[0].Gy_ini[185,193] = 45.1365380275333
        struct[0].Gy_ini[185,211] = 157.977883096366
        struct[0].Gy_ini[186,178] = 67.7048070412999
        struct[0].Gy_ini[186,186] = -270.819228165200
        struct[0].Gy_ini[186,194] = 45.1365380275333
        struct[0].Gy_ini[186,212] = 157.977883096366
        struct[0].Gy_ini[187,179] = 67.7048070412999
        struct[0].Gy_ini[187,187] = -270.819228165200
        struct[0].Gy_ini[187,195] = 45.1365380275333
        struct[0].Gy_ini[187,213] = 157.977883096366
        struct[0].Gy_ini[188,58] = 157.977883096366
        struct[0].Gy_ini[188,180] = 67.7048070412999
        struct[0].Gy_ini[188,188] = -270.819228165200
        struct[0].Gy_ini[188,196] = 45.1365380275333
        struct[0].Gy_ini[189,59] = 157.977883096366
        struct[0].Gy_ini[189,181] = 67.7048070412999
        struct[0].Gy_ini[189,189] = -270.819228165200
        struct[0].Gy_ini[189,197] = 45.1365380275333
        struct[0].Gy_ini[190,60] = 157.977883096366
        struct[0].Gy_ini[190,182] = 45.1365380275333
        struct[0].Gy_ini[190,190] = -361.092304220266
        struct[0].Gy_ini[190,198] = 157.977883096366
        struct[0].Gy_ini[191,61] = 157.977883096366
        struct[0].Gy_ini[191,183] = 45.1365380275333
        struct[0].Gy_ini[191,191] = -361.092304220266
        struct[0].Gy_ini[191,199] = 157.977883096366
        struct[0].Gy_ini[192,184] = 45.1365380275333
        struct[0].Gy_ini[192,192] = -361.092304220266
        struct[0].Gy_ini[192,200] = 157.977883096366
        struct[0].Gy_ini[192,214] = 157.977883096366
        struct[0].Gy_ini[193,185] = 45.1365380275333
        struct[0].Gy_ini[193,193] = -361.092304220266
        struct[0].Gy_ini[193,201] = 157.977883096366
        struct[0].Gy_ini[193,215] = 157.977883096366
        struct[0].Gy_ini[194,186] = 45.1365380275333
        struct[0].Gy_ini[194,194] = -361.092304220266
        struct[0].Gy_ini[194,202] = 157.977883096366
        struct[0].Gy_ini[194,216] = 157.977883096366
        struct[0].Gy_ini[195,187] = 45.1365380275333
        struct[0].Gy_ini[195,195] = -361.092304220266
        struct[0].Gy_ini[195,203] = 157.977883096366
        struct[0].Gy_ini[195,217] = 157.977883096366
        struct[0].Gy_ini[196,62] = 157.977883096366
        struct[0].Gy_ini[196,188] = 45.1365380275333
        struct[0].Gy_ini[196,196] = -361.092304220266
        struct[0].Gy_ini[196,204] = 157.977883096366
        struct[0].Gy_ini[197,63] = 157.977883096366
        struct[0].Gy_ini[197,189] = 45.1365380275333
        struct[0].Gy_ini[197,197] = -361.092304220266
        struct[0].Gy_ini[197,205] = 157.977883096366
        struct[0].Gy_ini[198,64] = 157.977883096366
        struct[0].Gy_ini[198,190] = 157.977883096366
        struct[0].Gy_ini[198,198] = -315.955766192733
        struct[0].Gy_ini[198,419] = 1
        struct[0].Gy_ini[199,65] = 157.977883096366
        struct[0].Gy_ini[199,191] = 157.977883096366
        struct[0].Gy_ini[199,199] = -315.955766192733
        struct[0].Gy_ini[200,192] = 157.977883096366
        struct[0].Gy_ini[200,200] = -315.955766192733
        struct[0].Gy_ini[200,218] = 157.977883096366
        struct[0].Gy_ini[201,193] = 157.977883096366
        struct[0].Gy_ini[201,201] = -315.955766192733
        struct[0].Gy_ini[201,219] = 157.977883096366
        struct[0].Gy_ini[202,194] = 157.977883096366
        struct[0].Gy_ini[202,202] = -315.955766192733
        struct[0].Gy_ini[202,220] = 157.977883096366
        struct[0].Gy_ini[203,195] = 157.977883096366
        struct[0].Gy_ini[203,203] = -315.955766192733
        struct[0].Gy_ini[203,221] = 157.977883096366
        struct[0].Gy_ini[204,66] = 157.977883096366
        struct[0].Gy_ini[204,196] = 157.977883096366
        struct[0].Gy_ini[204,204] = -315.955766192733
        struct[0].Gy_ini[204,420] = 1
        struct[0].Gy_ini[205,67] = 157.977883096366
        struct[0].Gy_ini[205,197] = 157.977883096366
        struct[0].Gy_ini[205,205] = -315.955766192733
        struct[0].Gy_ini[206,168] = 157.977883096366
        struct[0].Gy_ini[206,206] = -157.977883096366
        struct[0].Gy_ini[207,169] = 157.977883096366
        struct[0].Gy_ini[207,207] = -157.977883096366
        struct[0].Gy_ini[208,170] = 157.977883096366
        struct[0].Gy_ini[208,208] = -157.977883096366
        struct[0].Gy_ini[209,171] = 157.977883096366
        struct[0].Gy_ini[209,209] = -157.977883096366
        struct[0].Gy_ini[210,184] = 157.977883096366
        struct[0].Gy_ini[210,210] = -157.977883096366
        struct[0].Gy_ini[211,185] = 157.977883096366
        struct[0].Gy_ini[211,211] = -157.977883096366
        struct[0].Gy_ini[212,186] = 157.977883096366
        struct[0].Gy_ini[212,212] = -157.977883096366
        struct[0].Gy_ini[213,187] = 157.977883096366
        struct[0].Gy_ini[213,213] = -157.977883096366
        struct[0].Gy_ini[214,192] = 157.977883096366
        struct[0].Gy_ini[214,214] = -157.977883096366
        struct[0].Gy_ini[215,193] = 157.977883096366
        struct[0].Gy_ini[215,215] = -157.977883096366
        struct[0].Gy_ini[216,194] = 157.977883096366
        struct[0].Gy_ini[216,216] = -157.977883096366
        struct[0].Gy_ini[217,195] = 157.977883096366
        struct[0].Gy_ini[217,217] = -157.977883096366
        struct[0].Gy_ini[218,200] = 157.977883096366
        struct[0].Gy_ini[218,218] = -157.977883096366
        struct[0].Gy_ini[219,201] = 157.977883096366
        struct[0].Gy_ini[219,219] = -157.977883096366
        struct[0].Gy_ini[220,202] = 157.977883096366
        struct[0].Gy_ini[220,220] = -157.977883096366
        struct[0].Gy_ini[221,203] = 157.977883096366
        struct[0].Gy_ini[221,221] = -157.977883096366
        struct[0].Gy_ini[222,48] = 135.409614082600
        struct[0].Gy_ini[222,174] = 45.1365380275333
        struct[0].Gy_ini[222,222] = -180.546152110133
        struct[0].Gy_ini[222,429] = 1
        struct[0].Gy_ini[223,49] = 135.409614082600
        struct[0].Gy_ini[223,175] = 45.1365380275333
        struct[0].Gy_ini[223,223] = -180.546152110133
        struct[0].Gy_ini[224,176] = 45.1365380275333
        struct[0].Gy_ini[224,224] = -180.546152110133
        struct[0].Gy_ini[224,230] = 135.409614082600
        struct[0].Gy_ini[225,177] = 45.1365380275333
        struct[0].Gy_ini[225,225] = -180.546152110133
        struct[0].Gy_ini[225,231] = 135.409614082600
        struct[0].Gy_ini[226,178] = 45.1365380275333
        struct[0].Gy_ini[226,226] = -180.546152110133
        struct[0].Gy_ini[226,232] = 135.409614082600
        struct[0].Gy_ini[227,179] = 45.1365380275333
        struct[0].Gy_ini[227,227] = -180.546152110133
        struct[0].Gy_ini[227,233] = 135.409614082600
        struct[0].Gy_ini[228,50] = 135.409614082600
        struct[0].Gy_ini[228,180] = 45.1365380275333
        struct[0].Gy_ini[228,228] = -180.546152110133
        struct[0].Gy_ini[228,430] = 1
        struct[0].Gy_ini[229,51] = 135.409614082600
        struct[0].Gy_ini[229,181] = 45.1365380275333
        struct[0].Gy_ini[229,229] = -180.546152110133
        struct[0].Gy_ini[230,224] = 135.409614082600
        struct[0].Gy_ini[230,230] = -135.409614082600
        struct[0].Gy_ini[231,225] = 135.409614082600
        struct[0].Gy_ini[231,231] = -135.409614082600
        struct[0].Gy_ini[232,226] = 135.409614082600
        struct[0].Gy_ini[232,232] = -135.409614082600
        struct[0].Gy_ini[233,227] = 135.409614082600
        struct[0].Gy_ini[233,233] = -135.409614082600
        struct[0].Gy_ini[234,0] = -0.212261128378539
        struct[0].Gy_ini[234,1] = -0.849044513514155
        struct[0].Gy_ini[234,2] = 0.212261128378539
        struct[0].Gy_ini[234,3] = 0.849044513514155
        struct[0].Gy_ini[234,234] = -1
        struct[0].Gy_ini[235,0] = 0.849044513514155
        struct[0].Gy_ini[235,1] = -0.212261128378539
        struct[0].Gy_ini[235,2] = -0.849044513514155
        struct[0].Gy_ini[235,3] = 0.212261128378539
        struct[0].Gy_ini[235,235] = -1
        struct[0].Gy_ini[236,2] = -0.212261128378539
        struct[0].Gy_ini[236,3] = -0.849044513514155
        struct[0].Gy_ini[236,4] = 0.212261128378539
        struct[0].Gy_ini[236,5] = 0.849044513514155
        struct[0].Gy_ini[236,236] = -1
        struct[0].Gy_ini[237,2] = 0.849044513514155
        struct[0].Gy_ini[237,3] = -0.212261128378539
        struct[0].Gy_ini[237,4] = -0.849044513514155
        struct[0].Gy_ini[237,5] = 0.212261128378539
        struct[0].Gy_ini[237,237] = -1
        struct[0].Gy_ini[238,0] = 0.212261128378539
        struct[0].Gy_ini[238,1] = 0.849044513514155
        struct[0].Gy_ini[238,4] = -0.212261128378539
        struct[0].Gy_ini[238,5] = -0.849044513514155
        struct[0].Gy_ini[238,238] = -1
        struct[0].Gy_ini[239,0] = -0.849044513514155
        struct[0].Gy_ini[239,1] = 0.212261128378539
        struct[0].Gy_ini[239,4] = 0.849044513514155
        struct[0].Gy_ini[239,5] = -0.212261128378539
        struct[0].Gy_ini[239,239] = -1
        struct[0].Gy_ini[240,0] = 105.571769313180
        struct[0].Gy_ini[240,1] = 54.0657727682604
        struct[0].Gy_ini[240,2] = -39.6392229058202
        struct[0].Gy_ini[240,3] = -10.2713736253513
        struct[0].Gy_ini[240,4] = -24.9575997948692
        struct[0].Gy_ini[240,5] = -23.2849644809540
        struct[0].Gy_ini[240,6] = -39.6392229058202
        struct[0].Gy_ini[240,7] = -10.2713736253513
        struct[0].Gy_ini[240,68] = -105.571769313180
        struct[0].Gy_ini[240,69] = -54.0657727682604
        struct[0].Gy_ini[240,70] = 39.6392229058202
        struct[0].Gy_ini[240,71] = 10.2713736253513
        struct[0].Gy_ini[240,72] = 24.9575997948692
        struct[0].Gy_ini[240,73] = 23.2849644809540
        struct[0].Gy_ini[240,74] = 39.6392229058202
        struct[0].Gy_ini[240,75] = 10.2713736253513
        struct[0].Gy_ini[240,240] = -1
        struct[0].Gy_ini[241,0] = -54.0657727682604
        struct[0].Gy_ini[241,1] = 105.571769313180
        struct[0].Gy_ini[241,2] = 10.2713736253513
        struct[0].Gy_ini[241,3] = -39.6392229058202
        struct[0].Gy_ini[241,4] = 23.2849644809540
        struct[0].Gy_ini[241,5] = -24.9575997948692
        struct[0].Gy_ini[241,6] = 10.2713736253513
        struct[0].Gy_ini[241,7] = -39.6392229058202
        struct[0].Gy_ini[241,68] = 54.0657727682604
        struct[0].Gy_ini[241,69] = -105.571769313180
        struct[0].Gy_ini[241,70] = -10.2713736253513
        struct[0].Gy_ini[241,71] = 39.6392229058202
        struct[0].Gy_ini[241,72] = -23.2849644809540
        struct[0].Gy_ini[241,73] = 24.9575997948692
        struct[0].Gy_ini[241,74] = -10.2713736253513
        struct[0].Gy_ini[241,75] = 39.6392229058202
        struct[0].Gy_ini[241,241] = -1
        struct[0].Gy_ini[242,0] = -39.6392229058202
        struct[0].Gy_ini[242,1] = -10.2713736253513
        struct[0].Gy_ini[242,2] = 105.571769313180
        struct[0].Gy_ini[242,3] = 54.0657727682604
        struct[0].Gy_ini[242,4] = -39.6392229058201
        struct[0].Gy_ini[242,5] = -10.2713736253513
        struct[0].Gy_ini[242,6] = -24.9575997948692
        struct[0].Gy_ini[242,7] = -23.2849644809540
        struct[0].Gy_ini[242,68] = 39.6392229058202
        struct[0].Gy_ini[242,69] = 10.2713736253513
        struct[0].Gy_ini[242,70] = -105.571769313180
        struct[0].Gy_ini[242,71] = -54.0657727682604
        struct[0].Gy_ini[242,72] = 39.6392229058201
        struct[0].Gy_ini[242,73] = 10.2713736253513
        struct[0].Gy_ini[242,74] = 24.9575997948692
        struct[0].Gy_ini[242,75] = 23.2849644809540
        struct[0].Gy_ini[242,242] = -1
        struct[0].Gy_ini[243,0] = 10.2713736253513
        struct[0].Gy_ini[243,1] = -39.6392229058202
        struct[0].Gy_ini[243,2] = -54.0657727682604
        struct[0].Gy_ini[243,3] = 105.571769313180
        struct[0].Gy_ini[243,4] = 10.2713736253513
        struct[0].Gy_ini[243,5] = -39.6392229058201
        struct[0].Gy_ini[243,6] = 23.2849644809540
        struct[0].Gy_ini[243,7] = -24.9575997948692
        struct[0].Gy_ini[243,68] = -10.2713736253513
        struct[0].Gy_ini[243,69] = 39.6392229058202
        struct[0].Gy_ini[243,70] = 54.0657727682604
        struct[0].Gy_ini[243,71] = -105.571769313180
        struct[0].Gy_ini[243,72] = -10.2713736253513
        struct[0].Gy_ini[243,73] = 39.6392229058201
        struct[0].Gy_ini[243,74] = -23.2849644809540
        struct[0].Gy_ini[243,75] = 24.9575997948692
        struct[0].Gy_ini[243,243] = -1
        struct[0].Gy_ini[244,0] = -24.9575997948692
        struct[0].Gy_ini[244,1] = -23.2849644809540
        struct[0].Gy_ini[244,2] = -39.6392229058202
        struct[0].Gy_ini[244,3] = -10.2713736253513
        struct[0].Gy_ini[244,4] = 105.571769313180
        struct[0].Gy_ini[244,5] = 54.0657727682604
        struct[0].Gy_ini[244,6] = -39.6392229058201
        struct[0].Gy_ini[244,7] = -10.2713736253514
        struct[0].Gy_ini[244,68] = 24.9575997948692
        struct[0].Gy_ini[244,69] = 23.2849644809540
        struct[0].Gy_ini[244,70] = 39.6392229058202
        struct[0].Gy_ini[244,71] = 10.2713736253513
        struct[0].Gy_ini[244,72] = -105.571769313180
        struct[0].Gy_ini[244,73] = -54.0657727682604
        struct[0].Gy_ini[244,74] = 39.6392229058201
        struct[0].Gy_ini[244,75] = 10.2713736253514
        struct[0].Gy_ini[244,244] = -1
        struct[0].Gy_ini[245,0] = 23.2849644809540
        struct[0].Gy_ini[245,1] = -24.9575997948692
        struct[0].Gy_ini[245,2] = 10.2713736253513
        struct[0].Gy_ini[245,3] = -39.6392229058202
        struct[0].Gy_ini[245,4] = -54.0657727682604
        struct[0].Gy_ini[245,5] = 105.571769313180
        struct[0].Gy_ini[245,6] = 10.2713736253514
        struct[0].Gy_ini[245,7] = -39.6392229058201
        struct[0].Gy_ini[245,68] = -23.2849644809540
        struct[0].Gy_ini[245,69] = 24.9575997948692
        struct[0].Gy_ini[245,70] = -10.2713736253513
        struct[0].Gy_ini[245,71] = 39.6392229058202
        struct[0].Gy_ini[245,72] = 54.0657727682604
        struct[0].Gy_ini[245,73] = -105.571769313180
        struct[0].Gy_ini[245,74] = -10.2713736253514
        struct[0].Gy_ini[245,75] = 39.6392229058201
        struct[0].Gy_ini[245,245] = -1
        struct[0].Gy_ini[246,240] = 1
        struct[0].Gy_ini[246,242] = 1
        struct[0].Gy_ini[246,244] = 1
        struct[0].Gy_ini[246,246] = -1
        struct[0].Gy_ini[247,241] = 1
        struct[0].Gy_ini[247,243] = 1
        struct[0].Gy_ini[247,245] = 1
        struct[0].Gy_ini[247,247] = -1
        struct[0].Gy_ini[248,166] = -67.7048070412999
        struct[0].Gy_ini[248,248] = -1
        struct[0].Gy_ini[249,167] = -67.7048070412999
        struct[0].Gy_ini[249,249] = -1
        struct[0].Gy_ini[250,168] = -67.7048070412999
        struct[0].Gy_ini[250,250] = -1
        struct[0].Gy_ini[251,169] = -67.7048070412999
        struct[0].Gy_ini[251,251] = -1
        struct[0].Gy_ini[252,170] = -67.7048070412999
        struct[0].Gy_ini[252,252] = -1
        struct[0].Gy_ini[253,171] = -67.7048070412999
        struct[0].Gy_ini[253,253] = -1
        struct[0].Gy_ini[254,248] = 1
        struct[0].Gy_ini[254,250] = 1
        struct[0].Gy_ini[254,252] = 1
        struct[0].Gy_ini[254,254] = -1
        struct[0].Gy_ini[255,249] = 1
        struct[0].Gy_ini[255,251] = 1
        struct[0].Gy_ini[255,253] = 1
        struct[0].Gy_ini[255,255] = -1
        struct[0].Gy_ini[256,166] = 135.409614082600
        struct[0].Gy_ini[256,174] = -135.409614082600
        struct[0].Gy_ini[256,256] = -1
        struct[0].Gy_ini[257,167] = 135.409614082600
        struct[0].Gy_ini[257,175] = -135.409614082600
        struct[0].Gy_ini[257,257] = -1
        struct[0].Gy_ini[258,168] = 135.409614082600
        struct[0].Gy_ini[258,176] = -135.409614082600
        struct[0].Gy_ini[258,258] = -1
        struct[0].Gy_ini[259,169] = 135.409614082600
        struct[0].Gy_ini[259,177] = -135.409614082600
        struct[0].Gy_ini[259,259] = -1
        struct[0].Gy_ini[260,170] = 135.409614082600
        struct[0].Gy_ini[260,178] = -135.409614082600
        struct[0].Gy_ini[260,260] = -1
        struct[0].Gy_ini[261,171] = 135.409614082600
        struct[0].Gy_ini[261,179] = -135.409614082600
        struct[0].Gy_ini[261,261] = -1
        struct[0].Gy_ini[262,256] = 1
        struct[0].Gy_ini[262,258] = 1
        struct[0].Gy_ini[262,260] = 1
        struct[0].Gy_ini[262,262] = -1
        struct[0].Gy_ini[263,257] = 1
        struct[0].Gy_ini[263,259] = 1
        struct[0].Gy_ini[263,261] = 1
        struct[0].Gy_ini[263,263] = -1
        struct[0].Gy_ini[264,174] = 67.7048070412999
        struct[0].Gy_ini[264,182] = -67.7048070412999
        struct[0].Gy_ini[264,264] = -1
        struct[0].Gy_ini[265,175] = 67.7048070412999
        struct[0].Gy_ini[265,183] = -67.7048070412999
        struct[0].Gy_ini[265,265] = -1
        struct[0].Gy_ini[266,176] = 67.7048070412999
        struct[0].Gy_ini[266,184] = -67.7048070412999
        struct[0].Gy_ini[266,266] = -1
        struct[0].Gy_ini[267,177] = 67.7048070412999
        struct[0].Gy_ini[267,185] = -67.7048070412999
        struct[0].Gy_ini[267,267] = -1
        struct[0].Gy_ini[268,178] = 67.7048070412999
        struct[0].Gy_ini[268,186] = -67.7048070412999
        struct[0].Gy_ini[268,268] = -1
        struct[0].Gy_ini[269,179] = 67.7048070412999
        struct[0].Gy_ini[269,187] = -67.7048070412999
        struct[0].Gy_ini[269,269] = -1
        struct[0].Gy_ini[270,264] = 1
        struct[0].Gy_ini[270,266] = 1
        struct[0].Gy_ini[270,268] = 1
        struct[0].Gy_ini[270,270] = -1
        struct[0].Gy_ini[271,265] = 1
        struct[0].Gy_ini[271,267] = 1
        struct[0].Gy_ini[271,269] = 1
        struct[0].Gy_ini[271,271] = -1
        struct[0].Gy_ini[272,182] = 45.1365380275333
        struct[0].Gy_ini[272,190] = -45.1365380275333
        struct[0].Gy_ini[272,272] = -1
        struct[0].Gy_ini[273,183] = 45.1365380275333
        struct[0].Gy_ini[273,191] = -45.1365380275333
        struct[0].Gy_ini[273,273] = -1
        struct[0].Gy_ini[274,184] = 45.1365380275333
        struct[0].Gy_ini[274,192] = -45.1365380275333
        struct[0].Gy_ini[274,274] = -1
        struct[0].Gy_ini[275,185] = 45.1365380275333
        struct[0].Gy_ini[275,193] = -45.1365380275333
        struct[0].Gy_ini[275,275] = -1
        struct[0].Gy_ini[276,186] = 45.1365380275333
        struct[0].Gy_ini[276,194] = -45.1365380275333
        struct[0].Gy_ini[276,276] = -1
        struct[0].Gy_ini[277,187] = 45.1365380275333
        struct[0].Gy_ini[277,195] = -45.1365380275333
        struct[0].Gy_ini[277,277] = -1
        struct[0].Gy_ini[278,272] = 1
        struct[0].Gy_ini[278,274] = 1
        struct[0].Gy_ini[278,276] = 1
        struct[0].Gy_ini[278,278] = -1
        struct[0].Gy_ini[279,273] = 1
        struct[0].Gy_ini[279,275] = 1
        struct[0].Gy_ini[279,277] = 1
        struct[0].Gy_ini[279,279] = -1
        struct[0].Gy_ini[280,190] = 157.977883096366
        struct[0].Gy_ini[280,198] = -157.977883096366
        struct[0].Gy_ini[280,280] = -1
        struct[0].Gy_ini[281,191] = 157.977883096366
        struct[0].Gy_ini[281,199] = -157.977883096366
        struct[0].Gy_ini[281,281] = -1
        struct[0].Gy_ini[282,192] = 157.977883096366
        struct[0].Gy_ini[282,200] = -157.977883096366
        struct[0].Gy_ini[282,282] = -1
        struct[0].Gy_ini[283,193] = 157.977883096366
        struct[0].Gy_ini[283,201] = -157.977883096366
        struct[0].Gy_ini[283,283] = -1
        struct[0].Gy_ini[284,194] = 157.977883096366
        struct[0].Gy_ini[284,202] = -157.977883096366
        struct[0].Gy_ini[284,284] = -1
        struct[0].Gy_ini[285,195] = 157.977883096366
        struct[0].Gy_ini[285,203] = -157.977883096366
        struct[0].Gy_ini[285,285] = -1
        struct[0].Gy_ini[286,280] = 1
        struct[0].Gy_ini[286,282] = 1
        struct[0].Gy_ini[286,284] = 1
        struct[0].Gy_ini[286,286] = -1
        struct[0].Gy_ini[287,281] = 1
        struct[0].Gy_ini[287,283] = 1
        struct[0].Gy_ini[287,285] = 1
        struct[0].Gy_ini[287,287] = -1
        struct[0].Gy_ini[288,52] = -157.977883096366
        struct[0].Gy_ini[288,166] = 157.977883096366
        struct[0].Gy_ini[288,288] = -1
        struct[0].Gy_ini[289,53] = -157.977883096366
        struct[0].Gy_ini[289,167] = 157.977883096366
        struct[0].Gy_ini[289,289] = -1
        struct[0].Gy_ini[290,168] = 157.977883096366
        struct[0].Gy_ini[290,206] = -157.977883096366
        struct[0].Gy_ini[290,290] = -1
        struct[0].Gy_ini[291,169] = 157.977883096366
        struct[0].Gy_ini[291,207] = -157.977883096366
        struct[0].Gy_ini[291,291] = -1
        struct[0].Gy_ini[292,170] = 157.977883096366
        struct[0].Gy_ini[292,208] = -157.977883096366
        struct[0].Gy_ini[292,292] = -1
        struct[0].Gy_ini[293,171] = 157.977883096366
        struct[0].Gy_ini[293,209] = -157.977883096366
        struct[0].Gy_ini[293,293] = -1
        struct[0].Gy_ini[294,288] = 1
        struct[0].Gy_ini[294,290] = 1
        struct[0].Gy_ini[294,292] = 1
        struct[0].Gy_ini[294,294] = -1
        struct[0].Gy_ini[295,289] = 1
        struct[0].Gy_ini[295,291] = 1
        struct[0].Gy_ini[295,293] = 1
        struct[0].Gy_ini[295,295] = -1
        struct[0].Gy_ini[296,56] = -157.977883096366
        struct[0].Gy_ini[296,182] = 157.977883096366
        struct[0].Gy_ini[296,296] = -1
        struct[0].Gy_ini[297,57] = -157.977883096366
        struct[0].Gy_ini[297,183] = 157.977883096366
        struct[0].Gy_ini[297,297] = -1
        struct[0].Gy_ini[298,184] = 157.977883096366
        struct[0].Gy_ini[298,210] = -157.977883096366
        struct[0].Gy_ini[298,298] = -1
        struct[0].Gy_ini[299,185] = 157.977883096366
        struct[0].Gy_ini[299,211] = -157.977883096366
        struct[0].Gy_ini[299,299] = -1
        struct[0].Gy_ini[300,186] = 157.977883096366
        struct[0].Gy_ini[300,212] = -157.977883096366
        struct[0].Gy_ini[300,300] = -1
        struct[0].Gy_ini[301,187] = 157.977883096366
        struct[0].Gy_ini[301,213] = -157.977883096366
        struct[0].Gy_ini[301,301] = -1
        struct[0].Gy_ini[302,296] = 1
        struct[0].Gy_ini[302,298] = 1
        struct[0].Gy_ini[302,300] = 1
        struct[0].Gy_ini[302,302] = -1
        struct[0].Gy_ini[303,297] = 1
        struct[0].Gy_ini[303,299] = 1
        struct[0].Gy_ini[303,301] = 1
        struct[0].Gy_ini[303,303] = -1
        struct[0].Gy_ini[304,60] = -157.977883096366
        struct[0].Gy_ini[304,190] = 157.977883096366
        struct[0].Gy_ini[304,304] = -1
        struct[0].Gy_ini[305,61] = -157.977883096366
        struct[0].Gy_ini[305,191] = 157.977883096366
        struct[0].Gy_ini[305,305] = -1
        struct[0].Gy_ini[306,192] = 157.977883096366
        struct[0].Gy_ini[306,214] = -157.977883096366
        struct[0].Gy_ini[306,306] = -1
        struct[0].Gy_ini[307,193] = 157.977883096366
        struct[0].Gy_ini[307,215] = -157.977883096366
        struct[0].Gy_ini[307,307] = -1
        struct[0].Gy_ini[308,194] = 157.977883096366
        struct[0].Gy_ini[308,216] = -157.977883096366
        struct[0].Gy_ini[308,308] = -1
        struct[0].Gy_ini[309,195] = 157.977883096366
        struct[0].Gy_ini[309,217] = -157.977883096366
        struct[0].Gy_ini[309,309] = -1
        struct[0].Gy_ini[310,304] = 1
        struct[0].Gy_ini[310,306] = 1
        struct[0].Gy_ini[310,308] = 1
        struct[0].Gy_ini[310,310] = -1
        struct[0].Gy_ini[311,305] = 1
        struct[0].Gy_ini[311,307] = 1
        struct[0].Gy_ini[311,309] = 1
        struct[0].Gy_ini[311,311] = -1
        struct[0].Gy_ini[312,64] = -157.977883096366
        struct[0].Gy_ini[312,198] = 157.977883096366
        struct[0].Gy_ini[312,312] = -1
        struct[0].Gy_ini[313,65] = -157.977883096366
        struct[0].Gy_ini[313,199] = 157.977883096366
        struct[0].Gy_ini[313,313] = -1
        struct[0].Gy_ini[314,200] = 157.977883096366
        struct[0].Gy_ini[314,218] = -157.977883096366
        struct[0].Gy_ini[314,314] = -1
        struct[0].Gy_ini[315,201] = 157.977883096366
        struct[0].Gy_ini[315,219] = -157.977883096366
        struct[0].Gy_ini[315,315] = -1
        struct[0].Gy_ini[316,202] = 157.977883096366
        struct[0].Gy_ini[316,220] = -157.977883096366
        struct[0].Gy_ini[316,316] = -1
        struct[0].Gy_ini[317,203] = 157.977883096366
        struct[0].Gy_ini[317,221] = -157.977883096366
        struct[0].Gy_ini[317,317] = -1
        struct[0].Gy_ini[318,312] = 1
        struct[0].Gy_ini[318,314] = 1
        struct[0].Gy_ini[318,316] = 1
        struct[0].Gy_ini[318,318] = -1
        struct[0].Gy_ini[319,313] = 1
        struct[0].Gy_ini[319,315] = 1
        struct[0].Gy_ini[319,317] = 1
        struct[0].Gy_ini[319,319] = -1
        struct[0].Gy_ini[320,174] = 45.1365380275333
        struct[0].Gy_ini[320,222] = -45.1365380275333
        struct[0].Gy_ini[320,320] = -1
        struct[0].Gy_ini[321,175] = 45.1365380275333
        struct[0].Gy_ini[321,223] = -45.1365380275333
        struct[0].Gy_ini[321,321] = -1
        struct[0].Gy_ini[322,176] = 45.1365380275333
        struct[0].Gy_ini[322,224] = -45.1365380275333
        struct[0].Gy_ini[322,322] = -1
        struct[0].Gy_ini[323,177] = 45.1365380275333
        struct[0].Gy_ini[323,225] = -45.1365380275333
        struct[0].Gy_ini[323,323] = -1
        struct[0].Gy_ini[324,178] = 45.1365380275333
        struct[0].Gy_ini[324,226] = -45.1365380275333
        struct[0].Gy_ini[324,324] = -1
        struct[0].Gy_ini[325,179] = 45.1365380275333
        struct[0].Gy_ini[325,227] = -45.1365380275333
        struct[0].Gy_ini[325,325] = -1
        struct[0].Gy_ini[326,320] = 1
        struct[0].Gy_ini[326,322] = 1
        struct[0].Gy_ini[326,324] = 1
        struct[0].Gy_ini[326,326] = -1
        struct[0].Gy_ini[327,321] = 1
        struct[0].Gy_ini[327,323] = 1
        struct[0].Gy_ini[327,325] = 1
        struct[0].Gy_ini[327,327] = -1
        struct[0].Gy_ini[328,48] = -135.409614082600
        struct[0].Gy_ini[328,222] = 135.409614082600
        struct[0].Gy_ini[328,328] = -1
        struct[0].Gy_ini[329,49] = -135.409614082600
        struct[0].Gy_ini[329,223] = 135.409614082600
        struct[0].Gy_ini[329,329] = -1
        struct[0].Gy_ini[330,224] = 135.409614082600
        struct[0].Gy_ini[330,230] = -135.409614082600
        struct[0].Gy_ini[330,330] = -1
        struct[0].Gy_ini[331,225] = 135.409614082600
        struct[0].Gy_ini[331,231] = -135.409614082600
        struct[0].Gy_ini[331,331] = -1
        struct[0].Gy_ini[332,226] = 135.409614082600
        struct[0].Gy_ini[332,232] = -135.409614082600
        struct[0].Gy_ini[332,332] = -1
        struct[0].Gy_ini[333,227] = 135.409614082600
        struct[0].Gy_ini[333,233] = -135.409614082600
        struct[0].Gy_ini[333,333] = -1
        struct[0].Gy_ini[334,328] = 1
        struct[0].Gy_ini[334,330] = 1
        struct[0].Gy_ini[334,332] = 1
        struct[0].Gy_ini[334,334] = -1
        struct[0].Gy_ini[335,329] = 1
        struct[0].Gy_ini[335,331] = 1
        struct[0].Gy_ini[335,333] = 1
        struct[0].Gy_ini[335,335] = -1
        struct[0].Gy_ini[336,0] = i_load_R1_a_r
        struct[0].Gy_ini[336,1] = i_load_R1_a_i
        struct[0].Gy_ini[336,6] = -i_load_R1_a_r
        struct[0].Gy_ini[336,7] = -i_load_R1_a_i
        struct[0].Gy_ini[336,336] = v_R1_a_r - v_R1_n_r
        struct[0].Gy_ini[336,337] = v_R1_a_i - v_R1_n_i
        struct[0].Gy_ini[337,2] = i_load_R1_b_r
        struct[0].Gy_ini[337,3] = i_load_R1_b_i
        struct[0].Gy_ini[337,6] = -i_load_R1_b_r
        struct[0].Gy_ini[337,7] = -i_load_R1_b_i
        struct[0].Gy_ini[337,338] = v_R1_b_r - v_R1_n_r
        struct[0].Gy_ini[337,339] = v_R1_b_i - v_R1_n_i
        struct[0].Gy_ini[338,4] = i_load_R1_c_r
        struct[0].Gy_ini[338,5] = i_load_R1_c_i
        struct[0].Gy_ini[338,6] = -i_load_R1_c_r
        struct[0].Gy_ini[338,7] = -i_load_R1_c_i
        struct[0].Gy_ini[338,340] = v_R1_c_r - v_R1_n_r
        struct[0].Gy_ini[338,341] = v_R1_c_i - v_R1_n_i
        struct[0].Gy_ini[339,0] = -i_load_R1_a_i
        struct[0].Gy_ini[339,1] = i_load_R1_a_r
        struct[0].Gy_ini[339,6] = i_load_R1_a_i
        struct[0].Gy_ini[339,7] = -i_load_R1_a_r
        struct[0].Gy_ini[339,336] = v_R1_a_i - v_R1_n_i
        struct[0].Gy_ini[339,337] = -v_R1_a_r + v_R1_n_r
        struct[0].Gy_ini[340,2] = -i_load_R1_b_i
        struct[0].Gy_ini[340,3] = i_load_R1_b_r
        struct[0].Gy_ini[340,6] = i_load_R1_b_i
        struct[0].Gy_ini[340,7] = -i_load_R1_b_r
        struct[0].Gy_ini[340,338] = v_R1_b_i - v_R1_n_i
        struct[0].Gy_ini[340,339] = -v_R1_b_r + v_R1_n_r
        struct[0].Gy_ini[341,4] = -i_load_R1_c_i
        struct[0].Gy_ini[341,5] = i_load_R1_c_r
        struct[0].Gy_ini[341,6] = i_load_R1_c_i
        struct[0].Gy_ini[341,7] = -i_load_R1_c_r
        struct[0].Gy_ini[341,340] = v_R1_c_i - v_R1_n_i
        struct[0].Gy_ini[341,341] = -v_R1_c_r + v_R1_n_r
        struct[0].Gy_ini[342,336] = 1
        struct[0].Gy_ini[342,338] = 1
        struct[0].Gy_ini[342,340] = 1
        struct[0].Gy_ini[342,342] = 1
        struct[0].Gy_ini[343,337] = 1
        struct[0].Gy_ini[343,339] = 1
        struct[0].Gy_ini[343,341] = 1
        struct[0].Gy_ini[343,343] = 1
        struct[0].Gy_ini[344,8] = i_load_R11_a_r
        struct[0].Gy_ini[344,9] = i_load_R11_a_i
        struct[0].Gy_ini[344,14] = -i_load_R11_a_r
        struct[0].Gy_ini[344,15] = -i_load_R11_a_i
        struct[0].Gy_ini[344,344] = v_R11_a_r - v_R11_n_r
        struct[0].Gy_ini[344,345] = v_R11_a_i - v_R11_n_i
        struct[0].Gy_ini[345,10] = i_load_R11_b_r
        struct[0].Gy_ini[345,11] = i_load_R11_b_i
        struct[0].Gy_ini[345,14] = -i_load_R11_b_r
        struct[0].Gy_ini[345,15] = -i_load_R11_b_i
        struct[0].Gy_ini[345,346] = v_R11_b_r - v_R11_n_r
        struct[0].Gy_ini[345,347] = v_R11_b_i - v_R11_n_i
        struct[0].Gy_ini[346,12] = i_load_R11_c_r
        struct[0].Gy_ini[346,13] = i_load_R11_c_i
        struct[0].Gy_ini[346,14] = -i_load_R11_c_r
        struct[0].Gy_ini[346,15] = -i_load_R11_c_i
        struct[0].Gy_ini[346,348] = v_R11_c_r - v_R11_n_r
        struct[0].Gy_ini[346,349] = v_R11_c_i - v_R11_n_i
        struct[0].Gy_ini[347,8] = -i_load_R11_a_i
        struct[0].Gy_ini[347,9] = i_load_R11_a_r
        struct[0].Gy_ini[347,14] = i_load_R11_a_i
        struct[0].Gy_ini[347,15] = -i_load_R11_a_r
        struct[0].Gy_ini[347,344] = v_R11_a_i - v_R11_n_i
        struct[0].Gy_ini[347,345] = -v_R11_a_r + v_R11_n_r
        struct[0].Gy_ini[348,10] = -i_load_R11_b_i
        struct[0].Gy_ini[348,11] = i_load_R11_b_r
        struct[0].Gy_ini[348,14] = i_load_R11_b_i
        struct[0].Gy_ini[348,15] = -i_load_R11_b_r
        struct[0].Gy_ini[348,346] = v_R11_b_i - v_R11_n_i
        struct[0].Gy_ini[348,347] = -v_R11_b_r + v_R11_n_r
        struct[0].Gy_ini[349,12] = -i_load_R11_c_i
        struct[0].Gy_ini[349,13] = i_load_R11_c_r
        struct[0].Gy_ini[349,14] = i_load_R11_c_i
        struct[0].Gy_ini[349,15] = -i_load_R11_c_r
        struct[0].Gy_ini[349,348] = v_R11_c_i - v_R11_n_i
        struct[0].Gy_ini[349,349] = -v_R11_c_r + v_R11_n_r
        struct[0].Gy_ini[350,344] = 1
        struct[0].Gy_ini[350,346] = 1
        struct[0].Gy_ini[350,348] = 1
        struct[0].Gy_ini[350,350] = 1
        struct[0].Gy_ini[351,345] = 1
        struct[0].Gy_ini[351,347] = 1
        struct[0].Gy_ini[351,349] = 1
        struct[0].Gy_ini[351,351] = 1
        struct[0].Gy_ini[352,16] = i_load_R15_a_r
        struct[0].Gy_ini[352,17] = i_load_R15_a_i
        struct[0].Gy_ini[352,22] = -i_load_R15_a_r
        struct[0].Gy_ini[352,23] = -i_load_R15_a_i
        struct[0].Gy_ini[352,352] = v_R15_a_r - v_R15_n_r
        struct[0].Gy_ini[352,353] = v_R15_a_i - v_R15_n_i
        struct[0].Gy_ini[353,18] = i_load_R15_b_r
        struct[0].Gy_ini[353,19] = i_load_R15_b_i
        struct[0].Gy_ini[353,22] = -i_load_R15_b_r
        struct[0].Gy_ini[353,23] = -i_load_R15_b_i
        struct[0].Gy_ini[353,354] = v_R15_b_r - v_R15_n_r
        struct[0].Gy_ini[353,355] = v_R15_b_i - v_R15_n_i
        struct[0].Gy_ini[354,20] = i_load_R15_c_r
        struct[0].Gy_ini[354,21] = i_load_R15_c_i
        struct[0].Gy_ini[354,22] = -i_load_R15_c_r
        struct[0].Gy_ini[354,23] = -i_load_R15_c_i
        struct[0].Gy_ini[354,356] = v_R15_c_r - v_R15_n_r
        struct[0].Gy_ini[354,357] = v_R15_c_i - v_R15_n_i
        struct[0].Gy_ini[355,16] = -i_load_R15_a_i
        struct[0].Gy_ini[355,17] = i_load_R15_a_r
        struct[0].Gy_ini[355,22] = i_load_R15_a_i
        struct[0].Gy_ini[355,23] = -i_load_R15_a_r
        struct[0].Gy_ini[355,352] = v_R15_a_i - v_R15_n_i
        struct[0].Gy_ini[355,353] = -v_R15_a_r + v_R15_n_r
        struct[0].Gy_ini[356,18] = -i_load_R15_b_i
        struct[0].Gy_ini[356,19] = i_load_R15_b_r
        struct[0].Gy_ini[356,22] = i_load_R15_b_i
        struct[0].Gy_ini[356,23] = -i_load_R15_b_r
        struct[0].Gy_ini[356,354] = v_R15_b_i - v_R15_n_i
        struct[0].Gy_ini[356,355] = -v_R15_b_r + v_R15_n_r
        struct[0].Gy_ini[357,20] = -i_load_R15_c_i
        struct[0].Gy_ini[357,21] = i_load_R15_c_r
        struct[0].Gy_ini[357,22] = i_load_R15_c_i
        struct[0].Gy_ini[357,23] = -i_load_R15_c_r
        struct[0].Gy_ini[357,356] = v_R15_c_i - v_R15_n_i
        struct[0].Gy_ini[357,357] = -v_R15_c_r + v_R15_n_r
        struct[0].Gy_ini[358,352] = 1
        struct[0].Gy_ini[358,354] = 1
        struct[0].Gy_ini[358,356] = 1
        struct[0].Gy_ini[358,358] = 1
        struct[0].Gy_ini[359,353] = 1
        struct[0].Gy_ini[359,355] = 1
        struct[0].Gy_ini[359,357] = 1
        struct[0].Gy_ini[359,359] = 1
        struct[0].Gy_ini[360,24] = i_load_R16_a_r
        struct[0].Gy_ini[360,25] = i_load_R16_a_i
        struct[0].Gy_ini[360,30] = -i_load_R16_a_r
        struct[0].Gy_ini[360,31] = -i_load_R16_a_i
        struct[0].Gy_ini[360,360] = v_R16_a_r - v_R16_n_r
        struct[0].Gy_ini[360,361] = v_R16_a_i - v_R16_n_i
        struct[0].Gy_ini[361,26] = i_load_R16_b_r
        struct[0].Gy_ini[361,27] = i_load_R16_b_i
        struct[0].Gy_ini[361,30] = -i_load_R16_b_r
        struct[0].Gy_ini[361,31] = -i_load_R16_b_i
        struct[0].Gy_ini[361,362] = v_R16_b_r - v_R16_n_r
        struct[0].Gy_ini[361,363] = v_R16_b_i - v_R16_n_i
        struct[0].Gy_ini[362,28] = i_load_R16_c_r
        struct[0].Gy_ini[362,29] = i_load_R16_c_i
        struct[0].Gy_ini[362,30] = -i_load_R16_c_r
        struct[0].Gy_ini[362,31] = -i_load_R16_c_i
        struct[0].Gy_ini[362,364] = v_R16_c_r - v_R16_n_r
        struct[0].Gy_ini[362,365] = v_R16_c_i - v_R16_n_i
        struct[0].Gy_ini[363,24] = -i_load_R16_a_i
        struct[0].Gy_ini[363,25] = i_load_R16_a_r
        struct[0].Gy_ini[363,30] = i_load_R16_a_i
        struct[0].Gy_ini[363,31] = -i_load_R16_a_r
        struct[0].Gy_ini[363,360] = v_R16_a_i - v_R16_n_i
        struct[0].Gy_ini[363,361] = -v_R16_a_r + v_R16_n_r
        struct[0].Gy_ini[364,26] = -i_load_R16_b_i
        struct[0].Gy_ini[364,27] = i_load_R16_b_r
        struct[0].Gy_ini[364,30] = i_load_R16_b_i
        struct[0].Gy_ini[364,31] = -i_load_R16_b_r
        struct[0].Gy_ini[364,362] = v_R16_b_i - v_R16_n_i
        struct[0].Gy_ini[364,363] = -v_R16_b_r + v_R16_n_r
        struct[0].Gy_ini[365,28] = -i_load_R16_c_i
        struct[0].Gy_ini[365,29] = i_load_R16_c_r
        struct[0].Gy_ini[365,30] = i_load_R16_c_i
        struct[0].Gy_ini[365,31] = -i_load_R16_c_r
        struct[0].Gy_ini[365,364] = v_R16_c_i - v_R16_n_i
        struct[0].Gy_ini[365,365] = -v_R16_c_r + v_R16_n_r
        struct[0].Gy_ini[366,360] = 1
        struct[0].Gy_ini[366,362] = 1
        struct[0].Gy_ini[366,364] = 1
        struct[0].Gy_ini[366,366] = 1
        struct[0].Gy_ini[367,361] = 1
        struct[0].Gy_ini[367,363] = 1
        struct[0].Gy_ini[367,365] = 1
        struct[0].Gy_ini[367,367] = 1
        struct[0].Gy_ini[368,32] = i_load_R17_a_r
        struct[0].Gy_ini[368,33] = i_load_R17_a_i
        struct[0].Gy_ini[368,38] = -i_load_R17_a_r
        struct[0].Gy_ini[368,39] = -i_load_R17_a_i
        struct[0].Gy_ini[368,368] = v_R17_a_r - v_R17_n_r
        struct[0].Gy_ini[368,369] = v_R17_a_i - v_R17_n_i
        struct[0].Gy_ini[369,34] = i_load_R17_b_r
        struct[0].Gy_ini[369,35] = i_load_R17_b_i
        struct[0].Gy_ini[369,38] = -i_load_R17_b_r
        struct[0].Gy_ini[369,39] = -i_load_R17_b_i
        struct[0].Gy_ini[369,370] = v_R17_b_r - v_R17_n_r
        struct[0].Gy_ini[369,371] = v_R17_b_i - v_R17_n_i
        struct[0].Gy_ini[370,36] = i_load_R17_c_r
        struct[0].Gy_ini[370,37] = i_load_R17_c_i
        struct[0].Gy_ini[370,38] = -i_load_R17_c_r
        struct[0].Gy_ini[370,39] = -i_load_R17_c_i
        struct[0].Gy_ini[370,372] = v_R17_c_r - v_R17_n_r
        struct[0].Gy_ini[370,373] = v_R17_c_i - v_R17_n_i
        struct[0].Gy_ini[371,32] = -i_load_R17_a_i
        struct[0].Gy_ini[371,33] = i_load_R17_a_r
        struct[0].Gy_ini[371,38] = i_load_R17_a_i
        struct[0].Gy_ini[371,39] = -i_load_R17_a_r
        struct[0].Gy_ini[371,368] = v_R17_a_i - v_R17_n_i
        struct[0].Gy_ini[371,369] = -v_R17_a_r + v_R17_n_r
        struct[0].Gy_ini[372,34] = -i_load_R17_b_i
        struct[0].Gy_ini[372,35] = i_load_R17_b_r
        struct[0].Gy_ini[372,38] = i_load_R17_b_i
        struct[0].Gy_ini[372,39] = -i_load_R17_b_r
        struct[0].Gy_ini[372,370] = v_R17_b_i - v_R17_n_i
        struct[0].Gy_ini[372,371] = -v_R17_b_r + v_R17_n_r
        struct[0].Gy_ini[373,36] = -i_load_R17_c_i
        struct[0].Gy_ini[373,37] = i_load_R17_c_r
        struct[0].Gy_ini[373,38] = i_load_R17_c_i
        struct[0].Gy_ini[373,39] = -i_load_R17_c_r
        struct[0].Gy_ini[373,372] = v_R17_c_i - v_R17_n_i
        struct[0].Gy_ini[373,373] = -v_R17_c_r + v_R17_n_r
        struct[0].Gy_ini[374,368] = 1
        struct[0].Gy_ini[374,370] = 1
        struct[0].Gy_ini[374,372] = 1
        struct[0].Gy_ini[374,374] = 1
        struct[0].Gy_ini[375,369] = 1
        struct[0].Gy_ini[375,371] = 1
        struct[0].Gy_ini[375,373] = 1
        struct[0].Gy_ini[375,375] = 1
        struct[0].Gy_ini[376,40] = i_load_R18_a_r
        struct[0].Gy_ini[376,41] = i_load_R18_a_i
        struct[0].Gy_ini[376,46] = -i_load_R18_a_r
        struct[0].Gy_ini[376,47] = -i_load_R18_a_i
        struct[0].Gy_ini[376,376] = v_R18_a_r - v_R18_n_r
        struct[0].Gy_ini[376,377] = v_R18_a_i - v_R18_n_i
        struct[0].Gy_ini[377,42] = i_load_R18_b_r
        struct[0].Gy_ini[377,43] = i_load_R18_b_i
        struct[0].Gy_ini[377,46] = -i_load_R18_b_r
        struct[0].Gy_ini[377,47] = -i_load_R18_b_i
        struct[0].Gy_ini[377,378] = v_R18_b_r - v_R18_n_r
        struct[0].Gy_ini[377,379] = v_R18_b_i - v_R18_n_i
        struct[0].Gy_ini[378,44] = i_load_R18_c_r
        struct[0].Gy_ini[378,45] = i_load_R18_c_i
        struct[0].Gy_ini[378,46] = -i_load_R18_c_r
        struct[0].Gy_ini[378,47] = -i_load_R18_c_i
        struct[0].Gy_ini[378,380] = v_R18_c_r - v_R18_n_r
        struct[0].Gy_ini[378,381] = v_R18_c_i - v_R18_n_i
        struct[0].Gy_ini[379,40] = -i_load_R18_a_i
        struct[0].Gy_ini[379,41] = i_load_R18_a_r
        struct[0].Gy_ini[379,46] = i_load_R18_a_i
        struct[0].Gy_ini[379,47] = -i_load_R18_a_r
        struct[0].Gy_ini[379,376] = v_R18_a_i - v_R18_n_i
        struct[0].Gy_ini[379,377] = -v_R18_a_r + v_R18_n_r
        struct[0].Gy_ini[380,42] = -i_load_R18_b_i
        struct[0].Gy_ini[380,43] = i_load_R18_b_r
        struct[0].Gy_ini[380,46] = i_load_R18_b_i
        struct[0].Gy_ini[380,47] = -i_load_R18_b_r
        struct[0].Gy_ini[380,378] = v_R18_b_i - v_R18_n_i
        struct[0].Gy_ini[380,379] = -v_R18_b_r + v_R18_n_r
        struct[0].Gy_ini[381,44] = -i_load_R18_c_i
        struct[0].Gy_ini[381,45] = i_load_R18_c_r
        struct[0].Gy_ini[381,46] = i_load_R18_c_i
        struct[0].Gy_ini[381,47] = -i_load_R18_c_r
        struct[0].Gy_ini[381,380] = v_R18_c_i - v_R18_n_i
        struct[0].Gy_ini[381,381] = -v_R18_c_r + v_R18_n_r
        struct[0].Gy_ini[382,376] = 1
        struct[0].Gy_ini[382,378] = 1
        struct[0].Gy_ini[382,380] = 1
        struct[0].Gy_ini[382,382] = 1
        struct[0].Gy_ini[383,377] = 1
        struct[0].Gy_ini[383,379] = 1
        struct[0].Gy_ini[383,381] = 1
        struct[0].Gy_ini[383,383] = 1
        struct[0].Gy_ini[384,48] = i_load_D15_a_r
        struct[0].Gy_ini[384,49] = 1.0*i_load_D15_a_i
        struct[0].Gy_ini[384,50] = -i_load_D15_a_r
        struct[0].Gy_ini[384,51] = -1.0*i_load_D15_a_i
        struct[0].Gy_ini[384,384] = v_D15_a_r - v_D15_n_r
        struct[0].Gy_ini[384,385] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy_ini[385,48] = -1.0*i_load_D15_a_i
        struct[0].Gy_ini[385,49] = 1.0*i_load_D15_a_r
        struct[0].Gy_ini[385,50] = 1.0*i_load_D15_a_i
        struct[0].Gy_ini[385,51] = -1.0*i_load_D15_a_r
        struct[0].Gy_ini[385,384] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy_ini[385,385] = -1.0*v_D15_a_r + 1.0*v_D15_n_r
        struct[0].Gy_ini[386,384] = 1
        struct[0].Gy_ini[386,386] = 1
        struct[0].Gy_ini[387,385] = 1.00000000000000
        struct[0].Gy_ini[387,387] = 1.00000000000000
        struct[0].Gy_ini[388,52] = i_load_D11_a_r
        struct[0].Gy_ini[388,53] = 1.0*i_load_D11_a_i
        struct[0].Gy_ini[388,54] = -i_load_D11_a_r
        struct[0].Gy_ini[388,55] = -1.0*i_load_D11_a_i
        struct[0].Gy_ini[388,388] = v_D11_a_r - v_D11_n_r
        struct[0].Gy_ini[388,389] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy_ini[389,52] = -1.0*i_load_D11_a_i
        struct[0].Gy_ini[389,53] = 1.0*i_load_D11_a_r
        struct[0].Gy_ini[389,54] = 1.0*i_load_D11_a_i
        struct[0].Gy_ini[389,55] = -1.0*i_load_D11_a_r
        struct[0].Gy_ini[389,388] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy_ini[389,389] = -1.0*v_D11_a_r + 1.0*v_D11_n_r
        struct[0].Gy_ini[390,388] = 1
        struct[0].Gy_ini[390,390] = 1
        struct[0].Gy_ini[391,389] = 1.00000000000000
        struct[0].Gy_ini[391,391] = 1.00000000000000
        struct[0].Gy_ini[392,56] = i_load_D16_a_r
        struct[0].Gy_ini[392,57] = 1.0*i_load_D16_a_i
        struct[0].Gy_ini[392,58] = -i_load_D16_a_r
        struct[0].Gy_ini[392,59] = -1.0*i_load_D16_a_i
        struct[0].Gy_ini[392,392] = v_D16_a_r - v_D16_n_r
        struct[0].Gy_ini[392,393] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy_ini[393,56] = -1.0*i_load_D16_a_i
        struct[0].Gy_ini[393,57] = 1.0*i_load_D16_a_r
        struct[0].Gy_ini[393,58] = 1.0*i_load_D16_a_i
        struct[0].Gy_ini[393,59] = -1.0*i_load_D16_a_r
        struct[0].Gy_ini[393,392] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy_ini[393,393] = -1.0*v_D16_a_r + 1.0*v_D16_n_r
        struct[0].Gy_ini[394,392] = 1
        struct[0].Gy_ini[394,394] = 1
        struct[0].Gy_ini[395,393] = 1.00000000000000
        struct[0].Gy_ini[395,395] = 1.00000000000000
        struct[0].Gy_ini[396,60] = i_load_D17_a_r
        struct[0].Gy_ini[396,61] = 1.0*i_load_D17_a_i
        struct[0].Gy_ini[396,62] = -i_load_D17_a_r
        struct[0].Gy_ini[396,63] = -1.0*i_load_D17_a_i
        struct[0].Gy_ini[396,396] = v_D17_a_r - v_D17_n_r
        struct[0].Gy_ini[396,397] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy_ini[397,60] = -1.0*i_load_D17_a_i
        struct[0].Gy_ini[397,61] = 1.0*i_load_D17_a_r
        struct[0].Gy_ini[397,62] = 1.0*i_load_D17_a_i
        struct[0].Gy_ini[397,63] = -1.0*i_load_D17_a_r
        struct[0].Gy_ini[397,396] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy_ini[397,397] = -1.0*v_D17_a_r + 1.0*v_D17_n_r
        struct[0].Gy_ini[398,396] = 1
        struct[0].Gy_ini[398,398] = 1
        struct[0].Gy_ini[399,397] = 1.00000000000000
        struct[0].Gy_ini[399,399] = 1.00000000000000
        struct[0].Gy_ini[400,64] = i_load_D18_a_r
        struct[0].Gy_ini[400,65] = 1.0*i_load_D18_a_i
        struct[0].Gy_ini[400,66] = -i_load_D18_a_r
        struct[0].Gy_ini[400,67] = -1.0*i_load_D18_a_i
        struct[0].Gy_ini[400,400] = v_D18_a_r - v_D18_n_r
        struct[0].Gy_ini[400,401] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy_ini[401,64] = -1.0*i_load_D18_a_i
        struct[0].Gy_ini[401,65] = 1.0*i_load_D18_a_r
        struct[0].Gy_ini[401,66] = 1.0*i_load_D18_a_i
        struct[0].Gy_ini[401,67] = -1.0*i_load_D18_a_r
        struct[0].Gy_ini[401,400] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy_ini[401,401] = -1.0*v_D18_a_r + 1.0*v_D18_n_r
        struct[0].Gy_ini[402,400] = 1
        struct[0].Gy_ini[402,402] = 1
        struct[0].Gy_ini[403,401] = 1.00000000000000
        struct[0].Gy_ini[403,403] = 1.00000000000000
        struct[0].Gy_ini[404,0] = i_vsc_R1_a_r
        struct[0].Gy_ini[404,1] = 1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[404,6] = -i_vsc_R1_a_r
        struct[0].Gy_ini[404,7] = -1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[404,404] = v_R1_a_r - v_R1_n_r
        struct[0].Gy_ini[404,405] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[404,410] = -1/3
        struct[0].Gy_ini[405,0] = -1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[405,1] = 1.0*i_vsc_R1_a_r
        struct[0].Gy_ini[405,6] = 1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[405,7] = -1.0*i_vsc_R1_a_r
        struct[0].Gy_ini[405,404] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[405,405] = -1.0*v_R1_a_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[406,2] = i_vsc_R1_b_r
        struct[0].Gy_ini[406,3] = 1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[406,6] = -i_vsc_R1_b_r
        struct[0].Gy_ini[406,7] = -1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[406,406] = v_R1_b_r - v_R1_n_r
        struct[0].Gy_ini[406,407] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[406,410] = -1/3
        struct[0].Gy_ini[407,2] = -1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[407,3] = 1.0*i_vsc_R1_b_r
        struct[0].Gy_ini[407,6] = 1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[407,7] = -1.0*i_vsc_R1_b_r
        struct[0].Gy_ini[407,406] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[407,407] = -1.0*v_R1_b_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[408,4] = i_vsc_R1_c_r
        struct[0].Gy_ini[408,5] = 1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[408,6] = -i_vsc_R1_c_r
        struct[0].Gy_ini[408,7] = -1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[408,408] = v_R1_c_r - v_R1_n_r
        struct[0].Gy_ini[408,409] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[408,410] = -1/3
        struct[0].Gy_ini[409,4] = -1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[409,5] = 1.0*i_vsc_R1_c_r
        struct[0].Gy_ini[409,6] = 1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[409,7] = -1.0*i_vsc_R1_c_r
        struct[0].Gy_ini[409,408] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[409,409] = -1.0*v_R1_c_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[410,410] = 1
        struct[0].Gy_ini[410,411] = 1
        struct[0].Gy_ini[410,412] = Piecewise(np.array([(-1, p_D1 < 0), (1, True)]))
        struct[0].Gy_ini[411,248] = v_D1_a_r
        struct[0].Gy_ini[411,254] = v_D1_n_r
        struct[0].Gy_ini[411,411] = -1
        struct[0].Gy_ini[412,404] = -b_R1*i_vsc_R1_a_r/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_r
        struct[0].Gy_ini[412,405] = -b_R1*i_vsc_R1_a_i/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_i
        struct[0].Gy_ini[412,412] = 1
        struct[0].Gy_ini[413,132] = i_vsc_R10_a_r
        struct[0].Gy_ini[413,133] = 1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[413,138] = -i_vsc_R10_a_r
        struct[0].Gy_ini[413,139] = -1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[413,413] = v_R10_a_r - v_R10_n_r
        struct[0].Gy_ini[413,414] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[414,132] = -1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[414,133] = 1.0*i_vsc_R10_a_r
        struct[0].Gy_ini[414,138] = 1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[414,139] = -1.0*i_vsc_R10_a_r
        struct[0].Gy_ini[414,413] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[414,414] = -1.0*v_R10_a_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[415,134] = i_vsc_R10_b_r
        struct[0].Gy_ini[415,135] = 1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[415,138] = -i_vsc_R10_b_r
        struct[0].Gy_ini[415,139] = -1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[415,415] = v_R10_b_r - v_R10_n_r
        struct[0].Gy_ini[415,416] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[416,134] = -1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[416,135] = 1.0*i_vsc_R10_b_r
        struct[0].Gy_ini[416,138] = 1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[416,139] = -1.0*i_vsc_R10_b_r
        struct[0].Gy_ini[416,415] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[416,416] = -1.0*v_R10_b_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[417,136] = i_vsc_R10_c_r
        struct[0].Gy_ini[417,137] = 1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[417,138] = -i_vsc_R10_c_r
        struct[0].Gy_ini[417,139] = -1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[417,417] = v_R10_c_r - v_R10_n_r
        struct[0].Gy_ini[417,418] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[418,136] = -1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[418,137] = 1.0*i_vsc_R10_c_r
        struct[0].Gy_ini[418,138] = 1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[418,139] = -1.0*i_vsc_R10_c_r
        struct[0].Gy_ini[418,417] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[418,418] = -1.0*v_R10_c_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[419,198] = -p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[419,204] = p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[419,419] = 1
        struct[0].Gy_ini[419,421] = 1/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].Gy_ini[420,198] = p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[420,204] = -p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[420,420] = 1
        struct[0].Gy_ini[420,421] = 1/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].Gy_ini[421,421] = 1
        struct[0].Gy_ini[421,422] = -Piecewise(np.array([(-1, p_D10 < 0), (1, True)]))
        struct[0].Gy_ini[422,413] = -b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_r
        struct[0].Gy_ini[422,414] = -b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_i
        struct[0].Gy_ini[422,422] = 1
        struct[0].Gy_ini[423,156] = i_vsc_R14_a_r
        struct[0].Gy_ini[423,157] = 1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[423,162] = -i_vsc_R14_a_r
        struct[0].Gy_ini[423,163] = -1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[423,423] = v_R14_a_r - v_R14_n_r
        struct[0].Gy_ini[423,424] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[424,156] = -1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[424,157] = 1.0*i_vsc_R14_a_r
        struct[0].Gy_ini[424,162] = 1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[424,163] = -1.0*i_vsc_R14_a_r
        struct[0].Gy_ini[424,423] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[424,424] = -1.0*v_R14_a_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[425,158] = i_vsc_R14_b_r
        struct[0].Gy_ini[425,159] = 1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[425,162] = -i_vsc_R14_b_r
        struct[0].Gy_ini[425,163] = -1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[425,425] = v_R14_b_r - v_R14_n_r
        struct[0].Gy_ini[425,426] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[426,158] = -1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[426,159] = 1.0*i_vsc_R14_b_r
        struct[0].Gy_ini[426,162] = 1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[426,163] = -1.0*i_vsc_R14_b_r
        struct[0].Gy_ini[426,425] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[426,426] = -1.0*v_R14_b_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[427,160] = i_vsc_R14_c_r
        struct[0].Gy_ini[427,161] = 1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[427,162] = -i_vsc_R14_c_r
        struct[0].Gy_ini[427,163] = -1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[427,427] = v_R14_c_r - v_R14_n_r
        struct[0].Gy_ini[427,428] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[428,160] = -1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[428,161] = 1.0*i_vsc_R14_c_r
        struct[0].Gy_ini[428,162] = 1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[428,163] = -1.0*i_vsc_R14_c_r
        struct[0].Gy_ini[428,427] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[428,428] = -1.0*v_R14_c_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[429,222] = -p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[429,228] = p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[429,429] = 1
        struct[0].Gy_ini[429,431] = 1/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].Gy_ini[430,222] = p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[430,228] = -p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[430,430] = 1
        struct[0].Gy_ini[430,431] = 1/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].Gy_ini[431,431] = 1
        struct[0].Gy_ini[431,432] = -Piecewise(np.array([(-1, p_D14 < 0), (1, True)]))
        struct[0].Gy_ini[432,423] = -b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_r
        struct[0].Gy_ini[432,424] = -b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_i
        struct[0].Gy_ini[432,432] = 1



def run_nn(t,struct,mode):

    # Parameters:
    a_R1 = struct[0].a_R1
    b_R1 = struct[0].b_R1
    c_R1 = struct[0].c_R1
    a_R10 = struct[0].a_R10
    b_R10 = struct[0].b_R10
    c_R10 = struct[0].c_R10
    coef_a_R10 = struct[0].coef_a_R10
    coef_b_R10 = struct[0].coef_b_R10
    coef_c_R10 = struct[0].coef_c_R10
    a_R14 = struct[0].a_R14
    b_R14 = struct[0].b_R14
    c_R14 = struct[0].c_R14
    coef_a_R14 = struct[0].coef_a_R14
    coef_b_R14 = struct[0].coef_b_R14
    coef_c_R14 = struct[0].coef_c_R14
    
    # Inputs:
    v_R0_a_r = struct[0].v_R0_a_r
    v_R0_a_i = struct[0].v_R0_a_i
    v_R0_b_r = struct[0].v_R0_b_r
    v_R0_b_i = struct[0].v_R0_b_i
    v_R0_c_r = struct[0].v_R0_c_r
    v_R0_c_i = struct[0].v_R0_c_i
    v_D1_a_r = struct[0].v_D1_a_r
    v_D1_a_i = struct[0].v_D1_a_i
    v_D1_b_r = struct[0].v_D1_b_r
    v_D1_b_i = struct[0].v_D1_b_i
    v_D1_c_r = struct[0].v_D1_c_r
    v_D1_c_i = struct[0].v_D1_c_i
    i_R1_n_r = struct[0].i_R1_n_r
    i_R1_n_i = struct[0].i_R1_n_i
    i_R11_n_r = struct[0].i_R11_n_r
    i_R11_n_i = struct[0].i_R11_n_i
    i_R15_n_r = struct[0].i_R15_n_r
    i_R15_n_i = struct[0].i_R15_n_i
    i_R16_n_r = struct[0].i_R16_n_r
    i_R16_n_i = struct[0].i_R16_n_i
    i_R17_n_r = struct[0].i_R17_n_r
    i_R17_n_i = struct[0].i_R17_n_i
    i_R18_n_r = struct[0].i_R18_n_r
    i_R18_n_i = struct[0].i_R18_n_i
    i_R2_a_r = struct[0].i_R2_a_r
    i_R2_a_i = struct[0].i_R2_a_i
    i_R2_b_r = struct[0].i_R2_b_r
    i_R2_b_i = struct[0].i_R2_b_i
    i_R2_c_r = struct[0].i_R2_c_r
    i_R2_c_i = struct[0].i_R2_c_i
    i_R2_n_r = struct[0].i_R2_n_r
    i_R2_n_i = struct[0].i_R2_n_i
    i_R3_a_r = struct[0].i_R3_a_r
    i_R3_a_i = struct[0].i_R3_a_i
    i_R3_b_r = struct[0].i_R3_b_r
    i_R3_b_i = struct[0].i_R3_b_i
    i_R3_c_r = struct[0].i_R3_c_r
    i_R3_c_i = struct[0].i_R3_c_i
    i_R3_n_r = struct[0].i_R3_n_r
    i_R3_n_i = struct[0].i_R3_n_i
    i_R4_a_r = struct[0].i_R4_a_r
    i_R4_a_i = struct[0].i_R4_a_i
    i_R4_b_r = struct[0].i_R4_b_r
    i_R4_b_i = struct[0].i_R4_b_i
    i_R4_c_r = struct[0].i_R4_c_r
    i_R4_c_i = struct[0].i_R4_c_i
    i_R4_n_r = struct[0].i_R4_n_r
    i_R4_n_i = struct[0].i_R4_n_i
    i_R5_a_r = struct[0].i_R5_a_r
    i_R5_a_i = struct[0].i_R5_a_i
    i_R5_b_r = struct[0].i_R5_b_r
    i_R5_b_i = struct[0].i_R5_b_i
    i_R5_c_r = struct[0].i_R5_c_r
    i_R5_c_i = struct[0].i_R5_c_i
    i_R5_n_r = struct[0].i_R5_n_r
    i_R5_n_i = struct[0].i_R5_n_i
    i_R6_a_r = struct[0].i_R6_a_r
    i_R6_a_i = struct[0].i_R6_a_i
    i_R6_b_r = struct[0].i_R6_b_r
    i_R6_b_i = struct[0].i_R6_b_i
    i_R6_c_r = struct[0].i_R6_c_r
    i_R6_c_i = struct[0].i_R6_c_i
    i_R6_n_r = struct[0].i_R6_n_r
    i_R6_n_i = struct[0].i_R6_n_i
    i_R7_a_r = struct[0].i_R7_a_r
    i_R7_a_i = struct[0].i_R7_a_i
    i_R7_b_r = struct[0].i_R7_b_r
    i_R7_b_i = struct[0].i_R7_b_i
    i_R7_c_r = struct[0].i_R7_c_r
    i_R7_c_i = struct[0].i_R7_c_i
    i_R7_n_r = struct[0].i_R7_n_r
    i_R7_n_i = struct[0].i_R7_n_i
    i_R8_a_r = struct[0].i_R8_a_r
    i_R8_a_i = struct[0].i_R8_a_i
    i_R8_b_r = struct[0].i_R8_b_r
    i_R8_b_i = struct[0].i_R8_b_i
    i_R8_c_r = struct[0].i_R8_c_r
    i_R8_c_i = struct[0].i_R8_c_i
    i_R8_n_r = struct[0].i_R8_n_r
    i_R8_n_i = struct[0].i_R8_n_i
    i_R9_a_r = struct[0].i_R9_a_r
    i_R9_a_i = struct[0].i_R9_a_i
    i_R9_b_r = struct[0].i_R9_b_r
    i_R9_b_i = struct[0].i_R9_b_i
    i_R9_c_r = struct[0].i_R9_c_r
    i_R9_c_i = struct[0].i_R9_c_i
    i_R9_n_r = struct[0].i_R9_n_r
    i_R9_n_i = struct[0].i_R9_n_i
    i_R10_a_r = struct[0].i_R10_a_r
    i_R10_a_i = struct[0].i_R10_a_i
    i_R10_b_r = struct[0].i_R10_b_r
    i_R10_b_i = struct[0].i_R10_b_i
    i_R10_c_r = struct[0].i_R10_c_r
    i_R10_c_i = struct[0].i_R10_c_i
    i_R10_n_r = struct[0].i_R10_n_r
    i_R10_n_i = struct[0].i_R10_n_i
    i_R12_a_r = struct[0].i_R12_a_r
    i_R12_a_i = struct[0].i_R12_a_i
    i_R12_b_r = struct[0].i_R12_b_r
    i_R12_b_i = struct[0].i_R12_b_i
    i_R12_c_r = struct[0].i_R12_c_r
    i_R12_c_i = struct[0].i_R12_c_i
    i_R12_n_r = struct[0].i_R12_n_r
    i_R12_n_i = struct[0].i_R12_n_i
    i_R13_a_r = struct[0].i_R13_a_r
    i_R13_a_i = struct[0].i_R13_a_i
    i_R13_b_r = struct[0].i_R13_b_r
    i_R13_b_i = struct[0].i_R13_b_i
    i_R13_c_r = struct[0].i_R13_c_r
    i_R13_c_i = struct[0].i_R13_c_i
    i_R13_n_r = struct[0].i_R13_n_r
    i_R13_n_i = struct[0].i_R13_n_i
    i_R14_a_r = struct[0].i_R14_a_r
    i_R14_a_i = struct[0].i_R14_a_i
    i_R14_b_r = struct[0].i_R14_b_r
    i_R14_b_i = struct[0].i_R14_b_i
    i_R14_c_r = struct[0].i_R14_c_r
    i_R14_c_i = struct[0].i_R14_c_i
    i_R14_n_r = struct[0].i_R14_n_r
    i_R14_n_i = struct[0].i_R14_n_i
    i_D1_n_r = struct[0].i_D1_n_r
    i_D1_n_i = struct[0].i_D1_n_i
    i_D3_a_r = struct[0].i_D3_a_r
    i_D3_a_i = struct[0].i_D3_a_i
    i_D3_b_r = struct[0].i_D3_b_r
    i_D3_b_i = struct[0].i_D3_b_i
    i_D3_c_r = struct[0].i_D3_c_r
    i_D3_c_i = struct[0].i_D3_c_i
    i_D3_n_r = struct[0].i_D3_n_r
    i_D3_n_i = struct[0].i_D3_n_i
    i_D4_a_r = struct[0].i_D4_a_r
    i_D4_a_i = struct[0].i_D4_a_i
    i_D4_b_r = struct[0].i_D4_b_r
    i_D4_b_i = struct[0].i_D4_b_i
    i_D4_c_r = struct[0].i_D4_c_r
    i_D4_c_i = struct[0].i_D4_c_i
    i_D4_n_r = struct[0].i_D4_n_r
    i_D4_n_i = struct[0].i_D4_n_i
    i_D6_a_r = struct[0].i_D6_a_r
    i_D6_a_i = struct[0].i_D6_a_i
    i_D6_b_r = struct[0].i_D6_b_r
    i_D6_b_i = struct[0].i_D6_b_i
    i_D6_c_r = struct[0].i_D6_c_r
    i_D6_c_i = struct[0].i_D6_c_i
    i_D6_n_r = struct[0].i_D6_n_r
    i_D6_n_i = struct[0].i_D6_n_i
    i_D9_a_r = struct[0].i_D9_a_r
    i_D9_a_i = struct[0].i_D9_a_i
    i_D9_b_r = struct[0].i_D9_b_r
    i_D9_b_i = struct[0].i_D9_b_i
    i_D9_c_r = struct[0].i_D9_c_r
    i_D9_c_i = struct[0].i_D9_c_i
    i_D9_n_r = struct[0].i_D9_n_r
    i_D9_n_i = struct[0].i_D9_n_i
    i_D10_a_i = struct[0].i_D10_a_i
    i_D10_b_r = struct[0].i_D10_b_r
    i_D10_b_i = struct[0].i_D10_b_i
    i_D10_c_r = struct[0].i_D10_c_r
    i_D10_c_i = struct[0].i_D10_c_i
    i_D10_n_i = struct[0].i_D10_n_i
    i_D11_b_r = struct[0].i_D11_b_r
    i_D11_b_i = struct[0].i_D11_b_i
    i_D11_c_r = struct[0].i_D11_c_r
    i_D11_c_i = struct[0].i_D11_c_i
    i_D16_b_r = struct[0].i_D16_b_r
    i_D16_b_i = struct[0].i_D16_b_i
    i_D16_c_r = struct[0].i_D16_c_r
    i_D16_c_i = struct[0].i_D16_c_i
    i_D17_b_r = struct[0].i_D17_b_r
    i_D17_b_i = struct[0].i_D17_b_i
    i_D17_c_r = struct[0].i_D17_c_r
    i_D17_c_i = struct[0].i_D17_c_i
    i_D18_b_r = struct[0].i_D18_b_r
    i_D18_b_i = struct[0].i_D18_b_i
    i_D18_c_r = struct[0].i_D18_c_r
    i_D18_c_i = struct[0].i_D18_c_i
    i_D14_a_i = struct[0].i_D14_a_i
    i_D14_b_r = struct[0].i_D14_b_r
    i_D14_b_i = struct[0].i_D14_b_i
    i_D14_c_r = struct[0].i_D14_c_r
    i_D14_c_i = struct[0].i_D14_c_i
    i_D14_n_i = struct[0].i_D14_n_i
    i_D15_b_r = struct[0].i_D15_b_r
    i_D15_b_i = struct[0].i_D15_b_i
    i_D15_c_r = struct[0].i_D15_c_r
    i_D15_c_i = struct[0].i_D15_c_i
    p_R1_a = struct[0].p_R1_a
    q_R1_a = struct[0].q_R1_a
    p_R1_b = struct[0].p_R1_b
    q_R1_b = struct[0].q_R1_b
    p_R1_c = struct[0].p_R1_c
    q_R1_c = struct[0].q_R1_c
    p_R11_a = struct[0].p_R11_a
    q_R11_a = struct[0].q_R11_a
    p_R11_b = struct[0].p_R11_b
    q_R11_b = struct[0].q_R11_b
    p_R11_c = struct[0].p_R11_c
    q_R11_c = struct[0].q_R11_c
    p_R15_a = struct[0].p_R15_a
    q_R15_a = struct[0].q_R15_a
    p_R15_b = struct[0].p_R15_b
    q_R15_b = struct[0].q_R15_b
    p_R15_c = struct[0].p_R15_c
    q_R15_c = struct[0].q_R15_c
    p_R16_a = struct[0].p_R16_a
    q_R16_a = struct[0].q_R16_a
    p_R16_b = struct[0].p_R16_b
    q_R16_b = struct[0].q_R16_b
    p_R16_c = struct[0].p_R16_c
    q_R16_c = struct[0].q_R16_c
    p_R17_a = struct[0].p_R17_a
    q_R17_a = struct[0].q_R17_a
    p_R17_b = struct[0].p_R17_b
    q_R17_b = struct[0].q_R17_b
    p_R17_c = struct[0].p_R17_c
    q_R17_c = struct[0].q_R17_c
    p_R18_a = struct[0].p_R18_a
    q_R18_a = struct[0].q_R18_a
    p_R18_b = struct[0].p_R18_b
    q_R18_b = struct[0].q_R18_b
    p_R18_c = struct[0].p_R18_c
    q_R18_c = struct[0].q_R18_c
    p_D15_1 = struct[0].p_D15_1
    q_D15_1 = struct[0].q_D15_1
    p_D11_1 = struct[0].p_D11_1
    q_D11_1 = struct[0].q_D11_1
    p_D16_1 = struct[0].p_D16_1
    q_D16_1 = struct[0].q_D16_1
    p_D17_1 = struct[0].p_D17_1
    q_D17_1 = struct[0].q_D17_1
    p_D18_1 = struct[0].p_D18_1
    q_D18_1 = struct[0].q_D18_1
    v_dc_D1 = struct[0].v_dc_D1
    q_R1 = struct[0].q_R1
    p_R10 = struct[0].p_R10
    q_R10 = struct[0].q_R10
    p_R14 = struct[0].p_R14
    q_R14 = struct[0].q_R14
    u_dummy = struct[0].u_dummy
    
    # Dynamical states:
    x_dummy = struct[0].x[0,0]
    
    # Algebraic states:
    v_R1_a_r = struct[0].y_run[0,0]
    v_R1_a_i = struct[0].y_run[1,0]
    v_R1_b_r = struct[0].y_run[2,0]
    v_R1_b_i = struct[0].y_run[3,0]
    v_R1_c_r = struct[0].y_run[4,0]
    v_R1_c_i = struct[0].y_run[5,0]
    v_R1_n_r = struct[0].y_run[6,0]
    v_R1_n_i = struct[0].y_run[7,0]
    v_R11_a_r = struct[0].y_run[8,0]
    v_R11_a_i = struct[0].y_run[9,0]
    v_R11_b_r = struct[0].y_run[10,0]
    v_R11_b_i = struct[0].y_run[11,0]
    v_R11_c_r = struct[0].y_run[12,0]
    v_R11_c_i = struct[0].y_run[13,0]
    v_R11_n_r = struct[0].y_run[14,0]
    v_R11_n_i = struct[0].y_run[15,0]
    v_R15_a_r = struct[0].y_run[16,0]
    v_R15_a_i = struct[0].y_run[17,0]
    v_R15_b_r = struct[0].y_run[18,0]
    v_R15_b_i = struct[0].y_run[19,0]
    v_R15_c_r = struct[0].y_run[20,0]
    v_R15_c_i = struct[0].y_run[21,0]
    v_R15_n_r = struct[0].y_run[22,0]
    v_R15_n_i = struct[0].y_run[23,0]
    v_R16_a_r = struct[0].y_run[24,0]
    v_R16_a_i = struct[0].y_run[25,0]
    v_R16_b_r = struct[0].y_run[26,0]
    v_R16_b_i = struct[0].y_run[27,0]
    v_R16_c_r = struct[0].y_run[28,0]
    v_R16_c_i = struct[0].y_run[29,0]
    v_R16_n_r = struct[0].y_run[30,0]
    v_R16_n_i = struct[0].y_run[31,0]
    v_R17_a_r = struct[0].y_run[32,0]
    v_R17_a_i = struct[0].y_run[33,0]
    v_R17_b_r = struct[0].y_run[34,0]
    v_R17_b_i = struct[0].y_run[35,0]
    v_R17_c_r = struct[0].y_run[36,0]
    v_R17_c_i = struct[0].y_run[37,0]
    v_R17_n_r = struct[0].y_run[38,0]
    v_R17_n_i = struct[0].y_run[39,0]
    v_R18_a_r = struct[0].y_run[40,0]
    v_R18_a_i = struct[0].y_run[41,0]
    v_R18_b_r = struct[0].y_run[42,0]
    v_R18_b_i = struct[0].y_run[43,0]
    v_R18_c_r = struct[0].y_run[44,0]
    v_R18_c_i = struct[0].y_run[45,0]
    v_R18_n_r = struct[0].y_run[46,0]
    v_R18_n_i = struct[0].y_run[47,0]
    v_D15_a_r = struct[0].y_run[48,0]
    v_D15_a_i = struct[0].y_run[49,0]
    v_D15_n_r = struct[0].y_run[50,0]
    v_D15_n_i = struct[0].y_run[51,0]
    v_D11_a_r = struct[0].y_run[52,0]
    v_D11_a_i = struct[0].y_run[53,0]
    v_D11_n_r = struct[0].y_run[54,0]
    v_D11_n_i = struct[0].y_run[55,0]
    v_D16_a_r = struct[0].y_run[56,0]
    v_D16_a_i = struct[0].y_run[57,0]
    v_D16_n_r = struct[0].y_run[58,0]
    v_D16_n_i = struct[0].y_run[59,0]
    v_D17_a_r = struct[0].y_run[60,0]
    v_D17_a_i = struct[0].y_run[61,0]
    v_D17_n_r = struct[0].y_run[62,0]
    v_D17_n_i = struct[0].y_run[63,0]
    v_D18_a_r = struct[0].y_run[64,0]
    v_D18_a_i = struct[0].y_run[65,0]
    v_D18_n_r = struct[0].y_run[66,0]
    v_D18_n_i = struct[0].y_run[67,0]
    v_R2_a_r = struct[0].y_run[68,0]
    v_R2_a_i = struct[0].y_run[69,0]
    v_R2_b_r = struct[0].y_run[70,0]
    v_R2_b_i = struct[0].y_run[71,0]
    v_R2_c_r = struct[0].y_run[72,0]
    v_R2_c_i = struct[0].y_run[73,0]
    v_R2_n_r = struct[0].y_run[74,0]
    v_R2_n_i = struct[0].y_run[75,0]
    v_R3_a_r = struct[0].y_run[76,0]
    v_R3_a_i = struct[0].y_run[77,0]
    v_R3_b_r = struct[0].y_run[78,0]
    v_R3_b_i = struct[0].y_run[79,0]
    v_R3_c_r = struct[0].y_run[80,0]
    v_R3_c_i = struct[0].y_run[81,0]
    v_R3_n_r = struct[0].y_run[82,0]
    v_R3_n_i = struct[0].y_run[83,0]
    v_R4_a_r = struct[0].y_run[84,0]
    v_R4_a_i = struct[0].y_run[85,0]
    v_R4_b_r = struct[0].y_run[86,0]
    v_R4_b_i = struct[0].y_run[87,0]
    v_R4_c_r = struct[0].y_run[88,0]
    v_R4_c_i = struct[0].y_run[89,0]
    v_R4_n_r = struct[0].y_run[90,0]
    v_R4_n_i = struct[0].y_run[91,0]
    v_R5_a_r = struct[0].y_run[92,0]
    v_R5_a_i = struct[0].y_run[93,0]
    v_R5_b_r = struct[0].y_run[94,0]
    v_R5_b_i = struct[0].y_run[95,0]
    v_R5_c_r = struct[0].y_run[96,0]
    v_R5_c_i = struct[0].y_run[97,0]
    v_R5_n_r = struct[0].y_run[98,0]
    v_R5_n_i = struct[0].y_run[99,0]
    v_R6_a_r = struct[0].y_run[100,0]
    v_R6_a_i = struct[0].y_run[101,0]
    v_R6_b_r = struct[0].y_run[102,0]
    v_R6_b_i = struct[0].y_run[103,0]
    v_R6_c_r = struct[0].y_run[104,0]
    v_R6_c_i = struct[0].y_run[105,0]
    v_R6_n_r = struct[0].y_run[106,0]
    v_R6_n_i = struct[0].y_run[107,0]
    v_R7_a_r = struct[0].y_run[108,0]
    v_R7_a_i = struct[0].y_run[109,0]
    v_R7_b_r = struct[0].y_run[110,0]
    v_R7_b_i = struct[0].y_run[111,0]
    v_R7_c_r = struct[0].y_run[112,0]
    v_R7_c_i = struct[0].y_run[113,0]
    v_R7_n_r = struct[0].y_run[114,0]
    v_R7_n_i = struct[0].y_run[115,0]
    v_R8_a_r = struct[0].y_run[116,0]
    v_R8_a_i = struct[0].y_run[117,0]
    v_R8_b_r = struct[0].y_run[118,0]
    v_R8_b_i = struct[0].y_run[119,0]
    v_R8_c_r = struct[0].y_run[120,0]
    v_R8_c_i = struct[0].y_run[121,0]
    v_R8_n_r = struct[0].y_run[122,0]
    v_R8_n_i = struct[0].y_run[123,0]
    v_R9_a_r = struct[0].y_run[124,0]
    v_R9_a_i = struct[0].y_run[125,0]
    v_R9_b_r = struct[0].y_run[126,0]
    v_R9_b_i = struct[0].y_run[127,0]
    v_R9_c_r = struct[0].y_run[128,0]
    v_R9_c_i = struct[0].y_run[129,0]
    v_R9_n_r = struct[0].y_run[130,0]
    v_R9_n_i = struct[0].y_run[131,0]
    v_R10_a_r = struct[0].y_run[132,0]
    v_R10_a_i = struct[0].y_run[133,0]
    v_R10_b_r = struct[0].y_run[134,0]
    v_R10_b_i = struct[0].y_run[135,0]
    v_R10_c_r = struct[0].y_run[136,0]
    v_R10_c_i = struct[0].y_run[137,0]
    v_R10_n_r = struct[0].y_run[138,0]
    v_R10_n_i = struct[0].y_run[139,0]
    v_R12_a_r = struct[0].y_run[140,0]
    v_R12_a_i = struct[0].y_run[141,0]
    v_R12_b_r = struct[0].y_run[142,0]
    v_R12_b_i = struct[0].y_run[143,0]
    v_R12_c_r = struct[0].y_run[144,0]
    v_R12_c_i = struct[0].y_run[145,0]
    v_R12_n_r = struct[0].y_run[146,0]
    v_R12_n_i = struct[0].y_run[147,0]
    v_R13_a_r = struct[0].y_run[148,0]
    v_R13_a_i = struct[0].y_run[149,0]
    v_R13_b_r = struct[0].y_run[150,0]
    v_R13_b_i = struct[0].y_run[151,0]
    v_R13_c_r = struct[0].y_run[152,0]
    v_R13_c_i = struct[0].y_run[153,0]
    v_R13_n_r = struct[0].y_run[154,0]
    v_R13_n_i = struct[0].y_run[155,0]
    v_R14_a_r = struct[0].y_run[156,0]
    v_R14_a_i = struct[0].y_run[157,0]
    v_R14_b_r = struct[0].y_run[158,0]
    v_R14_b_i = struct[0].y_run[159,0]
    v_R14_c_r = struct[0].y_run[160,0]
    v_R14_c_i = struct[0].y_run[161,0]
    v_R14_n_r = struct[0].y_run[162,0]
    v_R14_n_i = struct[0].y_run[163,0]
    v_D1_n_r = struct[0].y_run[164,0]
    v_D1_n_i = struct[0].y_run[165,0]
    v_D3_a_r = struct[0].y_run[166,0]
    v_D3_a_i = struct[0].y_run[167,0]
    v_D3_b_r = struct[0].y_run[168,0]
    v_D3_b_i = struct[0].y_run[169,0]
    v_D3_c_r = struct[0].y_run[170,0]
    v_D3_c_i = struct[0].y_run[171,0]
    v_D3_n_r = struct[0].y_run[172,0]
    v_D3_n_i = struct[0].y_run[173,0]
    v_D4_a_r = struct[0].y_run[174,0]
    v_D4_a_i = struct[0].y_run[175,0]
    v_D4_b_r = struct[0].y_run[176,0]
    v_D4_b_i = struct[0].y_run[177,0]
    v_D4_c_r = struct[0].y_run[178,0]
    v_D4_c_i = struct[0].y_run[179,0]
    v_D4_n_r = struct[0].y_run[180,0]
    v_D4_n_i = struct[0].y_run[181,0]
    v_D6_a_r = struct[0].y_run[182,0]
    v_D6_a_i = struct[0].y_run[183,0]
    v_D6_b_r = struct[0].y_run[184,0]
    v_D6_b_i = struct[0].y_run[185,0]
    v_D6_c_r = struct[0].y_run[186,0]
    v_D6_c_i = struct[0].y_run[187,0]
    v_D6_n_r = struct[0].y_run[188,0]
    v_D6_n_i = struct[0].y_run[189,0]
    v_D9_a_r = struct[0].y_run[190,0]
    v_D9_a_i = struct[0].y_run[191,0]
    v_D9_b_r = struct[0].y_run[192,0]
    v_D9_b_i = struct[0].y_run[193,0]
    v_D9_c_r = struct[0].y_run[194,0]
    v_D9_c_i = struct[0].y_run[195,0]
    v_D9_n_r = struct[0].y_run[196,0]
    v_D9_n_i = struct[0].y_run[197,0]
    v_D10_a_r = struct[0].y_run[198,0]
    v_D10_a_i = struct[0].y_run[199,0]
    v_D10_b_r = struct[0].y_run[200,0]
    v_D10_b_i = struct[0].y_run[201,0]
    v_D10_c_r = struct[0].y_run[202,0]
    v_D10_c_i = struct[0].y_run[203,0]
    v_D10_n_r = struct[0].y_run[204,0]
    v_D10_n_i = struct[0].y_run[205,0]
    v_D11_b_r = struct[0].y_run[206,0]
    v_D11_b_i = struct[0].y_run[207,0]
    v_D11_c_r = struct[0].y_run[208,0]
    v_D11_c_i = struct[0].y_run[209,0]
    v_D16_b_r = struct[0].y_run[210,0]
    v_D16_b_i = struct[0].y_run[211,0]
    v_D16_c_r = struct[0].y_run[212,0]
    v_D16_c_i = struct[0].y_run[213,0]
    v_D17_b_r = struct[0].y_run[214,0]
    v_D17_b_i = struct[0].y_run[215,0]
    v_D17_c_r = struct[0].y_run[216,0]
    v_D17_c_i = struct[0].y_run[217,0]
    v_D18_b_r = struct[0].y_run[218,0]
    v_D18_b_i = struct[0].y_run[219,0]
    v_D18_c_r = struct[0].y_run[220,0]
    v_D18_c_i = struct[0].y_run[221,0]
    v_D14_a_r = struct[0].y_run[222,0]
    v_D14_a_i = struct[0].y_run[223,0]
    v_D14_b_r = struct[0].y_run[224,0]
    v_D14_b_i = struct[0].y_run[225,0]
    v_D14_c_r = struct[0].y_run[226,0]
    v_D14_c_i = struct[0].y_run[227,0]
    v_D14_n_r = struct[0].y_run[228,0]
    v_D14_n_i = struct[0].y_run[229,0]
    v_D15_b_r = struct[0].y_run[230,0]
    v_D15_b_i = struct[0].y_run[231,0]
    v_D15_c_r = struct[0].y_run[232,0]
    v_D15_c_i = struct[0].y_run[233,0]
    i_t_R0_R1_a_r = struct[0].y_run[234,0]
    i_t_R0_R1_a_i = struct[0].y_run[235,0]
    i_t_R0_R1_b_r = struct[0].y_run[236,0]
    i_t_R0_R1_b_i = struct[0].y_run[237,0]
    i_t_R0_R1_c_r = struct[0].y_run[238,0]
    i_t_R0_R1_c_i = struct[0].y_run[239,0]
    i_l_R1_R2_a_r = struct[0].y_run[240,0]
    i_l_R1_R2_a_i = struct[0].y_run[241,0]
    i_l_R1_R2_b_r = struct[0].y_run[242,0]
    i_l_R1_R2_b_i = struct[0].y_run[243,0]
    i_l_R1_R2_c_r = struct[0].y_run[244,0]
    i_l_R1_R2_c_i = struct[0].y_run[245,0]
    i_l_R1_R2_n_r = struct[0].y_run[246,0]
    i_l_R1_R2_n_i = struct[0].y_run[247,0]
    i_l_D1_D3_a_r = struct[0].y_run[248,0]
    i_l_D1_D3_a_i = struct[0].y_run[249,0]
    i_l_D1_D3_b_r = struct[0].y_run[250,0]
    i_l_D1_D3_b_i = struct[0].y_run[251,0]
    i_l_D1_D3_c_r = struct[0].y_run[252,0]
    i_l_D1_D3_c_i = struct[0].y_run[253,0]
    i_l_D1_D3_n_r = struct[0].y_run[254,0]
    i_l_D1_D3_n_i = struct[0].y_run[255,0]
    i_l_D3_D4_a_r = struct[0].y_run[256,0]
    i_l_D3_D4_a_i = struct[0].y_run[257,0]
    i_l_D3_D4_b_r = struct[0].y_run[258,0]
    i_l_D3_D4_b_i = struct[0].y_run[259,0]
    i_l_D3_D4_c_r = struct[0].y_run[260,0]
    i_l_D3_D4_c_i = struct[0].y_run[261,0]
    i_l_D3_D4_n_r = struct[0].y_run[262,0]
    i_l_D3_D4_n_i = struct[0].y_run[263,0]
    i_l_D4_D6_a_r = struct[0].y_run[264,0]
    i_l_D4_D6_a_i = struct[0].y_run[265,0]
    i_l_D4_D6_b_r = struct[0].y_run[266,0]
    i_l_D4_D6_b_i = struct[0].y_run[267,0]
    i_l_D4_D6_c_r = struct[0].y_run[268,0]
    i_l_D4_D6_c_i = struct[0].y_run[269,0]
    i_l_D4_D6_n_r = struct[0].y_run[270,0]
    i_l_D4_D6_n_i = struct[0].y_run[271,0]
    i_l_D6_D9_a_r = struct[0].y_run[272,0]
    i_l_D6_D9_a_i = struct[0].y_run[273,0]
    i_l_D6_D9_b_r = struct[0].y_run[274,0]
    i_l_D6_D9_b_i = struct[0].y_run[275,0]
    i_l_D6_D9_c_r = struct[0].y_run[276,0]
    i_l_D6_D9_c_i = struct[0].y_run[277,0]
    i_l_D6_D9_n_r = struct[0].y_run[278,0]
    i_l_D6_D9_n_i = struct[0].y_run[279,0]
    i_l_D9_D10_a_r = struct[0].y_run[280,0]
    i_l_D9_D10_a_i = struct[0].y_run[281,0]
    i_l_D9_D10_b_r = struct[0].y_run[282,0]
    i_l_D9_D10_b_i = struct[0].y_run[283,0]
    i_l_D9_D10_c_r = struct[0].y_run[284,0]
    i_l_D9_D10_c_i = struct[0].y_run[285,0]
    i_l_D9_D10_n_r = struct[0].y_run[286,0]
    i_l_D9_D10_n_i = struct[0].y_run[287,0]
    i_l_D3_D11_a_r = struct[0].y_run[288,0]
    i_l_D3_D11_a_i = struct[0].y_run[289,0]
    i_l_D3_D11_b_r = struct[0].y_run[290,0]
    i_l_D3_D11_b_i = struct[0].y_run[291,0]
    i_l_D3_D11_c_r = struct[0].y_run[292,0]
    i_l_D3_D11_c_i = struct[0].y_run[293,0]
    i_l_D3_D11_n_r = struct[0].y_run[294,0]
    i_l_D3_D11_n_i = struct[0].y_run[295,0]
    i_l_D6_D16_a_r = struct[0].y_run[296,0]
    i_l_D6_D16_a_i = struct[0].y_run[297,0]
    i_l_D6_D16_b_r = struct[0].y_run[298,0]
    i_l_D6_D16_b_i = struct[0].y_run[299,0]
    i_l_D6_D16_c_r = struct[0].y_run[300,0]
    i_l_D6_D16_c_i = struct[0].y_run[301,0]
    i_l_D6_D16_n_r = struct[0].y_run[302,0]
    i_l_D6_D16_n_i = struct[0].y_run[303,0]
    i_l_D9_D17_a_r = struct[0].y_run[304,0]
    i_l_D9_D17_a_i = struct[0].y_run[305,0]
    i_l_D9_D17_b_r = struct[0].y_run[306,0]
    i_l_D9_D17_b_i = struct[0].y_run[307,0]
    i_l_D9_D17_c_r = struct[0].y_run[308,0]
    i_l_D9_D17_c_i = struct[0].y_run[309,0]
    i_l_D9_D17_n_r = struct[0].y_run[310,0]
    i_l_D9_D17_n_i = struct[0].y_run[311,0]
    i_l_D10_D18_a_r = struct[0].y_run[312,0]
    i_l_D10_D18_a_i = struct[0].y_run[313,0]
    i_l_D10_D18_b_r = struct[0].y_run[314,0]
    i_l_D10_D18_b_i = struct[0].y_run[315,0]
    i_l_D10_D18_c_r = struct[0].y_run[316,0]
    i_l_D10_D18_c_i = struct[0].y_run[317,0]
    i_l_D10_D18_n_r = struct[0].y_run[318,0]
    i_l_D10_D18_n_i = struct[0].y_run[319,0]
    i_l_D4_D14_a_r = struct[0].y_run[320,0]
    i_l_D4_D14_a_i = struct[0].y_run[321,0]
    i_l_D4_D14_b_r = struct[0].y_run[322,0]
    i_l_D4_D14_b_i = struct[0].y_run[323,0]
    i_l_D4_D14_c_r = struct[0].y_run[324,0]
    i_l_D4_D14_c_i = struct[0].y_run[325,0]
    i_l_D4_D14_n_r = struct[0].y_run[326,0]
    i_l_D4_D14_n_i = struct[0].y_run[327,0]
    i_l_D14_D15_a_r = struct[0].y_run[328,0]
    i_l_D14_D15_a_i = struct[0].y_run[329,0]
    i_l_D14_D15_b_r = struct[0].y_run[330,0]
    i_l_D14_D15_b_i = struct[0].y_run[331,0]
    i_l_D14_D15_c_r = struct[0].y_run[332,0]
    i_l_D14_D15_c_i = struct[0].y_run[333,0]
    i_l_D14_D15_n_r = struct[0].y_run[334,0]
    i_l_D14_D15_n_i = struct[0].y_run[335,0]
    i_load_R1_a_r = struct[0].y_run[336,0]
    i_load_R1_a_i = struct[0].y_run[337,0]
    i_load_R1_b_r = struct[0].y_run[338,0]
    i_load_R1_b_i = struct[0].y_run[339,0]
    i_load_R1_c_r = struct[0].y_run[340,0]
    i_load_R1_c_i = struct[0].y_run[341,0]
    i_load_R1_n_r = struct[0].y_run[342,0]
    i_load_R1_n_i = struct[0].y_run[343,0]
    i_load_R11_a_r = struct[0].y_run[344,0]
    i_load_R11_a_i = struct[0].y_run[345,0]
    i_load_R11_b_r = struct[0].y_run[346,0]
    i_load_R11_b_i = struct[0].y_run[347,0]
    i_load_R11_c_r = struct[0].y_run[348,0]
    i_load_R11_c_i = struct[0].y_run[349,0]
    i_load_R11_n_r = struct[0].y_run[350,0]
    i_load_R11_n_i = struct[0].y_run[351,0]
    i_load_R15_a_r = struct[0].y_run[352,0]
    i_load_R15_a_i = struct[0].y_run[353,0]
    i_load_R15_b_r = struct[0].y_run[354,0]
    i_load_R15_b_i = struct[0].y_run[355,0]
    i_load_R15_c_r = struct[0].y_run[356,0]
    i_load_R15_c_i = struct[0].y_run[357,0]
    i_load_R15_n_r = struct[0].y_run[358,0]
    i_load_R15_n_i = struct[0].y_run[359,0]
    i_load_R16_a_r = struct[0].y_run[360,0]
    i_load_R16_a_i = struct[0].y_run[361,0]
    i_load_R16_b_r = struct[0].y_run[362,0]
    i_load_R16_b_i = struct[0].y_run[363,0]
    i_load_R16_c_r = struct[0].y_run[364,0]
    i_load_R16_c_i = struct[0].y_run[365,0]
    i_load_R16_n_r = struct[0].y_run[366,0]
    i_load_R16_n_i = struct[0].y_run[367,0]
    i_load_R17_a_r = struct[0].y_run[368,0]
    i_load_R17_a_i = struct[0].y_run[369,0]
    i_load_R17_b_r = struct[0].y_run[370,0]
    i_load_R17_b_i = struct[0].y_run[371,0]
    i_load_R17_c_r = struct[0].y_run[372,0]
    i_load_R17_c_i = struct[0].y_run[373,0]
    i_load_R17_n_r = struct[0].y_run[374,0]
    i_load_R17_n_i = struct[0].y_run[375,0]
    i_load_R18_a_r = struct[0].y_run[376,0]
    i_load_R18_a_i = struct[0].y_run[377,0]
    i_load_R18_b_r = struct[0].y_run[378,0]
    i_load_R18_b_i = struct[0].y_run[379,0]
    i_load_R18_c_r = struct[0].y_run[380,0]
    i_load_R18_c_i = struct[0].y_run[381,0]
    i_load_R18_n_r = struct[0].y_run[382,0]
    i_load_R18_n_i = struct[0].y_run[383,0]
    i_load_D15_a_r = struct[0].y_run[384,0]
    i_load_D15_a_i = struct[0].y_run[385,0]
    i_load_D15_n_r = struct[0].y_run[386,0]
    i_load_D15_n_i = struct[0].y_run[387,0]
    i_load_D11_a_r = struct[0].y_run[388,0]
    i_load_D11_a_i = struct[0].y_run[389,0]
    i_load_D11_n_r = struct[0].y_run[390,0]
    i_load_D11_n_i = struct[0].y_run[391,0]
    i_load_D16_a_r = struct[0].y_run[392,0]
    i_load_D16_a_i = struct[0].y_run[393,0]
    i_load_D16_n_r = struct[0].y_run[394,0]
    i_load_D16_n_i = struct[0].y_run[395,0]
    i_load_D17_a_r = struct[0].y_run[396,0]
    i_load_D17_a_i = struct[0].y_run[397,0]
    i_load_D17_n_r = struct[0].y_run[398,0]
    i_load_D17_n_i = struct[0].y_run[399,0]
    i_load_D18_a_r = struct[0].y_run[400,0]
    i_load_D18_a_i = struct[0].y_run[401,0]
    i_load_D18_n_r = struct[0].y_run[402,0]
    i_load_D18_n_i = struct[0].y_run[403,0]
    i_vsc_R1_a_r = struct[0].y_run[404,0]
    i_vsc_R1_a_i = struct[0].y_run[405,0]
    i_vsc_R1_b_r = struct[0].y_run[406,0]
    i_vsc_R1_b_i = struct[0].y_run[407,0]
    i_vsc_R1_c_r = struct[0].y_run[408,0]
    i_vsc_R1_c_i = struct[0].y_run[409,0]
    p_R1 = struct[0].y_run[410,0]
    p_D1 = struct[0].y_run[411,0]
    p_loss_R1 = struct[0].y_run[412,0]
    i_vsc_R10_a_r = struct[0].y_run[413,0]
    i_vsc_R10_a_i = struct[0].y_run[414,0]
    i_vsc_R10_b_r = struct[0].y_run[415,0]
    i_vsc_R10_b_i = struct[0].y_run[416,0]
    i_vsc_R10_c_r = struct[0].y_run[417,0]
    i_vsc_R10_c_i = struct[0].y_run[418,0]
    i_vsc_D10_a_r = struct[0].y_run[419,0]
    i_vsc_D10_n_r = struct[0].y_run[420,0]
    p_D10 = struct[0].y_run[421,0]
    p_loss_R10 = struct[0].y_run[422,0]
    i_vsc_R14_a_r = struct[0].y_run[423,0]
    i_vsc_R14_a_i = struct[0].y_run[424,0]
    i_vsc_R14_b_r = struct[0].y_run[425,0]
    i_vsc_R14_b_i = struct[0].y_run[426,0]
    i_vsc_R14_c_r = struct[0].y_run[427,0]
    i_vsc_R14_c_i = struct[0].y_run[428,0]
    i_vsc_D14_a_r = struct[0].y_run[429,0]
    i_vsc_D14_n_r = struct[0].y_run[430,0]
    p_D14 = struct[0].y_run[431,0]
    p_loss_R14 = struct[0].y_run[432,0]
    
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = u_dummy - x_dummy
    
    # Algebraic equations:
    if mode == 3:


        struct[0].g[0,0] = i_load_R1_a_r + i_vsc_R1_a_r + 0.849044513514155*v_R0_a_i + 0.212261128378539*v_R0_a_r - 0.849044513514155*v_R0_c_i - 0.212261128378539*v_R0_c_r - 127.595184532966*v_R1_a_i - 123.954122254357*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r + 23.284964480954*v_R1_c_i + 24.9575997948692*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r + 54.0657727682604*v_R2_a_i + 105.57176931318*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r - 23.284964480954*v_R2_c_i - 24.9575997948692*v_R2_c_r - 10.2713736253513*v_R2_n_i - 39.6392229058202*v_R2_n_r
        struct[0].g[1,0] = i_load_R1_a_i + i_vsc_R1_a_i + 0.212261128378539*v_R0_a_i - 0.849044513514155*v_R0_a_r - 0.212261128378539*v_R0_c_i + 0.849044513514155*v_R0_c_r - 123.954122254357*v_R1_a_i + 127.595184532966*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r + 24.9575997948692*v_R1_c_i - 23.284964480954*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r + 105.57176931318*v_R2_a_i - 54.0657727682604*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r - 24.9575997948692*v_R2_c_i + 23.284964480954*v_R2_c_r - 39.6392229058202*v_R2_n_i + 10.2713736253513*v_R2_n_r
        struct[0].g[2,0] = i_load_R1_b_r + i_vsc_R1_b_r - 0.849044513514155*v_R0_a_i - 0.212261128378539*v_R0_a_r + 0.849044513514155*v_R0_b_i + 0.212261128378539*v_R0_b_r + 10.2713736253513*v_R1_a_i + 39.6392229058202*v_R1_a_r - 127.595184532966*v_R1_b_i - 123.954122254357*v_R1_b_r + 10.2713736253513*v_R1_c_i + 39.6392229058201*v_R1_c_r + 96.8143762456598*v_R1_n_i + 43.3399527360457*v_R1_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r + 54.0657727682604*v_R2_b_i + 105.57176931318*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058201*v_R2_c_r - 23.284964480954*v_R2_n_i - 24.9575997948692*v_R2_n_r
        struct[0].g[3,0] = i_load_R1_b_i + i_vsc_R1_b_i - 0.212261128378539*v_R0_a_i + 0.849044513514155*v_R0_a_r + 0.212261128378539*v_R0_b_i - 0.849044513514155*v_R0_b_r + 39.6392229058202*v_R1_a_i - 10.2713736253513*v_R1_a_r - 123.954122254357*v_R1_b_i + 127.595184532966*v_R1_b_r + 39.6392229058201*v_R1_c_i - 10.2713736253513*v_R1_c_r + 43.3399527360457*v_R1_n_i - 96.8143762456598*v_R1_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r + 105.57176931318*v_R2_b_i - 54.0657727682604*v_R2_b_r - 39.6392229058201*v_R2_c_i + 10.2713736253513*v_R2_c_r - 24.9575997948692*v_R2_n_i + 23.284964480954*v_R2_n_r
        struct[0].g[4,0] = i_load_R1_c_r + i_vsc_R1_c_r - 0.849044513514155*v_R0_b_i - 0.212261128378539*v_R0_b_r + 0.849044513514155*v_R0_c_i + 0.212261128378539*v_R0_c_r + 23.284964480954*v_R1_a_i + 24.9575997948692*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r - 127.595184532966*v_R1_c_i - 123.954122254357*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r - 23.284964480954*v_R2_a_i - 24.9575997948692*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r + 54.0657727682604*v_R2_c_i + 105.57176931318*v_R2_c_r - 10.2713736253514*v_R2_n_i - 39.6392229058201*v_R2_n_r
        struct[0].g[5,0] = i_load_R1_c_i + i_vsc_R1_c_i - 0.212261128378539*v_R0_b_i + 0.849044513514155*v_R0_b_r + 0.212261128378539*v_R0_c_i - 0.849044513514155*v_R0_c_r + 24.9575997948692*v_R1_a_i - 23.284964480954*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r - 123.954122254357*v_R1_c_i + 127.595184532966*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r - 24.9575997948692*v_R2_a_i + 23.284964480954*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r + 105.57176931318*v_R2_c_i - 54.0657727682604*v_R2_c_r - 39.6392229058201*v_R2_n_i + 10.2713736253514*v_R2_n_r
        struct[0].g[6,0] = 83.8007853900572*v_R1_a_i + 58.0215758469966*v_R1_a_r + 96.8143762456598*v_R1_b_i + 43.3399527360457*v_R1_b_r + 83.8007853900572*v_R1_c_i + 58.0215758469966*v_R1_c_r - 274.654008062378*v_R1_n_i - 161.052161470043*v_R1_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r - 23.284964480954*v_R2_b_i - 24.9575997948692*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058202*v_R2_c_r + 54.0657727682604*v_R2_n_i + 105.57176931318*v_R2_n_r
        struct[0].g[7,0] = 58.0215758469966*v_R1_a_i - 83.8007853900572*v_R1_a_r + 43.3399527360457*v_R1_b_i - 96.8143762456598*v_R1_b_r + 58.0215758469966*v_R1_c_i - 83.8007853900572*v_R1_c_r - 161.052161470043*v_R1_n_i + 274.654008062378*v_R1_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r - 24.9575997948692*v_R2_b_i + 23.284964480954*v_R2_b_r - 39.6392229058202*v_R2_c_i + 10.2713736253513*v_R2_c_r + 105.57176931318*v_R2_n_i - 54.0657727682604*v_R2_n_r
        struct[0].g[8,0] = i_load_R11_a_r - 4.84676915585801*v_R11_a_i - 26.5300693004806*v_R11_a_r - 1.58482814504483*v_R11_b_i + 7.8946133751477*v_R11_b_r - 0.67991845328531*v_R11_c_i + 7.72144347466701*v_R11_c_r - 1.58482814504483*v_R11_n_i + 7.89461337514771*v_R11_n_r + 4.84676915585801*v_R3_a_i + 26.5300693004806*v_R3_a_r + 1.58482814504483*v_R3_b_i - 7.8946133751477*v_R3_b_r + 0.67991845328531*v_R3_c_i - 7.72144347466701*v_R3_c_r + 1.58482814504483*v_R3_n_i - 7.89461337514771*v_R3_n_r
        struct[0].g[9,0] = i_load_R11_a_i - 26.5300693004806*v_R11_a_i + 4.84676915585801*v_R11_a_r + 7.8946133751477*v_R11_b_i + 1.58482814504483*v_R11_b_r + 7.72144347466701*v_R11_c_i + 0.67991845328531*v_R11_c_r + 7.89461337514771*v_R11_n_i + 1.58482814504483*v_R11_n_r + 26.5300693004806*v_R3_a_i - 4.84676915585801*v_R3_a_r - 7.8946133751477*v_R3_b_i - 1.58482814504483*v_R3_b_r - 7.72144347466701*v_R3_c_i - 0.67991845328531*v_R3_c_r - 7.89461337514771*v_R3_n_i - 1.58482814504483*v_R3_n_r
        struct[0].g[10,0] = i_load_R11_b_r - 1.58482814504483*v_R11_a_i + 7.89461337514771*v_R11_a_r - 4.84676915585801*v_R11_b_i - 26.5300693004806*v_R11_b_r - 1.58482814504483*v_R11_c_i + 7.89461337514771*v_R11_c_r - 0.679918453285308*v_R11_n_i + 7.72144347466701*v_R11_n_r + 1.58482814504483*v_R3_a_i - 7.89461337514771*v_R3_a_r + 4.84676915585801*v_R3_b_i + 26.5300693004806*v_R3_b_r + 1.58482814504483*v_R3_c_i - 7.89461337514771*v_R3_c_r + 0.679918453285308*v_R3_n_i - 7.72144347466701*v_R3_n_r
        struct[0].g[11,0] = i_load_R11_b_i + 7.89461337514771*v_R11_a_i + 1.58482814504483*v_R11_a_r - 26.5300693004806*v_R11_b_i + 4.84676915585801*v_R11_b_r + 7.89461337514771*v_R11_c_i + 1.58482814504483*v_R11_c_r + 7.72144347466701*v_R11_n_i + 0.679918453285308*v_R11_n_r - 7.89461337514771*v_R3_a_i - 1.58482814504483*v_R3_a_r + 26.5300693004806*v_R3_b_i - 4.84676915585801*v_R3_b_r - 7.89461337514771*v_R3_c_i - 1.58482814504483*v_R3_c_r - 7.72144347466701*v_R3_n_i - 0.679918453285308*v_R3_n_r
        struct[0].g[12,0] = i_load_R11_c_r - 0.67991845328531*v_R11_a_i + 7.72144347466701*v_R11_a_r - 1.58482814504483*v_R11_b_i + 7.8946133751477*v_R11_b_r - 4.84676915585801*v_R11_c_i - 26.5300693004806*v_R11_c_r - 1.58482814504483*v_R11_n_i + 7.89461337514771*v_R11_n_r + 0.67991845328531*v_R3_a_i - 7.72144347466701*v_R3_a_r + 1.58482814504483*v_R3_b_i - 7.8946133751477*v_R3_b_r + 4.84676915585801*v_R3_c_i + 26.5300693004806*v_R3_c_r + 1.58482814504483*v_R3_n_i - 7.89461337514771*v_R3_n_r
        struct[0].g[13,0] = i_load_R11_c_i + 7.72144347466701*v_R11_a_i + 0.67991845328531*v_R11_a_r + 7.8946133751477*v_R11_b_i + 1.58482814504483*v_R11_b_r - 26.5300693004806*v_R11_c_i + 4.84676915585801*v_R11_c_r + 7.89461337514771*v_R11_n_i + 1.58482814504483*v_R11_n_r - 7.72144347466701*v_R3_a_i - 0.67991845328531*v_R3_a_r - 7.8946133751477*v_R3_b_i - 1.58482814504483*v_R3_b_r + 26.5300693004806*v_R3_c_i - 4.84676915585801*v_R3_c_r - 7.89461337514771*v_R3_n_i - 1.58482814504483*v_R3_n_r
        struct[0].g[14,0] = -1.58482814504483*v_R11_a_i + 7.89461337514771*v_R11_a_r - 0.679918453285308*v_R11_b_i + 7.72144347466701*v_R11_b_r - 1.58482814504483*v_R11_c_i + 7.89461337514771*v_R11_c_r - 4.84676915585801*v_R11_n_i - 26.5550693004806*v_R11_n_r + 1.58482814504483*v_R3_a_i - 7.89461337514771*v_R3_a_r + 0.679918453285308*v_R3_b_i - 7.72144347466701*v_R3_b_r + 1.58482814504483*v_R3_c_i - 7.89461337514771*v_R3_c_r + 4.84676915585801*v_R3_n_i + 26.5300693004806*v_R3_n_r
        struct[0].g[15,0] = 7.89461337514771*v_R11_a_i + 1.58482814504483*v_R11_a_r + 7.72144347466701*v_R11_b_i + 0.679918453285308*v_R11_b_r + 7.89461337514771*v_R11_c_i + 1.58482814504483*v_R11_c_r - 26.5550693004806*v_R11_n_i + 4.84676915585801*v_R11_n_r - 7.89461337514771*v_R3_a_i - 1.58482814504483*v_R3_a_r - 7.72144347466701*v_R3_b_i - 0.679918453285308*v_R3_b_r - 7.89461337514771*v_R3_c_i - 1.58482814504483*v_R3_c_r + 26.5300693004806*v_R3_n_i - 4.84676915585801*v_R3_n_r
        struct[0].g[16,0] = i_load_R15_a_r + 4.84676915585801*v_R14_a_i + 26.5300693004806*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 0.67991845328531*v_R14_c_i - 7.72144347466701*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r - 4.84676915585801*v_R15_a_i - 26.5300693004806*v_R15_a_r - 1.58482814504483*v_R15_b_i + 7.8946133751477*v_R15_b_r - 0.67991845328531*v_R15_c_i + 7.72144347466701*v_R15_c_r - 1.58482814504483*v_R15_n_i + 7.89461337514771*v_R15_n_r
        struct[0].g[17,0] = i_load_R15_a_i + 26.5300693004806*v_R14_a_i - 4.84676915585801*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r - 7.72144347466701*v_R14_c_i - 0.67991845328531*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r - 26.5300693004806*v_R15_a_i + 4.84676915585801*v_R15_a_r + 7.8946133751477*v_R15_b_i + 1.58482814504483*v_R15_b_r + 7.72144347466701*v_R15_c_i + 0.67991845328531*v_R15_c_r + 7.89461337514771*v_R15_n_i + 1.58482814504483*v_R15_n_r
        struct[0].g[18,0] = i_load_R15_b_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 4.84676915585801*v_R14_b_i + 26.5300693004806*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 0.679918453285308*v_R14_n_i - 7.72144347466701*v_R14_n_r - 1.58482814504483*v_R15_a_i + 7.89461337514771*v_R15_a_r - 4.84676915585801*v_R15_b_i - 26.5300693004806*v_R15_b_r - 1.58482814504483*v_R15_c_i + 7.89461337514771*v_R15_c_r - 0.679918453285308*v_R15_n_i + 7.72144347466701*v_R15_n_r
        struct[0].g[19,0] = i_load_R15_b_i - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r + 26.5300693004806*v_R14_b_i - 4.84676915585801*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r - 7.72144347466701*v_R14_n_i - 0.679918453285308*v_R14_n_r + 7.89461337514771*v_R15_a_i + 1.58482814504483*v_R15_a_r - 26.5300693004806*v_R15_b_i + 4.84676915585801*v_R15_b_r + 7.89461337514771*v_R15_c_i + 1.58482814504483*v_R15_c_r + 7.72144347466701*v_R15_n_i + 0.679918453285308*v_R15_n_r
        struct[0].g[20,0] = i_load_R15_c_r + 0.67991845328531*v_R14_a_i - 7.72144347466701*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 4.84676915585801*v_R14_c_i + 26.5300693004806*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r - 0.67991845328531*v_R15_a_i + 7.72144347466701*v_R15_a_r - 1.58482814504483*v_R15_b_i + 7.8946133751477*v_R15_b_r - 4.84676915585801*v_R15_c_i - 26.5300693004806*v_R15_c_r - 1.58482814504483*v_R15_n_i + 7.89461337514771*v_R15_n_r
        struct[0].g[21,0] = i_load_R15_c_i - 7.72144347466701*v_R14_a_i - 0.67991845328531*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r + 26.5300693004806*v_R14_c_i - 4.84676915585801*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r + 7.72144347466701*v_R15_a_i + 0.67991845328531*v_R15_a_r + 7.8946133751477*v_R15_b_i + 1.58482814504483*v_R15_b_r - 26.5300693004806*v_R15_c_i + 4.84676915585801*v_R15_c_r + 7.89461337514771*v_R15_n_i + 1.58482814504483*v_R15_n_r
        struct[0].g[22,0] = 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 0.679918453285308*v_R14_b_i - 7.72144347466701*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 4.84676915585801*v_R14_n_i + 26.5300693004806*v_R14_n_r - 1.58482814504483*v_R15_a_i + 7.89461337514771*v_R15_a_r - 0.679918453285308*v_R15_b_i + 7.72144347466701*v_R15_b_r - 1.58482814504483*v_R15_c_i + 7.89461337514771*v_R15_c_r - 4.84676915585801*v_R15_n_i - 26.5550693004806*v_R15_n_r
        struct[0].g[23,0] = -7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r - 7.72144347466701*v_R14_b_i - 0.679918453285308*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r + 26.5300693004806*v_R14_n_i - 4.84676915585801*v_R14_n_r + 7.89461337514771*v_R15_a_i + 1.58482814504483*v_R15_a_r + 7.72144347466701*v_R15_b_i + 0.679918453285308*v_R15_b_r + 7.89461337514771*v_R15_c_i + 1.58482814504483*v_R15_c_r - 26.5550693004806*v_R15_n_i + 4.84676915585801*v_R15_n_r
        struct[0].g[24,0] = i_load_R16_a_r - 5.65456401516768*v_R16_a_i - 30.9517475172273*v_R16_a_r - 1.84896616921897*v_R16_b_i + 9.21038227100566*v_R16_b_r - 0.793238195499529*v_R16_c_i + 9.00835072044485*v_R16_c_r - 1.84896616921897*v_R16_n_i + 9.21038227100566*v_R16_n_r + 5.65456401516768*v_R6_a_i + 30.9517475172273*v_R6_a_r + 1.84896616921897*v_R6_b_i - 9.21038227100566*v_R6_b_r + 0.793238195499529*v_R6_c_i - 9.00835072044485*v_R6_c_r + 1.84896616921897*v_R6_n_i - 9.21038227100566*v_R6_n_r
        struct[0].g[25,0] = i_load_R16_a_i - 30.9517475172273*v_R16_a_i + 5.65456401516768*v_R16_a_r + 9.21038227100566*v_R16_b_i + 1.84896616921897*v_R16_b_r + 9.00835072044485*v_R16_c_i + 0.793238195499529*v_R16_c_r + 9.21038227100566*v_R16_n_i + 1.84896616921897*v_R16_n_r + 30.9517475172273*v_R6_a_i - 5.65456401516768*v_R6_a_r - 9.21038227100566*v_R6_b_i - 1.84896616921897*v_R6_b_r - 9.00835072044485*v_R6_c_i - 0.793238195499529*v_R6_c_r - 9.21038227100566*v_R6_n_i - 1.84896616921897*v_R6_n_r
        struct[0].g[26,0] = i_load_R16_b_r - 1.84896616921897*v_R16_a_i + 9.21038227100566*v_R16_a_r - 5.65456401516768*v_R16_b_i - 30.9517475172273*v_R16_b_r - 1.84896616921897*v_R16_c_i + 9.21038227100566*v_R16_c_r - 0.793238195499528*v_R16_n_i + 9.00835072044485*v_R16_n_r + 1.84896616921897*v_R6_a_i - 9.21038227100566*v_R6_a_r + 5.65456401516768*v_R6_b_i + 30.9517475172273*v_R6_b_r + 1.84896616921897*v_R6_c_i - 9.21038227100566*v_R6_c_r + 0.793238195499528*v_R6_n_i - 9.00835072044485*v_R6_n_r
        struct[0].g[27,0] = i_load_R16_b_i + 9.21038227100566*v_R16_a_i + 1.84896616921897*v_R16_a_r - 30.9517475172273*v_R16_b_i + 5.65456401516768*v_R16_b_r + 9.21038227100566*v_R16_c_i + 1.84896616921897*v_R16_c_r + 9.00835072044485*v_R16_n_i + 0.793238195499528*v_R16_n_r - 9.21038227100566*v_R6_a_i - 1.84896616921897*v_R6_a_r + 30.9517475172273*v_R6_b_i - 5.65456401516768*v_R6_b_r - 9.21038227100566*v_R6_c_i - 1.84896616921897*v_R6_c_r - 9.00835072044485*v_R6_n_i - 0.793238195499528*v_R6_n_r
        struct[0].g[28,0] = i_load_R16_c_r - 0.793238195499527*v_R16_a_i + 9.00835072044484*v_R16_a_r - 1.84896616921897*v_R16_b_i + 9.21038227100566*v_R16_b_r - 5.65456401516768*v_R16_c_i - 30.9517475172273*v_R16_c_r - 1.84896616921897*v_R16_n_i + 9.21038227100566*v_R16_n_r + 0.793238195499527*v_R6_a_i - 9.00835072044484*v_R6_a_r + 1.84896616921897*v_R6_b_i - 9.21038227100566*v_R6_b_r + 5.65456401516768*v_R6_c_i + 30.9517475172273*v_R6_c_r + 1.84896616921897*v_R6_n_i - 9.21038227100566*v_R6_n_r
        struct[0].g[29,0] = i_load_R16_c_i + 9.00835072044484*v_R16_a_i + 0.793238195499527*v_R16_a_r + 9.21038227100566*v_R16_b_i + 1.84896616921897*v_R16_b_r - 30.9517475172273*v_R16_c_i + 5.65456401516768*v_R16_c_r + 9.21038227100566*v_R16_n_i + 1.84896616921897*v_R16_n_r - 9.00835072044484*v_R6_a_i - 0.793238195499527*v_R6_a_r - 9.21038227100566*v_R6_b_i - 1.84896616921897*v_R6_b_r + 30.9517475172273*v_R6_c_i - 5.65456401516768*v_R6_c_r - 9.21038227100566*v_R6_n_i - 1.84896616921897*v_R6_n_r
        struct[0].g[30,0] = -1.84896616921897*v_R16_a_i + 9.21038227100566*v_R16_a_r - 0.793238195499527*v_R16_b_i + 9.00835072044485*v_R16_b_r - 1.84896616921897*v_R16_c_i + 9.21038227100566*v_R16_c_r - 5.65456401516768*v_R16_n_i - 30.9767475172273*v_R16_n_r + 1.84896616921897*v_R6_a_i - 9.21038227100566*v_R6_a_r + 0.793238195499527*v_R6_b_i - 9.00835072044485*v_R6_b_r + 1.84896616921897*v_R6_c_i - 9.21038227100566*v_R6_c_r + 5.65456401516768*v_R6_n_i + 30.9517475172273*v_R6_n_r
        struct[0].g[31,0] = 9.21038227100566*v_R16_a_i + 1.84896616921897*v_R16_a_r + 9.00835072044485*v_R16_b_i + 0.793238195499527*v_R16_b_r + 9.21038227100566*v_R16_c_i + 1.84896616921897*v_R16_c_r - 30.9767475172273*v_R16_n_i + 5.65456401516768*v_R16_n_r - 9.21038227100566*v_R6_a_i - 1.84896616921897*v_R6_a_r - 9.00835072044485*v_R6_b_i - 0.793238195499527*v_R6_b_r - 9.21038227100566*v_R6_c_i - 1.84896616921897*v_R6_c_r + 30.9517475172273*v_R6_n_i - 5.65456401516768*v_R6_n_r
        struct[0].g[32,0] = i_load_R17_a_r - 5.65456401516768*v_R17_a_i - 30.9517475172273*v_R17_a_r - 1.84896616921897*v_R17_b_i + 9.21038227100566*v_R17_b_r - 0.793238195499529*v_R17_c_i + 9.00835072044485*v_R17_c_r - 1.84896616921897*v_R17_n_i + 9.21038227100566*v_R17_n_r + 5.65456401516768*v_R9_a_i + 30.9517475172273*v_R9_a_r + 1.84896616921897*v_R9_b_i - 9.21038227100566*v_R9_b_r + 0.793238195499529*v_R9_c_i - 9.00835072044485*v_R9_c_r + 1.84896616921897*v_R9_n_i - 9.21038227100566*v_R9_n_r
        struct[0].g[33,0] = i_load_R17_a_i - 30.9517475172273*v_R17_a_i + 5.65456401516768*v_R17_a_r + 9.21038227100566*v_R17_b_i + 1.84896616921897*v_R17_b_r + 9.00835072044485*v_R17_c_i + 0.793238195499529*v_R17_c_r + 9.21038227100566*v_R17_n_i + 1.84896616921897*v_R17_n_r + 30.9517475172273*v_R9_a_i - 5.65456401516768*v_R9_a_r - 9.21038227100566*v_R9_b_i - 1.84896616921897*v_R9_b_r - 9.00835072044485*v_R9_c_i - 0.793238195499529*v_R9_c_r - 9.21038227100566*v_R9_n_i - 1.84896616921897*v_R9_n_r
        struct[0].g[34,0] = i_load_R17_b_r - 1.84896616921897*v_R17_a_i + 9.21038227100566*v_R17_a_r - 5.65456401516768*v_R17_b_i - 30.9517475172273*v_R17_b_r - 1.84896616921897*v_R17_c_i + 9.21038227100566*v_R17_c_r - 0.793238195499528*v_R17_n_i + 9.00835072044485*v_R17_n_r + 1.84896616921897*v_R9_a_i - 9.21038227100566*v_R9_a_r + 5.65456401516768*v_R9_b_i + 30.9517475172273*v_R9_b_r + 1.84896616921897*v_R9_c_i - 9.21038227100566*v_R9_c_r + 0.793238195499528*v_R9_n_i - 9.00835072044485*v_R9_n_r
        struct[0].g[35,0] = i_load_R17_b_i + 9.21038227100566*v_R17_a_i + 1.84896616921897*v_R17_a_r - 30.9517475172273*v_R17_b_i + 5.65456401516768*v_R17_b_r + 9.21038227100566*v_R17_c_i + 1.84896616921897*v_R17_c_r + 9.00835072044485*v_R17_n_i + 0.793238195499528*v_R17_n_r - 9.21038227100566*v_R9_a_i - 1.84896616921897*v_R9_a_r + 30.9517475172273*v_R9_b_i - 5.65456401516768*v_R9_b_r - 9.21038227100566*v_R9_c_i - 1.84896616921897*v_R9_c_r - 9.00835072044485*v_R9_n_i - 0.793238195499528*v_R9_n_r
        struct[0].g[36,0] = i_load_R17_c_r - 0.793238195499527*v_R17_a_i + 9.00835072044484*v_R17_a_r - 1.84896616921897*v_R17_b_i + 9.21038227100566*v_R17_b_r - 5.65456401516768*v_R17_c_i - 30.9517475172273*v_R17_c_r - 1.84896616921897*v_R17_n_i + 9.21038227100566*v_R17_n_r + 0.793238195499527*v_R9_a_i - 9.00835072044484*v_R9_a_r + 1.84896616921897*v_R9_b_i - 9.21038227100566*v_R9_b_r + 5.65456401516768*v_R9_c_i + 30.9517475172273*v_R9_c_r + 1.84896616921897*v_R9_n_i - 9.21038227100566*v_R9_n_r
        struct[0].g[37,0] = i_load_R17_c_i + 9.00835072044484*v_R17_a_i + 0.793238195499527*v_R17_a_r + 9.21038227100566*v_R17_b_i + 1.84896616921897*v_R17_b_r - 30.9517475172273*v_R17_c_i + 5.65456401516768*v_R17_c_r + 9.21038227100566*v_R17_n_i + 1.84896616921897*v_R17_n_r - 9.00835072044484*v_R9_a_i - 0.793238195499527*v_R9_a_r - 9.21038227100566*v_R9_b_i - 1.84896616921897*v_R9_b_r + 30.9517475172273*v_R9_c_i - 5.65456401516768*v_R9_c_r - 9.21038227100566*v_R9_n_i - 1.84896616921897*v_R9_n_r
        struct[0].g[38,0] = -1.84896616921897*v_R17_a_i + 9.21038227100566*v_R17_a_r - 0.793238195499527*v_R17_b_i + 9.00835072044485*v_R17_b_r - 1.84896616921897*v_R17_c_i + 9.21038227100566*v_R17_c_r - 5.65456401516768*v_R17_n_i - 30.9767475172273*v_R17_n_r + 1.84896616921897*v_R9_a_i - 9.21038227100566*v_R9_a_r + 0.793238195499527*v_R9_b_i - 9.00835072044485*v_R9_b_r + 1.84896616921897*v_R9_c_i - 9.21038227100566*v_R9_c_r + 5.65456401516768*v_R9_n_i + 30.9517475172273*v_R9_n_r
        struct[0].g[39,0] = 9.21038227100566*v_R17_a_i + 1.84896616921897*v_R17_a_r + 9.00835072044485*v_R17_b_i + 0.793238195499527*v_R17_b_r + 9.21038227100566*v_R17_c_i + 1.84896616921897*v_R17_c_r - 30.9767475172273*v_R17_n_i + 5.65456401516768*v_R17_n_r - 9.21038227100566*v_R9_a_i - 1.84896616921897*v_R9_a_r - 9.00835072044485*v_R9_b_i - 0.793238195499527*v_R9_b_r - 9.21038227100566*v_R9_c_i - 1.84896616921897*v_R9_c_r + 30.9517475172273*v_R9_n_i - 5.65456401516768*v_R9_n_r
        struct[0].g[40,0] = i_load_R18_a_r + 5.65456401516768*v_R10_a_i + 30.9517475172273*v_R10_a_r + 1.84896616921897*v_R10_b_i - 9.21038227100566*v_R10_b_r + 0.793238195499529*v_R10_c_i - 9.00835072044485*v_R10_c_r + 1.84896616921897*v_R10_n_i - 9.21038227100566*v_R10_n_r - 5.65456401516768*v_R18_a_i - 30.9517475172273*v_R18_a_r - 1.84896616921897*v_R18_b_i + 9.21038227100566*v_R18_b_r - 0.793238195499529*v_R18_c_i + 9.00835072044485*v_R18_c_r - 1.84896616921897*v_R18_n_i + 9.21038227100566*v_R18_n_r
        struct[0].g[41,0] = i_load_R18_a_i + 30.9517475172273*v_R10_a_i - 5.65456401516768*v_R10_a_r - 9.21038227100566*v_R10_b_i - 1.84896616921897*v_R10_b_r - 9.00835072044485*v_R10_c_i - 0.793238195499529*v_R10_c_r - 9.21038227100566*v_R10_n_i - 1.84896616921897*v_R10_n_r - 30.9517475172273*v_R18_a_i + 5.65456401516768*v_R18_a_r + 9.21038227100566*v_R18_b_i + 1.84896616921897*v_R18_b_r + 9.00835072044485*v_R18_c_i + 0.793238195499529*v_R18_c_r + 9.21038227100566*v_R18_n_i + 1.84896616921897*v_R18_n_r
        struct[0].g[42,0] = i_load_R18_b_r + 1.84896616921897*v_R10_a_i - 9.21038227100566*v_R10_a_r + 5.65456401516768*v_R10_b_i + 30.9517475172273*v_R10_b_r + 1.84896616921897*v_R10_c_i - 9.21038227100566*v_R10_c_r + 0.793238195499528*v_R10_n_i - 9.00835072044485*v_R10_n_r - 1.84896616921897*v_R18_a_i + 9.21038227100566*v_R18_a_r - 5.65456401516768*v_R18_b_i - 30.9517475172273*v_R18_b_r - 1.84896616921897*v_R18_c_i + 9.21038227100566*v_R18_c_r - 0.793238195499528*v_R18_n_i + 9.00835072044485*v_R18_n_r
        struct[0].g[43,0] = i_load_R18_b_i - 9.21038227100566*v_R10_a_i - 1.84896616921897*v_R10_a_r + 30.9517475172273*v_R10_b_i - 5.65456401516768*v_R10_b_r - 9.21038227100566*v_R10_c_i - 1.84896616921897*v_R10_c_r - 9.00835072044485*v_R10_n_i - 0.793238195499528*v_R10_n_r + 9.21038227100566*v_R18_a_i + 1.84896616921897*v_R18_a_r - 30.9517475172273*v_R18_b_i + 5.65456401516768*v_R18_b_r + 9.21038227100566*v_R18_c_i + 1.84896616921897*v_R18_c_r + 9.00835072044485*v_R18_n_i + 0.793238195499528*v_R18_n_r
        struct[0].g[44,0] = i_load_R18_c_r + 0.793238195499527*v_R10_a_i - 9.00835072044484*v_R10_a_r + 1.84896616921897*v_R10_b_i - 9.21038227100566*v_R10_b_r + 5.65456401516768*v_R10_c_i + 30.9517475172273*v_R10_c_r + 1.84896616921897*v_R10_n_i - 9.21038227100566*v_R10_n_r - 0.793238195499527*v_R18_a_i + 9.00835072044484*v_R18_a_r - 1.84896616921897*v_R18_b_i + 9.21038227100566*v_R18_b_r - 5.65456401516768*v_R18_c_i - 30.9517475172273*v_R18_c_r - 1.84896616921897*v_R18_n_i + 9.21038227100566*v_R18_n_r
        struct[0].g[45,0] = i_load_R18_c_i - 9.00835072044484*v_R10_a_i - 0.793238195499527*v_R10_a_r - 9.21038227100566*v_R10_b_i - 1.84896616921897*v_R10_b_r + 30.9517475172273*v_R10_c_i - 5.65456401516768*v_R10_c_r - 9.21038227100566*v_R10_n_i - 1.84896616921897*v_R10_n_r + 9.00835072044484*v_R18_a_i + 0.793238195499527*v_R18_a_r + 9.21038227100566*v_R18_b_i + 1.84896616921897*v_R18_b_r - 30.9517475172273*v_R18_c_i + 5.65456401516768*v_R18_c_r + 9.21038227100566*v_R18_n_i + 1.84896616921897*v_R18_n_r
        struct[0].g[46,0] = 1.84896616921897*v_R10_a_i - 9.21038227100566*v_R10_a_r + 0.793238195499527*v_R10_b_i - 9.00835072044485*v_R10_b_r + 1.84896616921897*v_R10_c_i - 9.21038227100566*v_R10_c_r + 5.65456401516768*v_R10_n_i + 30.9517475172273*v_R10_n_r - 1.84896616921897*v_R18_a_i + 9.21038227100566*v_R18_a_r - 0.793238195499527*v_R18_b_i + 9.00835072044485*v_R18_b_r - 1.84896616921897*v_R18_c_i + 9.21038227100566*v_R18_c_r - 5.65456401516768*v_R18_n_i - 30.9767475172273*v_R18_n_r
        struct[0].g[47,0] = -9.21038227100566*v_R10_a_i - 1.84896616921897*v_R10_a_r - 9.00835072044485*v_R10_b_i - 0.793238195499527*v_R10_b_r - 9.21038227100566*v_R10_c_i - 1.84896616921897*v_R10_c_r + 30.9517475172273*v_R10_n_i - 5.65456401516768*v_R10_n_r + 9.21038227100566*v_R18_a_i + 1.84896616921897*v_R18_a_r + 9.00835072044485*v_R18_b_i + 0.793238195499527*v_R18_b_r + 9.21038227100566*v_R18_c_i + 1.84896616921897*v_R18_c_r - 30.9767475172273*v_R18_n_i + 5.65456401516768*v_R18_n_r
        struct[0].g[48,0] = i_load_D15_a_r + 135.4096140826*v_D14_a_r - 135.4096140826*v_D15_a_r
        struct[0].g[49,0] = i_load_D15_a_i + 135.4096140826*v_D14_a_i - 135.4096140826*v_D15_a_i
        struct[0].g[50,0] = i_load_D15_n_r + 135.4096140826*v_D14_n_r - 135.4096140826*v_D15_n_r
        struct[0].g[51,0] = i_load_D15_n_i + 135.4096140826*v_D14_n_i - 135.4096140826*v_D15_n_i
        struct[0].g[52,0] = i_load_D11_a_r - 157.977883096366*v_D11_a_r + 157.977883096366*v_D3_a_r
        struct[0].g[53,0] = i_load_D11_a_i - 157.977883096366*v_D11_a_i + 157.977883096366*v_D3_a_i
        struct[0].g[54,0] = i_load_D11_n_r - 157.977883096366*v_D11_n_r + 157.977883096366*v_D3_n_r
        struct[0].g[55,0] = i_load_D11_n_i - 157.977883096366*v_D11_n_i + 157.977883096366*v_D3_n_i
        struct[0].g[56,0] = i_load_D16_a_r - 157.977883096366*v_D16_a_r + 157.977883096366*v_D6_a_r
        struct[0].g[57,0] = i_load_D16_a_i - 157.977883096366*v_D16_a_i + 157.977883096366*v_D6_a_i
        struct[0].g[58,0] = i_load_D16_n_r - 157.977883096366*v_D16_n_r + 157.977883096366*v_D6_n_r
        struct[0].g[59,0] = i_load_D16_n_i - 157.977883096366*v_D16_n_i + 157.977883096366*v_D6_n_i
        struct[0].g[60,0] = i_load_D17_a_r - 157.977883096366*v_D17_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[61,0] = i_load_D17_a_i - 157.977883096366*v_D17_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[62,0] = i_load_D17_n_r - 157.977883096366*v_D17_n_r + 157.977883096366*v_D9_n_r
        struct[0].g[63,0] = i_load_D17_n_i - 157.977883096366*v_D17_n_i + 157.977883096366*v_D9_n_i
        struct[0].g[64,0] = i_load_D18_a_r + 157.977883096366*v_D10_a_r - 157.977883096366*v_D18_a_r
        struct[0].g[65,0] = i_load_D18_a_i + 157.977883096366*v_D10_a_i - 157.977883096366*v_D18_a_i
        struct[0].g[66,0] = i_load_D18_n_r + 157.977883096366*v_D10_n_r - 157.977883096366*v_D18_n_r
        struct[0].g[67,0] = i_load_D18_n_i + 157.977883096366*v_D10_n_i - 157.977883096366*v_D18_n_i
        struct[0].g[68,0] = 54.0657727682604*v_R1_a_i + 105.57176931318*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r - 23.284964480954*v_R1_c_i - 24.9575997948692*v_R1_c_r - 10.2713736253513*v_R1_n_i - 39.6392229058202*v_R1_n_r - 108.131545536521*v_R2_a_i - 211.14353862636*v_R2_a_r + 20.5427472507027*v_R2_b_i + 79.2784458116403*v_R2_b_r + 46.569928961908*v_R2_c_i + 49.9151995897384*v_R2_c_r + 20.5427472507027*v_R2_n_i + 79.2784458116403*v_R2_n_r + 54.0657727682604*v_R3_a_i + 105.57176931318*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r - 23.284964480954*v_R3_c_i - 24.9575997948692*v_R3_c_r - 10.2713736253513*v_R3_n_i - 39.6392229058202*v_R3_n_r
        struct[0].g[69,0] = 105.57176931318*v_R1_a_i - 54.0657727682604*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r - 24.9575997948692*v_R1_c_i + 23.284964480954*v_R1_c_r - 39.6392229058202*v_R1_n_i + 10.2713736253513*v_R1_n_r - 211.14353862636*v_R2_a_i + 108.131545536521*v_R2_a_r + 79.2784458116403*v_R2_b_i - 20.5427472507027*v_R2_b_r + 49.9151995897384*v_R2_c_i - 46.569928961908*v_R2_c_r + 79.2784458116403*v_R2_n_i - 20.5427472507027*v_R2_n_r + 105.57176931318*v_R3_a_i - 54.0657727682604*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r - 24.9575997948692*v_R3_c_i + 23.284964480954*v_R3_c_r - 39.6392229058202*v_R3_n_i + 10.2713736253513*v_R3_n_r
        struct[0].g[70,0] = -10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r + 54.0657727682604*v_R1_b_i + 105.57176931318*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058201*v_R1_c_r - 23.284964480954*v_R1_n_i - 24.9575997948692*v_R1_n_r + 20.5427472507027*v_R2_a_i + 79.2784458116403*v_R2_a_r - 108.131545536521*v_R2_b_i - 211.14353862636*v_R2_b_r + 20.5427472507027*v_R2_c_i + 79.2784458116403*v_R2_c_r + 46.569928961908*v_R2_n_i + 49.9151995897384*v_R2_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r + 54.0657727682604*v_R3_b_i + 105.57176931318*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058201*v_R3_c_r - 23.284964480954*v_R3_n_i - 24.9575997948692*v_R3_n_r
        struct[0].g[71,0] = -39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r + 105.57176931318*v_R1_b_i - 54.0657727682604*v_R1_b_r - 39.6392229058201*v_R1_c_i + 10.2713736253513*v_R1_c_r - 24.9575997948692*v_R1_n_i + 23.284964480954*v_R1_n_r + 79.2784458116403*v_R2_a_i - 20.5427472507027*v_R2_a_r - 211.14353862636*v_R2_b_i + 108.131545536521*v_R2_b_r + 79.2784458116403*v_R2_c_i - 20.5427472507027*v_R2_c_r + 49.9151995897384*v_R2_n_i - 46.569928961908*v_R2_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r + 105.57176931318*v_R3_b_i - 54.0657727682604*v_R3_b_r - 39.6392229058201*v_R3_c_i + 10.2713736253513*v_R3_c_r - 24.9575997948692*v_R3_n_i + 23.284964480954*v_R3_n_r
        struct[0].g[72,0] = -23.284964480954*v_R1_a_i - 24.9575997948692*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r + 54.0657727682604*v_R1_c_i + 105.57176931318*v_R1_c_r - 10.2713736253514*v_R1_n_i - 39.6392229058201*v_R1_n_r + 46.569928961908*v_R2_a_i + 49.9151995897384*v_R2_a_r + 20.5427472507027*v_R2_b_i + 79.2784458116404*v_R2_b_r - 108.131545536521*v_R2_c_i - 211.14353862636*v_R2_c_r + 20.5427472507027*v_R2_n_i + 79.2784458116403*v_R2_n_r - 23.284964480954*v_R3_a_i - 24.9575997948692*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r + 54.0657727682604*v_R3_c_i + 105.57176931318*v_R3_c_r - 10.2713736253514*v_R3_n_i - 39.6392229058201*v_R3_n_r
        struct[0].g[73,0] = -24.9575997948692*v_R1_a_i + 23.284964480954*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r + 105.57176931318*v_R1_c_i - 54.0657727682604*v_R1_c_r - 39.6392229058201*v_R1_n_i + 10.2713736253514*v_R1_n_r + 49.9151995897384*v_R2_a_i - 46.569928961908*v_R2_a_r + 79.2784458116404*v_R2_b_i - 20.5427472507027*v_R2_b_r - 211.14353862636*v_R2_c_i + 108.131545536521*v_R2_c_r + 79.2784458116403*v_R2_n_i - 20.5427472507027*v_R2_n_r - 24.9575997948692*v_R3_a_i + 23.284964480954*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r + 105.57176931318*v_R3_c_i - 54.0657727682604*v_R3_c_r - 39.6392229058201*v_R3_n_i + 10.2713736253514*v_R3_n_r
        struct[0].g[74,0] = -10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r - 23.284964480954*v_R1_b_i - 24.9575997948692*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058202*v_R1_c_r + 54.0657727682604*v_R1_n_i + 105.57176931318*v_R1_n_r + 20.5427472507027*v_R2_a_i + 79.2784458116403*v_R2_a_r + 46.569928961908*v_R2_b_i + 49.9151995897384*v_R2_b_r + 20.5427472507027*v_R2_c_i + 79.2784458116403*v_R2_c_r - 108.131545536521*v_R2_n_i - 211.16853862636*v_R2_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r - 23.284964480954*v_R3_b_i - 24.9575997948692*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058202*v_R3_c_r + 54.0657727682604*v_R3_n_i + 105.57176931318*v_R3_n_r
        struct[0].g[75,0] = -39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r - 24.9575997948692*v_R1_b_i + 23.284964480954*v_R1_b_r - 39.6392229058202*v_R1_c_i + 10.2713736253513*v_R1_c_r + 105.57176931318*v_R1_n_i - 54.0657727682604*v_R1_n_r + 79.2784458116403*v_R2_a_i - 20.5427472507027*v_R2_a_r + 49.9151995897384*v_R2_b_i - 46.569928961908*v_R2_b_r + 79.2784458116403*v_R2_c_i - 20.5427472507027*v_R2_c_r - 211.16853862636*v_R2_n_i + 108.131545536521*v_R2_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r - 24.9575997948692*v_R3_b_i + 23.284964480954*v_R3_b_r - 39.6392229058202*v_R3_c_i + 10.2713736253513*v_R3_c_r + 105.57176931318*v_R3_n_i - 54.0657727682604*v_R3_n_r
        struct[0].g[76,0] = 4.84676915585801*v_R11_a_i + 26.5300693004806*v_R11_a_r + 1.58482814504483*v_R11_b_i - 7.8946133751477*v_R11_b_r + 0.67991845328531*v_R11_c_i - 7.72144347466701*v_R11_c_r + 1.58482814504483*v_R11_n_i - 7.89461337514771*v_R11_n_r + 54.0657727682604*v_R2_a_i + 105.57176931318*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r - 23.284964480954*v_R2_c_i - 24.9575997948692*v_R2_c_r - 10.2713736253513*v_R2_n_i - 39.6392229058202*v_R2_n_r - 112.978314692379*v_R3_a_i - 237.673607926841*v_R3_a_r + 18.9579191056578*v_R3_b_i + 87.173059186788*v_R3_b_r + 45.8900105086227*v_R3_c_i + 57.6366430644055*v_R3_c_r + 18.9579191056579*v_R3_n_i + 87.173059186788*v_R3_n_r + 54.0657727682604*v_R4_a_i + 105.57176931318*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r - 23.284964480954*v_R4_c_i - 24.9575997948692*v_R4_c_r - 10.2713736253513*v_R4_n_i - 39.6392229058202*v_R4_n_r
        struct[0].g[77,0] = 26.5300693004806*v_R11_a_i - 4.84676915585801*v_R11_a_r - 7.8946133751477*v_R11_b_i - 1.58482814504483*v_R11_b_r - 7.72144347466701*v_R11_c_i - 0.67991845328531*v_R11_c_r - 7.89461337514771*v_R11_n_i - 1.58482814504483*v_R11_n_r + 105.57176931318*v_R2_a_i - 54.0657727682604*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r - 24.9575997948692*v_R2_c_i + 23.284964480954*v_R2_c_r - 39.6392229058202*v_R2_n_i + 10.2713736253513*v_R2_n_r - 237.673607926841*v_R3_a_i + 112.978314692379*v_R3_a_r + 87.173059186788*v_R3_b_i - 18.9579191056578*v_R3_b_r + 57.6366430644055*v_R3_c_i - 45.8900105086227*v_R3_c_r + 87.173059186788*v_R3_n_i - 18.9579191056579*v_R3_n_r + 105.57176931318*v_R4_a_i - 54.0657727682604*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r - 24.9575997948692*v_R4_c_i + 23.284964480954*v_R4_c_r - 39.6392229058202*v_R4_n_i + 10.2713736253513*v_R4_n_r
        struct[0].g[78,0] = 1.58482814504483*v_R11_a_i - 7.89461337514771*v_R11_a_r + 4.84676915585801*v_R11_b_i + 26.5300693004806*v_R11_b_r + 1.58482814504483*v_R11_c_i - 7.89461337514771*v_R11_c_r + 0.679918453285308*v_R11_n_i - 7.72144347466701*v_R11_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r + 54.0657727682604*v_R2_b_i + 105.57176931318*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058201*v_R2_c_r - 23.284964480954*v_R2_n_i - 24.9575997948692*v_R2_n_r + 18.9579191056579*v_R3_a_i + 87.173059186788*v_R3_a_r - 112.978314692379*v_R3_b_i - 237.673607926841*v_R3_b_r + 18.9579191056579*v_R3_c_i + 87.173059186788*v_R3_c_r + 45.8900105086227*v_R3_n_i + 57.6366430644054*v_R3_n_r - 10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r + 54.0657727682604*v_R4_b_i + 105.57176931318*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058201*v_R4_c_r - 23.284964480954*v_R4_n_i - 24.9575997948692*v_R4_n_r
        struct[0].g[79,0] = -7.89461337514771*v_R11_a_i - 1.58482814504483*v_R11_a_r + 26.5300693004806*v_R11_b_i - 4.84676915585801*v_R11_b_r - 7.89461337514771*v_R11_c_i - 1.58482814504483*v_R11_c_r - 7.72144347466701*v_R11_n_i - 0.679918453285308*v_R11_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r + 105.57176931318*v_R2_b_i - 54.0657727682604*v_R2_b_r - 39.6392229058201*v_R2_c_i + 10.2713736253513*v_R2_c_r - 24.9575997948692*v_R2_n_i + 23.284964480954*v_R2_n_r + 87.173059186788*v_R3_a_i - 18.9579191056579*v_R3_a_r - 237.673607926841*v_R3_b_i + 112.978314692379*v_R3_b_r + 87.173059186788*v_R3_c_i - 18.9579191056579*v_R3_c_r + 57.6366430644054*v_R3_n_i - 45.8900105086227*v_R3_n_r - 39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r + 105.57176931318*v_R4_b_i - 54.0657727682604*v_R4_b_r - 39.6392229058201*v_R4_c_i + 10.2713736253513*v_R4_c_r - 24.9575997948692*v_R4_n_i + 23.284964480954*v_R4_n_r
        struct[0].g[80,0] = 0.67991845328531*v_R11_a_i - 7.72144347466701*v_R11_a_r + 1.58482814504483*v_R11_b_i - 7.8946133751477*v_R11_b_r + 4.84676915585801*v_R11_c_i + 26.5300693004806*v_R11_c_r + 1.58482814504483*v_R11_n_i - 7.89461337514771*v_R11_n_r - 23.284964480954*v_R2_a_i - 24.9575997948692*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r + 54.0657727682604*v_R2_c_i + 105.57176931318*v_R2_c_r - 10.2713736253514*v_R2_n_i - 39.6392229058201*v_R2_n_r + 45.8900105086227*v_R3_a_i + 57.6366430644054*v_R3_a_r + 18.9579191056578*v_R3_b_i + 87.1730591867881*v_R3_b_r - 112.978314692379*v_R3_c_i - 237.673607926841*v_R3_c_r + 18.9579191056579*v_R3_n_i + 87.173059186788*v_R3_n_r - 23.284964480954*v_R4_a_i - 24.9575997948692*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r + 54.0657727682604*v_R4_c_i + 105.57176931318*v_R4_c_r - 10.2713736253514*v_R4_n_i - 39.6392229058201*v_R4_n_r
        struct[0].g[81,0] = -7.72144347466701*v_R11_a_i - 0.67991845328531*v_R11_a_r - 7.8946133751477*v_R11_b_i - 1.58482814504483*v_R11_b_r + 26.5300693004806*v_R11_c_i - 4.84676915585801*v_R11_c_r - 7.89461337514771*v_R11_n_i - 1.58482814504483*v_R11_n_r - 24.9575997948692*v_R2_a_i + 23.284964480954*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r + 105.57176931318*v_R2_c_i - 54.0657727682604*v_R2_c_r - 39.6392229058201*v_R2_n_i + 10.2713736253514*v_R2_n_r + 57.6366430644054*v_R3_a_i - 45.8900105086227*v_R3_a_r + 87.1730591867881*v_R3_b_i - 18.9579191056578*v_R3_b_r - 237.673607926841*v_R3_c_i + 112.978314692379*v_R3_c_r + 87.173059186788*v_R3_n_i - 18.9579191056579*v_R3_n_r - 24.9575997948692*v_R4_a_i + 23.284964480954*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r + 105.57176931318*v_R4_c_i - 54.0657727682604*v_R4_c_r - 39.6392229058201*v_R4_n_i + 10.2713736253514*v_R4_n_r
        struct[0].g[82,0] = 1.58482814504483*v_R11_a_i - 7.89461337514771*v_R11_a_r + 0.679918453285308*v_R11_b_i - 7.72144347466701*v_R11_b_r + 1.58482814504483*v_R11_c_i - 7.89461337514771*v_R11_c_r + 4.84676915585801*v_R11_n_i + 26.5300693004806*v_R11_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r - 23.284964480954*v_R2_b_i - 24.9575997948692*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058202*v_R2_c_r + 54.0657727682604*v_R2_n_i + 105.57176931318*v_R2_n_r + 18.9579191056578*v_R3_a_i + 87.173059186788*v_R3_a_r + 45.8900105086227*v_R3_b_i + 57.6366430644054*v_R3_b_r + 18.9579191056579*v_R3_c_i + 87.173059186788*v_R3_c_r - 112.978314692379*v_R3_n_i - 237.673607926841*v_R3_n_r - 10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r - 23.284964480954*v_R4_b_i - 24.9575997948692*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058202*v_R4_c_r + 54.0657727682604*v_R4_n_i + 105.57176931318*v_R4_n_r
        struct[0].g[83,0] = -7.89461337514771*v_R11_a_i - 1.58482814504483*v_R11_a_r - 7.72144347466701*v_R11_b_i - 0.679918453285308*v_R11_b_r - 7.89461337514771*v_R11_c_i - 1.58482814504483*v_R11_c_r + 26.5300693004806*v_R11_n_i - 4.84676915585801*v_R11_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r - 24.9575997948692*v_R2_b_i + 23.284964480954*v_R2_b_r - 39.6392229058202*v_R2_c_i + 10.2713736253513*v_R2_c_r + 105.57176931318*v_R2_n_i - 54.0657727682604*v_R2_n_r + 87.173059186788*v_R3_a_i - 18.9579191056578*v_R3_a_r + 57.6366430644054*v_R3_b_i - 45.8900105086227*v_R3_b_r + 87.173059186788*v_R3_c_i - 18.9579191056579*v_R3_c_r - 237.673607926841*v_R3_n_i + 112.978314692379*v_R3_n_r - 39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r - 24.9575997948692*v_R4_b_i + 23.284964480954*v_R4_b_r - 39.6392229058202*v_R4_c_i + 10.2713736253513*v_R4_c_r + 105.57176931318*v_R4_n_i - 54.0657727682604*v_R4_n_r
        struct[0].g[84,0] = 4.84676915585801*v_R12_a_i + 26.5300693004806*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 0.67991845328531*v_R12_c_i - 7.72144347466701*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r + 54.0657727682604*v_R3_a_i + 105.57176931318*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r - 23.284964480954*v_R3_c_i - 24.9575997948692*v_R3_c_r - 10.2713736253513*v_R3_n_i - 39.6392229058202*v_R3_n_r - 112.978314692379*v_R4_a_i - 237.673607926841*v_R4_a_r + 18.9579191056578*v_R4_b_i + 87.173059186788*v_R4_b_r + 45.8900105086227*v_R4_c_i + 57.6366430644055*v_R4_c_r + 18.9579191056579*v_R4_n_i + 87.173059186788*v_R4_n_r + 54.0657727682604*v_R5_a_i + 105.57176931318*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r - 23.284964480954*v_R5_c_i - 24.9575997948692*v_R5_c_r - 10.2713736253513*v_R5_n_i - 39.6392229058202*v_R5_n_r
        struct[0].g[85,0] = 26.5300693004806*v_R12_a_i - 4.84676915585801*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r - 7.72144347466701*v_R12_c_i - 0.67991845328531*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r + 105.57176931318*v_R3_a_i - 54.0657727682604*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r - 24.9575997948692*v_R3_c_i + 23.284964480954*v_R3_c_r - 39.6392229058202*v_R3_n_i + 10.2713736253513*v_R3_n_r - 237.673607926841*v_R4_a_i + 112.978314692379*v_R4_a_r + 87.173059186788*v_R4_b_i - 18.9579191056578*v_R4_b_r + 57.6366430644055*v_R4_c_i - 45.8900105086227*v_R4_c_r + 87.173059186788*v_R4_n_i - 18.9579191056579*v_R4_n_r + 105.57176931318*v_R5_a_i - 54.0657727682604*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r - 24.9575997948692*v_R5_c_i + 23.284964480954*v_R5_c_r - 39.6392229058202*v_R5_n_i + 10.2713736253513*v_R5_n_r
        struct[0].g[86,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 4.84676915585801*v_R12_b_i + 26.5300693004806*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 0.679918453285308*v_R12_n_i - 7.72144347466701*v_R12_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r + 54.0657727682604*v_R3_b_i + 105.57176931318*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058201*v_R3_c_r - 23.284964480954*v_R3_n_i - 24.9575997948692*v_R3_n_r + 18.9579191056579*v_R4_a_i + 87.173059186788*v_R4_a_r - 112.978314692379*v_R4_b_i - 237.673607926841*v_R4_b_r + 18.9579191056579*v_R4_c_i + 87.173059186788*v_R4_c_r + 45.8900105086227*v_R4_n_i + 57.6366430644054*v_R4_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r + 54.0657727682604*v_R5_b_i + 105.57176931318*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058201*v_R5_c_r - 23.284964480954*v_R5_n_i - 24.9575997948692*v_R5_n_r
        struct[0].g[87,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r + 26.5300693004806*v_R12_b_i - 4.84676915585801*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r - 7.72144347466701*v_R12_n_i - 0.679918453285308*v_R12_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r + 105.57176931318*v_R3_b_i - 54.0657727682604*v_R3_b_r - 39.6392229058201*v_R3_c_i + 10.2713736253513*v_R3_c_r - 24.9575997948692*v_R3_n_i + 23.284964480954*v_R3_n_r + 87.173059186788*v_R4_a_i - 18.9579191056579*v_R4_a_r - 237.673607926841*v_R4_b_i + 112.978314692379*v_R4_b_r + 87.173059186788*v_R4_c_i - 18.9579191056579*v_R4_c_r + 57.6366430644054*v_R4_n_i - 45.8900105086227*v_R4_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r + 105.57176931318*v_R5_b_i - 54.0657727682604*v_R5_b_r - 39.6392229058201*v_R5_c_i + 10.2713736253513*v_R5_c_r - 24.9575997948692*v_R5_n_i + 23.284964480954*v_R5_n_r
        struct[0].g[88,0] = 0.67991845328531*v_R12_a_i - 7.72144347466701*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 4.84676915585801*v_R12_c_i + 26.5300693004806*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 23.284964480954*v_R3_a_i - 24.9575997948692*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r + 54.0657727682604*v_R3_c_i + 105.57176931318*v_R3_c_r - 10.2713736253514*v_R3_n_i - 39.6392229058201*v_R3_n_r + 45.8900105086227*v_R4_a_i + 57.6366430644054*v_R4_a_r + 18.9579191056578*v_R4_b_i + 87.1730591867881*v_R4_b_r - 112.978314692379*v_R4_c_i - 237.673607926841*v_R4_c_r + 18.9579191056579*v_R4_n_i + 87.173059186788*v_R4_n_r - 23.284964480954*v_R5_a_i - 24.9575997948692*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r + 54.0657727682604*v_R5_c_i + 105.57176931318*v_R5_c_r - 10.2713736253514*v_R5_n_i - 39.6392229058201*v_R5_n_r
        struct[0].g[89,0] = -7.72144347466701*v_R12_a_i - 0.67991845328531*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r + 26.5300693004806*v_R12_c_i - 4.84676915585801*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r - 24.9575997948692*v_R3_a_i + 23.284964480954*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r + 105.57176931318*v_R3_c_i - 54.0657727682604*v_R3_c_r - 39.6392229058201*v_R3_n_i + 10.2713736253514*v_R3_n_r + 57.6366430644054*v_R4_a_i - 45.8900105086227*v_R4_a_r + 87.1730591867881*v_R4_b_i - 18.9579191056578*v_R4_b_r - 237.673607926841*v_R4_c_i + 112.978314692379*v_R4_c_r + 87.173059186788*v_R4_n_i - 18.9579191056579*v_R4_n_r - 24.9575997948692*v_R5_a_i + 23.284964480954*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r + 105.57176931318*v_R5_c_i - 54.0657727682604*v_R5_c_r - 39.6392229058201*v_R5_n_i + 10.2713736253514*v_R5_n_r
        struct[0].g[90,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 0.679918453285308*v_R12_b_i - 7.72144347466701*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 4.84676915585801*v_R12_n_i + 26.5300693004806*v_R12_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r - 23.284964480954*v_R3_b_i - 24.9575997948692*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058202*v_R3_c_r + 54.0657727682604*v_R3_n_i + 105.57176931318*v_R3_n_r + 18.9579191056578*v_R4_a_i + 87.173059186788*v_R4_a_r + 45.8900105086227*v_R4_b_i + 57.6366430644054*v_R4_b_r + 18.9579191056579*v_R4_c_i + 87.173059186788*v_R4_c_r - 112.978314692379*v_R4_n_i - 237.698607926841*v_R4_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r - 23.284964480954*v_R5_b_i - 24.9575997948692*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058202*v_R5_c_r + 54.0657727682604*v_R5_n_i + 105.57176931318*v_R5_n_r
        struct[0].g[91,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r - 7.72144347466701*v_R12_b_i - 0.679918453285308*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r + 26.5300693004806*v_R12_n_i - 4.84676915585801*v_R12_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r - 24.9575997948692*v_R3_b_i + 23.284964480954*v_R3_b_r - 39.6392229058202*v_R3_c_i + 10.2713736253513*v_R3_c_r + 105.57176931318*v_R3_n_i - 54.0657727682604*v_R3_n_r + 87.173059186788*v_R4_a_i - 18.9579191056578*v_R4_a_r + 57.6366430644054*v_R4_b_i - 45.8900105086227*v_R4_b_r + 87.173059186788*v_R4_c_i - 18.9579191056579*v_R4_c_r - 237.698607926841*v_R4_n_i + 112.978314692379*v_R4_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r - 24.9575997948692*v_R5_b_i + 23.284964480954*v_R5_b_r - 39.6392229058202*v_R5_c_i + 10.2713736253513*v_R5_c_r + 105.57176931318*v_R5_n_i - 54.0657727682604*v_R5_n_r
        struct[0].g[92,0] = 54.0657727682604*v_R4_a_i + 105.57176931318*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r - 23.284964480954*v_R4_c_i - 24.9575997948692*v_R4_c_r - 10.2713736253513*v_R4_n_i - 39.6392229058202*v_R4_n_r - 108.131545536521*v_R5_a_i - 211.14353862636*v_R5_a_r + 20.5427472507027*v_R5_b_i + 79.2784458116403*v_R5_b_r + 46.569928961908*v_R5_c_i + 49.9151995897384*v_R5_c_r + 20.5427472507027*v_R5_n_i + 79.2784458116403*v_R5_n_r + 54.0657727682604*v_R6_a_i + 105.57176931318*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r - 23.284964480954*v_R6_c_i - 24.9575997948692*v_R6_c_r - 10.2713736253513*v_R6_n_i - 39.6392229058202*v_R6_n_r
        struct[0].g[93,0] = 105.57176931318*v_R4_a_i - 54.0657727682604*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r - 24.9575997948692*v_R4_c_i + 23.284964480954*v_R4_c_r - 39.6392229058202*v_R4_n_i + 10.2713736253513*v_R4_n_r - 211.14353862636*v_R5_a_i + 108.131545536521*v_R5_a_r + 79.2784458116403*v_R5_b_i - 20.5427472507027*v_R5_b_r + 49.9151995897384*v_R5_c_i - 46.569928961908*v_R5_c_r + 79.2784458116403*v_R5_n_i - 20.5427472507027*v_R5_n_r + 105.57176931318*v_R6_a_i - 54.0657727682604*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r - 24.9575997948692*v_R6_c_i + 23.284964480954*v_R6_c_r - 39.6392229058202*v_R6_n_i + 10.2713736253513*v_R6_n_r
        struct[0].g[94,0] = -10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r + 54.0657727682604*v_R4_b_i + 105.57176931318*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058201*v_R4_c_r - 23.284964480954*v_R4_n_i - 24.9575997948692*v_R4_n_r + 20.5427472507027*v_R5_a_i + 79.2784458116403*v_R5_a_r - 108.131545536521*v_R5_b_i - 211.14353862636*v_R5_b_r + 20.5427472507027*v_R5_c_i + 79.2784458116403*v_R5_c_r + 46.569928961908*v_R5_n_i + 49.9151995897384*v_R5_n_r - 10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r + 54.0657727682604*v_R6_b_i + 105.57176931318*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058201*v_R6_c_r - 23.284964480954*v_R6_n_i - 24.9575997948692*v_R6_n_r
        struct[0].g[95,0] = -39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r + 105.57176931318*v_R4_b_i - 54.0657727682604*v_R4_b_r - 39.6392229058201*v_R4_c_i + 10.2713736253513*v_R4_c_r - 24.9575997948692*v_R4_n_i + 23.284964480954*v_R4_n_r + 79.2784458116403*v_R5_a_i - 20.5427472507027*v_R5_a_r - 211.14353862636*v_R5_b_i + 108.131545536521*v_R5_b_r + 79.2784458116403*v_R5_c_i - 20.5427472507027*v_R5_c_r + 49.9151995897384*v_R5_n_i - 46.569928961908*v_R5_n_r - 39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r + 105.57176931318*v_R6_b_i - 54.0657727682604*v_R6_b_r - 39.6392229058201*v_R6_c_i + 10.2713736253513*v_R6_c_r - 24.9575997948692*v_R6_n_i + 23.284964480954*v_R6_n_r
        struct[0].g[96,0] = -23.284964480954*v_R4_a_i - 24.9575997948692*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r + 54.0657727682604*v_R4_c_i + 105.57176931318*v_R4_c_r - 10.2713736253514*v_R4_n_i - 39.6392229058201*v_R4_n_r + 46.569928961908*v_R5_a_i + 49.9151995897384*v_R5_a_r + 20.5427472507027*v_R5_b_i + 79.2784458116404*v_R5_b_r - 108.131545536521*v_R5_c_i - 211.14353862636*v_R5_c_r + 20.5427472507027*v_R5_n_i + 79.2784458116403*v_R5_n_r - 23.284964480954*v_R6_a_i - 24.9575997948692*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r + 54.0657727682604*v_R6_c_i + 105.57176931318*v_R6_c_r - 10.2713736253514*v_R6_n_i - 39.6392229058201*v_R6_n_r
        struct[0].g[97,0] = -24.9575997948692*v_R4_a_i + 23.284964480954*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r + 105.57176931318*v_R4_c_i - 54.0657727682604*v_R4_c_r - 39.6392229058201*v_R4_n_i + 10.2713736253514*v_R4_n_r + 49.9151995897384*v_R5_a_i - 46.569928961908*v_R5_a_r + 79.2784458116404*v_R5_b_i - 20.5427472507027*v_R5_b_r - 211.14353862636*v_R5_c_i + 108.131545536521*v_R5_c_r + 79.2784458116403*v_R5_n_i - 20.5427472507027*v_R5_n_r - 24.9575997948692*v_R6_a_i + 23.284964480954*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r + 105.57176931318*v_R6_c_i - 54.0657727682604*v_R6_c_r - 39.6392229058201*v_R6_n_i + 10.2713736253514*v_R6_n_r
        struct[0].g[98,0] = -10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r - 23.284964480954*v_R4_b_i - 24.9575997948692*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058202*v_R4_c_r + 54.0657727682604*v_R4_n_i + 105.57176931318*v_R4_n_r + 20.5427472507027*v_R5_a_i + 79.2784458116403*v_R5_a_r + 46.569928961908*v_R5_b_i + 49.9151995897384*v_R5_b_r + 20.5427472507027*v_R5_c_i + 79.2784458116403*v_R5_c_r - 108.131545536521*v_R5_n_i - 211.14353862636*v_R5_n_r - 10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r - 23.284964480954*v_R6_b_i - 24.9575997948692*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058202*v_R6_c_r + 54.0657727682604*v_R6_n_i + 105.57176931318*v_R6_n_r
        struct[0].g[99,0] = -39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r - 24.9575997948692*v_R4_b_i + 23.284964480954*v_R4_b_r - 39.6392229058202*v_R4_c_i + 10.2713736253513*v_R4_c_r + 105.57176931318*v_R4_n_i - 54.0657727682604*v_R4_n_r + 79.2784458116403*v_R5_a_i - 20.5427472507027*v_R5_a_r + 49.9151995897384*v_R5_b_i - 46.569928961908*v_R5_b_r + 79.2784458116403*v_R5_c_i - 20.5427472507027*v_R5_c_r - 211.14353862636*v_R5_n_i + 108.131545536521*v_R5_n_r - 39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r - 24.9575997948692*v_R6_b_i + 23.284964480954*v_R6_b_r - 39.6392229058202*v_R6_c_i + 10.2713736253513*v_R6_c_r + 105.57176931318*v_R6_n_i - 54.0657727682604*v_R6_n_r
        struct[0].g[100,0] = 5.65456401516768*v_R16_a_i + 30.9517475172273*v_R16_a_r + 1.84896616921897*v_R16_b_i - 9.21038227100566*v_R16_b_r + 0.793238195499529*v_R16_c_i - 9.00835072044485*v_R16_c_r + 1.84896616921897*v_R16_n_i - 9.21038227100566*v_R16_n_r + 54.0657727682604*v_R5_a_i + 105.57176931318*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r - 23.284964480954*v_R5_c_i - 24.9575997948692*v_R5_c_r - 10.2713736253513*v_R5_n_i - 39.6392229058202*v_R5_n_r - 113.786109551688*v_R6_a_i - 242.095286143588*v_R6_a_r + 18.6937810814837*v_R6_b_i + 88.488828082646*v_R6_b_r + 45.7766907664085*v_R6_c_i + 58.9235503101833*v_R6_c_r + 18.6937810814837*v_R6_n_i + 88.488828082646*v_R6_n_r + 54.0657727682604*v_R7_a_i + 105.57176931318*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r - 23.284964480954*v_R7_c_i - 24.9575997948692*v_R7_c_r - 10.2713736253513*v_R7_n_i - 39.6392229058202*v_R7_n_r
        struct[0].g[101,0] = 30.9517475172273*v_R16_a_i - 5.65456401516768*v_R16_a_r - 9.21038227100566*v_R16_b_i - 1.84896616921897*v_R16_b_r - 9.00835072044485*v_R16_c_i - 0.793238195499529*v_R16_c_r - 9.21038227100566*v_R16_n_i - 1.84896616921897*v_R16_n_r + 105.57176931318*v_R5_a_i - 54.0657727682604*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r - 24.9575997948692*v_R5_c_i + 23.284964480954*v_R5_c_r - 39.6392229058202*v_R5_n_i + 10.2713736253513*v_R5_n_r - 242.095286143588*v_R6_a_i + 113.786109551688*v_R6_a_r + 88.488828082646*v_R6_b_i - 18.6937810814837*v_R6_b_r + 58.9235503101833*v_R6_c_i - 45.7766907664085*v_R6_c_r + 88.488828082646*v_R6_n_i - 18.6937810814837*v_R6_n_r + 105.57176931318*v_R7_a_i - 54.0657727682604*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r - 24.9575997948692*v_R7_c_i + 23.284964480954*v_R7_c_r - 39.6392229058202*v_R7_n_i + 10.2713736253513*v_R7_n_r
        struct[0].g[102,0] = 1.84896616921897*v_R16_a_i - 9.21038227100566*v_R16_a_r + 5.65456401516768*v_R16_b_i + 30.9517475172273*v_R16_b_r + 1.84896616921897*v_R16_c_i - 9.21038227100566*v_R16_c_r + 0.793238195499528*v_R16_n_i - 9.00835072044485*v_R16_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r + 54.0657727682604*v_R5_b_i + 105.57176931318*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058201*v_R5_c_r - 23.284964480954*v_R5_n_i - 24.9575997948692*v_R5_n_r + 18.6937810814837*v_R6_a_i + 88.488828082646*v_R6_a_r - 113.786109551688*v_R6_b_i - 242.095286143588*v_R6_b_r + 18.6937810814837*v_R6_c_i + 88.488828082646*v_R6_c_r + 45.7766907664085*v_R6_n_i + 58.9235503101833*v_R6_n_r - 10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r + 54.0657727682604*v_R7_b_i + 105.57176931318*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058201*v_R7_c_r - 23.284964480954*v_R7_n_i - 24.9575997948692*v_R7_n_r
        struct[0].g[103,0] = -9.21038227100566*v_R16_a_i - 1.84896616921897*v_R16_a_r + 30.9517475172273*v_R16_b_i - 5.65456401516768*v_R16_b_r - 9.21038227100566*v_R16_c_i - 1.84896616921897*v_R16_c_r - 9.00835072044485*v_R16_n_i - 0.793238195499528*v_R16_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r + 105.57176931318*v_R5_b_i - 54.0657727682604*v_R5_b_r - 39.6392229058201*v_R5_c_i + 10.2713736253513*v_R5_c_r - 24.9575997948692*v_R5_n_i + 23.284964480954*v_R5_n_r + 88.488828082646*v_R6_a_i - 18.6937810814837*v_R6_a_r - 242.095286143588*v_R6_b_i + 113.786109551688*v_R6_b_r + 88.488828082646*v_R6_c_i - 18.6937810814837*v_R6_c_r + 58.9235503101833*v_R6_n_i - 45.7766907664085*v_R6_n_r - 39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r + 105.57176931318*v_R7_b_i - 54.0657727682604*v_R7_b_r - 39.6392229058201*v_R7_c_i + 10.2713736253513*v_R7_c_r - 24.9575997948692*v_R7_n_i + 23.284964480954*v_R7_n_r
        struct[0].g[104,0] = 0.793238195499527*v_R16_a_i - 9.00835072044484*v_R16_a_r + 1.84896616921897*v_R16_b_i - 9.21038227100566*v_R16_b_r + 5.65456401516768*v_R16_c_i + 30.9517475172273*v_R16_c_r + 1.84896616921897*v_R16_n_i - 9.21038227100566*v_R16_n_r - 23.284964480954*v_R5_a_i - 24.9575997948692*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r + 54.0657727682604*v_R5_c_i + 105.57176931318*v_R5_c_r - 10.2713736253514*v_R5_n_i - 39.6392229058201*v_R5_n_r + 45.7766907664085*v_R6_a_i + 58.9235503101833*v_R6_a_r + 18.6937810814837*v_R6_b_i + 88.4888280826461*v_R6_b_r - 113.786109551688*v_R6_c_i - 242.095286143588*v_R6_c_r + 18.6937810814837*v_R6_n_i + 88.4888280826459*v_R6_n_r - 23.284964480954*v_R7_a_i - 24.9575997948692*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r + 54.0657727682604*v_R7_c_i + 105.57176931318*v_R7_c_r - 10.2713736253514*v_R7_n_i - 39.6392229058201*v_R7_n_r
        struct[0].g[105,0] = -9.00835072044484*v_R16_a_i - 0.793238195499527*v_R16_a_r - 9.21038227100566*v_R16_b_i - 1.84896616921897*v_R16_b_r + 30.9517475172273*v_R16_c_i - 5.65456401516768*v_R16_c_r - 9.21038227100566*v_R16_n_i - 1.84896616921897*v_R16_n_r - 24.9575997948692*v_R5_a_i + 23.284964480954*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r + 105.57176931318*v_R5_c_i - 54.0657727682604*v_R5_c_r - 39.6392229058201*v_R5_n_i + 10.2713736253514*v_R5_n_r + 58.9235503101833*v_R6_a_i - 45.7766907664085*v_R6_a_r + 88.4888280826461*v_R6_b_i - 18.6937810814837*v_R6_b_r - 242.095286143588*v_R6_c_i + 113.786109551688*v_R6_c_r + 88.4888280826459*v_R6_n_i - 18.6937810814837*v_R6_n_r - 24.9575997948692*v_R7_a_i + 23.284964480954*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r + 105.57176931318*v_R7_c_i - 54.0657727682604*v_R7_c_r - 39.6392229058201*v_R7_n_i + 10.2713736253514*v_R7_n_r
        struct[0].g[106,0] = 1.84896616921897*v_R16_a_i - 9.21038227100566*v_R16_a_r + 0.793238195499527*v_R16_b_i - 9.00835072044485*v_R16_b_r + 1.84896616921897*v_R16_c_i - 9.21038227100566*v_R16_c_r + 5.65456401516768*v_R16_n_i + 30.9517475172273*v_R16_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r - 23.284964480954*v_R5_b_i - 24.9575997948692*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058202*v_R5_c_r + 54.0657727682604*v_R5_n_i + 105.57176931318*v_R5_n_r + 18.6937810814837*v_R6_a_i + 88.488828082646*v_R6_a_r + 45.7766907664085*v_R6_b_i + 58.9235503101832*v_R6_b_r + 18.6937810814837*v_R6_c_i + 88.488828082646*v_R6_c_r - 113.786109551688*v_R6_n_i - 242.120286143588*v_R6_n_r - 10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r - 23.284964480954*v_R7_b_i - 24.9575997948692*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058202*v_R7_c_r + 54.0657727682604*v_R7_n_i + 105.57176931318*v_R7_n_r
        struct[0].g[107,0] = -9.21038227100566*v_R16_a_i - 1.84896616921897*v_R16_a_r - 9.00835072044485*v_R16_b_i - 0.793238195499527*v_R16_b_r - 9.21038227100566*v_R16_c_i - 1.84896616921897*v_R16_c_r + 30.9517475172273*v_R16_n_i - 5.65456401516768*v_R16_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r - 24.9575997948692*v_R5_b_i + 23.284964480954*v_R5_b_r - 39.6392229058202*v_R5_c_i + 10.2713736253513*v_R5_c_r + 105.57176931318*v_R5_n_i - 54.0657727682604*v_R5_n_r + 88.488828082646*v_R6_a_i - 18.6937810814837*v_R6_a_r + 58.9235503101832*v_R6_b_i - 45.7766907664085*v_R6_b_r + 88.488828082646*v_R6_c_i - 18.6937810814837*v_R6_c_r - 242.120286143588*v_R6_n_i + 113.786109551688*v_R6_n_r - 39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r - 24.9575997948692*v_R7_b_i + 23.284964480954*v_R7_b_r - 39.6392229058202*v_R7_c_i + 10.2713736253513*v_R7_c_r + 105.57176931318*v_R7_n_i - 54.0657727682604*v_R7_n_r
        struct[0].g[108,0] = 54.0657727682604*v_R6_a_i + 105.57176931318*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r - 23.284964480954*v_R6_c_i - 24.9575997948692*v_R6_c_r - 10.2713736253513*v_R6_n_i - 39.6392229058202*v_R6_n_r - 108.131545536521*v_R7_a_i - 211.14353862636*v_R7_a_r + 20.5427472507027*v_R7_b_i + 79.2784458116403*v_R7_b_r + 46.569928961908*v_R7_c_i + 49.9151995897384*v_R7_c_r + 20.5427472507027*v_R7_n_i + 79.2784458116403*v_R7_n_r + 54.0657727682604*v_R8_a_i + 105.57176931318*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r - 23.284964480954*v_R8_c_i - 24.9575997948692*v_R8_c_r - 10.2713736253513*v_R8_n_i - 39.6392229058202*v_R8_n_r
        struct[0].g[109,0] = 105.57176931318*v_R6_a_i - 54.0657727682604*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r - 24.9575997948692*v_R6_c_i + 23.284964480954*v_R6_c_r - 39.6392229058202*v_R6_n_i + 10.2713736253513*v_R6_n_r - 211.14353862636*v_R7_a_i + 108.131545536521*v_R7_a_r + 79.2784458116403*v_R7_b_i - 20.5427472507027*v_R7_b_r + 49.9151995897384*v_R7_c_i - 46.569928961908*v_R7_c_r + 79.2784458116403*v_R7_n_i - 20.5427472507027*v_R7_n_r + 105.57176931318*v_R8_a_i - 54.0657727682604*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r - 24.9575997948692*v_R8_c_i + 23.284964480954*v_R8_c_r - 39.6392229058202*v_R8_n_i + 10.2713736253513*v_R8_n_r
        struct[0].g[110,0] = -10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r + 54.0657727682604*v_R6_b_i + 105.57176931318*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058201*v_R6_c_r - 23.284964480954*v_R6_n_i - 24.9575997948692*v_R6_n_r + 20.5427472507027*v_R7_a_i + 79.2784458116403*v_R7_a_r - 108.131545536521*v_R7_b_i - 211.14353862636*v_R7_b_r + 20.5427472507027*v_R7_c_i + 79.2784458116403*v_R7_c_r + 46.569928961908*v_R7_n_i + 49.9151995897384*v_R7_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r + 54.0657727682604*v_R8_b_i + 105.57176931318*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058201*v_R8_c_r - 23.284964480954*v_R8_n_i - 24.9575997948692*v_R8_n_r
        struct[0].g[111,0] = -39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r + 105.57176931318*v_R6_b_i - 54.0657727682604*v_R6_b_r - 39.6392229058201*v_R6_c_i + 10.2713736253513*v_R6_c_r - 24.9575997948692*v_R6_n_i + 23.284964480954*v_R6_n_r + 79.2784458116403*v_R7_a_i - 20.5427472507027*v_R7_a_r - 211.14353862636*v_R7_b_i + 108.131545536521*v_R7_b_r + 79.2784458116403*v_R7_c_i - 20.5427472507027*v_R7_c_r + 49.9151995897384*v_R7_n_i - 46.569928961908*v_R7_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r + 105.57176931318*v_R8_b_i - 54.0657727682604*v_R8_b_r - 39.6392229058201*v_R8_c_i + 10.2713736253513*v_R8_c_r - 24.9575997948692*v_R8_n_i + 23.284964480954*v_R8_n_r
        struct[0].g[112,0] = -23.284964480954*v_R6_a_i - 24.9575997948692*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r + 54.0657727682604*v_R6_c_i + 105.57176931318*v_R6_c_r - 10.2713736253514*v_R6_n_i - 39.6392229058201*v_R6_n_r + 46.569928961908*v_R7_a_i + 49.9151995897384*v_R7_a_r + 20.5427472507027*v_R7_b_i + 79.2784458116404*v_R7_b_r - 108.131545536521*v_R7_c_i - 211.14353862636*v_R7_c_r + 20.5427472507027*v_R7_n_i + 79.2784458116403*v_R7_n_r - 23.284964480954*v_R8_a_i - 24.9575997948692*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r + 54.0657727682604*v_R8_c_i + 105.57176931318*v_R8_c_r - 10.2713736253514*v_R8_n_i - 39.6392229058201*v_R8_n_r
        struct[0].g[113,0] = -24.9575997948692*v_R6_a_i + 23.284964480954*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r + 105.57176931318*v_R6_c_i - 54.0657727682604*v_R6_c_r - 39.6392229058201*v_R6_n_i + 10.2713736253514*v_R6_n_r + 49.9151995897384*v_R7_a_i - 46.569928961908*v_R7_a_r + 79.2784458116404*v_R7_b_i - 20.5427472507027*v_R7_b_r - 211.14353862636*v_R7_c_i + 108.131545536521*v_R7_c_r + 79.2784458116403*v_R7_n_i - 20.5427472507027*v_R7_n_r - 24.9575997948692*v_R8_a_i + 23.284964480954*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r + 105.57176931318*v_R8_c_i - 54.0657727682604*v_R8_c_r - 39.6392229058201*v_R8_n_i + 10.2713736253514*v_R8_n_r
        struct[0].g[114,0] = -10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r - 23.284964480954*v_R6_b_i - 24.9575997948692*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058202*v_R6_c_r + 54.0657727682604*v_R6_n_i + 105.57176931318*v_R6_n_r + 20.5427472507027*v_R7_a_i + 79.2784458116403*v_R7_a_r + 46.569928961908*v_R7_b_i + 49.9151995897384*v_R7_b_r + 20.5427472507027*v_R7_c_i + 79.2784458116403*v_R7_c_r - 108.131545536521*v_R7_n_i - 211.14353862636*v_R7_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r - 23.284964480954*v_R8_b_i - 24.9575997948692*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058202*v_R8_c_r + 54.0657727682604*v_R8_n_i + 105.57176931318*v_R8_n_r
        struct[0].g[115,0] = -39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r - 24.9575997948692*v_R6_b_i + 23.284964480954*v_R6_b_r - 39.6392229058202*v_R6_c_i + 10.2713736253513*v_R6_c_r + 105.57176931318*v_R6_n_i - 54.0657727682604*v_R6_n_r + 79.2784458116403*v_R7_a_i - 20.5427472507027*v_R7_a_r + 49.9151995897384*v_R7_b_i - 46.569928961908*v_R7_b_r + 79.2784458116403*v_R7_c_i - 20.5427472507027*v_R7_c_r - 211.14353862636*v_R7_n_i + 108.131545536521*v_R7_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r - 24.9575997948692*v_R8_b_i + 23.284964480954*v_R8_b_r - 39.6392229058202*v_R8_c_i + 10.2713736253513*v_R8_c_r + 105.57176931318*v_R8_n_i - 54.0657727682604*v_R8_n_r
        struct[0].g[116,0] = 54.0657727682604*v_R7_a_i + 105.57176931318*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r - 23.284964480954*v_R7_c_i - 24.9575997948692*v_R7_c_r - 10.2713736253513*v_R7_n_i - 39.6392229058202*v_R7_n_r - 108.131545536521*v_R8_a_i - 211.14353862636*v_R8_a_r + 20.5427472507027*v_R8_b_i + 79.2784458116403*v_R8_b_r + 46.569928961908*v_R8_c_i + 49.9151995897384*v_R8_c_r + 20.5427472507027*v_R8_n_i + 79.2784458116403*v_R8_n_r + 54.0657727682604*v_R9_a_i + 105.57176931318*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r - 23.284964480954*v_R9_c_i - 24.9575997948692*v_R9_c_r - 10.2713736253513*v_R9_n_i - 39.6392229058202*v_R9_n_r
        struct[0].g[117,0] = 105.57176931318*v_R7_a_i - 54.0657727682604*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r - 24.9575997948692*v_R7_c_i + 23.284964480954*v_R7_c_r - 39.6392229058202*v_R7_n_i + 10.2713736253513*v_R7_n_r - 211.14353862636*v_R8_a_i + 108.131545536521*v_R8_a_r + 79.2784458116403*v_R8_b_i - 20.5427472507027*v_R8_b_r + 49.9151995897384*v_R8_c_i - 46.569928961908*v_R8_c_r + 79.2784458116403*v_R8_n_i - 20.5427472507027*v_R8_n_r + 105.57176931318*v_R9_a_i - 54.0657727682604*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r - 24.9575997948692*v_R9_c_i + 23.284964480954*v_R9_c_r - 39.6392229058202*v_R9_n_i + 10.2713736253513*v_R9_n_r
        struct[0].g[118,0] = -10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r + 54.0657727682604*v_R7_b_i + 105.57176931318*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058201*v_R7_c_r - 23.284964480954*v_R7_n_i - 24.9575997948692*v_R7_n_r + 20.5427472507027*v_R8_a_i + 79.2784458116403*v_R8_a_r - 108.131545536521*v_R8_b_i - 211.14353862636*v_R8_b_r + 20.5427472507027*v_R8_c_i + 79.2784458116403*v_R8_c_r + 46.569928961908*v_R8_n_i + 49.9151995897384*v_R8_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r + 54.0657727682604*v_R9_b_i + 105.57176931318*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058201*v_R9_c_r - 23.284964480954*v_R9_n_i - 24.9575997948692*v_R9_n_r
        struct[0].g[119,0] = -39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r + 105.57176931318*v_R7_b_i - 54.0657727682604*v_R7_b_r - 39.6392229058201*v_R7_c_i + 10.2713736253513*v_R7_c_r - 24.9575997948692*v_R7_n_i + 23.284964480954*v_R7_n_r + 79.2784458116403*v_R8_a_i - 20.5427472507027*v_R8_a_r - 211.14353862636*v_R8_b_i + 108.131545536521*v_R8_b_r + 79.2784458116403*v_R8_c_i - 20.5427472507027*v_R8_c_r + 49.9151995897384*v_R8_n_i - 46.569928961908*v_R8_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r + 105.57176931318*v_R9_b_i - 54.0657727682604*v_R9_b_r - 39.6392229058201*v_R9_c_i + 10.2713736253513*v_R9_c_r - 24.9575997948692*v_R9_n_i + 23.284964480954*v_R9_n_r
        struct[0].g[120,0] = -23.284964480954*v_R7_a_i - 24.9575997948692*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r + 54.0657727682604*v_R7_c_i + 105.57176931318*v_R7_c_r - 10.2713736253514*v_R7_n_i - 39.6392229058201*v_R7_n_r + 46.569928961908*v_R8_a_i + 49.9151995897384*v_R8_a_r + 20.5427472507027*v_R8_b_i + 79.2784458116404*v_R8_b_r - 108.131545536521*v_R8_c_i - 211.14353862636*v_R8_c_r + 20.5427472507027*v_R8_n_i + 79.2784458116403*v_R8_n_r - 23.284964480954*v_R9_a_i - 24.9575997948692*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r + 54.0657727682604*v_R9_c_i + 105.57176931318*v_R9_c_r - 10.2713736253514*v_R9_n_i - 39.6392229058201*v_R9_n_r
        struct[0].g[121,0] = -24.9575997948692*v_R7_a_i + 23.284964480954*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r + 105.57176931318*v_R7_c_i - 54.0657727682604*v_R7_c_r - 39.6392229058201*v_R7_n_i + 10.2713736253514*v_R7_n_r + 49.9151995897384*v_R8_a_i - 46.569928961908*v_R8_a_r + 79.2784458116404*v_R8_b_i - 20.5427472507027*v_R8_b_r - 211.14353862636*v_R8_c_i + 108.131545536521*v_R8_c_r + 79.2784458116403*v_R8_n_i - 20.5427472507027*v_R8_n_r - 24.9575997948692*v_R9_a_i + 23.284964480954*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r + 105.57176931318*v_R9_c_i - 54.0657727682604*v_R9_c_r - 39.6392229058201*v_R9_n_i + 10.2713736253514*v_R9_n_r
        struct[0].g[122,0] = -10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r - 23.284964480954*v_R7_b_i - 24.9575997948692*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058202*v_R7_c_r + 54.0657727682604*v_R7_n_i + 105.57176931318*v_R7_n_r + 20.5427472507027*v_R8_a_i + 79.2784458116403*v_R8_a_r + 46.569928961908*v_R8_b_i + 49.9151995897384*v_R8_b_r + 20.5427472507027*v_R8_c_i + 79.2784458116403*v_R8_c_r - 108.131545536521*v_R8_n_i - 211.16853862636*v_R8_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r - 23.284964480954*v_R9_b_i - 24.9575997948692*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058202*v_R9_c_r + 54.0657727682604*v_R9_n_i + 105.57176931318*v_R9_n_r
        struct[0].g[123,0] = -39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r - 24.9575997948692*v_R7_b_i + 23.284964480954*v_R7_b_r - 39.6392229058202*v_R7_c_i + 10.2713736253513*v_R7_c_r + 105.57176931318*v_R7_n_i - 54.0657727682604*v_R7_n_r + 79.2784458116403*v_R8_a_i - 20.5427472507027*v_R8_a_r + 49.9151995897384*v_R8_b_i - 46.569928961908*v_R8_b_r + 79.2784458116403*v_R8_c_i - 20.5427472507027*v_R8_c_r - 211.16853862636*v_R8_n_i + 108.131545536521*v_R8_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r - 24.9575997948692*v_R9_b_i + 23.284964480954*v_R9_b_r - 39.6392229058202*v_R9_c_i + 10.2713736253513*v_R9_c_r + 105.57176931318*v_R9_n_i - 54.0657727682604*v_R9_n_r
        struct[0].g[124,0] = 54.0657727682604*v_R10_a_i + 105.57176931318*v_R10_a_r - 10.2713736253513*v_R10_b_i - 39.6392229058202*v_R10_b_r - 23.284964480954*v_R10_c_i - 24.9575997948692*v_R10_c_r - 10.2713736253513*v_R10_n_i - 39.6392229058202*v_R10_n_r + 5.65456401516768*v_R17_a_i + 30.9517475172273*v_R17_a_r + 1.84896616921897*v_R17_b_i - 9.21038227100566*v_R17_b_r + 0.793238195499529*v_R17_c_i - 9.00835072044485*v_R17_c_r + 1.84896616921897*v_R17_n_i - 9.21038227100566*v_R17_n_r + 54.0657727682604*v_R8_a_i + 105.57176931318*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r - 23.284964480954*v_R8_c_i - 24.9575997948692*v_R8_c_r - 10.2713736253513*v_R8_n_i - 39.6392229058202*v_R8_n_r - 113.786109551688*v_R9_a_i - 242.095286143588*v_R9_a_r + 18.6937810814837*v_R9_b_i + 88.488828082646*v_R9_b_r + 45.7766907664085*v_R9_c_i + 58.9235503101833*v_R9_c_r + 18.6937810814837*v_R9_n_i + 88.488828082646*v_R9_n_r
        struct[0].g[125,0] = 105.57176931318*v_R10_a_i - 54.0657727682604*v_R10_a_r - 39.6392229058202*v_R10_b_i + 10.2713736253513*v_R10_b_r - 24.9575997948692*v_R10_c_i + 23.284964480954*v_R10_c_r - 39.6392229058202*v_R10_n_i + 10.2713736253513*v_R10_n_r + 30.9517475172273*v_R17_a_i - 5.65456401516768*v_R17_a_r - 9.21038227100566*v_R17_b_i - 1.84896616921897*v_R17_b_r - 9.00835072044485*v_R17_c_i - 0.793238195499529*v_R17_c_r - 9.21038227100566*v_R17_n_i - 1.84896616921897*v_R17_n_r + 105.57176931318*v_R8_a_i - 54.0657727682604*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r - 24.9575997948692*v_R8_c_i + 23.284964480954*v_R8_c_r - 39.6392229058202*v_R8_n_i + 10.2713736253513*v_R8_n_r - 242.095286143588*v_R9_a_i + 113.786109551688*v_R9_a_r + 88.488828082646*v_R9_b_i - 18.6937810814837*v_R9_b_r + 58.9235503101833*v_R9_c_i - 45.7766907664085*v_R9_c_r + 88.488828082646*v_R9_n_i - 18.6937810814837*v_R9_n_r
        struct[0].g[126,0] = -10.2713736253513*v_R10_a_i - 39.6392229058202*v_R10_a_r + 54.0657727682604*v_R10_b_i + 105.57176931318*v_R10_b_r - 10.2713736253513*v_R10_c_i - 39.6392229058201*v_R10_c_r - 23.284964480954*v_R10_n_i - 24.9575997948692*v_R10_n_r + 1.84896616921897*v_R17_a_i - 9.21038227100566*v_R17_a_r + 5.65456401516768*v_R17_b_i + 30.9517475172273*v_R17_b_r + 1.84896616921897*v_R17_c_i - 9.21038227100566*v_R17_c_r + 0.793238195499528*v_R17_n_i - 9.00835072044485*v_R17_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r + 54.0657727682604*v_R8_b_i + 105.57176931318*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058201*v_R8_c_r - 23.284964480954*v_R8_n_i - 24.9575997948692*v_R8_n_r + 18.6937810814837*v_R9_a_i + 88.488828082646*v_R9_a_r - 113.786109551688*v_R9_b_i - 242.095286143588*v_R9_b_r + 18.6937810814837*v_R9_c_i + 88.488828082646*v_R9_c_r + 45.7766907664085*v_R9_n_i + 58.9235503101833*v_R9_n_r
        struct[0].g[127,0] = -39.6392229058202*v_R10_a_i + 10.2713736253513*v_R10_a_r + 105.57176931318*v_R10_b_i - 54.0657727682604*v_R10_b_r - 39.6392229058201*v_R10_c_i + 10.2713736253513*v_R10_c_r - 24.9575997948692*v_R10_n_i + 23.284964480954*v_R10_n_r - 9.21038227100566*v_R17_a_i - 1.84896616921897*v_R17_a_r + 30.9517475172273*v_R17_b_i - 5.65456401516768*v_R17_b_r - 9.21038227100566*v_R17_c_i - 1.84896616921897*v_R17_c_r - 9.00835072044485*v_R17_n_i - 0.793238195499528*v_R17_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r + 105.57176931318*v_R8_b_i - 54.0657727682604*v_R8_b_r - 39.6392229058201*v_R8_c_i + 10.2713736253513*v_R8_c_r - 24.9575997948692*v_R8_n_i + 23.284964480954*v_R8_n_r + 88.488828082646*v_R9_a_i - 18.6937810814837*v_R9_a_r - 242.095286143588*v_R9_b_i + 113.786109551688*v_R9_b_r + 88.488828082646*v_R9_c_i - 18.6937810814837*v_R9_c_r + 58.9235503101833*v_R9_n_i - 45.7766907664085*v_R9_n_r
        struct[0].g[128,0] = -23.284964480954*v_R10_a_i - 24.9575997948692*v_R10_a_r - 10.2713736253513*v_R10_b_i - 39.6392229058202*v_R10_b_r + 54.0657727682604*v_R10_c_i + 105.57176931318*v_R10_c_r - 10.2713736253514*v_R10_n_i - 39.6392229058201*v_R10_n_r + 0.793238195499527*v_R17_a_i - 9.00835072044484*v_R17_a_r + 1.84896616921897*v_R17_b_i - 9.21038227100566*v_R17_b_r + 5.65456401516768*v_R17_c_i + 30.9517475172273*v_R17_c_r + 1.84896616921897*v_R17_n_i - 9.21038227100566*v_R17_n_r - 23.284964480954*v_R8_a_i - 24.9575997948692*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r + 54.0657727682604*v_R8_c_i + 105.57176931318*v_R8_c_r - 10.2713736253514*v_R8_n_i - 39.6392229058201*v_R8_n_r + 45.7766907664085*v_R9_a_i + 58.9235503101833*v_R9_a_r + 18.6937810814837*v_R9_b_i + 88.4888280826461*v_R9_b_r - 113.786109551688*v_R9_c_i - 242.095286143588*v_R9_c_r + 18.6937810814837*v_R9_n_i + 88.4888280826459*v_R9_n_r
        struct[0].g[129,0] = -24.9575997948692*v_R10_a_i + 23.284964480954*v_R10_a_r - 39.6392229058202*v_R10_b_i + 10.2713736253513*v_R10_b_r + 105.57176931318*v_R10_c_i - 54.0657727682604*v_R10_c_r - 39.6392229058201*v_R10_n_i + 10.2713736253514*v_R10_n_r - 9.00835072044484*v_R17_a_i - 0.793238195499527*v_R17_a_r - 9.21038227100566*v_R17_b_i - 1.84896616921897*v_R17_b_r + 30.9517475172273*v_R17_c_i - 5.65456401516768*v_R17_c_r - 9.21038227100566*v_R17_n_i - 1.84896616921897*v_R17_n_r - 24.9575997948692*v_R8_a_i + 23.284964480954*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r + 105.57176931318*v_R8_c_i - 54.0657727682604*v_R8_c_r - 39.6392229058201*v_R8_n_i + 10.2713736253514*v_R8_n_r + 58.9235503101833*v_R9_a_i - 45.7766907664085*v_R9_a_r + 88.4888280826461*v_R9_b_i - 18.6937810814837*v_R9_b_r - 242.095286143588*v_R9_c_i + 113.786109551688*v_R9_c_r + 88.4888280826459*v_R9_n_i - 18.6937810814837*v_R9_n_r
        struct[0].g[130,0] = -10.2713736253513*v_R10_a_i - 39.6392229058202*v_R10_a_r - 23.284964480954*v_R10_b_i - 24.9575997948692*v_R10_b_r - 10.2713736253513*v_R10_c_i - 39.6392229058202*v_R10_c_r + 54.0657727682604*v_R10_n_i + 105.57176931318*v_R10_n_r + 1.84896616921897*v_R17_a_i - 9.21038227100566*v_R17_a_r + 0.793238195499527*v_R17_b_i - 9.00835072044485*v_R17_b_r + 1.84896616921897*v_R17_c_i - 9.21038227100566*v_R17_c_r + 5.65456401516768*v_R17_n_i + 30.9517475172273*v_R17_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r - 23.284964480954*v_R8_b_i - 24.9575997948692*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058202*v_R8_c_r + 54.0657727682604*v_R8_n_i + 105.57176931318*v_R8_n_r + 18.6937810814837*v_R9_a_i + 88.488828082646*v_R9_a_r + 45.7766907664085*v_R9_b_i + 58.9235503101832*v_R9_b_r + 18.6937810814837*v_R9_c_i + 88.488828082646*v_R9_c_r - 113.786109551688*v_R9_n_i - 242.095286143588*v_R9_n_r
        struct[0].g[131,0] = -39.6392229058202*v_R10_a_i + 10.2713736253513*v_R10_a_r - 24.9575997948692*v_R10_b_i + 23.284964480954*v_R10_b_r - 39.6392229058202*v_R10_c_i + 10.2713736253513*v_R10_c_r + 105.57176931318*v_R10_n_i - 54.0657727682604*v_R10_n_r - 9.21038227100566*v_R17_a_i - 1.84896616921897*v_R17_a_r - 9.00835072044485*v_R17_b_i - 0.793238195499527*v_R17_b_r - 9.21038227100566*v_R17_c_i - 1.84896616921897*v_R17_c_r + 30.9517475172273*v_R17_n_i - 5.65456401516768*v_R17_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r - 24.9575997948692*v_R8_b_i + 23.284964480954*v_R8_b_r - 39.6392229058202*v_R8_c_i + 10.2713736253513*v_R8_c_r + 105.57176931318*v_R8_n_i - 54.0657727682604*v_R8_n_r + 88.488828082646*v_R9_a_i - 18.6937810814837*v_R9_a_r + 58.9235503101832*v_R9_b_i - 45.7766907664085*v_R9_b_r + 88.488828082646*v_R9_c_i - 18.6937810814837*v_R9_c_r - 242.095286143588*v_R9_n_i + 113.786109551688*v_R9_n_r
        struct[0].g[132,0] = i_vsc_R10_a_r - 59.7203367834281*v_R10_a_i - 136.523516830407*v_R10_a_r + 8.42240745613237*v_R10_b_i + 48.8496051768258*v_R10_b_r + 22.4917262854545*v_R10_c_i + 33.9659505153141*v_R10_c_r + 8.42240745613237*v_R10_n_i + 48.8496051768258*v_R10_n_r + 5.65456401516768*v_R18_a_i + 30.9517475172273*v_R18_a_r + 1.84896616921897*v_R18_b_i - 9.21038227100566*v_R18_b_r + 0.793238195499529*v_R18_c_i - 9.00835072044485*v_R18_c_r + 1.84896616921897*v_R18_n_i - 9.21038227100566*v_R18_n_r + 54.0657727682604*v_R9_a_i + 105.57176931318*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r - 23.284964480954*v_R9_c_i - 24.9575997948692*v_R9_c_r - 10.2713736253513*v_R9_n_i - 39.6392229058202*v_R9_n_r
        struct[0].g[133,0] = i_vsc_R10_a_i - 136.523516830407*v_R10_a_i + 59.7203367834281*v_R10_a_r + 48.8496051768258*v_R10_b_i - 8.42240745613237*v_R10_b_r + 33.9659505153141*v_R10_c_i - 22.4917262854545*v_R10_c_r + 48.8496051768258*v_R10_n_i - 8.42240745613237*v_R10_n_r + 30.9517475172273*v_R18_a_i - 5.65456401516768*v_R18_a_r - 9.21038227100566*v_R18_b_i - 1.84896616921897*v_R18_b_r - 9.00835072044485*v_R18_c_i - 0.793238195499529*v_R18_c_r - 9.21038227100566*v_R18_n_i - 1.84896616921897*v_R18_n_r + 105.57176931318*v_R9_a_i - 54.0657727682604*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r - 24.9575997948692*v_R9_c_i + 23.284964480954*v_R9_c_r - 39.6392229058202*v_R9_n_i + 10.2713736253513*v_R9_n_r
        struct[0].g[134,0] = i_vsc_R10_b_r + 8.42240745613237*v_R10_a_i + 48.8496051768258*v_R10_a_r - 59.720336783428*v_R10_b_i - 136.523516830407*v_R10_b_r + 8.42240745613238*v_R10_c_i + 48.8496051768258*v_R10_c_r + 22.4917262854545*v_R10_n_i + 33.9659505153141*v_R10_n_r + 1.84896616921897*v_R18_a_i - 9.21038227100566*v_R18_a_r + 5.65456401516768*v_R18_b_i + 30.9517475172273*v_R18_b_r + 1.84896616921897*v_R18_c_i - 9.21038227100566*v_R18_c_r + 0.793238195499528*v_R18_n_i - 9.00835072044485*v_R18_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r + 54.0657727682604*v_R9_b_i + 105.57176931318*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058201*v_R9_c_r - 23.284964480954*v_R9_n_i - 24.9575997948692*v_R9_n_r
        struct[0].g[135,0] = i_vsc_R10_b_i + 48.8496051768258*v_R10_a_i - 8.42240745613237*v_R10_a_r - 136.523516830407*v_R10_b_i + 59.720336783428*v_R10_b_r + 48.8496051768258*v_R10_c_i - 8.42240745613238*v_R10_c_r + 33.9659505153141*v_R10_n_i - 22.4917262854545*v_R10_n_r - 9.21038227100566*v_R18_a_i - 1.84896616921897*v_R18_a_r + 30.9517475172273*v_R18_b_i - 5.65456401516768*v_R18_b_r - 9.21038227100566*v_R18_c_i - 1.84896616921897*v_R18_c_r - 9.00835072044485*v_R18_n_i - 0.793238195499528*v_R18_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r + 105.57176931318*v_R9_b_i - 54.0657727682604*v_R9_b_r - 39.6392229058201*v_R9_c_i + 10.2713736253513*v_R9_c_r - 24.9575997948692*v_R9_n_i + 23.284964480954*v_R9_n_r
        struct[0].g[136,0] = i_vsc_R10_c_r + 22.4917262854545*v_R10_a_i + 33.9659505153141*v_R10_a_r + 8.42240745613236*v_R10_b_i + 48.8496051768259*v_R10_b_r - 59.7203367834281*v_R10_c_i - 136.523516830407*v_R10_c_r + 8.42240745613239*v_R10_n_i + 48.8496051768258*v_R10_n_r + 0.793238195499527*v_R18_a_i - 9.00835072044484*v_R18_a_r + 1.84896616921897*v_R18_b_i - 9.21038227100566*v_R18_b_r + 5.65456401516768*v_R18_c_i + 30.9517475172273*v_R18_c_r + 1.84896616921897*v_R18_n_i - 9.21038227100566*v_R18_n_r - 23.284964480954*v_R9_a_i - 24.9575997948692*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r + 54.0657727682604*v_R9_c_i + 105.57176931318*v_R9_c_r - 10.2713736253514*v_R9_n_i - 39.6392229058201*v_R9_n_r
        struct[0].g[137,0] = i_vsc_R10_c_i + 33.9659505153141*v_R10_a_i - 22.4917262854545*v_R10_a_r + 48.8496051768259*v_R10_b_i - 8.42240745613236*v_R10_b_r - 136.523516830407*v_R10_c_i + 59.7203367834281*v_R10_c_r + 48.8496051768258*v_R10_n_i - 8.42240745613239*v_R10_n_r - 9.00835072044484*v_R18_a_i - 0.793238195499527*v_R18_a_r - 9.21038227100566*v_R18_b_i - 1.84896616921897*v_R18_b_r + 30.9517475172273*v_R18_c_i - 5.65456401516768*v_R18_c_r - 9.21038227100566*v_R18_n_i - 1.84896616921897*v_R18_n_r - 24.9575997948692*v_R9_a_i + 23.284964480954*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r + 105.57176931318*v_R9_c_i - 54.0657727682604*v_R9_c_r - 39.6392229058201*v_R9_n_i + 10.2713736253514*v_R9_n_r
        struct[0].g[138,0] = 8.42240745613237*v_R10_a_i + 48.8496051768258*v_R10_a_r + 22.4917262854545*v_R10_b_i + 33.965950515314*v_R10_b_r + 8.42240745613237*v_R10_c_i + 48.8496051768258*v_R10_c_r - 59.7203367834281*v_R10_n_i - 136.548516830407*v_R10_n_r + 1.84896616921897*v_R18_a_i - 9.21038227100566*v_R18_a_r + 0.793238195499527*v_R18_b_i - 9.00835072044485*v_R18_b_r + 1.84896616921897*v_R18_c_i - 9.21038227100566*v_R18_c_r + 5.65456401516768*v_R18_n_i + 30.9517475172273*v_R18_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r - 23.284964480954*v_R9_b_i - 24.9575997948692*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058202*v_R9_c_r + 54.0657727682604*v_R9_n_i + 105.57176931318*v_R9_n_r
        struct[0].g[139,0] = 48.8496051768258*v_R10_a_i - 8.42240745613237*v_R10_a_r + 33.965950515314*v_R10_b_i - 22.4917262854545*v_R10_b_r + 48.8496051768258*v_R10_c_i - 8.42240745613237*v_R10_c_r - 136.548516830407*v_R10_n_i + 59.7203367834281*v_R10_n_r - 9.21038227100566*v_R18_a_i - 1.84896616921897*v_R18_a_r - 9.00835072044485*v_R18_b_i - 0.793238195499527*v_R18_b_r - 9.21038227100566*v_R18_c_i - 1.84896616921897*v_R18_c_r + 30.9517475172273*v_R18_n_i - 5.65456401516768*v_R18_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r - 24.9575997948692*v_R9_b_i + 23.284964480954*v_R9_b_r - 39.6392229058202*v_R9_c_i + 10.2713736253513*v_R9_c_r + 105.57176931318*v_R9_n_i - 54.0657727682604*v_R9_n_r
        struct[0].g[140,0] = -9.69353831171601*v_R12_a_i - 53.0601386009611*v_R12_a_r - 3.16965629008966*v_R12_b_i + 15.7892267502954*v_R12_b_r - 1.35983690657062*v_R12_c_i + 15.442886949334*v_R12_c_r - 3.16965629008966*v_R12_n_i + 15.7892267502954*v_R12_n_r + 4.84676915585801*v_R13_a_i + 26.5300693004806*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 0.67991845328531*v_R13_c_i - 7.72144347466701*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r + 4.84676915585801*v_R4_a_i + 26.5300693004806*v_R4_a_r + 1.58482814504483*v_R4_b_i - 7.8946133751477*v_R4_b_r + 0.67991845328531*v_R4_c_i - 7.72144347466701*v_R4_c_r + 1.58482814504483*v_R4_n_i - 7.89461337514771*v_R4_n_r
        struct[0].g[141,0] = -53.0601386009611*v_R12_a_i + 9.69353831171601*v_R12_a_r + 15.7892267502954*v_R12_b_i + 3.16965629008966*v_R12_b_r + 15.442886949334*v_R12_c_i + 1.35983690657062*v_R12_c_r + 15.7892267502954*v_R12_n_i + 3.16965629008966*v_R12_n_r + 26.5300693004806*v_R13_a_i - 4.84676915585801*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r - 7.72144347466701*v_R13_c_i - 0.67991845328531*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r + 26.5300693004806*v_R4_a_i - 4.84676915585801*v_R4_a_r - 7.8946133751477*v_R4_b_i - 1.58482814504483*v_R4_b_r - 7.72144347466701*v_R4_c_i - 0.67991845328531*v_R4_c_r - 7.89461337514771*v_R4_n_i - 1.58482814504483*v_R4_n_r
        struct[0].g[142,0] = -3.16965629008966*v_R12_a_i + 15.7892267502954*v_R12_a_r - 9.69353831171602*v_R12_b_i - 53.0601386009611*v_R12_b_r - 3.16965629008967*v_R12_c_i + 15.7892267502954*v_R12_c_r - 1.35983690657062*v_R12_n_i + 15.442886949334*v_R12_n_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 4.84676915585801*v_R13_b_i + 26.5300693004806*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 0.679918453285308*v_R13_n_i - 7.72144347466701*v_R13_n_r + 1.58482814504483*v_R4_a_i - 7.89461337514771*v_R4_a_r + 4.84676915585801*v_R4_b_i + 26.5300693004806*v_R4_b_r + 1.58482814504483*v_R4_c_i - 7.89461337514771*v_R4_c_r + 0.679918453285308*v_R4_n_i - 7.72144347466701*v_R4_n_r
        struct[0].g[143,0] = 15.7892267502954*v_R12_a_i + 3.16965629008966*v_R12_a_r - 53.0601386009611*v_R12_b_i + 9.69353831171602*v_R12_b_r + 15.7892267502954*v_R12_c_i + 3.16965629008967*v_R12_c_r + 15.442886949334*v_R12_n_i + 1.35983690657062*v_R12_n_r - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r + 26.5300693004806*v_R13_b_i - 4.84676915585801*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r - 7.72144347466701*v_R13_n_i - 0.679918453285308*v_R13_n_r - 7.89461337514771*v_R4_a_i - 1.58482814504483*v_R4_a_r + 26.5300693004806*v_R4_b_i - 4.84676915585801*v_R4_b_r - 7.89461337514771*v_R4_c_i - 1.58482814504483*v_R4_c_r - 7.72144347466701*v_R4_n_i - 0.679918453285308*v_R4_n_r
        struct[0].g[144,0] = -1.35983690657062*v_R12_a_i + 15.442886949334*v_R12_a_r - 3.16965629008966*v_R12_b_i + 15.7892267502954*v_R12_b_r - 9.69353831171602*v_R12_c_i - 53.0601386009611*v_R12_c_r - 3.16965629008967*v_R12_n_i + 15.7892267502954*v_R12_n_r + 0.67991845328531*v_R13_a_i - 7.72144347466701*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 4.84676915585801*v_R13_c_i + 26.5300693004806*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r + 0.67991845328531*v_R4_a_i - 7.72144347466701*v_R4_a_r + 1.58482814504483*v_R4_b_i - 7.8946133751477*v_R4_b_r + 4.84676915585801*v_R4_c_i + 26.5300693004806*v_R4_c_r + 1.58482814504483*v_R4_n_i - 7.89461337514771*v_R4_n_r
        struct[0].g[145,0] = 15.442886949334*v_R12_a_i + 1.35983690657062*v_R12_a_r + 15.7892267502954*v_R12_b_i + 3.16965629008966*v_R12_b_r - 53.0601386009611*v_R12_c_i + 9.69353831171602*v_R12_c_r + 15.7892267502954*v_R12_n_i + 3.16965629008967*v_R12_n_r - 7.72144347466701*v_R13_a_i - 0.67991845328531*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r + 26.5300693004806*v_R13_c_i - 4.84676915585801*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r - 7.72144347466701*v_R4_a_i - 0.67991845328531*v_R4_a_r - 7.8946133751477*v_R4_b_i - 1.58482814504483*v_R4_b_r + 26.5300693004806*v_R4_c_i - 4.84676915585801*v_R4_c_r - 7.89461337514771*v_R4_n_i - 1.58482814504483*v_R4_n_r
        struct[0].g[146,0] = -3.16965629008966*v_R12_a_i + 15.7892267502954*v_R12_a_r - 1.35983690657062*v_R12_b_i + 15.442886949334*v_R12_b_r - 3.16965629008966*v_R12_c_i + 15.7892267502954*v_R12_c_r - 9.69353831171602*v_R12_n_i - 53.0601386009611*v_R12_n_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 0.679918453285308*v_R13_b_i - 7.72144347466701*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 4.84676915585801*v_R13_n_i + 26.5300693004806*v_R13_n_r + 1.58482814504483*v_R4_a_i - 7.89461337514771*v_R4_a_r + 0.679918453285308*v_R4_b_i - 7.72144347466701*v_R4_b_r + 1.58482814504483*v_R4_c_i - 7.89461337514771*v_R4_c_r + 4.84676915585801*v_R4_n_i + 26.5300693004806*v_R4_n_r
        struct[0].g[147,0] = 15.7892267502954*v_R12_a_i + 3.16965629008966*v_R12_a_r + 15.442886949334*v_R12_b_i + 1.35983690657062*v_R12_b_r + 15.7892267502954*v_R12_c_i + 3.16965629008966*v_R12_c_r - 53.0601386009611*v_R12_n_i + 9.69353831171602*v_R12_n_r - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r - 7.72144347466701*v_R13_b_i - 0.679918453285308*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r + 26.5300693004806*v_R13_n_i - 4.84676915585801*v_R13_n_r - 7.89461337514771*v_R4_a_i - 1.58482814504483*v_R4_a_r - 7.72144347466701*v_R4_b_i - 0.679918453285308*v_R4_b_r - 7.89461337514771*v_R4_c_i - 1.58482814504483*v_R4_c_r + 26.5300693004806*v_R4_n_i - 4.84676915585801*v_R4_n_r
        struct[0].g[148,0] = 4.84676915585801*v_R12_a_i + 26.5300693004806*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 0.67991845328531*v_R12_c_i - 7.72144347466701*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 9.69353831171601*v_R13_a_i - 53.0601386009611*v_R13_a_r - 3.16965629008966*v_R13_b_i + 15.7892267502954*v_R13_b_r - 1.35983690657062*v_R13_c_i + 15.442886949334*v_R13_c_r - 3.16965629008966*v_R13_n_i + 15.7892267502954*v_R13_n_r + 4.84676915585801*v_R14_a_i + 26.5300693004806*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 0.67991845328531*v_R14_c_i - 7.72144347466701*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r
        struct[0].g[149,0] = 26.5300693004806*v_R12_a_i - 4.84676915585801*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r - 7.72144347466701*v_R12_c_i - 0.67991845328531*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r - 53.0601386009611*v_R13_a_i + 9.69353831171601*v_R13_a_r + 15.7892267502954*v_R13_b_i + 3.16965629008966*v_R13_b_r + 15.442886949334*v_R13_c_i + 1.35983690657062*v_R13_c_r + 15.7892267502954*v_R13_n_i + 3.16965629008966*v_R13_n_r + 26.5300693004806*v_R14_a_i - 4.84676915585801*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r - 7.72144347466701*v_R14_c_i - 0.67991845328531*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r
        struct[0].g[150,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 4.84676915585801*v_R12_b_i + 26.5300693004806*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 0.679918453285308*v_R12_n_i - 7.72144347466701*v_R12_n_r - 3.16965629008966*v_R13_a_i + 15.7892267502954*v_R13_a_r - 9.69353831171602*v_R13_b_i - 53.0601386009611*v_R13_b_r - 3.16965629008967*v_R13_c_i + 15.7892267502954*v_R13_c_r - 1.35983690657062*v_R13_n_i + 15.442886949334*v_R13_n_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 4.84676915585801*v_R14_b_i + 26.5300693004806*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 0.679918453285308*v_R14_n_i - 7.72144347466701*v_R14_n_r
        struct[0].g[151,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r + 26.5300693004806*v_R12_b_i - 4.84676915585801*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r - 7.72144347466701*v_R12_n_i - 0.679918453285308*v_R12_n_r + 15.7892267502954*v_R13_a_i + 3.16965629008966*v_R13_a_r - 53.0601386009611*v_R13_b_i + 9.69353831171602*v_R13_b_r + 15.7892267502954*v_R13_c_i + 3.16965629008967*v_R13_c_r + 15.442886949334*v_R13_n_i + 1.35983690657062*v_R13_n_r - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r + 26.5300693004806*v_R14_b_i - 4.84676915585801*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r - 7.72144347466701*v_R14_n_i - 0.679918453285308*v_R14_n_r
        struct[0].g[152,0] = 0.67991845328531*v_R12_a_i - 7.72144347466701*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 4.84676915585801*v_R12_c_i + 26.5300693004806*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 1.35983690657062*v_R13_a_i + 15.442886949334*v_R13_a_r - 3.16965629008966*v_R13_b_i + 15.7892267502954*v_R13_b_r - 9.69353831171602*v_R13_c_i - 53.0601386009611*v_R13_c_r - 3.16965629008967*v_R13_n_i + 15.7892267502954*v_R13_n_r + 0.67991845328531*v_R14_a_i - 7.72144347466701*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 4.84676915585801*v_R14_c_i + 26.5300693004806*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r
        struct[0].g[153,0] = -7.72144347466701*v_R12_a_i - 0.67991845328531*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r + 26.5300693004806*v_R12_c_i - 4.84676915585801*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r + 15.442886949334*v_R13_a_i + 1.35983690657062*v_R13_a_r + 15.7892267502954*v_R13_b_i + 3.16965629008966*v_R13_b_r - 53.0601386009611*v_R13_c_i + 9.69353831171602*v_R13_c_r + 15.7892267502954*v_R13_n_i + 3.16965629008967*v_R13_n_r - 7.72144347466701*v_R14_a_i - 0.67991845328531*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r + 26.5300693004806*v_R14_c_i - 4.84676915585801*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r
        struct[0].g[154,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 0.679918453285308*v_R12_b_i - 7.72144347466701*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 4.84676915585801*v_R12_n_i + 26.5300693004806*v_R12_n_r - 3.16965629008966*v_R13_a_i + 15.7892267502954*v_R13_a_r - 1.35983690657062*v_R13_b_i + 15.442886949334*v_R13_b_r - 3.16965629008966*v_R13_c_i + 15.7892267502954*v_R13_c_r - 9.69353831171602*v_R13_n_i - 53.0851386009611*v_R13_n_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 0.679918453285308*v_R14_b_i - 7.72144347466701*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 4.84676915585801*v_R14_n_i + 26.5300693004806*v_R14_n_r
        struct[0].g[155,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r - 7.72144347466701*v_R12_b_i - 0.679918453285308*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r + 26.5300693004806*v_R12_n_i - 4.84676915585801*v_R12_n_r + 15.7892267502954*v_R13_a_i + 3.16965629008966*v_R13_a_r + 15.442886949334*v_R13_b_i + 1.35983690657062*v_R13_b_r + 15.7892267502954*v_R13_c_i + 3.16965629008966*v_R13_c_r - 53.0851386009611*v_R13_n_i + 9.69353831171602*v_R13_n_r - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r - 7.72144347466701*v_R14_b_i - 0.679918453285308*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r + 26.5300693004806*v_R14_n_i - 4.84676915585801*v_R14_n_r
        struct[0].g[156,0] = i_vsc_R14_a_r + 4.84676915585801*v_R13_a_i + 26.5300693004806*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 0.67991845328531*v_R13_c_i - 7.72144347466701*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r - 9.69353831171601*v_R14_a_i - 53.0601386009611*v_R14_a_r - 3.16965629008966*v_R14_b_i + 15.7892267502954*v_R14_b_r - 1.35983690657062*v_R14_c_i + 15.442886949334*v_R14_c_r - 3.16965629008966*v_R14_n_i + 15.7892267502954*v_R14_n_r + 4.84676915585801*v_R15_a_i + 26.5300693004806*v_R15_a_r + 1.58482814504483*v_R15_b_i - 7.8946133751477*v_R15_b_r + 0.67991845328531*v_R15_c_i - 7.72144347466701*v_R15_c_r + 1.58482814504483*v_R15_n_i - 7.89461337514771*v_R15_n_r
        struct[0].g[157,0] = i_vsc_R14_a_i + 26.5300693004806*v_R13_a_i - 4.84676915585801*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r - 7.72144347466701*v_R13_c_i - 0.67991845328531*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r - 53.0601386009611*v_R14_a_i + 9.69353831171601*v_R14_a_r + 15.7892267502954*v_R14_b_i + 3.16965629008966*v_R14_b_r + 15.442886949334*v_R14_c_i + 1.35983690657062*v_R14_c_r + 15.7892267502954*v_R14_n_i + 3.16965629008966*v_R14_n_r + 26.5300693004806*v_R15_a_i - 4.84676915585801*v_R15_a_r - 7.8946133751477*v_R15_b_i - 1.58482814504483*v_R15_b_r - 7.72144347466701*v_R15_c_i - 0.67991845328531*v_R15_c_r - 7.89461337514771*v_R15_n_i - 1.58482814504483*v_R15_n_r
        struct[0].g[158,0] = i_vsc_R14_b_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 4.84676915585801*v_R13_b_i + 26.5300693004806*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 0.679918453285308*v_R13_n_i - 7.72144347466701*v_R13_n_r - 3.16965629008966*v_R14_a_i + 15.7892267502954*v_R14_a_r - 9.69353831171602*v_R14_b_i - 53.0601386009611*v_R14_b_r - 3.16965629008967*v_R14_c_i + 15.7892267502954*v_R14_c_r - 1.35983690657062*v_R14_n_i + 15.442886949334*v_R14_n_r + 1.58482814504483*v_R15_a_i - 7.89461337514771*v_R15_a_r + 4.84676915585801*v_R15_b_i + 26.5300693004806*v_R15_b_r + 1.58482814504483*v_R15_c_i - 7.89461337514771*v_R15_c_r + 0.679918453285308*v_R15_n_i - 7.72144347466701*v_R15_n_r
        struct[0].g[159,0] = i_vsc_R14_b_i - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r + 26.5300693004806*v_R13_b_i - 4.84676915585801*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r - 7.72144347466701*v_R13_n_i - 0.679918453285308*v_R13_n_r + 15.7892267502954*v_R14_a_i + 3.16965629008966*v_R14_a_r - 53.0601386009611*v_R14_b_i + 9.69353831171602*v_R14_b_r + 15.7892267502954*v_R14_c_i + 3.16965629008967*v_R14_c_r + 15.442886949334*v_R14_n_i + 1.35983690657062*v_R14_n_r - 7.89461337514771*v_R15_a_i - 1.58482814504483*v_R15_a_r + 26.5300693004806*v_R15_b_i - 4.84676915585801*v_R15_b_r - 7.89461337514771*v_R15_c_i - 1.58482814504483*v_R15_c_r - 7.72144347466701*v_R15_n_i - 0.679918453285308*v_R15_n_r
        struct[0].g[160,0] = i_vsc_R14_c_r + 0.67991845328531*v_R13_a_i - 7.72144347466701*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 4.84676915585801*v_R13_c_i + 26.5300693004806*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r - 1.35983690657062*v_R14_a_i + 15.442886949334*v_R14_a_r - 3.16965629008966*v_R14_b_i + 15.7892267502954*v_R14_b_r - 9.69353831171602*v_R14_c_i - 53.0601386009611*v_R14_c_r - 3.16965629008967*v_R14_n_i + 15.7892267502954*v_R14_n_r + 0.67991845328531*v_R15_a_i - 7.72144347466701*v_R15_a_r + 1.58482814504483*v_R15_b_i - 7.8946133751477*v_R15_b_r + 4.84676915585801*v_R15_c_i + 26.5300693004806*v_R15_c_r + 1.58482814504483*v_R15_n_i - 7.89461337514771*v_R15_n_r
        struct[0].g[161,0] = i_vsc_R14_c_i - 7.72144347466701*v_R13_a_i - 0.67991845328531*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r + 26.5300693004806*v_R13_c_i - 4.84676915585801*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r + 15.442886949334*v_R14_a_i + 1.35983690657062*v_R14_a_r + 15.7892267502954*v_R14_b_i + 3.16965629008966*v_R14_b_r - 53.0601386009611*v_R14_c_i + 9.69353831171602*v_R14_c_r + 15.7892267502954*v_R14_n_i + 3.16965629008967*v_R14_n_r - 7.72144347466701*v_R15_a_i - 0.67991845328531*v_R15_a_r - 7.8946133751477*v_R15_b_i - 1.58482814504483*v_R15_b_r + 26.5300693004806*v_R15_c_i - 4.84676915585801*v_R15_c_r - 7.89461337514771*v_R15_n_i - 1.58482814504483*v_R15_n_r
        struct[0].g[162,0] = 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 0.679918453285308*v_R13_b_i - 7.72144347466701*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 4.84676915585801*v_R13_n_i + 26.5300693004806*v_R13_n_r - 3.16965629008966*v_R14_a_i + 15.7892267502954*v_R14_a_r - 1.35983690657062*v_R14_b_i + 15.442886949334*v_R14_b_r - 3.16965629008966*v_R14_c_i + 15.7892267502954*v_R14_c_r - 9.69353831171602*v_R14_n_i - 53.0601386009611*v_R14_n_r + 1.58482814504483*v_R15_a_i - 7.89461337514771*v_R15_a_r + 0.679918453285308*v_R15_b_i - 7.72144347466701*v_R15_b_r + 1.58482814504483*v_R15_c_i - 7.89461337514771*v_R15_c_r + 4.84676915585801*v_R15_n_i + 26.5300693004806*v_R15_n_r
        struct[0].g[163,0] = -7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r - 7.72144347466701*v_R13_b_i - 0.679918453285308*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r + 26.5300693004806*v_R13_n_i - 4.84676915585801*v_R13_n_r + 15.7892267502954*v_R14_a_i + 3.16965629008966*v_R14_a_r + 15.442886949334*v_R14_b_i + 1.35983690657062*v_R14_b_r + 15.7892267502954*v_R14_c_i + 3.16965629008966*v_R14_c_r - 53.0601386009611*v_R14_n_i + 9.69353831171602*v_R14_n_r - 7.89461337514771*v_R15_a_i - 1.58482814504483*v_R15_a_r - 7.72144347466701*v_R15_b_i - 0.679918453285308*v_R15_b_r - 7.89461337514771*v_R15_c_i - 1.58482814504483*v_R15_c_r + 26.5300693004806*v_R15_n_i - 4.84676915585801*v_R15_n_r
        struct[0].g[164,0] = -1067.7048070413*v_D1_n_r + 67.7048070412999*v_D3_n_r
        struct[0].g[165,0] = -1067.7048070413*v_D1_n_i + 67.7048070412999*v_D3_n_i
        struct[0].g[166,0] = 157.977883096366*v_D11_a_r + 67.7048070412999*v_D1_a_r - 361.092304220266*v_D3_a_r + 135.4096140826*v_D4_a_r
        struct[0].g[167,0] = 157.977883096366*v_D11_a_i + 67.7048070412999*v_D1_a_i - 361.092304220266*v_D3_a_i + 135.4096140826*v_D4_a_i
        struct[0].g[168,0] = 157.977883096366*v_D11_b_r + 67.7048070412999*v_D1_b_r - 361.092304220266*v_D3_b_r + 135.4096140826*v_D4_b_r
        struct[0].g[169,0] = 157.977883096366*v_D11_b_i + 67.7048070412999*v_D1_b_i - 361.092304220266*v_D3_b_i + 135.4096140826*v_D4_b_i
        struct[0].g[170,0] = 157.977883096366*v_D11_c_r + 67.7048070412999*v_D1_c_r - 361.092304220266*v_D3_c_r + 135.4096140826*v_D4_c_r
        struct[0].g[171,0] = 157.977883096366*v_D11_c_i + 67.7048070412999*v_D1_c_i - 361.092304220266*v_D3_c_i + 135.4096140826*v_D4_c_i
        struct[0].g[172,0] = 157.977883096366*v_D11_n_r + 67.7048070412999*v_D1_n_r - 361.092304220266*v_D3_n_r + 135.4096140826*v_D4_n_r
        struct[0].g[173,0] = 157.977883096366*v_D11_n_i + 67.7048070412999*v_D1_n_i - 361.092304220266*v_D3_n_i + 135.4096140826*v_D4_n_i
        struct[0].g[174,0] = 45.1365380275333*v_D14_a_r + 135.4096140826*v_D3_a_r - 248.250959151433*v_D4_a_r + 67.7048070412999*v_D6_a_r
        struct[0].g[175,0] = 45.1365380275333*v_D14_a_i + 135.4096140826*v_D3_a_i - 248.250959151433*v_D4_a_i + 67.7048070412999*v_D6_a_i
        struct[0].g[176,0] = 45.1365380275333*v_D14_b_r + 135.4096140826*v_D3_b_r - 248.250959151433*v_D4_b_r + 67.7048070412999*v_D6_b_r
        struct[0].g[177,0] = 45.1365380275333*v_D14_b_i + 135.4096140826*v_D3_b_i - 248.250959151433*v_D4_b_i + 67.7048070412999*v_D6_b_i
        struct[0].g[178,0] = 45.1365380275333*v_D14_c_r + 135.4096140826*v_D3_c_r - 248.250959151433*v_D4_c_r + 67.7048070412999*v_D6_c_r
        struct[0].g[179,0] = 45.1365380275333*v_D14_c_i + 135.4096140826*v_D3_c_i - 248.250959151433*v_D4_c_i + 67.7048070412999*v_D6_c_i
        struct[0].g[180,0] = 45.1365380275333*v_D14_n_r + 135.4096140826*v_D3_n_r - 248.250959151433*v_D4_n_r + 67.7048070412999*v_D6_n_r
        struct[0].g[181,0] = 45.1365380275333*v_D14_n_i + 135.4096140826*v_D3_n_i - 248.250959151433*v_D4_n_i + 67.7048070412999*v_D6_n_i
        struct[0].g[182,0] = 157.977883096366*v_D16_a_r + 67.7048070412999*v_D4_a_r - 270.8192281652*v_D6_a_r + 45.1365380275333*v_D9_a_r
        struct[0].g[183,0] = 157.977883096366*v_D16_a_i + 67.7048070412999*v_D4_a_i - 270.8192281652*v_D6_a_i + 45.1365380275333*v_D9_a_i
        struct[0].g[184,0] = 157.977883096366*v_D16_b_r + 67.7048070412999*v_D4_b_r - 270.8192281652*v_D6_b_r + 45.1365380275333*v_D9_b_r
        struct[0].g[185,0] = 157.977883096366*v_D16_b_i + 67.7048070412999*v_D4_b_i - 270.8192281652*v_D6_b_i + 45.1365380275333*v_D9_b_i
        struct[0].g[186,0] = 157.977883096366*v_D16_c_r + 67.7048070412999*v_D4_c_r - 270.8192281652*v_D6_c_r + 45.1365380275333*v_D9_c_r
        struct[0].g[187,0] = 157.977883096366*v_D16_c_i + 67.7048070412999*v_D4_c_i - 270.8192281652*v_D6_c_i + 45.1365380275333*v_D9_c_i
        struct[0].g[188,0] = 157.977883096366*v_D16_n_r + 67.7048070412999*v_D4_n_r - 270.8192281652*v_D6_n_r + 45.1365380275333*v_D9_n_r
        struct[0].g[189,0] = 157.977883096366*v_D16_n_i + 67.7048070412999*v_D4_n_i - 270.8192281652*v_D6_n_i + 45.1365380275333*v_D9_n_i
        struct[0].g[190,0] = 157.977883096366*v_D10_a_r + 157.977883096366*v_D17_a_r + 45.1365380275333*v_D6_a_r - 361.092304220266*v_D9_a_r
        struct[0].g[191,0] = 157.977883096366*v_D10_a_i + 157.977883096366*v_D17_a_i + 45.1365380275333*v_D6_a_i - 361.092304220266*v_D9_a_i
        struct[0].g[192,0] = 157.977883096366*v_D10_b_r + 157.977883096366*v_D17_b_r + 45.1365380275333*v_D6_b_r - 361.092304220266*v_D9_b_r
        struct[0].g[193,0] = 157.977883096366*v_D10_b_i + 157.977883096366*v_D17_b_i + 45.1365380275333*v_D6_b_i - 361.092304220266*v_D9_b_i
        struct[0].g[194,0] = 157.977883096366*v_D10_c_r + 157.977883096366*v_D17_c_r + 45.1365380275333*v_D6_c_r - 361.092304220266*v_D9_c_r
        struct[0].g[195,0] = 157.977883096366*v_D10_c_i + 157.977883096366*v_D17_c_i + 45.1365380275333*v_D6_c_i - 361.092304220266*v_D9_c_i
        struct[0].g[196,0] = 157.977883096366*v_D10_n_r + 157.977883096366*v_D17_n_r + 45.1365380275333*v_D6_n_r - 361.092304220266*v_D9_n_r
        struct[0].g[197,0] = 157.977883096366*v_D10_n_i + 157.977883096366*v_D17_n_i + 45.1365380275333*v_D6_n_i - 361.092304220266*v_D9_n_i
        struct[0].g[198,0] = i_vsc_D10_a_r - 315.955766192733*v_D10_a_r + 157.977883096366*v_D18_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[199,0] = -315.955766192733*v_D10_a_i + 157.977883096366*v_D18_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[200,0] = -315.955766192733*v_D10_b_r + 157.977883096366*v_D18_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[201,0] = -315.955766192733*v_D10_b_i + 157.977883096366*v_D18_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[202,0] = -315.955766192733*v_D10_c_r + 157.977883096366*v_D18_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[203,0] = -315.955766192733*v_D10_c_i + 157.977883096366*v_D18_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[204,0] = i_vsc_D10_n_r - 315.955766192733*v_D10_n_r + 157.977883096366*v_D18_n_r + 157.977883096366*v_D9_n_r
        struct[0].g[205,0] = -315.955766192733*v_D10_n_i + 157.977883096366*v_D18_n_i + 157.977883096366*v_D9_n_i
        struct[0].g[206,0] = -157.977883096366*v_D11_b_r + 157.977883096366*v_D3_b_r
        struct[0].g[207,0] = -157.977883096366*v_D11_b_i + 157.977883096366*v_D3_b_i
        struct[0].g[208,0] = -157.977883096366*v_D11_c_r + 157.977883096366*v_D3_c_r
        struct[0].g[209,0] = -157.977883096366*v_D11_c_i + 157.977883096366*v_D3_c_i
        struct[0].g[210,0] = -157.977883096366*v_D16_b_r + 157.977883096366*v_D6_b_r
        struct[0].g[211,0] = -157.977883096366*v_D16_b_i + 157.977883096366*v_D6_b_i
        struct[0].g[212,0] = -157.977883096366*v_D16_c_r + 157.977883096366*v_D6_c_r
        struct[0].g[213,0] = -157.977883096366*v_D16_c_i + 157.977883096366*v_D6_c_i
        struct[0].g[214,0] = -157.977883096366*v_D17_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[215,0] = -157.977883096366*v_D17_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[216,0] = -157.977883096366*v_D17_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[217,0] = -157.977883096366*v_D17_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[218,0] = 157.977883096366*v_D10_b_r - 157.977883096366*v_D18_b_r
        struct[0].g[219,0] = 157.977883096366*v_D10_b_i - 157.977883096366*v_D18_b_i
        struct[0].g[220,0] = 157.977883096366*v_D10_c_r - 157.977883096366*v_D18_c_r
        struct[0].g[221,0] = 157.977883096366*v_D10_c_i - 157.977883096366*v_D18_c_i
        struct[0].g[222,0] = i_vsc_D14_a_r - 180.546152110133*v_D14_a_r + 135.4096140826*v_D15_a_r + 45.1365380275333*v_D4_a_r
        struct[0].g[223,0] = -180.546152110133*v_D14_a_i + 135.4096140826*v_D15_a_i + 45.1365380275333*v_D4_a_i
        struct[0].g[224,0] = -180.546152110133*v_D14_b_r + 135.4096140826*v_D15_b_r + 45.1365380275333*v_D4_b_r
        struct[0].g[225,0] = -180.546152110133*v_D14_b_i + 135.4096140826*v_D15_b_i + 45.1365380275333*v_D4_b_i
        struct[0].g[226,0] = -180.546152110133*v_D14_c_r + 135.4096140826*v_D15_c_r + 45.1365380275333*v_D4_c_r
        struct[0].g[227,0] = -180.546152110133*v_D14_c_i + 135.4096140826*v_D15_c_i + 45.1365380275333*v_D4_c_i
        struct[0].g[228,0] = i_vsc_D14_n_r - 180.546152110133*v_D14_n_r + 135.4096140826*v_D15_n_r + 45.1365380275333*v_D4_n_r
        struct[0].g[229,0] = -180.546152110133*v_D14_n_i + 135.4096140826*v_D15_n_i + 45.1365380275333*v_D4_n_i
        struct[0].g[230,0] = 135.4096140826*v_D14_b_r - 135.4096140826*v_D15_b_r
        struct[0].g[231,0] = 135.4096140826*v_D14_b_i - 135.4096140826*v_D15_b_i
        struct[0].g[232,0] = 135.4096140826*v_D14_c_r - 135.4096140826*v_D15_c_r
        struct[0].g[233,0] = 135.4096140826*v_D14_c_i - 135.4096140826*v_D15_c_i
        struct[0].g[234,0] = -i_t_R0_R1_a_r + 0.0196078431372549*v_R0_a_i + 0.00490196078431373*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_a_i - 0.212261128378539*v_R1_a_r + 0.849044513514155*v_R1_b_i + 0.212261128378539*v_R1_b_r
        struct[0].g[235,0] = -i_t_R0_R1_a_i + 0.00490196078431373*v_R0_a_i - 0.0196078431372549*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_a_i + 0.849044513514155*v_R1_a_r + 0.212261128378539*v_R1_b_i - 0.849044513514155*v_R1_b_r
        struct[0].g[236,0] = -i_t_R0_R1_b_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r + 0.0196078431372549*v_R0_b_i + 0.00490196078431373*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_b_i - 0.212261128378539*v_R1_b_r + 0.849044513514155*v_R1_c_i + 0.212261128378539*v_R1_c_r
        struct[0].g[237,0] = -i_t_R0_R1_b_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r + 0.00490196078431373*v_R0_b_i - 0.0196078431372549*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_b_i + 0.849044513514155*v_R1_b_r + 0.212261128378539*v_R1_c_i - 0.849044513514155*v_R1_c_r
        struct[0].g[238,0] = -i_t_R0_R1_c_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r + 0.0196078431372549*v_R0_c_i + 0.00490196078431373*v_R0_c_r + 0.849044513514155*v_R1_a_i + 0.212261128378539*v_R1_a_r - 0.849044513514155*v_R1_c_i - 0.212261128378539*v_R1_c_r
        struct[0].g[239,0] = -i_t_R0_R1_c_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r + 0.00490196078431373*v_R0_c_i - 0.0196078431372549*v_R0_c_r + 0.212261128378539*v_R1_a_i - 0.849044513514155*v_R1_a_r - 0.212261128378539*v_R1_c_i + 0.849044513514155*v_R1_c_r
        struct[0].g[240,0] = -i_l_R1_R2_a_r + 54.0657727682604*v_R1_a_i + 105.57176931318*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r - 23.284964480954*v_R1_c_i - 24.9575997948692*v_R1_c_r - 10.2713736253513*v_R1_n_i - 39.6392229058202*v_R1_n_r - 54.0657727682604*v_R2_a_i - 105.57176931318*v_R2_a_r + 10.2713736253513*v_R2_b_i + 39.6392229058202*v_R2_b_r + 23.284964480954*v_R2_c_i + 24.9575997948692*v_R2_c_r + 10.2713736253513*v_R2_n_i + 39.6392229058202*v_R2_n_r
        struct[0].g[241,0] = -i_l_R1_R2_a_i + 105.57176931318*v_R1_a_i - 54.0657727682604*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r - 24.9575997948692*v_R1_c_i + 23.284964480954*v_R1_c_r - 39.6392229058202*v_R1_n_i + 10.2713736253513*v_R1_n_r - 105.57176931318*v_R2_a_i + 54.0657727682604*v_R2_a_r + 39.6392229058202*v_R2_b_i - 10.2713736253513*v_R2_b_r + 24.9575997948692*v_R2_c_i - 23.284964480954*v_R2_c_r + 39.6392229058202*v_R2_n_i - 10.2713736253513*v_R2_n_r
        struct[0].g[242,0] = -i_l_R1_R2_b_r - 10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r + 54.0657727682604*v_R1_b_i + 105.57176931318*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058201*v_R1_c_r - 23.284964480954*v_R1_n_i - 24.9575997948692*v_R1_n_r + 10.2713736253513*v_R2_a_i + 39.6392229058202*v_R2_a_r - 54.0657727682604*v_R2_b_i - 105.57176931318*v_R2_b_r + 10.2713736253513*v_R2_c_i + 39.6392229058201*v_R2_c_r + 23.284964480954*v_R2_n_i + 24.9575997948692*v_R2_n_r
        struct[0].g[243,0] = -i_l_R1_R2_b_i - 39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r + 105.57176931318*v_R1_b_i - 54.0657727682604*v_R1_b_r - 39.6392229058201*v_R1_c_i + 10.2713736253513*v_R1_c_r - 24.9575997948692*v_R1_n_i + 23.284964480954*v_R1_n_r + 39.6392229058202*v_R2_a_i - 10.2713736253513*v_R2_a_r - 105.57176931318*v_R2_b_i + 54.0657727682604*v_R2_b_r + 39.6392229058201*v_R2_c_i - 10.2713736253513*v_R2_c_r + 24.9575997948692*v_R2_n_i - 23.284964480954*v_R2_n_r
        struct[0].g[244,0] = -i_l_R1_R2_c_r - 23.284964480954*v_R1_a_i - 24.9575997948692*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r + 54.0657727682604*v_R1_c_i + 105.57176931318*v_R1_c_r - 10.2713736253514*v_R1_n_i - 39.6392229058201*v_R1_n_r + 23.284964480954*v_R2_a_i + 24.9575997948692*v_R2_a_r + 10.2713736253513*v_R2_b_i + 39.6392229058202*v_R2_b_r - 54.0657727682604*v_R2_c_i - 105.57176931318*v_R2_c_r + 10.2713736253514*v_R2_n_i + 39.6392229058201*v_R2_n_r
        struct[0].g[245,0] = -i_l_R1_R2_c_i - 24.9575997948692*v_R1_a_i + 23.284964480954*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r + 105.57176931318*v_R1_c_i - 54.0657727682604*v_R1_c_r - 39.6392229058201*v_R1_n_i + 10.2713736253514*v_R1_n_r + 24.9575997948692*v_R2_a_i - 23.284964480954*v_R2_a_r + 39.6392229058202*v_R2_b_i - 10.2713736253513*v_R2_b_r - 105.57176931318*v_R2_c_i + 54.0657727682604*v_R2_c_r + 39.6392229058201*v_R2_n_i - 10.2713736253514*v_R2_n_r
        struct[0].g[246,0] = i_l_R1_R2_a_r + i_l_R1_R2_b_r + i_l_R1_R2_c_r - i_l_R1_R2_n_r
        struct[0].g[247,0] = i_l_R1_R2_a_i + i_l_R1_R2_b_i + i_l_R1_R2_c_i - i_l_R1_R2_n_i
        struct[0].g[248,0] = -i_l_D1_D3_a_r + 67.7048070412999*v_D1_a_r - 67.7048070412999*v_D3_a_r
        struct[0].g[249,0] = -i_l_D1_D3_a_i + 67.7048070412999*v_D1_a_i - 67.7048070412999*v_D3_a_i
        struct[0].g[250,0] = -i_l_D1_D3_b_r + 67.7048070412999*v_D1_b_r - 67.7048070412999*v_D3_b_r
        struct[0].g[251,0] = -i_l_D1_D3_b_i + 67.7048070412999*v_D1_b_i - 67.7048070412999*v_D3_b_i
        struct[0].g[252,0] = -i_l_D1_D3_c_r + 67.7048070412999*v_D1_c_r - 67.7048070412999*v_D3_c_r
        struct[0].g[253,0] = -i_l_D1_D3_c_i + 67.7048070412999*v_D1_c_i - 67.7048070412999*v_D3_c_i
        struct[0].g[254,0] = i_l_D1_D3_a_r + i_l_D1_D3_b_r + i_l_D1_D3_c_r - i_l_D1_D3_n_r
        struct[0].g[255,0] = i_l_D1_D3_a_i + i_l_D1_D3_b_i + i_l_D1_D3_c_i - i_l_D1_D3_n_i
        struct[0].g[256,0] = -i_l_D3_D4_a_r + 135.4096140826*v_D3_a_r - 135.4096140826*v_D4_a_r
        struct[0].g[257,0] = -i_l_D3_D4_a_i + 135.4096140826*v_D3_a_i - 135.4096140826*v_D4_a_i
        struct[0].g[258,0] = -i_l_D3_D4_b_r + 135.4096140826*v_D3_b_r - 135.4096140826*v_D4_b_r
        struct[0].g[259,0] = -i_l_D3_D4_b_i + 135.4096140826*v_D3_b_i - 135.4096140826*v_D4_b_i
        struct[0].g[260,0] = -i_l_D3_D4_c_r + 135.4096140826*v_D3_c_r - 135.4096140826*v_D4_c_r
        struct[0].g[261,0] = -i_l_D3_D4_c_i + 135.4096140826*v_D3_c_i - 135.4096140826*v_D4_c_i
        struct[0].g[262,0] = i_l_D3_D4_a_r + i_l_D3_D4_b_r + i_l_D3_D4_c_r - i_l_D3_D4_n_r
        struct[0].g[263,0] = i_l_D3_D4_a_i + i_l_D3_D4_b_i + i_l_D3_D4_c_i - i_l_D3_D4_n_i
        struct[0].g[264,0] = -i_l_D4_D6_a_r + 67.7048070412999*v_D4_a_r - 67.7048070412999*v_D6_a_r
        struct[0].g[265,0] = -i_l_D4_D6_a_i + 67.7048070412999*v_D4_a_i - 67.7048070412999*v_D6_a_i
        struct[0].g[266,0] = -i_l_D4_D6_b_r + 67.7048070412999*v_D4_b_r - 67.7048070412999*v_D6_b_r
        struct[0].g[267,0] = -i_l_D4_D6_b_i + 67.7048070412999*v_D4_b_i - 67.7048070412999*v_D6_b_i
        struct[0].g[268,0] = -i_l_D4_D6_c_r + 67.7048070412999*v_D4_c_r - 67.7048070412999*v_D6_c_r
        struct[0].g[269,0] = -i_l_D4_D6_c_i + 67.7048070412999*v_D4_c_i - 67.7048070412999*v_D6_c_i
        struct[0].g[270,0] = i_l_D4_D6_a_r + i_l_D4_D6_b_r + i_l_D4_D6_c_r - i_l_D4_D6_n_r
        struct[0].g[271,0] = i_l_D4_D6_a_i + i_l_D4_D6_b_i + i_l_D4_D6_c_i - i_l_D4_D6_n_i
        struct[0].g[272,0] = -i_l_D6_D9_a_r + 45.1365380275333*v_D6_a_r - 45.1365380275333*v_D9_a_r
        struct[0].g[273,0] = -i_l_D6_D9_a_i + 45.1365380275333*v_D6_a_i - 45.1365380275333*v_D9_a_i
        struct[0].g[274,0] = -i_l_D6_D9_b_r + 45.1365380275333*v_D6_b_r - 45.1365380275333*v_D9_b_r
        struct[0].g[275,0] = -i_l_D6_D9_b_i + 45.1365380275333*v_D6_b_i - 45.1365380275333*v_D9_b_i
        struct[0].g[276,0] = -i_l_D6_D9_c_r + 45.1365380275333*v_D6_c_r - 45.1365380275333*v_D9_c_r
        struct[0].g[277,0] = -i_l_D6_D9_c_i + 45.1365380275333*v_D6_c_i - 45.1365380275333*v_D9_c_i
        struct[0].g[278,0] = i_l_D6_D9_a_r + i_l_D6_D9_b_r + i_l_D6_D9_c_r - i_l_D6_D9_n_r
        struct[0].g[279,0] = i_l_D6_D9_a_i + i_l_D6_D9_b_i + i_l_D6_D9_c_i - i_l_D6_D9_n_i
        struct[0].g[280,0] = -i_l_D9_D10_a_r - 157.977883096366*v_D10_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[281,0] = -i_l_D9_D10_a_i - 157.977883096366*v_D10_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[282,0] = -i_l_D9_D10_b_r - 157.977883096366*v_D10_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[283,0] = -i_l_D9_D10_b_i - 157.977883096366*v_D10_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[284,0] = -i_l_D9_D10_c_r - 157.977883096366*v_D10_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[285,0] = -i_l_D9_D10_c_i - 157.977883096366*v_D10_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[286,0] = i_l_D9_D10_a_r + i_l_D9_D10_b_r + i_l_D9_D10_c_r - i_l_D9_D10_n_r
        struct[0].g[287,0] = i_l_D9_D10_a_i + i_l_D9_D10_b_i + i_l_D9_D10_c_i - i_l_D9_D10_n_i
        struct[0].g[288,0] = -i_l_D3_D11_a_r - 157.977883096366*v_D11_a_r + 157.977883096366*v_D3_a_r
        struct[0].g[289,0] = -i_l_D3_D11_a_i - 157.977883096366*v_D11_a_i + 157.977883096366*v_D3_a_i
        struct[0].g[290,0] = -i_l_D3_D11_b_r - 157.977883096366*v_D11_b_r + 157.977883096366*v_D3_b_r
        struct[0].g[291,0] = -i_l_D3_D11_b_i - 157.977883096366*v_D11_b_i + 157.977883096366*v_D3_b_i
        struct[0].g[292,0] = -i_l_D3_D11_c_r - 157.977883096366*v_D11_c_r + 157.977883096366*v_D3_c_r
        struct[0].g[293,0] = -i_l_D3_D11_c_i - 157.977883096366*v_D11_c_i + 157.977883096366*v_D3_c_i
        struct[0].g[294,0] = i_l_D3_D11_a_r + i_l_D3_D11_b_r + i_l_D3_D11_c_r - i_l_D3_D11_n_r
        struct[0].g[295,0] = i_l_D3_D11_a_i + i_l_D3_D11_b_i + i_l_D3_D11_c_i - i_l_D3_D11_n_i
        struct[0].g[296,0] = -i_l_D6_D16_a_r - 157.977883096366*v_D16_a_r + 157.977883096366*v_D6_a_r
        struct[0].g[297,0] = -i_l_D6_D16_a_i - 157.977883096366*v_D16_a_i + 157.977883096366*v_D6_a_i
        struct[0].g[298,0] = -i_l_D6_D16_b_r - 157.977883096366*v_D16_b_r + 157.977883096366*v_D6_b_r
        struct[0].g[299,0] = -i_l_D6_D16_b_i - 157.977883096366*v_D16_b_i + 157.977883096366*v_D6_b_i
        struct[0].g[300,0] = -i_l_D6_D16_c_r - 157.977883096366*v_D16_c_r + 157.977883096366*v_D6_c_r
        struct[0].g[301,0] = -i_l_D6_D16_c_i - 157.977883096366*v_D16_c_i + 157.977883096366*v_D6_c_i
        struct[0].g[302,0] = i_l_D6_D16_a_r + i_l_D6_D16_b_r + i_l_D6_D16_c_r - i_l_D6_D16_n_r
        struct[0].g[303,0] = i_l_D6_D16_a_i + i_l_D6_D16_b_i + i_l_D6_D16_c_i - i_l_D6_D16_n_i
        struct[0].g[304,0] = -i_l_D9_D17_a_r - 157.977883096366*v_D17_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[305,0] = -i_l_D9_D17_a_i - 157.977883096366*v_D17_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[306,0] = -i_l_D9_D17_b_r - 157.977883096366*v_D17_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[307,0] = -i_l_D9_D17_b_i - 157.977883096366*v_D17_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[308,0] = -i_l_D9_D17_c_r - 157.977883096366*v_D17_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[309,0] = -i_l_D9_D17_c_i - 157.977883096366*v_D17_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[310,0] = i_l_D9_D17_a_r + i_l_D9_D17_b_r + i_l_D9_D17_c_r - i_l_D9_D17_n_r
        struct[0].g[311,0] = i_l_D9_D17_a_i + i_l_D9_D17_b_i + i_l_D9_D17_c_i - i_l_D9_D17_n_i
        struct[0].g[312,0] = -i_l_D10_D18_a_r + 157.977883096366*v_D10_a_r - 157.977883096366*v_D18_a_r
        struct[0].g[313,0] = -i_l_D10_D18_a_i + 157.977883096366*v_D10_a_i - 157.977883096366*v_D18_a_i
        struct[0].g[314,0] = -i_l_D10_D18_b_r + 157.977883096366*v_D10_b_r - 157.977883096366*v_D18_b_r
        struct[0].g[315,0] = -i_l_D10_D18_b_i + 157.977883096366*v_D10_b_i - 157.977883096366*v_D18_b_i
        struct[0].g[316,0] = -i_l_D10_D18_c_r + 157.977883096366*v_D10_c_r - 157.977883096366*v_D18_c_r
        struct[0].g[317,0] = -i_l_D10_D18_c_i + 157.977883096366*v_D10_c_i - 157.977883096366*v_D18_c_i
        struct[0].g[318,0] = i_l_D10_D18_a_r + i_l_D10_D18_b_r + i_l_D10_D18_c_r - i_l_D10_D18_n_r
        struct[0].g[319,0] = i_l_D10_D18_a_i + i_l_D10_D18_b_i + i_l_D10_D18_c_i - i_l_D10_D18_n_i
        struct[0].g[320,0] = -i_l_D4_D14_a_r - 45.1365380275333*v_D14_a_r + 45.1365380275333*v_D4_a_r
        struct[0].g[321,0] = -i_l_D4_D14_a_i - 45.1365380275333*v_D14_a_i + 45.1365380275333*v_D4_a_i
        struct[0].g[322,0] = -i_l_D4_D14_b_r - 45.1365380275333*v_D14_b_r + 45.1365380275333*v_D4_b_r
        struct[0].g[323,0] = -i_l_D4_D14_b_i - 45.1365380275333*v_D14_b_i + 45.1365380275333*v_D4_b_i
        struct[0].g[324,0] = -i_l_D4_D14_c_r - 45.1365380275333*v_D14_c_r + 45.1365380275333*v_D4_c_r
        struct[0].g[325,0] = -i_l_D4_D14_c_i - 45.1365380275333*v_D14_c_i + 45.1365380275333*v_D4_c_i
        struct[0].g[326,0] = i_l_D4_D14_a_r + i_l_D4_D14_b_r + i_l_D4_D14_c_r - i_l_D4_D14_n_r
        struct[0].g[327,0] = i_l_D4_D14_a_i + i_l_D4_D14_b_i + i_l_D4_D14_c_i - i_l_D4_D14_n_i
        struct[0].g[328,0] = -i_l_D14_D15_a_r + 135.4096140826*v_D14_a_r - 135.4096140826*v_D15_a_r
        struct[0].g[329,0] = -i_l_D14_D15_a_i + 135.4096140826*v_D14_a_i - 135.4096140826*v_D15_a_i
        struct[0].g[330,0] = -i_l_D14_D15_b_r + 135.4096140826*v_D14_b_r - 135.4096140826*v_D15_b_r
        struct[0].g[331,0] = -i_l_D14_D15_b_i + 135.4096140826*v_D14_b_i - 135.4096140826*v_D15_b_i
        struct[0].g[332,0] = -i_l_D14_D15_c_r + 135.4096140826*v_D14_c_r - 135.4096140826*v_D15_c_r
        struct[0].g[333,0] = -i_l_D14_D15_c_i + 135.4096140826*v_D14_c_i - 135.4096140826*v_D15_c_i
        struct[0].g[334,0] = i_l_D14_D15_a_r + i_l_D14_D15_b_r + i_l_D14_D15_c_r - i_l_D14_D15_n_r
        struct[0].g[335,0] = i_l_D14_D15_a_i + i_l_D14_D15_b_i + i_l_D14_D15_c_i - i_l_D14_D15_n_i
        struct[0].g[336,0] = i_load_R1_a_i*v_R1_a_i - i_load_R1_a_i*v_R1_n_i + i_load_R1_a_r*v_R1_a_r - i_load_R1_a_r*v_R1_n_r - p_R1_a
        struct[0].g[337,0] = i_load_R1_b_i*v_R1_b_i - i_load_R1_b_i*v_R1_n_i + i_load_R1_b_r*v_R1_b_r - i_load_R1_b_r*v_R1_n_r - p_R1_b
        struct[0].g[338,0] = i_load_R1_c_i*v_R1_c_i - i_load_R1_c_i*v_R1_n_i + i_load_R1_c_r*v_R1_c_r - i_load_R1_c_r*v_R1_n_r - p_R1_c
        struct[0].g[339,0] = -i_load_R1_a_i*v_R1_a_r + i_load_R1_a_i*v_R1_n_r + i_load_R1_a_r*v_R1_a_i - i_load_R1_a_r*v_R1_n_i - q_R1_a
        struct[0].g[340,0] = -i_load_R1_b_i*v_R1_b_r + i_load_R1_b_i*v_R1_n_r + i_load_R1_b_r*v_R1_b_i - i_load_R1_b_r*v_R1_n_i - q_R1_b
        struct[0].g[341,0] = -i_load_R1_c_i*v_R1_c_r + i_load_R1_c_i*v_R1_n_r + i_load_R1_c_r*v_R1_c_i - i_load_R1_c_r*v_R1_n_i - q_R1_c
        struct[0].g[342,0] = i_load_R1_a_r + i_load_R1_b_r + i_load_R1_c_r + i_load_R1_n_r
        struct[0].g[343,0] = i_load_R1_a_i + i_load_R1_b_i + i_load_R1_c_i + i_load_R1_n_i
        struct[0].g[344,0] = i_load_R11_a_i*v_R11_a_i - i_load_R11_a_i*v_R11_n_i + i_load_R11_a_r*v_R11_a_r - i_load_R11_a_r*v_R11_n_r - p_R11_a
        struct[0].g[345,0] = i_load_R11_b_i*v_R11_b_i - i_load_R11_b_i*v_R11_n_i + i_load_R11_b_r*v_R11_b_r - i_load_R11_b_r*v_R11_n_r - p_R11_b
        struct[0].g[346,0] = i_load_R11_c_i*v_R11_c_i - i_load_R11_c_i*v_R11_n_i + i_load_R11_c_r*v_R11_c_r - i_load_R11_c_r*v_R11_n_r - p_R11_c
        struct[0].g[347,0] = -i_load_R11_a_i*v_R11_a_r + i_load_R11_a_i*v_R11_n_r + i_load_R11_a_r*v_R11_a_i - i_load_R11_a_r*v_R11_n_i - q_R11_a
        struct[0].g[348,0] = -i_load_R11_b_i*v_R11_b_r + i_load_R11_b_i*v_R11_n_r + i_load_R11_b_r*v_R11_b_i - i_load_R11_b_r*v_R11_n_i - q_R11_b
        struct[0].g[349,0] = -i_load_R11_c_i*v_R11_c_r + i_load_R11_c_i*v_R11_n_r + i_load_R11_c_r*v_R11_c_i - i_load_R11_c_r*v_R11_n_i - q_R11_c
        struct[0].g[350,0] = i_load_R11_a_r + i_load_R11_b_r + i_load_R11_c_r + i_load_R11_n_r
        struct[0].g[351,0] = i_load_R11_a_i + i_load_R11_b_i + i_load_R11_c_i + i_load_R11_n_i
        struct[0].g[352,0] = i_load_R15_a_i*v_R15_a_i - i_load_R15_a_i*v_R15_n_i + i_load_R15_a_r*v_R15_a_r - i_load_R15_a_r*v_R15_n_r - p_R15_a
        struct[0].g[353,0] = i_load_R15_b_i*v_R15_b_i - i_load_R15_b_i*v_R15_n_i + i_load_R15_b_r*v_R15_b_r - i_load_R15_b_r*v_R15_n_r - p_R15_b
        struct[0].g[354,0] = i_load_R15_c_i*v_R15_c_i - i_load_R15_c_i*v_R15_n_i + i_load_R15_c_r*v_R15_c_r - i_load_R15_c_r*v_R15_n_r - p_R15_c
        struct[0].g[355,0] = -i_load_R15_a_i*v_R15_a_r + i_load_R15_a_i*v_R15_n_r + i_load_R15_a_r*v_R15_a_i - i_load_R15_a_r*v_R15_n_i - q_R15_a
        struct[0].g[356,0] = -i_load_R15_b_i*v_R15_b_r + i_load_R15_b_i*v_R15_n_r + i_load_R15_b_r*v_R15_b_i - i_load_R15_b_r*v_R15_n_i - q_R15_b
        struct[0].g[357,0] = -i_load_R15_c_i*v_R15_c_r + i_load_R15_c_i*v_R15_n_r + i_load_R15_c_r*v_R15_c_i - i_load_R15_c_r*v_R15_n_i - q_R15_c
        struct[0].g[358,0] = i_load_R15_a_r + i_load_R15_b_r + i_load_R15_c_r + i_load_R15_n_r
        struct[0].g[359,0] = i_load_R15_a_i + i_load_R15_b_i + i_load_R15_c_i + i_load_R15_n_i
        struct[0].g[360,0] = i_load_R16_a_i*v_R16_a_i - i_load_R16_a_i*v_R16_n_i + i_load_R16_a_r*v_R16_a_r - i_load_R16_a_r*v_R16_n_r - p_R16_a
        struct[0].g[361,0] = i_load_R16_b_i*v_R16_b_i - i_load_R16_b_i*v_R16_n_i + i_load_R16_b_r*v_R16_b_r - i_load_R16_b_r*v_R16_n_r - p_R16_b
        struct[0].g[362,0] = i_load_R16_c_i*v_R16_c_i - i_load_R16_c_i*v_R16_n_i + i_load_R16_c_r*v_R16_c_r - i_load_R16_c_r*v_R16_n_r - p_R16_c
        struct[0].g[363,0] = -i_load_R16_a_i*v_R16_a_r + i_load_R16_a_i*v_R16_n_r + i_load_R16_a_r*v_R16_a_i - i_load_R16_a_r*v_R16_n_i - q_R16_a
        struct[0].g[364,0] = -i_load_R16_b_i*v_R16_b_r + i_load_R16_b_i*v_R16_n_r + i_load_R16_b_r*v_R16_b_i - i_load_R16_b_r*v_R16_n_i - q_R16_b
        struct[0].g[365,0] = -i_load_R16_c_i*v_R16_c_r + i_load_R16_c_i*v_R16_n_r + i_load_R16_c_r*v_R16_c_i - i_load_R16_c_r*v_R16_n_i - q_R16_c
        struct[0].g[366,0] = i_load_R16_a_r + i_load_R16_b_r + i_load_R16_c_r + i_load_R16_n_r
        struct[0].g[367,0] = i_load_R16_a_i + i_load_R16_b_i + i_load_R16_c_i + i_load_R16_n_i
        struct[0].g[368,0] = i_load_R17_a_i*v_R17_a_i - i_load_R17_a_i*v_R17_n_i + i_load_R17_a_r*v_R17_a_r - i_load_R17_a_r*v_R17_n_r - p_R17_a
        struct[0].g[369,0] = i_load_R17_b_i*v_R17_b_i - i_load_R17_b_i*v_R17_n_i + i_load_R17_b_r*v_R17_b_r - i_load_R17_b_r*v_R17_n_r - p_R17_b
        struct[0].g[370,0] = i_load_R17_c_i*v_R17_c_i - i_load_R17_c_i*v_R17_n_i + i_load_R17_c_r*v_R17_c_r - i_load_R17_c_r*v_R17_n_r - p_R17_c
        struct[0].g[371,0] = -i_load_R17_a_i*v_R17_a_r + i_load_R17_a_i*v_R17_n_r + i_load_R17_a_r*v_R17_a_i - i_load_R17_a_r*v_R17_n_i - q_R17_a
        struct[0].g[372,0] = -i_load_R17_b_i*v_R17_b_r + i_load_R17_b_i*v_R17_n_r + i_load_R17_b_r*v_R17_b_i - i_load_R17_b_r*v_R17_n_i - q_R17_b
        struct[0].g[373,0] = -i_load_R17_c_i*v_R17_c_r + i_load_R17_c_i*v_R17_n_r + i_load_R17_c_r*v_R17_c_i - i_load_R17_c_r*v_R17_n_i - q_R17_c
        struct[0].g[374,0] = i_load_R17_a_r + i_load_R17_b_r + i_load_R17_c_r + i_load_R17_n_r
        struct[0].g[375,0] = i_load_R17_a_i + i_load_R17_b_i + i_load_R17_c_i + i_load_R17_n_i
        struct[0].g[376,0] = i_load_R18_a_i*v_R18_a_i - i_load_R18_a_i*v_R18_n_i + i_load_R18_a_r*v_R18_a_r - i_load_R18_a_r*v_R18_n_r - p_R18_a
        struct[0].g[377,0] = i_load_R18_b_i*v_R18_b_i - i_load_R18_b_i*v_R18_n_i + i_load_R18_b_r*v_R18_b_r - i_load_R18_b_r*v_R18_n_r - p_R18_b
        struct[0].g[378,0] = i_load_R18_c_i*v_R18_c_i - i_load_R18_c_i*v_R18_n_i + i_load_R18_c_r*v_R18_c_r - i_load_R18_c_r*v_R18_n_r - p_R18_c
        struct[0].g[379,0] = -i_load_R18_a_i*v_R18_a_r + i_load_R18_a_i*v_R18_n_r + i_load_R18_a_r*v_R18_a_i - i_load_R18_a_r*v_R18_n_i - q_R18_a
        struct[0].g[380,0] = -i_load_R18_b_i*v_R18_b_r + i_load_R18_b_i*v_R18_n_r + i_load_R18_b_r*v_R18_b_i - i_load_R18_b_r*v_R18_n_i - q_R18_b
        struct[0].g[381,0] = -i_load_R18_c_i*v_R18_c_r + i_load_R18_c_i*v_R18_n_r + i_load_R18_c_r*v_R18_c_i - i_load_R18_c_r*v_R18_n_i - q_R18_c
        struct[0].g[382,0] = i_load_R18_a_r + i_load_R18_b_r + i_load_R18_c_r + i_load_R18_n_r
        struct[0].g[383,0] = i_load_R18_a_i + i_load_R18_b_i + i_load_R18_c_i + i_load_R18_n_i
        struct[0].g[384,0] = 1.0*i_load_D15_a_i*v_D15_a_i - 1.0*i_load_D15_a_i*v_D15_n_i + i_load_D15_a_r*v_D15_a_r - i_load_D15_a_r*v_D15_n_r - p_D15_1
        struct[0].g[385,0] = -1.0*i_load_D15_a_i*v_D15_a_r + 1.0*i_load_D15_a_i*v_D15_n_r + 1.0*i_load_D15_a_r*v_D15_a_i - 1.0*i_load_D15_a_r*v_D15_n_i - q_D15_1
        struct[0].g[386,0] = i_load_D15_a_r + i_load_D15_n_r
        struct[0].g[387,0] = 1.0*i_load_D15_a_i + 1.0*i_load_D15_n_i
        struct[0].g[388,0] = 1.0*i_load_D11_a_i*v_D11_a_i - 1.0*i_load_D11_a_i*v_D11_n_i + i_load_D11_a_r*v_D11_a_r - i_load_D11_a_r*v_D11_n_r - p_D11_1
        struct[0].g[389,0] = -1.0*i_load_D11_a_i*v_D11_a_r + 1.0*i_load_D11_a_i*v_D11_n_r + 1.0*i_load_D11_a_r*v_D11_a_i - 1.0*i_load_D11_a_r*v_D11_n_i - q_D11_1
        struct[0].g[390,0] = i_load_D11_a_r + i_load_D11_n_r
        struct[0].g[391,0] = 1.0*i_load_D11_a_i + 1.0*i_load_D11_n_i
        struct[0].g[392,0] = 1.0*i_load_D16_a_i*v_D16_a_i - 1.0*i_load_D16_a_i*v_D16_n_i + i_load_D16_a_r*v_D16_a_r - i_load_D16_a_r*v_D16_n_r - p_D16_1
        struct[0].g[393,0] = -1.0*i_load_D16_a_i*v_D16_a_r + 1.0*i_load_D16_a_i*v_D16_n_r + 1.0*i_load_D16_a_r*v_D16_a_i - 1.0*i_load_D16_a_r*v_D16_n_i - q_D16_1
        struct[0].g[394,0] = i_load_D16_a_r + i_load_D16_n_r
        struct[0].g[395,0] = 1.0*i_load_D16_a_i + 1.0*i_load_D16_n_i
        struct[0].g[396,0] = 1.0*i_load_D17_a_i*v_D17_a_i - 1.0*i_load_D17_a_i*v_D17_n_i + i_load_D17_a_r*v_D17_a_r - i_load_D17_a_r*v_D17_n_r - p_D17_1
        struct[0].g[397,0] = -1.0*i_load_D17_a_i*v_D17_a_r + 1.0*i_load_D17_a_i*v_D17_n_r + 1.0*i_load_D17_a_r*v_D17_a_i - 1.0*i_load_D17_a_r*v_D17_n_i - q_D17_1
        struct[0].g[398,0] = i_load_D17_a_r + i_load_D17_n_r
        struct[0].g[399,0] = 1.0*i_load_D17_a_i + 1.0*i_load_D17_n_i
        struct[0].g[400,0] = 1.0*i_load_D18_a_i*v_D18_a_i - 1.0*i_load_D18_a_i*v_D18_n_i + i_load_D18_a_r*v_D18_a_r - i_load_D18_a_r*v_D18_n_r - p_D18_1
        struct[0].g[401,0] = -1.0*i_load_D18_a_i*v_D18_a_r + 1.0*i_load_D18_a_i*v_D18_n_r + 1.0*i_load_D18_a_r*v_D18_a_i - 1.0*i_load_D18_a_r*v_D18_n_i - q_D18_1
        struct[0].g[402,0] = i_load_D18_a_r + i_load_D18_n_r
        struct[0].g[403,0] = 1.0*i_load_D18_a_i + 1.0*i_load_D18_n_i
        struct[0].g[404,0] = 1.0*i_vsc_R1_a_i*v_R1_a_i - 1.0*i_vsc_R1_a_i*v_R1_n_i + i_vsc_R1_a_r*v_R1_a_r - i_vsc_R1_a_r*v_R1_n_r - p_R1/3
        struct[0].g[405,0] = -1.0*i_vsc_R1_a_i*v_R1_a_r + 1.0*i_vsc_R1_a_i*v_R1_n_r + 1.0*i_vsc_R1_a_r*v_R1_a_i - 1.0*i_vsc_R1_a_r*v_R1_n_i - q_R1/3
        struct[0].g[406,0] = 1.0*i_vsc_R1_b_i*v_R1_b_i - 1.0*i_vsc_R1_b_i*v_R1_n_i + i_vsc_R1_b_r*v_R1_b_r - i_vsc_R1_b_r*v_R1_n_r - p_R1/3
        struct[0].g[407,0] = -1.0*i_vsc_R1_b_i*v_R1_b_r + 1.0*i_vsc_R1_b_i*v_R1_n_r + 1.0*i_vsc_R1_b_r*v_R1_b_i - 1.0*i_vsc_R1_b_r*v_R1_n_i - q_R1/3
        struct[0].g[408,0] = 1.0*i_vsc_R1_c_i*v_R1_c_i - 1.0*i_vsc_R1_c_i*v_R1_n_i + i_vsc_R1_c_r*v_R1_c_r - i_vsc_R1_c_r*v_R1_n_r - p_R1/3
        struct[0].g[409,0] = -1.0*i_vsc_R1_c_i*v_R1_c_r + 1.0*i_vsc_R1_c_i*v_R1_n_r + 1.0*i_vsc_R1_c_r*v_R1_c_i - 1.0*i_vsc_R1_c_r*v_R1_n_i - q_R1/3
        struct[0].g[410,0] = p_D1 + p_R1 + Piecewise(np.array([(-p_loss_R1, p_D1 < 0), (p_loss_R1, True)]))
        struct[0].g[411,0] = i_l_D1_D3_a_r*v_D1_a_r + i_l_D1_D3_n_r*v_D1_n_r - p_D1
        struct[0].g[412,0] = -a_R1 - b_R1*sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - c_R1*(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) + p_loss_R1
        struct[0].g[413,0] = -coef_a_R10*p_R10 + 1.0*i_vsc_R10_a_i*v_R10_a_i - 1.0*i_vsc_R10_a_i*v_R10_n_i + i_vsc_R10_a_r*v_R10_a_r - i_vsc_R10_a_r*v_R10_n_r
        struct[0].g[414,0] = -coef_a_R10*q_R10 - 1.0*i_vsc_R10_a_i*v_R10_a_r + 1.0*i_vsc_R10_a_i*v_R10_n_r + 1.0*i_vsc_R10_a_r*v_R10_a_i - 1.0*i_vsc_R10_a_r*v_R10_n_i
        struct[0].g[415,0] = -coef_b_R10*p_R10 + 1.0*i_vsc_R10_b_i*v_R10_b_i - 1.0*i_vsc_R10_b_i*v_R10_n_i + i_vsc_R10_b_r*v_R10_b_r - i_vsc_R10_b_r*v_R10_n_r
        struct[0].g[416,0] = -coef_b_R10*q_R10 - 1.0*i_vsc_R10_b_i*v_R10_b_r + 1.0*i_vsc_R10_b_i*v_R10_n_r + 1.0*i_vsc_R10_b_r*v_R10_b_i - 1.0*i_vsc_R10_b_r*v_R10_n_i
        struct[0].g[417,0] = -coef_c_R10*p_R10 + 1.0*i_vsc_R10_c_i*v_R10_c_i - 1.0*i_vsc_R10_c_i*v_R10_n_i + i_vsc_R10_c_r*v_R10_c_r - i_vsc_R10_c_r*v_R10_n_r
        struct[0].g[418,0] = -coef_c_R10*q_R10 - 1.0*i_vsc_R10_c_i*v_R10_c_r + 1.0*i_vsc_R10_c_i*v_R10_n_r + 1.0*i_vsc_R10_c_r*v_R10_c_i - 1.0*i_vsc_R10_c_r*v_R10_n_i
        struct[0].g[419,0] = i_vsc_D10_a_r + p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].g[420,0] = i_vsc_D10_n_r + p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].g[421,0] = p_D10 - p_R10 - Piecewise(np.array([(-p_loss_R10, p_D10 < 0), (p_loss_R10, True)]))
        struct[0].g[422,0] = -a_R10 - b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + p_loss_R10
        struct[0].g[423,0] = -coef_a_R14*p_R14 + 1.0*i_vsc_R14_a_i*v_R14_a_i - 1.0*i_vsc_R14_a_i*v_R14_n_i + i_vsc_R14_a_r*v_R14_a_r - i_vsc_R14_a_r*v_R14_n_r
        struct[0].g[424,0] = -coef_a_R14*q_R14 - 1.0*i_vsc_R14_a_i*v_R14_a_r + 1.0*i_vsc_R14_a_i*v_R14_n_r + 1.0*i_vsc_R14_a_r*v_R14_a_i - 1.0*i_vsc_R14_a_r*v_R14_n_i
        struct[0].g[425,0] = -coef_b_R14*p_R14 + 1.0*i_vsc_R14_b_i*v_R14_b_i - 1.0*i_vsc_R14_b_i*v_R14_n_i + i_vsc_R14_b_r*v_R14_b_r - i_vsc_R14_b_r*v_R14_n_r
        struct[0].g[426,0] = -coef_b_R14*q_R14 - 1.0*i_vsc_R14_b_i*v_R14_b_r + 1.0*i_vsc_R14_b_i*v_R14_n_r + 1.0*i_vsc_R14_b_r*v_R14_b_i - 1.0*i_vsc_R14_b_r*v_R14_n_i
        struct[0].g[427,0] = -coef_c_R14*p_R14 + 1.0*i_vsc_R14_c_i*v_R14_c_i - 1.0*i_vsc_R14_c_i*v_R14_n_i + i_vsc_R14_c_r*v_R14_c_r - i_vsc_R14_c_r*v_R14_n_r
        struct[0].g[428,0] = -coef_c_R14*q_R14 - 1.0*i_vsc_R14_c_i*v_R14_c_r + 1.0*i_vsc_R14_c_i*v_R14_n_r + 1.0*i_vsc_R14_c_r*v_R14_c_i - 1.0*i_vsc_R14_c_r*v_R14_n_i
        struct[0].g[429,0] = i_vsc_D14_a_r + p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].g[430,0] = i_vsc_D14_n_r + p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].g[431,0] = p_D14 - p_R14 - Piecewise(np.array([(-p_loss_R14, p_D14 < 0), (p_loss_R14, True)]))
        struct[0].g[432,0] = -a_R14 - b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + p_loss_R14
    
    # Outputs:
    if mode == 3:

        struct[0].h[0,0] = (v_R0_a_i**2 + v_R0_a_r**2)**0.5
        struct[0].h[1,0] = (v_R0_b_i**2 + v_R0_b_r**2)**0.5
        struct[0].h[2,0] = (v_R0_c_i**2 + v_R0_c_r**2)**0.5
        struct[0].h[3,0] = (v_D1_a_i**2 + v_D1_a_r**2)**0.5
        struct[0].h[4,0] = (v_D1_b_i**2 + v_D1_b_r**2)**0.5
        struct[0].h[5,0] = (v_D1_c_i**2 + v_D1_c_r**2)**0.5
        struct[0].h[6,0] = (v_R1_a_i**2 + v_R1_a_r**2)**0.5
        struct[0].h[7,0] = (v_R1_b_i**2 + v_R1_b_r**2)**0.5
        struct[0].h[8,0] = (v_R1_c_i**2 + v_R1_c_r**2)**0.5
        struct[0].h[9,0] = (v_R1_n_i**2 + v_R1_n_r**2)**0.5
        struct[0].h[10,0] = (v_R11_a_i**2 + v_R11_a_r**2)**0.5
        struct[0].h[11,0] = (v_R11_b_i**2 + v_R11_b_r**2)**0.5
        struct[0].h[12,0] = (v_R11_c_i**2 + v_R11_c_r**2)**0.5
        struct[0].h[13,0] = (v_R11_n_i**2 + v_R11_n_r**2)**0.5
        struct[0].h[14,0] = (v_R15_a_i**2 + v_R15_a_r**2)**0.5
        struct[0].h[15,0] = (v_R15_b_i**2 + v_R15_b_r**2)**0.5
        struct[0].h[16,0] = (v_R15_c_i**2 + v_R15_c_r**2)**0.5
        struct[0].h[17,0] = (v_R15_n_i**2 + v_R15_n_r**2)**0.5
        struct[0].h[18,0] = (v_R16_a_i**2 + v_R16_a_r**2)**0.5
        struct[0].h[19,0] = (v_R16_b_i**2 + v_R16_b_r**2)**0.5
        struct[0].h[20,0] = (v_R16_c_i**2 + v_R16_c_r**2)**0.5
        struct[0].h[21,0] = (v_R16_n_i**2 + v_R16_n_r**2)**0.5
        struct[0].h[22,0] = (v_R17_a_i**2 + v_R17_a_r**2)**0.5
        struct[0].h[23,0] = (v_R17_b_i**2 + v_R17_b_r**2)**0.5
        struct[0].h[24,0] = (v_R17_c_i**2 + v_R17_c_r**2)**0.5
        struct[0].h[25,0] = (v_R17_n_i**2 + v_R17_n_r**2)**0.5
        struct[0].h[26,0] = (v_R18_a_i**2 + v_R18_a_r**2)**0.5
        struct[0].h[27,0] = (v_R18_b_i**2 + v_R18_b_r**2)**0.5
        struct[0].h[28,0] = (v_R18_c_i**2 + v_R18_c_r**2)**0.5
        struct[0].h[29,0] = (v_R18_n_i**2 + v_R18_n_r**2)**0.5
        struct[0].h[30,0] = (v_D15_a_i**2 + v_D15_a_r**2)**0.5
        struct[0].h[31,0] = (v_D15_n_i**2 + v_D15_n_r**2)**0.5
        struct[0].h[32,0] = (v_D11_a_i**2 + v_D11_a_r**2)**0.5
        struct[0].h[33,0] = (v_D11_n_i**2 + v_D11_n_r**2)**0.5
        struct[0].h[34,0] = (v_D16_a_i**2 + v_D16_a_r**2)**0.5
        struct[0].h[35,0] = (v_D16_n_i**2 + v_D16_n_r**2)**0.5
        struct[0].h[36,0] = (v_D17_a_i**2 + v_D17_a_r**2)**0.5
        struct[0].h[37,0] = (v_D17_n_i**2 + v_D17_n_r**2)**0.5
        struct[0].h[38,0] = (v_D18_a_i**2 + v_D18_a_r**2)**0.5
        struct[0].h[39,0] = (v_D18_n_i**2 + v_D18_n_r**2)**0.5
        struct[0].h[40,0] = (v_R2_a_i**2 + v_R2_a_r**2)**0.5
        struct[0].h[41,0] = (v_R2_b_i**2 + v_R2_b_r**2)**0.5
        struct[0].h[42,0] = (v_R2_c_i**2 + v_R2_c_r**2)**0.5
        struct[0].h[43,0] = (v_R2_n_i**2 + v_R2_n_r**2)**0.5
        struct[0].h[44,0] = (v_R3_a_i**2 + v_R3_a_r**2)**0.5
        struct[0].h[45,0] = (v_R3_b_i**2 + v_R3_b_r**2)**0.5
        struct[0].h[46,0] = (v_R3_c_i**2 + v_R3_c_r**2)**0.5
        struct[0].h[47,0] = (v_R3_n_i**2 + v_R3_n_r**2)**0.5
        struct[0].h[48,0] = (v_R4_a_i**2 + v_R4_a_r**2)**0.5
        struct[0].h[49,0] = (v_R4_b_i**2 + v_R4_b_r**2)**0.5
        struct[0].h[50,0] = (v_R4_c_i**2 + v_R4_c_r**2)**0.5
        struct[0].h[51,0] = (v_R4_n_i**2 + v_R4_n_r**2)**0.5
        struct[0].h[52,0] = (v_R5_a_i**2 + v_R5_a_r**2)**0.5
        struct[0].h[53,0] = (v_R5_b_i**2 + v_R5_b_r**2)**0.5
        struct[0].h[54,0] = (v_R5_c_i**2 + v_R5_c_r**2)**0.5
        struct[0].h[55,0] = (v_R5_n_i**2 + v_R5_n_r**2)**0.5
        struct[0].h[56,0] = (v_R6_a_i**2 + v_R6_a_r**2)**0.5
        struct[0].h[57,0] = (v_R6_b_i**2 + v_R6_b_r**2)**0.5
        struct[0].h[58,0] = (v_R6_c_i**2 + v_R6_c_r**2)**0.5
        struct[0].h[59,0] = (v_R6_n_i**2 + v_R6_n_r**2)**0.5
        struct[0].h[60,0] = (v_R7_a_i**2 + v_R7_a_r**2)**0.5
        struct[0].h[61,0] = (v_R7_b_i**2 + v_R7_b_r**2)**0.5
        struct[0].h[62,0] = (v_R7_c_i**2 + v_R7_c_r**2)**0.5
        struct[0].h[63,0] = (v_R7_n_i**2 + v_R7_n_r**2)**0.5
        struct[0].h[64,0] = (v_R8_a_i**2 + v_R8_a_r**2)**0.5
        struct[0].h[65,0] = (v_R8_b_i**2 + v_R8_b_r**2)**0.5
        struct[0].h[66,0] = (v_R8_c_i**2 + v_R8_c_r**2)**0.5
        struct[0].h[67,0] = (v_R8_n_i**2 + v_R8_n_r**2)**0.5
        struct[0].h[68,0] = (v_R9_a_i**2 + v_R9_a_r**2)**0.5
        struct[0].h[69,0] = (v_R9_b_i**2 + v_R9_b_r**2)**0.5
        struct[0].h[70,0] = (v_R9_c_i**2 + v_R9_c_r**2)**0.5
        struct[0].h[71,0] = (v_R9_n_i**2 + v_R9_n_r**2)**0.5
        struct[0].h[72,0] = (v_R10_a_i**2 + v_R10_a_r**2)**0.5
        struct[0].h[73,0] = (v_R10_b_i**2 + v_R10_b_r**2)**0.5
        struct[0].h[74,0] = (v_R10_c_i**2 + v_R10_c_r**2)**0.5
        struct[0].h[75,0] = (v_R10_n_i**2 + v_R10_n_r**2)**0.5
        struct[0].h[76,0] = (v_R12_a_i**2 + v_R12_a_r**2)**0.5
        struct[0].h[77,0] = (v_R12_b_i**2 + v_R12_b_r**2)**0.5
        struct[0].h[78,0] = (v_R12_c_i**2 + v_R12_c_r**2)**0.5
        struct[0].h[79,0] = (v_R12_n_i**2 + v_R12_n_r**2)**0.5
        struct[0].h[80,0] = (v_R13_a_i**2 + v_R13_a_r**2)**0.5
        struct[0].h[81,0] = (v_R13_b_i**2 + v_R13_b_r**2)**0.5
        struct[0].h[82,0] = (v_R13_c_i**2 + v_R13_c_r**2)**0.5
        struct[0].h[83,0] = (v_R13_n_i**2 + v_R13_n_r**2)**0.5
        struct[0].h[84,0] = (v_R14_a_i**2 + v_R14_a_r**2)**0.5
        struct[0].h[85,0] = (v_R14_b_i**2 + v_R14_b_r**2)**0.5
        struct[0].h[86,0] = (v_R14_c_i**2 + v_R14_c_r**2)**0.5
        struct[0].h[87,0] = (v_R14_n_i**2 + v_R14_n_r**2)**0.5
        struct[0].h[88,0] = (v_D1_n_i**2 + v_D1_n_r**2)**0.5
        struct[0].h[89,0] = (v_D3_a_i**2 + v_D3_a_r**2)**0.5
        struct[0].h[90,0] = (v_D3_b_i**2 + v_D3_b_r**2)**0.5
        struct[0].h[91,0] = (v_D3_c_i**2 + v_D3_c_r**2)**0.5
        struct[0].h[92,0] = (v_D3_n_i**2 + v_D3_n_r**2)**0.5
        struct[0].h[93,0] = (v_D4_a_i**2 + v_D4_a_r**2)**0.5
        struct[0].h[94,0] = (v_D4_b_i**2 + v_D4_b_r**2)**0.5
        struct[0].h[95,0] = (v_D4_c_i**2 + v_D4_c_r**2)**0.5
        struct[0].h[96,0] = (v_D4_n_i**2 + v_D4_n_r**2)**0.5
        struct[0].h[97,0] = (v_D6_a_i**2 + v_D6_a_r**2)**0.5
        struct[0].h[98,0] = (v_D6_b_i**2 + v_D6_b_r**2)**0.5
        struct[0].h[99,0] = (v_D6_c_i**2 + v_D6_c_r**2)**0.5
        struct[0].h[100,0] = (v_D6_n_i**2 + v_D6_n_r**2)**0.5
        struct[0].h[101,0] = (v_D9_a_i**2 + v_D9_a_r**2)**0.5
        struct[0].h[102,0] = (v_D9_b_i**2 + v_D9_b_r**2)**0.5
        struct[0].h[103,0] = (v_D9_c_i**2 + v_D9_c_r**2)**0.5
        struct[0].h[104,0] = (v_D9_n_i**2 + v_D9_n_r**2)**0.5
        struct[0].h[105,0] = (v_D10_a_i**2 + v_D10_a_r**2)**0.5
        struct[0].h[106,0] = (v_D10_b_i**2 + v_D10_b_r**2)**0.5
        struct[0].h[107,0] = (v_D10_c_i**2 + v_D10_c_r**2)**0.5
        struct[0].h[108,0] = (v_D10_n_i**2 + v_D10_n_r**2)**0.5
        struct[0].h[109,0] = (v_D11_b_i**2 + v_D11_b_r**2)**0.5
        struct[0].h[110,0] = (v_D11_c_i**2 + v_D11_c_r**2)**0.5
        struct[0].h[111,0] = (v_D16_b_i**2 + v_D16_b_r**2)**0.5
        struct[0].h[112,0] = (v_D16_c_i**2 + v_D16_c_r**2)**0.5
        struct[0].h[113,0] = (v_D17_b_i**2 + v_D17_b_r**2)**0.5
        struct[0].h[114,0] = (v_D17_c_i**2 + v_D17_c_r**2)**0.5
        struct[0].h[115,0] = (v_D18_b_i**2 + v_D18_b_r**2)**0.5
        struct[0].h[116,0] = (v_D18_c_i**2 + v_D18_c_r**2)**0.5
        struct[0].h[117,0] = (v_D14_a_i**2 + v_D14_a_r**2)**0.5
        struct[0].h[118,0] = (v_D14_b_i**2 + v_D14_b_r**2)**0.5
        struct[0].h[119,0] = (v_D14_c_i**2 + v_D14_c_r**2)**0.5
        struct[0].h[120,0] = (v_D14_n_i**2 + v_D14_n_r**2)**0.5
        struct[0].h[121,0] = (v_D15_b_i**2 + v_D15_b_r**2)**0.5
        struct[0].h[122,0] = (v_D15_c_i**2 + v_D15_c_r**2)**0.5
    

    if mode == 10:

        struct[0].Fx[0,0] = -1

    if mode == 11:


        struct[0].Gy[0,0] = -123.954122254357
        struct[0].Gy[0,1] = -127.595184532966
        struct[0].Gy[0,2] = 39.6392229058202
        struct[0].Gy[0,3] = 10.2713736253513
        struct[0].Gy[0,4] = 24.9575997948692
        struct[0].Gy[0,5] = 23.2849644809540
        struct[0].Gy[0,6] = 58.0215758469966
        struct[0].Gy[0,7] = 83.8007853900572
        struct[0].Gy[0,68] = 105.571769313180
        struct[0].Gy[0,69] = 54.0657727682604
        struct[0].Gy[0,70] = -39.6392229058202
        struct[0].Gy[0,71] = -10.2713736253513
        struct[0].Gy[0,72] = -24.9575997948692
        struct[0].Gy[0,73] = -23.2849644809540
        struct[0].Gy[0,74] = -39.6392229058202
        struct[0].Gy[0,75] = -10.2713736253513
        struct[0].Gy[0,336] = 1
        struct[0].Gy[0,404] = 1
        struct[0].Gy[1,0] = 127.595184532966
        struct[0].Gy[1,1] = -123.954122254357
        struct[0].Gy[1,2] = -10.2713736253513
        struct[0].Gy[1,3] = 39.6392229058202
        struct[0].Gy[1,4] = -23.2849644809540
        struct[0].Gy[1,5] = 24.9575997948692
        struct[0].Gy[1,6] = -83.8007853900572
        struct[0].Gy[1,7] = 58.0215758469966
        struct[0].Gy[1,68] = -54.0657727682604
        struct[0].Gy[1,69] = 105.571769313180
        struct[0].Gy[1,70] = 10.2713736253513
        struct[0].Gy[1,71] = -39.6392229058202
        struct[0].Gy[1,72] = 23.2849644809540
        struct[0].Gy[1,73] = -24.9575997948692
        struct[0].Gy[1,74] = 10.2713736253513
        struct[0].Gy[1,75] = -39.6392229058202
        struct[0].Gy[1,337] = 1
        struct[0].Gy[1,405] = 1
        struct[0].Gy[2,0] = 39.6392229058202
        struct[0].Gy[2,1] = 10.2713736253513
        struct[0].Gy[2,2] = -123.954122254357
        struct[0].Gy[2,3] = -127.595184532966
        struct[0].Gy[2,4] = 39.6392229058201
        struct[0].Gy[2,5] = 10.2713736253513
        struct[0].Gy[2,6] = 43.3399527360457
        struct[0].Gy[2,7] = 96.8143762456598
        struct[0].Gy[2,68] = -39.6392229058202
        struct[0].Gy[2,69] = -10.2713736253513
        struct[0].Gy[2,70] = 105.571769313180
        struct[0].Gy[2,71] = 54.0657727682604
        struct[0].Gy[2,72] = -39.6392229058201
        struct[0].Gy[2,73] = -10.2713736253513
        struct[0].Gy[2,74] = -24.9575997948692
        struct[0].Gy[2,75] = -23.2849644809540
        struct[0].Gy[2,338] = 1
        struct[0].Gy[2,406] = 1
        struct[0].Gy[3,0] = -10.2713736253513
        struct[0].Gy[3,1] = 39.6392229058202
        struct[0].Gy[3,2] = 127.595184532966
        struct[0].Gy[3,3] = -123.954122254357
        struct[0].Gy[3,4] = -10.2713736253513
        struct[0].Gy[3,5] = 39.6392229058201
        struct[0].Gy[3,6] = -96.8143762456598
        struct[0].Gy[3,7] = 43.3399527360457
        struct[0].Gy[3,68] = 10.2713736253513
        struct[0].Gy[3,69] = -39.6392229058202
        struct[0].Gy[3,70] = -54.0657727682604
        struct[0].Gy[3,71] = 105.571769313180
        struct[0].Gy[3,72] = 10.2713736253513
        struct[0].Gy[3,73] = -39.6392229058201
        struct[0].Gy[3,74] = 23.2849644809540
        struct[0].Gy[3,75] = -24.9575997948692
        struct[0].Gy[3,339] = 1
        struct[0].Gy[3,407] = 1
        struct[0].Gy[4,0] = 24.9575997948692
        struct[0].Gy[4,1] = 23.2849644809540
        struct[0].Gy[4,2] = 39.6392229058202
        struct[0].Gy[4,3] = 10.2713736253513
        struct[0].Gy[4,4] = -123.954122254357
        struct[0].Gy[4,5] = -127.595184532966
        struct[0].Gy[4,6] = 58.0215758469966
        struct[0].Gy[4,7] = 83.8007853900572
        struct[0].Gy[4,68] = -24.9575997948692
        struct[0].Gy[4,69] = -23.2849644809540
        struct[0].Gy[4,70] = -39.6392229058202
        struct[0].Gy[4,71] = -10.2713736253513
        struct[0].Gy[4,72] = 105.571769313180
        struct[0].Gy[4,73] = 54.0657727682604
        struct[0].Gy[4,74] = -39.6392229058201
        struct[0].Gy[4,75] = -10.2713736253514
        struct[0].Gy[4,340] = 1
        struct[0].Gy[4,408] = 1
        struct[0].Gy[5,0] = -23.2849644809540
        struct[0].Gy[5,1] = 24.9575997948692
        struct[0].Gy[5,2] = -10.2713736253513
        struct[0].Gy[5,3] = 39.6392229058202
        struct[0].Gy[5,4] = 127.595184532966
        struct[0].Gy[5,5] = -123.954122254357
        struct[0].Gy[5,6] = -83.8007853900572
        struct[0].Gy[5,7] = 58.0215758469966
        struct[0].Gy[5,68] = 23.2849644809540
        struct[0].Gy[5,69] = -24.9575997948692
        struct[0].Gy[5,70] = 10.2713736253513
        struct[0].Gy[5,71] = -39.6392229058202
        struct[0].Gy[5,72] = -54.0657727682604
        struct[0].Gy[5,73] = 105.571769313180
        struct[0].Gy[5,74] = 10.2713736253514
        struct[0].Gy[5,75] = -39.6392229058201
        struct[0].Gy[5,341] = 1
        struct[0].Gy[5,409] = 1
        struct[0].Gy[6,0] = 58.0215758469966
        struct[0].Gy[6,1] = 83.8007853900572
        struct[0].Gy[6,2] = 43.3399527360457
        struct[0].Gy[6,3] = 96.8143762456598
        struct[0].Gy[6,4] = 58.0215758469966
        struct[0].Gy[6,5] = 83.8007853900572
        struct[0].Gy[6,6] = -161.052161470043
        struct[0].Gy[6,7] = -274.654008062378
        struct[0].Gy[6,68] = -39.6392229058202
        struct[0].Gy[6,69] = -10.2713736253513
        struct[0].Gy[6,70] = -24.9575997948692
        struct[0].Gy[6,71] = -23.2849644809540
        struct[0].Gy[6,72] = -39.6392229058202
        struct[0].Gy[6,73] = -10.2713736253513
        struct[0].Gy[6,74] = 105.571769313180
        struct[0].Gy[6,75] = 54.0657727682604
        struct[0].Gy[7,0] = -83.8007853900572
        struct[0].Gy[7,1] = 58.0215758469966
        struct[0].Gy[7,2] = -96.8143762456598
        struct[0].Gy[7,3] = 43.3399527360457
        struct[0].Gy[7,4] = -83.8007853900572
        struct[0].Gy[7,5] = 58.0215758469966
        struct[0].Gy[7,6] = 274.654008062378
        struct[0].Gy[7,7] = -161.052161470043
        struct[0].Gy[7,68] = 10.2713736253513
        struct[0].Gy[7,69] = -39.6392229058202
        struct[0].Gy[7,70] = 23.2849644809540
        struct[0].Gy[7,71] = -24.9575997948692
        struct[0].Gy[7,72] = 10.2713736253513
        struct[0].Gy[7,73] = -39.6392229058202
        struct[0].Gy[7,74] = -54.0657727682604
        struct[0].Gy[7,75] = 105.571769313180
        struct[0].Gy[8,8] = -26.5300693004806
        struct[0].Gy[8,9] = -4.84676915585801
        struct[0].Gy[8,10] = 7.89461337514770
        struct[0].Gy[8,11] = -1.58482814504483
        struct[0].Gy[8,12] = 7.72144347466701
        struct[0].Gy[8,13] = -0.679918453285310
        struct[0].Gy[8,14] = 7.89461337514771
        struct[0].Gy[8,15] = -1.58482814504483
        struct[0].Gy[8,76] = 26.5300693004806
        struct[0].Gy[8,77] = 4.84676915585801
        struct[0].Gy[8,78] = -7.89461337514770
        struct[0].Gy[8,79] = 1.58482814504483
        struct[0].Gy[8,80] = -7.72144347466701
        struct[0].Gy[8,81] = 0.679918453285310
        struct[0].Gy[8,82] = -7.89461337514771
        struct[0].Gy[8,83] = 1.58482814504483
        struct[0].Gy[8,344] = 1
        struct[0].Gy[9,8] = 4.84676915585801
        struct[0].Gy[9,9] = -26.5300693004806
        struct[0].Gy[9,10] = 1.58482814504483
        struct[0].Gy[9,11] = 7.89461337514770
        struct[0].Gy[9,12] = 0.679918453285310
        struct[0].Gy[9,13] = 7.72144347466701
        struct[0].Gy[9,14] = 1.58482814504483
        struct[0].Gy[9,15] = 7.89461337514771
        struct[0].Gy[9,76] = -4.84676915585801
        struct[0].Gy[9,77] = 26.5300693004806
        struct[0].Gy[9,78] = -1.58482814504483
        struct[0].Gy[9,79] = -7.89461337514770
        struct[0].Gy[9,80] = -0.679918453285310
        struct[0].Gy[9,81] = -7.72144347466701
        struct[0].Gy[9,82] = -1.58482814504483
        struct[0].Gy[9,83] = -7.89461337514771
        struct[0].Gy[9,345] = 1
        struct[0].Gy[10,8] = 7.89461337514771
        struct[0].Gy[10,9] = -1.58482814504483
        struct[0].Gy[10,10] = -26.5300693004806
        struct[0].Gy[10,11] = -4.84676915585801
        struct[0].Gy[10,12] = 7.89461337514771
        struct[0].Gy[10,13] = -1.58482814504483
        struct[0].Gy[10,14] = 7.72144347466701
        struct[0].Gy[10,15] = -0.679918453285308
        struct[0].Gy[10,76] = -7.89461337514771
        struct[0].Gy[10,77] = 1.58482814504483
        struct[0].Gy[10,78] = 26.5300693004806
        struct[0].Gy[10,79] = 4.84676915585801
        struct[0].Gy[10,80] = -7.89461337514771
        struct[0].Gy[10,81] = 1.58482814504483
        struct[0].Gy[10,82] = -7.72144347466701
        struct[0].Gy[10,83] = 0.679918453285308
        struct[0].Gy[10,346] = 1
        struct[0].Gy[11,8] = 1.58482814504483
        struct[0].Gy[11,9] = 7.89461337514771
        struct[0].Gy[11,10] = 4.84676915585801
        struct[0].Gy[11,11] = -26.5300693004806
        struct[0].Gy[11,12] = 1.58482814504483
        struct[0].Gy[11,13] = 7.89461337514771
        struct[0].Gy[11,14] = 0.679918453285308
        struct[0].Gy[11,15] = 7.72144347466701
        struct[0].Gy[11,76] = -1.58482814504483
        struct[0].Gy[11,77] = -7.89461337514771
        struct[0].Gy[11,78] = -4.84676915585801
        struct[0].Gy[11,79] = 26.5300693004806
        struct[0].Gy[11,80] = -1.58482814504483
        struct[0].Gy[11,81] = -7.89461337514771
        struct[0].Gy[11,82] = -0.679918453285308
        struct[0].Gy[11,83] = -7.72144347466701
        struct[0].Gy[11,347] = 1
        struct[0].Gy[12,8] = 7.72144347466701
        struct[0].Gy[12,9] = -0.679918453285310
        struct[0].Gy[12,10] = 7.89461337514770
        struct[0].Gy[12,11] = -1.58482814504483
        struct[0].Gy[12,12] = -26.5300693004806
        struct[0].Gy[12,13] = -4.84676915585801
        struct[0].Gy[12,14] = 7.89461337514771
        struct[0].Gy[12,15] = -1.58482814504483
        struct[0].Gy[12,76] = -7.72144347466701
        struct[0].Gy[12,77] = 0.679918453285310
        struct[0].Gy[12,78] = -7.89461337514770
        struct[0].Gy[12,79] = 1.58482814504483
        struct[0].Gy[12,80] = 26.5300693004806
        struct[0].Gy[12,81] = 4.84676915585801
        struct[0].Gy[12,82] = -7.89461337514771
        struct[0].Gy[12,83] = 1.58482814504483
        struct[0].Gy[12,348] = 1
        struct[0].Gy[13,8] = 0.679918453285310
        struct[0].Gy[13,9] = 7.72144347466701
        struct[0].Gy[13,10] = 1.58482814504483
        struct[0].Gy[13,11] = 7.89461337514770
        struct[0].Gy[13,12] = 4.84676915585801
        struct[0].Gy[13,13] = -26.5300693004806
        struct[0].Gy[13,14] = 1.58482814504483
        struct[0].Gy[13,15] = 7.89461337514771
        struct[0].Gy[13,76] = -0.679918453285310
        struct[0].Gy[13,77] = -7.72144347466701
        struct[0].Gy[13,78] = -1.58482814504483
        struct[0].Gy[13,79] = -7.89461337514770
        struct[0].Gy[13,80] = -4.84676915585801
        struct[0].Gy[13,81] = 26.5300693004806
        struct[0].Gy[13,82] = -1.58482814504483
        struct[0].Gy[13,83] = -7.89461337514771
        struct[0].Gy[13,349] = 1
        struct[0].Gy[14,8] = 7.89461337514771
        struct[0].Gy[14,9] = -1.58482814504483
        struct[0].Gy[14,10] = 7.72144347466701
        struct[0].Gy[14,11] = -0.679918453285308
        struct[0].Gy[14,12] = 7.89461337514771
        struct[0].Gy[14,13] = -1.58482814504483
        struct[0].Gy[14,14] = -26.5550693004806
        struct[0].Gy[14,15] = -4.84676915585801
        struct[0].Gy[14,76] = -7.89461337514771
        struct[0].Gy[14,77] = 1.58482814504483
        struct[0].Gy[14,78] = -7.72144347466701
        struct[0].Gy[14,79] = 0.679918453285308
        struct[0].Gy[14,80] = -7.89461337514771
        struct[0].Gy[14,81] = 1.58482814504483
        struct[0].Gy[14,82] = 26.5300693004806
        struct[0].Gy[14,83] = 4.84676915585801
        struct[0].Gy[15,8] = 1.58482814504483
        struct[0].Gy[15,9] = 7.89461337514771
        struct[0].Gy[15,10] = 0.679918453285308
        struct[0].Gy[15,11] = 7.72144347466701
        struct[0].Gy[15,12] = 1.58482814504483
        struct[0].Gy[15,13] = 7.89461337514771
        struct[0].Gy[15,14] = 4.84676915585801
        struct[0].Gy[15,15] = -26.5550693004806
        struct[0].Gy[15,76] = -1.58482814504483
        struct[0].Gy[15,77] = -7.89461337514771
        struct[0].Gy[15,78] = -0.679918453285308
        struct[0].Gy[15,79] = -7.72144347466701
        struct[0].Gy[15,80] = -1.58482814504483
        struct[0].Gy[15,81] = -7.89461337514771
        struct[0].Gy[15,82] = -4.84676915585801
        struct[0].Gy[15,83] = 26.5300693004806
        struct[0].Gy[16,16] = -26.5300693004806
        struct[0].Gy[16,17] = -4.84676915585801
        struct[0].Gy[16,18] = 7.89461337514770
        struct[0].Gy[16,19] = -1.58482814504483
        struct[0].Gy[16,20] = 7.72144347466701
        struct[0].Gy[16,21] = -0.679918453285310
        struct[0].Gy[16,22] = 7.89461337514771
        struct[0].Gy[16,23] = -1.58482814504483
        struct[0].Gy[16,156] = 26.5300693004806
        struct[0].Gy[16,157] = 4.84676915585801
        struct[0].Gy[16,158] = -7.89461337514770
        struct[0].Gy[16,159] = 1.58482814504483
        struct[0].Gy[16,160] = -7.72144347466701
        struct[0].Gy[16,161] = 0.679918453285310
        struct[0].Gy[16,162] = -7.89461337514771
        struct[0].Gy[16,163] = 1.58482814504483
        struct[0].Gy[16,352] = 1
        struct[0].Gy[17,16] = 4.84676915585801
        struct[0].Gy[17,17] = -26.5300693004806
        struct[0].Gy[17,18] = 1.58482814504483
        struct[0].Gy[17,19] = 7.89461337514770
        struct[0].Gy[17,20] = 0.679918453285310
        struct[0].Gy[17,21] = 7.72144347466701
        struct[0].Gy[17,22] = 1.58482814504483
        struct[0].Gy[17,23] = 7.89461337514771
        struct[0].Gy[17,156] = -4.84676915585801
        struct[0].Gy[17,157] = 26.5300693004806
        struct[0].Gy[17,158] = -1.58482814504483
        struct[0].Gy[17,159] = -7.89461337514770
        struct[0].Gy[17,160] = -0.679918453285310
        struct[0].Gy[17,161] = -7.72144347466701
        struct[0].Gy[17,162] = -1.58482814504483
        struct[0].Gy[17,163] = -7.89461337514771
        struct[0].Gy[17,353] = 1
        struct[0].Gy[18,16] = 7.89461337514771
        struct[0].Gy[18,17] = -1.58482814504483
        struct[0].Gy[18,18] = -26.5300693004806
        struct[0].Gy[18,19] = -4.84676915585801
        struct[0].Gy[18,20] = 7.89461337514771
        struct[0].Gy[18,21] = -1.58482814504483
        struct[0].Gy[18,22] = 7.72144347466701
        struct[0].Gy[18,23] = -0.679918453285308
        struct[0].Gy[18,156] = -7.89461337514771
        struct[0].Gy[18,157] = 1.58482814504483
        struct[0].Gy[18,158] = 26.5300693004806
        struct[0].Gy[18,159] = 4.84676915585801
        struct[0].Gy[18,160] = -7.89461337514771
        struct[0].Gy[18,161] = 1.58482814504483
        struct[0].Gy[18,162] = -7.72144347466701
        struct[0].Gy[18,163] = 0.679918453285308
        struct[0].Gy[18,354] = 1
        struct[0].Gy[19,16] = 1.58482814504483
        struct[0].Gy[19,17] = 7.89461337514771
        struct[0].Gy[19,18] = 4.84676915585801
        struct[0].Gy[19,19] = -26.5300693004806
        struct[0].Gy[19,20] = 1.58482814504483
        struct[0].Gy[19,21] = 7.89461337514771
        struct[0].Gy[19,22] = 0.679918453285308
        struct[0].Gy[19,23] = 7.72144347466701
        struct[0].Gy[19,156] = -1.58482814504483
        struct[0].Gy[19,157] = -7.89461337514771
        struct[0].Gy[19,158] = -4.84676915585801
        struct[0].Gy[19,159] = 26.5300693004806
        struct[0].Gy[19,160] = -1.58482814504483
        struct[0].Gy[19,161] = -7.89461337514771
        struct[0].Gy[19,162] = -0.679918453285308
        struct[0].Gy[19,163] = -7.72144347466701
        struct[0].Gy[19,355] = 1
        struct[0].Gy[20,16] = 7.72144347466701
        struct[0].Gy[20,17] = -0.679918453285310
        struct[0].Gy[20,18] = 7.89461337514770
        struct[0].Gy[20,19] = -1.58482814504483
        struct[0].Gy[20,20] = -26.5300693004806
        struct[0].Gy[20,21] = -4.84676915585801
        struct[0].Gy[20,22] = 7.89461337514771
        struct[0].Gy[20,23] = -1.58482814504483
        struct[0].Gy[20,156] = -7.72144347466701
        struct[0].Gy[20,157] = 0.679918453285310
        struct[0].Gy[20,158] = -7.89461337514770
        struct[0].Gy[20,159] = 1.58482814504483
        struct[0].Gy[20,160] = 26.5300693004806
        struct[0].Gy[20,161] = 4.84676915585801
        struct[0].Gy[20,162] = -7.89461337514771
        struct[0].Gy[20,163] = 1.58482814504483
        struct[0].Gy[20,356] = 1
        struct[0].Gy[21,16] = 0.679918453285310
        struct[0].Gy[21,17] = 7.72144347466701
        struct[0].Gy[21,18] = 1.58482814504483
        struct[0].Gy[21,19] = 7.89461337514770
        struct[0].Gy[21,20] = 4.84676915585801
        struct[0].Gy[21,21] = -26.5300693004806
        struct[0].Gy[21,22] = 1.58482814504483
        struct[0].Gy[21,23] = 7.89461337514771
        struct[0].Gy[21,156] = -0.679918453285310
        struct[0].Gy[21,157] = -7.72144347466701
        struct[0].Gy[21,158] = -1.58482814504483
        struct[0].Gy[21,159] = -7.89461337514770
        struct[0].Gy[21,160] = -4.84676915585801
        struct[0].Gy[21,161] = 26.5300693004806
        struct[0].Gy[21,162] = -1.58482814504483
        struct[0].Gy[21,163] = -7.89461337514771
        struct[0].Gy[21,357] = 1
        struct[0].Gy[22,16] = 7.89461337514771
        struct[0].Gy[22,17] = -1.58482814504483
        struct[0].Gy[22,18] = 7.72144347466701
        struct[0].Gy[22,19] = -0.679918453285308
        struct[0].Gy[22,20] = 7.89461337514771
        struct[0].Gy[22,21] = -1.58482814504483
        struct[0].Gy[22,22] = -26.5550693004806
        struct[0].Gy[22,23] = -4.84676915585801
        struct[0].Gy[22,156] = -7.89461337514771
        struct[0].Gy[22,157] = 1.58482814504483
        struct[0].Gy[22,158] = -7.72144347466701
        struct[0].Gy[22,159] = 0.679918453285308
        struct[0].Gy[22,160] = -7.89461337514771
        struct[0].Gy[22,161] = 1.58482814504483
        struct[0].Gy[22,162] = 26.5300693004806
        struct[0].Gy[22,163] = 4.84676915585801
        struct[0].Gy[23,16] = 1.58482814504483
        struct[0].Gy[23,17] = 7.89461337514771
        struct[0].Gy[23,18] = 0.679918453285308
        struct[0].Gy[23,19] = 7.72144347466701
        struct[0].Gy[23,20] = 1.58482814504483
        struct[0].Gy[23,21] = 7.89461337514771
        struct[0].Gy[23,22] = 4.84676915585801
        struct[0].Gy[23,23] = -26.5550693004806
        struct[0].Gy[23,156] = -1.58482814504483
        struct[0].Gy[23,157] = -7.89461337514771
        struct[0].Gy[23,158] = -0.679918453285308
        struct[0].Gy[23,159] = -7.72144347466701
        struct[0].Gy[23,160] = -1.58482814504483
        struct[0].Gy[23,161] = -7.89461337514771
        struct[0].Gy[23,162] = -4.84676915585801
        struct[0].Gy[23,163] = 26.5300693004806
        struct[0].Gy[24,24] = -30.9517475172273
        struct[0].Gy[24,25] = -5.65456401516768
        struct[0].Gy[24,26] = 9.21038227100566
        struct[0].Gy[24,27] = -1.84896616921897
        struct[0].Gy[24,28] = 9.00835072044485
        struct[0].Gy[24,29] = -0.793238195499529
        struct[0].Gy[24,30] = 9.21038227100566
        struct[0].Gy[24,31] = -1.84896616921897
        struct[0].Gy[24,100] = 30.9517475172273
        struct[0].Gy[24,101] = 5.65456401516768
        struct[0].Gy[24,102] = -9.21038227100566
        struct[0].Gy[24,103] = 1.84896616921897
        struct[0].Gy[24,104] = -9.00835072044485
        struct[0].Gy[24,105] = 0.793238195499529
        struct[0].Gy[24,106] = -9.21038227100566
        struct[0].Gy[24,107] = 1.84896616921897
        struct[0].Gy[24,360] = 1
        struct[0].Gy[25,24] = 5.65456401516768
        struct[0].Gy[25,25] = -30.9517475172273
        struct[0].Gy[25,26] = 1.84896616921897
        struct[0].Gy[25,27] = 9.21038227100566
        struct[0].Gy[25,28] = 0.793238195499529
        struct[0].Gy[25,29] = 9.00835072044485
        struct[0].Gy[25,30] = 1.84896616921897
        struct[0].Gy[25,31] = 9.21038227100566
        struct[0].Gy[25,100] = -5.65456401516768
        struct[0].Gy[25,101] = 30.9517475172273
        struct[0].Gy[25,102] = -1.84896616921897
        struct[0].Gy[25,103] = -9.21038227100566
        struct[0].Gy[25,104] = -0.793238195499529
        struct[0].Gy[25,105] = -9.00835072044485
        struct[0].Gy[25,106] = -1.84896616921897
        struct[0].Gy[25,107] = -9.21038227100566
        struct[0].Gy[25,361] = 1
        struct[0].Gy[26,24] = 9.21038227100566
        struct[0].Gy[26,25] = -1.84896616921897
        struct[0].Gy[26,26] = -30.9517475172273
        struct[0].Gy[26,27] = -5.65456401516768
        struct[0].Gy[26,28] = 9.21038227100566
        struct[0].Gy[26,29] = -1.84896616921897
        struct[0].Gy[26,30] = 9.00835072044485
        struct[0].Gy[26,31] = -0.793238195499528
        struct[0].Gy[26,100] = -9.21038227100566
        struct[0].Gy[26,101] = 1.84896616921897
        struct[0].Gy[26,102] = 30.9517475172273
        struct[0].Gy[26,103] = 5.65456401516768
        struct[0].Gy[26,104] = -9.21038227100566
        struct[0].Gy[26,105] = 1.84896616921897
        struct[0].Gy[26,106] = -9.00835072044485
        struct[0].Gy[26,107] = 0.793238195499528
        struct[0].Gy[26,362] = 1
        struct[0].Gy[27,24] = 1.84896616921897
        struct[0].Gy[27,25] = 9.21038227100566
        struct[0].Gy[27,26] = 5.65456401516768
        struct[0].Gy[27,27] = -30.9517475172273
        struct[0].Gy[27,28] = 1.84896616921897
        struct[0].Gy[27,29] = 9.21038227100566
        struct[0].Gy[27,30] = 0.793238195499528
        struct[0].Gy[27,31] = 9.00835072044485
        struct[0].Gy[27,100] = -1.84896616921897
        struct[0].Gy[27,101] = -9.21038227100566
        struct[0].Gy[27,102] = -5.65456401516768
        struct[0].Gy[27,103] = 30.9517475172273
        struct[0].Gy[27,104] = -1.84896616921897
        struct[0].Gy[27,105] = -9.21038227100566
        struct[0].Gy[27,106] = -0.793238195499528
        struct[0].Gy[27,107] = -9.00835072044485
        struct[0].Gy[27,363] = 1
        struct[0].Gy[28,24] = 9.00835072044484
        struct[0].Gy[28,25] = -0.793238195499527
        struct[0].Gy[28,26] = 9.21038227100566
        struct[0].Gy[28,27] = -1.84896616921897
        struct[0].Gy[28,28] = -30.9517475172273
        struct[0].Gy[28,29] = -5.65456401516768
        struct[0].Gy[28,30] = 9.21038227100566
        struct[0].Gy[28,31] = -1.84896616921897
        struct[0].Gy[28,100] = -9.00835072044484
        struct[0].Gy[28,101] = 0.793238195499527
        struct[0].Gy[28,102] = -9.21038227100566
        struct[0].Gy[28,103] = 1.84896616921897
        struct[0].Gy[28,104] = 30.9517475172273
        struct[0].Gy[28,105] = 5.65456401516768
        struct[0].Gy[28,106] = -9.21038227100566
        struct[0].Gy[28,107] = 1.84896616921897
        struct[0].Gy[28,364] = 1
        struct[0].Gy[29,24] = 0.793238195499527
        struct[0].Gy[29,25] = 9.00835072044484
        struct[0].Gy[29,26] = 1.84896616921897
        struct[0].Gy[29,27] = 9.21038227100566
        struct[0].Gy[29,28] = 5.65456401516768
        struct[0].Gy[29,29] = -30.9517475172273
        struct[0].Gy[29,30] = 1.84896616921897
        struct[0].Gy[29,31] = 9.21038227100566
        struct[0].Gy[29,100] = -0.793238195499527
        struct[0].Gy[29,101] = -9.00835072044484
        struct[0].Gy[29,102] = -1.84896616921897
        struct[0].Gy[29,103] = -9.21038227100566
        struct[0].Gy[29,104] = -5.65456401516768
        struct[0].Gy[29,105] = 30.9517475172273
        struct[0].Gy[29,106] = -1.84896616921897
        struct[0].Gy[29,107] = -9.21038227100566
        struct[0].Gy[29,365] = 1
        struct[0].Gy[30,24] = 9.21038227100566
        struct[0].Gy[30,25] = -1.84896616921897
        struct[0].Gy[30,26] = 9.00835072044485
        struct[0].Gy[30,27] = -0.793238195499527
        struct[0].Gy[30,28] = 9.21038227100566
        struct[0].Gy[30,29] = -1.84896616921897
        struct[0].Gy[30,30] = -30.9767475172273
        struct[0].Gy[30,31] = -5.65456401516768
        struct[0].Gy[30,100] = -9.21038227100566
        struct[0].Gy[30,101] = 1.84896616921897
        struct[0].Gy[30,102] = -9.00835072044485
        struct[0].Gy[30,103] = 0.793238195499527
        struct[0].Gy[30,104] = -9.21038227100566
        struct[0].Gy[30,105] = 1.84896616921897
        struct[0].Gy[30,106] = 30.9517475172273
        struct[0].Gy[30,107] = 5.65456401516768
        struct[0].Gy[31,24] = 1.84896616921897
        struct[0].Gy[31,25] = 9.21038227100566
        struct[0].Gy[31,26] = 0.793238195499527
        struct[0].Gy[31,27] = 9.00835072044485
        struct[0].Gy[31,28] = 1.84896616921897
        struct[0].Gy[31,29] = 9.21038227100566
        struct[0].Gy[31,30] = 5.65456401516768
        struct[0].Gy[31,31] = -30.9767475172273
        struct[0].Gy[31,100] = -1.84896616921897
        struct[0].Gy[31,101] = -9.21038227100566
        struct[0].Gy[31,102] = -0.793238195499527
        struct[0].Gy[31,103] = -9.00835072044485
        struct[0].Gy[31,104] = -1.84896616921897
        struct[0].Gy[31,105] = -9.21038227100566
        struct[0].Gy[31,106] = -5.65456401516768
        struct[0].Gy[31,107] = 30.9517475172273
        struct[0].Gy[32,32] = -30.9517475172273
        struct[0].Gy[32,33] = -5.65456401516768
        struct[0].Gy[32,34] = 9.21038227100566
        struct[0].Gy[32,35] = -1.84896616921897
        struct[0].Gy[32,36] = 9.00835072044485
        struct[0].Gy[32,37] = -0.793238195499529
        struct[0].Gy[32,38] = 9.21038227100566
        struct[0].Gy[32,39] = -1.84896616921897
        struct[0].Gy[32,124] = 30.9517475172273
        struct[0].Gy[32,125] = 5.65456401516768
        struct[0].Gy[32,126] = -9.21038227100566
        struct[0].Gy[32,127] = 1.84896616921897
        struct[0].Gy[32,128] = -9.00835072044485
        struct[0].Gy[32,129] = 0.793238195499529
        struct[0].Gy[32,130] = -9.21038227100566
        struct[0].Gy[32,131] = 1.84896616921897
        struct[0].Gy[32,368] = 1
        struct[0].Gy[33,32] = 5.65456401516768
        struct[0].Gy[33,33] = -30.9517475172273
        struct[0].Gy[33,34] = 1.84896616921897
        struct[0].Gy[33,35] = 9.21038227100566
        struct[0].Gy[33,36] = 0.793238195499529
        struct[0].Gy[33,37] = 9.00835072044485
        struct[0].Gy[33,38] = 1.84896616921897
        struct[0].Gy[33,39] = 9.21038227100566
        struct[0].Gy[33,124] = -5.65456401516768
        struct[0].Gy[33,125] = 30.9517475172273
        struct[0].Gy[33,126] = -1.84896616921897
        struct[0].Gy[33,127] = -9.21038227100566
        struct[0].Gy[33,128] = -0.793238195499529
        struct[0].Gy[33,129] = -9.00835072044485
        struct[0].Gy[33,130] = -1.84896616921897
        struct[0].Gy[33,131] = -9.21038227100566
        struct[0].Gy[33,369] = 1
        struct[0].Gy[34,32] = 9.21038227100566
        struct[0].Gy[34,33] = -1.84896616921897
        struct[0].Gy[34,34] = -30.9517475172273
        struct[0].Gy[34,35] = -5.65456401516768
        struct[0].Gy[34,36] = 9.21038227100566
        struct[0].Gy[34,37] = -1.84896616921897
        struct[0].Gy[34,38] = 9.00835072044485
        struct[0].Gy[34,39] = -0.793238195499528
        struct[0].Gy[34,124] = -9.21038227100566
        struct[0].Gy[34,125] = 1.84896616921897
        struct[0].Gy[34,126] = 30.9517475172273
        struct[0].Gy[34,127] = 5.65456401516768
        struct[0].Gy[34,128] = -9.21038227100566
        struct[0].Gy[34,129] = 1.84896616921897
        struct[0].Gy[34,130] = -9.00835072044485
        struct[0].Gy[34,131] = 0.793238195499528
        struct[0].Gy[34,370] = 1
        struct[0].Gy[35,32] = 1.84896616921897
        struct[0].Gy[35,33] = 9.21038227100566
        struct[0].Gy[35,34] = 5.65456401516768
        struct[0].Gy[35,35] = -30.9517475172273
        struct[0].Gy[35,36] = 1.84896616921897
        struct[0].Gy[35,37] = 9.21038227100566
        struct[0].Gy[35,38] = 0.793238195499528
        struct[0].Gy[35,39] = 9.00835072044485
        struct[0].Gy[35,124] = -1.84896616921897
        struct[0].Gy[35,125] = -9.21038227100566
        struct[0].Gy[35,126] = -5.65456401516768
        struct[0].Gy[35,127] = 30.9517475172273
        struct[0].Gy[35,128] = -1.84896616921897
        struct[0].Gy[35,129] = -9.21038227100566
        struct[0].Gy[35,130] = -0.793238195499528
        struct[0].Gy[35,131] = -9.00835072044485
        struct[0].Gy[35,371] = 1
        struct[0].Gy[36,32] = 9.00835072044484
        struct[0].Gy[36,33] = -0.793238195499527
        struct[0].Gy[36,34] = 9.21038227100566
        struct[0].Gy[36,35] = -1.84896616921897
        struct[0].Gy[36,36] = -30.9517475172273
        struct[0].Gy[36,37] = -5.65456401516768
        struct[0].Gy[36,38] = 9.21038227100566
        struct[0].Gy[36,39] = -1.84896616921897
        struct[0].Gy[36,124] = -9.00835072044484
        struct[0].Gy[36,125] = 0.793238195499527
        struct[0].Gy[36,126] = -9.21038227100566
        struct[0].Gy[36,127] = 1.84896616921897
        struct[0].Gy[36,128] = 30.9517475172273
        struct[0].Gy[36,129] = 5.65456401516768
        struct[0].Gy[36,130] = -9.21038227100566
        struct[0].Gy[36,131] = 1.84896616921897
        struct[0].Gy[36,372] = 1
        struct[0].Gy[37,32] = 0.793238195499527
        struct[0].Gy[37,33] = 9.00835072044484
        struct[0].Gy[37,34] = 1.84896616921897
        struct[0].Gy[37,35] = 9.21038227100566
        struct[0].Gy[37,36] = 5.65456401516768
        struct[0].Gy[37,37] = -30.9517475172273
        struct[0].Gy[37,38] = 1.84896616921897
        struct[0].Gy[37,39] = 9.21038227100566
        struct[0].Gy[37,124] = -0.793238195499527
        struct[0].Gy[37,125] = -9.00835072044484
        struct[0].Gy[37,126] = -1.84896616921897
        struct[0].Gy[37,127] = -9.21038227100566
        struct[0].Gy[37,128] = -5.65456401516768
        struct[0].Gy[37,129] = 30.9517475172273
        struct[0].Gy[37,130] = -1.84896616921897
        struct[0].Gy[37,131] = -9.21038227100566
        struct[0].Gy[37,373] = 1
        struct[0].Gy[38,32] = 9.21038227100566
        struct[0].Gy[38,33] = -1.84896616921897
        struct[0].Gy[38,34] = 9.00835072044485
        struct[0].Gy[38,35] = -0.793238195499527
        struct[0].Gy[38,36] = 9.21038227100566
        struct[0].Gy[38,37] = -1.84896616921897
        struct[0].Gy[38,38] = -30.9767475172273
        struct[0].Gy[38,39] = -5.65456401516768
        struct[0].Gy[38,124] = -9.21038227100566
        struct[0].Gy[38,125] = 1.84896616921897
        struct[0].Gy[38,126] = -9.00835072044485
        struct[0].Gy[38,127] = 0.793238195499527
        struct[0].Gy[38,128] = -9.21038227100566
        struct[0].Gy[38,129] = 1.84896616921897
        struct[0].Gy[38,130] = 30.9517475172273
        struct[0].Gy[38,131] = 5.65456401516768
        struct[0].Gy[39,32] = 1.84896616921897
        struct[0].Gy[39,33] = 9.21038227100566
        struct[0].Gy[39,34] = 0.793238195499527
        struct[0].Gy[39,35] = 9.00835072044485
        struct[0].Gy[39,36] = 1.84896616921897
        struct[0].Gy[39,37] = 9.21038227100566
        struct[0].Gy[39,38] = 5.65456401516768
        struct[0].Gy[39,39] = -30.9767475172273
        struct[0].Gy[39,124] = -1.84896616921897
        struct[0].Gy[39,125] = -9.21038227100566
        struct[0].Gy[39,126] = -0.793238195499527
        struct[0].Gy[39,127] = -9.00835072044485
        struct[0].Gy[39,128] = -1.84896616921897
        struct[0].Gy[39,129] = -9.21038227100566
        struct[0].Gy[39,130] = -5.65456401516768
        struct[0].Gy[39,131] = 30.9517475172273
        struct[0].Gy[40,40] = -30.9517475172273
        struct[0].Gy[40,41] = -5.65456401516768
        struct[0].Gy[40,42] = 9.21038227100566
        struct[0].Gy[40,43] = -1.84896616921897
        struct[0].Gy[40,44] = 9.00835072044485
        struct[0].Gy[40,45] = -0.793238195499529
        struct[0].Gy[40,46] = 9.21038227100566
        struct[0].Gy[40,47] = -1.84896616921897
        struct[0].Gy[40,132] = 30.9517475172273
        struct[0].Gy[40,133] = 5.65456401516768
        struct[0].Gy[40,134] = -9.21038227100566
        struct[0].Gy[40,135] = 1.84896616921897
        struct[0].Gy[40,136] = -9.00835072044485
        struct[0].Gy[40,137] = 0.793238195499529
        struct[0].Gy[40,138] = -9.21038227100566
        struct[0].Gy[40,139] = 1.84896616921897
        struct[0].Gy[40,376] = 1
        struct[0].Gy[41,40] = 5.65456401516768
        struct[0].Gy[41,41] = -30.9517475172273
        struct[0].Gy[41,42] = 1.84896616921897
        struct[0].Gy[41,43] = 9.21038227100566
        struct[0].Gy[41,44] = 0.793238195499529
        struct[0].Gy[41,45] = 9.00835072044485
        struct[0].Gy[41,46] = 1.84896616921897
        struct[0].Gy[41,47] = 9.21038227100566
        struct[0].Gy[41,132] = -5.65456401516768
        struct[0].Gy[41,133] = 30.9517475172273
        struct[0].Gy[41,134] = -1.84896616921897
        struct[0].Gy[41,135] = -9.21038227100566
        struct[0].Gy[41,136] = -0.793238195499529
        struct[0].Gy[41,137] = -9.00835072044485
        struct[0].Gy[41,138] = -1.84896616921897
        struct[0].Gy[41,139] = -9.21038227100566
        struct[0].Gy[41,377] = 1
        struct[0].Gy[42,40] = 9.21038227100566
        struct[0].Gy[42,41] = -1.84896616921897
        struct[0].Gy[42,42] = -30.9517475172273
        struct[0].Gy[42,43] = -5.65456401516768
        struct[0].Gy[42,44] = 9.21038227100566
        struct[0].Gy[42,45] = -1.84896616921897
        struct[0].Gy[42,46] = 9.00835072044485
        struct[0].Gy[42,47] = -0.793238195499528
        struct[0].Gy[42,132] = -9.21038227100566
        struct[0].Gy[42,133] = 1.84896616921897
        struct[0].Gy[42,134] = 30.9517475172273
        struct[0].Gy[42,135] = 5.65456401516768
        struct[0].Gy[42,136] = -9.21038227100566
        struct[0].Gy[42,137] = 1.84896616921897
        struct[0].Gy[42,138] = -9.00835072044485
        struct[0].Gy[42,139] = 0.793238195499528
        struct[0].Gy[42,378] = 1
        struct[0].Gy[43,40] = 1.84896616921897
        struct[0].Gy[43,41] = 9.21038227100566
        struct[0].Gy[43,42] = 5.65456401516768
        struct[0].Gy[43,43] = -30.9517475172273
        struct[0].Gy[43,44] = 1.84896616921897
        struct[0].Gy[43,45] = 9.21038227100566
        struct[0].Gy[43,46] = 0.793238195499528
        struct[0].Gy[43,47] = 9.00835072044485
        struct[0].Gy[43,132] = -1.84896616921897
        struct[0].Gy[43,133] = -9.21038227100566
        struct[0].Gy[43,134] = -5.65456401516768
        struct[0].Gy[43,135] = 30.9517475172273
        struct[0].Gy[43,136] = -1.84896616921897
        struct[0].Gy[43,137] = -9.21038227100566
        struct[0].Gy[43,138] = -0.793238195499528
        struct[0].Gy[43,139] = -9.00835072044485
        struct[0].Gy[43,379] = 1
        struct[0].Gy[44,40] = 9.00835072044484
        struct[0].Gy[44,41] = -0.793238195499527
        struct[0].Gy[44,42] = 9.21038227100566
        struct[0].Gy[44,43] = -1.84896616921897
        struct[0].Gy[44,44] = -30.9517475172273
        struct[0].Gy[44,45] = -5.65456401516768
        struct[0].Gy[44,46] = 9.21038227100566
        struct[0].Gy[44,47] = -1.84896616921897
        struct[0].Gy[44,132] = -9.00835072044484
        struct[0].Gy[44,133] = 0.793238195499527
        struct[0].Gy[44,134] = -9.21038227100566
        struct[0].Gy[44,135] = 1.84896616921897
        struct[0].Gy[44,136] = 30.9517475172273
        struct[0].Gy[44,137] = 5.65456401516768
        struct[0].Gy[44,138] = -9.21038227100566
        struct[0].Gy[44,139] = 1.84896616921897
        struct[0].Gy[44,380] = 1
        struct[0].Gy[45,40] = 0.793238195499527
        struct[0].Gy[45,41] = 9.00835072044484
        struct[0].Gy[45,42] = 1.84896616921897
        struct[0].Gy[45,43] = 9.21038227100566
        struct[0].Gy[45,44] = 5.65456401516768
        struct[0].Gy[45,45] = -30.9517475172273
        struct[0].Gy[45,46] = 1.84896616921897
        struct[0].Gy[45,47] = 9.21038227100566
        struct[0].Gy[45,132] = -0.793238195499527
        struct[0].Gy[45,133] = -9.00835072044484
        struct[0].Gy[45,134] = -1.84896616921897
        struct[0].Gy[45,135] = -9.21038227100566
        struct[0].Gy[45,136] = -5.65456401516768
        struct[0].Gy[45,137] = 30.9517475172273
        struct[0].Gy[45,138] = -1.84896616921897
        struct[0].Gy[45,139] = -9.21038227100566
        struct[0].Gy[45,381] = 1
        struct[0].Gy[46,40] = 9.21038227100566
        struct[0].Gy[46,41] = -1.84896616921897
        struct[0].Gy[46,42] = 9.00835072044485
        struct[0].Gy[46,43] = -0.793238195499527
        struct[0].Gy[46,44] = 9.21038227100566
        struct[0].Gy[46,45] = -1.84896616921897
        struct[0].Gy[46,46] = -30.9767475172273
        struct[0].Gy[46,47] = -5.65456401516768
        struct[0].Gy[46,132] = -9.21038227100566
        struct[0].Gy[46,133] = 1.84896616921897
        struct[0].Gy[46,134] = -9.00835072044485
        struct[0].Gy[46,135] = 0.793238195499527
        struct[0].Gy[46,136] = -9.21038227100566
        struct[0].Gy[46,137] = 1.84896616921897
        struct[0].Gy[46,138] = 30.9517475172273
        struct[0].Gy[46,139] = 5.65456401516768
        struct[0].Gy[47,40] = 1.84896616921897
        struct[0].Gy[47,41] = 9.21038227100566
        struct[0].Gy[47,42] = 0.793238195499527
        struct[0].Gy[47,43] = 9.00835072044485
        struct[0].Gy[47,44] = 1.84896616921897
        struct[0].Gy[47,45] = 9.21038227100566
        struct[0].Gy[47,46] = 5.65456401516768
        struct[0].Gy[47,47] = -30.9767475172273
        struct[0].Gy[47,132] = -1.84896616921897
        struct[0].Gy[47,133] = -9.21038227100566
        struct[0].Gy[47,134] = -0.793238195499527
        struct[0].Gy[47,135] = -9.00835072044485
        struct[0].Gy[47,136] = -1.84896616921897
        struct[0].Gy[47,137] = -9.21038227100566
        struct[0].Gy[47,138] = -5.65456401516768
        struct[0].Gy[47,139] = 30.9517475172273
        struct[0].Gy[48,48] = -135.409614082600
        struct[0].Gy[48,222] = 135.409614082600
        struct[0].Gy[48,384] = 1
        struct[0].Gy[49,49] = -135.409614082600
        struct[0].Gy[49,223] = 135.409614082600
        struct[0].Gy[49,385] = 1
        struct[0].Gy[50,50] = -135.409614082600
        struct[0].Gy[50,228] = 135.409614082600
        struct[0].Gy[50,386] = 1
        struct[0].Gy[51,51] = -135.409614082600
        struct[0].Gy[51,229] = 135.409614082600
        struct[0].Gy[51,387] = 1
        struct[0].Gy[52,52] = -157.977883096366
        struct[0].Gy[52,166] = 157.977883096366
        struct[0].Gy[52,388] = 1
        struct[0].Gy[53,53] = -157.977883096366
        struct[0].Gy[53,167] = 157.977883096366
        struct[0].Gy[53,389] = 1
        struct[0].Gy[54,54] = -157.977883096366
        struct[0].Gy[54,172] = 157.977883096366
        struct[0].Gy[54,390] = 1
        struct[0].Gy[55,55] = -157.977883096366
        struct[0].Gy[55,173] = 157.977883096366
        struct[0].Gy[55,391] = 1
        struct[0].Gy[56,56] = -157.977883096366
        struct[0].Gy[56,182] = 157.977883096366
        struct[0].Gy[56,392] = 1
        struct[0].Gy[57,57] = -157.977883096366
        struct[0].Gy[57,183] = 157.977883096366
        struct[0].Gy[57,393] = 1
        struct[0].Gy[58,58] = -157.977883096366
        struct[0].Gy[58,188] = 157.977883096366
        struct[0].Gy[58,394] = 1
        struct[0].Gy[59,59] = -157.977883096366
        struct[0].Gy[59,189] = 157.977883096366
        struct[0].Gy[59,395] = 1
        struct[0].Gy[60,60] = -157.977883096366
        struct[0].Gy[60,190] = 157.977883096366
        struct[0].Gy[60,396] = 1
        struct[0].Gy[61,61] = -157.977883096366
        struct[0].Gy[61,191] = 157.977883096366
        struct[0].Gy[61,397] = 1
        struct[0].Gy[62,62] = -157.977883096366
        struct[0].Gy[62,196] = 157.977883096366
        struct[0].Gy[62,398] = 1
        struct[0].Gy[63,63] = -157.977883096366
        struct[0].Gy[63,197] = 157.977883096366
        struct[0].Gy[63,399] = 1
        struct[0].Gy[64,64] = -157.977883096366
        struct[0].Gy[64,198] = 157.977883096366
        struct[0].Gy[64,400] = 1
        struct[0].Gy[65,65] = -157.977883096366
        struct[0].Gy[65,199] = 157.977883096366
        struct[0].Gy[65,401] = 1
        struct[0].Gy[66,66] = -157.977883096366
        struct[0].Gy[66,204] = 157.977883096366
        struct[0].Gy[66,402] = 1
        struct[0].Gy[67,67] = -157.977883096366
        struct[0].Gy[67,205] = 157.977883096366
        struct[0].Gy[67,403] = 1
        struct[0].Gy[68,0] = 105.571769313180
        struct[0].Gy[68,1] = 54.0657727682604
        struct[0].Gy[68,2] = -39.6392229058202
        struct[0].Gy[68,3] = -10.2713736253513
        struct[0].Gy[68,4] = -24.9575997948692
        struct[0].Gy[68,5] = -23.2849644809540
        struct[0].Gy[68,6] = -39.6392229058202
        struct[0].Gy[68,7] = -10.2713736253513
        struct[0].Gy[68,68] = -211.143538626360
        struct[0].Gy[68,69] = -108.131545536521
        struct[0].Gy[68,70] = 79.2784458116403
        struct[0].Gy[68,71] = 20.5427472507027
        struct[0].Gy[68,72] = 49.9151995897384
        struct[0].Gy[68,73] = 46.5699289619080
        struct[0].Gy[68,74] = 79.2784458116403
        struct[0].Gy[68,75] = 20.5427472507027
        struct[0].Gy[68,76] = 105.571769313180
        struct[0].Gy[68,77] = 54.0657727682604
        struct[0].Gy[68,78] = -39.6392229058202
        struct[0].Gy[68,79] = -10.2713736253513
        struct[0].Gy[68,80] = -24.9575997948692
        struct[0].Gy[68,81] = -23.2849644809540
        struct[0].Gy[68,82] = -39.6392229058202
        struct[0].Gy[68,83] = -10.2713736253513
        struct[0].Gy[69,0] = -54.0657727682604
        struct[0].Gy[69,1] = 105.571769313180
        struct[0].Gy[69,2] = 10.2713736253513
        struct[0].Gy[69,3] = -39.6392229058202
        struct[0].Gy[69,4] = 23.2849644809540
        struct[0].Gy[69,5] = -24.9575997948692
        struct[0].Gy[69,6] = 10.2713736253513
        struct[0].Gy[69,7] = -39.6392229058202
        struct[0].Gy[69,68] = 108.131545536521
        struct[0].Gy[69,69] = -211.143538626360
        struct[0].Gy[69,70] = -20.5427472507027
        struct[0].Gy[69,71] = 79.2784458116403
        struct[0].Gy[69,72] = -46.5699289619080
        struct[0].Gy[69,73] = 49.9151995897384
        struct[0].Gy[69,74] = -20.5427472507027
        struct[0].Gy[69,75] = 79.2784458116403
        struct[0].Gy[69,76] = -54.0657727682604
        struct[0].Gy[69,77] = 105.571769313180
        struct[0].Gy[69,78] = 10.2713736253513
        struct[0].Gy[69,79] = -39.6392229058202
        struct[0].Gy[69,80] = 23.2849644809540
        struct[0].Gy[69,81] = -24.9575997948692
        struct[0].Gy[69,82] = 10.2713736253513
        struct[0].Gy[69,83] = -39.6392229058202
        struct[0].Gy[70,0] = -39.6392229058202
        struct[0].Gy[70,1] = -10.2713736253513
        struct[0].Gy[70,2] = 105.571769313180
        struct[0].Gy[70,3] = 54.0657727682604
        struct[0].Gy[70,4] = -39.6392229058201
        struct[0].Gy[70,5] = -10.2713736253513
        struct[0].Gy[70,6] = -24.9575997948692
        struct[0].Gy[70,7] = -23.2849644809540
        struct[0].Gy[70,68] = 79.2784458116403
        struct[0].Gy[70,69] = 20.5427472507027
        struct[0].Gy[70,70] = -211.143538626360
        struct[0].Gy[70,71] = -108.131545536521
        struct[0].Gy[70,72] = 79.2784458116403
        struct[0].Gy[70,73] = 20.5427472507027
        struct[0].Gy[70,74] = 49.9151995897384
        struct[0].Gy[70,75] = 46.5699289619080
        struct[0].Gy[70,76] = -39.6392229058202
        struct[0].Gy[70,77] = -10.2713736253513
        struct[0].Gy[70,78] = 105.571769313180
        struct[0].Gy[70,79] = 54.0657727682604
        struct[0].Gy[70,80] = -39.6392229058201
        struct[0].Gy[70,81] = -10.2713736253513
        struct[0].Gy[70,82] = -24.9575997948692
        struct[0].Gy[70,83] = -23.2849644809540
        struct[0].Gy[71,0] = 10.2713736253513
        struct[0].Gy[71,1] = -39.6392229058202
        struct[0].Gy[71,2] = -54.0657727682604
        struct[0].Gy[71,3] = 105.571769313180
        struct[0].Gy[71,4] = 10.2713736253513
        struct[0].Gy[71,5] = -39.6392229058201
        struct[0].Gy[71,6] = 23.2849644809540
        struct[0].Gy[71,7] = -24.9575997948692
        struct[0].Gy[71,68] = -20.5427472507027
        struct[0].Gy[71,69] = 79.2784458116403
        struct[0].Gy[71,70] = 108.131545536521
        struct[0].Gy[71,71] = -211.143538626360
        struct[0].Gy[71,72] = -20.5427472507027
        struct[0].Gy[71,73] = 79.2784458116403
        struct[0].Gy[71,74] = -46.5699289619080
        struct[0].Gy[71,75] = 49.9151995897384
        struct[0].Gy[71,76] = 10.2713736253513
        struct[0].Gy[71,77] = -39.6392229058202
        struct[0].Gy[71,78] = -54.0657727682604
        struct[0].Gy[71,79] = 105.571769313180
        struct[0].Gy[71,80] = 10.2713736253513
        struct[0].Gy[71,81] = -39.6392229058201
        struct[0].Gy[71,82] = 23.2849644809540
        struct[0].Gy[71,83] = -24.9575997948692
        struct[0].Gy[72,0] = -24.9575997948692
        struct[0].Gy[72,1] = -23.2849644809540
        struct[0].Gy[72,2] = -39.6392229058202
        struct[0].Gy[72,3] = -10.2713736253513
        struct[0].Gy[72,4] = 105.571769313180
        struct[0].Gy[72,5] = 54.0657727682604
        struct[0].Gy[72,6] = -39.6392229058201
        struct[0].Gy[72,7] = -10.2713736253514
        struct[0].Gy[72,68] = 49.9151995897384
        struct[0].Gy[72,69] = 46.5699289619080
        struct[0].Gy[72,70] = 79.2784458116404
        struct[0].Gy[72,71] = 20.5427472507027
        struct[0].Gy[72,72] = -211.143538626360
        struct[0].Gy[72,73] = -108.131545536521
        struct[0].Gy[72,74] = 79.2784458116403
        struct[0].Gy[72,75] = 20.5427472507027
        struct[0].Gy[72,76] = -24.9575997948692
        struct[0].Gy[72,77] = -23.2849644809540
        struct[0].Gy[72,78] = -39.6392229058202
        struct[0].Gy[72,79] = -10.2713736253513
        struct[0].Gy[72,80] = 105.571769313180
        struct[0].Gy[72,81] = 54.0657727682604
        struct[0].Gy[72,82] = -39.6392229058201
        struct[0].Gy[72,83] = -10.2713736253514
        struct[0].Gy[73,0] = 23.2849644809540
        struct[0].Gy[73,1] = -24.9575997948692
        struct[0].Gy[73,2] = 10.2713736253513
        struct[0].Gy[73,3] = -39.6392229058202
        struct[0].Gy[73,4] = -54.0657727682604
        struct[0].Gy[73,5] = 105.571769313180
        struct[0].Gy[73,6] = 10.2713736253514
        struct[0].Gy[73,7] = -39.6392229058201
        struct[0].Gy[73,68] = -46.5699289619080
        struct[0].Gy[73,69] = 49.9151995897384
        struct[0].Gy[73,70] = -20.5427472507027
        struct[0].Gy[73,71] = 79.2784458116404
        struct[0].Gy[73,72] = 108.131545536521
        struct[0].Gy[73,73] = -211.143538626360
        struct[0].Gy[73,74] = -20.5427472507027
        struct[0].Gy[73,75] = 79.2784458116403
        struct[0].Gy[73,76] = 23.2849644809540
        struct[0].Gy[73,77] = -24.9575997948692
        struct[0].Gy[73,78] = 10.2713736253513
        struct[0].Gy[73,79] = -39.6392229058202
        struct[0].Gy[73,80] = -54.0657727682604
        struct[0].Gy[73,81] = 105.571769313180
        struct[0].Gy[73,82] = 10.2713736253514
        struct[0].Gy[73,83] = -39.6392229058201
        struct[0].Gy[74,0] = -39.6392229058202
        struct[0].Gy[74,1] = -10.2713736253513
        struct[0].Gy[74,2] = -24.9575997948692
        struct[0].Gy[74,3] = -23.2849644809540
        struct[0].Gy[74,4] = -39.6392229058202
        struct[0].Gy[74,5] = -10.2713736253513
        struct[0].Gy[74,6] = 105.571769313180
        struct[0].Gy[74,7] = 54.0657727682604
        struct[0].Gy[74,68] = 79.2784458116403
        struct[0].Gy[74,69] = 20.5427472507027
        struct[0].Gy[74,70] = 49.9151995897384
        struct[0].Gy[74,71] = 46.5699289619080
        struct[0].Gy[74,72] = 79.2784458116403
        struct[0].Gy[74,73] = 20.5427472507027
        struct[0].Gy[74,74] = -211.168538626360
        struct[0].Gy[74,75] = -108.131545536521
        struct[0].Gy[74,76] = -39.6392229058202
        struct[0].Gy[74,77] = -10.2713736253513
        struct[0].Gy[74,78] = -24.9575997948692
        struct[0].Gy[74,79] = -23.2849644809540
        struct[0].Gy[74,80] = -39.6392229058202
        struct[0].Gy[74,81] = -10.2713736253513
        struct[0].Gy[74,82] = 105.571769313180
        struct[0].Gy[74,83] = 54.0657727682604
        struct[0].Gy[75,0] = 10.2713736253513
        struct[0].Gy[75,1] = -39.6392229058202
        struct[0].Gy[75,2] = 23.2849644809540
        struct[0].Gy[75,3] = -24.9575997948692
        struct[0].Gy[75,4] = 10.2713736253513
        struct[0].Gy[75,5] = -39.6392229058202
        struct[0].Gy[75,6] = -54.0657727682604
        struct[0].Gy[75,7] = 105.571769313180
        struct[0].Gy[75,68] = -20.5427472507027
        struct[0].Gy[75,69] = 79.2784458116403
        struct[0].Gy[75,70] = -46.5699289619080
        struct[0].Gy[75,71] = 49.9151995897384
        struct[0].Gy[75,72] = -20.5427472507027
        struct[0].Gy[75,73] = 79.2784458116403
        struct[0].Gy[75,74] = 108.131545536521
        struct[0].Gy[75,75] = -211.168538626360
        struct[0].Gy[75,76] = 10.2713736253513
        struct[0].Gy[75,77] = -39.6392229058202
        struct[0].Gy[75,78] = 23.2849644809540
        struct[0].Gy[75,79] = -24.9575997948692
        struct[0].Gy[75,80] = 10.2713736253513
        struct[0].Gy[75,81] = -39.6392229058202
        struct[0].Gy[75,82] = -54.0657727682604
        struct[0].Gy[75,83] = 105.571769313180
        struct[0].Gy[76,8] = 26.5300693004806
        struct[0].Gy[76,9] = 4.84676915585801
        struct[0].Gy[76,10] = -7.89461337514770
        struct[0].Gy[76,11] = 1.58482814504483
        struct[0].Gy[76,12] = -7.72144347466701
        struct[0].Gy[76,13] = 0.679918453285310
        struct[0].Gy[76,14] = -7.89461337514771
        struct[0].Gy[76,15] = 1.58482814504483
        struct[0].Gy[76,68] = 105.571769313180
        struct[0].Gy[76,69] = 54.0657727682604
        struct[0].Gy[76,70] = -39.6392229058202
        struct[0].Gy[76,71] = -10.2713736253513
        struct[0].Gy[76,72] = -24.9575997948692
        struct[0].Gy[76,73] = -23.2849644809540
        struct[0].Gy[76,74] = -39.6392229058202
        struct[0].Gy[76,75] = -10.2713736253513
        struct[0].Gy[76,76] = -237.673607926841
        struct[0].Gy[76,77] = -112.978314692379
        struct[0].Gy[76,78] = 87.1730591867880
        struct[0].Gy[76,79] = 18.9579191056578
        struct[0].Gy[76,80] = 57.6366430644055
        struct[0].Gy[76,81] = 45.8900105086227
        struct[0].Gy[76,82] = 87.1730591867880
        struct[0].Gy[76,83] = 18.9579191056579
        struct[0].Gy[76,84] = 105.571769313180
        struct[0].Gy[76,85] = 54.0657727682604
        struct[0].Gy[76,86] = -39.6392229058202
        struct[0].Gy[76,87] = -10.2713736253513
        struct[0].Gy[76,88] = -24.9575997948692
        struct[0].Gy[76,89] = -23.2849644809540
        struct[0].Gy[76,90] = -39.6392229058202
        struct[0].Gy[76,91] = -10.2713736253513
        struct[0].Gy[77,8] = -4.84676915585801
        struct[0].Gy[77,9] = 26.5300693004806
        struct[0].Gy[77,10] = -1.58482814504483
        struct[0].Gy[77,11] = -7.89461337514770
        struct[0].Gy[77,12] = -0.679918453285310
        struct[0].Gy[77,13] = -7.72144347466701
        struct[0].Gy[77,14] = -1.58482814504483
        struct[0].Gy[77,15] = -7.89461337514771
        struct[0].Gy[77,68] = -54.0657727682604
        struct[0].Gy[77,69] = 105.571769313180
        struct[0].Gy[77,70] = 10.2713736253513
        struct[0].Gy[77,71] = -39.6392229058202
        struct[0].Gy[77,72] = 23.2849644809540
        struct[0].Gy[77,73] = -24.9575997948692
        struct[0].Gy[77,74] = 10.2713736253513
        struct[0].Gy[77,75] = -39.6392229058202
        struct[0].Gy[77,76] = 112.978314692379
        struct[0].Gy[77,77] = -237.673607926841
        struct[0].Gy[77,78] = -18.9579191056578
        struct[0].Gy[77,79] = 87.1730591867880
        struct[0].Gy[77,80] = -45.8900105086227
        struct[0].Gy[77,81] = 57.6366430644055
        struct[0].Gy[77,82] = -18.9579191056579
        struct[0].Gy[77,83] = 87.1730591867880
        struct[0].Gy[77,84] = -54.0657727682604
        struct[0].Gy[77,85] = 105.571769313180
        struct[0].Gy[77,86] = 10.2713736253513
        struct[0].Gy[77,87] = -39.6392229058202
        struct[0].Gy[77,88] = 23.2849644809540
        struct[0].Gy[77,89] = -24.9575997948692
        struct[0].Gy[77,90] = 10.2713736253513
        struct[0].Gy[77,91] = -39.6392229058202
        struct[0].Gy[78,8] = -7.89461337514771
        struct[0].Gy[78,9] = 1.58482814504483
        struct[0].Gy[78,10] = 26.5300693004806
        struct[0].Gy[78,11] = 4.84676915585801
        struct[0].Gy[78,12] = -7.89461337514771
        struct[0].Gy[78,13] = 1.58482814504483
        struct[0].Gy[78,14] = -7.72144347466701
        struct[0].Gy[78,15] = 0.679918453285308
        struct[0].Gy[78,68] = -39.6392229058202
        struct[0].Gy[78,69] = -10.2713736253513
        struct[0].Gy[78,70] = 105.571769313180
        struct[0].Gy[78,71] = 54.0657727682604
        struct[0].Gy[78,72] = -39.6392229058201
        struct[0].Gy[78,73] = -10.2713736253513
        struct[0].Gy[78,74] = -24.9575997948692
        struct[0].Gy[78,75] = -23.2849644809540
        struct[0].Gy[78,76] = 87.1730591867880
        struct[0].Gy[78,77] = 18.9579191056579
        struct[0].Gy[78,78] = -237.673607926841
        struct[0].Gy[78,79] = -112.978314692379
        struct[0].Gy[78,80] = 87.1730591867880
        struct[0].Gy[78,81] = 18.9579191056579
        struct[0].Gy[78,82] = 57.6366430644054
        struct[0].Gy[78,83] = 45.8900105086227
        struct[0].Gy[78,84] = -39.6392229058202
        struct[0].Gy[78,85] = -10.2713736253513
        struct[0].Gy[78,86] = 105.571769313180
        struct[0].Gy[78,87] = 54.0657727682604
        struct[0].Gy[78,88] = -39.6392229058201
        struct[0].Gy[78,89] = -10.2713736253513
        struct[0].Gy[78,90] = -24.9575997948692
        struct[0].Gy[78,91] = -23.2849644809540
        struct[0].Gy[79,8] = -1.58482814504483
        struct[0].Gy[79,9] = -7.89461337514771
        struct[0].Gy[79,10] = -4.84676915585801
        struct[0].Gy[79,11] = 26.5300693004806
        struct[0].Gy[79,12] = -1.58482814504483
        struct[0].Gy[79,13] = -7.89461337514771
        struct[0].Gy[79,14] = -0.679918453285308
        struct[0].Gy[79,15] = -7.72144347466701
        struct[0].Gy[79,68] = 10.2713736253513
        struct[0].Gy[79,69] = -39.6392229058202
        struct[0].Gy[79,70] = -54.0657727682604
        struct[0].Gy[79,71] = 105.571769313180
        struct[0].Gy[79,72] = 10.2713736253513
        struct[0].Gy[79,73] = -39.6392229058201
        struct[0].Gy[79,74] = 23.2849644809540
        struct[0].Gy[79,75] = -24.9575997948692
        struct[0].Gy[79,76] = -18.9579191056579
        struct[0].Gy[79,77] = 87.1730591867880
        struct[0].Gy[79,78] = 112.978314692379
        struct[0].Gy[79,79] = -237.673607926841
        struct[0].Gy[79,80] = -18.9579191056579
        struct[0].Gy[79,81] = 87.1730591867880
        struct[0].Gy[79,82] = -45.8900105086227
        struct[0].Gy[79,83] = 57.6366430644054
        struct[0].Gy[79,84] = 10.2713736253513
        struct[0].Gy[79,85] = -39.6392229058202
        struct[0].Gy[79,86] = -54.0657727682604
        struct[0].Gy[79,87] = 105.571769313180
        struct[0].Gy[79,88] = 10.2713736253513
        struct[0].Gy[79,89] = -39.6392229058201
        struct[0].Gy[79,90] = 23.2849644809540
        struct[0].Gy[79,91] = -24.9575997948692
        struct[0].Gy[80,8] = -7.72144347466701
        struct[0].Gy[80,9] = 0.679918453285310
        struct[0].Gy[80,10] = -7.89461337514770
        struct[0].Gy[80,11] = 1.58482814504483
        struct[0].Gy[80,12] = 26.5300693004806
        struct[0].Gy[80,13] = 4.84676915585801
        struct[0].Gy[80,14] = -7.89461337514771
        struct[0].Gy[80,15] = 1.58482814504483
        struct[0].Gy[80,68] = -24.9575997948692
        struct[0].Gy[80,69] = -23.2849644809540
        struct[0].Gy[80,70] = -39.6392229058202
        struct[0].Gy[80,71] = -10.2713736253513
        struct[0].Gy[80,72] = 105.571769313180
        struct[0].Gy[80,73] = 54.0657727682604
        struct[0].Gy[80,74] = -39.6392229058201
        struct[0].Gy[80,75] = -10.2713736253514
        struct[0].Gy[80,76] = 57.6366430644054
        struct[0].Gy[80,77] = 45.8900105086227
        struct[0].Gy[80,78] = 87.1730591867881
        struct[0].Gy[80,79] = 18.9579191056578
        struct[0].Gy[80,80] = -237.673607926841
        struct[0].Gy[80,81] = -112.978314692379
        struct[0].Gy[80,82] = 87.1730591867880
        struct[0].Gy[80,83] = 18.9579191056579
        struct[0].Gy[80,84] = -24.9575997948692
        struct[0].Gy[80,85] = -23.2849644809540
        struct[0].Gy[80,86] = -39.6392229058202
        struct[0].Gy[80,87] = -10.2713736253513
        struct[0].Gy[80,88] = 105.571769313180
        struct[0].Gy[80,89] = 54.0657727682604
        struct[0].Gy[80,90] = -39.6392229058201
        struct[0].Gy[80,91] = -10.2713736253514
        struct[0].Gy[81,8] = -0.679918453285310
        struct[0].Gy[81,9] = -7.72144347466701
        struct[0].Gy[81,10] = -1.58482814504483
        struct[0].Gy[81,11] = -7.89461337514770
        struct[0].Gy[81,12] = -4.84676915585801
        struct[0].Gy[81,13] = 26.5300693004806
        struct[0].Gy[81,14] = -1.58482814504483
        struct[0].Gy[81,15] = -7.89461337514771
        struct[0].Gy[81,68] = 23.2849644809540
        struct[0].Gy[81,69] = -24.9575997948692
        struct[0].Gy[81,70] = 10.2713736253513
        struct[0].Gy[81,71] = -39.6392229058202
        struct[0].Gy[81,72] = -54.0657727682604
        struct[0].Gy[81,73] = 105.571769313180
        struct[0].Gy[81,74] = 10.2713736253514
        struct[0].Gy[81,75] = -39.6392229058201
        struct[0].Gy[81,76] = -45.8900105086227
        struct[0].Gy[81,77] = 57.6366430644054
        struct[0].Gy[81,78] = -18.9579191056578
        struct[0].Gy[81,79] = 87.1730591867881
        struct[0].Gy[81,80] = 112.978314692379
        struct[0].Gy[81,81] = -237.673607926841
        struct[0].Gy[81,82] = -18.9579191056579
        struct[0].Gy[81,83] = 87.1730591867880
        struct[0].Gy[81,84] = 23.2849644809540
        struct[0].Gy[81,85] = -24.9575997948692
        struct[0].Gy[81,86] = 10.2713736253513
        struct[0].Gy[81,87] = -39.6392229058202
        struct[0].Gy[81,88] = -54.0657727682604
        struct[0].Gy[81,89] = 105.571769313180
        struct[0].Gy[81,90] = 10.2713736253514
        struct[0].Gy[81,91] = -39.6392229058201
        struct[0].Gy[82,8] = -7.89461337514771
        struct[0].Gy[82,9] = 1.58482814504483
        struct[0].Gy[82,10] = -7.72144347466701
        struct[0].Gy[82,11] = 0.679918453285308
        struct[0].Gy[82,12] = -7.89461337514771
        struct[0].Gy[82,13] = 1.58482814504483
        struct[0].Gy[82,14] = 26.5300693004806
        struct[0].Gy[82,15] = 4.84676915585801
        struct[0].Gy[82,68] = -39.6392229058202
        struct[0].Gy[82,69] = -10.2713736253513
        struct[0].Gy[82,70] = -24.9575997948692
        struct[0].Gy[82,71] = -23.2849644809540
        struct[0].Gy[82,72] = -39.6392229058202
        struct[0].Gy[82,73] = -10.2713736253513
        struct[0].Gy[82,74] = 105.571769313180
        struct[0].Gy[82,75] = 54.0657727682604
        struct[0].Gy[82,76] = 87.1730591867880
        struct[0].Gy[82,77] = 18.9579191056578
        struct[0].Gy[82,78] = 57.6366430644054
        struct[0].Gy[82,79] = 45.8900105086227
        struct[0].Gy[82,80] = 87.1730591867880
        struct[0].Gy[82,81] = 18.9579191056579
        struct[0].Gy[82,82] = -237.673607926841
        struct[0].Gy[82,83] = -112.978314692379
        struct[0].Gy[82,84] = -39.6392229058202
        struct[0].Gy[82,85] = -10.2713736253513
        struct[0].Gy[82,86] = -24.9575997948692
        struct[0].Gy[82,87] = -23.2849644809540
        struct[0].Gy[82,88] = -39.6392229058202
        struct[0].Gy[82,89] = -10.2713736253513
        struct[0].Gy[82,90] = 105.571769313180
        struct[0].Gy[82,91] = 54.0657727682604
        struct[0].Gy[83,8] = -1.58482814504483
        struct[0].Gy[83,9] = -7.89461337514771
        struct[0].Gy[83,10] = -0.679918453285308
        struct[0].Gy[83,11] = -7.72144347466701
        struct[0].Gy[83,12] = -1.58482814504483
        struct[0].Gy[83,13] = -7.89461337514771
        struct[0].Gy[83,14] = -4.84676915585801
        struct[0].Gy[83,15] = 26.5300693004806
        struct[0].Gy[83,68] = 10.2713736253513
        struct[0].Gy[83,69] = -39.6392229058202
        struct[0].Gy[83,70] = 23.2849644809540
        struct[0].Gy[83,71] = -24.9575997948692
        struct[0].Gy[83,72] = 10.2713736253513
        struct[0].Gy[83,73] = -39.6392229058202
        struct[0].Gy[83,74] = -54.0657727682604
        struct[0].Gy[83,75] = 105.571769313180
        struct[0].Gy[83,76] = -18.9579191056578
        struct[0].Gy[83,77] = 87.1730591867880
        struct[0].Gy[83,78] = -45.8900105086227
        struct[0].Gy[83,79] = 57.6366430644054
        struct[0].Gy[83,80] = -18.9579191056579
        struct[0].Gy[83,81] = 87.1730591867880
        struct[0].Gy[83,82] = 112.978314692379
        struct[0].Gy[83,83] = -237.673607926841
        struct[0].Gy[83,84] = 10.2713736253513
        struct[0].Gy[83,85] = -39.6392229058202
        struct[0].Gy[83,86] = 23.2849644809540
        struct[0].Gy[83,87] = -24.9575997948692
        struct[0].Gy[83,88] = 10.2713736253513
        struct[0].Gy[83,89] = -39.6392229058202
        struct[0].Gy[83,90] = -54.0657727682604
        struct[0].Gy[83,91] = 105.571769313180
        struct[0].Gy[84,76] = 105.571769313180
        struct[0].Gy[84,77] = 54.0657727682604
        struct[0].Gy[84,78] = -39.6392229058202
        struct[0].Gy[84,79] = -10.2713736253513
        struct[0].Gy[84,80] = -24.9575997948692
        struct[0].Gy[84,81] = -23.2849644809540
        struct[0].Gy[84,82] = -39.6392229058202
        struct[0].Gy[84,83] = -10.2713736253513
        struct[0].Gy[84,84] = -237.673607926841
        struct[0].Gy[84,85] = -112.978314692379
        struct[0].Gy[84,86] = 87.1730591867880
        struct[0].Gy[84,87] = 18.9579191056578
        struct[0].Gy[84,88] = 57.6366430644055
        struct[0].Gy[84,89] = 45.8900105086227
        struct[0].Gy[84,90] = 87.1730591867880
        struct[0].Gy[84,91] = 18.9579191056579
        struct[0].Gy[84,92] = 105.571769313180
        struct[0].Gy[84,93] = 54.0657727682604
        struct[0].Gy[84,94] = -39.6392229058202
        struct[0].Gy[84,95] = -10.2713736253513
        struct[0].Gy[84,96] = -24.9575997948692
        struct[0].Gy[84,97] = -23.2849644809540
        struct[0].Gy[84,98] = -39.6392229058202
        struct[0].Gy[84,99] = -10.2713736253513
        struct[0].Gy[84,140] = 26.5300693004806
        struct[0].Gy[84,141] = 4.84676915585801
        struct[0].Gy[84,142] = -7.89461337514770
        struct[0].Gy[84,143] = 1.58482814504483
        struct[0].Gy[84,144] = -7.72144347466701
        struct[0].Gy[84,145] = 0.679918453285310
        struct[0].Gy[84,146] = -7.89461337514771
        struct[0].Gy[84,147] = 1.58482814504483
        struct[0].Gy[85,76] = -54.0657727682604
        struct[0].Gy[85,77] = 105.571769313180
        struct[0].Gy[85,78] = 10.2713736253513
        struct[0].Gy[85,79] = -39.6392229058202
        struct[0].Gy[85,80] = 23.2849644809540
        struct[0].Gy[85,81] = -24.9575997948692
        struct[0].Gy[85,82] = 10.2713736253513
        struct[0].Gy[85,83] = -39.6392229058202
        struct[0].Gy[85,84] = 112.978314692379
        struct[0].Gy[85,85] = -237.673607926841
        struct[0].Gy[85,86] = -18.9579191056578
        struct[0].Gy[85,87] = 87.1730591867880
        struct[0].Gy[85,88] = -45.8900105086227
        struct[0].Gy[85,89] = 57.6366430644055
        struct[0].Gy[85,90] = -18.9579191056579
        struct[0].Gy[85,91] = 87.1730591867880
        struct[0].Gy[85,92] = -54.0657727682604
        struct[0].Gy[85,93] = 105.571769313180
        struct[0].Gy[85,94] = 10.2713736253513
        struct[0].Gy[85,95] = -39.6392229058202
        struct[0].Gy[85,96] = 23.2849644809540
        struct[0].Gy[85,97] = -24.9575997948692
        struct[0].Gy[85,98] = 10.2713736253513
        struct[0].Gy[85,99] = -39.6392229058202
        struct[0].Gy[85,140] = -4.84676915585801
        struct[0].Gy[85,141] = 26.5300693004806
        struct[0].Gy[85,142] = -1.58482814504483
        struct[0].Gy[85,143] = -7.89461337514770
        struct[0].Gy[85,144] = -0.679918453285310
        struct[0].Gy[85,145] = -7.72144347466701
        struct[0].Gy[85,146] = -1.58482814504483
        struct[0].Gy[85,147] = -7.89461337514771
        struct[0].Gy[86,76] = -39.6392229058202
        struct[0].Gy[86,77] = -10.2713736253513
        struct[0].Gy[86,78] = 105.571769313180
        struct[0].Gy[86,79] = 54.0657727682604
        struct[0].Gy[86,80] = -39.6392229058201
        struct[0].Gy[86,81] = -10.2713736253513
        struct[0].Gy[86,82] = -24.9575997948692
        struct[0].Gy[86,83] = -23.2849644809540
        struct[0].Gy[86,84] = 87.1730591867880
        struct[0].Gy[86,85] = 18.9579191056579
        struct[0].Gy[86,86] = -237.673607926841
        struct[0].Gy[86,87] = -112.978314692379
        struct[0].Gy[86,88] = 87.1730591867880
        struct[0].Gy[86,89] = 18.9579191056579
        struct[0].Gy[86,90] = 57.6366430644054
        struct[0].Gy[86,91] = 45.8900105086227
        struct[0].Gy[86,92] = -39.6392229058202
        struct[0].Gy[86,93] = -10.2713736253513
        struct[0].Gy[86,94] = 105.571769313180
        struct[0].Gy[86,95] = 54.0657727682604
        struct[0].Gy[86,96] = -39.6392229058201
        struct[0].Gy[86,97] = -10.2713736253513
        struct[0].Gy[86,98] = -24.9575997948692
        struct[0].Gy[86,99] = -23.2849644809540
        struct[0].Gy[86,140] = -7.89461337514771
        struct[0].Gy[86,141] = 1.58482814504483
        struct[0].Gy[86,142] = 26.5300693004806
        struct[0].Gy[86,143] = 4.84676915585801
        struct[0].Gy[86,144] = -7.89461337514771
        struct[0].Gy[86,145] = 1.58482814504483
        struct[0].Gy[86,146] = -7.72144347466701
        struct[0].Gy[86,147] = 0.679918453285308
        struct[0].Gy[87,76] = 10.2713736253513
        struct[0].Gy[87,77] = -39.6392229058202
        struct[0].Gy[87,78] = -54.0657727682604
        struct[0].Gy[87,79] = 105.571769313180
        struct[0].Gy[87,80] = 10.2713736253513
        struct[0].Gy[87,81] = -39.6392229058201
        struct[0].Gy[87,82] = 23.2849644809540
        struct[0].Gy[87,83] = -24.9575997948692
        struct[0].Gy[87,84] = -18.9579191056579
        struct[0].Gy[87,85] = 87.1730591867880
        struct[0].Gy[87,86] = 112.978314692379
        struct[0].Gy[87,87] = -237.673607926841
        struct[0].Gy[87,88] = -18.9579191056579
        struct[0].Gy[87,89] = 87.1730591867880
        struct[0].Gy[87,90] = -45.8900105086227
        struct[0].Gy[87,91] = 57.6366430644054
        struct[0].Gy[87,92] = 10.2713736253513
        struct[0].Gy[87,93] = -39.6392229058202
        struct[0].Gy[87,94] = -54.0657727682604
        struct[0].Gy[87,95] = 105.571769313180
        struct[0].Gy[87,96] = 10.2713736253513
        struct[0].Gy[87,97] = -39.6392229058201
        struct[0].Gy[87,98] = 23.2849644809540
        struct[0].Gy[87,99] = -24.9575997948692
        struct[0].Gy[87,140] = -1.58482814504483
        struct[0].Gy[87,141] = -7.89461337514771
        struct[0].Gy[87,142] = -4.84676915585801
        struct[0].Gy[87,143] = 26.5300693004806
        struct[0].Gy[87,144] = -1.58482814504483
        struct[0].Gy[87,145] = -7.89461337514771
        struct[0].Gy[87,146] = -0.679918453285308
        struct[0].Gy[87,147] = -7.72144347466701
        struct[0].Gy[88,76] = -24.9575997948692
        struct[0].Gy[88,77] = -23.2849644809540
        struct[0].Gy[88,78] = -39.6392229058202
        struct[0].Gy[88,79] = -10.2713736253513
        struct[0].Gy[88,80] = 105.571769313180
        struct[0].Gy[88,81] = 54.0657727682604
        struct[0].Gy[88,82] = -39.6392229058201
        struct[0].Gy[88,83] = -10.2713736253514
        struct[0].Gy[88,84] = 57.6366430644054
        struct[0].Gy[88,85] = 45.8900105086227
        struct[0].Gy[88,86] = 87.1730591867881
        struct[0].Gy[88,87] = 18.9579191056578
        struct[0].Gy[88,88] = -237.673607926841
        struct[0].Gy[88,89] = -112.978314692379
        struct[0].Gy[88,90] = 87.1730591867880
        struct[0].Gy[88,91] = 18.9579191056579
        struct[0].Gy[88,92] = -24.9575997948692
        struct[0].Gy[88,93] = -23.2849644809540
        struct[0].Gy[88,94] = -39.6392229058202
        struct[0].Gy[88,95] = -10.2713736253513
        struct[0].Gy[88,96] = 105.571769313180
        struct[0].Gy[88,97] = 54.0657727682604
        struct[0].Gy[88,98] = -39.6392229058201
        struct[0].Gy[88,99] = -10.2713736253514
        struct[0].Gy[88,140] = -7.72144347466701
        struct[0].Gy[88,141] = 0.679918453285310
        struct[0].Gy[88,142] = -7.89461337514770
        struct[0].Gy[88,143] = 1.58482814504483
        struct[0].Gy[88,144] = 26.5300693004806
        struct[0].Gy[88,145] = 4.84676915585801
        struct[0].Gy[88,146] = -7.89461337514771
        struct[0].Gy[88,147] = 1.58482814504483
        struct[0].Gy[89,76] = 23.2849644809540
        struct[0].Gy[89,77] = -24.9575997948692
        struct[0].Gy[89,78] = 10.2713736253513
        struct[0].Gy[89,79] = -39.6392229058202
        struct[0].Gy[89,80] = -54.0657727682604
        struct[0].Gy[89,81] = 105.571769313180
        struct[0].Gy[89,82] = 10.2713736253514
        struct[0].Gy[89,83] = -39.6392229058201
        struct[0].Gy[89,84] = -45.8900105086227
        struct[0].Gy[89,85] = 57.6366430644054
        struct[0].Gy[89,86] = -18.9579191056578
        struct[0].Gy[89,87] = 87.1730591867881
        struct[0].Gy[89,88] = 112.978314692379
        struct[0].Gy[89,89] = -237.673607926841
        struct[0].Gy[89,90] = -18.9579191056579
        struct[0].Gy[89,91] = 87.1730591867880
        struct[0].Gy[89,92] = 23.2849644809540
        struct[0].Gy[89,93] = -24.9575997948692
        struct[0].Gy[89,94] = 10.2713736253513
        struct[0].Gy[89,95] = -39.6392229058202
        struct[0].Gy[89,96] = -54.0657727682604
        struct[0].Gy[89,97] = 105.571769313180
        struct[0].Gy[89,98] = 10.2713736253514
        struct[0].Gy[89,99] = -39.6392229058201
        struct[0].Gy[89,140] = -0.679918453285310
        struct[0].Gy[89,141] = -7.72144347466701
        struct[0].Gy[89,142] = -1.58482814504483
        struct[0].Gy[89,143] = -7.89461337514770
        struct[0].Gy[89,144] = -4.84676915585801
        struct[0].Gy[89,145] = 26.5300693004806
        struct[0].Gy[89,146] = -1.58482814504483
        struct[0].Gy[89,147] = -7.89461337514771
        struct[0].Gy[90,76] = -39.6392229058202
        struct[0].Gy[90,77] = -10.2713736253513
        struct[0].Gy[90,78] = -24.9575997948692
        struct[0].Gy[90,79] = -23.2849644809540
        struct[0].Gy[90,80] = -39.6392229058202
        struct[0].Gy[90,81] = -10.2713736253513
        struct[0].Gy[90,82] = 105.571769313180
        struct[0].Gy[90,83] = 54.0657727682604
        struct[0].Gy[90,84] = 87.1730591867880
        struct[0].Gy[90,85] = 18.9579191056578
        struct[0].Gy[90,86] = 57.6366430644054
        struct[0].Gy[90,87] = 45.8900105086227
        struct[0].Gy[90,88] = 87.1730591867880
        struct[0].Gy[90,89] = 18.9579191056579
        struct[0].Gy[90,90] = -237.698607926841
        struct[0].Gy[90,91] = -112.978314692379
        struct[0].Gy[90,92] = -39.6392229058202
        struct[0].Gy[90,93] = -10.2713736253513
        struct[0].Gy[90,94] = -24.9575997948692
        struct[0].Gy[90,95] = -23.2849644809540
        struct[0].Gy[90,96] = -39.6392229058202
        struct[0].Gy[90,97] = -10.2713736253513
        struct[0].Gy[90,98] = 105.571769313180
        struct[0].Gy[90,99] = 54.0657727682604
        struct[0].Gy[90,140] = -7.89461337514771
        struct[0].Gy[90,141] = 1.58482814504483
        struct[0].Gy[90,142] = -7.72144347466701
        struct[0].Gy[90,143] = 0.679918453285308
        struct[0].Gy[90,144] = -7.89461337514771
        struct[0].Gy[90,145] = 1.58482814504483
        struct[0].Gy[90,146] = 26.5300693004806
        struct[0].Gy[90,147] = 4.84676915585801
        struct[0].Gy[91,76] = 10.2713736253513
        struct[0].Gy[91,77] = -39.6392229058202
        struct[0].Gy[91,78] = 23.2849644809540
        struct[0].Gy[91,79] = -24.9575997948692
        struct[0].Gy[91,80] = 10.2713736253513
        struct[0].Gy[91,81] = -39.6392229058202
        struct[0].Gy[91,82] = -54.0657727682604
        struct[0].Gy[91,83] = 105.571769313180
        struct[0].Gy[91,84] = -18.9579191056578
        struct[0].Gy[91,85] = 87.1730591867880
        struct[0].Gy[91,86] = -45.8900105086227
        struct[0].Gy[91,87] = 57.6366430644054
        struct[0].Gy[91,88] = -18.9579191056579
        struct[0].Gy[91,89] = 87.1730591867880
        struct[0].Gy[91,90] = 112.978314692379
        struct[0].Gy[91,91] = -237.698607926841
        struct[0].Gy[91,92] = 10.2713736253513
        struct[0].Gy[91,93] = -39.6392229058202
        struct[0].Gy[91,94] = 23.2849644809540
        struct[0].Gy[91,95] = -24.9575997948692
        struct[0].Gy[91,96] = 10.2713736253513
        struct[0].Gy[91,97] = -39.6392229058202
        struct[0].Gy[91,98] = -54.0657727682604
        struct[0].Gy[91,99] = 105.571769313180
        struct[0].Gy[91,140] = -1.58482814504483
        struct[0].Gy[91,141] = -7.89461337514771
        struct[0].Gy[91,142] = -0.679918453285308
        struct[0].Gy[91,143] = -7.72144347466701
        struct[0].Gy[91,144] = -1.58482814504483
        struct[0].Gy[91,145] = -7.89461337514771
        struct[0].Gy[91,146] = -4.84676915585801
        struct[0].Gy[91,147] = 26.5300693004806
        struct[0].Gy[92,84] = 105.571769313180
        struct[0].Gy[92,85] = 54.0657727682604
        struct[0].Gy[92,86] = -39.6392229058202
        struct[0].Gy[92,87] = -10.2713736253513
        struct[0].Gy[92,88] = -24.9575997948692
        struct[0].Gy[92,89] = -23.2849644809540
        struct[0].Gy[92,90] = -39.6392229058202
        struct[0].Gy[92,91] = -10.2713736253513
        struct[0].Gy[92,92] = -211.143538626360
        struct[0].Gy[92,93] = -108.131545536521
        struct[0].Gy[92,94] = 79.2784458116403
        struct[0].Gy[92,95] = 20.5427472507027
        struct[0].Gy[92,96] = 49.9151995897384
        struct[0].Gy[92,97] = 46.5699289619080
        struct[0].Gy[92,98] = 79.2784458116403
        struct[0].Gy[92,99] = 20.5427472507027
        struct[0].Gy[92,100] = 105.571769313180
        struct[0].Gy[92,101] = 54.0657727682604
        struct[0].Gy[92,102] = -39.6392229058202
        struct[0].Gy[92,103] = -10.2713736253513
        struct[0].Gy[92,104] = -24.9575997948692
        struct[0].Gy[92,105] = -23.2849644809540
        struct[0].Gy[92,106] = -39.6392229058202
        struct[0].Gy[92,107] = -10.2713736253513
        struct[0].Gy[93,84] = -54.0657727682604
        struct[0].Gy[93,85] = 105.571769313180
        struct[0].Gy[93,86] = 10.2713736253513
        struct[0].Gy[93,87] = -39.6392229058202
        struct[0].Gy[93,88] = 23.2849644809540
        struct[0].Gy[93,89] = -24.9575997948692
        struct[0].Gy[93,90] = 10.2713736253513
        struct[0].Gy[93,91] = -39.6392229058202
        struct[0].Gy[93,92] = 108.131545536521
        struct[0].Gy[93,93] = -211.143538626360
        struct[0].Gy[93,94] = -20.5427472507027
        struct[0].Gy[93,95] = 79.2784458116403
        struct[0].Gy[93,96] = -46.5699289619080
        struct[0].Gy[93,97] = 49.9151995897384
        struct[0].Gy[93,98] = -20.5427472507027
        struct[0].Gy[93,99] = 79.2784458116403
        struct[0].Gy[93,100] = -54.0657727682604
        struct[0].Gy[93,101] = 105.571769313180
        struct[0].Gy[93,102] = 10.2713736253513
        struct[0].Gy[93,103] = -39.6392229058202
        struct[0].Gy[93,104] = 23.2849644809540
        struct[0].Gy[93,105] = -24.9575997948692
        struct[0].Gy[93,106] = 10.2713736253513
        struct[0].Gy[93,107] = -39.6392229058202
        struct[0].Gy[94,84] = -39.6392229058202
        struct[0].Gy[94,85] = -10.2713736253513
        struct[0].Gy[94,86] = 105.571769313180
        struct[0].Gy[94,87] = 54.0657727682604
        struct[0].Gy[94,88] = -39.6392229058201
        struct[0].Gy[94,89] = -10.2713736253513
        struct[0].Gy[94,90] = -24.9575997948692
        struct[0].Gy[94,91] = -23.2849644809540
        struct[0].Gy[94,92] = 79.2784458116403
        struct[0].Gy[94,93] = 20.5427472507027
        struct[0].Gy[94,94] = -211.143538626360
        struct[0].Gy[94,95] = -108.131545536521
        struct[0].Gy[94,96] = 79.2784458116403
        struct[0].Gy[94,97] = 20.5427472507027
        struct[0].Gy[94,98] = 49.9151995897384
        struct[0].Gy[94,99] = 46.5699289619080
        struct[0].Gy[94,100] = -39.6392229058202
        struct[0].Gy[94,101] = -10.2713736253513
        struct[0].Gy[94,102] = 105.571769313180
        struct[0].Gy[94,103] = 54.0657727682604
        struct[0].Gy[94,104] = -39.6392229058201
        struct[0].Gy[94,105] = -10.2713736253513
        struct[0].Gy[94,106] = -24.9575997948692
        struct[0].Gy[94,107] = -23.2849644809540
        struct[0].Gy[95,84] = 10.2713736253513
        struct[0].Gy[95,85] = -39.6392229058202
        struct[0].Gy[95,86] = -54.0657727682604
        struct[0].Gy[95,87] = 105.571769313180
        struct[0].Gy[95,88] = 10.2713736253513
        struct[0].Gy[95,89] = -39.6392229058201
        struct[0].Gy[95,90] = 23.2849644809540
        struct[0].Gy[95,91] = -24.9575997948692
        struct[0].Gy[95,92] = -20.5427472507027
        struct[0].Gy[95,93] = 79.2784458116403
        struct[0].Gy[95,94] = 108.131545536521
        struct[0].Gy[95,95] = -211.143538626360
        struct[0].Gy[95,96] = -20.5427472507027
        struct[0].Gy[95,97] = 79.2784458116403
        struct[0].Gy[95,98] = -46.5699289619080
        struct[0].Gy[95,99] = 49.9151995897384
        struct[0].Gy[95,100] = 10.2713736253513
        struct[0].Gy[95,101] = -39.6392229058202
        struct[0].Gy[95,102] = -54.0657727682604
        struct[0].Gy[95,103] = 105.571769313180
        struct[0].Gy[95,104] = 10.2713736253513
        struct[0].Gy[95,105] = -39.6392229058201
        struct[0].Gy[95,106] = 23.2849644809540
        struct[0].Gy[95,107] = -24.9575997948692
        struct[0].Gy[96,84] = -24.9575997948692
        struct[0].Gy[96,85] = -23.2849644809540
        struct[0].Gy[96,86] = -39.6392229058202
        struct[0].Gy[96,87] = -10.2713736253513
        struct[0].Gy[96,88] = 105.571769313180
        struct[0].Gy[96,89] = 54.0657727682604
        struct[0].Gy[96,90] = -39.6392229058201
        struct[0].Gy[96,91] = -10.2713736253514
        struct[0].Gy[96,92] = 49.9151995897384
        struct[0].Gy[96,93] = 46.5699289619080
        struct[0].Gy[96,94] = 79.2784458116404
        struct[0].Gy[96,95] = 20.5427472507027
        struct[0].Gy[96,96] = -211.143538626360
        struct[0].Gy[96,97] = -108.131545536521
        struct[0].Gy[96,98] = 79.2784458116403
        struct[0].Gy[96,99] = 20.5427472507027
        struct[0].Gy[96,100] = -24.9575997948692
        struct[0].Gy[96,101] = -23.2849644809540
        struct[0].Gy[96,102] = -39.6392229058202
        struct[0].Gy[96,103] = -10.2713736253513
        struct[0].Gy[96,104] = 105.571769313180
        struct[0].Gy[96,105] = 54.0657727682604
        struct[0].Gy[96,106] = -39.6392229058201
        struct[0].Gy[96,107] = -10.2713736253514
        struct[0].Gy[97,84] = 23.2849644809540
        struct[0].Gy[97,85] = -24.9575997948692
        struct[0].Gy[97,86] = 10.2713736253513
        struct[0].Gy[97,87] = -39.6392229058202
        struct[0].Gy[97,88] = -54.0657727682604
        struct[0].Gy[97,89] = 105.571769313180
        struct[0].Gy[97,90] = 10.2713736253514
        struct[0].Gy[97,91] = -39.6392229058201
        struct[0].Gy[97,92] = -46.5699289619080
        struct[0].Gy[97,93] = 49.9151995897384
        struct[0].Gy[97,94] = -20.5427472507027
        struct[0].Gy[97,95] = 79.2784458116404
        struct[0].Gy[97,96] = 108.131545536521
        struct[0].Gy[97,97] = -211.143538626360
        struct[0].Gy[97,98] = -20.5427472507027
        struct[0].Gy[97,99] = 79.2784458116403
        struct[0].Gy[97,100] = 23.2849644809540
        struct[0].Gy[97,101] = -24.9575997948692
        struct[0].Gy[97,102] = 10.2713736253513
        struct[0].Gy[97,103] = -39.6392229058202
        struct[0].Gy[97,104] = -54.0657727682604
        struct[0].Gy[97,105] = 105.571769313180
        struct[0].Gy[97,106] = 10.2713736253514
        struct[0].Gy[97,107] = -39.6392229058201
        struct[0].Gy[98,84] = -39.6392229058202
        struct[0].Gy[98,85] = -10.2713736253513
        struct[0].Gy[98,86] = -24.9575997948692
        struct[0].Gy[98,87] = -23.2849644809540
        struct[0].Gy[98,88] = -39.6392229058202
        struct[0].Gy[98,89] = -10.2713736253513
        struct[0].Gy[98,90] = 105.571769313180
        struct[0].Gy[98,91] = 54.0657727682604
        struct[0].Gy[98,92] = 79.2784458116403
        struct[0].Gy[98,93] = 20.5427472507027
        struct[0].Gy[98,94] = 49.9151995897384
        struct[0].Gy[98,95] = 46.5699289619080
        struct[0].Gy[98,96] = 79.2784458116403
        struct[0].Gy[98,97] = 20.5427472507027
        struct[0].Gy[98,98] = -211.143538626360
        struct[0].Gy[98,99] = -108.131545536521
        struct[0].Gy[98,100] = -39.6392229058202
        struct[0].Gy[98,101] = -10.2713736253513
        struct[0].Gy[98,102] = -24.9575997948692
        struct[0].Gy[98,103] = -23.2849644809540
        struct[0].Gy[98,104] = -39.6392229058202
        struct[0].Gy[98,105] = -10.2713736253513
        struct[0].Gy[98,106] = 105.571769313180
        struct[0].Gy[98,107] = 54.0657727682604
        struct[0].Gy[99,84] = 10.2713736253513
        struct[0].Gy[99,85] = -39.6392229058202
        struct[0].Gy[99,86] = 23.2849644809540
        struct[0].Gy[99,87] = -24.9575997948692
        struct[0].Gy[99,88] = 10.2713736253513
        struct[0].Gy[99,89] = -39.6392229058202
        struct[0].Gy[99,90] = -54.0657727682604
        struct[0].Gy[99,91] = 105.571769313180
        struct[0].Gy[99,92] = -20.5427472507027
        struct[0].Gy[99,93] = 79.2784458116403
        struct[0].Gy[99,94] = -46.5699289619080
        struct[0].Gy[99,95] = 49.9151995897384
        struct[0].Gy[99,96] = -20.5427472507027
        struct[0].Gy[99,97] = 79.2784458116403
        struct[0].Gy[99,98] = 108.131545536521
        struct[0].Gy[99,99] = -211.143538626360
        struct[0].Gy[99,100] = 10.2713736253513
        struct[0].Gy[99,101] = -39.6392229058202
        struct[0].Gy[99,102] = 23.2849644809540
        struct[0].Gy[99,103] = -24.9575997948692
        struct[0].Gy[99,104] = 10.2713736253513
        struct[0].Gy[99,105] = -39.6392229058202
        struct[0].Gy[99,106] = -54.0657727682604
        struct[0].Gy[99,107] = 105.571769313180
        struct[0].Gy[100,24] = 30.9517475172273
        struct[0].Gy[100,25] = 5.65456401516768
        struct[0].Gy[100,26] = -9.21038227100566
        struct[0].Gy[100,27] = 1.84896616921897
        struct[0].Gy[100,28] = -9.00835072044485
        struct[0].Gy[100,29] = 0.793238195499529
        struct[0].Gy[100,30] = -9.21038227100566
        struct[0].Gy[100,31] = 1.84896616921897
        struct[0].Gy[100,92] = 105.571769313180
        struct[0].Gy[100,93] = 54.0657727682604
        struct[0].Gy[100,94] = -39.6392229058202
        struct[0].Gy[100,95] = -10.2713736253513
        struct[0].Gy[100,96] = -24.9575997948692
        struct[0].Gy[100,97] = -23.2849644809540
        struct[0].Gy[100,98] = -39.6392229058202
        struct[0].Gy[100,99] = -10.2713736253513
        struct[0].Gy[100,100] = -242.095286143588
        struct[0].Gy[100,101] = -113.786109551688
        struct[0].Gy[100,102] = 88.4888280826460
        struct[0].Gy[100,103] = 18.6937810814837
        struct[0].Gy[100,104] = 58.9235503101833
        struct[0].Gy[100,105] = 45.7766907664085
        struct[0].Gy[100,106] = 88.4888280826460
        struct[0].Gy[100,107] = 18.6937810814837
        struct[0].Gy[100,108] = 105.571769313180
        struct[0].Gy[100,109] = 54.0657727682604
        struct[0].Gy[100,110] = -39.6392229058202
        struct[0].Gy[100,111] = -10.2713736253513
        struct[0].Gy[100,112] = -24.9575997948692
        struct[0].Gy[100,113] = -23.2849644809540
        struct[0].Gy[100,114] = -39.6392229058202
        struct[0].Gy[100,115] = -10.2713736253513
        struct[0].Gy[101,24] = -5.65456401516768
        struct[0].Gy[101,25] = 30.9517475172273
        struct[0].Gy[101,26] = -1.84896616921897
        struct[0].Gy[101,27] = -9.21038227100566
        struct[0].Gy[101,28] = -0.793238195499529
        struct[0].Gy[101,29] = -9.00835072044485
        struct[0].Gy[101,30] = -1.84896616921897
        struct[0].Gy[101,31] = -9.21038227100566
        struct[0].Gy[101,92] = -54.0657727682604
        struct[0].Gy[101,93] = 105.571769313180
        struct[0].Gy[101,94] = 10.2713736253513
        struct[0].Gy[101,95] = -39.6392229058202
        struct[0].Gy[101,96] = 23.2849644809540
        struct[0].Gy[101,97] = -24.9575997948692
        struct[0].Gy[101,98] = 10.2713736253513
        struct[0].Gy[101,99] = -39.6392229058202
        struct[0].Gy[101,100] = 113.786109551688
        struct[0].Gy[101,101] = -242.095286143588
        struct[0].Gy[101,102] = -18.6937810814837
        struct[0].Gy[101,103] = 88.4888280826460
        struct[0].Gy[101,104] = -45.7766907664085
        struct[0].Gy[101,105] = 58.9235503101833
        struct[0].Gy[101,106] = -18.6937810814837
        struct[0].Gy[101,107] = 88.4888280826460
        struct[0].Gy[101,108] = -54.0657727682604
        struct[0].Gy[101,109] = 105.571769313180
        struct[0].Gy[101,110] = 10.2713736253513
        struct[0].Gy[101,111] = -39.6392229058202
        struct[0].Gy[101,112] = 23.2849644809540
        struct[0].Gy[101,113] = -24.9575997948692
        struct[0].Gy[101,114] = 10.2713736253513
        struct[0].Gy[101,115] = -39.6392229058202
        struct[0].Gy[102,24] = -9.21038227100566
        struct[0].Gy[102,25] = 1.84896616921897
        struct[0].Gy[102,26] = 30.9517475172273
        struct[0].Gy[102,27] = 5.65456401516768
        struct[0].Gy[102,28] = -9.21038227100566
        struct[0].Gy[102,29] = 1.84896616921897
        struct[0].Gy[102,30] = -9.00835072044485
        struct[0].Gy[102,31] = 0.793238195499528
        struct[0].Gy[102,92] = -39.6392229058202
        struct[0].Gy[102,93] = -10.2713736253513
        struct[0].Gy[102,94] = 105.571769313180
        struct[0].Gy[102,95] = 54.0657727682604
        struct[0].Gy[102,96] = -39.6392229058201
        struct[0].Gy[102,97] = -10.2713736253513
        struct[0].Gy[102,98] = -24.9575997948692
        struct[0].Gy[102,99] = -23.2849644809540
        struct[0].Gy[102,100] = 88.4888280826460
        struct[0].Gy[102,101] = 18.6937810814837
        struct[0].Gy[102,102] = -242.095286143588
        struct[0].Gy[102,103] = -113.786109551688
        struct[0].Gy[102,104] = 88.4888280826460
        struct[0].Gy[102,105] = 18.6937810814837
        struct[0].Gy[102,106] = 58.9235503101833
        struct[0].Gy[102,107] = 45.7766907664085
        struct[0].Gy[102,108] = -39.6392229058202
        struct[0].Gy[102,109] = -10.2713736253513
        struct[0].Gy[102,110] = 105.571769313180
        struct[0].Gy[102,111] = 54.0657727682604
        struct[0].Gy[102,112] = -39.6392229058201
        struct[0].Gy[102,113] = -10.2713736253513
        struct[0].Gy[102,114] = -24.9575997948692
        struct[0].Gy[102,115] = -23.2849644809540
        struct[0].Gy[103,24] = -1.84896616921897
        struct[0].Gy[103,25] = -9.21038227100566
        struct[0].Gy[103,26] = -5.65456401516768
        struct[0].Gy[103,27] = 30.9517475172273
        struct[0].Gy[103,28] = -1.84896616921897
        struct[0].Gy[103,29] = -9.21038227100566
        struct[0].Gy[103,30] = -0.793238195499528
        struct[0].Gy[103,31] = -9.00835072044485
        struct[0].Gy[103,92] = 10.2713736253513
        struct[0].Gy[103,93] = -39.6392229058202
        struct[0].Gy[103,94] = -54.0657727682604
        struct[0].Gy[103,95] = 105.571769313180
        struct[0].Gy[103,96] = 10.2713736253513
        struct[0].Gy[103,97] = -39.6392229058201
        struct[0].Gy[103,98] = 23.2849644809540
        struct[0].Gy[103,99] = -24.9575997948692
        struct[0].Gy[103,100] = -18.6937810814837
        struct[0].Gy[103,101] = 88.4888280826460
        struct[0].Gy[103,102] = 113.786109551688
        struct[0].Gy[103,103] = -242.095286143588
        struct[0].Gy[103,104] = -18.6937810814837
        struct[0].Gy[103,105] = 88.4888280826460
        struct[0].Gy[103,106] = -45.7766907664085
        struct[0].Gy[103,107] = 58.9235503101833
        struct[0].Gy[103,108] = 10.2713736253513
        struct[0].Gy[103,109] = -39.6392229058202
        struct[0].Gy[103,110] = -54.0657727682604
        struct[0].Gy[103,111] = 105.571769313180
        struct[0].Gy[103,112] = 10.2713736253513
        struct[0].Gy[103,113] = -39.6392229058201
        struct[0].Gy[103,114] = 23.2849644809540
        struct[0].Gy[103,115] = -24.9575997948692
        struct[0].Gy[104,24] = -9.00835072044484
        struct[0].Gy[104,25] = 0.793238195499527
        struct[0].Gy[104,26] = -9.21038227100566
        struct[0].Gy[104,27] = 1.84896616921897
        struct[0].Gy[104,28] = 30.9517475172273
        struct[0].Gy[104,29] = 5.65456401516768
        struct[0].Gy[104,30] = -9.21038227100566
        struct[0].Gy[104,31] = 1.84896616921897
        struct[0].Gy[104,92] = -24.9575997948692
        struct[0].Gy[104,93] = -23.2849644809540
        struct[0].Gy[104,94] = -39.6392229058202
        struct[0].Gy[104,95] = -10.2713736253513
        struct[0].Gy[104,96] = 105.571769313180
        struct[0].Gy[104,97] = 54.0657727682604
        struct[0].Gy[104,98] = -39.6392229058201
        struct[0].Gy[104,99] = -10.2713736253514
        struct[0].Gy[104,100] = 58.9235503101833
        struct[0].Gy[104,101] = 45.7766907664085
        struct[0].Gy[104,102] = 88.4888280826461
        struct[0].Gy[104,103] = 18.6937810814837
        struct[0].Gy[104,104] = -242.095286143588
        struct[0].Gy[104,105] = -113.786109551688
        struct[0].Gy[104,106] = 88.4888280826459
        struct[0].Gy[104,107] = 18.6937810814837
        struct[0].Gy[104,108] = -24.9575997948692
        struct[0].Gy[104,109] = -23.2849644809540
        struct[0].Gy[104,110] = -39.6392229058202
        struct[0].Gy[104,111] = -10.2713736253513
        struct[0].Gy[104,112] = 105.571769313180
        struct[0].Gy[104,113] = 54.0657727682604
        struct[0].Gy[104,114] = -39.6392229058201
        struct[0].Gy[104,115] = -10.2713736253514
        struct[0].Gy[105,24] = -0.793238195499527
        struct[0].Gy[105,25] = -9.00835072044484
        struct[0].Gy[105,26] = -1.84896616921897
        struct[0].Gy[105,27] = -9.21038227100566
        struct[0].Gy[105,28] = -5.65456401516768
        struct[0].Gy[105,29] = 30.9517475172273
        struct[0].Gy[105,30] = -1.84896616921897
        struct[0].Gy[105,31] = -9.21038227100566
        struct[0].Gy[105,92] = 23.2849644809540
        struct[0].Gy[105,93] = -24.9575997948692
        struct[0].Gy[105,94] = 10.2713736253513
        struct[0].Gy[105,95] = -39.6392229058202
        struct[0].Gy[105,96] = -54.0657727682604
        struct[0].Gy[105,97] = 105.571769313180
        struct[0].Gy[105,98] = 10.2713736253514
        struct[0].Gy[105,99] = -39.6392229058201
        struct[0].Gy[105,100] = -45.7766907664085
        struct[0].Gy[105,101] = 58.9235503101833
        struct[0].Gy[105,102] = -18.6937810814837
        struct[0].Gy[105,103] = 88.4888280826461
        struct[0].Gy[105,104] = 113.786109551688
        struct[0].Gy[105,105] = -242.095286143588
        struct[0].Gy[105,106] = -18.6937810814837
        struct[0].Gy[105,107] = 88.4888280826459
        struct[0].Gy[105,108] = 23.2849644809540
        struct[0].Gy[105,109] = -24.9575997948692
        struct[0].Gy[105,110] = 10.2713736253513
        struct[0].Gy[105,111] = -39.6392229058202
        struct[0].Gy[105,112] = -54.0657727682604
        struct[0].Gy[105,113] = 105.571769313180
        struct[0].Gy[105,114] = 10.2713736253514
        struct[0].Gy[105,115] = -39.6392229058201
        struct[0].Gy[106,24] = -9.21038227100566
        struct[0].Gy[106,25] = 1.84896616921897
        struct[0].Gy[106,26] = -9.00835072044485
        struct[0].Gy[106,27] = 0.793238195499527
        struct[0].Gy[106,28] = -9.21038227100566
        struct[0].Gy[106,29] = 1.84896616921897
        struct[0].Gy[106,30] = 30.9517475172273
        struct[0].Gy[106,31] = 5.65456401516768
        struct[0].Gy[106,92] = -39.6392229058202
        struct[0].Gy[106,93] = -10.2713736253513
        struct[0].Gy[106,94] = -24.9575997948692
        struct[0].Gy[106,95] = -23.2849644809540
        struct[0].Gy[106,96] = -39.6392229058202
        struct[0].Gy[106,97] = -10.2713736253513
        struct[0].Gy[106,98] = 105.571769313180
        struct[0].Gy[106,99] = 54.0657727682604
        struct[0].Gy[106,100] = 88.4888280826460
        struct[0].Gy[106,101] = 18.6937810814837
        struct[0].Gy[106,102] = 58.9235503101832
        struct[0].Gy[106,103] = 45.7766907664085
        struct[0].Gy[106,104] = 88.4888280826460
        struct[0].Gy[106,105] = 18.6937810814837
        struct[0].Gy[106,106] = -242.120286143588
        struct[0].Gy[106,107] = -113.786109551688
        struct[0].Gy[106,108] = -39.6392229058202
        struct[0].Gy[106,109] = -10.2713736253513
        struct[0].Gy[106,110] = -24.9575997948692
        struct[0].Gy[106,111] = -23.2849644809540
        struct[0].Gy[106,112] = -39.6392229058202
        struct[0].Gy[106,113] = -10.2713736253513
        struct[0].Gy[106,114] = 105.571769313180
        struct[0].Gy[106,115] = 54.0657727682604
        struct[0].Gy[107,24] = -1.84896616921897
        struct[0].Gy[107,25] = -9.21038227100566
        struct[0].Gy[107,26] = -0.793238195499527
        struct[0].Gy[107,27] = -9.00835072044485
        struct[0].Gy[107,28] = -1.84896616921897
        struct[0].Gy[107,29] = -9.21038227100566
        struct[0].Gy[107,30] = -5.65456401516768
        struct[0].Gy[107,31] = 30.9517475172273
        struct[0].Gy[107,92] = 10.2713736253513
        struct[0].Gy[107,93] = -39.6392229058202
        struct[0].Gy[107,94] = 23.2849644809540
        struct[0].Gy[107,95] = -24.9575997948692
        struct[0].Gy[107,96] = 10.2713736253513
        struct[0].Gy[107,97] = -39.6392229058202
        struct[0].Gy[107,98] = -54.0657727682604
        struct[0].Gy[107,99] = 105.571769313180
        struct[0].Gy[107,100] = -18.6937810814837
        struct[0].Gy[107,101] = 88.4888280826460
        struct[0].Gy[107,102] = -45.7766907664085
        struct[0].Gy[107,103] = 58.9235503101832
        struct[0].Gy[107,104] = -18.6937810814837
        struct[0].Gy[107,105] = 88.4888280826460
        struct[0].Gy[107,106] = 113.786109551688
        struct[0].Gy[107,107] = -242.120286143588
        struct[0].Gy[107,108] = 10.2713736253513
        struct[0].Gy[107,109] = -39.6392229058202
        struct[0].Gy[107,110] = 23.2849644809540
        struct[0].Gy[107,111] = -24.9575997948692
        struct[0].Gy[107,112] = 10.2713736253513
        struct[0].Gy[107,113] = -39.6392229058202
        struct[0].Gy[107,114] = -54.0657727682604
        struct[0].Gy[107,115] = 105.571769313180
        struct[0].Gy[108,100] = 105.571769313180
        struct[0].Gy[108,101] = 54.0657727682604
        struct[0].Gy[108,102] = -39.6392229058202
        struct[0].Gy[108,103] = -10.2713736253513
        struct[0].Gy[108,104] = -24.9575997948692
        struct[0].Gy[108,105] = -23.2849644809540
        struct[0].Gy[108,106] = -39.6392229058202
        struct[0].Gy[108,107] = -10.2713736253513
        struct[0].Gy[108,108] = -211.143538626360
        struct[0].Gy[108,109] = -108.131545536521
        struct[0].Gy[108,110] = 79.2784458116403
        struct[0].Gy[108,111] = 20.5427472507027
        struct[0].Gy[108,112] = 49.9151995897384
        struct[0].Gy[108,113] = 46.5699289619080
        struct[0].Gy[108,114] = 79.2784458116403
        struct[0].Gy[108,115] = 20.5427472507027
        struct[0].Gy[108,116] = 105.571769313180
        struct[0].Gy[108,117] = 54.0657727682604
        struct[0].Gy[108,118] = -39.6392229058202
        struct[0].Gy[108,119] = -10.2713736253513
        struct[0].Gy[108,120] = -24.9575997948692
        struct[0].Gy[108,121] = -23.2849644809540
        struct[0].Gy[108,122] = -39.6392229058202
        struct[0].Gy[108,123] = -10.2713736253513
        struct[0].Gy[109,100] = -54.0657727682604
        struct[0].Gy[109,101] = 105.571769313180
        struct[0].Gy[109,102] = 10.2713736253513
        struct[0].Gy[109,103] = -39.6392229058202
        struct[0].Gy[109,104] = 23.2849644809540
        struct[0].Gy[109,105] = -24.9575997948692
        struct[0].Gy[109,106] = 10.2713736253513
        struct[0].Gy[109,107] = -39.6392229058202
        struct[0].Gy[109,108] = 108.131545536521
        struct[0].Gy[109,109] = -211.143538626360
        struct[0].Gy[109,110] = -20.5427472507027
        struct[0].Gy[109,111] = 79.2784458116403
        struct[0].Gy[109,112] = -46.5699289619080
        struct[0].Gy[109,113] = 49.9151995897384
        struct[0].Gy[109,114] = -20.5427472507027
        struct[0].Gy[109,115] = 79.2784458116403
        struct[0].Gy[109,116] = -54.0657727682604
        struct[0].Gy[109,117] = 105.571769313180
        struct[0].Gy[109,118] = 10.2713736253513
        struct[0].Gy[109,119] = -39.6392229058202
        struct[0].Gy[109,120] = 23.2849644809540
        struct[0].Gy[109,121] = -24.9575997948692
        struct[0].Gy[109,122] = 10.2713736253513
        struct[0].Gy[109,123] = -39.6392229058202
        struct[0].Gy[110,100] = -39.6392229058202
        struct[0].Gy[110,101] = -10.2713736253513
        struct[0].Gy[110,102] = 105.571769313180
        struct[0].Gy[110,103] = 54.0657727682604
        struct[0].Gy[110,104] = -39.6392229058201
        struct[0].Gy[110,105] = -10.2713736253513
        struct[0].Gy[110,106] = -24.9575997948692
        struct[0].Gy[110,107] = -23.2849644809540
        struct[0].Gy[110,108] = 79.2784458116403
        struct[0].Gy[110,109] = 20.5427472507027
        struct[0].Gy[110,110] = -211.143538626360
        struct[0].Gy[110,111] = -108.131545536521
        struct[0].Gy[110,112] = 79.2784458116403
        struct[0].Gy[110,113] = 20.5427472507027
        struct[0].Gy[110,114] = 49.9151995897384
        struct[0].Gy[110,115] = 46.5699289619080
        struct[0].Gy[110,116] = -39.6392229058202
        struct[0].Gy[110,117] = -10.2713736253513
        struct[0].Gy[110,118] = 105.571769313180
        struct[0].Gy[110,119] = 54.0657727682604
        struct[0].Gy[110,120] = -39.6392229058201
        struct[0].Gy[110,121] = -10.2713736253513
        struct[0].Gy[110,122] = -24.9575997948692
        struct[0].Gy[110,123] = -23.2849644809540
        struct[0].Gy[111,100] = 10.2713736253513
        struct[0].Gy[111,101] = -39.6392229058202
        struct[0].Gy[111,102] = -54.0657727682604
        struct[0].Gy[111,103] = 105.571769313180
        struct[0].Gy[111,104] = 10.2713736253513
        struct[0].Gy[111,105] = -39.6392229058201
        struct[0].Gy[111,106] = 23.2849644809540
        struct[0].Gy[111,107] = -24.9575997948692
        struct[0].Gy[111,108] = -20.5427472507027
        struct[0].Gy[111,109] = 79.2784458116403
        struct[0].Gy[111,110] = 108.131545536521
        struct[0].Gy[111,111] = -211.143538626360
        struct[0].Gy[111,112] = -20.5427472507027
        struct[0].Gy[111,113] = 79.2784458116403
        struct[0].Gy[111,114] = -46.5699289619080
        struct[0].Gy[111,115] = 49.9151995897384
        struct[0].Gy[111,116] = 10.2713736253513
        struct[0].Gy[111,117] = -39.6392229058202
        struct[0].Gy[111,118] = -54.0657727682604
        struct[0].Gy[111,119] = 105.571769313180
        struct[0].Gy[111,120] = 10.2713736253513
        struct[0].Gy[111,121] = -39.6392229058201
        struct[0].Gy[111,122] = 23.2849644809540
        struct[0].Gy[111,123] = -24.9575997948692
        struct[0].Gy[112,100] = -24.9575997948692
        struct[0].Gy[112,101] = -23.2849644809540
        struct[0].Gy[112,102] = -39.6392229058202
        struct[0].Gy[112,103] = -10.2713736253513
        struct[0].Gy[112,104] = 105.571769313180
        struct[0].Gy[112,105] = 54.0657727682604
        struct[0].Gy[112,106] = -39.6392229058201
        struct[0].Gy[112,107] = -10.2713736253514
        struct[0].Gy[112,108] = 49.9151995897384
        struct[0].Gy[112,109] = 46.5699289619080
        struct[0].Gy[112,110] = 79.2784458116404
        struct[0].Gy[112,111] = 20.5427472507027
        struct[0].Gy[112,112] = -211.143538626360
        struct[0].Gy[112,113] = -108.131545536521
        struct[0].Gy[112,114] = 79.2784458116403
        struct[0].Gy[112,115] = 20.5427472507027
        struct[0].Gy[112,116] = -24.9575997948692
        struct[0].Gy[112,117] = -23.2849644809540
        struct[0].Gy[112,118] = -39.6392229058202
        struct[0].Gy[112,119] = -10.2713736253513
        struct[0].Gy[112,120] = 105.571769313180
        struct[0].Gy[112,121] = 54.0657727682604
        struct[0].Gy[112,122] = -39.6392229058201
        struct[0].Gy[112,123] = -10.2713736253514
        struct[0].Gy[113,100] = 23.2849644809540
        struct[0].Gy[113,101] = -24.9575997948692
        struct[0].Gy[113,102] = 10.2713736253513
        struct[0].Gy[113,103] = -39.6392229058202
        struct[0].Gy[113,104] = -54.0657727682604
        struct[0].Gy[113,105] = 105.571769313180
        struct[0].Gy[113,106] = 10.2713736253514
        struct[0].Gy[113,107] = -39.6392229058201
        struct[0].Gy[113,108] = -46.5699289619080
        struct[0].Gy[113,109] = 49.9151995897384
        struct[0].Gy[113,110] = -20.5427472507027
        struct[0].Gy[113,111] = 79.2784458116404
        struct[0].Gy[113,112] = 108.131545536521
        struct[0].Gy[113,113] = -211.143538626360
        struct[0].Gy[113,114] = -20.5427472507027
        struct[0].Gy[113,115] = 79.2784458116403
        struct[0].Gy[113,116] = 23.2849644809540
        struct[0].Gy[113,117] = -24.9575997948692
        struct[0].Gy[113,118] = 10.2713736253513
        struct[0].Gy[113,119] = -39.6392229058202
        struct[0].Gy[113,120] = -54.0657727682604
        struct[0].Gy[113,121] = 105.571769313180
        struct[0].Gy[113,122] = 10.2713736253514
        struct[0].Gy[113,123] = -39.6392229058201
        struct[0].Gy[114,100] = -39.6392229058202
        struct[0].Gy[114,101] = -10.2713736253513
        struct[0].Gy[114,102] = -24.9575997948692
        struct[0].Gy[114,103] = -23.2849644809540
        struct[0].Gy[114,104] = -39.6392229058202
        struct[0].Gy[114,105] = -10.2713736253513
        struct[0].Gy[114,106] = 105.571769313180
        struct[0].Gy[114,107] = 54.0657727682604
        struct[0].Gy[114,108] = 79.2784458116403
        struct[0].Gy[114,109] = 20.5427472507027
        struct[0].Gy[114,110] = 49.9151995897384
        struct[0].Gy[114,111] = 46.5699289619080
        struct[0].Gy[114,112] = 79.2784458116403
        struct[0].Gy[114,113] = 20.5427472507027
        struct[0].Gy[114,114] = -211.143538626360
        struct[0].Gy[114,115] = -108.131545536521
        struct[0].Gy[114,116] = -39.6392229058202
        struct[0].Gy[114,117] = -10.2713736253513
        struct[0].Gy[114,118] = -24.9575997948692
        struct[0].Gy[114,119] = -23.2849644809540
        struct[0].Gy[114,120] = -39.6392229058202
        struct[0].Gy[114,121] = -10.2713736253513
        struct[0].Gy[114,122] = 105.571769313180
        struct[0].Gy[114,123] = 54.0657727682604
        struct[0].Gy[115,100] = 10.2713736253513
        struct[0].Gy[115,101] = -39.6392229058202
        struct[0].Gy[115,102] = 23.2849644809540
        struct[0].Gy[115,103] = -24.9575997948692
        struct[0].Gy[115,104] = 10.2713736253513
        struct[0].Gy[115,105] = -39.6392229058202
        struct[0].Gy[115,106] = -54.0657727682604
        struct[0].Gy[115,107] = 105.571769313180
        struct[0].Gy[115,108] = -20.5427472507027
        struct[0].Gy[115,109] = 79.2784458116403
        struct[0].Gy[115,110] = -46.5699289619080
        struct[0].Gy[115,111] = 49.9151995897384
        struct[0].Gy[115,112] = -20.5427472507027
        struct[0].Gy[115,113] = 79.2784458116403
        struct[0].Gy[115,114] = 108.131545536521
        struct[0].Gy[115,115] = -211.143538626360
        struct[0].Gy[115,116] = 10.2713736253513
        struct[0].Gy[115,117] = -39.6392229058202
        struct[0].Gy[115,118] = 23.2849644809540
        struct[0].Gy[115,119] = -24.9575997948692
        struct[0].Gy[115,120] = 10.2713736253513
        struct[0].Gy[115,121] = -39.6392229058202
        struct[0].Gy[115,122] = -54.0657727682604
        struct[0].Gy[115,123] = 105.571769313180
        struct[0].Gy[116,108] = 105.571769313180
        struct[0].Gy[116,109] = 54.0657727682604
        struct[0].Gy[116,110] = -39.6392229058202
        struct[0].Gy[116,111] = -10.2713736253513
        struct[0].Gy[116,112] = -24.9575997948692
        struct[0].Gy[116,113] = -23.2849644809540
        struct[0].Gy[116,114] = -39.6392229058202
        struct[0].Gy[116,115] = -10.2713736253513
        struct[0].Gy[116,116] = -211.143538626360
        struct[0].Gy[116,117] = -108.131545536521
        struct[0].Gy[116,118] = 79.2784458116403
        struct[0].Gy[116,119] = 20.5427472507027
        struct[0].Gy[116,120] = 49.9151995897384
        struct[0].Gy[116,121] = 46.5699289619080
        struct[0].Gy[116,122] = 79.2784458116403
        struct[0].Gy[116,123] = 20.5427472507027
        struct[0].Gy[116,124] = 105.571769313180
        struct[0].Gy[116,125] = 54.0657727682604
        struct[0].Gy[116,126] = -39.6392229058202
        struct[0].Gy[116,127] = -10.2713736253513
        struct[0].Gy[116,128] = -24.9575997948692
        struct[0].Gy[116,129] = -23.2849644809540
        struct[0].Gy[116,130] = -39.6392229058202
        struct[0].Gy[116,131] = -10.2713736253513
        struct[0].Gy[117,108] = -54.0657727682604
        struct[0].Gy[117,109] = 105.571769313180
        struct[0].Gy[117,110] = 10.2713736253513
        struct[0].Gy[117,111] = -39.6392229058202
        struct[0].Gy[117,112] = 23.2849644809540
        struct[0].Gy[117,113] = -24.9575997948692
        struct[0].Gy[117,114] = 10.2713736253513
        struct[0].Gy[117,115] = -39.6392229058202
        struct[0].Gy[117,116] = 108.131545536521
        struct[0].Gy[117,117] = -211.143538626360
        struct[0].Gy[117,118] = -20.5427472507027
        struct[0].Gy[117,119] = 79.2784458116403
        struct[0].Gy[117,120] = -46.5699289619080
        struct[0].Gy[117,121] = 49.9151995897384
        struct[0].Gy[117,122] = -20.5427472507027
        struct[0].Gy[117,123] = 79.2784458116403
        struct[0].Gy[117,124] = -54.0657727682604
        struct[0].Gy[117,125] = 105.571769313180
        struct[0].Gy[117,126] = 10.2713736253513
        struct[0].Gy[117,127] = -39.6392229058202
        struct[0].Gy[117,128] = 23.2849644809540
        struct[0].Gy[117,129] = -24.9575997948692
        struct[0].Gy[117,130] = 10.2713736253513
        struct[0].Gy[117,131] = -39.6392229058202
        struct[0].Gy[118,108] = -39.6392229058202
        struct[0].Gy[118,109] = -10.2713736253513
        struct[0].Gy[118,110] = 105.571769313180
        struct[0].Gy[118,111] = 54.0657727682604
        struct[0].Gy[118,112] = -39.6392229058201
        struct[0].Gy[118,113] = -10.2713736253513
        struct[0].Gy[118,114] = -24.9575997948692
        struct[0].Gy[118,115] = -23.2849644809540
        struct[0].Gy[118,116] = 79.2784458116403
        struct[0].Gy[118,117] = 20.5427472507027
        struct[0].Gy[118,118] = -211.143538626360
        struct[0].Gy[118,119] = -108.131545536521
        struct[0].Gy[118,120] = 79.2784458116403
        struct[0].Gy[118,121] = 20.5427472507027
        struct[0].Gy[118,122] = 49.9151995897384
        struct[0].Gy[118,123] = 46.5699289619080
        struct[0].Gy[118,124] = -39.6392229058202
        struct[0].Gy[118,125] = -10.2713736253513
        struct[0].Gy[118,126] = 105.571769313180
        struct[0].Gy[118,127] = 54.0657727682604
        struct[0].Gy[118,128] = -39.6392229058201
        struct[0].Gy[118,129] = -10.2713736253513
        struct[0].Gy[118,130] = -24.9575997948692
        struct[0].Gy[118,131] = -23.2849644809540
        struct[0].Gy[119,108] = 10.2713736253513
        struct[0].Gy[119,109] = -39.6392229058202
        struct[0].Gy[119,110] = -54.0657727682604
        struct[0].Gy[119,111] = 105.571769313180
        struct[0].Gy[119,112] = 10.2713736253513
        struct[0].Gy[119,113] = -39.6392229058201
        struct[0].Gy[119,114] = 23.2849644809540
        struct[0].Gy[119,115] = -24.9575997948692
        struct[0].Gy[119,116] = -20.5427472507027
        struct[0].Gy[119,117] = 79.2784458116403
        struct[0].Gy[119,118] = 108.131545536521
        struct[0].Gy[119,119] = -211.143538626360
        struct[0].Gy[119,120] = -20.5427472507027
        struct[0].Gy[119,121] = 79.2784458116403
        struct[0].Gy[119,122] = -46.5699289619080
        struct[0].Gy[119,123] = 49.9151995897384
        struct[0].Gy[119,124] = 10.2713736253513
        struct[0].Gy[119,125] = -39.6392229058202
        struct[0].Gy[119,126] = -54.0657727682604
        struct[0].Gy[119,127] = 105.571769313180
        struct[0].Gy[119,128] = 10.2713736253513
        struct[0].Gy[119,129] = -39.6392229058201
        struct[0].Gy[119,130] = 23.2849644809540
        struct[0].Gy[119,131] = -24.9575997948692
        struct[0].Gy[120,108] = -24.9575997948692
        struct[0].Gy[120,109] = -23.2849644809540
        struct[0].Gy[120,110] = -39.6392229058202
        struct[0].Gy[120,111] = -10.2713736253513
        struct[0].Gy[120,112] = 105.571769313180
        struct[0].Gy[120,113] = 54.0657727682604
        struct[0].Gy[120,114] = -39.6392229058201
        struct[0].Gy[120,115] = -10.2713736253514
        struct[0].Gy[120,116] = 49.9151995897384
        struct[0].Gy[120,117] = 46.5699289619080
        struct[0].Gy[120,118] = 79.2784458116404
        struct[0].Gy[120,119] = 20.5427472507027
        struct[0].Gy[120,120] = -211.143538626360
        struct[0].Gy[120,121] = -108.131545536521
        struct[0].Gy[120,122] = 79.2784458116403
        struct[0].Gy[120,123] = 20.5427472507027
        struct[0].Gy[120,124] = -24.9575997948692
        struct[0].Gy[120,125] = -23.2849644809540
        struct[0].Gy[120,126] = -39.6392229058202
        struct[0].Gy[120,127] = -10.2713736253513
        struct[0].Gy[120,128] = 105.571769313180
        struct[0].Gy[120,129] = 54.0657727682604
        struct[0].Gy[120,130] = -39.6392229058201
        struct[0].Gy[120,131] = -10.2713736253514
        struct[0].Gy[121,108] = 23.2849644809540
        struct[0].Gy[121,109] = -24.9575997948692
        struct[0].Gy[121,110] = 10.2713736253513
        struct[0].Gy[121,111] = -39.6392229058202
        struct[0].Gy[121,112] = -54.0657727682604
        struct[0].Gy[121,113] = 105.571769313180
        struct[0].Gy[121,114] = 10.2713736253514
        struct[0].Gy[121,115] = -39.6392229058201
        struct[0].Gy[121,116] = -46.5699289619080
        struct[0].Gy[121,117] = 49.9151995897384
        struct[0].Gy[121,118] = -20.5427472507027
        struct[0].Gy[121,119] = 79.2784458116404
        struct[0].Gy[121,120] = 108.131545536521
        struct[0].Gy[121,121] = -211.143538626360
        struct[0].Gy[121,122] = -20.5427472507027
        struct[0].Gy[121,123] = 79.2784458116403
        struct[0].Gy[121,124] = 23.2849644809540
        struct[0].Gy[121,125] = -24.9575997948692
        struct[0].Gy[121,126] = 10.2713736253513
        struct[0].Gy[121,127] = -39.6392229058202
        struct[0].Gy[121,128] = -54.0657727682604
        struct[0].Gy[121,129] = 105.571769313180
        struct[0].Gy[121,130] = 10.2713736253514
        struct[0].Gy[121,131] = -39.6392229058201
        struct[0].Gy[122,108] = -39.6392229058202
        struct[0].Gy[122,109] = -10.2713736253513
        struct[0].Gy[122,110] = -24.9575997948692
        struct[0].Gy[122,111] = -23.2849644809540
        struct[0].Gy[122,112] = -39.6392229058202
        struct[0].Gy[122,113] = -10.2713736253513
        struct[0].Gy[122,114] = 105.571769313180
        struct[0].Gy[122,115] = 54.0657727682604
        struct[0].Gy[122,116] = 79.2784458116403
        struct[0].Gy[122,117] = 20.5427472507027
        struct[0].Gy[122,118] = 49.9151995897384
        struct[0].Gy[122,119] = 46.5699289619080
        struct[0].Gy[122,120] = 79.2784458116403
        struct[0].Gy[122,121] = 20.5427472507027
        struct[0].Gy[122,122] = -211.168538626360
        struct[0].Gy[122,123] = -108.131545536521
        struct[0].Gy[122,124] = -39.6392229058202
        struct[0].Gy[122,125] = -10.2713736253513
        struct[0].Gy[122,126] = -24.9575997948692
        struct[0].Gy[122,127] = -23.2849644809540
        struct[0].Gy[122,128] = -39.6392229058202
        struct[0].Gy[122,129] = -10.2713736253513
        struct[0].Gy[122,130] = 105.571769313180
        struct[0].Gy[122,131] = 54.0657727682604
        struct[0].Gy[123,108] = 10.2713736253513
        struct[0].Gy[123,109] = -39.6392229058202
        struct[0].Gy[123,110] = 23.2849644809540
        struct[0].Gy[123,111] = -24.9575997948692
        struct[0].Gy[123,112] = 10.2713736253513
        struct[0].Gy[123,113] = -39.6392229058202
        struct[0].Gy[123,114] = -54.0657727682604
        struct[0].Gy[123,115] = 105.571769313180
        struct[0].Gy[123,116] = -20.5427472507027
        struct[0].Gy[123,117] = 79.2784458116403
        struct[0].Gy[123,118] = -46.5699289619080
        struct[0].Gy[123,119] = 49.9151995897384
        struct[0].Gy[123,120] = -20.5427472507027
        struct[0].Gy[123,121] = 79.2784458116403
        struct[0].Gy[123,122] = 108.131545536521
        struct[0].Gy[123,123] = -211.168538626360
        struct[0].Gy[123,124] = 10.2713736253513
        struct[0].Gy[123,125] = -39.6392229058202
        struct[0].Gy[123,126] = 23.2849644809540
        struct[0].Gy[123,127] = -24.9575997948692
        struct[0].Gy[123,128] = 10.2713736253513
        struct[0].Gy[123,129] = -39.6392229058202
        struct[0].Gy[123,130] = -54.0657727682604
        struct[0].Gy[123,131] = 105.571769313180
        struct[0].Gy[124,32] = 30.9517475172273
        struct[0].Gy[124,33] = 5.65456401516768
        struct[0].Gy[124,34] = -9.21038227100566
        struct[0].Gy[124,35] = 1.84896616921897
        struct[0].Gy[124,36] = -9.00835072044485
        struct[0].Gy[124,37] = 0.793238195499529
        struct[0].Gy[124,38] = -9.21038227100566
        struct[0].Gy[124,39] = 1.84896616921897
        struct[0].Gy[124,116] = 105.571769313180
        struct[0].Gy[124,117] = 54.0657727682604
        struct[0].Gy[124,118] = -39.6392229058202
        struct[0].Gy[124,119] = -10.2713736253513
        struct[0].Gy[124,120] = -24.9575997948692
        struct[0].Gy[124,121] = -23.2849644809540
        struct[0].Gy[124,122] = -39.6392229058202
        struct[0].Gy[124,123] = -10.2713736253513
        struct[0].Gy[124,124] = -242.095286143588
        struct[0].Gy[124,125] = -113.786109551688
        struct[0].Gy[124,126] = 88.4888280826460
        struct[0].Gy[124,127] = 18.6937810814837
        struct[0].Gy[124,128] = 58.9235503101833
        struct[0].Gy[124,129] = 45.7766907664085
        struct[0].Gy[124,130] = 88.4888280826460
        struct[0].Gy[124,131] = 18.6937810814837
        struct[0].Gy[124,132] = 105.571769313180
        struct[0].Gy[124,133] = 54.0657727682604
        struct[0].Gy[124,134] = -39.6392229058202
        struct[0].Gy[124,135] = -10.2713736253513
        struct[0].Gy[124,136] = -24.9575997948692
        struct[0].Gy[124,137] = -23.2849644809540
        struct[0].Gy[124,138] = -39.6392229058202
        struct[0].Gy[124,139] = -10.2713736253513
        struct[0].Gy[125,32] = -5.65456401516768
        struct[0].Gy[125,33] = 30.9517475172273
        struct[0].Gy[125,34] = -1.84896616921897
        struct[0].Gy[125,35] = -9.21038227100566
        struct[0].Gy[125,36] = -0.793238195499529
        struct[0].Gy[125,37] = -9.00835072044485
        struct[0].Gy[125,38] = -1.84896616921897
        struct[0].Gy[125,39] = -9.21038227100566
        struct[0].Gy[125,116] = -54.0657727682604
        struct[0].Gy[125,117] = 105.571769313180
        struct[0].Gy[125,118] = 10.2713736253513
        struct[0].Gy[125,119] = -39.6392229058202
        struct[0].Gy[125,120] = 23.2849644809540
        struct[0].Gy[125,121] = -24.9575997948692
        struct[0].Gy[125,122] = 10.2713736253513
        struct[0].Gy[125,123] = -39.6392229058202
        struct[0].Gy[125,124] = 113.786109551688
        struct[0].Gy[125,125] = -242.095286143588
        struct[0].Gy[125,126] = -18.6937810814837
        struct[0].Gy[125,127] = 88.4888280826460
        struct[0].Gy[125,128] = -45.7766907664085
        struct[0].Gy[125,129] = 58.9235503101833
        struct[0].Gy[125,130] = -18.6937810814837
        struct[0].Gy[125,131] = 88.4888280826460
        struct[0].Gy[125,132] = -54.0657727682604
        struct[0].Gy[125,133] = 105.571769313180
        struct[0].Gy[125,134] = 10.2713736253513
        struct[0].Gy[125,135] = -39.6392229058202
        struct[0].Gy[125,136] = 23.2849644809540
        struct[0].Gy[125,137] = -24.9575997948692
        struct[0].Gy[125,138] = 10.2713736253513
        struct[0].Gy[125,139] = -39.6392229058202
        struct[0].Gy[126,32] = -9.21038227100566
        struct[0].Gy[126,33] = 1.84896616921897
        struct[0].Gy[126,34] = 30.9517475172273
        struct[0].Gy[126,35] = 5.65456401516768
        struct[0].Gy[126,36] = -9.21038227100566
        struct[0].Gy[126,37] = 1.84896616921897
        struct[0].Gy[126,38] = -9.00835072044485
        struct[0].Gy[126,39] = 0.793238195499528
        struct[0].Gy[126,116] = -39.6392229058202
        struct[0].Gy[126,117] = -10.2713736253513
        struct[0].Gy[126,118] = 105.571769313180
        struct[0].Gy[126,119] = 54.0657727682604
        struct[0].Gy[126,120] = -39.6392229058201
        struct[0].Gy[126,121] = -10.2713736253513
        struct[0].Gy[126,122] = -24.9575997948692
        struct[0].Gy[126,123] = -23.2849644809540
        struct[0].Gy[126,124] = 88.4888280826460
        struct[0].Gy[126,125] = 18.6937810814837
        struct[0].Gy[126,126] = -242.095286143588
        struct[0].Gy[126,127] = -113.786109551688
        struct[0].Gy[126,128] = 88.4888280826460
        struct[0].Gy[126,129] = 18.6937810814837
        struct[0].Gy[126,130] = 58.9235503101833
        struct[0].Gy[126,131] = 45.7766907664085
        struct[0].Gy[126,132] = -39.6392229058202
        struct[0].Gy[126,133] = -10.2713736253513
        struct[0].Gy[126,134] = 105.571769313180
        struct[0].Gy[126,135] = 54.0657727682604
        struct[0].Gy[126,136] = -39.6392229058201
        struct[0].Gy[126,137] = -10.2713736253513
        struct[0].Gy[126,138] = -24.9575997948692
        struct[0].Gy[126,139] = -23.2849644809540
        struct[0].Gy[127,32] = -1.84896616921897
        struct[0].Gy[127,33] = -9.21038227100566
        struct[0].Gy[127,34] = -5.65456401516768
        struct[0].Gy[127,35] = 30.9517475172273
        struct[0].Gy[127,36] = -1.84896616921897
        struct[0].Gy[127,37] = -9.21038227100566
        struct[0].Gy[127,38] = -0.793238195499528
        struct[0].Gy[127,39] = -9.00835072044485
        struct[0].Gy[127,116] = 10.2713736253513
        struct[0].Gy[127,117] = -39.6392229058202
        struct[0].Gy[127,118] = -54.0657727682604
        struct[0].Gy[127,119] = 105.571769313180
        struct[0].Gy[127,120] = 10.2713736253513
        struct[0].Gy[127,121] = -39.6392229058201
        struct[0].Gy[127,122] = 23.2849644809540
        struct[0].Gy[127,123] = -24.9575997948692
        struct[0].Gy[127,124] = -18.6937810814837
        struct[0].Gy[127,125] = 88.4888280826460
        struct[0].Gy[127,126] = 113.786109551688
        struct[0].Gy[127,127] = -242.095286143588
        struct[0].Gy[127,128] = -18.6937810814837
        struct[0].Gy[127,129] = 88.4888280826460
        struct[0].Gy[127,130] = -45.7766907664085
        struct[0].Gy[127,131] = 58.9235503101833
        struct[0].Gy[127,132] = 10.2713736253513
        struct[0].Gy[127,133] = -39.6392229058202
        struct[0].Gy[127,134] = -54.0657727682604
        struct[0].Gy[127,135] = 105.571769313180
        struct[0].Gy[127,136] = 10.2713736253513
        struct[0].Gy[127,137] = -39.6392229058201
        struct[0].Gy[127,138] = 23.2849644809540
        struct[0].Gy[127,139] = -24.9575997948692
        struct[0].Gy[128,32] = -9.00835072044484
        struct[0].Gy[128,33] = 0.793238195499527
        struct[0].Gy[128,34] = -9.21038227100566
        struct[0].Gy[128,35] = 1.84896616921897
        struct[0].Gy[128,36] = 30.9517475172273
        struct[0].Gy[128,37] = 5.65456401516768
        struct[0].Gy[128,38] = -9.21038227100566
        struct[0].Gy[128,39] = 1.84896616921897
        struct[0].Gy[128,116] = -24.9575997948692
        struct[0].Gy[128,117] = -23.2849644809540
        struct[0].Gy[128,118] = -39.6392229058202
        struct[0].Gy[128,119] = -10.2713736253513
        struct[0].Gy[128,120] = 105.571769313180
        struct[0].Gy[128,121] = 54.0657727682604
        struct[0].Gy[128,122] = -39.6392229058201
        struct[0].Gy[128,123] = -10.2713736253514
        struct[0].Gy[128,124] = 58.9235503101833
        struct[0].Gy[128,125] = 45.7766907664085
        struct[0].Gy[128,126] = 88.4888280826461
        struct[0].Gy[128,127] = 18.6937810814837
        struct[0].Gy[128,128] = -242.095286143588
        struct[0].Gy[128,129] = -113.786109551688
        struct[0].Gy[128,130] = 88.4888280826459
        struct[0].Gy[128,131] = 18.6937810814837
        struct[0].Gy[128,132] = -24.9575997948692
        struct[0].Gy[128,133] = -23.2849644809540
        struct[0].Gy[128,134] = -39.6392229058202
        struct[0].Gy[128,135] = -10.2713736253513
        struct[0].Gy[128,136] = 105.571769313180
        struct[0].Gy[128,137] = 54.0657727682604
        struct[0].Gy[128,138] = -39.6392229058201
        struct[0].Gy[128,139] = -10.2713736253514
        struct[0].Gy[129,32] = -0.793238195499527
        struct[0].Gy[129,33] = -9.00835072044484
        struct[0].Gy[129,34] = -1.84896616921897
        struct[0].Gy[129,35] = -9.21038227100566
        struct[0].Gy[129,36] = -5.65456401516768
        struct[0].Gy[129,37] = 30.9517475172273
        struct[0].Gy[129,38] = -1.84896616921897
        struct[0].Gy[129,39] = -9.21038227100566
        struct[0].Gy[129,116] = 23.2849644809540
        struct[0].Gy[129,117] = -24.9575997948692
        struct[0].Gy[129,118] = 10.2713736253513
        struct[0].Gy[129,119] = -39.6392229058202
        struct[0].Gy[129,120] = -54.0657727682604
        struct[0].Gy[129,121] = 105.571769313180
        struct[0].Gy[129,122] = 10.2713736253514
        struct[0].Gy[129,123] = -39.6392229058201
        struct[0].Gy[129,124] = -45.7766907664085
        struct[0].Gy[129,125] = 58.9235503101833
        struct[0].Gy[129,126] = -18.6937810814837
        struct[0].Gy[129,127] = 88.4888280826461
        struct[0].Gy[129,128] = 113.786109551688
        struct[0].Gy[129,129] = -242.095286143588
        struct[0].Gy[129,130] = -18.6937810814837
        struct[0].Gy[129,131] = 88.4888280826459
        struct[0].Gy[129,132] = 23.2849644809540
        struct[0].Gy[129,133] = -24.9575997948692
        struct[0].Gy[129,134] = 10.2713736253513
        struct[0].Gy[129,135] = -39.6392229058202
        struct[0].Gy[129,136] = -54.0657727682604
        struct[0].Gy[129,137] = 105.571769313180
        struct[0].Gy[129,138] = 10.2713736253514
        struct[0].Gy[129,139] = -39.6392229058201
        struct[0].Gy[130,32] = -9.21038227100566
        struct[0].Gy[130,33] = 1.84896616921897
        struct[0].Gy[130,34] = -9.00835072044485
        struct[0].Gy[130,35] = 0.793238195499527
        struct[0].Gy[130,36] = -9.21038227100566
        struct[0].Gy[130,37] = 1.84896616921897
        struct[0].Gy[130,38] = 30.9517475172273
        struct[0].Gy[130,39] = 5.65456401516768
        struct[0].Gy[130,116] = -39.6392229058202
        struct[0].Gy[130,117] = -10.2713736253513
        struct[0].Gy[130,118] = -24.9575997948692
        struct[0].Gy[130,119] = -23.2849644809540
        struct[0].Gy[130,120] = -39.6392229058202
        struct[0].Gy[130,121] = -10.2713736253513
        struct[0].Gy[130,122] = 105.571769313180
        struct[0].Gy[130,123] = 54.0657727682604
        struct[0].Gy[130,124] = 88.4888280826460
        struct[0].Gy[130,125] = 18.6937810814837
        struct[0].Gy[130,126] = 58.9235503101832
        struct[0].Gy[130,127] = 45.7766907664085
        struct[0].Gy[130,128] = 88.4888280826460
        struct[0].Gy[130,129] = 18.6937810814837
        struct[0].Gy[130,130] = -242.095286143588
        struct[0].Gy[130,131] = -113.786109551688
        struct[0].Gy[130,132] = -39.6392229058202
        struct[0].Gy[130,133] = -10.2713736253513
        struct[0].Gy[130,134] = -24.9575997948692
        struct[0].Gy[130,135] = -23.2849644809540
        struct[0].Gy[130,136] = -39.6392229058202
        struct[0].Gy[130,137] = -10.2713736253513
        struct[0].Gy[130,138] = 105.571769313180
        struct[0].Gy[130,139] = 54.0657727682604
        struct[0].Gy[131,32] = -1.84896616921897
        struct[0].Gy[131,33] = -9.21038227100566
        struct[0].Gy[131,34] = -0.793238195499527
        struct[0].Gy[131,35] = -9.00835072044485
        struct[0].Gy[131,36] = -1.84896616921897
        struct[0].Gy[131,37] = -9.21038227100566
        struct[0].Gy[131,38] = -5.65456401516768
        struct[0].Gy[131,39] = 30.9517475172273
        struct[0].Gy[131,116] = 10.2713736253513
        struct[0].Gy[131,117] = -39.6392229058202
        struct[0].Gy[131,118] = 23.2849644809540
        struct[0].Gy[131,119] = -24.9575997948692
        struct[0].Gy[131,120] = 10.2713736253513
        struct[0].Gy[131,121] = -39.6392229058202
        struct[0].Gy[131,122] = -54.0657727682604
        struct[0].Gy[131,123] = 105.571769313180
        struct[0].Gy[131,124] = -18.6937810814837
        struct[0].Gy[131,125] = 88.4888280826460
        struct[0].Gy[131,126] = -45.7766907664085
        struct[0].Gy[131,127] = 58.9235503101832
        struct[0].Gy[131,128] = -18.6937810814837
        struct[0].Gy[131,129] = 88.4888280826460
        struct[0].Gy[131,130] = 113.786109551688
        struct[0].Gy[131,131] = -242.095286143588
        struct[0].Gy[131,132] = 10.2713736253513
        struct[0].Gy[131,133] = -39.6392229058202
        struct[0].Gy[131,134] = 23.2849644809540
        struct[0].Gy[131,135] = -24.9575997948692
        struct[0].Gy[131,136] = 10.2713736253513
        struct[0].Gy[131,137] = -39.6392229058202
        struct[0].Gy[131,138] = -54.0657727682604
        struct[0].Gy[131,139] = 105.571769313180
        struct[0].Gy[132,40] = 30.9517475172273
        struct[0].Gy[132,41] = 5.65456401516768
        struct[0].Gy[132,42] = -9.21038227100566
        struct[0].Gy[132,43] = 1.84896616921897
        struct[0].Gy[132,44] = -9.00835072044485
        struct[0].Gy[132,45] = 0.793238195499529
        struct[0].Gy[132,46] = -9.21038227100566
        struct[0].Gy[132,47] = 1.84896616921897
        struct[0].Gy[132,124] = 105.571769313180
        struct[0].Gy[132,125] = 54.0657727682604
        struct[0].Gy[132,126] = -39.6392229058202
        struct[0].Gy[132,127] = -10.2713736253513
        struct[0].Gy[132,128] = -24.9575997948692
        struct[0].Gy[132,129] = -23.2849644809540
        struct[0].Gy[132,130] = -39.6392229058202
        struct[0].Gy[132,131] = -10.2713736253513
        struct[0].Gy[132,132] = -136.523516830407
        struct[0].Gy[132,133] = -59.7203367834281
        struct[0].Gy[132,134] = 48.8496051768258
        struct[0].Gy[132,135] = 8.42240745613237
        struct[0].Gy[132,136] = 33.9659505153141
        struct[0].Gy[132,137] = 22.4917262854545
        struct[0].Gy[132,138] = 48.8496051768258
        struct[0].Gy[132,139] = 8.42240745613237
        struct[0].Gy[132,413] = 1
        struct[0].Gy[133,40] = -5.65456401516768
        struct[0].Gy[133,41] = 30.9517475172273
        struct[0].Gy[133,42] = -1.84896616921897
        struct[0].Gy[133,43] = -9.21038227100566
        struct[0].Gy[133,44] = -0.793238195499529
        struct[0].Gy[133,45] = -9.00835072044485
        struct[0].Gy[133,46] = -1.84896616921897
        struct[0].Gy[133,47] = -9.21038227100566
        struct[0].Gy[133,124] = -54.0657727682604
        struct[0].Gy[133,125] = 105.571769313180
        struct[0].Gy[133,126] = 10.2713736253513
        struct[0].Gy[133,127] = -39.6392229058202
        struct[0].Gy[133,128] = 23.2849644809540
        struct[0].Gy[133,129] = -24.9575997948692
        struct[0].Gy[133,130] = 10.2713736253513
        struct[0].Gy[133,131] = -39.6392229058202
        struct[0].Gy[133,132] = 59.7203367834281
        struct[0].Gy[133,133] = -136.523516830407
        struct[0].Gy[133,134] = -8.42240745613237
        struct[0].Gy[133,135] = 48.8496051768258
        struct[0].Gy[133,136] = -22.4917262854545
        struct[0].Gy[133,137] = 33.9659505153141
        struct[0].Gy[133,138] = -8.42240745613237
        struct[0].Gy[133,139] = 48.8496051768258
        struct[0].Gy[133,414] = 1
        struct[0].Gy[134,40] = -9.21038227100566
        struct[0].Gy[134,41] = 1.84896616921897
        struct[0].Gy[134,42] = 30.9517475172273
        struct[0].Gy[134,43] = 5.65456401516768
        struct[0].Gy[134,44] = -9.21038227100566
        struct[0].Gy[134,45] = 1.84896616921897
        struct[0].Gy[134,46] = -9.00835072044485
        struct[0].Gy[134,47] = 0.793238195499528
        struct[0].Gy[134,124] = -39.6392229058202
        struct[0].Gy[134,125] = -10.2713736253513
        struct[0].Gy[134,126] = 105.571769313180
        struct[0].Gy[134,127] = 54.0657727682604
        struct[0].Gy[134,128] = -39.6392229058201
        struct[0].Gy[134,129] = -10.2713736253513
        struct[0].Gy[134,130] = -24.9575997948692
        struct[0].Gy[134,131] = -23.2849644809540
        struct[0].Gy[134,132] = 48.8496051768258
        struct[0].Gy[134,133] = 8.42240745613237
        struct[0].Gy[134,134] = -136.523516830407
        struct[0].Gy[134,135] = -59.7203367834280
        struct[0].Gy[134,136] = 48.8496051768258
        struct[0].Gy[134,137] = 8.42240745613238
        struct[0].Gy[134,138] = 33.9659505153141
        struct[0].Gy[134,139] = 22.4917262854545
        struct[0].Gy[134,415] = 1
        struct[0].Gy[135,40] = -1.84896616921897
        struct[0].Gy[135,41] = -9.21038227100566
        struct[0].Gy[135,42] = -5.65456401516768
        struct[0].Gy[135,43] = 30.9517475172273
        struct[0].Gy[135,44] = -1.84896616921897
        struct[0].Gy[135,45] = -9.21038227100566
        struct[0].Gy[135,46] = -0.793238195499528
        struct[0].Gy[135,47] = -9.00835072044485
        struct[0].Gy[135,124] = 10.2713736253513
        struct[0].Gy[135,125] = -39.6392229058202
        struct[0].Gy[135,126] = -54.0657727682604
        struct[0].Gy[135,127] = 105.571769313180
        struct[0].Gy[135,128] = 10.2713736253513
        struct[0].Gy[135,129] = -39.6392229058201
        struct[0].Gy[135,130] = 23.2849644809540
        struct[0].Gy[135,131] = -24.9575997948692
        struct[0].Gy[135,132] = -8.42240745613237
        struct[0].Gy[135,133] = 48.8496051768258
        struct[0].Gy[135,134] = 59.7203367834280
        struct[0].Gy[135,135] = -136.523516830407
        struct[0].Gy[135,136] = -8.42240745613238
        struct[0].Gy[135,137] = 48.8496051768258
        struct[0].Gy[135,138] = -22.4917262854545
        struct[0].Gy[135,139] = 33.9659505153141
        struct[0].Gy[135,416] = 1
        struct[0].Gy[136,40] = -9.00835072044484
        struct[0].Gy[136,41] = 0.793238195499527
        struct[0].Gy[136,42] = -9.21038227100566
        struct[0].Gy[136,43] = 1.84896616921897
        struct[0].Gy[136,44] = 30.9517475172273
        struct[0].Gy[136,45] = 5.65456401516768
        struct[0].Gy[136,46] = -9.21038227100566
        struct[0].Gy[136,47] = 1.84896616921897
        struct[0].Gy[136,124] = -24.9575997948692
        struct[0].Gy[136,125] = -23.2849644809540
        struct[0].Gy[136,126] = -39.6392229058202
        struct[0].Gy[136,127] = -10.2713736253513
        struct[0].Gy[136,128] = 105.571769313180
        struct[0].Gy[136,129] = 54.0657727682604
        struct[0].Gy[136,130] = -39.6392229058201
        struct[0].Gy[136,131] = -10.2713736253514
        struct[0].Gy[136,132] = 33.9659505153141
        struct[0].Gy[136,133] = 22.4917262854545
        struct[0].Gy[136,134] = 48.8496051768259
        struct[0].Gy[136,135] = 8.42240745613236
        struct[0].Gy[136,136] = -136.523516830407
        struct[0].Gy[136,137] = -59.7203367834281
        struct[0].Gy[136,138] = 48.8496051768258
        struct[0].Gy[136,139] = 8.42240745613239
        struct[0].Gy[136,417] = 1
        struct[0].Gy[137,40] = -0.793238195499527
        struct[0].Gy[137,41] = -9.00835072044484
        struct[0].Gy[137,42] = -1.84896616921897
        struct[0].Gy[137,43] = -9.21038227100566
        struct[0].Gy[137,44] = -5.65456401516768
        struct[0].Gy[137,45] = 30.9517475172273
        struct[0].Gy[137,46] = -1.84896616921897
        struct[0].Gy[137,47] = -9.21038227100566
        struct[0].Gy[137,124] = 23.2849644809540
        struct[0].Gy[137,125] = -24.9575997948692
        struct[0].Gy[137,126] = 10.2713736253513
        struct[0].Gy[137,127] = -39.6392229058202
        struct[0].Gy[137,128] = -54.0657727682604
        struct[0].Gy[137,129] = 105.571769313180
        struct[0].Gy[137,130] = 10.2713736253514
        struct[0].Gy[137,131] = -39.6392229058201
        struct[0].Gy[137,132] = -22.4917262854545
        struct[0].Gy[137,133] = 33.9659505153141
        struct[0].Gy[137,134] = -8.42240745613236
        struct[0].Gy[137,135] = 48.8496051768259
        struct[0].Gy[137,136] = 59.7203367834281
        struct[0].Gy[137,137] = -136.523516830407
        struct[0].Gy[137,138] = -8.42240745613239
        struct[0].Gy[137,139] = 48.8496051768258
        struct[0].Gy[137,418] = 1
        struct[0].Gy[138,40] = -9.21038227100566
        struct[0].Gy[138,41] = 1.84896616921897
        struct[0].Gy[138,42] = -9.00835072044485
        struct[0].Gy[138,43] = 0.793238195499527
        struct[0].Gy[138,44] = -9.21038227100566
        struct[0].Gy[138,45] = 1.84896616921897
        struct[0].Gy[138,46] = 30.9517475172273
        struct[0].Gy[138,47] = 5.65456401516768
        struct[0].Gy[138,124] = -39.6392229058202
        struct[0].Gy[138,125] = -10.2713736253513
        struct[0].Gy[138,126] = -24.9575997948692
        struct[0].Gy[138,127] = -23.2849644809540
        struct[0].Gy[138,128] = -39.6392229058202
        struct[0].Gy[138,129] = -10.2713736253513
        struct[0].Gy[138,130] = 105.571769313180
        struct[0].Gy[138,131] = 54.0657727682604
        struct[0].Gy[138,132] = 48.8496051768258
        struct[0].Gy[138,133] = 8.42240745613237
        struct[0].Gy[138,134] = 33.9659505153140
        struct[0].Gy[138,135] = 22.4917262854545
        struct[0].Gy[138,136] = 48.8496051768258
        struct[0].Gy[138,137] = 8.42240745613237
        struct[0].Gy[138,138] = -136.548516830407
        struct[0].Gy[138,139] = -59.7203367834281
        struct[0].Gy[139,40] = -1.84896616921897
        struct[0].Gy[139,41] = -9.21038227100566
        struct[0].Gy[139,42] = -0.793238195499527
        struct[0].Gy[139,43] = -9.00835072044485
        struct[0].Gy[139,44] = -1.84896616921897
        struct[0].Gy[139,45] = -9.21038227100566
        struct[0].Gy[139,46] = -5.65456401516768
        struct[0].Gy[139,47] = 30.9517475172273
        struct[0].Gy[139,124] = 10.2713736253513
        struct[0].Gy[139,125] = -39.6392229058202
        struct[0].Gy[139,126] = 23.2849644809540
        struct[0].Gy[139,127] = -24.9575997948692
        struct[0].Gy[139,128] = 10.2713736253513
        struct[0].Gy[139,129] = -39.6392229058202
        struct[0].Gy[139,130] = -54.0657727682604
        struct[0].Gy[139,131] = 105.571769313180
        struct[0].Gy[139,132] = -8.42240745613237
        struct[0].Gy[139,133] = 48.8496051768258
        struct[0].Gy[139,134] = -22.4917262854545
        struct[0].Gy[139,135] = 33.9659505153140
        struct[0].Gy[139,136] = -8.42240745613237
        struct[0].Gy[139,137] = 48.8496051768258
        struct[0].Gy[139,138] = 59.7203367834281
        struct[0].Gy[139,139] = -136.548516830407
        struct[0].Gy[140,84] = 26.5300693004806
        struct[0].Gy[140,85] = 4.84676915585801
        struct[0].Gy[140,86] = -7.89461337514770
        struct[0].Gy[140,87] = 1.58482814504483
        struct[0].Gy[140,88] = -7.72144347466701
        struct[0].Gy[140,89] = 0.679918453285310
        struct[0].Gy[140,90] = -7.89461337514771
        struct[0].Gy[140,91] = 1.58482814504483
        struct[0].Gy[140,140] = -53.0601386009611
        struct[0].Gy[140,141] = -9.69353831171601
        struct[0].Gy[140,142] = 15.7892267502954
        struct[0].Gy[140,143] = -3.16965629008966
        struct[0].Gy[140,144] = 15.4428869493340
        struct[0].Gy[140,145] = -1.35983690657062
        struct[0].Gy[140,146] = 15.7892267502954
        struct[0].Gy[140,147] = -3.16965629008966
        struct[0].Gy[140,148] = 26.5300693004806
        struct[0].Gy[140,149] = 4.84676915585801
        struct[0].Gy[140,150] = -7.89461337514770
        struct[0].Gy[140,151] = 1.58482814504483
        struct[0].Gy[140,152] = -7.72144347466701
        struct[0].Gy[140,153] = 0.679918453285310
        struct[0].Gy[140,154] = -7.89461337514771
        struct[0].Gy[140,155] = 1.58482814504483
        struct[0].Gy[141,84] = -4.84676915585801
        struct[0].Gy[141,85] = 26.5300693004806
        struct[0].Gy[141,86] = -1.58482814504483
        struct[0].Gy[141,87] = -7.89461337514770
        struct[0].Gy[141,88] = -0.679918453285310
        struct[0].Gy[141,89] = -7.72144347466701
        struct[0].Gy[141,90] = -1.58482814504483
        struct[0].Gy[141,91] = -7.89461337514771
        struct[0].Gy[141,140] = 9.69353831171601
        struct[0].Gy[141,141] = -53.0601386009611
        struct[0].Gy[141,142] = 3.16965629008966
        struct[0].Gy[141,143] = 15.7892267502954
        struct[0].Gy[141,144] = 1.35983690657062
        struct[0].Gy[141,145] = 15.4428869493340
        struct[0].Gy[141,146] = 3.16965629008966
        struct[0].Gy[141,147] = 15.7892267502954
        struct[0].Gy[141,148] = -4.84676915585801
        struct[0].Gy[141,149] = 26.5300693004806
        struct[0].Gy[141,150] = -1.58482814504483
        struct[0].Gy[141,151] = -7.89461337514770
        struct[0].Gy[141,152] = -0.679918453285310
        struct[0].Gy[141,153] = -7.72144347466701
        struct[0].Gy[141,154] = -1.58482814504483
        struct[0].Gy[141,155] = -7.89461337514771
        struct[0].Gy[142,84] = -7.89461337514771
        struct[0].Gy[142,85] = 1.58482814504483
        struct[0].Gy[142,86] = 26.5300693004806
        struct[0].Gy[142,87] = 4.84676915585801
        struct[0].Gy[142,88] = -7.89461337514771
        struct[0].Gy[142,89] = 1.58482814504483
        struct[0].Gy[142,90] = -7.72144347466701
        struct[0].Gy[142,91] = 0.679918453285308
        struct[0].Gy[142,140] = 15.7892267502954
        struct[0].Gy[142,141] = -3.16965629008966
        struct[0].Gy[142,142] = -53.0601386009611
        struct[0].Gy[142,143] = -9.69353831171602
        struct[0].Gy[142,144] = 15.7892267502954
        struct[0].Gy[142,145] = -3.16965629008967
        struct[0].Gy[142,146] = 15.4428869493340
        struct[0].Gy[142,147] = -1.35983690657062
        struct[0].Gy[142,148] = -7.89461337514771
        struct[0].Gy[142,149] = 1.58482814504483
        struct[0].Gy[142,150] = 26.5300693004806
        struct[0].Gy[142,151] = 4.84676915585801
        struct[0].Gy[142,152] = -7.89461337514771
        struct[0].Gy[142,153] = 1.58482814504483
        struct[0].Gy[142,154] = -7.72144347466701
        struct[0].Gy[142,155] = 0.679918453285308
        struct[0].Gy[143,84] = -1.58482814504483
        struct[0].Gy[143,85] = -7.89461337514771
        struct[0].Gy[143,86] = -4.84676915585801
        struct[0].Gy[143,87] = 26.5300693004806
        struct[0].Gy[143,88] = -1.58482814504483
        struct[0].Gy[143,89] = -7.89461337514771
        struct[0].Gy[143,90] = -0.679918453285308
        struct[0].Gy[143,91] = -7.72144347466701
        struct[0].Gy[143,140] = 3.16965629008966
        struct[0].Gy[143,141] = 15.7892267502954
        struct[0].Gy[143,142] = 9.69353831171602
        struct[0].Gy[143,143] = -53.0601386009611
        struct[0].Gy[143,144] = 3.16965629008967
        struct[0].Gy[143,145] = 15.7892267502954
        struct[0].Gy[143,146] = 1.35983690657062
        struct[0].Gy[143,147] = 15.4428869493340
        struct[0].Gy[143,148] = -1.58482814504483
        struct[0].Gy[143,149] = -7.89461337514771
        struct[0].Gy[143,150] = -4.84676915585801
        struct[0].Gy[143,151] = 26.5300693004806
        struct[0].Gy[143,152] = -1.58482814504483
        struct[0].Gy[143,153] = -7.89461337514771
        struct[0].Gy[143,154] = -0.679918453285308
        struct[0].Gy[143,155] = -7.72144347466701
        struct[0].Gy[144,84] = -7.72144347466701
        struct[0].Gy[144,85] = 0.679918453285310
        struct[0].Gy[144,86] = -7.89461337514770
        struct[0].Gy[144,87] = 1.58482814504483
        struct[0].Gy[144,88] = 26.5300693004806
        struct[0].Gy[144,89] = 4.84676915585801
        struct[0].Gy[144,90] = -7.89461337514771
        struct[0].Gy[144,91] = 1.58482814504483
        struct[0].Gy[144,140] = 15.4428869493340
        struct[0].Gy[144,141] = -1.35983690657062
        struct[0].Gy[144,142] = 15.7892267502954
        struct[0].Gy[144,143] = -3.16965629008966
        struct[0].Gy[144,144] = -53.0601386009611
        struct[0].Gy[144,145] = -9.69353831171602
        struct[0].Gy[144,146] = 15.7892267502954
        struct[0].Gy[144,147] = -3.16965629008967
        struct[0].Gy[144,148] = -7.72144347466701
        struct[0].Gy[144,149] = 0.679918453285310
        struct[0].Gy[144,150] = -7.89461337514770
        struct[0].Gy[144,151] = 1.58482814504483
        struct[0].Gy[144,152] = 26.5300693004806
        struct[0].Gy[144,153] = 4.84676915585801
        struct[0].Gy[144,154] = -7.89461337514771
        struct[0].Gy[144,155] = 1.58482814504483
        struct[0].Gy[145,84] = -0.679918453285310
        struct[0].Gy[145,85] = -7.72144347466701
        struct[0].Gy[145,86] = -1.58482814504483
        struct[0].Gy[145,87] = -7.89461337514770
        struct[0].Gy[145,88] = -4.84676915585801
        struct[0].Gy[145,89] = 26.5300693004806
        struct[0].Gy[145,90] = -1.58482814504483
        struct[0].Gy[145,91] = -7.89461337514771
        struct[0].Gy[145,140] = 1.35983690657062
        struct[0].Gy[145,141] = 15.4428869493340
        struct[0].Gy[145,142] = 3.16965629008966
        struct[0].Gy[145,143] = 15.7892267502954
        struct[0].Gy[145,144] = 9.69353831171602
        struct[0].Gy[145,145] = -53.0601386009611
        struct[0].Gy[145,146] = 3.16965629008967
        struct[0].Gy[145,147] = 15.7892267502954
        struct[0].Gy[145,148] = -0.679918453285310
        struct[0].Gy[145,149] = -7.72144347466701
        struct[0].Gy[145,150] = -1.58482814504483
        struct[0].Gy[145,151] = -7.89461337514770
        struct[0].Gy[145,152] = -4.84676915585801
        struct[0].Gy[145,153] = 26.5300693004806
        struct[0].Gy[145,154] = -1.58482814504483
        struct[0].Gy[145,155] = -7.89461337514771
        struct[0].Gy[146,84] = -7.89461337514771
        struct[0].Gy[146,85] = 1.58482814504483
        struct[0].Gy[146,86] = -7.72144347466701
        struct[0].Gy[146,87] = 0.679918453285308
        struct[0].Gy[146,88] = -7.89461337514771
        struct[0].Gy[146,89] = 1.58482814504483
        struct[0].Gy[146,90] = 26.5300693004806
        struct[0].Gy[146,91] = 4.84676915585801
        struct[0].Gy[146,140] = 15.7892267502954
        struct[0].Gy[146,141] = -3.16965629008966
        struct[0].Gy[146,142] = 15.4428869493340
        struct[0].Gy[146,143] = -1.35983690657062
        struct[0].Gy[146,144] = 15.7892267502954
        struct[0].Gy[146,145] = -3.16965629008966
        struct[0].Gy[146,146] = -53.0601386009611
        struct[0].Gy[146,147] = -9.69353831171602
        struct[0].Gy[146,148] = -7.89461337514771
        struct[0].Gy[146,149] = 1.58482814504483
        struct[0].Gy[146,150] = -7.72144347466701
        struct[0].Gy[146,151] = 0.679918453285308
        struct[0].Gy[146,152] = -7.89461337514771
        struct[0].Gy[146,153] = 1.58482814504483
        struct[0].Gy[146,154] = 26.5300693004806
        struct[0].Gy[146,155] = 4.84676915585801
        struct[0].Gy[147,84] = -1.58482814504483
        struct[0].Gy[147,85] = -7.89461337514771
        struct[0].Gy[147,86] = -0.679918453285308
        struct[0].Gy[147,87] = -7.72144347466701
        struct[0].Gy[147,88] = -1.58482814504483
        struct[0].Gy[147,89] = -7.89461337514771
        struct[0].Gy[147,90] = -4.84676915585801
        struct[0].Gy[147,91] = 26.5300693004806
        struct[0].Gy[147,140] = 3.16965629008966
        struct[0].Gy[147,141] = 15.7892267502954
        struct[0].Gy[147,142] = 1.35983690657062
        struct[0].Gy[147,143] = 15.4428869493340
        struct[0].Gy[147,144] = 3.16965629008966
        struct[0].Gy[147,145] = 15.7892267502954
        struct[0].Gy[147,146] = 9.69353831171602
        struct[0].Gy[147,147] = -53.0601386009611
        struct[0].Gy[147,148] = -1.58482814504483
        struct[0].Gy[147,149] = -7.89461337514771
        struct[0].Gy[147,150] = -0.679918453285308
        struct[0].Gy[147,151] = -7.72144347466701
        struct[0].Gy[147,152] = -1.58482814504483
        struct[0].Gy[147,153] = -7.89461337514771
        struct[0].Gy[147,154] = -4.84676915585801
        struct[0].Gy[147,155] = 26.5300693004806
        struct[0].Gy[148,140] = 26.5300693004806
        struct[0].Gy[148,141] = 4.84676915585801
        struct[0].Gy[148,142] = -7.89461337514770
        struct[0].Gy[148,143] = 1.58482814504483
        struct[0].Gy[148,144] = -7.72144347466701
        struct[0].Gy[148,145] = 0.679918453285310
        struct[0].Gy[148,146] = -7.89461337514771
        struct[0].Gy[148,147] = 1.58482814504483
        struct[0].Gy[148,148] = -53.0601386009611
        struct[0].Gy[148,149] = -9.69353831171601
        struct[0].Gy[148,150] = 15.7892267502954
        struct[0].Gy[148,151] = -3.16965629008966
        struct[0].Gy[148,152] = 15.4428869493340
        struct[0].Gy[148,153] = -1.35983690657062
        struct[0].Gy[148,154] = 15.7892267502954
        struct[0].Gy[148,155] = -3.16965629008966
        struct[0].Gy[148,156] = 26.5300693004806
        struct[0].Gy[148,157] = 4.84676915585801
        struct[0].Gy[148,158] = -7.89461337514770
        struct[0].Gy[148,159] = 1.58482814504483
        struct[0].Gy[148,160] = -7.72144347466701
        struct[0].Gy[148,161] = 0.679918453285310
        struct[0].Gy[148,162] = -7.89461337514771
        struct[0].Gy[148,163] = 1.58482814504483
        struct[0].Gy[149,140] = -4.84676915585801
        struct[0].Gy[149,141] = 26.5300693004806
        struct[0].Gy[149,142] = -1.58482814504483
        struct[0].Gy[149,143] = -7.89461337514770
        struct[0].Gy[149,144] = -0.679918453285310
        struct[0].Gy[149,145] = -7.72144347466701
        struct[0].Gy[149,146] = -1.58482814504483
        struct[0].Gy[149,147] = -7.89461337514771
        struct[0].Gy[149,148] = 9.69353831171601
        struct[0].Gy[149,149] = -53.0601386009611
        struct[0].Gy[149,150] = 3.16965629008966
        struct[0].Gy[149,151] = 15.7892267502954
        struct[0].Gy[149,152] = 1.35983690657062
        struct[0].Gy[149,153] = 15.4428869493340
        struct[0].Gy[149,154] = 3.16965629008966
        struct[0].Gy[149,155] = 15.7892267502954
        struct[0].Gy[149,156] = -4.84676915585801
        struct[0].Gy[149,157] = 26.5300693004806
        struct[0].Gy[149,158] = -1.58482814504483
        struct[0].Gy[149,159] = -7.89461337514770
        struct[0].Gy[149,160] = -0.679918453285310
        struct[0].Gy[149,161] = -7.72144347466701
        struct[0].Gy[149,162] = -1.58482814504483
        struct[0].Gy[149,163] = -7.89461337514771
        struct[0].Gy[150,140] = -7.89461337514771
        struct[0].Gy[150,141] = 1.58482814504483
        struct[0].Gy[150,142] = 26.5300693004806
        struct[0].Gy[150,143] = 4.84676915585801
        struct[0].Gy[150,144] = -7.89461337514771
        struct[0].Gy[150,145] = 1.58482814504483
        struct[0].Gy[150,146] = -7.72144347466701
        struct[0].Gy[150,147] = 0.679918453285308
        struct[0].Gy[150,148] = 15.7892267502954
        struct[0].Gy[150,149] = -3.16965629008966
        struct[0].Gy[150,150] = -53.0601386009611
        struct[0].Gy[150,151] = -9.69353831171602
        struct[0].Gy[150,152] = 15.7892267502954
        struct[0].Gy[150,153] = -3.16965629008967
        struct[0].Gy[150,154] = 15.4428869493340
        struct[0].Gy[150,155] = -1.35983690657062
        struct[0].Gy[150,156] = -7.89461337514771
        struct[0].Gy[150,157] = 1.58482814504483
        struct[0].Gy[150,158] = 26.5300693004806
        struct[0].Gy[150,159] = 4.84676915585801
        struct[0].Gy[150,160] = -7.89461337514771
        struct[0].Gy[150,161] = 1.58482814504483
        struct[0].Gy[150,162] = -7.72144347466701
        struct[0].Gy[150,163] = 0.679918453285308
        struct[0].Gy[151,140] = -1.58482814504483
        struct[0].Gy[151,141] = -7.89461337514771
        struct[0].Gy[151,142] = -4.84676915585801
        struct[0].Gy[151,143] = 26.5300693004806
        struct[0].Gy[151,144] = -1.58482814504483
        struct[0].Gy[151,145] = -7.89461337514771
        struct[0].Gy[151,146] = -0.679918453285308
        struct[0].Gy[151,147] = -7.72144347466701
        struct[0].Gy[151,148] = 3.16965629008966
        struct[0].Gy[151,149] = 15.7892267502954
        struct[0].Gy[151,150] = 9.69353831171602
        struct[0].Gy[151,151] = -53.0601386009611
        struct[0].Gy[151,152] = 3.16965629008967
        struct[0].Gy[151,153] = 15.7892267502954
        struct[0].Gy[151,154] = 1.35983690657062
        struct[0].Gy[151,155] = 15.4428869493340
        struct[0].Gy[151,156] = -1.58482814504483
        struct[0].Gy[151,157] = -7.89461337514771
        struct[0].Gy[151,158] = -4.84676915585801
        struct[0].Gy[151,159] = 26.5300693004806
        struct[0].Gy[151,160] = -1.58482814504483
        struct[0].Gy[151,161] = -7.89461337514771
        struct[0].Gy[151,162] = -0.679918453285308
        struct[0].Gy[151,163] = -7.72144347466701
        struct[0].Gy[152,140] = -7.72144347466701
        struct[0].Gy[152,141] = 0.679918453285310
        struct[0].Gy[152,142] = -7.89461337514770
        struct[0].Gy[152,143] = 1.58482814504483
        struct[0].Gy[152,144] = 26.5300693004806
        struct[0].Gy[152,145] = 4.84676915585801
        struct[0].Gy[152,146] = -7.89461337514771
        struct[0].Gy[152,147] = 1.58482814504483
        struct[0].Gy[152,148] = 15.4428869493340
        struct[0].Gy[152,149] = -1.35983690657062
        struct[0].Gy[152,150] = 15.7892267502954
        struct[0].Gy[152,151] = -3.16965629008966
        struct[0].Gy[152,152] = -53.0601386009611
        struct[0].Gy[152,153] = -9.69353831171602
        struct[0].Gy[152,154] = 15.7892267502954
        struct[0].Gy[152,155] = -3.16965629008967
        struct[0].Gy[152,156] = -7.72144347466701
        struct[0].Gy[152,157] = 0.679918453285310
        struct[0].Gy[152,158] = -7.89461337514770
        struct[0].Gy[152,159] = 1.58482814504483
        struct[0].Gy[152,160] = 26.5300693004806
        struct[0].Gy[152,161] = 4.84676915585801
        struct[0].Gy[152,162] = -7.89461337514771
        struct[0].Gy[152,163] = 1.58482814504483
        struct[0].Gy[153,140] = -0.679918453285310
        struct[0].Gy[153,141] = -7.72144347466701
        struct[0].Gy[153,142] = -1.58482814504483
        struct[0].Gy[153,143] = -7.89461337514770
        struct[0].Gy[153,144] = -4.84676915585801
        struct[0].Gy[153,145] = 26.5300693004806
        struct[0].Gy[153,146] = -1.58482814504483
        struct[0].Gy[153,147] = -7.89461337514771
        struct[0].Gy[153,148] = 1.35983690657062
        struct[0].Gy[153,149] = 15.4428869493340
        struct[0].Gy[153,150] = 3.16965629008966
        struct[0].Gy[153,151] = 15.7892267502954
        struct[0].Gy[153,152] = 9.69353831171602
        struct[0].Gy[153,153] = -53.0601386009611
        struct[0].Gy[153,154] = 3.16965629008967
        struct[0].Gy[153,155] = 15.7892267502954
        struct[0].Gy[153,156] = -0.679918453285310
        struct[0].Gy[153,157] = -7.72144347466701
        struct[0].Gy[153,158] = -1.58482814504483
        struct[0].Gy[153,159] = -7.89461337514770
        struct[0].Gy[153,160] = -4.84676915585801
        struct[0].Gy[153,161] = 26.5300693004806
        struct[0].Gy[153,162] = -1.58482814504483
        struct[0].Gy[153,163] = -7.89461337514771
        struct[0].Gy[154,140] = -7.89461337514771
        struct[0].Gy[154,141] = 1.58482814504483
        struct[0].Gy[154,142] = -7.72144347466701
        struct[0].Gy[154,143] = 0.679918453285308
        struct[0].Gy[154,144] = -7.89461337514771
        struct[0].Gy[154,145] = 1.58482814504483
        struct[0].Gy[154,146] = 26.5300693004806
        struct[0].Gy[154,147] = 4.84676915585801
        struct[0].Gy[154,148] = 15.7892267502954
        struct[0].Gy[154,149] = -3.16965629008966
        struct[0].Gy[154,150] = 15.4428869493340
        struct[0].Gy[154,151] = -1.35983690657062
        struct[0].Gy[154,152] = 15.7892267502954
        struct[0].Gy[154,153] = -3.16965629008966
        struct[0].Gy[154,154] = -53.0851386009611
        struct[0].Gy[154,155] = -9.69353831171602
        struct[0].Gy[154,156] = -7.89461337514771
        struct[0].Gy[154,157] = 1.58482814504483
        struct[0].Gy[154,158] = -7.72144347466701
        struct[0].Gy[154,159] = 0.679918453285308
        struct[0].Gy[154,160] = -7.89461337514771
        struct[0].Gy[154,161] = 1.58482814504483
        struct[0].Gy[154,162] = 26.5300693004806
        struct[0].Gy[154,163] = 4.84676915585801
        struct[0].Gy[155,140] = -1.58482814504483
        struct[0].Gy[155,141] = -7.89461337514771
        struct[0].Gy[155,142] = -0.679918453285308
        struct[0].Gy[155,143] = -7.72144347466701
        struct[0].Gy[155,144] = -1.58482814504483
        struct[0].Gy[155,145] = -7.89461337514771
        struct[0].Gy[155,146] = -4.84676915585801
        struct[0].Gy[155,147] = 26.5300693004806
        struct[0].Gy[155,148] = 3.16965629008966
        struct[0].Gy[155,149] = 15.7892267502954
        struct[0].Gy[155,150] = 1.35983690657062
        struct[0].Gy[155,151] = 15.4428869493340
        struct[0].Gy[155,152] = 3.16965629008966
        struct[0].Gy[155,153] = 15.7892267502954
        struct[0].Gy[155,154] = 9.69353831171602
        struct[0].Gy[155,155] = -53.0851386009611
        struct[0].Gy[155,156] = -1.58482814504483
        struct[0].Gy[155,157] = -7.89461337514771
        struct[0].Gy[155,158] = -0.679918453285308
        struct[0].Gy[155,159] = -7.72144347466701
        struct[0].Gy[155,160] = -1.58482814504483
        struct[0].Gy[155,161] = -7.89461337514771
        struct[0].Gy[155,162] = -4.84676915585801
        struct[0].Gy[155,163] = 26.5300693004806
        struct[0].Gy[156,16] = 26.5300693004806
        struct[0].Gy[156,17] = 4.84676915585801
        struct[0].Gy[156,18] = -7.89461337514770
        struct[0].Gy[156,19] = 1.58482814504483
        struct[0].Gy[156,20] = -7.72144347466701
        struct[0].Gy[156,21] = 0.679918453285310
        struct[0].Gy[156,22] = -7.89461337514771
        struct[0].Gy[156,23] = 1.58482814504483
        struct[0].Gy[156,148] = 26.5300693004806
        struct[0].Gy[156,149] = 4.84676915585801
        struct[0].Gy[156,150] = -7.89461337514770
        struct[0].Gy[156,151] = 1.58482814504483
        struct[0].Gy[156,152] = -7.72144347466701
        struct[0].Gy[156,153] = 0.679918453285310
        struct[0].Gy[156,154] = -7.89461337514771
        struct[0].Gy[156,155] = 1.58482814504483
        struct[0].Gy[156,156] = -53.0601386009611
        struct[0].Gy[156,157] = -9.69353831171601
        struct[0].Gy[156,158] = 15.7892267502954
        struct[0].Gy[156,159] = -3.16965629008966
        struct[0].Gy[156,160] = 15.4428869493340
        struct[0].Gy[156,161] = -1.35983690657062
        struct[0].Gy[156,162] = 15.7892267502954
        struct[0].Gy[156,163] = -3.16965629008966
        struct[0].Gy[156,423] = 1
        struct[0].Gy[157,16] = -4.84676915585801
        struct[0].Gy[157,17] = 26.5300693004806
        struct[0].Gy[157,18] = -1.58482814504483
        struct[0].Gy[157,19] = -7.89461337514770
        struct[0].Gy[157,20] = -0.679918453285310
        struct[0].Gy[157,21] = -7.72144347466701
        struct[0].Gy[157,22] = -1.58482814504483
        struct[0].Gy[157,23] = -7.89461337514771
        struct[0].Gy[157,148] = -4.84676915585801
        struct[0].Gy[157,149] = 26.5300693004806
        struct[0].Gy[157,150] = -1.58482814504483
        struct[0].Gy[157,151] = -7.89461337514770
        struct[0].Gy[157,152] = -0.679918453285310
        struct[0].Gy[157,153] = -7.72144347466701
        struct[0].Gy[157,154] = -1.58482814504483
        struct[0].Gy[157,155] = -7.89461337514771
        struct[0].Gy[157,156] = 9.69353831171601
        struct[0].Gy[157,157] = -53.0601386009611
        struct[0].Gy[157,158] = 3.16965629008966
        struct[0].Gy[157,159] = 15.7892267502954
        struct[0].Gy[157,160] = 1.35983690657062
        struct[0].Gy[157,161] = 15.4428869493340
        struct[0].Gy[157,162] = 3.16965629008966
        struct[0].Gy[157,163] = 15.7892267502954
        struct[0].Gy[157,424] = 1
        struct[0].Gy[158,16] = -7.89461337514771
        struct[0].Gy[158,17] = 1.58482814504483
        struct[0].Gy[158,18] = 26.5300693004806
        struct[0].Gy[158,19] = 4.84676915585801
        struct[0].Gy[158,20] = -7.89461337514771
        struct[0].Gy[158,21] = 1.58482814504483
        struct[0].Gy[158,22] = -7.72144347466701
        struct[0].Gy[158,23] = 0.679918453285308
        struct[0].Gy[158,148] = -7.89461337514771
        struct[0].Gy[158,149] = 1.58482814504483
        struct[0].Gy[158,150] = 26.5300693004806
        struct[0].Gy[158,151] = 4.84676915585801
        struct[0].Gy[158,152] = -7.89461337514771
        struct[0].Gy[158,153] = 1.58482814504483
        struct[0].Gy[158,154] = -7.72144347466701
        struct[0].Gy[158,155] = 0.679918453285308
        struct[0].Gy[158,156] = 15.7892267502954
        struct[0].Gy[158,157] = -3.16965629008966
        struct[0].Gy[158,158] = -53.0601386009611
        struct[0].Gy[158,159] = -9.69353831171602
        struct[0].Gy[158,160] = 15.7892267502954
        struct[0].Gy[158,161] = -3.16965629008967
        struct[0].Gy[158,162] = 15.4428869493340
        struct[0].Gy[158,163] = -1.35983690657062
        struct[0].Gy[158,425] = 1
        struct[0].Gy[159,16] = -1.58482814504483
        struct[0].Gy[159,17] = -7.89461337514771
        struct[0].Gy[159,18] = -4.84676915585801
        struct[0].Gy[159,19] = 26.5300693004806
        struct[0].Gy[159,20] = -1.58482814504483
        struct[0].Gy[159,21] = -7.89461337514771
        struct[0].Gy[159,22] = -0.679918453285308
        struct[0].Gy[159,23] = -7.72144347466701
        struct[0].Gy[159,148] = -1.58482814504483
        struct[0].Gy[159,149] = -7.89461337514771
        struct[0].Gy[159,150] = -4.84676915585801
        struct[0].Gy[159,151] = 26.5300693004806
        struct[0].Gy[159,152] = -1.58482814504483
        struct[0].Gy[159,153] = -7.89461337514771
        struct[0].Gy[159,154] = -0.679918453285308
        struct[0].Gy[159,155] = -7.72144347466701
        struct[0].Gy[159,156] = 3.16965629008966
        struct[0].Gy[159,157] = 15.7892267502954
        struct[0].Gy[159,158] = 9.69353831171602
        struct[0].Gy[159,159] = -53.0601386009611
        struct[0].Gy[159,160] = 3.16965629008967
        struct[0].Gy[159,161] = 15.7892267502954
        struct[0].Gy[159,162] = 1.35983690657062
        struct[0].Gy[159,163] = 15.4428869493340
        struct[0].Gy[159,426] = 1
        struct[0].Gy[160,16] = -7.72144347466701
        struct[0].Gy[160,17] = 0.679918453285310
        struct[0].Gy[160,18] = -7.89461337514770
        struct[0].Gy[160,19] = 1.58482814504483
        struct[0].Gy[160,20] = 26.5300693004806
        struct[0].Gy[160,21] = 4.84676915585801
        struct[0].Gy[160,22] = -7.89461337514771
        struct[0].Gy[160,23] = 1.58482814504483
        struct[0].Gy[160,148] = -7.72144347466701
        struct[0].Gy[160,149] = 0.679918453285310
        struct[0].Gy[160,150] = -7.89461337514770
        struct[0].Gy[160,151] = 1.58482814504483
        struct[0].Gy[160,152] = 26.5300693004806
        struct[0].Gy[160,153] = 4.84676915585801
        struct[0].Gy[160,154] = -7.89461337514771
        struct[0].Gy[160,155] = 1.58482814504483
        struct[0].Gy[160,156] = 15.4428869493340
        struct[0].Gy[160,157] = -1.35983690657062
        struct[0].Gy[160,158] = 15.7892267502954
        struct[0].Gy[160,159] = -3.16965629008966
        struct[0].Gy[160,160] = -53.0601386009611
        struct[0].Gy[160,161] = -9.69353831171602
        struct[0].Gy[160,162] = 15.7892267502954
        struct[0].Gy[160,163] = -3.16965629008967
        struct[0].Gy[160,427] = 1
        struct[0].Gy[161,16] = -0.679918453285310
        struct[0].Gy[161,17] = -7.72144347466701
        struct[0].Gy[161,18] = -1.58482814504483
        struct[0].Gy[161,19] = -7.89461337514770
        struct[0].Gy[161,20] = -4.84676915585801
        struct[0].Gy[161,21] = 26.5300693004806
        struct[0].Gy[161,22] = -1.58482814504483
        struct[0].Gy[161,23] = -7.89461337514771
        struct[0].Gy[161,148] = -0.679918453285310
        struct[0].Gy[161,149] = -7.72144347466701
        struct[0].Gy[161,150] = -1.58482814504483
        struct[0].Gy[161,151] = -7.89461337514770
        struct[0].Gy[161,152] = -4.84676915585801
        struct[0].Gy[161,153] = 26.5300693004806
        struct[0].Gy[161,154] = -1.58482814504483
        struct[0].Gy[161,155] = -7.89461337514771
        struct[0].Gy[161,156] = 1.35983690657062
        struct[0].Gy[161,157] = 15.4428869493340
        struct[0].Gy[161,158] = 3.16965629008966
        struct[0].Gy[161,159] = 15.7892267502954
        struct[0].Gy[161,160] = 9.69353831171602
        struct[0].Gy[161,161] = -53.0601386009611
        struct[0].Gy[161,162] = 3.16965629008967
        struct[0].Gy[161,163] = 15.7892267502954
        struct[0].Gy[161,428] = 1
        struct[0].Gy[162,16] = -7.89461337514771
        struct[0].Gy[162,17] = 1.58482814504483
        struct[0].Gy[162,18] = -7.72144347466701
        struct[0].Gy[162,19] = 0.679918453285308
        struct[0].Gy[162,20] = -7.89461337514771
        struct[0].Gy[162,21] = 1.58482814504483
        struct[0].Gy[162,22] = 26.5300693004806
        struct[0].Gy[162,23] = 4.84676915585801
        struct[0].Gy[162,148] = -7.89461337514771
        struct[0].Gy[162,149] = 1.58482814504483
        struct[0].Gy[162,150] = -7.72144347466701
        struct[0].Gy[162,151] = 0.679918453285308
        struct[0].Gy[162,152] = -7.89461337514771
        struct[0].Gy[162,153] = 1.58482814504483
        struct[0].Gy[162,154] = 26.5300693004806
        struct[0].Gy[162,155] = 4.84676915585801
        struct[0].Gy[162,156] = 15.7892267502954
        struct[0].Gy[162,157] = -3.16965629008966
        struct[0].Gy[162,158] = 15.4428869493340
        struct[0].Gy[162,159] = -1.35983690657062
        struct[0].Gy[162,160] = 15.7892267502954
        struct[0].Gy[162,161] = -3.16965629008966
        struct[0].Gy[162,162] = -53.0601386009611
        struct[0].Gy[162,163] = -9.69353831171602
        struct[0].Gy[163,16] = -1.58482814504483
        struct[0].Gy[163,17] = -7.89461337514771
        struct[0].Gy[163,18] = -0.679918453285308
        struct[0].Gy[163,19] = -7.72144347466701
        struct[0].Gy[163,20] = -1.58482814504483
        struct[0].Gy[163,21] = -7.89461337514771
        struct[0].Gy[163,22] = -4.84676915585801
        struct[0].Gy[163,23] = 26.5300693004806
        struct[0].Gy[163,148] = -1.58482814504483
        struct[0].Gy[163,149] = -7.89461337514771
        struct[0].Gy[163,150] = -0.679918453285308
        struct[0].Gy[163,151] = -7.72144347466701
        struct[0].Gy[163,152] = -1.58482814504483
        struct[0].Gy[163,153] = -7.89461337514771
        struct[0].Gy[163,154] = -4.84676915585801
        struct[0].Gy[163,155] = 26.5300693004806
        struct[0].Gy[163,156] = 3.16965629008966
        struct[0].Gy[163,157] = 15.7892267502954
        struct[0].Gy[163,158] = 1.35983690657062
        struct[0].Gy[163,159] = 15.4428869493340
        struct[0].Gy[163,160] = 3.16965629008966
        struct[0].Gy[163,161] = 15.7892267502954
        struct[0].Gy[163,162] = 9.69353831171602
        struct[0].Gy[163,163] = -53.0601386009611
        struct[0].Gy[164,164] = -1067.70480704130
        struct[0].Gy[164,172] = 67.7048070412999
        struct[0].Gy[165,165] = -1067.70480704130
        struct[0].Gy[165,173] = 67.7048070412999
        struct[0].Gy[166,52] = 157.977883096366
        struct[0].Gy[166,166] = -361.092304220266
        struct[0].Gy[166,174] = 135.409614082600
        struct[0].Gy[167,53] = 157.977883096366
        struct[0].Gy[167,167] = -361.092304220266
        struct[0].Gy[167,175] = 135.409614082600
        struct[0].Gy[168,168] = -361.092304220266
        struct[0].Gy[168,176] = 135.409614082600
        struct[0].Gy[168,206] = 157.977883096366
        struct[0].Gy[169,169] = -361.092304220266
        struct[0].Gy[169,177] = 135.409614082600
        struct[0].Gy[169,207] = 157.977883096366
        struct[0].Gy[170,170] = -361.092304220266
        struct[0].Gy[170,178] = 135.409614082600
        struct[0].Gy[170,208] = 157.977883096366
        struct[0].Gy[171,171] = -361.092304220266
        struct[0].Gy[171,179] = 135.409614082600
        struct[0].Gy[171,209] = 157.977883096366
        struct[0].Gy[172,54] = 157.977883096366
        struct[0].Gy[172,164] = 67.7048070412999
        struct[0].Gy[172,172] = -361.092304220266
        struct[0].Gy[172,180] = 135.409614082600
        struct[0].Gy[173,55] = 157.977883096366
        struct[0].Gy[173,165] = 67.7048070412999
        struct[0].Gy[173,173] = -361.092304220266
        struct[0].Gy[173,181] = 135.409614082600
        struct[0].Gy[174,166] = 135.409614082600
        struct[0].Gy[174,174] = -248.250959151433
        struct[0].Gy[174,182] = 67.7048070412999
        struct[0].Gy[174,222] = 45.1365380275333
        struct[0].Gy[175,167] = 135.409614082600
        struct[0].Gy[175,175] = -248.250959151433
        struct[0].Gy[175,183] = 67.7048070412999
        struct[0].Gy[175,223] = 45.1365380275333
        struct[0].Gy[176,168] = 135.409614082600
        struct[0].Gy[176,176] = -248.250959151433
        struct[0].Gy[176,184] = 67.7048070412999
        struct[0].Gy[176,224] = 45.1365380275333
        struct[0].Gy[177,169] = 135.409614082600
        struct[0].Gy[177,177] = -248.250959151433
        struct[0].Gy[177,185] = 67.7048070412999
        struct[0].Gy[177,225] = 45.1365380275333
        struct[0].Gy[178,170] = 135.409614082600
        struct[0].Gy[178,178] = -248.250959151433
        struct[0].Gy[178,186] = 67.7048070412999
        struct[0].Gy[178,226] = 45.1365380275333
        struct[0].Gy[179,171] = 135.409614082600
        struct[0].Gy[179,179] = -248.250959151433
        struct[0].Gy[179,187] = 67.7048070412999
        struct[0].Gy[179,227] = 45.1365380275333
        struct[0].Gy[180,172] = 135.409614082600
        struct[0].Gy[180,180] = -248.250959151433
        struct[0].Gy[180,188] = 67.7048070412999
        struct[0].Gy[180,228] = 45.1365380275333
        struct[0].Gy[181,173] = 135.409614082600
        struct[0].Gy[181,181] = -248.250959151433
        struct[0].Gy[181,189] = 67.7048070412999
        struct[0].Gy[181,229] = 45.1365380275333
        struct[0].Gy[182,56] = 157.977883096366
        struct[0].Gy[182,174] = 67.7048070412999
        struct[0].Gy[182,182] = -270.819228165200
        struct[0].Gy[182,190] = 45.1365380275333
        struct[0].Gy[183,57] = 157.977883096366
        struct[0].Gy[183,175] = 67.7048070412999
        struct[0].Gy[183,183] = -270.819228165200
        struct[0].Gy[183,191] = 45.1365380275333
        struct[0].Gy[184,176] = 67.7048070412999
        struct[0].Gy[184,184] = -270.819228165200
        struct[0].Gy[184,192] = 45.1365380275333
        struct[0].Gy[184,210] = 157.977883096366
        struct[0].Gy[185,177] = 67.7048070412999
        struct[0].Gy[185,185] = -270.819228165200
        struct[0].Gy[185,193] = 45.1365380275333
        struct[0].Gy[185,211] = 157.977883096366
        struct[0].Gy[186,178] = 67.7048070412999
        struct[0].Gy[186,186] = -270.819228165200
        struct[0].Gy[186,194] = 45.1365380275333
        struct[0].Gy[186,212] = 157.977883096366
        struct[0].Gy[187,179] = 67.7048070412999
        struct[0].Gy[187,187] = -270.819228165200
        struct[0].Gy[187,195] = 45.1365380275333
        struct[0].Gy[187,213] = 157.977883096366
        struct[0].Gy[188,58] = 157.977883096366
        struct[0].Gy[188,180] = 67.7048070412999
        struct[0].Gy[188,188] = -270.819228165200
        struct[0].Gy[188,196] = 45.1365380275333
        struct[0].Gy[189,59] = 157.977883096366
        struct[0].Gy[189,181] = 67.7048070412999
        struct[0].Gy[189,189] = -270.819228165200
        struct[0].Gy[189,197] = 45.1365380275333
        struct[0].Gy[190,60] = 157.977883096366
        struct[0].Gy[190,182] = 45.1365380275333
        struct[0].Gy[190,190] = -361.092304220266
        struct[0].Gy[190,198] = 157.977883096366
        struct[0].Gy[191,61] = 157.977883096366
        struct[0].Gy[191,183] = 45.1365380275333
        struct[0].Gy[191,191] = -361.092304220266
        struct[0].Gy[191,199] = 157.977883096366
        struct[0].Gy[192,184] = 45.1365380275333
        struct[0].Gy[192,192] = -361.092304220266
        struct[0].Gy[192,200] = 157.977883096366
        struct[0].Gy[192,214] = 157.977883096366
        struct[0].Gy[193,185] = 45.1365380275333
        struct[0].Gy[193,193] = -361.092304220266
        struct[0].Gy[193,201] = 157.977883096366
        struct[0].Gy[193,215] = 157.977883096366
        struct[0].Gy[194,186] = 45.1365380275333
        struct[0].Gy[194,194] = -361.092304220266
        struct[0].Gy[194,202] = 157.977883096366
        struct[0].Gy[194,216] = 157.977883096366
        struct[0].Gy[195,187] = 45.1365380275333
        struct[0].Gy[195,195] = -361.092304220266
        struct[0].Gy[195,203] = 157.977883096366
        struct[0].Gy[195,217] = 157.977883096366
        struct[0].Gy[196,62] = 157.977883096366
        struct[0].Gy[196,188] = 45.1365380275333
        struct[0].Gy[196,196] = -361.092304220266
        struct[0].Gy[196,204] = 157.977883096366
        struct[0].Gy[197,63] = 157.977883096366
        struct[0].Gy[197,189] = 45.1365380275333
        struct[0].Gy[197,197] = -361.092304220266
        struct[0].Gy[197,205] = 157.977883096366
        struct[0].Gy[198,64] = 157.977883096366
        struct[0].Gy[198,190] = 157.977883096366
        struct[0].Gy[198,198] = -315.955766192733
        struct[0].Gy[198,419] = 1
        struct[0].Gy[199,65] = 157.977883096366
        struct[0].Gy[199,191] = 157.977883096366
        struct[0].Gy[199,199] = -315.955766192733
        struct[0].Gy[200,192] = 157.977883096366
        struct[0].Gy[200,200] = -315.955766192733
        struct[0].Gy[200,218] = 157.977883096366
        struct[0].Gy[201,193] = 157.977883096366
        struct[0].Gy[201,201] = -315.955766192733
        struct[0].Gy[201,219] = 157.977883096366
        struct[0].Gy[202,194] = 157.977883096366
        struct[0].Gy[202,202] = -315.955766192733
        struct[0].Gy[202,220] = 157.977883096366
        struct[0].Gy[203,195] = 157.977883096366
        struct[0].Gy[203,203] = -315.955766192733
        struct[0].Gy[203,221] = 157.977883096366
        struct[0].Gy[204,66] = 157.977883096366
        struct[0].Gy[204,196] = 157.977883096366
        struct[0].Gy[204,204] = -315.955766192733
        struct[0].Gy[204,420] = 1
        struct[0].Gy[205,67] = 157.977883096366
        struct[0].Gy[205,197] = 157.977883096366
        struct[0].Gy[205,205] = -315.955766192733
        struct[0].Gy[206,168] = 157.977883096366
        struct[0].Gy[206,206] = -157.977883096366
        struct[0].Gy[207,169] = 157.977883096366
        struct[0].Gy[207,207] = -157.977883096366
        struct[0].Gy[208,170] = 157.977883096366
        struct[0].Gy[208,208] = -157.977883096366
        struct[0].Gy[209,171] = 157.977883096366
        struct[0].Gy[209,209] = -157.977883096366
        struct[0].Gy[210,184] = 157.977883096366
        struct[0].Gy[210,210] = -157.977883096366
        struct[0].Gy[211,185] = 157.977883096366
        struct[0].Gy[211,211] = -157.977883096366
        struct[0].Gy[212,186] = 157.977883096366
        struct[0].Gy[212,212] = -157.977883096366
        struct[0].Gy[213,187] = 157.977883096366
        struct[0].Gy[213,213] = -157.977883096366
        struct[0].Gy[214,192] = 157.977883096366
        struct[0].Gy[214,214] = -157.977883096366
        struct[0].Gy[215,193] = 157.977883096366
        struct[0].Gy[215,215] = -157.977883096366
        struct[0].Gy[216,194] = 157.977883096366
        struct[0].Gy[216,216] = -157.977883096366
        struct[0].Gy[217,195] = 157.977883096366
        struct[0].Gy[217,217] = -157.977883096366
        struct[0].Gy[218,200] = 157.977883096366
        struct[0].Gy[218,218] = -157.977883096366
        struct[0].Gy[219,201] = 157.977883096366
        struct[0].Gy[219,219] = -157.977883096366
        struct[0].Gy[220,202] = 157.977883096366
        struct[0].Gy[220,220] = -157.977883096366
        struct[0].Gy[221,203] = 157.977883096366
        struct[0].Gy[221,221] = -157.977883096366
        struct[0].Gy[222,48] = 135.409614082600
        struct[0].Gy[222,174] = 45.1365380275333
        struct[0].Gy[222,222] = -180.546152110133
        struct[0].Gy[222,429] = 1
        struct[0].Gy[223,49] = 135.409614082600
        struct[0].Gy[223,175] = 45.1365380275333
        struct[0].Gy[223,223] = -180.546152110133
        struct[0].Gy[224,176] = 45.1365380275333
        struct[0].Gy[224,224] = -180.546152110133
        struct[0].Gy[224,230] = 135.409614082600
        struct[0].Gy[225,177] = 45.1365380275333
        struct[0].Gy[225,225] = -180.546152110133
        struct[0].Gy[225,231] = 135.409614082600
        struct[0].Gy[226,178] = 45.1365380275333
        struct[0].Gy[226,226] = -180.546152110133
        struct[0].Gy[226,232] = 135.409614082600
        struct[0].Gy[227,179] = 45.1365380275333
        struct[0].Gy[227,227] = -180.546152110133
        struct[0].Gy[227,233] = 135.409614082600
        struct[0].Gy[228,50] = 135.409614082600
        struct[0].Gy[228,180] = 45.1365380275333
        struct[0].Gy[228,228] = -180.546152110133
        struct[0].Gy[228,430] = 1
        struct[0].Gy[229,51] = 135.409614082600
        struct[0].Gy[229,181] = 45.1365380275333
        struct[0].Gy[229,229] = -180.546152110133
        struct[0].Gy[230,224] = 135.409614082600
        struct[0].Gy[230,230] = -135.409614082600
        struct[0].Gy[231,225] = 135.409614082600
        struct[0].Gy[231,231] = -135.409614082600
        struct[0].Gy[232,226] = 135.409614082600
        struct[0].Gy[232,232] = -135.409614082600
        struct[0].Gy[233,227] = 135.409614082600
        struct[0].Gy[233,233] = -135.409614082600
        struct[0].Gy[234,0] = -0.212261128378539
        struct[0].Gy[234,1] = -0.849044513514155
        struct[0].Gy[234,2] = 0.212261128378539
        struct[0].Gy[234,3] = 0.849044513514155
        struct[0].Gy[234,234] = -1
        struct[0].Gy[235,0] = 0.849044513514155
        struct[0].Gy[235,1] = -0.212261128378539
        struct[0].Gy[235,2] = -0.849044513514155
        struct[0].Gy[235,3] = 0.212261128378539
        struct[0].Gy[235,235] = -1
        struct[0].Gy[236,2] = -0.212261128378539
        struct[0].Gy[236,3] = -0.849044513514155
        struct[0].Gy[236,4] = 0.212261128378539
        struct[0].Gy[236,5] = 0.849044513514155
        struct[0].Gy[236,236] = -1
        struct[0].Gy[237,2] = 0.849044513514155
        struct[0].Gy[237,3] = -0.212261128378539
        struct[0].Gy[237,4] = -0.849044513514155
        struct[0].Gy[237,5] = 0.212261128378539
        struct[0].Gy[237,237] = -1
        struct[0].Gy[238,0] = 0.212261128378539
        struct[0].Gy[238,1] = 0.849044513514155
        struct[0].Gy[238,4] = -0.212261128378539
        struct[0].Gy[238,5] = -0.849044513514155
        struct[0].Gy[238,238] = -1
        struct[0].Gy[239,0] = -0.849044513514155
        struct[0].Gy[239,1] = 0.212261128378539
        struct[0].Gy[239,4] = 0.849044513514155
        struct[0].Gy[239,5] = -0.212261128378539
        struct[0].Gy[239,239] = -1
        struct[0].Gy[240,0] = 105.571769313180
        struct[0].Gy[240,1] = 54.0657727682604
        struct[0].Gy[240,2] = -39.6392229058202
        struct[0].Gy[240,3] = -10.2713736253513
        struct[0].Gy[240,4] = -24.9575997948692
        struct[0].Gy[240,5] = -23.2849644809540
        struct[0].Gy[240,6] = -39.6392229058202
        struct[0].Gy[240,7] = -10.2713736253513
        struct[0].Gy[240,68] = -105.571769313180
        struct[0].Gy[240,69] = -54.0657727682604
        struct[0].Gy[240,70] = 39.6392229058202
        struct[0].Gy[240,71] = 10.2713736253513
        struct[0].Gy[240,72] = 24.9575997948692
        struct[0].Gy[240,73] = 23.2849644809540
        struct[0].Gy[240,74] = 39.6392229058202
        struct[0].Gy[240,75] = 10.2713736253513
        struct[0].Gy[240,240] = -1
        struct[0].Gy[241,0] = -54.0657727682604
        struct[0].Gy[241,1] = 105.571769313180
        struct[0].Gy[241,2] = 10.2713736253513
        struct[0].Gy[241,3] = -39.6392229058202
        struct[0].Gy[241,4] = 23.2849644809540
        struct[0].Gy[241,5] = -24.9575997948692
        struct[0].Gy[241,6] = 10.2713736253513
        struct[0].Gy[241,7] = -39.6392229058202
        struct[0].Gy[241,68] = 54.0657727682604
        struct[0].Gy[241,69] = -105.571769313180
        struct[0].Gy[241,70] = -10.2713736253513
        struct[0].Gy[241,71] = 39.6392229058202
        struct[0].Gy[241,72] = -23.2849644809540
        struct[0].Gy[241,73] = 24.9575997948692
        struct[0].Gy[241,74] = -10.2713736253513
        struct[0].Gy[241,75] = 39.6392229058202
        struct[0].Gy[241,241] = -1
        struct[0].Gy[242,0] = -39.6392229058202
        struct[0].Gy[242,1] = -10.2713736253513
        struct[0].Gy[242,2] = 105.571769313180
        struct[0].Gy[242,3] = 54.0657727682604
        struct[0].Gy[242,4] = -39.6392229058201
        struct[0].Gy[242,5] = -10.2713736253513
        struct[0].Gy[242,6] = -24.9575997948692
        struct[0].Gy[242,7] = -23.2849644809540
        struct[0].Gy[242,68] = 39.6392229058202
        struct[0].Gy[242,69] = 10.2713736253513
        struct[0].Gy[242,70] = -105.571769313180
        struct[0].Gy[242,71] = -54.0657727682604
        struct[0].Gy[242,72] = 39.6392229058201
        struct[0].Gy[242,73] = 10.2713736253513
        struct[0].Gy[242,74] = 24.9575997948692
        struct[0].Gy[242,75] = 23.2849644809540
        struct[0].Gy[242,242] = -1
        struct[0].Gy[243,0] = 10.2713736253513
        struct[0].Gy[243,1] = -39.6392229058202
        struct[0].Gy[243,2] = -54.0657727682604
        struct[0].Gy[243,3] = 105.571769313180
        struct[0].Gy[243,4] = 10.2713736253513
        struct[0].Gy[243,5] = -39.6392229058201
        struct[0].Gy[243,6] = 23.2849644809540
        struct[0].Gy[243,7] = -24.9575997948692
        struct[0].Gy[243,68] = -10.2713736253513
        struct[0].Gy[243,69] = 39.6392229058202
        struct[0].Gy[243,70] = 54.0657727682604
        struct[0].Gy[243,71] = -105.571769313180
        struct[0].Gy[243,72] = -10.2713736253513
        struct[0].Gy[243,73] = 39.6392229058201
        struct[0].Gy[243,74] = -23.2849644809540
        struct[0].Gy[243,75] = 24.9575997948692
        struct[0].Gy[243,243] = -1
        struct[0].Gy[244,0] = -24.9575997948692
        struct[0].Gy[244,1] = -23.2849644809540
        struct[0].Gy[244,2] = -39.6392229058202
        struct[0].Gy[244,3] = -10.2713736253513
        struct[0].Gy[244,4] = 105.571769313180
        struct[0].Gy[244,5] = 54.0657727682604
        struct[0].Gy[244,6] = -39.6392229058201
        struct[0].Gy[244,7] = -10.2713736253514
        struct[0].Gy[244,68] = 24.9575997948692
        struct[0].Gy[244,69] = 23.2849644809540
        struct[0].Gy[244,70] = 39.6392229058202
        struct[0].Gy[244,71] = 10.2713736253513
        struct[0].Gy[244,72] = -105.571769313180
        struct[0].Gy[244,73] = -54.0657727682604
        struct[0].Gy[244,74] = 39.6392229058201
        struct[0].Gy[244,75] = 10.2713736253514
        struct[0].Gy[244,244] = -1
        struct[0].Gy[245,0] = 23.2849644809540
        struct[0].Gy[245,1] = -24.9575997948692
        struct[0].Gy[245,2] = 10.2713736253513
        struct[0].Gy[245,3] = -39.6392229058202
        struct[0].Gy[245,4] = -54.0657727682604
        struct[0].Gy[245,5] = 105.571769313180
        struct[0].Gy[245,6] = 10.2713736253514
        struct[0].Gy[245,7] = -39.6392229058201
        struct[0].Gy[245,68] = -23.2849644809540
        struct[0].Gy[245,69] = 24.9575997948692
        struct[0].Gy[245,70] = -10.2713736253513
        struct[0].Gy[245,71] = 39.6392229058202
        struct[0].Gy[245,72] = 54.0657727682604
        struct[0].Gy[245,73] = -105.571769313180
        struct[0].Gy[245,74] = -10.2713736253514
        struct[0].Gy[245,75] = 39.6392229058201
        struct[0].Gy[245,245] = -1
        struct[0].Gy[246,240] = 1
        struct[0].Gy[246,242] = 1
        struct[0].Gy[246,244] = 1
        struct[0].Gy[246,246] = -1
        struct[0].Gy[247,241] = 1
        struct[0].Gy[247,243] = 1
        struct[0].Gy[247,245] = 1
        struct[0].Gy[247,247] = -1
        struct[0].Gy[248,166] = -67.7048070412999
        struct[0].Gy[248,248] = -1
        struct[0].Gy[249,167] = -67.7048070412999
        struct[0].Gy[249,249] = -1
        struct[0].Gy[250,168] = -67.7048070412999
        struct[0].Gy[250,250] = -1
        struct[0].Gy[251,169] = -67.7048070412999
        struct[0].Gy[251,251] = -1
        struct[0].Gy[252,170] = -67.7048070412999
        struct[0].Gy[252,252] = -1
        struct[0].Gy[253,171] = -67.7048070412999
        struct[0].Gy[253,253] = -1
        struct[0].Gy[254,248] = 1
        struct[0].Gy[254,250] = 1
        struct[0].Gy[254,252] = 1
        struct[0].Gy[254,254] = -1
        struct[0].Gy[255,249] = 1
        struct[0].Gy[255,251] = 1
        struct[0].Gy[255,253] = 1
        struct[0].Gy[255,255] = -1
        struct[0].Gy[256,166] = 135.409614082600
        struct[0].Gy[256,174] = -135.409614082600
        struct[0].Gy[256,256] = -1
        struct[0].Gy[257,167] = 135.409614082600
        struct[0].Gy[257,175] = -135.409614082600
        struct[0].Gy[257,257] = -1
        struct[0].Gy[258,168] = 135.409614082600
        struct[0].Gy[258,176] = -135.409614082600
        struct[0].Gy[258,258] = -1
        struct[0].Gy[259,169] = 135.409614082600
        struct[0].Gy[259,177] = -135.409614082600
        struct[0].Gy[259,259] = -1
        struct[0].Gy[260,170] = 135.409614082600
        struct[0].Gy[260,178] = -135.409614082600
        struct[0].Gy[260,260] = -1
        struct[0].Gy[261,171] = 135.409614082600
        struct[0].Gy[261,179] = -135.409614082600
        struct[0].Gy[261,261] = -1
        struct[0].Gy[262,256] = 1
        struct[0].Gy[262,258] = 1
        struct[0].Gy[262,260] = 1
        struct[0].Gy[262,262] = -1
        struct[0].Gy[263,257] = 1
        struct[0].Gy[263,259] = 1
        struct[0].Gy[263,261] = 1
        struct[0].Gy[263,263] = -1
        struct[0].Gy[264,174] = 67.7048070412999
        struct[0].Gy[264,182] = -67.7048070412999
        struct[0].Gy[264,264] = -1
        struct[0].Gy[265,175] = 67.7048070412999
        struct[0].Gy[265,183] = -67.7048070412999
        struct[0].Gy[265,265] = -1
        struct[0].Gy[266,176] = 67.7048070412999
        struct[0].Gy[266,184] = -67.7048070412999
        struct[0].Gy[266,266] = -1
        struct[0].Gy[267,177] = 67.7048070412999
        struct[0].Gy[267,185] = -67.7048070412999
        struct[0].Gy[267,267] = -1
        struct[0].Gy[268,178] = 67.7048070412999
        struct[0].Gy[268,186] = -67.7048070412999
        struct[0].Gy[268,268] = -1
        struct[0].Gy[269,179] = 67.7048070412999
        struct[0].Gy[269,187] = -67.7048070412999
        struct[0].Gy[269,269] = -1
        struct[0].Gy[270,264] = 1
        struct[0].Gy[270,266] = 1
        struct[0].Gy[270,268] = 1
        struct[0].Gy[270,270] = -1
        struct[0].Gy[271,265] = 1
        struct[0].Gy[271,267] = 1
        struct[0].Gy[271,269] = 1
        struct[0].Gy[271,271] = -1
        struct[0].Gy[272,182] = 45.1365380275333
        struct[0].Gy[272,190] = -45.1365380275333
        struct[0].Gy[272,272] = -1
        struct[0].Gy[273,183] = 45.1365380275333
        struct[0].Gy[273,191] = -45.1365380275333
        struct[0].Gy[273,273] = -1
        struct[0].Gy[274,184] = 45.1365380275333
        struct[0].Gy[274,192] = -45.1365380275333
        struct[0].Gy[274,274] = -1
        struct[0].Gy[275,185] = 45.1365380275333
        struct[0].Gy[275,193] = -45.1365380275333
        struct[0].Gy[275,275] = -1
        struct[0].Gy[276,186] = 45.1365380275333
        struct[0].Gy[276,194] = -45.1365380275333
        struct[0].Gy[276,276] = -1
        struct[0].Gy[277,187] = 45.1365380275333
        struct[0].Gy[277,195] = -45.1365380275333
        struct[0].Gy[277,277] = -1
        struct[0].Gy[278,272] = 1
        struct[0].Gy[278,274] = 1
        struct[0].Gy[278,276] = 1
        struct[0].Gy[278,278] = -1
        struct[0].Gy[279,273] = 1
        struct[0].Gy[279,275] = 1
        struct[0].Gy[279,277] = 1
        struct[0].Gy[279,279] = -1
        struct[0].Gy[280,190] = 157.977883096366
        struct[0].Gy[280,198] = -157.977883096366
        struct[0].Gy[280,280] = -1
        struct[0].Gy[281,191] = 157.977883096366
        struct[0].Gy[281,199] = -157.977883096366
        struct[0].Gy[281,281] = -1
        struct[0].Gy[282,192] = 157.977883096366
        struct[0].Gy[282,200] = -157.977883096366
        struct[0].Gy[282,282] = -1
        struct[0].Gy[283,193] = 157.977883096366
        struct[0].Gy[283,201] = -157.977883096366
        struct[0].Gy[283,283] = -1
        struct[0].Gy[284,194] = 157.977883096366
        struct[0].Gy[284,202] = -157.977883096366
        struct[0].Gy[284,284] = -1
        struct[0].Gy[285,195] = 157.977883096366
        struct[0].Gy[285,203] = -157.977883096366
        struct[0].Gy[285,285] = -1
        struct[0].Gy[286,280] = 1
        struct[0].Gy[286,282] = 1
        struct[0].Gy[286,284] = 1
        struct[0].Gy[286,286] = -1
        struct[0].Gy[287,281] = 1
        struct[0].Gy[287,283] = 1
        struct[0].Gy[287,285] = 1
        struct[0].Gy[287,287] = -1
        struct[0].Gy[288,52] = -157.977883096366
        struct[0].Gy[288,166] = 157.977883096366
        struct[0].Gy[288,288] = -1
        struct[0].Gy[289,53] = -157.977883096366
        struct[0].Gy[289,167] = 157.977883096366
        struct[0].Gy[289,289] = -1
        struct[0].Gy[290,168] = 157.977883096366
        struct[0].Gy[290,206] = -157.977883096366
        struct[0].Gy[290,290] = -1
        struct[0].Gy[291,169] = 157.977883096366
        struct[0].Gy[291,207] = -157.977883096366
        struct[0].Gy[291,291] = -1
        struct[0].Gy[292,170] = 157.977883096366
        struct[0].Gy[292,208] = -157.977883096366
        struct[0].Gy[292,292] = -1
        struct[0].Gy[293,171] = 157.977883096366
        struct[0].Gy[293,209] = -157.977883096366
        struct[0].Gy[293,293] = -1
        struct[0].Gy[294,288] = 1
        struct[0].Gy[294,290] = 1
        struct[0].Gy[294,292] = 1
        struct[0].Gy[294,294] = -1
        struct[0].Gy[295,289] = 1
        struct[0].Gy[295,291] = 1
        struct[0].Gy[295,293] = 1
        struct[0].Gy[295,295] = -1
        struct[0].Gy[296,56] = -157.977883096366
        struct[0].Gy[296,182] = 157.977883096366
        struct[0].Gy[296,296] = -1
        struct[0].Gy[297,57] = -157.977883096366
        struct[0].Gy[297,183] = 157.977883096366
        struct[0].Gy[297,297] = -1
        struct[0].Gy[298,184] = 157.977883096366
        struct[0].Gy[298,210] = -157.977883096366
        struct[0].Gy[298,298] = -1
        struct[0].Gy[299,185] = 157.977883096366
        struct[0].Gy[299,211] = -157.977883096366
        struct[0].Gy[299,299] = -1
        struct[0].Gy[300,186] = 157.977883096366
        struct[0].Gy[300,212] = -157.977883096366
        struct[0].Gy[300,300] = -1
        struct[0].Gy[301,187] = 157.977883096366
        struct[0].Gy[301,213] = -157.977883096366
        struct[0].Gy[301,301] = -1
        struct[0].Gy[302,296] = 1
        struct[0].Gy[302,298] = 1
        struct[0].Gy[302,300] = 1
        struct[0].Gy[302,302] = -1
        struct[0].Gy[303,297] = 1
        struct[0].Gy[303,299] = 1
        struct[0].Gy[303,301] = 1
        struct[0].Gy[303,303] = -1
        struct[0].Gy[304,60] = -157.977883096366
        struct[0].Gy[304,190] = 157.977883096366
        struct[0].Gy[304,304] = -1
        struct[0].Gy[305,61] = -157.977883096366
        struct[0].Gy[305,191] = 157.977883096366
        struct[0].Gy[305,305] = -1
        struct[0].Gy[306,192] = 157.977883096366
        struct[0].Gy[306,214] = -157.977883096366
        struct[0].Gy[306,306] = -1
        struct[0].Gy[307,193] = 157.977883096366
        struct[0].Gy[307,215] = -157.977883096366
        struct[0].Gy[307,307] = -1
        struct[0].Gy[308,194] = 157.977883096366
        struct[0].Gy[308,216] = -157.977883096366
        struct[0].Gy[308,308] = -1
        struct[0].Gy[309,195] = 157.977883096366
        struct[0].Gy[309,217] = -157.977883096366
        struct[0].Gy[309,309] = -1
        struct[0].Gy[310,304] = 1
        struct[0].Gy[310,306] = 1
        struct[0].Gy[310,308] = 1
        struct[0].Gy[310,310] = -1
        struct[0].Gy[311,305] = 1
        struct[0].Gy[311,307] = 1
        struct[0].Gy[311,309] = 1
        struct[0].Gy[311,311] = -1
        struct[0].Gy[312,64] = -157.977883096366
        struct[0].Gy[312,198] = 157.977883096366
        struct[0].Gy[312,312] = -1
        struct[0].Gy[313,65] = -157.977883096366
        struct[0].Gy[313,199] = 157.977883096366
        struct[0].Gy[313,313] = -1
        struct[0].Gy[314,200] = 157.977883096366
        struct[0].Gy[314,218] = -157.977883096366
        struct[0].Gy[314,314] = -1
        struct[0].Gy[315,201] = 157.977883096366
        struct[0].Gy[315,219] = -157.977883096366
        struct[0].Gy[315,315] = -1
        struct[0].Gy[316,202] = 157.977883096366
        struct[0].Gy[316,220] = -157.977883096366
        struct[0].Gy[316,316] = -1
        struct[0].Gy[317,203] = 157.977883096366
        struct[0].Gy[317,221] = -157.977883096366
        struct[0].Gy[317,317] = -1
        struct[0].Gy[318,312] = 1
        struct[0].Gy[318,314] = 1
        struct[0].Gy[318,316] = 1
        struct[0].Gy[318,318] = -1
        struct[0].Gy[319,313] = 1
        struct[0].Gy[319,315] = 1
        struct[0].Gy[319,317] = 1
        struct[0].Gy[319,319] = -1
        struct[0].Gy[320,174] = 45.1365380275333
        struct[0].Gy[320,222] = -45.1365380275333
        struct[0].Gy[320,320] = -1
        struct[0].Gy[321,175] = 45.1365380275333
        struct[0].Gy[321,223] = -45.1365380275333
        struct[0].Gy[321,321] = -1
        struct[0].Gy[322,176] = 45.1365380275333
        struct[0].Gy[322,224] = -45.1365380275333
        struct[0].Gy[322,322] = -1
        struct[0].Gy[323,177] = 45.1365380275333
        struct[0].Gy[323,225] = -45.1365380275333
        struct[0].Gy[323,323] = -1
        struct[0].Gy[324,178] = 45.1365380275333
        struct[0].Gy[324,226] = -45.1365380275333
        struct[0].Gy[324,324] = -1
        struct[0].Gy[325,179] = 45.1365380275333
        struct[0].Gy[325,227] = -45.1365380275333
        struct[0].Gy[325,325] = -1
        struct[0].Gy[326,320] = 1
        struct[0].Gy[326,322] = 1
        struct[0].Gy[326,324] = 1
        struct[0].Gy[326,326] = -1
        struct[0].Gy[327,321] = 1
        struct[0].Gy[327,323] = 1
        struct[0].Gy[327,325] = 1
        struct[0].Gy[327,327] = -1
        struct[0].Gy[328,48] = -135.409614082600
        struct[0].Gy[328,222] = 135.409614082600
        struct[0].Gy[328,328] = -1
        struct[0].Gy[329,49] = -135.409614082600
        struct[0].Gy[329,223] = 135.409614082600
        struct[0].Gy[329,329] = -1
        struct[0].Gy[330,224] = 135.409614082600
        struct[0].Gy[330,230] = -135.409614082600
        struct[0].Gy[330,330] = -1
        struct[0].Gy[331,225] = 135.409614082600
        struct[0].Gy[331,231] = -135.409614082600
        struct[0].Gy[331,331] = -1
        struct[0].Gy[332,226] = 135.409614082600
        struct[0].Gy[332,232] = -135.409614082600
        struct[0].Gy[332,332] = -1
        struct[0].Gy[333,227] = 135.409614082600
        struct[0].Gy[333,233] = -135.409614082600
        struct[0].Gy[333,333] = -1
        struct[0].Gy[334,328] = 1
        struct[0].Gy[334,330] = 1
        struct[0].Gy[334,332] = 1
        struct[0].Gy[334,334] = -1
        struct[0].Gy[335,329] = 1
        struct[0].Gy[335,331] = 1
        struct[0].Gy[335,333] = 1
        struct[0].Gy[335,335] = -1
        struct[0].Gy[336,0] = i_load_R1_a_r
        struct[0].Gy[336,1] = i_load_R1_a_i
        struct[0].Gy[336,6] = -i_load_R1_a_r
        struct[0].Gy[336,7] = -i_load_R1_a_i
        struct[0].Gy[336,336] = v_R1_a_r - v_R1_n_r
        struct[0].Gy[336,337] = v_R1_a_i - v_R1_n_i
        struct[0].Gy[337,2] = i_load_R1_b_r
        struct[0].Gy[337,3] = i_load_R1_b_i
        struct[0].Gy[337,6] = -i_load_R1_b_r
        struct[0].Gy[337,7] = -i_load_R1_b_i
        struct[0].Gy[337,338] = v_R1_b_r - v_R1_n_r
        struct[0].Gy[337,339] = v_R1_b_i - v_R1_n_i
        struct[0].Gy[338,4] = i_load_R1_c_r
        struct[0].Gy[338,5] = i_load_R1_c_i
        struct[0].Gy[338,6] = -i_load_R1_c_r
        struct[0].Gy[338,7] = -i_load_R1_c_i
        struct[0].Gy[338,340] = v_R1_c_r - v_R1_n_r
        struct[0].Gy[338,341] = v_R1_c_i - v_R1_n_i
        struct[0].Gy[339,0] = -i_load_R1_a_i
        struct[0].Gy[339,1] = i_load_R1_a_r
        struct[0].Gy[339,6] = i_load_R1_a_i
        struct[0].Gy[339,7] = -i_load_R1_a_r
        struct[0].Gy[339,336] = v_R1_a_i - v_R1_n_i
        struct[0].Gy[339,337] = -v_R1_a_r + v_R1_n_r
        struct[0].Gy[340,2] = -i_load_R1_b_i
        struct[0].Gy[340,3] = i_load_R1_b_r
        struct[0].Gy[340,6] = i_load_R1_b_i
        struct[0].Gy[340,7] = -i_load_R1_b_r
        struct[0].Gy[340,338] = v_R1_b_i - v_R1_n_i
        struct[0].Gy[340,339] = -v_R1_b_r + v_R1_n_r
        struct[0].Gy[341,4] = -i_load_R1_c_i
        struct[0].Gy[341,5] = i_load_R1_c_r
        struct[0].Gy[341,6] = i_load_R1_c_i
        struct[0].Gy[341,7] = -i_load_R1_c_r
        struct[0].Gy[341,340] = v_R1_c_i - v_R1_n_i
        struct[0].Gy[341,341] = -v_R1_c_r + v_R1_n_r
        struct[0].Gy[342,336] = 1
        struct[0].Gy[342,338] = 1
        struct[0].Gy[342,340] = 1
        struct[0].Gy[342,342] = 1
        struct[0].Gy[343,337] = 1
        struct[0].Gy[343,339] = 1
        struct[0].Gy[343,341] = 1
        struct[0].Gy[343,343] = 1
        struct[0].Gy[344,8] = i_load_R11_a_r
        struct[0].Gy[344,9] = i_load_R11_a_i
        struct[0].Gy[344,14] = -i_load_R11_a_r
        struct[0].Gy[344,15] = -i_load_R11_a_i
        struct[0].Gy[344,344] = v_R11_a_r - v_R11_n_r
        struct[0].Gy[344,345] = v_R11_a_i - v_R11_n_i
        struct[0].Gy[345,10] = i_load_R11_b_r
        struct[0].Gy[345,11] = i_load_R11_b_i
        struct[0].Gy[345,14] = -i_load_R11_b_r
        struct[0].Gy[345,15] = -i_load_R11_b_i
        struct[0].Gy[345,346] = v_R11_b_r - v_R11_n_r
        struct[0].Gy[345,347] = v_R11_b_i - v_R11_n_i
        struct[0].Gy[346,12] = i_load_R11_c_r
        struct[0].Gy[346,13] = i_load_R11_c_i
        struct[0].Gy[346,14] = -i_load_R11_c_r
        struct[0].Gy[346,15] = -i_load_R11_c_i
        struct[0].Gy[346,348] = v_R11_c_r - v_R11_n_r
        struct[0].Gy[346,349] = v_R11_c_i - v_R11_n_i
        struct[0].Gy[347,8] = -i_load_R11_a_i
        struct[0].Gy[347,9] = i_load_R11_a_r
        struct[0].Gy[347,14] = i_load_R11_a_i
        struct[0].Gy[347,15] = -i_load_R11_a_r
        struct[0].Gy[347,344] = v_R11_a_i - v_R11_n_i
        struct[0].Gy[347,345] = -v_R11_a_r + v_R11_n_r
        struct[0].Gy[348,10] = -i_load_R11_b_i
        struct[0].Gy[348,11] = i_load_R11_b_r
        struct[0].Gy[348,14] = i_load_R11_b_i
        struct[0].Gy[348,15] = -i_load_R11_b_r
        struct[0].Gy[348,346] = v_R11_b_i - v_R11_n_i
        struct[0].Gy[348,347] = -v_R11_b_r + v_R11_n_r
        struct[0].Gy[349,12] = -i_load_R11_c_i
        struct[0].Gy[349,13] = i_load_R11_c_r
        struct[0].Gy[349,14] = i_load_R11_c_i
        struct[0].Gy[349,15] = -i_load_R11_c_r
        struct[0].Gy[349,348] = v_R11_c_i - v_R11_n_i
        struct[0].Gy[349,349] = -v_R11_c_r + v_R11_n_r
        struct[0].Gy[350,344] = 1
        struct[0].Gy[350,346] = 1
        struct[0].Gy[350,348] = 1
        struct[0].Gy[350,350] = 1
        struct[0].Gy[351,345] = 1
        struct[0].Gy[351,347] = 1
        struct[0].Gy[351,349] = 1
        struct[0].Gy[351,351] = 1
        struct[0].Gy[352,16] = i_load_R15_a_r
        struct[0].Gy[352,17] = i_load_R15_a_i
        struct[0].Gy[352,22] = -i_load_R15_a_r
        struct[0].Gy[352,23] = -i_load_R15_a_i
        struct[0].Gy[352,352] = v_R15_a_r - v_R15_n_r
        struct[0].Gy[352,353] = v_R15_a_i - v_R15_n_i
        struct[0].Gy[353,18] = i_load_R15_b_r
        struct[0].Gy[353,19] = i_load_R15_b_i
        struct[0].Gy[353,22] = -i_load_R15_b_r
        struct[0].Gy[353,23] = -i_load_R15_b_i
        struct[0].Gy[353,354] = v_R15_b_r - v_R15_n_r
        struct[0].Gy[353,355] = v_R15_b_i - v_R15_n_i
        struct[0].Gy[354,20] = i_load_R15_c_r
        struct[0].Gy[354,21] = i_load_R15_c_i
        struct[0].Gy[354,22] = -i_load_R15_c_r
        struct[0].Gy[354,23] = -i_load_R15_c_i
        struct[0].Gy[354,356] = v_R15_c_r - v_R15_n_r
        struct[0].Gy[354,357] = v_R15_c_i - v_R15_n_i
        struct[0].Gy[355,16] = -i_load_R15_a_i
        struct[0].Gy[355,17] = i_load_R15_a_r
        struct[0].Gy[355,22] = i_load_R15_a_i
        struct[0].Gy[355,23] = -i_load_R15_a_r
        struct[0].Gy[355,352] = v_R15_a_i - v_R15_n_i
        struct[0].Gy[355,353] = -v_R15_a_r + v_R15_n_r
        struct[0].Gy[356,18] = -i_load_R15_b_i
        struct[0].Gy[356,19] = i_load_R15_b_r
        struct[0].Gy[356,22] = i_load_R15_b_i
        struct[0].Gy[356,23] = -i_load_R15_b_r
        struct[0].Gy[356,354] = v_R15_b_i - v_R15_n_i
        struct[0].Gy[356,355] = -v_R15_b_r + v_R15_n_r
        struct[0].Gy[357,20] = -i_load_R15_c_i
        struct[0].Gy[357,21] = i_load_R15_c_r
        struct[0].Gy[357,22] = i_load_R15_c_i
        struct[0].Gy[357,23] = -i_load_R15_c_r
        struct[0].Gy[357,356] = v_R15_c_i - v_R15_n_i
        struct[0].Gy[357,357] = -v_R15_c_r + v_R15_n_r
        struct[0].Gy[358,352] = 1
        struct[0].Gy[358,354] = 1
        struct[0].Gy[358,356] = 1
        struct[0].Gy[358,358] = 1
        struct[0].Gy[359,353] = 1
        struct[0].Gy[359,355] = 1
        struct[0].Gy[359,357] = 1
        struct[0].G