# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class TssV2TransactionsGet200ResponseProcessingInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'payment_solution': 'str',
        'commerce_indicator': 'str',
        'business_application_id': 'str',
        'authorization_options': 'TssV2TransactionsGet200ResponseProcessingInformationAuthorizationOptions',
        'bank_transfer_options': 'TssV2TransactionsGet200ResponseProcessingInformationBankTransferOptions',
        'japan_payment_options': 'TssV2TransactionsGet200ResponseProcessingInformationJapanPaymentOptions'
    }

    attribute_map = {
        'payment_solution': 'paymentSolution',
        'commerce_indicator': 'commerceIndicator',
        'business_application_id': 'businessApplicationId',
        'authorization_options': 'authorizationOptions',
        'bank_transfer_options': 'bankTransferOptions',
        'japan_payment_options': 'japanPaymentOptions'
    }

    def __init__(self, payment_solution=None, commerce_indicator=None, business_application_id=None, authorization_options=None, bank_transfer_options=None, japan_payment_options=None):
        """
        TssV2TransactionsGet200ResponseProcessingInformation - a model defined in Swagger
        """

        self._payment_solution = None
        self._commerce_indicator = None
        self._business_application_id = None
        self._authorization_options = None
        self._bank_transfer_options = None
        self._japan_payment_options = None

        if payment_solution is not None:
          self.payment_solution = payment_solution
        if commerce_indicator is not None:
          self.commerce_indicator = commerce_indicator
        if business_application_id is not None:
          self.business_application_id = business_application_id
        if authorization_options is not None:
          self.authorization_options = authorization_options
        if bank_transfer_options is not None:
          self.bank_transfer_options = bank_transfer_options
        if japan_payment_options is not None:
          self.japan_payment_options = japan_payment_options

    @property
    def payment_solution(self):
        """
        Gets the payment_solution of this TssV2TransactionsGet200ResponseProcessingInformation.
        Type of digital payment solution for the transaction. Possible Values:   - `visacheckout`: Visa Checkout. This value is required for Visa Checkout transactions. For details, see `payment_solution` field description in [Visa Checkout Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/VCO_SCMP_API/html/)  - `001`: Apple Pay.  - `004`: Cybersource In-App Solution.  - `005`: Masterpass. This value is required for Masterpass transactions on OmniPay Direct. For details, see \"Masterpass\" in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  - `006`: Android Pay.  - `007`: Chase Pay.  - `008`: Samsung Pay.  - `012`: Google Pay. 

        :return: The payment_solution of this TssV2TransactionsGet200ResponseProcessingInformation.
        :rtype: str
        """
        return self._payment_solution

    @payment_solution.setter
    def payment_solution(self, payment_solution):
        """
        Sets the payment_solution of this TssV2TransactionsGet200ResponseProcessingInformation.
        Type of digital payment solution for the transaction. Possible Values:   - `visacheckout`: Visa Checkout. This value is required for Visa Checkout transactions. For details, see `payment_solution` field description in [Visa Checkout Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/VCO_SCMP_API/html/)  - `001`: Apple Pay.  - `004`: Cybersource In-App Solution.  - `005`: Masterpass. This value is required for Masterpass transactions on OmniPay Direct. For details, see \"Masterpass\" in the [Credit Card Services Using the SCMP API Guide.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/)  - `006`: Android Pay.  - `007`: Chase Pay.  - `008`: Samsung Pay.  - `012`: Google Pay. 

        :param payment_solution: The payment_solution of this TssV2TransactionsGet200ResponseProcessingInformation.
        :type: str
        """
        if payment_solution is not None and len(payment_solution) > 12:
            raise ValueError("Invalid value for `payment_solution`, length must be less than or equal to `12`")

        self._payment_solution = payment_solution

    @property
    def commerce_indicator(self):
        """
        Gets the commerce_indicator of this TssV2TransactionsGet200ResponseProcessingInformation.
        Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional. Only `internet`, `moto`, `install`, `recurring`, and `recurring_internet` are valid values.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value (listed in Appendix I, \"Commerce Indicators,\" on page 441.)  #### Payer Authentication Transactions For the possible values and requirements, see \"Payer Authentication,\" page 195.  #### Other Types of Transactions See Appendix I, \"Commerce Indicators,\" on page 441.  #### Card Present You must set this field to `retail`. This field is required for a card-present transaction. 

        :return: The commerce_indicator of this TssV2TransactionsGet200ResponseProcessingInformation.
        :rtype: str
        """
        return self._commerce_indicator

    @commerce_indicator.setter
    def commerce_indicator(self, commerce_indicator):
        """
        Sets the commerce_indicator of this TssV2TransactionsGet200ResponseProcessingInformation.
        Type of transaction. Some payment card companies use this information when determining discount rates.  #### Used by **Authorization** Required payer authentication transactions; otherwise, optional. **Credit** Required for standalone credits on Chase Paymentech solutions; otherwise, optional. Only `internet`, `moto`, `install`, `recurring`, and `recurring_internet` are valid values.  #### Ingenico ePayments When you omit this field for Ingenico ePayments, the processor uses the default transaction type they have on file for you instead of the default value (listed in Appendix I, \"Commerce Indicators,\" on page 441.)  #### Payer Authentication Transactions For the possible values and requirements, see \"Payer Authentication,\" page 195.  #### Other Types of Transactions See Appendix I, \"Commerce Indicators,\" on page 441.  #### Card Present You must set this field to `retail`. This field is required for a card-present transaction. 

        :param commerce_indicator: The commerce_indicator of this TssV2TransactionsGet200ResponseProcessingInformation.
        :type: str
        """
        if commerce_indicator is not None and len(commerce_indicator) > 20:
            raise ValueError("Invalid value for `commerce_indicator`, length must be less than or equal to `20`")

        self._commerce_indicator = commerce_indicator

    @property
    def business_application_id(self):
        """
        Gets the business_application_id of this TssV2TransactionsGet200ResponseProcessingInformation.
        Payouts transaction type. Required for OCT transactions. This field is a pass-through, which means that CyberSource does not verify the value or modify it in any way before sending it to the processor. **Note** When the request includes this field, this value overrides the information in your CyberSource account.  For valid values, see the `invoiceHeader_businessApplicationID` field description in [Payouts Using the Simple Order API.](http://apps.cybersource.com/library/documentation/dev_guides/payouts_SO/Payouts_SO_API.pdf) 

        :return: The business_application_id of this TssV2TransactionsGet200ResponseProcessingInformation.
        :rtype: str
        """
        return self._business_application_id

    @business_application_id.setter
    def business_application_id(self, business_application_id):
        """
        Sets the business_application_id of this TssV2TransactionsGet200ResponseProcessingInformation.
        Payouts transaction type. Required for OCT transactions. This field is a pass-through, which means that CyberSource does not verify the value or modify it in any way before sending it to the processor. **Note** When the request includes this field, this value overrides the information in your CyberSource account.  For valid values, see the `invoiceHeader_businessApplicationID` field description in [Payouts Using the Simple Order API.](http://apps.cybersource.com/library/documentation/dev_guides/payouts_SO/Payouts_SO_API.pdf) 

        :param business_application_id: The business_application_id of this TssV2TransactionsGet200ResponseProcessingInformation.
        :type: str
        """

        self._business_application_id = business_application_id

    @property
    def authorization_options(self):
        """
        Gets the authorization_options of this TssV2TransactionsGet200ResponseProcessingInformation.

        :return: The authorization_options of this TssV2TransactionsGet200ResponseProcessingInformation.
        :rtype: TssV2TransactionsGet200ResponseProcessingInformationAuthorizationOptions
        """
        return self._authorization_options

    @authorization_options.setter
    def authorization_options(self, authorization_options):
        """
        Sets the authorization_options of this TssV2TransactionsGet200ResponseProcessingInformation.

        :param authorization_options: The authorization_options of this TssV2TransactionsGet200ResponseProcessingInformation.
        :type: TssV2TransactionsGet200ResponseProcessingInformationAuthorizationOptions
        """

        self._authorization_options = authorization_options

    @property
    def bank_transfer_options(self):
        """
        Gets the bank_transfer_options of this TssV2TransactionsGet200ResponseProcessingInformation.

        :return: The bank_transfer_options of this TssV2TransactionsGet200ResponseProcessingInformation.
        :rtype: TssV2TransactionsGet200ResponseProcessingInformationBankTransferOptions
        """
        return self._bank_transfer_options

    @bank_transfer_options.setter
    def bank_transfer_options(self, bank_transfer_options):
        """
        Sets the bank_transfer_options of this TssV2TransactionsGet200ResponseProcessingInformation.

        :param bank_transfer_options: The bank_transfer_options of this TssV2TransactionsGet200ResponseProcessingInformation.
        :type: TssV2TransactionsGet200ResponseProcessingInformationBankTransferOptions
        """

        self._bank_transfer_options = bank_transfer_options

    @property
    def japan_payment_options(self):
        """
        Gets the japan_payment_options of this TssV2TransactionsGet200ResponseProcessingInformation.

        :return: The japan_payment_options of this TssV2TransactionsGet200ResponseProcessingInformation.
        :rtype: TssV2TransactionsGet200ResponseProcessingInformationJapanPaymentOptions
        """
        return self._japan_payment_options

    @japan_payment_options.setter
    def japan_payment_options(self, japan_payment_options):
        """
        Sets the japan_payment_options of this TssV2TransactionsGet200ResponseProcessingInformation.

        :param japan_payment_options: The japan_payment_options of this TssV2TransactionsGet200ResponseProcessingInformation.
        :type: TssV2TransactionsGet200ResponseProcessingInformationJapanPaymentOptions
        """

        self._japan_payment_options = japan_payment_options

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TssV2TransactionsGet200ResponseProcessingInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
