# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Riskv1liststypeentriesPaymentInformationBank(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'account_number': 'str',
        'code': 'str',
        'country': 'str',
        'iban': 'str'
    }

    attribute_map = {
        'account_number': 'accountNumber',
        'code': 'code',
        'country': 'country',
        'iban': 'iban'
    }

    def __init__(self, account_number=None, code=None, country=None, iban=None):
        """
        Riskv1liststypeentriesPaymentInformationBank - a model defined in Swagger
        """

        self._account_number = None
        self._code = None
        self._country = None
        self._iban = None

        if account_number is not None:
          self.account_number = account_number
        if code is not None:
          self.code = code
        if country is not None:
          self.country = country
        if iban is not None:
          self.iban = iban

    @property
    def account_number(self):
        """
        Gets the account_number of this Riskv1liststypeentriesPaymentInformationBank.
        Customer's bank account number. You can use this field only when scoring a direct debit transaction. Use this field if you do not or are not allowed to provide the IBAN. Note Do not use the IBAN in this field. Use nly the traditional account number information. For the IBAN, use bank_iban. 

        :return: The account_number of this Riskv1liststypeentriesPaymentInformationBank.
        :rtype: str
        """
        return self._account_number

    @account_number.setter
    def account_number(self, account_number):
        """
        Sets the account_number of this Riskv1liststypeentriesPaymentInformationBank.
        Customer's bank account number. You can use this field only when scoring a direct debit transaction. Use this field if you do not or are not allowed to provide the IBAN. Note Do not use the IBAN in this field. Use nly the traditional account number information. For the IBAN, use bank_iban. 

        :param account_number: The account_number of this Riskv1liststypeentriesPaymentInformationBank.
        :type: str
        """
        if account_number is not None and len(account_number) > 30:
            raise ValueError("Invalid value for `account_number`, length must be less than or equal to `30`")

        self._account_number = account_number

    @property
    def code(self):
        """
        Gets the code of this Riskv1liststypeentriesPaymentInformationBank.
        Country-specific code used to identify the customer’s bank. Required for some countries if you do not or are not allowed to provide the IBAN instead. You can use this field only when scoring a direct debit transaction. For specific requirements, see \"Required Bank Account Information by Country,\" 

        :return: The code of this Riskv1liststypeentriesPaymentInformationBank.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this Riskv1liststypeentriesPaymentInformationBank.
        Country-specific code used to identify the customer’s bank. Required for some countries if you do not or are not allowed to provide the IBAN instead. You can use this field only when scoring a direct debit transaction. For specific requirements, see \"Required Bank Account Information by Country,\" 

        :param code: The code of this Riskv1liststypeentriesPaymentInformationBank.
        :type: str
        """
        if code is not None and len(code) > 15:
            raise ValueError("Invalid value for `code`, length must be less than or equal to `15`")

        self._code = code

    @property
    def country(self):
        """
        Gets the country of this Riskv1liststypeentriesPaymentInformationBank.
        Country where the bank is located. Use the two-character ISO codes. You can use this field only when scoring a direct debit transaction. 

        :return: The country of this Riskv1liststypeentriesPaymentInformationBank.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this Riskv1liststypeentriesPaymentInformationBank.
        Country where the bank is located. Use the two-character ISO codes. You can use this field only when scoring a direct debit transaction. 

        :param country: The country of this Riskv1liststypeentriesPaymentInformationBank.
        :type: str
        """
        if country is not None and len(country) > 2:
            raise ValueError("Invalid value for `country`, length must be less than or equal to `2`")

        self._country = country

    @property
    def iban(self):
        """
        Gets the iban of this Riskv1liststypeentriesPaymentInformationBank.
        International Bank Account Number (IBAN) for the bank account. For some countries you can provide this number instead of the traditional bank account information. You can use this field only when scoring a direct debit transaction. For specific requirements, see \"Required Bank Account Information by Country,\" 

        :return: The iban of this Riskv1liststypeentriesPaymentInformationBank.
        :rtype: str
        """
        return self._iban

    @iban.setter
    def iban(self, iban):
        """
        Sets the iban of this Riskv1liststypeentriesPaymentInformationBank.
        International Bank Account Number (IBAN) for the bank account. For some countries you can provide this number instead of the traditional bank account information. You can use this field only when scoring a direct debit transaction. For specific requirements, see \"Required Bank Account Information by Country,\" 

        :param iban: The iban of this Riskv1liststypeentriesPaymentInformationBank.
        :type: str
        """
        if iban is not None and len(iban) > 30:
            raise ValueError("Invalid value for `iban`, length must be less than or equal to `30`")

        self._iban = iban

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Riskv1liststypeentriesPaymentInformationBank):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
