/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { Project, ProjectOptions } from "projen";
/**
 * Configuration for the OpenAPI spec project
 */
export interface OpenApiSpecProjectOptions extends ProjectOptions {
    /**
     * The name of the OpenAPI specification file.
     * @default "spec.yaml"
     */
    readonly specFileName?: string;
    /**
     * The name of the output parsed OpenAPI specification file. Must end with .json.
     * @default ".parsed-spec.json"
     */
    readonly parsedSpecFileName?: string;
}
/**
 * Project containing the OpenAPI spec, and a parsed spec for use by the CDK construct
 */
export declare class OpenApiSpecProject extends Project {
    readonly specPath: string;
    readonly parsedSpecPath: string;
    readonly specFileName: string;
    readonly parsedSpecFileName: string;
    private synthed;
    constructor(options: OpenApiSpecProjectOptions);
    /**
     * @inheritDoc
     */
    synth(): void;
}
