"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaClientSourceCode = void 0;
const projen_1 = require("projen");
const languages_1 = require("../../languages");
const utils_1 = require("./utils");
/**
 * Generates the java client using OpenAPI Generator
 */
class GeneratedJavaClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        const javaProject = this.project;
        const invokerPackage = `${javaProject.pom.groupId}.${javaProject.name}.client`;
        // Generate the java client
        utils_1.generateClientCode({
            generator: "java",
            specPath: this.options.specPath,
            outputPath: this.project.outdir,
            language: languages_1.ClientLanguage.JAVA,
            additionalProperties: {
                // TODO: Upgrade to openapi-generator 6.0.1 when released so that useSingleRequestParameter is honoured
                // https://github.com/OpenAPITools/openapi-generator/milestone/42
                // https://github.com/OpenAPITools/openapi-generator/pull/12580
                // This will be required for generating java lambda handler wrappers
                useSingleRequestParameter: "true",
                groupId: javaProject.pom.groupId,
                artifactId: javaProject.pom.artifactId,
                artifactVersion: javaProject.pom.version,
                invokerPackage,
                apiPackage: `${invokerPackage}.api`,
                modelPackage: `${invokerPackage}.model`,
                hideGenerationTimestamp: "true",
            },
        });
    }
}
exports.GeneratedJavaClientSourceCode = GeneratedJavaClientSourceCode;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2VuZXJhdGVkLWphdmEtY2xpZW50LXNvdXJjZS1jb2RlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL3Byb2plY3QvY29kZWdlbi9jb21wb25lbnRzL2dlbmVyYXRlZC1qYXZhLWNsaWVudC1zb3VyY2UtY29kZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7Ozs7Ozs7Ozs7O3dIQWN3SDs7O0FBRXhILG1DQUFtQztBQUVuQywrQ0FBaUQ7QUFDakQsbUNBQTZDO0FBWTdDOztHQUVHO0FBQ0gsTUFBYSw2QkFBOEIsU0FBUSxrQkFBUztJQUcxRCxZQUNFLE9BQW9CLEVBQ3BCLE9BQTZDO1FBRTdDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUNmLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO0lBQ3pCLENBQUM7SUFFRDs7T0FFRztJQUNILFVBQVU7UUFDUixLQUFLLENBQUMsVUFBVSxFQUFFLENBQUM7UUFFbkIsTUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLE9BQXNCLENBQUM7UUFDaEQsTUFBTSxjQUFjLEdBQUcsR0FBRyxXQUFXLENBQUMsR0FBRyxDQUFDLE9BQU8sSUFBSSxXQUFXLENBQUMsSUFBSSxTQUFTLENBQUM7UUFFL0UsMkJBQTJCO1FBQzNCLDBCQUFrQixDQUFDO1lBQ2pCLFNBQVMsRUFBRSxNQUFNO1lBQ2pCLFFBQVEsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLFFBQVE7WUFDL0IsVUFBVSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTTtZQUMvQixRQUFRLEVBQUUsMEJBQWMsQ0FBQyxJQUFJO1lBQzdCLG9CQUFvQixFQUFFO2dCQUNwQix1R0FBdUc7Z0JBQ3ZHLGlFQUFpRTtnQkFDakUsK0RBQStEO2dCQUMvRCxvRUFBb0U7Z0JBQ3BFLHlCQUF5QixFQUFFLE1BQU07Z0JBQ2pDLE9BQU8sRUFBRSxXQUFXLENBQUMsR0FBRyxDQUFDLE9BQU87Z0JBQ2hDLFVBQVUsRUFBRSxXQUFXLENBQUMsR0FBRyxDQUFDLFVBQVU7Z0JBQ3RDLGVBQWUsRUFBRSxXQUFXLENBQUMsR0FBRyxDQUFDLE9BQU87Z0JBQ3hDLGNBQWM7Z0JBQ2QsVUFBVSxFQUFFLEdBQUcsY0FBYyxNQUFNO2dCQUNuQyxZQUFZLEVBQUUsR0FBRyxjQUFjLFFBQVE7Z0JBQ3ZDLHVCQUF1QixFQUFFLE1BQU07YUFDaEM7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUExQ0Qsc0VBMENDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKlxuIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuXG4gTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS5cbiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGggdGhlIExpY2Vuc2UuXG4gWW91IG1heSBvYnRhaW4gYSBjb3B5IG9mIHRoZSBMaWNlbnNlIGF0XG5cbiBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcblxuIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZywgc29mdHdhcmVcbiBkaXN0cmlidXRlZCB1bmRlciB0aGUgTGljZW5zZSBpcyBkaXN0cmlidXRlZCBvbiBhbiBcIkFTIElTXCIgQkFTSVMsXG4gV0lUSE9VVCBXQVJSQU5USUVTIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuXG4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZFxuIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqICovXG5cbmltcG9ydCB7IENvbXBvbmVudCB9IGZyb20gXCJwcm9qZW5cIjtcbmltcG9ydCB7IEphdmFQcm9qZWN0IH0gZnJvbSBcInByb2plbi9saWIvamF2YVwiO1xuaW1wb3J0IHsgQ2xpZW50TGFuZ3VhZ2UgfSBmcm9tIFwiLi4vLi4vbGFuZ3VhZ2VzXCI7XG5pbXBvcnQgeyBnZW5lcmF0ZUNsaWVudENvZGUgfSBmcm9tIFwiLi91dGlsc1wiO1xuXG4vKipcbiAqIENvbmZpZ3VyYXRpb24gZm9yIHRoZSBHZW5lcmF0ZWRKYXZhQ2xpZW50IGNvbXBvbmVudFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEdlbmVyYXRlZEphdmFDbGllbnRTb3VyY2VDb2RlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBBYnNvbHV0ZSBwYXRoIHRvIHRoZSBPcGVuQVBJIHNwZWNpZmljYXRpb24gKHNwZWMueWFtbClcbiAgICovXG4gIHJlYWRvbmx5IHNwZWNQYXRoOiBzdHJpbmc7XG59XG5cbi8qKlxuICogR2VuZXJhdGVzIHRoZSBqYXZhIGNsaWVudCB1c2luZyBPcGVuQVBJIEdlbmVyYXRvclxuICovXG5leHBvcnQgY2xhc3MgR2VuZXJhdGVkSmF2YUNsaWVudFNvdXJjZUNvZGUgZXh0ZW5kcyBDb21wb25lbnQge1xuICBwcml2YXRlIG9wdGlvbnM6IEdlbmVyYXRlZEphdmFDbGllbnRTb3VyY2VDb2RlT3B0aW9ucztcblxuICBjb25zdHJ1Y3RvcihcbiAgICBwcm9qZWN0OiBKYXZhUHJvamVjdCxcbiAgICBvcHRpb25zOiBHZW5lcmF0ZWRKYXZhQ2xpZW50U291cmNlQ29kZU9wdGlvbnNcbiAgKSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG4gICAgdGhpcy5vcHRpb25zID0gb3B0aW9ucztcbiAgfVxuXG4gIC8qKlxuICAgKiBAaW5oZXJpdERvY1xuICAgKi9cbiAgc3ludGhlc2l6ZSgpIHtcbiAgICBzdXBlci5zeW50aGVzaXplKCk7XG5cbiAgICBjb25zdCBqYXZhUHJvamVjdCA9IHRoaXMucHJvamVjdCBhcyBKYXZhUHJvamVjdDtcbiAgICBjb25zdCBpbnZva2VyUGFja2FnZSA9IGAke2phdmFQcm9qZWN0LnBvbS5ncm91cElkfS4ke2phdmFQcm9qZWN0Lm5hbWV9LmNsaWVudGA7XG5cbiAgICAvLyBHZW5lcmF0ZSB0aGUgamF2YSBjbGllbnRcbiAgICBnZW5lcmF0ZUNsaWVudENvZGUoe1xuICAgICAgZ2VuZXJhdG9yOiBcImphdmFcIixcbiAgICAgIHNwZWNQYXRoOiB0aGlzLm9wdGlvbnMuc3BlY1BhdGgsXG4gICAgICBvdXRwdXRQYXRoOiB0aGlzLnByb2plY3Qub3V0ZGlyLFxuICAgICAgbGFuZ3VhZ2U6IENsaWVudExhbmd1YWdlLkpBVkEsXG4gICAgICBhZGRpdGlvbmFsUHJvcGVydGllczoge1xuICAgICAgICAvLyBUT0RPOiBVcGdyYWRlIHRvIG9wZW5hcGktZ2VuZXJhdG9yIDYuMC4xIHdoZW4gcmVsZWFzZWQgc28gdGhhdCB1c2VTaW5nbGVSZXF1ZXN0UGFyYW1ldGVyIGlzIGhvbm91cmVkXG4gICAgICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9PcGVuQVBJVG9vbHMvb3BlbmFwaS1nZW5lcmF0b3IvbWlsZXN0b25lLzQyXG4gICAgICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9PcGVuQVBJVG9vbHMvb3BlbmFwaS1nZW5lcmF0b3IvcHVsbC8xMjU4MFxuICAgICAgICAvLyBUaGlzIHdpbGwgYmUgcmVxdWlyZWQgZm9yIGdlbmVyYXRpbmcgamF2YSBsYW1iZGEgaGFuZGxlciB3cmFwcGVyc1xuICAgICAgICB1c2VTaW5nbGVSZXF1ZXN0UGFyYW1ldGVyOiBcInRydWVcIixcbiAgICAgICAgZ3JvdXBJZDogamF2YVByb2plY3QucG9tLmdyb3VwSWQsXG4gICAgICAgIGFydGlmYWN0SWQ6IGphdmFQcm9qZWN0LnBvbS5hcnRpZmFjdElkLFxuICAgICAgICBhcnRpZmFjdFZlcnNpb246IGphdmFQcm9qZWN0LnBvbS52ZXJzaW9uLFxuICAgICAgICBpbnZva2VyUGFja2FnZSxcbiAgICAgICAgYXBpUGFja2FnZTogYCR7aW52b2tlclBhY2thZ2V9LmFwaWAsXG4gICAgICAgIG1vZGVsUGFja2FnZTogYCR7aW52b2tlclBhY2thZ2V9Lm1vZGVsYCxcbiAgICAgICAgaGlkZUdlbmVyYXRpb25UaW1lc3RhbXA6IFwidHJ1ZVwiLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxufVxuIl19