"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateClientCode = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const path = require("path");
const util_1 = require("projen/lib/util");
const serializeProperties = (properties) => Object.entries(properties)
    .map(([key, value]) => `${key}=${value}`)
    .join(",");
/**
 * Generate client code by invoking the root generate script
 */
exports.generateClientCode = (options) => {
    const additionalProperties = options.additionalProperties
        ? ` --additional-properties ${serializeProperties(options.additionalProperties)}`
        : "";
    util_1.exec(`./generate --generator ${options.generator} --spec-path ${options.specPath} --output-path ${options.outputPath} --language ${options.language}${additionalProperties}`, {
        cwd: path.resolve(__dirname, "..", "..", "..", "..", "scripts", "generators"),
    });
};
//# sourceMappingURL=data:application/json;base64,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