"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.functionInvocationUri = exports.concatMethodAndPath = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Serialise a method and path into a single string
 */
exports.concatMethodAndPath = ({ method, path }) => `${method.toLowerCase()}||${path.toLowerCase()}`;
/**
 * Generate the lambda function invocation uri for the given lambda within the given scope
 * @param scope scope in which the lambda is deployed
 * @param lambdaFunction the lambda function to be invoked
 */
exports.functionInvocationUri = (scope, lambdaFunction) => {
    const stack = aws_cdk_lib_1.Stack.of(scope);
    return `arn:${stack.partition}:apigateway:${stack.region}:lambda:path/2015-03-31/functions/${lambdaFunction.functionArn}/invocations`;
};
//# sourceMappingURL=data:application/json;base64,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