import { Authorizer, CognitoAuthorizer, CustomAuthorizer, IamAuthorizer, NoneAuthorizer } from "./authorizers";
/**
 * Predicate for narrowing an authorizer to CustomAuthorizer
 */
export declare const isCustomAuthorizer: (authorizer: Authorizer) => authorizer is CustomAuthorizer;
/**
 * Predicate for narrowing an authorizer to CognitoAuthorizer
 */
export declare const isCognitoAuthorizer: (authorizer: Authorizer) => authorizer is CognitoAuthorizer;
/**
 * Predicate for narrowing an authorizer to IamAuthorizer
 */
export declare const isIamAuthorizer: (authorizer: Authorizer) => authorizer is IamAuthorizer;
/**
 * Predicate for narrowing an authorizer to NoneAuthorizer
 */
export declare const isNoneAuthorizer: (authorizer: Authorizer) => authorizer is NoneAuthorizer;
