import { LogFormatterInterface } from '.';
import { LogAttributes, UnformattedAttributes } from '../types';
/**
 * This class defines and implements common methods for the formatting of log attributes.
 *
 * @class
 * @abstract
 * @implements {LogFormatterInterface}
 */
declare abstract class LogFormatter implements LogFormatterInterface {
    /**
     * It formats key-value pairs of log attributes.
     *
     * @param {UnformattedAttributes} attributes
     * @returns {LogAttributes}
     */
    abstract formatAttributes(attributes: UnformattedAttributes): LogAttributes;
    /**
     * It formats a given Error parameter.
     *
     * @param {Error} error
     * @returns {LogAttributes}
     */
    formatError(error: Error): LogAttributes;
    /**
     * It formats a date into a string in simplified extended ISO format (ISO 8601).
     *
     * @param {Date} now
     * @returns {string}
     */
    formatTimestamp(now: Date): string;
    /**
     * It returns a string containing the location of an error, given a particular stack trace.
     *
     * @param stack
     * @returns {string}
     */
    getCodeLocation(stack?: string): string;
}
export { LogFormatter, };
