"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToolsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
export class Hello {
  public sayHello() {
    return 'hello, world!';
  }
}
*/
//import * as path from 'path';
//import { AssetCode, LayerVersion, Runtime, LayerVersionProps } from 'aws-cdk-lib/aws-lambda';
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
/**
 * Create a Lambda layer with the PowerTools and other required modules.
 */
class ToolsLayer extends constructs_1.Construct {
    /**
       * @param {Construct} scope
       * @param {string} id
    */
    constructor(scope, id, props) {
        super(scope, id);
        this.layerVersion = new aws_lambda_1.LayerVersion(this, `${props?.layerVersionName}-ToolsLayer`, {
            compatibleRuntimes: [aws_lambda_1.Runtime.NODEJS_16_X],
            //code: AssetCode.fromAsset(path.join(__dirname, './powertools')),
            //code: AssetCode.fromAsset('./src/powertools'),
            code: aws_lambda_1.Code.fromAsset('src/powertools'),
            description: `${props?.layerVersionName} Tools Shared Layer`,
            layerVersionName: `${props?.layerVersionName}-tools`,
        });
    }
}
exports.ToolsLayer = ToolsLayer;
_a = JSII_RTTI_SYMBOL_1;
ToolsLayer[_a] = { fqn: "vaughntech-nodejs-powertools-lambdalayer.ToolsLayer", version: "0.0.10" };
//# sourceMappingURL=data:application/json;base64,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