/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.tools.optimization.de;

import java.util.ArrayList;
import java.util.Random;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.tools.optimization.de.DEIndividual;
import si.ijs.kt.clus.util.tools.optimization.de.DEProblem;

public class DEPopulation {
    public ArrayList<DEIndividual> m_Inds;
    private DEProblem m_Probl;
    private Random m_Rand;
    private ClusStatManager m_StatMgr;

    public DEPopulation(ClusStatManager stat_mgr, DEProblem probl) {
        this.m_Probl = probl;
        this.m_StatMgr = stat_mgr;
        this.m_Rand = new Random(this.getSettings().getRules().getOptDESeed());
        this.m_Inds = new ArrayList(this.getSettings().getRules().getOptDEPopSize());
        for (int i = 0; i < this.getSettings().getRules().getOptDEPopSize(); ++i) {
            DEIndividual ind = new DEIndividual();
            this.m_Inds.add(ind);
        }
    }

    public void createFirstPop() {
        for (int i = 0; i < this.getSettings().getRules().getOptDEPopSize(); ++i) {
            this.m_Inds.get(i).setGenes(this.m_Probl.getRandVector(this.m_Rand));
        }
    }

    public int evaluatePop(int num_eval) {
        int result = num_eval;
        for (int i = 0; i < this.m_Inds.size(); ++i) {
            result = this.m_Inds.get(i).evaluate(this.m_Probl, result);
        }
        return result;
    }

    public ArrayList<Double> getCandidate(int parent) {
        int i_rand;
        int i3;
        int i2;
        int i1;
        ArrayList<Double> result = new ArrayList<Double>(this.m_Probl.getNumVar());
        for (int k = 0; k < this.m_Probl.getNumVar(); ++k) {
            result.add(k, new Double(0.0));
        }
        while ((i1 = (int)((double)this.getSettings().getRules().getOptDEPopSize() * this.m_Rand.nextDouble())) == parent) {
        }
        while ((i2 = (int)((double)this.getSettings().getRules().getOptDEPopSize() * this.m_Rand.nextDouble())) == parent || i2 == i1) {
        }
        while ((i3 = (int)((double)this.getSettings().getRules().getOptDEPopSize() * this.m_Rand.nextDouble())) == parent || i3 == i1 || i3 == i2) {
        }
        int i = i_rand = (int)((double)this.m_Probl.getNumVar() * this.m_Rand.nextDouble());
        for (int kVariable = 0; kVariable < this.m_Probl.getNumVar(); ++kVariable) {
            result.set(i, this.m_Inds.get(parent).getGenes().get(i));
            if (this.m_Rand.nextDouble() < this.getSettings().getRules().getOptDECrossProb() || i == i_rand) {
                result.set(i, new Double(this.getSettings().getRules().getOptDEWeight() * (this.m_Inds.get(i1).getGenes().get(i) - this.m_Inds.get(i2).getGenes().get(i)) + this.m_Inds.get(i3).getGenes().get(i)));
            }
            if (this.m_Rand.nextDouble() < this.getSettings().getRules().getOptDEProbMutationZero()) {
                result.set(i, new Double(0.0));
            }
            if (this.m_Rand.nextDouble() < this.getSettings().getRules().getOptDEProbMutationNonZero()) {
                result.set(i, new Double(this.m_Probl.getRandValueInRange(this.m_Rand, i)));
            }
            ++i;
            i %= this.m_Probl.getNumVar();
        }
        return this.m_Probl.getRoundVector(result);
    }

    public void sortPopRandom() {
        int i;
        ArrayList<DEIndividual> inds = new ArrayList<DEIndividual>(this.getSettings().getRules().getOptDEPopSize());
        ArrayList<Integer> indexes = new ArrayList<Integer>(this.getSettings().getRules().getOptDEPopSize());
        for (i = 0; i < this.getSettings().getRules().getOptDEPopSize(); ++i) {
            inds.add(new DEIndividual());
            indexes.add(new Integer(i));
        }
        for (i = 0; i < this.getSettings().getRules().getOptDEPopSize(); ++i) {
            int n = (int)((double)indexes.size() * this.m_Rand.nextDouble());
            ((DEIndividual)inds.get(i)).copy(this.m_Inds.get((Integer)indexes.get(n)));
            indexes.remove(n);
        }
        for (i = 0; i < this.getSettings().getRules().getOptDEPopSize(); ++i) {
            this.m_Inds.get(i).copy((DEIndividual)inds.get(i));
        }
    }

    public String getPopString() {
        String result = "";
        for (int i = 0; i < this.m_Inds.size(); ++i) {
            result = result + this.m_Inds.get(i).getIndString();
        }
        return result;
    }

    public Settings getSettings() {
        return this.m_StatMgr.getSettings();
    }
}

