/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.tools.manual;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ManualEntry {
    private static final String m_OptionNameTemplate = "\\optionNameStyle{%s}:";
    private static final String m_PossibleValuesTemplate = "\\optionPossibleValues{}: %s";
    private static final String m_DefaultValueTemplate = "\\optionDefaultValue{}: %s";
    private static final String m_DescriptionTemplate = "\\optionDescription{}: %s";
    private static final String optionPattern = "\\\\optionNameStyle\\{(.*?)\\}";
    private static final String miscPattern = "(?<=\\\\item \\\\%s\\{\\}\\:)(.*?){1,}(?=(\\\\item)|(\\\\end\\{itemize))";
    private static final Pattern pOption = Pattern.compile("\\\\optionNameStyle\\{(.*?)\\}");
    private static final Pattern pPossible = Pattern.compile(String.format("(?<=\\\\item \\\\%s\\{\\}\\:)(.*?){1,}(?=(\\\\item)|(\\\\end\\{itemize))", "optionPossibleValues"), 40);
    private static final Pattern pDefault = Pattern.compile(String.format("(?<=\\\\item \\\\%s\\{\\}\\:)(.*?){1,}(?=(\\\\item)|(\\\\end\\{itemize))", "optionDefaultValue"), 40);
    private static final Pattern pDescription = Pattern.compile(String.format("(?<=\\\\item \\\\%s\\{\\}\\:)(.*?){1,}(?=(\\\\item)|(\\\\end\\{itemize))", "optionDescri?ption"), 40);
    private String m_Name;
    private String m_Possible;
    private String m_Default;
    private String m_Description;

    public String getName() {
        return this.m_Name;
    }

    public String getPossible() {
        return this.m_Possible;
    }

    public String getDefault() {
        return this.m_Default;
    }

    public String getDescription() {
        return this.m_Description;
    }

    public ManualEntry(String contents) {
        this.parse(contents);
    }

    private void parse(String contents) {
        Matcher m = pOption.matcher(contents);
        if (m.find()) {
            this.m_Name = m.group(1).trim();
        }
        if ((m = pPossible.matcher(contents)).find()) {
            this.m_Possible = m.group(0).trim();
        }
        if ((m = pDefault.matcher(contents)).find()) {
            this.m_Default = m.group(0).trim();
        }
        if ((m = pDescription.matcher(contents)).find()) {
            this.m_Description = m.group(0).trim();
        }
    }

    public static String getLatex\u0415mpty(String name, String defaultValue) {
        String none = "???";
        String s = "    \\item " + String.format(m_OptionNameTemplate, name) + System.lineSeparator() + "           \\begin{itemize}" + System.lineSeparator() + "                \\item " + String.format(m_PossibleValuesTemplate, none) + System.lineSeparator() + "                \\item " + String.format(m_DefaultValueTemplate, defaultValue) + System.lineSeparator() + "                \\item " + String.format(m_DescriptionTemplate, none) + System.lineSeparator() + "           \\end{itemize}";
        return s;
    }

    public String toString() {
        String s = "    \\item " + String.format(m_OptionNameTemplate, this.getName()) + System.lineSeparator() + "           \\begin{itemize}" + System.lineSeparator() + "                \\item " + String.format(m_PossibleValuesTemplate, this.getPossible()) + System.lineSeparator() + "                \\item " + String.format(m_DefaultValueTemplate, this.getDefault()) + System.lineSeparator() + "                \\item " + String.format(m_DescriptionTemplate, this.getDescription()) + System.lineSeparator() + "           \\end{itemize}";
        return s;
    }

    public int merge(ManualEntry other) {
        if (!this.getName().equals(other.getName())) {
            return 0;
        }
        int cnt = 0;
        if (!this.getPossible().equals(other.getPossible())) {
            this.m_Possible = other.getPossible();
            ++cnt;
        }
        if (!this.getDefault().equals(other.getDefault())) {
            this.m_Default = other.getDefault();
            ++cnt;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            this.m_Description = other.getDescription();
            ++cnt;
        }
        return cnt;
    }
}

