/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.tools.manual;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TreeMap;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.ClusUtil;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileSection;
import si.ijs.kt.clus.util.tools.manual.ManualEntry;
import si.ijs.kt.clus.util.tools.manual.ManualSectionEntry;

public class ManualBuilder {
    private void createFolder(String f) {
        block2: {
            File folder = new File(f);
            try {
                folder.mkdirs();
            }
            catch (SecurityException e) {
                if (folder.exists()) break block2;
                throw e;
            }
        }
    }

    public void buildSettingsTables(String settingsTablesFolder) {
        HashMap<String, TreeMap<Integer, String[]>> default_values = this.listAllSettings();
        this.createFolder(settingsTablesFolder);
        for (String section : default_values.keySet()) {
            this.writeLatexSectionSettingsFile(section, settingsTablesFolder, default_values.get(section), false);
        }
    }

    private HashMap<String, TreeMap<Integer, String[]>> listAllSettings() {
        HashMap<String, TreeMap<Integer, String[]>> default_values = new HashMap<String, TreeMap<Integer, String[]>>();
        Settings defaultSett = Settings.getDefaultSettings();
        Enumeration<INIFileNode> sectionEnum = defaultSett.getSectionsIterator();
        while (sectionEnum.hasMoreElements()) {
            INIFileSection section = (INIFileSection)sectionEnum.nextElement();
            String secName = section.getName();
            if (!default_values.containsKey(secName)) {
                default_values.put(secName, new TreeMap());
            }
            Integer count = 0;
            Enumeration<INIFileNode> e = section.getNodes();
            while (e.hasMoreElements()) {
                INIFileEntry entry = (INIFileEntry)e.nextElement();
                default_values.get(secName).put(count, new String[]{entry.getName(), entry.getStringValue()});
                count = new Integer(count + 1);
            }
        }
        return default_values;
    }

    private void writeLatexSectionSettingsFile(String sectionName, String settingsTablesFolder, TreeMap<Integer, String[]> sectionDefaults, boolean selfstandingTex) {
        try {
            String fileName = String.format("%s/options-%s.tex", settingsTablesFolder, sectionName);
            PrintWriter writer = new PrintWriter(fileName, "UTF-8");
            if (selfstandingTex) {
                String[] preamble;
                for (String line : preamble = new String[]{"\\documentclass{article}", "\\usepackage[utf8]{inputenc}"}) {
                    writer.println(line);
                }
                writer.println("\\begin{document}");
                writer.println();
            }
            writer.println(String.format("\\section{%s}", sectionName));
            writer.println("\\begin{itemize}");
            for (Integer key : sectionDefaults.keySet()) {
                String[] option_default = sectionDefaults.get(key);
                String name = option_default[0];
                CharSequence[] defaults = ManualBuilder.nicifyDefaultValue(option_default[1]);
                for (int i = 0; i < defaults.length; ++i) {
                    defaults[i] = String.format("\\optionDefaultValueStyle{%s}", defaults[i]);
                }
                String defaultValue = String.join((CharSequence)", ", defaults);
                writer.println(ManualEntry.getLatex\u0415mpty(name, defaultValue));
            }
            writer.println("\\end{itemize}");
            if (selfstandingTex) {
                writer.println();
                writer.println("\\end{document}");
            }
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String[] nicifyDefaultValue(String default_value) {
        String[] results;
        String result = default_value;
        result = result.trim();
        result = result.replaceAll("\r\n", ",");
        result = result.replaceAll("\n", ",");
        result = result.replaceAll("\r", ",");
        result = result.replaceAll(",+", ",");
        result = result.replaceAll("\t", " ");
        if ((result = result.replaceAll(" +", " ")).startsWith("{")) {
            result = result.replaceAll("\\{", "\\\\{");
            result = result.replaceAll("\\}", "\\\\}");
            results = new String[]{result};
        } else {
            results = result.split(",");
        }
        for (int i = 0; i < results.length; ++i) {
            results[i] = results[i].trim();
        }
        return results;
    }

    public void mergeExistingTables(String manualOptionsListsDir, String manualOptionsListsDirExisting) {
        Settings defaultSett = Settings.getDefaultSettings();
        try {
            Enumeration<INIFileNode> sectionEnum = defaultSett.getSectionsIterator();
            while (sectionEnum.hasMoreElements()) {
                INIFileSection section = (INIFileSection)sectionEnum.nextElement();
                String secName = section.getName();
                File fUpdated = new File(manualOptionsListsDir + "\\options-" + secName + ".tex");
                File fExisting = new File(manualOptionsListsDirExisting + "\\options-" + secName + ".tex");
                if (!fUpdated.exists() || !fExisting.exists()) continue;
                System.out.print("Merging section " + secName + ": ");
                int changes = this.mergeFiles(fExisting, fUpdated);
                System.out.println(changes + " differences found");
            }
        }
        catch (Exception ex) {
            System.err.println("Error while merging files.");
        }
    }

    private int mergeFiles(File existing, File updated) throws IOException {
        int changes;
        block18: {
            String ext = "";
            String upd = "";
            try (FileInputStream fsExisting = new FileInputStream(existing);
                 FileInputStream fsUpdated = new FileInputStream(updated);){
                ext = ClusUtil.readStream(fsExisting);
                upd = ClusUtil.readStream(fsUpdated);
            }
            ManualSectionEntry mExt = new ManualSectionEntry(ext);
            ManualSectionEntry mUpd = new ManualSectionEntry(upd);
            changes = mUpd.merge(mExt);
            try {
                if (changes <= 0) break block18;
                try (FileWriter fw = new FileWriter(updated);){
                    fw.write(mUpd.toString());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return changes;
    }
}

