/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.tools.hier;

import java.util.Arrays;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;
import si.ijs.kt.clus.ext.hierarchical.HierIO;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.jeans.io.MyFile;
import si.ijs.kt.clus.util.jeans.math.SingleStat;
import si.ijs.kt.clus.util.jeans.util.MyArray;

@Deprecated
public class GenerateData {
    public static double MEAN_BRANCH = 2.75;
    public static int MAX_BRANCH = 3;
    public static int MAX_DEPTH = 4;
    public static int MAX_CLASS = 1;
    public static int NB_DATA = 10000;
    public static double MAX_ERROR = 0.001;

    public static ClassTerm createSimpleHierarchy() {
        ClassTerm term = new ClassTerm();
        GenerateData.createSimpleHierarchy(term, 0);
        return term;
    }

    public static void createSimpleHierarchy(ClassTerm term, int depth) {
        if (depth >= MAX_DEPTH) {
            return;
        }
        for (int i = 0; i < MAX_BRANCH; ++i) {
            ClassTerm child = new ClassTerm(String.valueOf(i + 1));
            child.addParent(child);
            term.addChild(child);
            GenerateData.createSimpleHierarchy(child, depth + 1);
        }
    }

    public static ClassTerm createInitHierarchy() {
        ClassTerm term = new ClassTerm();
        GenerateData.createInitHier(term, 0);
        return term;
    }

    public static void createInitHier(ClassTerm term, int depth) {
        if (depth >= MAX_DEPTH) {
            return;
        }
        int arity = ClusRandom.nextInt(3, (int)Math.floor(2.0 * MEAN_BRANCH));
        for (int i = 0; i < arity; ++i) {
            ClassTerm child = new ClassTerm(String.valueOf(i + 1));
            child.addParent(term);
            term.addChild(child);
            GenerateData.createInitHier(child, depth + 1);
        }
    }

    public static ClassTerm createHierarchy() {
        boolean done = false;
        boolean increase = true;
        int count = 0;
        ClassTerm root = GenerateData.createInitHierarchy();
        MyArray terms = new MyArray();
        GenerateData.addAll(root, terms);
        MyArray sel_from = new MyArray();
        SingleStat stat = new SingleStat();
        while (!done) {
            int i;
            int nb_possible = 0;
            sel_from.removeAllElements();
            if (increase) {
                for (i = 0; i < terms.size(); ++i) {
                    ClassTerm trm = (ClassTerm)terms.elementAt(i);
                    if (trm.getLevel() >= MAX_DEPTH) continue;
                    ++nb_possible;
                    sel_from.addElement(trm);
                }
                int to_expand = ClusRandom.nextInt(3, nb_possible);
                ClassTerm myexp = (ClassTerm)sel_from.elementAt(to_expand);
                int name = myexp.getNbChildren();
                ClassTerm child = new ClassTerm(String.valueOf(name + 1));
                child.addParent(myexp);
                myexp.addChild(child);
                terms.addElement(child);
            } else {
                for (i = 0; i < terms.size(); ++i) {
                    ClassTerm trm = (ClassTerm)terms.elementAt(i);
                    if (trm.getNbChildren() <= 0) continue;
                    ++nb_possible;
                    sel_from.addElement(trm);
                }
                int to_decrease = ClusRandom.nextInt(3, nb_possible);
                ClassTerm mydecr = (ClassTerm)sel_from.elementAt(to_decrease);
                int nbch = mydecr.getNbChildren();
                int to_remove = ClusRandom.nextInt(3, nbch);
                mydecr.removeChild(to_remove);
                mydecr.numberChildren();
                terms.removeAllElements();
                GenerateData.addAll(root, terms);
            }
            boolean depth_constraint = false;
            for (int i2 = 0; i2 < terms.size(); ++i2) {
                ClassTerm trm = (ClassTerm)terms.elementAt(i2);
                if (trm.getLevel() != MAX_DEPTH) continue;
                depth_constraint = true;
            }
            stat.reset();
            root.getMeanBranch(null, stat);
            if (depth_constraint) {
                if (Math.abs(stat.getMean() - MEAN_BRANCH) < MAX_ERROR) {
                    done = true;
                } else {
                    increase = stat.getMean() < MEAN_BRANCH;
                }
            } else {
                increase = true;
            }
            if (count % 100 == 0) {
                ClusLogger.info("Current: " + stat.getMean() + " " + terms.size());
            }
            ++count;
        }
        return root;
    }

    public static void addAll(ClassTerm root, MyArray cls) {
        cls.addElement(root);
        for (int i = 0; i < root.getNbChildren(); ++i) {
            GenerateData.addAll((ClassTerm)root.getChild(i), cls);
        }
    }

    public static void addClasses(ClassTerm root, MyArray cls) {
        if (root.atBottomLevel()) {
            cls.addElement(root);
        }
        for (int i = 0; i < root.getNbChildren(); ++i) {
            GenerateData.addClasses((ClassTerm)root.getChild(i), cls);
        }
    }

    public static void addAttributes(ClassTerm root, MyArray cls) {
        if (!root.atBottomLevel()) {
            cls.addElement(root);
        }
        for (int i = 0; i < root.getNbChildren(); ++i) {
            GenerateData.addAttributes((ClassTerm)root.getChild(i), cls);
        }
    }

    public static void calcMeanDepth(ClassTerm root, SingleStat stat) {
        stat.addFloat(root.getLevel());
        for (int i = 0; i < root.getNbChildren(); ++i) {
            GenerateData.calcMeanDepth((ClassTerm)root.getChild(i), stat);
        }
    }

    public static void main(String[] args) {
        MAX_BRANCH = Integer.parseInt(args[0]);
        MAX_DEPTH = Integer.parseInt(args[1]);
        MAX_CLASS = Integer.parseInt(args[2]);
        int RND = Integer.parseInt(args[3]);
        ClusLogger.info("Branch: " + MAX_BRANCH);
        ClusLogger.info("Depth:  " + MAX_DEPTH);
        ClusLogger.info("Class:  " + MAX_CLASS);
        ClusLogger.info("Random: " + RND);
        ClusRandom.initialize(RND);
        ClassTerm root = GenerateData.createSimpleHierarchy();
        HierIO io = new HierIO();
        ClusLogger.info("Hierarchy:");
        io.writeHierarchy(root, ClusFormat.OUT_WRITER);
        SingleStat hb = new SingleStat();
        root.getMeanBranch(null, hb);
        ClusLogger.info("Mean branching factor: " + hb);
        MyArray cls = new MyArray();
        GenerateData.addClasses(root, cls);
        MyArray attr = new MyArray();
        GenerateData.addAttributes(root, attr);
        MyFile file = new MyFile("artificial.arff");
        file.log("@relation artificial");
        file.log();
        for (int i = 0; i < attr.size(); ++i) {
            ClassTerm at = (ClassTerm)attr.elementAt(i);
            for (int j = 0; j < at.getNbChildren(); ++j) {
                file.log("@attribute\t" + at + "_" + j + "\t{0,1}");
            }
        }
        file.log("@attribute\ttarget\tclasses");
        file.log();
        file.log("@data");
        ClassHierarchy hier = new ClassHierarchy(root);
        hier.numberHierarchy();
        MyArray target = new MyArray();
        boolean[] include = new boolean[hier.getTotal()];
        int nb_class = 0;
        SingleStat meb = new SingleStat();
        for (int i = 0; i < NB_DATA; ++i) {
            int j;
            StringBuffer buf = new StringBuffer();
            Arrays.fill(include, false);
            target.removeAllElements();
            int nb_classes = ClusRandom.nextInt(3, MAX_CLASS) + 1;
            for (j = 0; j < nb_classes; ++j) {
                boolean found = false;
                ClassTerm mcls = null;
                while (!found) {
                    int idx = ClusRandom.nextInt(3, cls.size());
                    mcls = (ClassTerm)cls.elementAt(idx);
                    if (include[mcls.getIndex()]) continue;
                    found = true;
                }
                target.addElement(mcls);
            }
            nb_class += nb_classes;
            meb.addMean(hier.getMeanBranch(include));
            for (j = 0; j < attr.size(); ++j) {
                int k;
                ClassTerm at = (ClassTerm)attr.elementAt(j);
                if (include[at.getIndex()]) {
                    for (k = 0; k < at.getNbChildren(); ++k) {
                        ClassTerm child = (ClassTerm)at.getChild(k);
                        if (include[child.getIndex()]) {
                            buf.append('1');
                        } else {
                            buf.append('0');
                        }
                        buf.append(',');
                    }
                    continue;
                }
                for (k = 0; k < at.getNbChildren(); ++k) {
                    int value = ClusRandom.nextInt(3, 2);
                    buf.append(value);
                    buf.append(',');
                }
            }
            for (j = 0; j < target.size(); ++j) {
                if (j != 0) {
                    buf.append('@');
                }
                buf.append(target.elementAt(j));
            }
            file.log(buf.toString());
        }
        file.close();
        SingleStat md = new SingleStat();
        GenerateData.calcMeanDepth(root, md);
        MyFile info = new MyFile("hier.info");
        info.log("Setting Mean Branch: " + MEAN_BRANCH);
        info.log("Hier Branch: " + hb);
        info.log("Hier Max Depth: " + MAX_DEPTH);
        info.log("Hier Mean Depth: " + md);
        info.log("Hier Nodes: " + attr.size());
        info.log("Hier Leaves: " + cls.size());
        info.log("Example Max Class: " + MAX_CLASS);
        double mean_cls = (double)nb_class / (double)NB_DATA;
        info.log("Example Mean Class: " + mean_cls);
        info.log("Example Branch: " + meb);
        info.log();
        io.writeHierarchy(root, info.getWriter());
        info.close();
    }
}

