/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util.cmdline;

import java.util.ArrayList;
import java.util.Hashtable;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.jeans.util.cmdline.CMDLineArgsProvider;

public class CMDLineArgs {
    protected CMDLineArgsProvider $prov;
    protected Hashtable<String, Object> $optargs = new Hashtable();
    protected String[] $mainargs;
    protected boolean $ok;
    protected int m_NbMainArgs;

    public CMDLineArgs(CMDLineArgsProvider prov) {
        this.$prov = prov;
        this.$mainargs = new String[prov.getNbMainArgs()];
    }

    public void process(String[] args) {
        int idx = 0;
        boolean done = false;
        String[] options = this.$prov.getOptionArgs();
        int[] arities = this.$prov.getOptionArgArities();
        while (idx < args.length && !done) {
            String arg = args[idx];
            if (arg.charAt(0) == '-' && arg.length() > 1) {
                ++idx;
                arg = arg.substring(1);
                boolean found = false;
                for (int i = 0; i < options.length && !found; ++i) {
                    if (!arg.equals(options[i])) continue;
                    int arity = arities[i];
                    if (args.length - idx >= arity) {
                        if (arity == 0) {
                            this.$optargs.put(arg, this);
                        } else if (arity == 1) {
                            this.$optargs.put(arg, args[idx++]);
                        } else {
                            String[] vals = new String[arity];
                            for (int j = 0; j < arity; ++j) {
                                vals[j] = args[idx + j];
                            }
                            idx += arity;
                            this.$optargs.put(arg, vals);
                        }
                    } else {
                        this.$prov.showHelp();
                        ClusLogger.info();
                        ClusLogger.info("Option -" + arg + " requires " + arity + " arguments");
                        return;
                    }
                    found = true;
                }
                if (found) continue;
                this.$prov.showHelp();
                ClusLogger.info();
                ClusLogger.info("Unknown option: -" + arg);
                return;
            }
            done = true;
        }
        int nbleft = args.length - idx;
        if (nbleft == this.$prov.getNbMainArgs()) {
            for (int i = 0; i < nbleft; ++i) {
                this.$mainargs[i] = args[idx + i];
            }
            this.$ok = true;
        }
        this.m_NbMainArgs = nbleft;
    }

    public boolean allOK() {
        return this.$ok;
    }

    public String getMainArg(int idx) {
        return this.$mainargs[idx];
    }

    public boolean hasOption(String option) {
        return this.$optargs.get(option) != null;
    }

    public String getOptionValue(String option) {
        return (String)this.$optargs.get(option);
    }

    public int getOptionInteger(String option) {
        return Integer.parseInt((String)this.$optargs.get(option));
    }

    public int getOptionInteger(String option, int min, int max) throws IllegalArgumentException {
        String val = (String)this.$optargs.get(option);
        try {
            int res = Integer.parseInt(val);
            if (res < min || res > max) {
                throw new IllegalArgumentException("Value " + val + " supplied for option '" + option + "' is out of range");
            }
            return res;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal value '" + val + "' supplied for option '" + option + "': expected integer");
        }
    }

    public double getOptionDouble(String option, double min, double max) throws IllegalArgumentException {
        String val = (String)this.$optargs.get(option);
        try {
            double res = Double.parseDouble(val);
            if (res < min || res > max) {
                throw new IllegalArgumentException("Value " + val + " supplied for option '" + option + "' is out of range");
            }
            return res;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal value '" + val + "' supplied for option '" + option + "': expected real");
        }
    }

    public int getNbMainArgs() {
        return this.m_NbMainArgs;
    }

    public ArrayList<Integer> getOptionList(String option) {
        String[] lst;
        ArrayList<Integer> values = new ArrayList<Integer>();
        String v = (String)this.$optargs.get(option);
        for (String s : lst = v.split(",")) {
            values.add(Integer.parseInt(s));
        }
        return values;
    }

    public String getOptionValue(String option, int index) {
        String[] vals = (String[])this.$optargs.get(option);
        return vals[index];
    }

    public String[] getOptionValues(String option) {
        return (String[])this.$optargs.get(option);
    }
}

