/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util.array;

import java.io.IOException;
import si.ijs.kt.clus.util.jeans.util.MStreamTokenizer;

public class MIntArray {
    protected int[] m_hArray;
    protected int m_lSize;
    protected int m_lLen;

    public MIntArray(int size) {
        this.m_hArray = new int[size];
        this.m_lSize = size;
        this.m_lLen = 0;
    }

    public MIntArray() {
        this.m_lSize = 0;
        this.m_lLen = 0;
    }

    public void read(MStreamTokenizer tokens, char st, char ed) throws IOException {
        tokens.readChar(st);
        int idx = 0;
        int ch = tokens.getCharToken();
        if (ch == ed) {
            this.m_lLen = 0;
            return;
        }
        tokens.pushBackChar(ch);
        do {
            int val = Integer.parseInt(tokens.readToken());
            if (idx >= this.m_lSize) {
                this.grow();
            }
            this.m_hArray[idx++] = val;
        } while ((ch = tokens.getCharToken()) != ed);
        this.m_lLen = idx;
    }

    public int[] toArray() {
        int[] nArr = new int[this.m_lLen];
        System.arraycopy(this.m_hArray, 0, nArr, 0, this.m_lLen);
        return nArr;
    }

    public int[] getArray() {
        return this.m_hArray;
    }

    public void clear() {
        this.m_lSize = 0;
        this.m_hArray = null;
    }

    public void grow() {
        int nSize = this.m_lSize * 3 / 2 + 10;
        int[] nArr = new int[nSize];
        if (this.m_hArray != null) {
            System.arraycopy(this.m_hArray, 0, nArr, 0, this.m_lSize);
        }
        this.m_lSize = nSize;
        this.m_hArray = nArr;
    }

    public String toString() {
        String str = "[";
        for (int ctr = 0; ctr < this.m_lLen; ++ctr) {
            if (ctr != 0) {
                str = str + ", ";
            }
            str = str + String.valueOf(this.m_hArray[ctr]);
        }
        return str + "]";
    }

    public static String toString(int[] arr) {
        String str = "[";
        for (int ctr = 0; ctr < arr.length; ++ctr) {
            if (ctr != 0) {
                str = str + ", ";
            }
            str = str + String.valueOf(arr[ctr]);
        }
        return str + "]";
    }

    public static void fillArray(int[] array, int val) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = val;
        }
    }
}

