/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util;

import java.io.Serializable;
import java.util.Arrays;

public class MyArray
implements Serializable {
    public static final long serialVersionUID = 1L;
    private Object[] m_Objects;
    private int m_Size;

    public MyArray() {
        this.m_Objects = new Object[0];
        this.m_Size = 0;
    }

    public MyArray(int cap) {
        this.m_Objects = new Object[cap];
        this.m_Size = 0;
    }

    public final void sort() {
        Arrays.sort(this.m_Objects, 0, this.m_Size);
    }

    public final void setSize(int size) {
        this.m_Objects = new Object[size];
    }

    public final void addElement(Object element) {
        if (this.m_Size == this.m_Objects.length) {
            Object[] newObjects = new Object[2 * this.m_Objects.length + 1];
            System.arraycopy(this.m_Objects, 0, newObjects, 0, this.m_Size);
            this.m_Objects = newObjects;
        }
        this.m_Objects[this.m_Size++] = element;
    }

    public final Object[] getObjects() {
        return this.m_Objects;
    }

    public final Object elementAt(int index) {
        return this.m_Objects[index];
    }

    public final void insertElementAt(Object element, int index) {
        if (this.m_Size < this.m_Objects.length) {
            System.arraycopy(this.m_Objects, index, this.m_Objects, index + 1, this.m_Size - index);
            this.m_Objects[index] = element;
        } else {
            Object[] nObjs = new Object[2 * this.m_Objects.length + 1];
            System.arraycopy(this.m_Objects, 0, nObjs, 0, index);
            nObjs[index] = element;
            System.arraycopy(this.m_Objects, index, nObjs, index + 1, this.m_Size - index);
            this.m_Objects = nObjs;
        }
        ++this.m_Size;
    }

    public final void removeElementAt(int index) {
        System.arraycopy(this.m_Objects, index + 1, this.m_Objects, index, this.m_Size - index - 1);
        this.m_Objects[--this.m_Size] = null;
    }

    public final void removeAllElements() {
        for (int i = 0; i < this.m_Size; ++i) {
            this.m_Objects[i] = null;
        }
        this.m_Size = 0;
    }

    public final void removeElement(Object element) {
        int index = 0;
        for (int i = 0; i < this.m_Size; ++i) {
            if (!this.m_Objects[i].equals(element)) continue;
            index = i;
        }
        this.removeElementAt(index);
    }

    public final void setElementAt(Object element, int index) {
        this.m_Objects[index] = element;
        if (index >= this.m_Size) {
            this.m_Size = index + 1;
        }
    }

    public final int size() {
        return this.m_Size;
    }

    public final void setCapacity(int cap) {
        Object[] newObjects = new Object[cap];
        System.arraycopy(this.m_Objects, 0, newObjects, 0, Math.min(cap, this.m_Size));
        this.m_Objects = newObjects;
        if (this.m_Objects.length < this.m_Size) {
            this.m_Size = this.m_Objects.length;
        }
    }

    public final void swap(int first, int second) {
        Object help = this.m_Objects[first];
        this.m_Objects[first] = this.m_Objects[second];
        this.m_Objects[second] = help;
    }

    public final void trimToSize() {
        Object[] newObjects = new Object[this.m_Size];
        System.arraycopy(this.m_Objects, 0, newObjects, 0, this.m_Size);
        this.m_Objects = newObjects;
    }
}

