/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import si.ijs.kt.clus.util.ClusLogger;

public class MultiDelimStringTokenizer {
    public static final String[] $example_delims = new String[]{"&nbsp;", "&", ";"};
    protected String[] $delims;
    protected String $line;
    protected int[] $delimpos;
    protected int[] $delimlen;
    protected int $pos;
    protected int $len;
    protected int $lastdelim = -1;

    MultiDelimStringTokenizer(String[] delims) {
        this.$delims = delims;
        this.$delimpos = new int[this.$delims.length];
        this.$delimlen = new int[this.$delims.length];
        for (int i = 0; i < this.$delims.length; ++i) {
            this.$delimlen[i] = this.$delims[i].length();
        }
    }

    public void setLine(String line) {
        this.$pos = 0;
        this.$line = line;
        this.$len = line.length();
        int delim = -1;
        while ((delim = this.checkDelim()) != -1) {
            this.$lastdelim = delim;
        }
    }

    public boolean hasMoreTokens() {
        return this.$pos < this.$len;
    }

    public String nextToken() {
        int delim = -1;
        boolean notdelim = true;
        StringBuffer token = new StringBuffer();
        while (this.$pos < this.$len && notdelim) {
            token.append(this.$line.charAt(this.$pos++));
            while ((delim = this.checkDelim()) != -1) {
                notdelim = false;
                this.$lastdelim = delim;
            }
        }
        return token.toString();
    }

    public int lastDelim() {
        return this.$lastdelim;
    }

    public int checkDelim() {
        int i;
        char ch = '\u0000';
        int mypos = this.$pos;
        int nbdelims = this.$delims.length;
        int is_delim = -1;
        for (i = 0; i < this.$delims.length; ++i) {
            this.$delimpos[i] = 0;
        }
        while (nbdelims > 0 && mypos <= this.$len) {
            if (mypos < this.$len) {
                ch = this.$line.charAt(mypos++);
            } else {
                is_delim = 0;
                this.$pos = ++mypos;
            }
            for (i = 0; i < this.$delims.length; ++i) {
                int delps = this.$delimpos[i];
                if (delps == -1) continue;
                char delch = this.$delims[i].charAt(delps);
                if (delch == ch) {
                    int n = i;
                    this.$delimpos[n] = this.$delimpos[n] + 1;
                    delps = this.$delimpos[n];
                    if (delps < this.$delimlen[i]) continue;
                    is_delim = i + 1;
                    this.$pos = mypos;
                    this.$delimpos[i] = -1;
                    --nbdelims;
                    continue;
                }
                this.$delimpos[i] = -1;
                --nbdelims;
            }
        }
        return is_delim;
    }

    public static void main(String[] args) {
        try {
            String line = null;
            MultiDelimStringTokenizer token = new MultiDelimStringTokenizer($example_delims);
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(new FileInputStream(args[0])));
            while ((line = reader.readLine()) != null) {
                token.setLine(line);
                while (token.hasMoreTokens()) {
                    ClusLogger.info(token.nextToken());
                }
            }
            reader.close();
        }
        catch (NullPointerException e) {
            ClusLogger.info("You must supply a file name!");
        }
        catch (IOException e) {
            ClusLogger.info("IO Error: " + e);
        }
    }
}

