/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util;

import java.io.IOException;

public abstract class MTokenizer {
    protected int lineno = 1;
    protected String pushbacktoken = null;
    protected boolean prevcr = false;
    protected int pushbackchar = -1;
    protected String chartokens = ":;,[]{}";
    protected int commentchar = 35;

    public String getToken() throws IOException {
        if (this.pushbacktoken == null) {
            int ch = this.readSignificantChar();
            if (ch != -1) {
                StringBuffer strg = new StringBuffer();
                boolean done = false;
                do {
                    strg.append((char)ch);
                    if (this.chartokens.indexOf((char)ch) == -1) {
                        ch = this.readChar();
                        if (ch == 32 || ch == 10 || ch == 13 || ch == -1 || ch == 9) {
                            this.pushBackChar(ch);
                            done = true;
                        }
                        if (this.chartokens.indexOf((char)ch) == -1) continue;
                        this.pushBackChar(ch);
                        done = true;
                        continue;
                    }
                    done = true;
                } while (!done);
                return strg.toString();
            }
            return null;
        }
        String betw = this.pushbacktoken;
        this.pushbacktoken = null;
        return betw;
    }

    public String readToken() throws IOException {
        int saveline = this.getLine();
        String token = this.getToken();
        if (token == null) {
            throw new IOException("Unexpected end of file at line: " + saveline);
        }
        return token;
    }

    public boolean hasMoreTokens() throws IOException {
        String token = this.getToken();
        if (token == null) {
            return false;
        }
        this.pushBackToken(token);
        return true;
    }

    public int readSignificantChar() throws IOException {
        int ch;
        do {
            if ((ch = this.readChar()) != this.commentchar) continue;
            while ((ch = this.readChar()) != -1 && ch != 10 && ch != 13) {
            }
        } while (ch == 32 || ch == 10 || ch == 13 || ch == 9);
        return ch;
    }

    public abstract int read();

    public int readChar() throws IOException {
        if (this.pushbackchar == -1) {
            int ch = this.read();
            if (ch == 10 && !this.prevcr) {
                ++this.lineno;
            }
            boolean bl = this.prevcr = ch == 13;
            if (this.prevcr) {
                ++this.lineno;
            }
            return ch;
        }
        int betw = this.pushbackchar;
        this.pushbackchar = -1;
        return betw;
    }

    public String readTillEol() throws IOException {
        int ch;
        StringBuffer strg = new StringBuffer();
        if (this.pushbacktoken == null) {
            ch = this.readSignificantChar();
            if (ch == -1) {
                return null;
            }
        } else {
            strg.append(this.pushbacktoken);
            this.pushbacktoken = null;
            ch = this.readChar();
        }
        while (ch != 10 && ch != 13 && ch != -1) {
            strg.append((char)ch);
            ch = this.readChar();
        }
        this.pushBackChar(ch);
        return strg.toString();
    }

    public int readInteger() throws IOException {
        int saveline = this.getLine();
        String token = this.readToken();
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            throw new IOException("Integer value expected at line: " + saveline);
        }
    }

    public float readFloat() throws IOException {
        int saveline = this.getLine();
        String token = this.readToken();
        try {
            Float fl = new Float(token);
            return fl.floatValue();
        }
        catch (NumberFormatException e) {
            throw new IOException("Float value expected at line: " + saveline);
        }
    }

    public String isNextTokenIn(String strg) throws IOException {
        String token = this.getToken();
        if (token == null || strg.indexOf(token) != -1) {
            return token;
        }
        this.pushBackToken(token);
        return null;
    }

    public boolean isNextToken(String strg) throws IOException {
        boolean yes = false;
        String token = this.getToken();
        if (token == null) {
            return false;
        }
        if (token.equals(strg)) {
            yes = true;
        } else {
            this.pushBackToken(token);
        }
        return yes;
    }

    public int readChar(String which) throws IOException {
        int saveline = this.getLine();
        String character = this.getToken();
        if (character == null) {
            throw new IOException("Unexpected end of file reading character at line: " + saveline);
        }
        int idx = which.indexOf(character.charAt(0));
        if (idx < 0 || character.length() != 1) {
            throw new IOException("Character '" + which + "' expected at line: " + saveline);
        }
        return idx;
    }

    public void readChar(char ch) throws IOException {
        int saveline = this.getLine();
        String character = this.getToken();
        if (character == null) {
            throw new IOException("Unexpected end of file reading character at line: " + saveline);
        }
        if (!character.equals(String.valueOf(ch))) {
            throw new IOException("Character '" + ch + "' expected at line: " + saveline);
        }
    }

    public void pushBackChar(int ch) {
        this.pushbackchar = ch;
    }

    public void pushBackToken(String token) {
        this.pushbacktoken = token;
    }

    public String setCharTokens(String chartokens) {
        String result = this.chartokens;
        this.chartokens = chartokens;
        return result;
    }

    public int setCommentChar(int commentchar) {
        int result = this.commentchar;
        this.commentchar = commentchar;
        return result;
    }

    public String getCharTokens() {
        return this.chartokens;
    }

    public int setCommentChar() {
        return this.commentchar;
    }

    public int getLine() {
        return this.lineno;
    }
}

