/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public class MStreamTokenizer {
    protected Reader reader;
    protected int lineno;
    protected String pushbacktoken;
    protected int pushbackchar;
    protected String chartokens;
    protected int commentchar;
    protected boolean septype;
    protected long position;
    protected String filename;

    public MStreamTokenizer() {
    }

    public MStreamTokenizer(String fname) throws FileNotFoundException {
        this(new FileInputStream(fname));
        this.filename = fname;
    }

    public MStreamTokenizer(InputStream stream) {
        this(new InputStreamReader(stream));
    }

    public MStreamTokenizer(Reader myreader) {
        this.reader = new BufferedReader(myreader);
        this.init();
    }

    public String getFileName() {
        return this.filename;
    }

    public String getFileNameForErrorMsg() {
        if (this.filename == null) {
            return "";
        }
        return " while reading '" + this.filename + "'";
    }

    public static MStreamTokenizer createStringParser(String strg) {
        MStreamTokenizer tokens = new MStreamTokenizer();
        tokens.reader = new StringReader(strg);
        tokens.init();
        return tokens;
    }

    private final void init() {
        this.lineno = 1;
        this.pushbacktoken = null;
        this.septype = true;
        this.pushbackchar = -1;
        this.chartokens = ":;,[]{}";
        this.commentchar = 35;
    }

    public final void setSeparatorType(boolean dontUseSpace) {
        this.septype = dontUseSpace;
    }

    public final boolean isSeparator(int ch) {
        if (this.septype) {
            return ch == 32 || ch == 10 || ch == -1 || ch == 9;
        }
        return ch == 10 || ch == -1;
    }

    public final boolean isRealSeparator(int ch) {
        if (this.septype) {
            return ch == 32 || ch == 10 || ch == 9;
        }
        return ch == 10;
    }

    public final String getToken() throws IOException {
        if (this.pushbacktoken == null) {
            int ch = this.readSignificantChar();
            if (ch != -1) {
                StringBuffer strg = new StringBuffer();
                boolean done = false;
                do {
                    strg.append((char)ch);
                    if (this.chartokens.indexOf((char)ch) == -1) {
                        ch = this.readChar();
                        if (this.isSeparator(ch)) {
                            this.pushBackChar(ch);
                            done = true;
                        }
                        if (this.chartokens.indexOf((char)ch) == -1) continue;
                        this.pushBackChar(ch);
                        done = true;
                        continue;
                    }
                    done = true;
                } while (!done);
                return strg.toString();
            }
            return null;
        }
        String betw = this.pushbacktoken;
        this.pushbacktoken = null;
        return betw;
    }

    public final String getDelimToken(char opendelim, char closedelim) throws IOException {
        int ch = this.readSignificantChar();
        if (ch == opendelim) {
            int depth = 0;
            StringBuffer strg = new StringBuffer();
            ch = this.readCharNoPushback();
            while (ch != closedelim || depth > 0) {
                if (ch == opendelim) {
                    ++depth;
                }
                if (ch != closedelim || depth > 0) {
                    strg.append((char)ch);
                }
                if (ch == closedelim) {
                    --depth;
                }
                ch = this.readCharNoPushback();
            }
            return strg.toString();
        }
        int ch2 = this.readChar();
        if (this.isRealSeparator(ch2)) {
            return String.valueOf((char)ch);
        }
        this.pushBackChar(ch2);
        return String.valueOf((char)ch) + this.getToken();
    }

    public final int getCharToken() throws IOException {
        if (this.pushbacktoken == null) {
            return this.readSignificantChar();
        }
        String betw = this.pushbacktoken;
        int len = betw.length();
        if (len >= 2) {
            this.pushbacktoken = betw.substring(1);
            return betw.charAt(0);
        }
        this.pushbacktoken = null;
        return betw.charAt(0);
    }

    public final long getPosition() {
        return this.position;
    }

    public final void gotoPosition(long pos) throws IOException {
        this.reader.skip(pos - this.position);
    }

    public final String readToken() throws IOException {
        int saveline = this.getLine();
        String token = this.getToken();
        if (token == null) {
            throw new IOException("Unexpected end of file at line: " + saveline);
        }
        return token;
    }

    public final boolean hasMoreTokens() throws IOException {
        String token = this.getToken();
        if (token == null) {
            return false;
        }
        this.pushBackToken(token);
        return true;
    }

    public final int readSignificantChar() throws IOException {
        int ch;
        do {
            if ((ch = this.readChar()) != this.commentchar) continue;
            while ((ch = this.readCharNoPushback()) != -1 && ch != 10) {
            }
        } while (this.isRealSeparator(ch));
        return ch;
    }

    public final int readChar() throws IOException {
        if (this.pushbackchar == -1) {
            int ch = this.reader.read();
            ++this.position;
            if (ch == 13) {
                ch = this.reader.read();
                ++this.position;
            }
            if (ch == 10) {
                ++this.lineno;
            }
            return ch;
        }
        int betw = this.pushbackchar;
        this.pushbackchar = -1;
        return betw;
    }

    public final int readCharNoPushback() throws IOException {
        int ch = this.reader.read();
        ++this.position;
        if (ch == 13) {
            ch = this.reader.read();
            ++this.position;
        }
        if (ch == 10) {
            ++this.lineno;
        }
        return ch;
    }

    public final void skipTillLine(int line) throws IOException {
        while (this.lineno < line) {
            this.readChar();
        }
    }

    public final boolean skipTillLine(String line) throws IOException {
        int len = line.length();
        int ch = this.readChar();
        char first = line.charAt(0);
        while (true) {
            if (ch == first && len >= 2) {
                int idx;
                ch = this.readCharNoPushback();
                for (idx = 1; idx < len - 1 && ch == line.charAt(idx); ++idx) {
                    ch = this.readCharNoPushback();
                }
                if (idx == len - 1) {
                    return true;
                }
            }
            if (ch == -1) {
                return false;
            }
            while (ch != 10 && ch != -1) {
                ch = this.readCharNoPushback();
            }
            if (ch == -1) {
                return false;
            }
            ch = this.readCharNoPushback();
        }
    }

    public final String readTillEol() throws IOException {
        int ch;
        StringBuffer strg = new StringBuffer();
        if (this.pushbacktoken == null) {
            ch = this.readSignificantChar();
            if (ch == -1) {
                return null;
            }
        } else {
            strg.append(this.pushbacktoken);
            this.pushbacktoken = null;
            ch = this.readChar();
        }
        while (ch != 10 && ch != -1) {
            strg.append((char)ch);
            ch = this.readCharNoPushback();
        }
        this.pushBackChar(ch);
        return strg.toString();
    }

    public final int readInteger() throws IOException {
        int saveline = this.getLine();
        String token = this.readToken();
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            throw new IOException("Integer value expected at line: " + saveline);
        }
    }

    public final float readFloat() throws IOException {
        int saveline = this.getLine();
        String token = this.readToken();
        try {
            Float fl = new Float(token);
            return fl.floatValue();
        }
        catch (NumberFormatException e) {
            throw new IOException("Float value expected at line: " + saveline);
        }
    }

    public final String isNextTokenIn(String strg) throws IOException {
        String token = this.getToken();
        if (token == null || strg.indexOf(token) != -1) {
            return token;
        }
        this.pushBackToken(token);
        return null;
    }

    public final boolean isNextToken(String strg) throws IOException {
        boolean yes = false;
        String token = this.getToken();
        if (token == null) {
            return false;
        }
        if (token.equals(strg)) {
            yes = true;
        } else {
            this.pushBackToken(token);
        }
        return yes;
    }

    public final boolean isNextToken(char ch) throws IOException {
        return this.isNextToken(String.valueOf(ch));
    }

    public final int readChar(String which) throws IOException {
        int character = this.getCharToken();
        if (character == -1) {
            throw new IOException("Unexpected end of file reading character at line: " + this.getLine());
        }
        int idx = which.indexOf(character);
        if (idx < 0) {
            throw new IOException("Character '" + which + "' expected at line: " + this.getLine() + " (found '" + (char)character + "')");
        }
        return idx;
    }

    public final void readChar(char ch) throws IOException {
        int character = this.getCharToken();
        if (character == -1) {
            throw new IOException("Unexpected end of file reading character at line: " + this.getLine());
        }
        if (character != ch) {
            throw new IOException("Character '" + ch + "' expected at line: " + this.getLine() + " (found '" + (char)character + "')");
        }
    }

    public final void pushBackChar(int ch) {
        this.pushbackchar = ch;
    }

    public final void pushBackToken(String token) {
        this.pushbacktoken = token;
    }

    public final String setCharTokens(String chartokens) {
        String result = this.chartokens;
        this.chartokens = chartokens;
        return result;
    }

    public final int setCommentChar(int commentchar) {
        int result = this.commentchar;
        this.commentchar = commentchar;
        return result;
    }

    public final String getCharTokens() {
        return this.chartokens;
    }

    public final int setCommentChar() {
        return this.commentchar;
    }

    public final int getLine() {
        return this.lineno;
    }

    public final Reader getReader() {
        return this.reader;
    }

    public final void close() throws IOException {
        this.reader.close();
    }

    public String toString() {
        return "MStreamTokenizer [" + this.commentchar + "] [" + this.chartokens + "]";
    }
}

