/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util;

import java.util.Enumeration;
import si.ijs.kt.clus.util.jeans.util.GeneralException;

public class MSStringTokenizer
implements Enumeration {
    public static final int NUMBER = 0;
    public static final int ALPHA = 1;
    public static final int SPECIAL = 2;
    public static final int SPACE = 3;
    public static final int CONTROL = 4;
    public static final int FLOAT = 5;
    public static final int GROUP = 6;
    private String strg;
    private int pos;
    private int prevpos;
    private int len;
    private int typegroup;

    public MSStringTokenizer(String strg) {
        this.strg = strg;
        this.len = strg.length();
        this.skipControlsAndSpaces();
    }

    public int getGroup(char ch) {
        if (Character.isDigit(ch)) {
            return 0;
        }
        if (Character.isLetter(ch)) {
            return 1;
        }
        if (ch == '_') {
            return 1;
        }
        if (ch == '(' || ch == ')') {
            return 6;
        }
        if (Character.isSpaceChar(ch)) {
            return 3;
        }
        if (Character.isISOControl(ch)) {
            return 4;
        }
        return 2;
    }

    public String nextToken() {
        int group;
        StringBuffer buffer = new StringBuffer();
        this.prevpos = this.pos;
        char ch = this.strg.charAt(this.pos);
        int prevgroup = this.typegroup = (group = this.getGroup(ch));
        while (group == prevgroup && this.pos < this.len) {
            buffer.append(ch);
            ++this.pos;
            if (this.pos >= this.len) continue;
            ch = this.strg.charAt(this.pos);
            prevgroup = group;
            group = this.getGroup(ch);
        }
        this.skipControlsAndSpaces();
        return buffer.toString();
    }

    public String nextGroupToken() throws GeneralException {
        StringBuffer buffer = new StringBuffer();
        this.prevpos = this.pos;
        char ch = this.strg.charAt(this.pos);
        int group = this.getGroup(ch);
        int level = 0;
        int prevgroup = this.typegroup = group;
        while ((level > 0 || group == prevgroup) && this.pos < this.len) {
            if (ch == ')') {
                --level;
            }
            if (level > 0 || group != 6) {
                buffer.append(ch);
            }
            if (ch == '(') {
                ++level;
            }
            if (++this.pos >= this.len) continue;
            ch = this.strg.charAt(this.pos);
            prevgroup = group;
            group = this.getGroup(ch);
        }
        if (level > 0) {
            throw new GeneralException("'(,)' don't match.");
        }
        this.skipControlsAndSpaces();
        return buffer.toString();
    }

    public String nextNumberToken() {
        StringBuffer buffer = new StringBuffer();
        boolean done = false;
        int prevChar = 0;
        this.prevpos = this.pos;
        this.typegroup = 0;
        do {
            char ch = Character.toUpperCase(this.strg.charAt(this.pos));
            done = true;
            if (Character.isDigit(ch)) {
                done = false;
            } else if (ch == 'E' || ch == '.') {
                done = false;
                this.typegroup = 5;
            } else if (!(ch != '+' && ch != '-' || prevChar != 0 && prevChar != 69)) {
                done = false;
            }
            if (done) continue;
            buffer.append(ch);
            ++this.pos;
            if (this.pos >= this.len) {
                done = true;
            }
            if (done) continue;
            prevChar = ch;
            ch = Character.toUpperCase(this.strg.charAt(this.pos));
        } while (!done);
        this.skipControlsAndSpaces();
        return buffer.toString();
    }

    public int getPosition() {
        return this.prevpos;
    }

    public boolean hasMoreTokens() {
        return this.hasMoreElements();
    }

    public int getGroup() {
        return this.typegroup;
    }

    public void pushBack() {
        this.pos = this.prevpos;
    }

    @Override
    public boolean hasMoreElements() {
        return this.pos < this.len;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    private void skipControlsAndSpaces() {
        if (this.pos < this.len) {
            char ch = this.strg.charAt(this.pos);
            int group = this.getGroup(ch);
            while ((group == 3 || group == 4) && this.pos < this.len) {
                ++this.pos;
                ch = this.strg.charAt(this.pos);
                group = this.getGroup(ch);
            }
        }
    }
}

