/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import si.ijs.kt.clus.util.jeans.util.Interval;
import si.ijs.kt.clus.util.jeans.util.MultiDelimStringTokenizer;

public class IntervalCollection
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final IntervalCollection EMPTY = new IntervalCollection();
    protected static final String[] DELIMS = new String[]{"-", ","};
    protected int m_Total;
    protected int m_CrInt;
    protected boolean m_Done;
    protected boolean m_Default;
    protected ArrayList m_Interval = new ArrayList();

    public int getTotal() {
        return this.m_Total;
    }

    public IntervalCollection(String str) {
        if (str.toUpperCase().equals("DEFAULT")) {
            this.m_Default = true;
            return;
        }
        if (!str.toUpperCase().equals("NONE") && !str.toUpperCase().equals("EMPTY")) {
            ArrayList<Interval> intervals = new ArrayList<Interval>();
            MultiDelimStringTokenizer tok = new MultiDelimStringTokenizer(DELIMS);
            tok.setLine(str);
            int first = -1;
            int last = -1;
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int delim = tok.lastDelim();
                first = Integer.parseInt(token);
                if (delim == 1) {
                    if (tok.hasMoreTokens()) {
                        token = tok.nextToken();
                        last = Integer.parseInt(token);
                    } else {
                        last = first;
                    }
                } else {
                    last = first;
                }
                intervals.add(new Interval(first, last));
            }
            this.initializeFromBits(IntervalCollection.toBits(intervals));
        }
    }

    protected IntervalCollection() {
    }

    public boolean isDefault() {
        return this.m_Default;
    }

    public void clear() {
        this.m_Default = false;
        this.m_Interval.clear();
        this.computeTotal();
    }

    public void addInterval(int first, int last) {
        this.m_Interval.add(new Interval(first, last));
        this.computeTotal();
    }

    public int getNbIntervals() {
        return this.m_Interval.size();
    }

    public Interval getInterval(int idx) {
        return (Interval)this.m_Interval.get(idx);
    }

    public void copyFrom(IntervalCollection other) {
        this.m_Interval.clear();
        for (int i = 0; i < other.getNbIntervals(); ++i) {
            this.m_Interval.add(other.getInterval(i));
        }
        this.computeTotal();
    }

    public void subtract(IntervalCollection other) {
        int max = Math.max(this.getMaxIndex(), other.getMaxIndex());
        boolean[] bits = new boolean[max + 1];
        this.toBits(bits);
        other.subtractFromBits(bits);
        this.initializeFromBits(bits);
    }

    public void add(boolean[] bits) {
        boolean[] this_bits = new boolean[Math.max(this.getMaxIndex() + 1, bits.length)];
        this.toBits(this_bits);
        for (int i = 0; i < bits.length; ++i) {
            if (!bits[i]) continue;
            this_bits[i] = true;
        }
        this.initializeFromBits(this_bits);
    }

    public void initializeFromBits(boolean[] bits) {
        this.m_Interval.clear();
        boolean is_in = false;
        int start = -1;
        for (int i = 0; i < bits.length; ++i) {
            if (bits[i]) {
                if (is_in) continue;
                start = i;
                is_in = true;
                continue;
            }
            if (!is_in) continue;
            this.m_Interval.add(new Interval(start, i - 1));
            is_in = false;
        }
        if (is_in) {
            this.m_Interval.add(new Interval(start, bits.length - 1));
        }
        this.computeTotal();
    }

    public void toBits(boolean[] bits) {
        IntervalCollection.toBits(this.m_Interval, bits);
    }

    public static void toBits(ArrayList intervals, boolean[] bits) {
        for (int i = 0; i < intervals.size(); ++i) {
            Interval interv = (Interval)intervals.get(i);
            interv.toBits(bits);
        }
    }

    public boolean[] toBits() {
        return IntervalCollection.toBits(this.m_Interval);
    }

    public static boolean[] toBits(ArrayList intervals) {
        boolean[] bits = new boolean[IntervalCollection.getMaxIndex(intervals) + 1];
        IntervalCollection.toBits(intervals, bits);
        return bits;
    }

    public void subtractFromBits(boolean[] bits) {
        for (int i = 0; i < this.getNbIntervals(); ++i) {
            Interval interv = this.getInterval(i);
            interv.subtractFromBits(bits);
        }
    }

    public int getMaxIndex() {
        return IntervalCollection.getMaxIndex(this.m_Interval);
    }

    public static int getMaxIndex(ArrayList intervals) {
        int max = 0;
        for (int i = 0; i < intervals.size(); ++i) {
            Interval interv = (Interval)intervals.get(i);
            max = Math.max(max, interv.getLast());
        }
        return max;
    }

    public int getMinIndex() {
        return IntervalCollection.getMinIndex(this.m_Interval);
    }

    public static int getMinIndex(ArrayList intervals) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < intervals.size(); ++i) {
            Interval interv = (Interval)intervals.get(i);
            min = Math.min(min, interv.getFirst());
        }
        return min;
    }

    public boolean isEmpty() {
        return this.m_Interval.size() == 0;
    }

    public void reset() {
        this.m_CrInt = -1;
        this.m_Done = this.gotoNext();
    }

    public boolean hasMoreInts() {
        return this.m_Done;
    }

    public int nextInt() {
        int res = this.getInterval(this.m_CrInt).get();
        this.m_Done = this.gotoNext();
        return res;
    }

    public boolean gotoNext() {
        if (this.m_CrInt != -1) {
            this.getInterval(this.m_CrInt).incr();
        }
        if (this.m_CrInt == -1 || this.getInterval(this.m_CrInt).atEnd()) {
            ++this.m_CrInt;
            if (this.m_CrInt >= this.getNbIntervals()) {
                return false;
            }
            this.getInterval(this.m_CrInt).reset();
        }
        return true;
    }

    public String toString() {
        if (this.getNbIntervals() > 0) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.getNbIntervals(); ++i) {
                Interval interv = this.getInterval(i);
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(interv.toString());
            }
            return buf.toString();
        }
        return "None";
    }

    protected void computeTotal() {
        int total = 0;
        for (int i = 0; i < this.m_Interval.size(); ++i) {
            Interval interv = (Interval)this.m_Interval.get(i);
            total += interv.getSize();
        }
        this.m_Total = total;
    }

    public int[] toIndices() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < this.getNbIntervals(); ++i) {
            int from = this.getInterval(i).getFirst();
            int to = this.getInterval(i).getLast();
            for (int attrInd = from; attrInd <= to; ++attrInd) {
                indices.add(attrInd);
            }
        }
        int[] indicesArray = new int[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            indicesArray[i] = (Integer)indices.get(i);
        }
        Arrays.sort(indicesArray);
        return indicesArray;
    }
}

