/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import si.ijs.kt.clus.util.jeans.util.ExtensionFilter;

public class FileUtil {
    public static String getExtension(File f) {
        return FileUtil.getExtension(f.getName());
    }

    public static File getCurrentDir() {
        return new File(".");
    }

    public static String cmbPath(String path, String fname) {
        if (path.endsWith("/") || path.endsWith("\\")) {
            return FileUtil.normPath(path + fname);
        }
        return FileUtil.normPath(path + File.separator + fname);
    }

    public static String normPath(String path) {
        if (File.separatorChar == '/') {
            return path.replace('\\', File.separatorChar);
        }
        return path.replace('/', File.separatorChar);
    }

    public static String getCurrentDirectory() throws IOException {
        return FileUtil.getCurrentDir().getCanonicalPath();
    }

    public static String addExtension(String fname, String ext) {
        String myext = FileUtil.getExtension(fname);
        if (myext == null || !myext.equals(ext)) {
            return fname + "." + ext;
        }
        return fname;
    }

    public static String getExtension(String s) {
        String ext = null;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getName(String s) {
        String name = s;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            name = s.substring(0, i);
        }
        return name;
    }

    public static void delete(String fname) {
        File file = new File(fname);
        file.delete();
    }

    public static void mkdir(String fname) {
        File file = new File(fname);
        file.mkdirs();
    }

    public static boolean fileExists(String fname) {
        File file = new File(fname);
        return file.exists();
    }

    public static boolean isNewerOrEqual(String newFile, String oldFile) {
        File newF = new File(newFile);
        File oldF = new File(oldFile);
        if (!newF.exists()) {
            return false;
        }
        if (!oldF.exists()) {
            return true;
        }
        return newF.lastModified() >= oldF.lastModified();
    }

    public static String removePath(String s) {
        String name = s;
        int i = s.lastIndexOf(File.separatorChar);
        if (i >= 0 && i < s.length() - 1) {
            name = s.substring(i + 1);
        }
        return name;
    }

    public static String getPath(String s) {
        int i = s.lastIndexOf(File.separatorChar);
        if (i >= 0 && i < s.length() - 1) {
            return FileUtil.trimDirSeparator(s.substring(0, i));
        }
        return null;
    }

    public static String trimDirSeparator(String s) {
        int len = s.length();
        if (len > 0 && s.charAt(len - 1) == File.separatorChar) {
            return s.substring(0, len - 1);
        }
        return s;
    }

    public static String relativePath(String abs, String prefix) {
        int pos = abs.indexOf(prefix);
        int from = prefix.length() + 1;
        if (pos == 0 && from < abs.length()) {
            return abs.substring(from);
        }
        return abs;
    }

    public static boolean isAbsolutePath(String fname) {
        if (fname.length() > 0) {
            if (fname.charAt(0) == File.separatorChar) {
                return true;
            }
            return fname.length() >= 3 && fname.charAt(1) == ':' && (fname.charAt(2) == File.separatorChar || fname.charAt(2) == '/');
        }
        return false;
    }

    public static String[] dirList(String dirname) throws FileNotFoundException {
        File directory = new File(dirname);
        if (directory != null && directory.isDirectory()) {
            return directory.list();
        }
        throw new FileNotFoundException();
    }

    public static ArrayList recursiveFind(File dir, String pattern) throws IOException {
        ArrayList res = new ArrayList();
        if (dir.isDirectory()) {
            FileUtil.recursiveFindAll(dir, pattern, res);
        }
        return res;
    }

    public static void recursiveFindAll(File dir, String pattern, ArrayList res) throws IOException {
        String[] list = dir.list();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            File file;
            String full = FileUtil.cmbPath(dir.getCanonicalPath(), list[i]);
            if (list[i].endsWith(pattern)) {
                res.add(full);
            }
            if (!(file = new File(full)).isDirectory()) continue;
            FileUtil.recursiveFindAll(file, pattern, res);
        }
    }

    public static String[] dirList(String dirname, String extension) throws FileNotFoundException {
        File directory = new File(dirname);
        if (directory != null && directory.isDirectory()) {
            return directory.list(new ExtensionFilter(extension));
        }
        throw new FileNotFoundException();
    }

    public static String[] readTextFile(String filename) throws FileNotFoundException, IOException {
        String line;
        Vector<String> lines = new Vector<String>();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        do {
            if ((line = in.readLine()) == null) continue;
            lines.addElement(line);
        } while (line != null);
        in.close();
        String[] text = new String[lines.size()];
        int idx = 0;
        Enumeration e = lines.elements();
        while (e.hasMoreElements()) {
            text[idx++] = (String)e.nextElement();
        }
        return text;
    }
}

