/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.util;

public class DisjointSetForest {
    protected int m_Size;
    protected int[] m_P;
    protected int[] m_Rank;
    protected int[] m_ComprTable;
    protected int[] m_Map;

    public DisjointSetForest(int size) {
        this.m_Size = size;
        this.m_P = new int[size];
        this.m_Rank = new int[size];
        this.m_ComprTable = new int[size];
        this.m_Map = new int[size];
        for (int i = 0; i < size; ++i) {
            this.m_Map[i] = -1;
        }
    }

    public void makeSets(int nb) {
        for (int i = 0; i < nb; ++i) {
            this.makeSet(i);
        }
    }

    public void makeSet(int x) {
        this.m_P[x] = x;
        this.m_Rank[x] = 0;
    }

    public void union(int x, int y) {
        this.link(this.findSet(x), this.findSet(y));
    }

    public void link(int x, int y) {
        if (this.m_Rank[x] > this.m_Rank[y]) {
            this.m_P[y] = x;
        } else {
            this.m_P[x] = y;
            if (this.m_Rank[x] == this.m_Rank[y]) {
                int n = y;
                this.m_Rank[n] = this.m_Rank[n] + 1;
            }
        }
    }

    public int findSet(int x) {
        int idx = 0;
        while (this.m_P[x] != x) {
            this.m_ComprTable[idx++] = x;
            x = this.m_P[x];
        }
        while (idx > 0) {
            this.m_P[this.m_ComprTable[--idx]] = x;
        }
        return x;
    }

    public int getComponent(int x) {
        return this.m_Map[this.findSet(x)];
    }

    public int numberComponents() {
        int idx = 0;
        for (int i = 0; i < this.m_Size; ++i) {
            int x = this.findSet(i);
            if (this.m_Map[x] != -1) continue;
            this.m_Map[x] = idx++;
        }
        return idx;
    }
}

