/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.tree;

import si.ijs.kt.clus.util.jeans.tree.Node;
import si.ijs.kt.clus.util.jeans.util.IntegerStack;

public class TreeIterator {
    private Node node;
    private IntegerStack stack;
    private int index;

    public TreeIterator(Node node) {
        this.index = 0;
        this.node = node;
        this.stack = new IntegerStack();
    }

    public TreeIterator(TreeIterator iter) {
        this.index = iter.index;
        this.node = iter.node;
        this.stack = new IntegerStack(iter.stack);
    }

    public void reset() {
        this.stack.clear();
        this.index = 0;
    }

    public boolean atBottomLevel() {
        return this.node.atBottomLevel();
    }

    public boolean atTopLevel() {
        return this.stack.isEmpty();
    }

    public Node getNode() {
        return this.node;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLevel() {
        return this.stack.getSize();
    }

    public void goUp() {
        this.node = this.node.getParent();
        this.index = this.stack.pop();
    }

    public void goDown(int child) {
        this.stack.push(this.index);
        this.node = this.node.getChild(child);
        this.index = child;
    }
}

