/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.tree;

import java.io.PrintWriter;
import java.io.Serializable;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.tree.Node;
import si.ijs.kt.clus.util.jeans.util.MyArray;

public class MyNode
implements Node,
Serializable {
    public static final long serialVersionUID = 1L;
    protected MyArray m_Children = new MyArray();
    protected Node m_Parent;

    public MyNode() {
    }

    public MyNode(Node parent) {
        this.m_Parent = parent;
    }

    public MyNode getRoot() {
        if (this.m_Parent == null) {
            return this;
        }
        return ((MyNode)this.m_Parent).getRoot();
    }

    public final int[] getPath() {
        Node node = this;
        int d = this.getLevel();
        int[] path = new int[d];
        for (int i = 0; i < d; ++i) {
            Node parent = node.getParent();
            path[i] = ((MyNode)parent).indexOf(node);
            node = parent;
        }
        return path;
    }

    public final MyNode fromPath(int[] path, int skip) {
        MyNode crnode = this;
        for (int i = path.length - 1 - skip; i >= 0; --i) {
            int pos = path[i];
            if (pos < 0 || pos >= crnode.getNbChildren()) {
                return null;
            }
            crnode = (MyNode)crnode.getChild(pos);
        }
        return crnode;
    }

    public final int indexOf(Node child) {
        for (int i = 0; i < this.getNbChildren(); ++i) {
            if (child != this.getChild(i)) continue;
            return i;
        }
        return -1;
    }

    public boolean equalsPath(int[] path) {
        int[] mypath = this.getPath();
        if (mypath.length != path.length) {
            return false;
        }
        for (int i = 0; i < path.length; ++i) {
            if (mypath[i] == path[i]) continue;
            return false;
        }
        return true;
    }

    public static void showPath(int[] path, PrintWriter out) {
        for (int i = 0; i < path.length; ++i) {
            if (i != 0) {
                out.print(",");
            }
            out.print(path[i]);
        }
    }

    public static void showPath(int[] path) {
        for (int i = 0; i < path.length; ++i) {
            if (i != 0) {
                System.out.print(",");
            }
            System.out.print(path[i]);
        }
    }

    public MyNode cloneNode() throws ClusException {
        return new MyNode();
    }

    @Override
    public final void addChild(Node node) {
        node.setParent(this);
        this.m_Children.addElement(node);
    }

    public final void setChild(Node node, int idx) {
        node.setParent(this);
        this.m_Children.setElementAt(node, idx);
    }

    @Override
    public final void removeChild(Node node) {
        node.setParent(null);
        this.m_Children.removeElement(node);
    }

    public final void removeChild(int idx) {
        MyNode child = (MyNode)this.getChild(idx);
        if (child != null) {
            child.setParent(null);
        }
        this.m_Children.removeElementAt(idx);
    }

    public final void removeAllChildren() {
        int nb = this.getNbChildren();
        for (int i = 0; i < nb; ++i) {
            Node node = this.getChild(i);
            node.setParent(null);
        }
        this.m_Children.removeAllElements();
    }

    @Override
    public final Node getParent() {
        return this.m_Parent;
    }

    @Override
    public final void setParent(Node parent) {
        this.m_Parent = parent;
    }

    @Override
    public final Node getChild(int idx) {
        return (Node)this.m_Children.elementAt(idx);
    }

    @Override
    public final int getNbChildren() {
        return this.m_Children.size();
    }

    public final void setNbChildren(int nb) {
        this.m_Children.setSize(nb);
    }

    @Override
    public final boolean atTopLevel() {
        return this.m_Parent == null;
    }

    @Override
    public final boolean atBottomLevel() {
        return this.m_Children.size() == 0;
    }

    public final MyNode cloneTree() throws ClusException {
        MyNode clone = this.cloneNode();
        int arity = this.getNbChildren();
        clone.setNbChildren(arity);
        for (int i = 0; i < arity; ++i) {
            MyNode node = (MyNode)this.getChild(i);
            clone.setChild(node.cloneTree(), i);
        }
        return clone;
    }

    public final MyNode cloneTree(MyNode n1, MyNode n2) throws ClusException {
        if (n1 == this) {
            return n2;
        }
        MyNode clone = this.cloneNode();
        int arity = this.getNbChildren();
        clone.setNbChildren(arity);
        for (int i = 0; i < arity; ++i) {
            MyNode node = (MyNode)this.getChild(i);
            clone.setChild(node.cloneTree(n1, n2), i);
        }
        return clone;
    }

    @Override
    public final int getLevel() {
        int depth = 0;
        for (Node node = this.getParent(); node != null; node = node.getParent()) {
            ++depth;
        }
        return depth;
    }

    public final int getMaxLeafDepth() {
        int nb = this.getNbChildren();
        if (nb == 0) {
            return 1;
        }
        int max = 0;
        for (int i = 0; i < nb; ++i) {
            MyNode node = (MyNode)this.getChild(i);
            max = Math.max(max, node.getMaxLeafDepth());
        }
        return max + 1;
    }
}

