/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.tree;

import si.ijs.kt.clus.util.jeans.tree.Node;
import si.ijs.kt.clus.util.jeans.tree.TreeIterator;

public class LeafTreeIterator
extends TreeIterator {
    private boolean busy = true;
    private boolean advanced = false;
    private int cr_level = 0;
    private Node cr_node = null;

    public LeafTreeIterator(Node node) {
        super(node);
    }

    public LeafTreeIterator(LeafTreeIterator other) {
        super(other);
        this.busy = other.busy;
        this.advanced = other.advanced;
        this.cr_level = other.cr_level;
        this.cr_node = other.cr_node;
    }

    @Override
    public void reset() {
        super.reset();
        this.busy = true;
        this.advanced = false;
    }

    public Node getNextNode() {
        if (!this.advanced) {
            this.gotoNextNode();
        }
        this.advanced = false;
        return this.cr_node;
    }

    public boolean hasMoreNodes() {
        if (!this.advanced) {
            this.gotoNextNode();
        }
        this.advanced = true;
        return this.cr_node != null;
    }

    public void gotoNextNode() {
        if (this.busy) {
            this.descentTillBottom();
            this.cr_node = this.getNode();
            this.climbTillDescision();
        } else {
            this.cr_node = null;
        }
    }

    @Override
    public int getLevel() {
        return this.cr_level;
    }

    private void descentTillBottom() {
        while (!this.atBottomLevel()) {
            this.goDown(0);
            ++this.cr_level;
        }
    }

    private void climbTillDescision() {
        int num;
        do {
            if (this.cr_level <= 0) {
                this.busy = false;
                return;
            }
            num = this.getIndex();
            this.goUp();
            --this.cr_level;
        } while (num >= this.getNode().getNbChildren() - 1);
        this.goDown(num + 1);
        ++this.cr_level;
    }
}

