/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.tree;

import si.ijs.kt.clus.util.jeans.tree.Node;
import si.ijs.kt.clus.util.jeans.tree.TreeIterator;

public class CompleteTreeIterator
extends TreeIterator {
    private boolean busy = true;
    private boolean advanced = true;

    public CompleteTreeIterator(Node node) {
        super(node);
    }

    @Override
    public void reset() {
        super.reset();
        this.busy = true;
        this.advanced = true;
    }

    public Node getNextNode() {
        if (!this.advanced) {
            this.gotoNextNode();
        }
        this.advanced = false;
        return this.getNode();
    }

    public boolean hasMoreNodes() {
        if (!this.advanced) {
            this.gotoNextNode();
        }
        this.advanced = true;
        return this.busy;
    }

    private void gotoNextNode() {
        if (!this.atBottomLevel()) {
            this.goDown(0);
        } else {
            boolean done = false;
            while (!done) {
                if (this.atTopLevel()) {
                    this.busy = false;
                    done = true;
                    continue;
                }
                int crindex = this.getIndex();
                this.goUp();
                int children = this.getNode().getNbChildren();
                if (crindex + 1 >= children) continue;
                this.goDown(crindex + 1);
                done = true;
            }
        }
    }
}

