/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.tree;

import si.ijs.kt.clus.util.jeans.tree.Node;

public class BinaryNode
implements Node {
    String m_Name;
    Object m_Cargo;
    BinaryNode m_Left;
    BinaryNode m_Right;
    Node m_Parent;
    boolean m_bFakeLeaf;

    public void setName(String name) {
        this.m_Name = name;
    }

    @Override
    public int getLevel() {
        int depth = 0;
        BinaryNode node = this;
        while (!node.atTopLevel()) {
            node = (BinaryNode)node.getParent();
            ++depth;
        }
        return depth;
    }

    public void setFakeLeaf(boolean fake) {
        this.m_bFakeLeaf = fake;
    }

    public boolean isFakeLeaf() {
        return this.m_bFakeLeaf;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setCargo(Object cargo) {
        this.m_Cargo = cargo;
    }

    public Object getCargo() {
        return this.m_Cargo;
    }

    public void setLeft(BinaryNode node) {
        this.m_Left = node;
        node.setParent(this);
    }

    public BinaryNode getLeft() {
        return this.m_Left;
    }

    public void setRight(BinaryNode node) {
        this.m_Right = node;
        node.setParent(this);
    }

    public BinaryNode getRight() {
        return this.m_Right;
    }

    @Override
    public Node getChild(int idx) {
        if (idx == 0) {
            return this.m_Left;
        }
        return this.m_Right;
    }

    @Override
    public int getNbChildren() {
        return this.atBottomLevel() ? 0 : 2;
    }

    @Override
    public void addChild(Node node) {
    }

    @Override
    public void removeChild(Node node) {
        if (node == this.m_Left) {
            this.m_Left = null;
        }
        if (node == this.m_Right) {
            this.m_Right = null;
        }
    }

    @Override
    public void setParent(Node parent) {
        this.m_Parent = parent;
    }

    @Override
    public Node getParent() {
        return this.m_Parent;
    }

    @Override
    public boolean atTopLevel() {
        return this.m_Parent == null;
    }

    @Override
    public boolean atBottomLevel() {
        return this.m_bFakeLeaf || this.atRealBottomLevel();
    }

    public boolean atRealBottomLevel() {
        return this.m_Left == null && this.m_Right == null;
    }

    public static int maxHeight(BinaryNode node) {
        if (node.atRealBottomLevel()) {
            return 0;
        }
        int ld = BinaryNode.maxHeight(node.getLeft());
        int rd = BinaryNode.maxHeight(node.getRight());
        return Math.max(ld, rd) + 1;
    }

    public static int getHeight(BinaryNode node) {
        if (node.atBottomLevel()) {
            return 0;
        }
        int ld = BinaryNode.getHeight(node.getLeft());
        int rd = BinaryNode.getHeight(node.getRight());
        return Math.max(ld, rd) + 1;
    }
}

