/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.math;

public class SingleStat {
    protected double m_Min = Double.POSITIVE_INFINITY;
    protected double m_Max = Double.NEGATIVE_INFINITY;
    protected double m_Sum;
    protected double m_SumSQ;
    protected double m_Count;

    public SingleStat() {
        this.m_Min = Double.POSITIVE_INFINITY;
        this.m_Max = Double.NEGATIVE_INFINITY;
    }

    public void reset() {
        this.m_Sum = 0.0;
        this.m_SumSQ = 0.0;
        this.m_Count = 0.0;
        this.m_Min = Double.POSITIVE_INFINITY;
        this.m_Max = Double.NEGATIVE_INFINITY;
    }

    public double getCount() {
        return this.m_Count;
    }

    public void addFloat(double value) {
        this.m_Sum += value;
        this.m_SumSQ += value * value;
        this.m_Count += 1.0;
        if (value < this.m_Min) {
            this.m_Min = value;
        }
        if (value > this.m_Max) {
            this.m_Max = value;
        }
    }

    public double getRange() {
        return Math.abs(this.getMax() - this.getMin());
    }

    public void addMean(SingleStat other) {
        this.addFloat(other.getMean());
    }

    public double getMin() {
        return this.m_Min;
    }

    public double getMax() {
        return this.m_Max;
    }

    public double getVariance() {
        return (this.m_SumSQ - this.m_Sum * this.m_Sum / this.m_Count) / this.m_Count;
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance() * this.m_Count / (this.m_Count - 1.0));
    }

    public double getStdDefOfMean() {
        return this.getStdDev() / Math.sqrt(this.m_Count);
    }

    public double getMean() {
        return this.m_Sum / this.m_Count;
    }

    public String toString() {
        return "" + this.getMean() + " (" + this.getStdDev() + ") " + this.getMin() + "/" + this.getMax();
    }
}

