/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.math;

import java.util.ArrayList;
import java.util.HashSet;
import si.ijs.kt.clus.util.ClusLogger;

public class MathUtil {
    public static final double C1E_6 = 1.0E-6;
    public static final double C1E_9 = 1.0E-9;
    public static final double C1E_16 = 1.0E-16;
    public static final double M_LN2 = Math.log(2.0);
    protected double[] blackBoxTestInterpolateX = new double[]{2.0, 5.0, 5.0, 5.0, 9.5};
    protected double[] blackBoxTestInterpolateY = new double[]{3.5, 3.5, 4.5, 5.5, 1.5};

    public static double interpolate(double x, ArrayList<double[]> fct) {
        double[] pt1;
        int i;
        int len = fct.size();
        if (len == 0) {
            return Double.NaN;
        }
        if (len == 1) {
            double[] pt = fct.get(0);
            return pt[1];
        }
        double[] pt0 = fct.get(0);
        if (x < pt0[0]) {
            return pt0[1];
        }
        double[] ptn = fct.get(len - 1);
        if (x > ptn[0]) {
            return ptn[1];
        }
        int count = 0;
        double sum = 0.0;
        for (i = 0; i < len; ++i) {
            pt1 = fct.get(i);
            if (x != pt1[0]) continue;
            sum += pt1[1];
            ++count;
        }
        if (count > 0) {
            return sum / (double)count;
        }
        for (i = 0; i < len - 1; ++i) {
            pt1 = fct.get(i);
            double[] pt2 = fct.get(i + 1);
            if (!(x >= pt1[0]) || !(x < pt2[0])) continue;
            double y1 = pt1[1];
            double y2 = pt2[1];
            double x1 = pt1[0];
            double x2 = pt2[0];
            return (x - x1) / (x2 - x1) * (y2 - y1) + y1;
        }
        return Double.NaN;
    }

    protected void blackBoxTestInterpolate() {
        ArrayList<double[]> fct = new ArrayList<double[]>();
        for (int i = 0; i < this.blackBoxTestInterpolateX.length; ++i) {
            fct.add(new double[]{this.blackBoxTestInterpolateX[i], this.blackBoxTestInterpolateY[i]});
        }
        ClusLogger.info("Interpolate x = 0   -> y = 3.5: " + MathUtil.interpolate(0.0, fct));
        ClusLogger.info("Interpolate x = 4   -> y = 3.5: " + MathUtil.interpolate(4.0, fct));
        ClusLogger.info("Interpolate x = 5   -> y = 4.5: " + MathUtil.interpolate(5.0, fct));
        ClusLogger.info("Interpolate x = 7   -> y = 3.8: " + MathUtil.interpolate(7.0, fct));
        ClusLogger.info("Interpolate x = 9.5 -> y = 1.5: " + MathUtil.interpolate(9.5, fct));
        ClusLogger.info("Interpolate x = 10  -> y = 1.5: " + MathUtil.interpolate(10.0, fct));
    }

    public static <T> HashSet<T> symmetricDifference(ArrayList<T> elements1, ArrayList<T> elements2) {
        HashSet<T> symmetricDifference = new HashSet<T>();
        for (T elt : elements1) {
            symmetricDifference.add(elt);
        }
        for (T elt : elements2) {
            if (symmetricDifference.contains(elt)) {
                symmetricDifference.remove(elt);
                continue;
            }
            symmetricDifference.add(elt);
        }
        return symmetricDifference;
    }

    public static void main(String[] arg) {
        MathUtil mu = new MathUtil();
        mu.blackBoxTestInterpolate();
    }
}

