/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.list;

import java.io.Serializable;
import java.util.Arrays;

public class BitList
implements Serializable {
    public static final long serialVersionUID = 1L;
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private long[] m_Bits;
    private int m_Size;

    public BitList() {
    }

    public BitList(int size) {
        this.resize(size);
    }

    public final void resize(int size) {
        this.m_Size = size;
        this.m_Bits = new long[BitList.unitIndex(size - 1) + 1];
    }

    public final BitList cloneList() {
        return new BitList(this.m_Size);
    }

    public final int size() {
        return this.m_Size;
    }

    public final void setBit(int idx) {
        int n = BitList.unitIndex(idx);
        this.m_Bits[n] = this.m_Bits[n] | BitList.bit(idx);
    }

    public final boolean getBit(int idx) {
        return (this.m_Bits[BitList.unitIndex(idx)] & BitList.bit(idx)) != 0L;
    }

    public final void reset() {
        Arrays.fill(this.m_Bits, 0L);
    }

    public final void copy(BitList other) {
        int olen = other.m_Bits.length;
        if (this.m_Bits == null || olen != this.m_Bits.length) {
            this.m_Bits = new long[olen];
            this.m_Size = other.size();
        }
        System.arraycopy(other.m_Bits, 0, this.m_Bits, 0, olen);
    }

    public final void add(BitList other) {
        int nb = this.m_Bits.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            this.m_Bits[n] = this.m_Bits[n] | other.m_Bits[i];
        }
    }

    public final void subtractFromThis(BitList other) {
        int nb = this.m_Bits.length;
        for (int i = 0; i < nb; ++i) {
            int n = i;
            this.m_Bits[n] = this.m_Bits[n] & (other.m_Bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public final void subtractFromOther(BitList other) {
        int nb = this.m_Bits.length;
        for (int i = 0; i < nb; ++i) {
            this.m_Bits[i] = other.m_Bits[i] & (this.m_Bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.m_Size; ++i) {
            buf.append(this.getBit(i) ? (char)'1' : '0');
        }
        return buf.toString();
    }

    public String toVector() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < this.m_Size; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.getBit(i) ? (char)'1' : '0');
        }
        buf.append("]");
        return buf.toString();
    }

    public final int getNbOnes() {
        int nb = 0;
        for (int i = 0; i < this.m_Size; ++i) {
            if (!this.getBit(i)) continue;
            ++nb;
        }
        return nb;
    }

    private static final int unitIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private static final long bit(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    public void copyAndSubtractFromThis(BitList bits, BitList bits2) {
        throw new UnsupportedOperationException();
    }
}

