/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileArray;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileSectionGroup;
import si.ijs.kt.clus.util.jeans.util.MStreamTokenizer;

public class INIFileSection
extends INIFileNode {
    public static final long serialVersionUID = 1L;
    protected Hashtable<String, INIFileNode> m_hEntries = new Hashtable();
    protected Vector<INIFileNode> m_hEntryList = new Vector();
    protected int m_Index = 1;

    public INIFileSection(String name) {
        super(name);
    }

    public INIFileSection() {
        this("");
    }

    @Override
    public boolean isSectionGroup() {
        return false;
    }

    @Override
    public boolean isSection() {
        return true;
    }

    @Override
    public INIFileNode cloneNode() {
        INIFileSection sec = new INIFileSection(this.getName());
        Enumeration<INIFileNode> e = this.getNodes();
        while (e.hasMoreElements()) {
            INIFileNode node = e.nextElement();
            sec.addNode(node.cloneNode());
        }
        return sec;
    }

    public int getNbNodes() {
        return this.m_hEntryList.size();
    }

    public Enumeration<INIFileNode> getNodes() {
        return this.m_hEntryList.elements();
    }

    public INIFileEntry getEntry(String name) {
        return (INIFileEntry)this.m_hEntries.get(name);
    }

    public INIFileNode getNode(String name) {
        return this.m_hEntries.get(name);
    }

    public void addNode(INIFileNode entry) {
        this.m_hEntries.put(entry.getName(), entry);
        this.m_hEntryList.addElement(entry);
        entry.setParent(this);
    }

    public INIFileNode getPathNode(String path, Class type) {
        INIFileNode node = this.getPathNode(path);
        if (node != null && node.getClass() == type) {
            return node;
        }
        return null;
    }

    public INIFileNode getPathNode(String path, int type) {
        INIFileNode node = this.getPathNode(path);
        if (node == null) {
            return null;
        }
        switch (type) {
            case 0: 
            case 1: {
                if (!(node instanceof INIFileArray) || ((INIFileArray)node).getType() != type) break;
                return node;
            }
        }
        return null;
    }

    public INIFileNode getPathNode(String path) {
        String nextNode = null;
        String subNode = null;
        if (path.equals("")) {
            return this;
        }
        int idx = path.indexOf(46);
        if (idx == -1) {
            nextNode = path;
            subNode = "";
        } else {
            nextNode = path.substring(0, idx);
            subNode = path.substring(idx + 1);
        }
        INIFileNode node = this.getNode(nextNode);
        if (node != null) {
            if (node.isSection()) {
                return ((INIFileSection)node).getPathNode(subNode);
            }
            return node;
        }
        ClusLogger.info("Can't find node: " + nextNode);
        Enumeration<INIFileNode> e = this.getNodes();
        while (e.hasMoreElements()) {
            INIFileNode entry = e.nextElement();
            ClusLogger.info("   " + entry.getName());
        }
        return null;
    }

    public void doLoad(String sectionName, String groupName, MStreamTokenizer tokens) throws IOException {
        INIFileNode node = this.getNode(groupName);
        if (node == null || !(node instanceof INIFileSectionGroup)) {
            throw new IOException("Error in the settings file. Don't know about group '" + groupName + "' at line: " + tokens.getLine());
        }
        INIFileSectionGroup group = (INIFileSectionGroup)node;
        INIFileSection sec = (INIFileSection)group.getPrototype().cloneNode();
        sec.setName(sectionName);
        group.addSection(sec);
        sec.load(tokens);
    }

    public void doLoad(String name, MStreamTokenizer tokens) throws IOException {
        INIFileNode node = this.getNode(name);
        if (node == null || !(node instanceof INIFileSection)) {
            throw new IOException("Error in the settings file. Don't know about section '" + name + "' at line: " + tokens.getLine());
        }
        INIFileSection section = (INIFileSection)node;
        section.load(tokens);
    }

    public void load(MStreamTokenizer tokens) throws IOException {
        String name;
        this.setEnabled(true);
        while (true) {
            String token;
            if ((token = tokens.getToken()) == null) {
                return;
            }
            if (token.equals("[")) {
                tokens.pushBackToken(token);
                return;
            }
            if (token.equals("<")) {
                if (this.getDepth() >= 1) {
                    tokens.pushBackToken(token);
                    return;
                }
                int saveline = tokens.getLine();
                String name2 = tokens.readTillEol();
                int idx1 = name2.indexOf(62);
                if (idx1 == -1) {
                    throw new IOException("Error in the settings file. Character '>' expected at line: " + saveline);
                }
                int idx2 = name2.indexOf(44);
                if (idx2 != -1) {
                    String groupName = name2.substring(0, idx2).trim();
                    String sectionName = name2.substring(idx2 + 1, idx1).trim();
                    this.doLoad(sectionName, groupName, tokens);
                    continue;
                }
                this.doLoad(name2.substring(0, idx1).trim(), tokens);
                continue;
            }
            name = token.trim();
            tokens.readChar('=');
            INIFileNode entry = this.getNode(name);
            if (entry == null || !(entry instanceof INIFileEntry)) break;
            ((INIFileEntry)entry).build(tokens);
        }
        throw new IOException("Error in the settings file. Don't know about entry '" + name + "' at line: " + tokens.getLine());
    }

    public void save(String group, PrintWriter writer) throws IOException {
        int depth = this.getDepth();
        if (!this.isEnabled()) {
            return;
        }
        if (group == null) {
            if (depth == 0) {
                writer.println("[" + this.getName() + "]");
            } else {
                writer.println("<" + this.getName() + ">");
            }
        } else if (depth == 0) {
            writer.println("[" + group + ", " + this.getName() + "]");
        } else {
            writer.println("<" + group + ", " + this.getName() + ">");
        }
        Enumeration<INIFileNode> e = this.getNodes();
        while (e.hasMoreElements()) {
            INIFileNode entry = e.nextElement();
            if (!entry.isEnabled()) continue;
            entry.save(writer);
        }
    }

    @Override
    public void save(PrintWriter writer) throws IOException {
        this.save(null, writer);
    }
}

