/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.io.range.NominalType;
import si.ijs.kt.clus.util.jeans.util.MStreamTokenizer;

public class INIFileNominalOrIntOrVector
extends INIFileEntry {
    public static final long serialVersionUID = 1L;
    protected NominalType m_Type;
    protected int m_SingleNominal;
    protected int m_SingleInt;
    protected int[] m_ArrayNominal;
    protected int[] m_ArrayInt;

    public INIFileNominalOrIntOrVector(String name, String[] values) {
        this(name, new NominalType(values));
    }

    public INIFileNominalOrIntOrVector(String name, NominalType values) {
        super(name);
        this.m_Type = values;
        this.m_SingleNominal = -1;
    }

    public NominalType getType() {
        return this.m_Type;
    }

    @Override
    public INIFileNode cloneNode() {
        return new INIFileNominalOrIntOrVector(this.getName(), this.getType());
    }

    public boolean isVector() {
        return this.m_ArrayNominal != null;
    }

    public boolean isNominal() {
        return this.m_SingleNominal != -1;
    }

    public boolean isNominal(int idx) {
        return this.getNominal(idx) != -1;
    }

    public int getNominal(int idx) {
        if (this.isVector()) {
            return this.m_ArrayNominal[idx];
        }
        return this.getNominal();
    }

    public String getNominalString(int idx) {
        return this.m_Type.getName(this.getNominal(idx));
    }

    public int getInt(int idx) {
        if (this.isVector()) {
            return this.m_ArrayInt[idx];
        }
        return this.getInt();
    }

    public int getNominal() {
        return this.m_SingleNominal;
    }

    public int getInt() {
        return this.m_SingleInt;
    }

    public void setInt(int value) {
        this.m_SingleInt = value;
        this.m_ArrayNominal = null;
        this.m_ArrayInt = null;
    }

    public void setNominal(int value) {
        this.m_SingleNominal = value;
        this.m_ArrayNominal = null;
        this.m_ArrayInt = null;
    }

    public void setInt(int idx, int value) {
        this.m_ArrayInt[idx] = value;
        this.m_ArrayNominal[idx] = -1;
    }

    public void setNominal(int idx, int value) {
        this.m_ArrayNominal[idx] = value;
    }

    public void setVector(int len) {
        this.m_ArrayNominal = new int[len];
        this.m_ArrayInt = new int[len];
    }

    public void setIntVector(int[] vector) {
        int len = vector.length;
        this.setVector(len);
        for (int i = 0; i < len; ++i) {
            this.setInt(i, vector[i]);
        }
    }

    public int getVectorLength() {
        return this.m_ArrayNominal == null ? 1 : this.m_ArrayNominal.length;
    }

    public int[] getIntVector() {
        if (this.isVector()) {
            int[] res = new int[this.m_ArrayInt.length];
            System.arraycopy(this.m_ArrayInt, 0, res, 0, this.m_ArrayInt.length);
            return res;
        }
        int[] res = new int[]{this.m_SingleInt};
        return res;
    }

    public int[] getIntVectorSorted() {
        int[] result = this.getIntVector();
        Arrays.sort(result);
        return result;
    }

    public int[] getNominalVector() {
        if (this.isVector()) {
            int[] res = new int[this.m_ArrayNominal.length];
            System.arraycopy(this.m_ArrayNominal, 0, res, 0, this.m_ArrayNominal.length);
            return res;
        }
        int[] res = new int[]{this.m_SingleNominal};
        return res;
    }

    @Override
    public void build(MStreamTokenizer tokens) throws IOException {
        this.m_Type.setReader(true);
        this.setNominal(-1);
        if (tokens.isNextToken('[')) {
            ArrayList<String> values = new ArrayList<String>();
            String token = tokens.getToken();
            while (token != null && !token.equals("]")) {
                values.add(token);
                token = this.readNextEntry(tokens);
            }
            this.setVector(values.size());
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.get(i);
                int idx = this.m_Type.getValue(value);
                if (idx != -1) {
                    this.setNominal(i, idx);
                    continue;
                }
                try {
                    this.setInt(i, Integer.parseInt(value));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IOException("Illegal value '" + value + "' in vector at pos " + i + " for setting '" + this.getName() + "'");
                }
            }
        } else {
            String token = tokens.getToken();
            int idx = this.m_Type.getValue(token);
            if (idx != -1) {
                this.setNominal(idx);
            } else {
                try {
                    this.setInt(Integer.parseInt(token));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Illegal value '" + token + "' for setting '" + this.getName() + "'");
                }
            }
        }
    }

    @Override
    public void setValue(String value) throws IOException {
        this.build(new MStreamTokenizer(new StringReader(value)));
    }

    public String readNextEntry(MStreamTokenizer tokens) throws IOException {
        String token = tokens.getToken();
        if (token != null && token.equals(",")) {
            token = tokens.getToken();
        }
        return token;
    }

    @Override
    public String getStringValue() {
        if (this.isVector()) {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            for (int i = 0; i < this.getVectorLength(); ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                if (this.isNominal(i)) {
                    buf.append(this.getNominalString(i));
                    continue;
                }
                buf.append(String.valueOf(this.getInt(i)));
            }
            buf.append("]");
            return buf.toString();
        }
        if (this.isNominal()) {
            return this.m_Type.getName(this.getNominal());
        }
        return String.valueOf(this.getInt());
    }
}

