/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.io.range.NominalType;
import si.ijs.kt.clus.util.jeans.util.MStreamTokenizer;

public class INIFileNominal
extends INIFileEntry {
    public static final long serialVersionUID = 1L;
    protected NominalType m_Type;
    protected int[] m_Values;
    protected boolean m_IsSet;

    public INIFileNominal(String name, String[] values) {
        super(name);
        this.m_Type = new NominalType(values);
    }

    public INIFileNominal(String name, String[] values, int def) {
        super(name);
        this.m_Type = new NominalType(values);
        this.m_Values = new int[1];
        this.m_Values[0] = def;
    }

    public INIFileNominal(String name, String[] type, int[] values) {
        super(name);
        this.m_Type = new NominalType(type);
        this.m_Values = values;
        this.m_IsSet = true;
    }

    public INIFileNominal(String name, NominalType type) {
        super(name);
        this.m_Type = type;
    }

    public INIFileNominal(String name, NominalType type, int[] values) {
        super(name);
        this.m_Type = type;
        this.m_Values = values;
        this.m_IsSet = true;
    }

    public INIFileNominal(String name, NominalType type, int value) {
        super(name);
        this.setSingleValue(value);
        this.m_Type = type;
        this.m_IsSet = false;
    }

    public void setSingleValue(int idx) {
        this.m_Values = new int[1];
        this.m_Values[0] = idx;
    }

    public int getSize() {
        return this.m_Values.length;
    }

    public NominalType getType() {
        return this.m_Type;
    }

    public boolean contains(int idx) {
        return Arrays.binarySearch(this.m_Values, idx) >= 0;
    }

    public int getIntAt(int idx) {
        return this.m_Values[idx];
    }

    public String getStringSingle() {
        return this.m_Type.getName(this.m_Values[0]);
    }

    public int getValue() {
        return this.m_Values[0];
    }

    public int getSingle() {
        return this.m_Values[0];
    }

    public String getStringAt(int idx) {
        return this.m_Type.getName(this.m_Values[idx]);
    }

    public void setValues(int[] vals) {
        this.m_Values = vals;
    }

    @Override
    public INIFileNode cloneNode() {
        return new INIFileNominal(this.getName(), this.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void build(MStreamTokenizer tokens) throws IOException {
        this.m_Type.setReader(true);
        if (tokens.isNextToken('{')) {
            if (!this.m_IsSet) throw new IOException("'" + this.getName() + "' is not a set");
            Vector<Integer> vals = new Vector<Integer>();
            String token = tokens.getToken();
            while (token != null && !token.equals("}")) {
                int idx = this.m_Type.getValue(token);
                if (idx == -1) {
                    throw new IOException(this.m_Type.getError(this.getName(), token));
                }
                vals.addElement(new Integer(idx));
                token = this.readNextEntry(tokens);
            }
            this.m_Values = new int[vals.size()];
            for (int i = 0; i < vals.size(); ++i) {
                this.m_Values[i] = (Integer)vals.elementAt(i);
            }
            Arrays.sort(this.m_Values);
            return;
        } else {
            String token = tokens.getToken();
            int idx = this.m_Type.getValue(token);
            if (idx == -1) {
                throw new IOException(this.m_Type.getError(this.getName(), token));
            }
            this.setSingleValue(idx);
        }
    }

    @Override
    public void setValue(String value) {
    }

    public String readNextEntry(MStreamTokenizer tokens) throws IOException {
        String token = tokens.getToken();
        if (token != null && token.equals(",")) {
            token = tokens.getToken();
        }
        return token;
    }

    @Override
    public String getStringValue() {
        if (this.m_IsSet) {
            StringBuffer buffer = new StringBuffer("{");
            for (int idx = 0; idx < this.m_Values.length; ++idx) {
                if (idx != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.m_Type.getName(this.m_Values[idx]));
            }
            buffer.append("}");
            return buffer.toString();
        }
        return this.getStringSingle();
    }
}

