/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;

public abstract class INIFileNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String m_hName;
    protected INIFileNode m_hParent;
    protected boolean m_Enabled = true;

    public INIFileNode(String name) {
        this.m_hName = name;
    }

    public void setName(String name) {
        this.m_hName = name;
    }

    public String getName() {
        return this.m_hName;
    }

    public void setEnabled(boolean enable) {
        this.m_Enabled = enable;
    }

    public boolean isEnabled() {
        return this.m_Enabled;
    }

    public int getDepth() {
        int depth = 0;
        for (INIFileNode node = this.getParent(); node != null; node = node.getParent()) {
            if (node.isSectionGroup()) continue;
            ++depth;
        }
        return depth;
    }

    public String getPathName(String my_name) {
        String name = my_name;
        for (INIFileNode node = this; node != null; node = node.getParent()) {
            if (node.isSectionGroup()) continue;
            INIFileNode parent = node.getParent();
            name = parent != null && parent.isSectionGroup() ? parent.getName() + "." + name : node.getName() + "." + name;
        }
        return name;
    }

    public void setParent(INIFileNode node) {
        this.m_hParent = node;
    }

    public INIFileNode getParent() {
        return this.m_hParent;
    }

    public boolean hasParent() {
        return this.m_hParent != null;
    }

    public abstract INIFileNode cloneNode();

    public abstract boolean isSectionGroup();

    public abstract boolean isSection();

    public abstract void save(PrintWriter var1) throws IOException;
}

