/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;

public class INIFileEnumList<T extends Enum<T>>
extends INIFileEntry {
    private static final long serialVersionUID = 1L;
    private Class<T> m_EnumType;
    private List<T> m_Values = null;

    public INIFileEnumList(String name, T defaultValue) {
        super(name);
        this.m_EnumType = defaultValue.getClass();
        this.m_Values = new ArrayList<T>();
        this.m_Values.add(defaultValue);
    }

    public INIFileEnumList(String name, List<T> values, Class<T> type) {
        super(name);
        if (values == null) {
            throw new RuntimeException("INIFileEnumList(String, List<T>) --> List<T> is null!");
        }
        this.m_Values = new ArrayList<T>(values);
        this.m_EnumType = type;
    }

    @Override
    public String getStringValue() {
        return "[" + this.m_Values.stream().map(Enum::toString).collect(Collectors.joining(", ")) + "]";
    }

    @Override
    public void setValue(String value) throws IOException {
        String[] entries = value.replace("[", "").replace("]", "").replace(" ", "").split(",");
        this.m_Values.clear();
        for (String entry : entries) {
            try {
                this.m_Values.add(Enum.valueOf(this.m_EnumType, entry));
            }
            catch (IllegalArgumentException e) {
                System.err.println(String.format("Value %s is illegal for the option %s", entry, this.m_hName));
                System.err.println(String.format("List of allowed values: " + Arrays.toString(this.m_EnumType.getEnumConstants()), new Object[0]));
                throw e;
            }
        }
    }

    @Override
    public INIFileNode cloneNode() {
        return new INIFileEnumList<T>(this.getName(), this.m_Values, this.m_EnumType);
    }

    public void setValue(List<T> values) {
        this.m_Values = values;
    }

    public List<T> getValue() {
        return this.m_Values;
    }

    public int getVectorSize() {
        return this.m_Values.size();
    }

    public boolean IsVector() {
        return this.m_Values.size() > 1;
    }
}

