/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import si.ijs.kt.clus.util.jeans.io.ini.INIFileEntry;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.io.range.ValueCheck;

public class INIFileDouble
extends INIFileEntry {
    public static final long serialVersionUID = 1L;
    protected double m_Value;
    protected ValueCheck m_Check;

    public INIFileDouble(String name, String value) {
        super(name);
        this.setValue(value);
    }

    public INIFileDouble(String name, double value) {
        super(name);
        this.setValue(value);
    }

    public INIFileDouble(String name) {
        this(name, 0.0);
    }

    public void setValueCheck(ValueCheck check) {
        this.m_Check = check;
    }

    @Override
    public INIFileNode cloneNode() {
        return new INIFileDouble(this.getName(), this.getValue());
    }

    public double getValue() {
        return this.m_Value;
    }

    public void setValue(double value) {
        Double dval;
        if (this.m_Check != null && !this.m_Check.checkValue(dval = new Double(value))) {
            throw new NumberFormatException(this.m_Check.getString(this.getName(), dval));
        }
        this.m_Value = value;
    }

    @Override
    public void setValue(String value) {
        this.setValue(Double.parseDouble(value));
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.getValue());
    }
}

