/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.jeans.io.ini;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileNode;
import si.ijs.kt.clus.util.jeans.io.ini.INIFileSection;
import si.ijs.kt.clus.util.jeans.util.MStreamTokenizer;

public class INIFile
extends INIFileSection {
    public static final long serialVersionUID = 1L;
    public static final int TYPE_DOUBLE_ARRAY = 0;
    public static final int TYPE_STRING_ARRAY = 1;
    public static final int TYPE_INT_ARRAY = 2;

    public INIFile() {
        super("");
    }

    @Override
    public void addNode(INIFileNode entry) {
        this.m_hEntries.put(entry.getName(), entry);
        this.m_hEntryList.addElement(entry);
    }

    public void load(String fname) throws FileNotFoundException, IOException {
        this.load(fname, '#');
    }

    public void load(String fname, char comment) throws FileNotFoundException, IOException {
        MStreamTokenizer tokens = new MStreamTokenizer(fname);
        this.load(tokens, comment);
        tokens.close();
    }

    public void load(Reader reader, char comment) throws IOException {
        MStreamTokenizer tokens = new MStreamTokenizer(reader);
        this.load(tokens, comment);
        tokens.close();
    }

    public void save(String fname) throws IOException {
        PrintWriter writer = new PrintWriter(new FileOutputStream(fname));
        this.save(writer);
        writer.close();
    }

    public void load(MStreamTokenizer tokens, char comment) throws IOException {
        tokens.setCharTokens("[]=<>,{}");
        tokens.setCommentChar(comment);
        while (true) {
            String token = "";
            while (token != null && !token.equals("[")) {
                token = tokens.getToken();
            }
            if (token == null) break;
            int saveline = tokens.getLine();
            String name = tokens.readTillEol();
            int idx1 = name.indexOf(93);
            if (idx1 == -1) {
                throw new IOException("Error in the settings file. Character ']' expected at line: " + saveline);
            }
            int idx2 = name.indexOf(44);
            if (idx2 != -1) {
                String groupName = name.substring(0, idx2).trim();
                String sectionName = name.substring(idx2 + 1, idx1).trim();
                this.doLoad(sectionName, groupName, tokens);
                continue;
            }
            this.doLoad(name.substring(0, idx1).trim(), tokens);
        }
    }

    @Override
    public void save(PrintWriter writer) throws IOException {
        Enumeration<INIFileNode> e = this.getNodes();
        while (e.hasMoreElements()) {
            INIFileNode section = e.nextElement();
            if (!section.isEnabled()) continue;
            section.save(writer);
            writer.println();
        }
    }
}

