/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.format;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.format.ClusNumberFormat;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class ClusFormat {
    public static final ClusNumberFormat ONE_AFTER_DOT = new ClusNumberFormat(1);
    public static final ClusNumberFormat TWO_AFTER_DOT = new ClusNumberFormat(2);
    public static final ClusNumberFormat THREE_AFTER_DOT = new ClusNumberFormat(3);
    public static final ClusNumberFormat SIX_AFTER_DOT = new ClusNumberFormat(6);
    public static final ClusNumberFormat FOUR_AFTER_DOT = new ClusNumberFormat(4);
    public static final PrintWriter OUT_WRITER = new PrintWriter(new OutputStreamWriter(System.out));

    public static NumberFormat makeNAfterDot(int n) {
        NumberFormat fr = NumberFormat.getInstance();
        fr.setMaximumFractionDigits(n);
        try {
            DecimalFormat df = (DecimalFormat)fr;
            DecimalFormatSymbols sym = df.getDecimalFormatSymbols();
            sym.setDecimalSeparator('.');
            df.setGroupingUsed(false);
            df.setDecimalFormatSymbols(sym);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return fr;
    }

    @Deprecated
    public static NumberFormat makeNAfterDot2(int n) {
        NumberFormat fr = ClusFormat.makeNAfterDot(n);
        fr.setMinimumFractionDigits(n);
        return fr;
    }

    public static void printArray(PrintWriter out, double[] a1, double[] a2, NumberFormat nf) {
        for (int i = 0; i < a1.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            if (a2[i] == 0.0) {
                out.print(nf.format(0.0));
                continue;
            }
            out.print(nf.format(a1[i] / a2[i]));
        }
    }

    public static void printArray(PrintWriter out, double[] a1, NumberFormat nf) {
        for (int i = 0; i < a1.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print(nf.format(a1[i]));
        }
    }

    public static void main(String[] args) {
        int n = 1;
        DecimalFormat df = new DecimalFormat(String.format("0.%sE0", StringUtils.makeString('0', n)));
        double[] xs = new double[]{9.0, 9.0, 9876.6, 0.0098766, 9.8766E-9, 9876543.456789, 0.987654};
        String[] xsStr = new String[]{"9", "9.0", "9876.6", "0.0098766", "0.0000000098766", "9876543.456789", "0.987654"};
        NumberFormat dff = ClusFormat.makeNAfterDot(n);
        for (int i = 0; i < xs.length; ++i) {
            ClusLogger.info("Representation of " + xsStr[i] + ": " + df.format(xs[i]) + " : " + dff.format(xs[i]));
        }
    }
}

