/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.stream.DoubleStream;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.util.ClusLogger;

public class ClusUtil {
    public static final double MICRO = 1.0E-6;
    public static final double NANO = 1.0E-9;
    public static final double PICO = 1.0E-12;
    public static final double NaN = Double.NaN;

    public static boolean grOrEq(double a, double b) {
        return b - a < 1.0E-6;
    }

    public static boolean smOrEq(double a, double b) {
        return a - b < 1.0E-6;
    }

    public static boolean eq(double a, double b) {
        return ClusUtil.eq(a, b, 1.0E-6);
    }

    public static boolean eq(double a, double b, double allowedDifference) {
        return Math.abs(a - b) < allowedDifference;
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public static double mean(double[] xs) {
        return DoubleStream.of(xs).sum() / (double)xs.length;
    }

    public static void main(String[] arg) {
        String[] tests;
        double d1 = -1.23456789;
        double d2 = -0.0;
        double d3 = -1234567.89;
        double d4 = -1.234E-12;
        double d5 = 2.23E-13;
        double d6 = 1.2345E-9;
        int n = 3;
        ClusLogger.info(ClusUtil.roundToSignificantFigures(d1, n));
        ClusLogger.info(ClusUtil.roundToSignificantFigures(d2, n));
        ClusLogger.info(ClusUtil.roundToSignificantFigures(d3, n));
        ClusLogger.info(ClusUtil.roundToSignificantFigures(d4, n));
        ClusLogger.info(ClusUtil.roundToSignificantFigures(d5, n));
        ClusLogger.info(ClusUtil.roundToSignificantFigures(d6, n));
        for (String test : tests = new String[]{"dsa", "sdaaa/dsa", "a/a/a/dsa", "s\\c\\dsa"}) {
            ClusLogger.info(ClusUtil.fileName(test));
        }
        ClusLogger.info(ClusUtil.correlation(new double[]{1.0, 2.0, 3.0, 4.0}, new double[]{1.0, 2.0, 3.0, 4.0}));
        ClusLogger.info(ClusUtil.correlation(new double[]{2.0, 1.0, 3.0, 4.0}, new double[]{-4.0, -2.0, -6.0, -8.0}));
    }

    public static double roundDouble(double value, int afterDecimalPoint) {
        double mask = Math.pow(10.0, afterDecimalPoint);
        return (double)Math.round(value * mask) / mask;
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static boolean isZero(double d) {
        return d == 0.0;
    }

    public static boolean isNaNOrZero(double d) {
        return ClusUtil.isNaN(d) || ClusUtil.isZero(d);
    }

    public static boolean isAnyNaNOrZero(double[] numbers) {
        for (double d : numbers) {
            if (!ClusUtil.isNaNOrZero(d)) continue;
            return true;
        }
        return false;
    }

    public static String fileName(String pathToFile) {
        String answer = pathToFile.replace("\\", "/");
        int i = answer.lastIndexOf("/") + 1;
        return answer.substring(i);
    }

    public static HashMap<String, Integer> getDescriptiveAttributesIndices(ClusStatManager statmgr) {
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        if (statmgr.getSettings().getOutput().isOutputPythonModel()) {
            int ii;
            ClusAttrType[] cat = ClusSchema.vectorToAttrArray(statmgr.getSchema().collectAttributes(ClusAttrType.AttributeUseType.Descriptive, null));
            for (ii = 0; ii < cat.length - 1; ++ii) {
                indices.put(cat[ii].getName(), ii);
            }
            ii = cat.length - 1;
            indices.put(cat[ii].getName(), ii);
        }
        return indices;
    }

    public static double[] getRanks(double[] values) {
        int i;
        double[] result = new double[values.length];
        final double[] scores = values;
        Integer[] indices = new Integer[values.length];
        for (i = 0; i < values.length; ++i) {
            indices[i] = i;
        }
        Arrays.sort(indices, new Comparator<Integer>(){

            @Override
            public int compare(Integer ind1, Integer ind2) {
                return Double.compare(scores[ind1], scores[ind2]);
            }
        });
        result[indices[0].intValue()] = values.length;
        for (i = 1; i < values.length; ++i) {
            int index = indices[i];
            int previous = indices[i - 1];
            result[index] = scores[previous] < scores[index] ? (double)(values.length - i) : result[previous];
        }
        return result;
    }

    public static double correlation(double[] a, double[] b) {
        double var_b;
        double max_a = ClusUtil.max_abs(a);
        double max_b = ClusUtil.max_abs(b);
        double var_a = ClusUtil.variance(a);
        if (Math.min(var_a, var_b = ClusUtil.variance(b)) < 1.0E-12 * Math.min(max_a, max_b)) {
            return 1.0;
        }
        double denominator = Math.pow(var_a * var_b, 0.5);
        double avg_a = ClusUtil.average(a);
        double avg_b = ClusUtil.average(b);
        double numerator = 0.0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            numerator += (a[i] - avg_a) * (b[i] - avg_b);
        }
        double f = (numerator /= (double)n) / denominator;
        if (f > 1.0) {
            return 1.0;
        }
        if (f < -1.0) {
            return -1.0;
        }
        return f;
    }

    public static double average(double[] a) {
        double s = 0.0;
        for (int i = 0; i < a.length; ++i) {
            s += a[i];
        }
        return s / (double)a.length;
    }

    public static double variance(double[] a) {
        double avg = ClusUtil.average(a);
        double s = 0.0;
        for (int i = 0; i < a.length; ++i) {
            s += Math.pow(a[i] - avg, 2.0);
        }
        return s / (double)a.length;
    }

    public static double max_abs(double[] a) {
        double m = Double.NEGATIVE_INFINITY;
        for (double x : a) {
            double y = Math.abs(x);
            if (!(y > m)) continue;
            m = y;
        }
        return m;
    }

    public static String readStream(InputStream is) {
        StringBuilder sb = new StringBuilder(512);
        try {
            InputStreamReader r = new InputStreamReader(is, "UTF-8");
            int c = 0;
            while ((c = ((Reader)r).read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }
}

