/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util;

import java.io.InputStreamReader;
import java.util.Calendar;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import si.ijs.kt.clus.Clus;

public class ClusMisc {
    private static String getClusVersion() {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = null;
        try {
            try (InputStreamReader isr = new InputStreamReader(Clus.class.getResourceAsStream("/pom.xml"));){
                model = reader.read(isr);
            }
            return model.getVersion();
        }
        catch (Exception ex) {
            return "DEVELOPMENT";
        }
    }

    public static void printHeader(boolean shorter) {
        System.out.println("Clus v" + ClusMisc.getClusVersion());
        if (!shorter) {
            System.out.println("Software for Predictive Clustering");
            System.out.println();
            System.out.println(String.format("Copyright (C) 2007 - %s", Calendar.getInstance().get(1)));
            System.out.println("   Katholieke Universiteit Leuven, Leuven, Belgium");
            System.out.println("   Jozef Stefan Institute, Ljubljana, Slovenia");
            System.out.println();
            System.out.println("This program is free software and comes with ABSOLUTELY NO");
            System.out.println("WARRANTY. You are welcome to redistribute it under certain");
            System.out.println("conditions. Type 'clus -copying' for distribution details.");
            System.out.println();
        }
    }

    public static void showHelp() {
        System.out.println("Usage: java -jar clus.jar [options] <experiment.s>");
        System.out.println("Output: experiment{.out, .pref, .xval, .oob, .fimp}");
        System.out.println();
        System.out.println("See user manual for details about different run options.");
        System.out.println();
        System.out.println("Expected arguments! Terminating...");
        System.out.println();
    }

    public static void printGPL() {
        System.out.println("                    GNU GENERAL PUBLIC LICENSE");
        System.out.println("                       Version 3, 29 June 2007");
        System.out.println("");
        System.out.println(" Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>");
        System.out.println(" Everyone is permitted to copy and distribute verbatim copies");
        System.out.println(" of this license document, but changing it is not allowed.");
        System.out.println("");
        System.out.println("                            Preamble");
        System.out.println("");
        System.out.println("  The GNU General Public License is a free, copyleft license for");
        System.out.println("software and other kinds of works.");
        System.out.println("");
        System.out.println("  The licenses for most software and other practical works are designed");
        System.out.println("to take away your freedom to share and change the works.  By contrast,");
        System.out.println("the GNU General Public License is intended to guarantee your freedom to");
        System.out.println("share and change all versions of a program--to make sure it remains free");
        System.out.println("software for all its users.  We, the Free Software Foundation, use the");
        System.out.println("GNU General Public License for most of our software; it applies also to");
        System.out.println("any other work released this way by its authors.  You can apply it to");
        System.out.println("your programs, too.");
        System.out.println("");
        System.out.println("  When we speak of free software, we are referring to freedom, not");
        System.out.println("price.  Our General Public Licenses are designed to make sure that you");
        System.out.println("have the freedom to distribute copies of free software (and charge for");
        System.out.println("them if you wish), that you receive source code or can get it if you");
        System.out.println("want it, that you can change the software or use pieces of it in new");
        System.out.println("free programs, and that you know you can do these things.");
        System.out.println("");
        System.out.println("  To protect your rights, we need to prevent others from denying you");
        System.out.println("these rights or asking you to surrender the rights.  Therefore, you have");
        System.out.println("certain responsibilities if you distribute copies of the software, or if");
        System.out.println("you modify it: responsibilities to respect the freedom of others.");
        System.out.println("");
        System.out.println("  For example, if you distribute copies of such a program, whether");
        System.out.println("gratis or for a fee, you must pass on to the recipients the same");
        System.out.println("freedoms that you received.  You must make sure that they, too, receive");
        System.out.println("or can get the source code.  And you must show them these terms so they");
        System.out.println("know their rights.");
        System.out.println("");
        System.out.println("  Developers that use the GNU GPL protect your rights with two steps:");
        System.out.println("(1) assert copyright on the software, and (2) offer you this License");
        System.out.println("giving you legal permission to copy, distribute and/or modify it.");
        System.out.println("");
        System.out.println("  For the developers' and authors' protection, the GPL clearly explains");
        System.out.println("that there is no warranty for this free software.  For both users' and");
        System.out.println("authors' sake, the GPL requires that modified versions be marked as");
        System.out.println("changed, so that their problems will not be attributed erroneously to");
        System.out.println("authors of previous versions.");
        System.out.println("");
        System.out.println("  Some devices are designed to deny users access to install or run");
        System.out.println("modified versions of the software inside them, although the manufacturer");
        System.out.println("can do so.  This is fundamentally incompatible with the aim of");
        System.out.println("protecting users' freedom to change the software.  The systematic");
        System.out.println("pattern of such abuse occurs in the area of products for individuals to");
        System.out.println("use, which is precisely where it is most unacceptable.  Therefore, we");
        System.out.println("have designed this version of the GPL to prohibit the practice for those");
        System.out.println("products.  If such problems arise substantially in other domains, we");
        System.out.println("stand ready to extend this provision to those domains in future versions");
        System.out.println("of the GPL, as needed to protect the freedom of users.");
        System.out.println("");
        System.out.println("  Finally, every program is threatened constantly by software patents.");
        System.out.println("States should not allow patents to restrict development and use of");
        System.out.println("software on general-purpose computers, but in those that do, we wish to");
        System.out.println("avoid the special danger that patents applied to a free program could");
        System.out.println("make it effectively proprietary.  To prevent this, the GPL assures that");
        System.out.println("patents cannot be used to render the program non-free.");
        System.out.println("");
        System.out.println("  The precise terms and conditions for copying, distribution and");
        System.out.println("modification follow.");
        System.out.println("");
        System.out.println("                       TERMS AND CONDITIONS");
        System.out.println("");
        System.out.println("  0. Definitions.");
        System.out.println("");
        System.out.println("  \"This License\" refers to version 3 of the GNU General Public License.");
        System.out.println("");
        System.out.println("  \"Copyright\" also means copyright-like laws that apply to other kinds of");
        System.out.println("works, such as semiconductor masks.");
        System.out.println("");
        System.out.println("  \"The Program\" refers to any copyrightable work licensed under this");
        System.out.println("License.  Each licensee is addressed as \"you\".  \"Licensees\" and");
        System.out.println("\"recipients\" may be individuals or organizations.");
        System.out.println("");
        System.out.println("  To \"modify\" a work means to copy from or adapt all or part of the work");
        System.out.println("in a fashion requiring copyright permission, other than the making of an");
        System.out.println("exact copy.  The resulting work is called a \"modified version\" of the");
        System.out.println("earlier work or a work \"based on\" the earlier work.");
        System.out.println("");
        System.out.println("  A \"covered work\" means either the unmodified Program or a work based");
        System.out.println("on the Program.");
        System.out.println("");
        System.out.println("  To \"propagate\" a work means to do anything with it that, without");
        System.out.println("permission, would make you directly or secondarily liable for");
        System.out.println("infringement under applicable copyright law, except executing it on a");
        System.out.println("computer or modifying a private copy.  Propagation includes copying,");
        System.out.println("distribution (with or without modification), making available to the");
        System.out.println("public, and in some countries other activities as well.");
        System.out.println("");
        System.out.println("  To \"convey\" a work means any kind of propagation that enables other");
        System.out.println("parties to make or receive copies.  Mere interaction with a user through");
        System.out.println("a computer network, with no transfer of a copy, is not conveying.");
        System.out.println("");
        System.out.println("  An interactive user interface displays \"Appropriate Legal Notices\"");
        System.out.println("to the extent that it includes a convenient and prominently visible");
        System.out.println("feature that (1) displays an appropriate copyright notice, and (2)");
        System.out.println("tells the user that there is no warranty for the work (except to the");
        System.out.println("extent that warranties are provided), that licensees may convey the");
        System.out.println("work under this License, and how to view a copy of this License.  If");
        System.out.println("the interface presents a list of user commands or options, such as a");
        System.out.println("menu, a prominent item in the list meets this criterion.");
        System.out.println("");
        System.out.println("  1. Source Code.");
        System.out.println("");
        System.out.println("  The \"source code\" for a work means the preferred form of the work");
        System.out.println("for making modifications to it.  \"Object code\" means any non-source");
        System.out.println("form of a work.");
        System.out.println("");
        System.out.println("  A \"Standard Interface\" means an interface that either is an official");
        System.out.println("standard defined by a recognized standards body, or, in the case of");
        System.out.println("interfaces specified for a particular programming language, one that");
        System.out.println("is widely used among developers working in that language.");
        System.out.println("");
        System.out.println("  The \"System Libraries\" of an executable work include anything, other");
        System.out.println("than the work as a whole, that (a) is included in the normal form of");
        System.out.println("packaging a Major Component, but which is not part of that Major");
        System.out.println("Component, and (b) serves only to enable use of the work with that");
        System.out.println("Major Component, or to implement a Standard Interface for which an");
        System.out.println("implementation is available to the public in source code form.  A");
        System.out.println("\"Major Component\", in this context, means a major essential component");
        System.out.println("(kernel, window system, and so on) of the specific operating system");
        System.out.println("(if any) on which the executable work runs, or a compiler used to");
        System.out.println("produce the work, or an object code interpreter used to run it.");
        System.out.println("");
        System.out.println("  The \"Corresponding Source\" for a work in object code form means all");
        System.out.println("the source code needed to generate, install, and (for an executable");
        System.out.println("work) run the object code and to modify the work, including scripts to");
        System.out.println("control those activities.  However, it does not include the work's");
        System.out.println("System Libraries, or general-purpose tools or generally available free");
        System.out.println("programs which are used unmodified in performing those activities but");
        System.out.println("which are not part of the work.  For example, Corresponding Source");
        System.out.println("includes interface definition files associated with source files for");
        System.out.println("the work, and the source code for shared libraries and dynamically");
        System.out.println("linked subprograms that the work is specifically designed to require,");
        System.out.println("such as by intimate data communication or control flow between those");
        System.out.println("subprograms and other parts of the work.");
        System.out.println("");
        System.out.println("  The Corresponding Source need not include anything that users");
        System.out.println("can regenerate automatically from other parts of the Corresponding");
        System.out.println("Source.");
        System.out.println("");
        System.out.println("  The Corresponding Source for a work in source code form is that");
        System.out.println("same work.");
        System.out.println("");
        System.out.println("  2. Basic Permissions.");
        System.out.println("");
        System.out.println("  All rights granted under this License are granted for the term of");
        System.out.println("copyright on the Program, and are irrevocable provided the stated");
        System.out.println("conditions are met.  This License explicitly affirms your unlimited");
        System.out.println("permission to run the unmodified Program.  The output from running a");
        System.out.println("covered work is covered by this License only if the output, given its");
        System.out.println("content, constitutes a covered work.  This License acknowledges your");
        System.out.println("rights of fair use or other equivalent, as provided by copyright law.");
        System.out.println("");
        System.out.println("  You may make, run and propagate covered works that you do not");
        System.out.println("convey, without conditions so long as your license otherwise remains");
        System.out.println("in force.  You may convey covered works to others for the sole purpose");
        System.out.println("of having them make modifications exclusively for you, or provide you");
        System.out.println("with facilities for running those works, provided that you comply with");
        System.out.println("the terms of this License in conveying all material for which you do");
        System.out.println("not control copyright.  Those thus making or running the covered works");
        System.out.println("for you must do so exclusively on your behalf, under your direction");
        System.out.println("and control, on terms that prohibit them from making any copies of");
        System.out.println("your copyrighted material outside their relationship with you.");
        System.out.println("");
        System.out.println("  Conveying under any other circumstances is permitted solely under");
        System.out.println("the conditions stated below.  Sublicensing is not allowed; section 10");
        System.out.println("makes it unnecessary.");
        System.out.println("");
        System.out.println("  3. Protecting Users' Legal Rights From Anti-Circumvention Law.");
        System.out.println("");
        System.out.println("  No covered work shall be deemed part of an effective technological");
        System.out.println("measure under any applicable law fulfilling obligations under article");
        System.out.println("11 of the WIPO copyright treaty adopted on 20 December 1996, or");
        System.out.println("similar laws prohibiting or restricting circumvention of such");
        System.out.println("measures.");
        System.out.println("");
        System.out.println("  When you convey a covered work, you waive any legal power to forbid");
        System.out.println("circumvention of technological measures to the extent such circumvention");
        System.out.println("is effected by exercising rights under this License with respect to");
        System.out.println("the covered work, and you disclaim any intention to limit operation or");
        System.out.println("modification of the work as a means of enforcing, against the work's");
        System.out.println("users, your or third parties' legal rights to forbid circumvention of");
        System.out.println("technological measures.");
        System.out.println("");
        System.out.println("  4. Conveying Verbatim Copies.");
        System.out.println("");
        System.out.println("  You may convey verbatim copies of the Program's source code as you");
        System.out.println("receive it, in any medium, provided that you conspicuously and");
        System.out.println("appropriately publish on each copy an appropriate copyright notice;");
        System.out.println("keep intact all notices stating that this License and any");
        System.out.println("non-permissive terms added in accord with section 7 apply to the code;");
        System.out.println("keep intact all notices of the absence of any warranty; and give all");
        System.out.println("recipients a copy of this License along with the Program.");
        System.out.println("");
        System.out.println("  You may charge any price or no price for each copy that you convey,");
        System.out.println("and you may offer support or warranty protection for a fee.");
        System.out.println("");
        System.out.println("  5. Conveying Modified Source Versions.");
        System.out.println("");
        System.out.println("  You may convey a work based on the Program, or the modifications to");
        System.out.println("produce it from the Program, in the form of source code under the");
        System.out.println("terms of section 4, provided that you also meet all of these conditions:");
        System.out.println("");
        System.out.println("    a) The work must carry prominent notices stating that you modified");
        System.out.println("    it, and giving a relevant date.");
        System.out.println("");
        System.out.println("    b) The work must carry prominent notices stating that it is");
        System.out.println("    released under this License and any conditions added under section");
        System.out.println("    7.  This requirement modifies the requirement in section 4 to");
        System.out.println("    \"keep intact all notices\".");
        System.out.println("");
        System.out.println("    c) You must license the entire work, as a whole, under this");
        System.out.println("    License to anyone who comes into possession of a copy.  This");
        System.out.println("    License will therefore apply, along with any applicable section 7");
        System.out.println("    additional terms, to the whole of the work, and all its parts,");
        System.out.println("    regardless of how they are packaged.  This License gives no");
        System.out.println("    permission to license the work in any other way, but it does not");
        System.out.println("    invalidate such permission if you have separately received it.");
        System.out.println("");
        System.out.println("    d) If the work has interactive user interfaces, each must display");
        System.out.println("    Appropriate Legal Notices; however, if the Program has interactive");
        System.out.println("    interfaces that do not display Appropriate Legal Notices, your");
        System.out.println("    work need not make them do so.");
        System.out.println("");
        System.out.println("  A compilation of a covered work with other separate and independent");
        System.out.println("works, which are not by their nature extensions of the covered work,");
        System.out.println("and which are not combined with it such as to form a larger program,");
        System.out.println("in or on a volume of a storage or distribution medium, is called an");
        System.out.println("\"aggregate\" if the compilation and its resulting copyright are not");
        System.out.println("used to limit the access or legal rights of the compilation's users");
        System.out.println("beyond what the individual works permit.  Inclusion of a covered work");
        System.out.println("in an aggregate does not cause this License to apply to the other");
        System.out.println("parts of the aggregate.");
        System.out.println("");
        System.out.println("  6. Conveying Non-Source Forms.");
        System.out.println("");
        System.out.println("  You may convey a covered work in object code form under the terms");
        System.out.println("of sections 4 and 5, provided that you also convey the");
        System.out.println("machine-readable Corresponding Source under the terms of this License,");
        System.out.println("in one of these ways:");
        System.out.println("");
        System.out.println("    a) Convey the object code in, or embodied in, a physical product");
        System.out.println("    (including a physical distribution medium), accompanied by the");
        System.out.println("    Corresponding Source fixed on a durable physical medium");
        System.out.println("    customarily used for software interchange.");
        System.out.println("");
        System.out.println("    b) Convey the object code in, or embodied in, a physical product");
        System.out.println("    (including a physical distribution medium), accompanied by a");
        System.out.println("    written offer, valid for at least three years and valid for as");
        System.out.println("    long as you offer spare parts or customer support for that product");
        System.out.println("    model, to give anyone who possesses the object code either (1) a");
        System.out.println("    copy of the Corresponding Source for all the software in the");
        System.out.println("    product that is covered by this License, on a durable physical");
        System.out.println("    medium customarily used for software interchange, for a price no");
        System.out.println("    more than your reasonable cost of physically performing this");
        System.out.println("    conveying of source, or (2) access to copy the");
        System.out.println("    Corresponding Source from a network server at no charge.");
        System.out.println("");
        System.out.println("    c) Convey individual copies of the object code with a copy of the");
        System.out.println("    written offer to provide the Corresponding Source.  This");
        System.out.println("    alternative is allowed only occasionally and noncommercially, and");
        System.out.println("    only if you received the object code with such an offer, in accord");
        System.out.println("    with subsection 6b.");
        System.out.println("");
        System.out.println("    d) Convey the object code by offering access from a designated");
        System.out.println("    place (gratis or for a charge), and offer equivalent access to the");
        System.out.println("    Corresponding Source in the same way through the same place at no");
        System.out.println("    further charge.  You need not require recipients to copy the");
        System.out.println("    Corresponding Source along with the object code.  If the place to");
        System.out.println("    copy the object code is a network server, the Corresponding Source");
        System.out.println("    may be on a different server (operated by you or a third party)");
        System.out.println("    that supports equivalent copying facilities, provided you maintain");
        System.out.println("    clear directions next to the object code saying where to find the");
        System.out.println("    Corresponding Source.  Regardless of what server hosts the");
        System.out.println("    Corresponding Source, you remain obligated to ensure that it is");
        System.out.println("    available for as long as needed to satisfy these requirements.");
        System.out.println("");
        System.out.println("    e) Convey the object code using peer-to-peer transmission, provided");
        System.out.println("    you inform other peers where the object code and Corresponding");
        System.out.println("    Source of the work are being offered to the general public at no");
        System.out.println("    charge under subsection 6d.");
        System.out.println("");
        System.out.println("  A separable portion of the object code, whose source code is excluded");
        System.out.println("from the Corresponding Source as a System Library, need not be");
        System.out.println("included in conveying the object code work.");
        System.out.println("");
        System.out.println("  A \"User Product\" is either (1) a \"consumer product\", which means any");
        System.out.println("tangible personal property which is normally used for personal, family,");
        System.out.println("or household purposes, or (2) anything designed or sold for incorporation");
        System.out.println("into a dwelling.  In determining whether a product is a consumer product,");
        System.out.println("doubtful cases shall be resolved in favor of coverage.  For a particular");
        System.out.println("product received by a particular user, \"normally used\" refers to a");
        System.out.println("typical or common use of that class of product, regardless of the status");
        System.out.println("of the particular user or of the way in which the particular user");
        System.out.println("actually uses, or expects or is expected to use, the product.  A product");
        System.out.println("is a consumer product regardless of whether the product has substantial");
        System.out.println("commercial, industrial or non-consumer uses, unless such uses represent");
        System.out.println("the only significant mode of use of the product.");
        System.out.println("");
        System.out.println("  \"Installation Information\" for a User Product means any methods,");
        System.out.println("procedures, authorization keys, or other information required to install");
        System.out.println("and execute modified versions of a covered work in that User Product from");
        System.out.println("a modified version of its Corresponding Source.  The information must");
        System.out.println("suffice to ensure that the continued functioning of the modified object");
        System.out.println("code is in no case prevented or interfered with solely because");
        System.out.println("modification has been made.");
        System.out.println("");
        System.out.println("  If you convey an object code work under this section in, or with, or");
        System.out.println("specifically for use in, a User Product, and the conveying occurs as");
        System.out.println("part of a transaction in which the right of possession and use of the");
        System.out.println("User Product is transferred to the recipient in perpetuity or for a");
        System.out.println("fixed term (regardless of how the transaction is characterized), the");
        System.out.println("Corresponding Source conveyed under this section must be accompanied");
        System.out.println("by the Installation Information.  But this requirement does not apply");
        System.out.println("if neither you nor any third party retains the ability to install");
        System.out.println("modified object code on the User Product (for example, the work has");
        System.out.println("been installed in ROM).");
        System.out.println("");
        System.out.println("  The requirement to provide Installation Information does not include a");
        System.out.println("requirement to continue to provide support service, warranty, or updates");
        System.out.println("for a work that has been modified or installed by the recipient, or for");
        System.out.println("the User Product in which it has been modified or installed.  Access to a");
        System.out.println("network may be denied when the modification itself materially and");
        System.out.println("adversely affects the operation of the network or violates the rules and");
        System.out.println("protocols for communication across the network.");
        System.out.println("");
        System.out.println("  Corresponding Source conveyed, and Installation Information provided,");
        System.out.println("in accord with this section must be in a format that is publicly");
        System.out.println("documented (and with an implementation available to the public in");
        System.out.println("source code form), and must require no special password or key for");
        System.out.println("unpacking, reading or copying.");
        System.out.println("");
        System.out.println("  7. Additional Terms.");
        System.out.println("");
        System.out.println("  \"Additional permissions\" are terms that supplement the terms of this");
        System.out.println("License by making exceptions from one or more of its conditions.");
        System.out.println("Additional permissions that are applicable to the entire Program shall");
        System.out.println("be treated as though they were included in this License, to the extent");
        System.out.println("that they are valid under applicable law.  If additional permissions");
        System.out.println("apply only to part of the Program, that part may be used separately");
        System.out.println("under those permissions, but the entire Program remains governed by");
        System.out.println("this License without regard to the additional permissions.");
        System.out.println("");
        System.out.println("  When you convey a copy of a covered work, you may at your option");
        System.out.println("remove any additional permissions from that copy, or from any part of");
        System.out.println("it.  (Additional permissions may be written to require their own");
        System.out.println("removal in certain cases when you modify the work.)  You may place");
        System.out.println("additional permissions on material, added by you to a covered work,");
        System.out.println("for which you have or can give appropriate copyright permission.");
        System.out.println("");
        System.out.println("  Notwithstanding any other provision of this License, for material you");
        System.out.println("add to a covered work, you may (if authorized by the copyright holders of");
        System.out.println("that material) supplement the terms of this License with terms:");
        System.out.println("");
        System.out.println("    a) Disclaiming warranty or limiting liability differently from the");
        System.out.println("    terms of sections 15 and 16 of this License; or");
        System.out.println("");
        System.out.println("    b) Requiring preservation of specified reasonable legal notices or");
        System.out.println("    author attributions in that material or in the Appropriate Legal");
        System.out.println("    Notices displayed by works containing it; or");
        System.out.println("");
        System.out.println("    c) Prohibiting misrepresentation of the origin of that material, or");
        System.out.println("    requiring that modified versions of such material be marked in");
        System.out.println("    reasonable ways as different from the original version; or");
        System.out.println("");
        System.out.println("    d) Limiting the use for publicity purposes of names of licensors or");
        System.out.println("    authors of the material; or");
        System.out.println("");
        System.out.println("    e) Declining to grant rights under trademark law for use of some");
        System.out.println("    trade names, trademarks, or service marks; or");
        System.out.println("");
        System.out.println("    f) Requiring indemnification of licensors and authors of that");
        System.out.println("    material by anyone who conveys the material (or modified versions of");
        System.out.println("    it) with contractual assumptions of liability to the recipient, for");
        System.out.println("    any liability that these contractual assumptions directly impose on");
        System.out.println("    those licensors and authors.");
        System.out.println("");
        System.out.println("  All other non-permissive additional terms are considered \"further");
        System.out.println("restrictions\" within the meaning of section 10.  If the Program as you");
        System.out.println("received it, or any part of it, contains a notice stating that it is");
        System.out.println("governed by this License along with a term that is a further");
        System.out.println("restriction, you may remove that term.  If a license document contains");
        System.out.println("a further restriction but permits relicensing or conveying under this");
        System.out.println("License, you may add to a covered work material governed by the terms");
        System.out.println("of that license document, provided that the further restriction does");
        System.out.println("not survive such relicensing or conveying.");
        System.out.println("");
        System.out.println("  If you add terms to a covered work in accord with this section, you");
        System.out.println("must place, in the relevant source files, a statement of the");
        System.out.println("additional terms that apply to those files, or a notice indicating");
        System.out.println("where to find the applicable terms.");
        System.out.println("");
        System.out.println("  Additional terms, permissive or non-permissive, may be stated in the");
        System.out.println("form of a separately written license, or stated as exceptions;");
        System.out.println("the above requirements apply either way.");
        System.out.println("");
        System.out.println("  8. Termination.");
        System.out.println("");
        System.out.println("  You may not propagate or modify a covered work except as expressly");
        System.out.println("provided under this License.  Any attempt otherwise to propagate or");
        System.out.println("modify it is void, and will automatically terminate your rights under");
        System.out.println("this License (including any patent licenses granted under the third");
        System.out.println("paragraph of section 11).");
        System.out.println("");
        System.out.println("  However, if you cease all violation of this License, then your");
        System.out.println("license from a particular copyright holder is reinstated (a)");
        System.out.println("provisionally, unless and until the copyright holder explicitly and");
        System.out.println("finally terminates your license, and (b) permanently, if the copyright");
        System.out.println("holder fails to notify you of the violation by some reasonable means");
        System.out.println("prior to 60 days after the cessation.");
        System.out.println("");
        System.out.println("  Moreover, your license from a particular copyright holder is");
        System.out.println("reinstated permanently if the copyright holder notifies you of the");
        System.out.println("violation by some reasonable means, this is the first time you have");
        System.out.println("received notice of violation of this License (for any work) from that");
        System.out.println("copyright holder, and you cure the violation prior to 30 days after");
        System.out.println("your receipt of the notice.");
        System.out.println("");
        System.out.println("  Termination of your rights under this section does not terminate the");
        System.out.println("licenses of parties who have received copies or rights from you under");
        System.out.println("this License.  If your rights have been terminated and not permanently");
        System.out.println("reinstated, you do not qualify to receive new licenses for the same");
        System.out.println("material under section 10.");
        System.out.println("");
        System.out.println("  9. Acceptance Not Required for Having Copies.");
        System.out.println("");
        System.out.println("  You are not required to accept this License in order to receive or");
        System.out.println("run a copy of the Program.  Ancillary propagation of a covered work");
        System.out.println("occurring solely as a consequence of using peer-to-peer transmission");
        System.out.println("to receive a copy likewise does not require acceptance.  However,");
        System.out.println("nothing other than this License grants you permission to propagate or");
        System.out.println("modify any covered work.  These actions infringe copyright if you do");
        System.out.println("not accept this License.  Therefore, by modifying or propagating a");
        System.out.println("covered work, you indicate your acceptance of this License to do so.");
        System.out.println("");
        System.out.println("  10. Automatic Licensing of Downstream Recipients.");
        System.out.println("");
        System.out.println("  Each time you convey a covered work, the recipient automatically");
        System.out.println("receives a license from the original licensors, to run, modify and");
        System.out.println("propagate that work, subject to this License.  You are not responsible");
        System.out.println("for enforcing compliance by third parties with this License.");
        System.out.println("");
        System.out.println("  An \"entity transaction\" is a transaction transferring control of an");
        System.out.println("organization, or substantially all assets of one, or subdividing an");
        System.out.println("organization, or merging organizations.  If propagation of a covered");
        System.out.println("work results from an entity transaction, each party to that");
        System.out.println("transaction who receives a copy of the work also receives whatever");
        System.out.println("licenses to the work the party's predecessor in interest had or could");
        System.out.println("give under the previous paragraph, plus a right to possession of the");
        System.out.println("Corresponding Source of the work from the predecessor in interest, if");
        System.out.println("the predecessor has it or can get it with reasonable efforts.");
        System.out.println("");
        System.out.println("  You may not impose any further restrictions on the exercise of the");
        System.out.println("rights granted or affirmed under this License.  For example, you may");
        System.out.println("not impose a license fee, royalty, or other charge for exercise of");
        System.out.println("rights granted under this License, and you may not initiate litigation");
        System.out.println("(including a cross-claim or counterclaim in a lawsuit) alleging that");
        System.out.println("any patent claim is infringed by making, using, selling, offering for");
        System.out.println("sale, or importing the Program or any portion of it.");
        System.out.println("");
        System.out.println("  11. Patents.");
        System.out.println("");
        System.out.println("  A \"contributor\" is a copyright holder who authorizes use under this");
        System.out.println("License of the Program or a work on which the Program is based.  The");
        System.out.println("work thus licensed is called the contributor's \"contributor version\".");
        System.out.println("");
        System.out.println("  A contributor's \"essential patent claims\" are all patent claims");
        System.out.println("owned or controlled by the contributor, whether already acquired or");
        System.out.println("hereafter acquired, that would be infringed by some manner, permitted");
        System.out.println("by this License, of making, using, or selling its contributor version,");
        System.out.println("but do not include claims that would be infringed only as a");
        System.out.println("consequence of further modification of the contributor version.  For");
        System.out.println("purposes of this definition, \"control\" includes the right to grant");
        System.out.println("patent sublicenses in a manner consistent with the requirements of");
        System.out.println("this License.");
        System.out.println("");
        System.out.println("  Each contributor grants you a non-exclusive, worldwide, royalty-free");
        System.out.println("patent license under the contributor's essential patent claims, to");
        System.out.println("make, use, sell, offer for sale, import and otherwise run, modify and");
        System.out.println("propagate the contents of its contributor version.");
        System.out.println("");
        System.out.println("  In the following three paragraphs, a \"patent license\" is any express");
        System.out.println("agreement or commitment, however denominated, not to enforce a patent");
        System.out.println("(such as an express permission to practice a patent or covenant not to");
        System.out.println("sue for patent infringement).  To \"grant\" such a patent license to a");
        System.out.println("party means to make such an agreement or commitment not to enforce a");
        System.out.println("patent against the party.");
        System.out.println("");
        System.out.println("  If you convey a covered work, knowingly relying on a patent license,");
        System.out.println("and the Corresponding Source of the work is not available for anyone");
        System.out.println("to copy, free of charge and under the terms of this License, through a");
        System.out.println("publicly available network server or other readily accessible means,");
        System.out.println("then you must either (1) cause the Corresponding Source to be so");
        System.out.println("available, or (2) arrange to deprive yourself of the benefit of the");
        System.out.println("patent license for this particular work, or (3) arrange, in a manner");
        System.out.println("consistent with the requirements of this License, to extend the patent");
        System.out.println("license to downstream recipients.  \"Knowingly relying\" means you have");
        System.out.println("actual knowledge that, but for the patent license, your conveying the");
        System.out.println("covered work in a country, or your recipient's use of the covered work");
        System.out.println("in a country, would infringe one or more identifiable patents in that");
        System.out.println("country that you have reason to believe are valid.");
        System.out.println("");
        System.out.println("  If, pursuant to or in connection with a single transaction or");
        System.out.println("arrangement, you convey, or propagate by procuring conveyance of, a");
        System.out.println("covered work, and grant a patent license to some of the parties");
        System.out.println("receiving the covered work authorizing them to use, propagate, modify");
        System.out.println("or convey a specific copy of the covered work, then the patent license");
        System.out.println("you grant is automatically extended to all recipients of the covered");
        System.out.println("work and works based on it.");
        System.out.println("");
        System.out.println("  A patent license is \"discriminatory\" if it does not include within");
        System.out.println("the scope of its coverage, prohibits the exercise of, or is");
        System.out.println("conditioned on the non-exercise of one or more of the rights that are");
        System.out.println("specifically granted under this License.  You may not convey a covered");
        System.out.println("work if you are a party to an arrangement with a third party that is");
        System.out.println("in the business of distributing software, under which you make payment");
        System.out.println("to the third party based on the extent of your activity of conveying");
        System.out.println("the work, and under which the third party grants, to any of the");
        System.out.println("parties who would receive the covered work from you, a discriminatory");
        System.out.println("patent license (a) in connection with copies of the covered work");
        System.out.println("conveyed by you (or copies made from those copies), or (b) primarily");
        System.out.println("for and in connection with specific products or compilations that");
        System.out.println("contain the covered work, unless you entered into that arrangement,");
        System.out.println("or that patent license was granted, prior to 28 March 2007.");
        System.out.println("");
        System.out.println("  Nothing in this License shall be construed as excluding or limiting");
        System.out.println("any implied license or other defenses to infringement that may");
        System.out.println("otherwise be available to you under applicable patent law.");
        System.out.println("");
        System.out.println("  12. No Surrender of Others' Freedom.");
        System.out.println("");
        System.out.println("  If conditions are imposed on you (whether by court order, agreement or");
        System.out.println("otherwise) that contradict the conditions of this License, they do not");
        System.out.println("excuse you from the conditions of this License.  If you cannot convey a");
        System.out.println("covered work so as to satisfy simultaneously your obligations under this");
        System.out.println("License and any other pertinent obligations, then as a consequence you may");
        System.out.println("not convey it at all.  For example, if you agree to terms that obligate you");
        System.out.println("to collect a royalty for further conveying from those to whom you convey");
        System.out.println("the Program, the only way you could satisfy both those terms and this");
        System.out.println("License would be to refrain entirely from conveying the Program.");
        System.out.println("");
        System.out.println("  13. Use with the GNU Affero General Public License.");
        System.out.println("");
        System.out.println("  Notwithstanding any other provision of this License, you have");
        System.out.println("permission to link or combine any covered work with a work licensed");
        System.out.println("under version 3 of the GNU Affero General Public License into a single");
        System.out.println("combined work, and to convey the resulting work.  The terms of this");
        System.out.println("License will continue to apply to the part which is the covered work,");
        System.out.println("but the special requirements of the GNU Affero General Public License,");
        System.out.println("section 13, concerning interaction through a network will apply to the");
        System.out.println("combination as such.");
        System.out.println("");
        System.out.println("  14. Revised Versions of this License.");
        System.out.println("");
        System.out.println("  The Free Software Foundation may publish revised and/or new versions of");
        System.out.println("the GNU General Public License from time to time.  Such new versions will");
        System.out.println("be similar in spirit to the present version, but may differ in detail to");
        System.out.println("address new problems or concerns.");
        System.out.println("");
        System.out.println("  Each version is given a distinguishing version number.  If the");
        System.out.println("Program specifies that a certain numbered version of the GNU General");
        System.out.println("Public License \"or any later version\" applies to it, you have the");
        System.out.println("option of following the terms and conditions either of that numbered");
        System.out.println("version or of any later version published by the Free Software");
        System.out.println("Foundation.  If the Program does not specify a version number of the");
        System.out.println("GNU General Public License, you may choose any version ever published");
        System.out.println("by the Free Software Foundation.");
        System.out.println("");
        System.out.println("  If the Program specifies that a proxy can decide which future");
        System.out.println("versions of the GNU General Public License can be used, that proxy's");
        System.out.println("public statement of acceptance of a version permanently authorizes you");
        System.out.println("to choose that version for the Program.");
        System.out.println("");
        System.out.println("  Later license versions may give you additional or different");
        System.out.println("permissions.  However, no additional obligations are imposed on any");
        System.out.println("author or copyright holder as a result of your choosing to follow a");
        System.out.println("later version.");
        System.out.println("");
        System.out.println("  15. Disclaimer of Warranty.");
        System.out.println("");
        System.out.println("  THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY");
        System.out.println("APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT");
        System.out.println("HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY");
        System.out.println("OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,");
        System.out.println("THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR");
        System.out.println("PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM");
        System.out.println("IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF");
        System.out.println("ALL NECESSARY SERVICING, REPAIR OR CORRECTION.");
        System.out.println("");
        System.out.println("  16. Limitation of Liability.");
        System.out.println("");
        System.out.println("  IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING");
        System.out.println("WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS");
        System.out.println("THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY");
        System.out.println("GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE");
        System.out.println("USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF");
        System.out.println("DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD");
        System.out.println("PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),");
        System.out.println("EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF");
        System.out.println("SUCH DAMAGES.");
        System.out.println("");
        System.out.println("  17. Interpretation of Sections 15 and 16.");
        System.out.println("");
        System.out.println("  If the disclaimer of warranty and limitation of liability provided");
        System.out.println("above cannot be given local legal effect according to their terms,");
        System.out.println("reviewing courts shall apply local law that most closely approximates");
        System.out.println("an absolute waiver of all civil liability in connection with the");
        System.out.println("Program, unless a warranty or assumption of liability accompanies a");
        System.out.println("copy of the Program in return for a fee.");
        System.out.println("");
        System.out.println("                     END OF TERMS AND CONDITIONS");
        System.out.println("");
        System.out.println("            How to Apply These Terms to Your New Programs");
        System.out.println("");
        System.out.println("  If you develop a new program, and you want it to be of the greatest");
        System.out.println("possible use to the public, the best way to achieve this is to make it");
        System.out.println("free software which everyone can redistribute and change under these terms.");
        System.out.println("");
        System.out.println("  To do so, attach the following notices to the program.  It is safest");
        System.out.println("to attach them to the start of each source file to most effectively");
        System.out.println("state the exclusion of warranty; and each file should have at least");
        System.out.println("the \"copyright\" line and a pointer to where the full notice is found.");
        System.out.println("");
        System.out.println("    <one line to give the program's name and a brief idea of what it does.>");
        System.out.println("    Copyright (C) <year>  <name of author>");
        System.out.println("");
        System.out.println("    This program is free software: you can redistribute it and/or modify");
        System.out.println("    it under the terms of the GNU General Public License as published by");
        System.out.println("    the Free Software Foundation, either version 3 of the License, or");
        System.out.println("    (at your option) any later version.");
        System.out.println("");
        System.out.println("    This program is distributed in the hope that it will be useful,");
        System.out.println("    but WITHOUT ANY WARRANTY; without even the implied warranty of");
        System.out.println("    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
        System.out.println("    GNU General Public License for more details.");
        System.out.println("");
        System.out.println("    You should have received a copy of the GNU General Public License");
        System.out.println("    along with this program.  If not, see <http://www.gnu.org/licenses/>.");
        System.out.println("");
        System.out.println("Also add information on how to contact you by electronic and paper mail.");
        System.out.println("");
        System.out.println("  If the program does terminal interaction, make it output a short");
        System.out.println("notice like this when it starts in an interactive mode:");
        System.out.println("");
        System.out.println("    <program>  Copyright (C) <year>  <name of author>");
        System.out.println("    This program comes with ABSOLUTELY NO WARRANTY; for details type `show w'.");
        System.out.println("    This is free software, and you are welcome to redistribute it");
        System.out.println("    under certain conditions; type `show c' for details.");
        System.out.println("");
        System.out.println("The hypothetical commands `show w' and `show c' should show the appropriate");
        System.out.println("parts of the General Public License.  Of course, your program's commands");
        System.out.println("might be different; for a GUI interface, you would use an \"about box\".");
        System.out.println("");
        System.out.println("  You should also get your employer (if you work as a programmer) or school,");
        System.out.println("if any, to sign a \"copyright disclaimer\" for the program, if necessary.");
        System.out.println("For more information on this, and how to apply and follow the GNU GPL, see");
        System.out.println("<http://www.gnu.org/licenses/>.");
        System.out.println("");
        System.out.println("  The GNU General Public License does not permit incorporating your program");
        System.out.println("into proprietary programs.  If your program is a subroutine library, you");
        System.out.println("may consider it more useful to permit linking proprietary applications with");
        System.out.println("the library.  If this is what you want to do, use the GNU Lesser General");
        System.out.println("Public License instead of this License.  But first, please read");
        System.out.println("<http://www.gnu.org/philosophy/why-not-lgpl.html>.");
    }
}

