/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import java.util.ArrayList;
import java.util.Random;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.distance.ClusDistance;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTimeSeries;
import si.ijs.kt.clus.statistic.BitVectorStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class SumPairwiseDistancesStat
extends BitVectorStat {
    public static final long serialVersionUID = 1L;
    public static final int linearParameter = 10;
    public static final Random m_Random = new Random(0L);
    protected double m_SVarS;
    protected ClusDistance m_Distance;
    protected SettingsTimeSeries.TimeSeriesPrototypeComplexity m_Efficiency = SettingsTimeSeries.TimeSeriesPrototypeComplexity.Linear;

    public SumPairwiseDistancesStat(Settings sett, ClusDistance dist) {
        super(sett);
        this.m_Distance = dist;
    }

    public SumPairwiseDistancesStat(Settings sett, ClusDistance dist, SettingsTimeSeries.TimeSeriesPrototypeComplexity efflvl) {
        this(sett, dist);
        this.m_Efficiency = efflvl;
    }

    @Override
    public ClusStatistic cloneStat() {
        return new SumPairwiseDistancesStat(this.m_Settings, this.m_Distance, this.m_Efficiency);
    }

    @Override
    public double getSVarS(ClusAttributeWeights scale, RowData data) throws ClusException {
        this.optimizePreCalc(data);
        return this.m_SVarS;
    }

    public SettingsTimeSeries.TimeSeriesPrototypeComplexity getEfficiencyLevel() {
        return this.m_Efficiency;
    }

    @Override
    public void optimizePreCalc(RowData data) throws ClusException {
        if (!this.m_Modified) {
            return;
        }
        switch (this.getEfficiencyLevel()) {
            case Log: {
                this.optimizeLogPreCalc(data);
                break;
            }
            case Linear: {
                this.optimizeLinearPreCalc(data);
                break;
            }
            default: {
                this.optimizePreCalcExact(data);
            }
        }
        this.m_Modified = false;
    }

    public double calcDistance(DataTuple t1, DataTuple t2) throws ClusException {
        return this.m_Distance.calcDistance(t1, t2);
    }

    public double calcDistanceToCentroid(DataTuple t1) throws ClusException {
        return this.m_Distance.calcDistanceToCentroid(t1, this);
    }

    public void optimizePreCalcExact(RowData data) throws ClusException {
        this.m_SVarS = 0.0;
        double sumWiDiag = 0.0;
        double sumWiTria = 0.0;
        int nb = this.m_Bits.size();
        ArrayList<Integer> presentIndices = new ArrayList<Integer>();
        for (int i = 0; i < nb; ++i) {
            if (!this.m_Bits.getBit(i)) continue;
            presentIndices.add(i);
        }
        int nbPresent = presentIndices.size();
        for (int ii = 0; ii < nbPresent; ++ii) {
            int i = (Integer)presentIndices.get(ii);
            DataTuple a = data.getTuple(i);
            double a_weight = a.getWeight();
            for (int jj = 0; jj < ii; ++jj) {
                int j = (Integer)presentIndices.get(jj);
                DataTuple b = data.getTuple(j);
                double wi = a_weight * b.getWeight();
                double d = this.calcDistance(a, b);
                this.m_SVarS += wi * d;
                sumWiTria += wi;
            }
            sumWiDiag += a_weight * a_weight;
        }
        this.m_SVarS = this.getTotalWeight() * this.m_SVarS / (2.0 * sumWiTria + sumWiDiag);
    }

    public static final int Sampling_K_Random(int a, int b) {
        return a + m_Random.nextInt(b + 1);
    }

    public void optimizeLinearPreCalc(RowData data) throws ClusException {
        this.optimizeLinearPreCalc(data, 10);
    }

    public void optimizeLinearPreCalc(RowData data, int samplenb) throws ClusException {
        this.m_SVarS = 0.0;
        int nb = this.m_Bits.size();
        int nb_total = 0;
        int[] indices = new int[nb];
        for (int i = 0; i < nb; ++i) {
            if (!this.m_Bits.getBit(i)) continue;
            indices[nb_total++] = i;
        }
        if (nb_total < samplenb) {
            this.optimizePreCalcExact(data);
            return;
        }
        double sumWi = 0.0;
        for (int i = 0; i < nb; ++i) {
            if (!this.m_Bits.getBit(i)) continue;
            DataTuple a = data.getTuple(i);
            double a_weight = a.getWeight();
            int T = 0;
            int M = 0;
            while (M < samplenb) {
                if (SumPairwiseDistancesStat.Sampling_K_Random(0, nb_total - T - 1) < samplenb - M) {
                    DataTuple b = data.getTuple(indices[T]);
                    double wi = a_weight * b.getWeight();
                    double d = this.calcDistance(a, b);
                    this.m_SVarS += wi * d;
                    sumWi += wi;
                    ++M;
                }
                ++T;
            }
        }
        this.m_SVarS = this.getTotalWeight() * this.m_SVarS / sumWi / 2.0;
    }

    public void optimizePairwiseLinearPreCalc(RowData data) throws ClusException {
        this.m_SVarS = 0.0;
        int nb = this.m_Bits.size();
        int nb_total = 0;
        int[] indices = new int[nb];
        for (int i = 0; i < nb; ++i) {
            if (!this.m_Bits.getBit(i)) continue;
            indices[nb_total++] = i;
        }
        double sumWi = 0.0;
        for (int i = 0; i < nb_total; ++i) {
            int a = SumPairwiseDistancesStat.Sampling_K_Random(0, nb_total - 1);
            DataTuple dt1 = data.getTuple(indices[a]);
            int b = SumPairwiseDistancesStat.Sampling_K_Random(0, nb_total - 1);
            DataTuple dt2 = data.getTuple(indices[b]);
            double wi = dt1.getWeight() * dt2.getWeight();
            this.m_SVarS += wi * this.calcDistance(dt1, dt2);
            sumWi += wi;
        }
        this.m_SVarS = this.getTotalWeight() * this.m_SVarS / sumWi;
    }

    public void optimizeLogPreCalc(RowData data) throws ClusException {
        int nb = this.getNbTuples();
        int lognb = (int)Math.floor(Math.log(nb) / Math.log(2.0)) + 1;
        this.optimizeLinearPreCalc(data, lognb);
    }

    @Override
    public void copy(ClusStatistic other) {
        super.copy(other);
        SumPairwiseDistancesStat or = (SumPairwiseDistancesStat)other;
        this.m_SVarS = or.m_SVarS;
    }

    @Override
    public void calcMean() throws ClusException {
    }

    @Override
    public ClusDistance getDistance() {
        return this.m_Distance;
    }

    @Override
    public String getDistanceName() {
        return this.getDistance().getDistanceName();
    }
}

