/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import java.util.Arrays;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.ComponentStatistic;
import si.ijs.kt.clus.statistic.RegressionStatBase;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;

public class RegressionStatBinaryNomiss
extends RegressionStatBase
implements ComponentStatistic {
    public static final long serialVersionUID = 1L;
    protected double[] m_SumValues;
    public WHTDStatistic m_ParentStat;
    public WHTDStatistic m_Training;

    public RegressionStatBinaryNomiss(Settings sett, NumericAttrType[] attrs) {
        this(sett, attrs, false);
    }

    public RegressionStatBinaryNomiss(Settings sett, NumericAttrType[] attrs, boolean onlymean) {
        super(sett, attrs, onlymean);
        if (!onlymean) {
            this.m_SumValues = new double[this.m_NbAttrs];
        }
    }

    @Override
    public ClusStatistic cloneStat() {
        return new RegressionStatBinaryNomiss(this.m_Settings, this.m_Attrs, false);
    }

    @Override
    public ClusStatistic cloneSimple() {
        return new RegressionStatBinaryNomiss(this.m_Settings, this.m_Attrs, true);
    }

    @Override
    public ClusStatistic copyNormalizedWeighted(double weight) {
        RegressionStatBinaryNomiss newStat = this.normalizedCopy();
        for (int iTarget = 0; iTarget < newStat.getNbAttributes(); ++iTarget) {
            newStat.m_Means[iTarget] = weight * newStat.m_Means[iTarget];
        }
        return newStat;
    }

    @Override
    public void reset() {
        this.m_SumWeight = 0.0;
        this.m_NbExamples = 0;
        Arrays.fill(this.m_SumValues, 0.0);
    }

    @Override
    public void copy(ClusStatistic other) {
        RegressionStatBinaryNomiss or = (RegressionStatBinaryNomiss)other;
        this.m_SumWeight = or.m_SumWeight;
        this.m_NbExamples = or.m_NbExamples;
        System.arraycopy(or.m_SumValues, 0, this.m_SumValues, 0, this.m_NbAttrs);
    }

    @Override
    public RegressionStatBinaryNomiss normalizedCopy() {
        RegressionStatBinaryNomiss copy = (RegressionStatBinaryNomiss)this.cloneSimple();
        copy.m_NbExamples = 0;
        copy.m_SumWeight = 1.0;
        this.calcMean(copy.m_Means);
        return copy;
    }

    @Override
    public void add(ClusStatistic other) {
        RegressionStatBinaryNomiss or = (RegressionStatBinaryNomiss)other;
        this.m_SumWeight += or.m_SumWeight;
        this.m_NbExamples += or.m_NbExamples;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumValues[n] = this.m_SumValues[n] + or.m_SumValues[i];
        }
    }

    @Override
    public void addScaled(double scale, ClusStatistic other) {
        RegressionStatBinaryNomiss or = (RegressionStatBinaryNomiss)other;
        this.m_SumWeight += scale * or.m_SumWeight;
        this.m_NbExamples += or.m_NbExamples;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumValues[n] = this.m_SumValues[n] + scale * or.m_SumValues[i];
        }
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
        RegressionStatBinaryNomiss or = (RegressionStatBinaryNomiss)other;
        this.m_SumWeight -= or.m_SumWeight;
        this.m_NbExamples -= or.m_NbExamples;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            int n = i;
            this.m_SumValues[n] = this.m_SumValues[n] - or.m_SumValues[i];
        }
    }

    @Override
    public void subtractFromOther(ClusStatistic other) {
        RegressionStatBinaryNomiss or = (RegressionStatBinaryNomiss)other;
        this.m_SumWeight = or.m_SumWeight - this.m_SumWeight;
        this.m_NbExamples = or.m_NbExamples - this.m_NbExamples;
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            this.m_SumValues[i] = or.m_SumValues[i] - this.m_SumValues[i];
        }
    }

    @Override
    public void calcMean(double[] means) {
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            means[i] = this.getMean(i);
        }
    }

    @Override
    public double getMean(int i) {
        return this.m_SumWeight != 0.0 ? this.m_SumValues[i] / this.m_SumWeight : 0.0;
    }

    @Override
    public double getSVarS(int i) {
        double n_tot = this.m_SumWeight;
        double sv_tot = this.m_SumValues[i];
        return sv_tot - sv_tot * sv_tot / n_tot;
    }

    @Override
    public double getSVarS(ClusAttributeWeights scale) {
        double result = 0.0;
        double n_tot = this.m_SumWeight;
        if (n_tot == 0.0) {
            return this.getEstimatedSVarS(scale) / (double)this.m_NbAttrs;
        }
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            double sv_tot = this.m_SumValues[i];
            result += (sv_tot - sv_tot * sv_tot / n_tot) * scale.getWeight(this.m_Attrs[i]);
        }
        return result / (double)this.m_NbAttrs;
    }

    @Override
    public double getSVarSDiff(ClusAttributeWeights scale, ClusStatistic other) {
        double result = 0.0;
        RegressionStatBinaryNomiss or = (RegressionStatBinaryNomiss)other;
        double n_tot = this.m_SumWeight - or.m_SumWeight;
        if (n_tot == 0.0) {
            return or.getEstimatedSVarS(scale) / (double)this.m_NbAttrs;
        }
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            double sv_tot = this.m_SumValues[i] - or.m_SumValues[i];
            result += (sv_tot - sv_tot * sv_tot / n_tot) * scale.getWeight(this.m_Attrs[i]);
        }
        return result / (double)this.m_NbAttrs;
    }

    public double getEstimatedSVarS(ClusAttributeWeights scale) {
        switch (this.getSettings().getTree().getMissingClusteringAttrHandling()) {
            case EstimateFromParentNode: {
                if (this.m_ParentStat == null) {
                    return Double.NaN;
                }
                return this.m_ParentStat.getSVarS(scale);
            }
            case Ignore: {
                return Double.NaN;
            }
        }
        if (this.m_Training == null) {
            return Double.NaN;
        }
        return this.m_Training.getSVarS(scale);
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(fr.format(this.getMean(i)));
        }
        buf.append("]");
        if (info.SHOW_EXAMPLE_COUNT) {
            buf.append(": ");
            buf.append(fr.format(this.m_SumWeight));
        }
        return buf.toString();
    }

    public double[] getSumValues() {
        return this.m_SumValues;
    }

    @Override
    public int getNbStatisticComponents() {
        return this.m_SumValues.length;
    }

    @Override
    public void setParentStat(ClusStatistic parent) {
        this.m_ParentStat = (WHTDStatistic)parent;
    }

    @Override
    public ClusStatistic getParentStat() {
        return this.m_ParentStat;
    }
}

