/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import java.util.ArrayList;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.WHTDStatistic;

public class HierSingleLabelStat
extends WHTDStatistic {
    public static final long serialVersionUID = 1L;

    public HierSingleLabelStat(Settings sett, ClassHierarchy hier) {
        this(sett, hier, false);
    }

    public HierSingleLabelStat(Settings sett, ClassHierarchy hier, boolean onlymean) {
        super(sett, hier, onlymean);
    }

    @Override
    public ClusStatistic cloneStat() {
        return new HierSingleLabelStat(this.m_Settings, this.m_Hier, false);
    }

    @Override
    public void addPredictWriterSchema(String prefix, ClusSchema schema) {
        ClassHierarchy hier = this.getHier();
        ArrayList<String> leafClasses = new ArrayList<String>();
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            ClassTerm term = hier.getTermAt(i);
            if (term.getNbChildren() != 0) continue;
            leafClasses.add(term.toStringHuman(hier));
        }
        NominalAttrType type = new NominalAttrType(prefix + "-class", leafClasses);
        schema.addAttrType(type);
    }

    @Override
    public String getPredictWriterString() {
        double biggest = 0.0;
        int prediction = -1;
        ClassHierarchy hier = this.getHier();
        for (int i = 0; i < this.m_NbAttrs; ++i) {
            ClassTerm term = hier.getTermAt(i);
            if (term.getNbChildren() != 0) continue;
            if (prediction == -1) {
                prediction = i;
                biggest = this.m_Means[i];
                continue;
            }
            if (!(this.m_Means[i] > biggest)) continue;
            prediction = i;
            biggest = this.m_Means[i];
        }
        ClassTerm term = hier.getTermAt(prediction);
        return term.toStringHuman(hier);
    }
}

