/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.statistic;

import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.statistic.BitVectorStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;
import si.ijs.kt.clus.util.jeans.list.BitList;

public class GeneticDistanceStat
extends BitVectorStat {
    public static final long serialVersionUID = 1L;
    public int m_NbTarget;
    public NominalAttrType[] m_Attrs;

    public GeneticDistanceStat(Settings sett, NominalAttrType[] nomAtts) {
        super(sett);
        this.m_NbTarget = nomAtts.length;
        this.m_Attrs = nomAtts;
    }

    public BitList getBits() {
        return this.m_Bits;
    }

    @Override
    public void updateWeighted(DataTuple tuple, int idx) {
        this.m_SumWeight += tuple.getWeight();
        this.m_Bits.setBit(idx);
        this.m_Modified = true;
    }

    public int getTupleIndex(int index) {
        int i;
        int size = this.getBits().size();
        int nbones = 0;
        for (i = 0; nbones <= index && i < size; ++i) {
            if (!this.getBits().getBit(i)) continue;
            ++nbones;
        }
        if (nbones == index + 1) {
            return i - 1;
        }
        System.err.println("error in getTuple (GeneticDistanceStat), requesting tuple" + index);
        return -1;
    }

    @Override
    public void reset() {
        this.m_SumWeight = 0.0;
        this.m_Bits.reset();
        this.m_Modified = true;
    }

    @Override
    public GeneticDistanceStat cloneStat() {
        GeneticDistanceStat stat = new GeneticDistanceStat(this.m_Settings, this.m_Attrs);
        stat.cloneFrom(this);
        return stat;
    }

    public void cloneFrom(GeneticDistanceStat other) {
        int nb = other.m_Bits.size();
        this.m_NbTarget = other.m_NbTarget;
        this.m_Attrs = other.m_Attrs;
        if (nb > 0) {
            this.setSDataSize(nb);
        }
    }

    @Override
    public void copy(ClusStatistic other) {
        GeneticDistanceStat or = (GeneticDistanceStat)other;
        this.m_SumWeight = or.m_SumWeight;
        this.m_Bits.copy(or.m_Bits);
        this.m_Modified = or.m_Modified;
        this.m_NbTarget = or.m_NbTarget;
        this.m_Attrs = or.m_Attrs;
    }

    @Override
    public void addPrediction(ClusStatistic other, double weight) {
        GeneticDistanceStat or = (GeneticDistanceStat)other;
        this.m_SumWeight += weight * or.m_SumWeight;
    }

    @Override
    public void add(ClusStatistic other) {
        GeneticDistanceStat or = (GeneticDistanceStat)other;
        this.m_SumWeight += or.m_SumWeight;
        this.m_Bits.add(or.m_Bits);
        this.m_Modified = true;
    }

    @Override
    public void addScaled(double scale, ClusStatistic other) {
        GeneticDistanceStat or = (GeneticDistanceStat)other;
        this.m_SumWeight += scale * or.m_SumWeight;
    }

    public void subtractFromThis(BitList bits) {
        this.m_SumWeight -= (double)bits.getNbOnes();
        this.m_Bits.subtractFromThis(bits);
        this.m_Modified = true;
    }

    @Override
    public void subtractFromThis(ClusStatistic other) {
        GeneticDistanceStat or = (GeneticDistanceStat)other;
        this.m_SumWeight -= or.m_SumWeight;
        this.m_Bits.subtractFromThis(or.m_Bits);
        this.m_Modified = true;
    }

    public void copyAndSubtractFromThis(ClusStatistic stattocopy, ClusStatistic stattosubtract) {
        GeneticDistanceStat tocopy = (GeneticDistanceStat)stattocopy;
        GeneticDistanceStat tosubtract = (GeneticDistanceStat)stattosubtract;
        this.m_SumWeight = tocopy.m_SumWeight - tosubtract.m_SumWeight;
        this.m_Bits.copyAndSubtractFromThis(tocopy.m_Bits, tosubtract.m_Bits);
        this.m_NbTarget = tocopy.m_NbTarget;
        this.m_Attrs = tocopy.m_Attrs;
        this.m_Modified = true;
    }

    @Override
    public void subtractFromOther(ClusStatistic other) {
        GeneticDistanceStat or = (GeneticDistanceStat)other;
        this.m_SumWeight = or.m_SumWeight - this.m_SumWeight;
        this.m_Bits.subtractFromOther(or.m_Bits);
        this.m_Modified = true;
    }

    @Override
    public int[] getNominalPred() {
        ClusLogger.info("getNominalPred: not implemented for GeneticDistanceStat");
        return null;
    }

    @Override
    public String getString(StatisticPrintInfo info) {
        StringBuffer buf = new StringBuffer();
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        buf.append("LEAF : ");
        buf.append(fr.format(this.m_SumWeight));
        buf.append(" sequence(s)");
        return buf.toString();
    }

    @Override
    public void calcMean() {
    }

    @Override
    public double getCount(int idx, int cls) {
        return 0.0;
    }

    @Override
    public int getNbStatisticComponents() {
        throw new RuntimeException(this.getClass().getName() + "getNbStatisticComponents(): not implemented");
    }
}

